float4x4 matWVP;

float FogDist;
float3 FogColor;
float3 EyePosition;

sampler Sampler1		: register(s0);
sampler Sampler2		: register(s1);

float3 GetBaseSample (const float2 texcoord);
float3 GetLightmapSample (const float2 texcoord);
float GetLinearFogFactor (const float3 worldPosition);

/*
-----------------------------------------------------------
technique: techLightmapped
-----------------------------------------------------------
*/

struct LIGHTMAPPED_IN {
	float3 position: POSITION0;
	float3 normal: NORMAL0;
	float2 texcoord: TEXCOORD0;
	float2 lightmap_coord: TEXCOORD1;
};

struct LIGHTMAPPED_OUT {
	float4 Position: POSITION0;
	
	float2 texcoord: TEXCOORD0;
	float2 lightmap_coord: TEXCOORD1;
	
	float3 worldPosition: TEXCOORD2;
	float3 worldNormal: TEXCOORD3;
};

void vs_Lightmapped (in LIGHTMAPPED_IN IN, out LIGHTMAPPED_OUT OUT) 
{
	OUT.Position = mul(float4(IN.position.xyz, 1.0f), matWVP);

	OUT.worldPosition = IN.position;
	OUT.worldNormal = IN.normal;
	
	OUT.texcoord = IN.texcoord;
	OUT.lightmap_coord = IN.lightmap_coord;
}

void ps_Lightmapped (in LIGHTMAPPED_OUT vertex, out float4 color: COLOR0) 
{
	float3 light;
	float3 base;
	float3 fog;
	float fogfactor;
	
	fogfactor = GetLinearFogFactor(vertex.worldPosition);
	base.rgb = GetBaseSample(vertex.texcoord);
	light.rgb = GetLightmapSample(vertex.lightmap_coord);
	
	color.a = 0.0f;
	color.rgb = (1.0f - fogfactor) * (base * light) + fogfactor * FogColor;
	
	//color.rgb = pow(color.rgb, 1.15f);
	
	/*
	const float blah[5] = {0.2f, 0.4f, 0.6f, 0.8f, 1.0f};
	color.r = blah[ color.r * 5 ];
	color.g = blah[ color.g * 5 ];
	color.b = blah[ color.b * 5 ];
	*/
}

technique techLightmapped {
	pass p0 {
		VertexShader = compile vs_2_0 vs_Lightmapped();
		PixelShader = compile ps_2_0 ps_Lightmapped();
	}
}

/*
-----------------------------------------------------------
technique: techGeometryOnly

used for the initial zpass
-----------------------------------------------------------
*/

struct GEOMETRY_IN {
	float3 position: POSITION0;
};

struct GEOMETRY_OUT {
	float4 Position: POSITION0;
};

void vs_geometryOnly (in GEOMETRY_IN IN, out GEOMETRY_OUT OUT) 
{
	OUT.Position = mul(float4(IN.position.xyz, 1.0f), matWVP);
}

void ps_geometryOnly (in GEOMETRY_OUT v, out float4 color: COLOR0)
{	
	color = float4(0,0,0,0);
}

technique techGeometryOnly {
	pass p0 {
		VertexShader = compile vs_2_0 vs_geometryOnly();
		PixelShader = compile ps_2_0 ps_geometryOnly();
	}
}

/*
-----------------------------------------------------------
helper functions
-----------------------------------------------------------
*/

float3 GetBaseSample (const float2 texcoord)
{
	float3 sample;
	sample = tex2D(Sampler1, texcoord).rgb;
	return sample;
}

float3 GetLightmapSample (const float2 texcoord)
{
	float3 sample;
	sample = tex2D(Sampler2, texcoord).rgb;
	return sample;
}

float GetLinearFogFactor (const float3 worldPosition)
{
	float factor;
	float3 fog;
	float3 EyePosition_worldPosition;
	float d;
	
	EyePosition_worldPosition = EyePosition - worldPosition;
	d = length(EyePosition_worldPosition);
	factor = saturate(d / FogDist);
	
	return factor;
}






