struct MODEL_VERTEX {
	float3 position: POSITION0;
	float3 normal: NORMAL0;
	float2 texcoord: TEXCOORD0;
	float3 position2: POSITION1;
	float3 normal2: NORMAL1;
};

struct MODEL_TVERTEX {
	float4 Position: POSITION0;
	float2 texcoord: TEXCOORD0;
	float3 light: TEXCOORD1;
	float3 worldNormal: TEXCOORD2;
};

float4x4 matWorldRotationPart;
float4x4 matWVP;

float tween;
float4 AmbientCube[6]; //in order of negative to positive along axes x, y, then z
sampler BaseSampler			: register(s0);
float3 tint; //modulated color, for things like highlighted entities for player to interact w/

float3 AmbientLight (const float3 worldNormal);

void TransformVertex (in MODEL_VERTEX IN, out MODEL_TVERTEX OUT)
{
	float3 tnormal;
	float3 tposition;
	
	tposition = lerp(IN.position, IN.position2, tween);
	tnormal = lerp(IN.normal, IN.normal2, tween);

	OUT.worldNormal = mul(float4(tnormal, 1.0f), matWorldRotationPart);
	OUT.worldNormal = tnormal;
	OUT.worldNormal = normalize(OUT.worldNormal);

	OUT.Position = mul(float4(tposition, 1.0f), matWVP);
	OUT.texcoord = IN.texcoord;
	OUT.light = AmbientLight(OUT.worldNormal);
}

float4 ColorVertex (in MODEL_TVERTEX IN): COLOR0
{
	float4	color;
	float3	skin;
	
	color.a = 1;
	
	IN.worldNormal = normalize(IN.worldNormal);
	skin = tex2D(BaseSampler, IN.texcoord).rgb;
	color.rgb = skin * IN.light * tint;
	//color.rgb = IN.worldNormal.xyz;
	
	return color;
}

float3 AmbientLight (const float3 worldNormal)
{
	float3 nSquared;
	float3 color;
	int3 isPositive;
	
	isPositive = (worldNormal > 0);
	nSquared = worldNormal * worldNormal;
	color = 
		nSquared.x * AmbientCube[ isPositive.x ] + 
		nSquared.y * AmbientCube[ isPositive.y+2 ] +
		nSquared.z * AmbientCube[ isPositive.z+4 ];
		
	return color;
}

technique techDefault {
	pass p0 {
		VertexShader = compile vs_1_1 TransformVertex();
		PixelShader = compile ps_1_1 ColorVertex();
	}
}