unit PathDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Mask, ComCtrls, FileCtrl;

type
  TFormPathDlg = class(TForm)
    BtnOK: TButton;
    DriveComboBox: TDriveComboBox;
    DirectoryListBox: TDirectoryListBox;
    EditDir: TEdit;
    EditCurrDir: TEdit;
    BtnCreate: TButton;
    procedure BtnOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DirectoryListBoxChange(Sender: TObject);
    procedure BtnCreateClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormPathDlg: TFormPathDlg;

implementation

{$R *.dfm}

{==============================================================================}
procedure TFormPathDlg.BtnOKClick(Sender: TObject);
begin
   if FormPathDlg.Caption = 'Select Quake 2 Install Directory' then
   begin
      if FileExists(DirectoryListBox.Directory+'\quake2.exe')
      then
         ModalResult := mrOK
      else
         MessageDlg('Can not locate quake2.exe in your selected directory, '+#13+#10+'please try again!', mtWarning, [mbOK], 0);
   end
   else
      ModalResult := mrOK;
end;

{==============================================================================}
procedure TFormPathDlg.FormCreate(Sender: TObject);
begin
  EditCurrDir.Text := DirectoryListBox.Directory;
end;

{==============================================================================}
procedure TFormPathDlg.DirectoryListBoxChange(Sender: TObject);
begin
  EditCurrDir.Text := DirectoryListBox.Directory;
end;

{==============================================================================}
procedure TFormPathDlg.BtnCreateClick(Sender: TObject);
var
  str : string;
  i : integer;
  ValidPath : boolean;
begin

  i := 1;
  ValidPath := true;
  str := '\/:*?"<>|';   // illeagal characters

  if EditDir.Text <> '' then
  begin

    // Validate the directory name
    while i <= Length(str) do
    begin
      if pos(str[i],EditDir.Text)<> 0 then begin
        ValidPath := false;
        MessageDlg('Can''t contain \ / : * ? " < > |', mtError, [mbOK], 0);
        break;
      end;
      inc(i);
    end;

    // Create directory if not exists
    if ValidPath then
    begin
      if not DirectoryExists(DirectoryListBox.Directory+'\'+EditDir.Text) then
      begin
        if not CreateDir(DirectoryListBox.Directory+'\'+EditDir.Text) then
          raise Exception.Create('Cannot create directory');
        DirectoryListBox.Update;
      end;
    end;

  end;
  EditDir.Text := '';
end;

end.
