/*
  tr.cpp
		
  Q3Plug 1.2b1
		
  Tribes server query

  Author:   Markus Baumgartner
  Compiler: Microsoft Visual C++ 6.0
  Last Mod: 03/11/2001
  Tab size: 2
*/


#include <assert.h>
#include <string.h>
#include <windows.h>
#include <stdio.h>

#include "npapi.h"
#include "commctrl.h"

#ifndef _TR_H_
#include "tr.h"
#endif

#ifndef _Q3PLUG_H_
#include "q3plug.h"
#endif

// game-specific information
void TR_getInfo(char* text[]) {
  text[0] = "Starsiege Tribes";
  text[1] = "Starsiege Tribes server query code written by Markus Baumgartner\nmarkus.baumgartner@liwest.at";
  text[2] = "tribes.exe";
  text[3] = "+connect %s:%s";                     // connect string used in command line (hostname:port)
}

// column names
void TR_getColumns(char* cols[]) {
  cols[0] = "Ping";
  cols[1] = "Score";
  cols[2] = "Player";
}

// custom compare function to compare columns correctly
// as we do not have information about team score availabe during sorting,
// this info is encoded in the player name to allow for correct sorting
int TR_compareFunc(char *val1, char *val2, int sortCol, int sortDir) {
  switch (sortCol) {
	  case 0: return sortDir*(atoi(val1) - atoi(val2));
		case 1: return sortDir*(atoi(val1) - atoi(val2));
		case 2: return sortDir*stricmp(val1,val2);
    default: return 0;
  }
}

// extract sematics from some rules
void TR_checkRule(PluginInstance *This, structRule r) {
  
}

// extracts a Pascal-style string from a Tribes packet
int ExtractString( char *tmp,  char *buf) {

  int len= (unsigned char) *buf;
  int savelen=len;
  buf++;
  while (len-->0) 
    *tmp++ = *buf++;
  *tmp=0;
  return savelen+1;
}

//  
// check if buffer valid
BOOL TR_initBuffer(PluginInstance *This) {

  assert(This);
	assert(This->buffer);

  
  structRule rule;
  structPlayer player;
  char string[256], tmp[256], tmp2[256];
  char *cur=This->buffer;
  char *x;
  int t,teams;
  int players;
  
	// check if packet is valid
  if (0!=memcmp(This->buffer, "\x63\x0\x0\x62", 4))
    return FALSE; 

  cur+=4;
  // parse
  rule.name = "Game";
  cur+=ExtractString(string,cur);
  rule.value=string;
  UI_insertRule(This, rule);

  rule.name = "Game Version";
  cur+=ExtractString(string,cur);
  rule.value=string;
  UI_insertRule(This, rule);

  cur+=ExtractString(string,cur);
  strncpy(This->hostname, string, 127);

  cur+=2;

  players = *cur++;
  sprintf(This->numplayers, "%d", (char) players);
  sprintf(This->maxclients, "%d", (char) *cur++);

  sprintf(string, "%hu", (unsigned short *) cur);
  rule.name = "Server CPU speed";
  rule.value = string;
  UI_insertRule(This, rule);

  cur+=2;

  rule.name = "Game Type";
  cur+=ExtractString(string,cur);
  rule.value=string;
  UI_insertRule(This, rule);

  rule.name = "Game Mode";
  cur+=ExtractString(string,cur);
  rule.value=string;
  UI_insertRule(This, rule);

  rule.name = "Map";
  cur+=ExtractString(string,cur);
  rule.value=string;
  UI_insertRule(This, rule);

  rule.name = "Server Info 1";
  cur+=ExtractString(string,cur);
  rule.value=string;
  x = string;
  while (*x != 10 && *x!=0)x++;
  *x = 0;
  UI_insertRule(This, rule);
  rule.name = "Server Info 2";
  rule.value = x+1;
  while (*x != 10 && *x!=0)x++;
  *x = 0;
  UI_insertRule(This, rule);
  rule.name = "Server Info 3";
  rule.value = x+1;
  while (*x != 10 && *x!=0)x++;
  *x = 0;
  UI_insertRule(This, rule);
  

  teams = *cur ++; // skip no. of teams

  rule.name = "team score label string";
  cur+=ExtractString(string,cur);
  rule.value=string;
  //UI_insertRule(This, rule);

  rule.name = "player label string";
  cur+=ExtractString(string,cur);
  rule.value=string;
  //UI_insertRule(This, rule);

  rule.name = "No. teams";
  sprintf(string, "%d", teams);
  rule.value = string;
  UI_insertRule(This, rule);

  for (t=0; t<teams; t++) {
    cur+=ExtractString(string,cur);
    //sprintf(tmp, "\1 Team \1 %s", string);
    //player.name = tmp;
    //player.ping = "";
    cur+=ExtractString(string, cur);
    //sprintf(tmp2, "%d", teamscores[t]);
    //player.frags = tmp2;
    //UI_insertPlayer(This, player);
  }

  for (int p=0; p<players; p++) {
    unsigned int d = (unsigned char) *cur;
    sprintf(tmp, "%u", d*4);
    player.ping = tmp;
    cur += 2;
    cur++;
    cur += ExtractString(tmp2, cur);  // name
    cur += ExtractString(string, cur);
    player.frags = string+6;
    x = player.frags++;
    while ((*x >='0' && *x<='9') || *x==0x20 || *x=='-') x++;
    *x = 0;
    player.name = tmp2;
    UI_insertPlayer(This,player);
  }

  return TRUE;
}


// this function is called when the plugin window is notified of the arrival
// of a packet on its socket
BOOL TR_receivePacket(PluginInstance *p) {
 
  LARGE_INTEGER counter, freq;
  
  int count=0;
  
  assert(p);
  assert(p->text);
 
 	// get packet time
	if (QueryPerformanceFrequency(&freq) && QueryPerformanceCounter(&counter))
		p->ticks = 1000*(counter.QuadPart - p->ticks) / freq.QuadPart;
	else
    p->ticks = GetTickCount() - p->ticks; 
  
  p->buffer = (char*) malloc(BUFSIZE);
	assert(p->buffer);

	// clear buffer (don't remove this!)
  unsigned int i=0; unsigned int c=0;
  while ( c < BUFSIZE ) {
		p->buffer[c] = i++ % 255;
		c++;
	}

	/* receive packet */
  if (recv(p->sock, p->buffer, BUFSIZE, 0) == SOCKET_ERROR) {
    wsprintf(p->text, "Receive error (%d)", WSAGetLastError());
    free(p->buffer);
		return FALSE;
  }

  
  //MessageBox(NULL,p->buffer,"",MB_OK);
	
  if (!TR_initBuffer(p)) {
		strcpy(p->text, "Invalid packet. Updating Q3Plug might solve the problem.");
		free(p->buffer);
		return FALSE;
	 }

  strcpy(p->text, "");
  itoa((int) p->ticks, p->ping, 10);
  
	// now we can free the buffer and close socket
  free(p->buffer);
  closesocket(p->sock);

	p->playerPos = NULL;
	p->rulePos = NULL;

  return TRUE;
}

// Sends a status-request packet to destination server */
BOOL TR_sendPacket(PluginInstance *p) {
  struct sockaddr_in sa;
  LARGE_INTEGER t;
  HOSTENT *host;
  int err;

  assert(p);

  /* create new socket */
  p->sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
  if (p->sock == INVALID_SOCKET) {
    wsprintf(p->text, "Socket error (%d)", WSAGetLastError());
    return FALSE;
  }
    
  /* set parameters */
  sa.sin_family = AF_INET;
  sa.sin_port = htons(atoi(p->port));
  sa.sin_addr.S_un.S_addr = inet_addr(p->server);

  if (sa.sin_addr.S_un.S_addr == -1) {
    host = gethostbyname(p->server);
    if (!host) {
      strcpy(p->text, "Invalid server name");
      return FALSE;
    }
    memcpy(&(sa.sin_addr.s_addr), host->h_addr, sizeof(int));
  }
    
  /* send it (finally) */
  err= sendto(p->sock, TR_getStatus, 3, 0, (sockaddr*) &sa, sizeof(sa));
  if (err == SOCKET_ERROR ){
    wsprintf(p->text, "Send error (%d)", WSAGetLastError());
    return FALSE;
  }

  if (QueryPerformanceCounter(&t))
		p->ticks = t.QuadPart;
	else
		p->ticks = GetTickCount();
 
  /* set socket to non-blocking mode */
  err=WSAAsyncSelect(p->sock, p->fhWnd, WM_SERVER_RESPONSE, FD_READ);
  if (err == SOCKET_ERROR) {
    wsprintf(p->text, "Select error (%d)", WSAGetLastError());
    return FALSE;
  }
  
  return TRUE;
}


// custom draw procedure for Q3 colored names and display of encoded names
// in case of OSP
BOOL TR_drawName(PluginInstance *This, HDC hdc, RECT win, char *name) {
	return FALSE;
}