;  Kingpin CD-ROM Installer V0.1
;  Created 2024 FREDZ
;  <https://kingpin.info/>
;  Contains source code from LEGO Racers Setup
;  Copyright (c) 2007-2008 Bgbennyboy
;  Created 2013 Triangle717
;  <http://https://github.com/le717/Racers-Alternate-Installer/>

; If any version below the specified version is used for compiling, 
; this error will be shown.
#if VER < EncodeVer(5,5,2)
  #error You must use Inno Setup 5.5.2 or newer to compile this script
#endif

#define MyAppInstallerName "Kingpin CD-ROM Installer "
#define MyAppInstallerVersion "0.1"
#define MyAppName "Kingpin: Life of Crime"
#define MyAppNameNoR "Kingpin"
#define MyAppVersion "1.0"
#define MyAppPublisher "Xatrix"
#define MyAppExeName "Kingpin.exe"

[Setup]
AppID={#MyAppInstallerName}{#MyAppInstallerVersion}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
VersionInfoVersion={#MyAppInstallerVersion}
AppPublisher={#MyAppPublisher}
AppCopyright= 1999 {#MyAppPublisher}
LicenseFile=ReadMe.txt
; Start menu/screen and Desktop shortcuts
DefaultDirName=c:\Games\{#MyAppNameNoR}
DefaultGroupName=Games\{#MyAppNameNoR}
AllowNoIcons=yes
; Installer Graphics
SetupIconFile=Kingpin.ico
WizardImageFile=kp1.bmp
WizardSmallImageFile=small-image.bmp
WizardImageStretch=True
WizardImageBackColor=clBlack
; Location of the compiled Exe
OutputDir=bin
OutputBaseFilename={#MyAppNameNoR} CD-ROM Installer {#MyAppInstallerVersion}
; Uninstallation stuff
UninstallFilesDir={app}
UninstallDisplayIcon={app}\Kingpin.ico
CreateUninstallRegKey=yes
UninstallDisplayName={#MyAppName}
UsePreviousAppDir=no
; This is required so Inno can correctly report the installation size.
UninstallDisplaySize=587120640
; Compression
Compression=lzma2/ultra64
SolidCompression=True
InternalCompressLevel=ultra
LZMAUseSeparateProcess=yes
; From top to bottom:
; Explicitly set Admin rights, no other languages, do not restart upon finish.
PrivilegesRequired=admin
ShowLanguageDialog=no
RestartIfNeededByRun=no

[Languages]
Name: "English"; MessagesFile: "compiler:Default.isl"

[Messages]
BeveledLabel={#MyAppInstallerName} {#MyAppInstallerVersion}
; WelcomeLabel2 is overridden because I'm unsure if every Kingpin disc says 
; version 1.0.0.0 or just mine.
WelcomeLabel2=This will install [name] on your computer.%n%nIt is recommended that you close all other applications before continuing.
; DiskSpaceMBLabel is overridden because it reports an incorrect installation size. 
;FREDZ Kingpin normalys says 570 MB but it more closer to 590
DiskSpaceMBLabel=At least 590 MB of free disk space is required.

; Both Types and Components sections are required to create the installation options.
;[Types]
;Name: "MATURE"; Description: "Mature"  
;Name: "LOW"; Description: "Low Violence"

;[Components]
;Name: "SETUPTYPE_MATURE"; Description: "This version will include include ALL game features, including explicit language, blood and gore."; Types: MATURE
;Name: "SETUPTYPE_LOW"; Description: "This version does NOT contain any explicit language and gore."; Types: LOW

[Files]
; Pull the game files off a standard Kingpin disc.
Source: "{code:GetSourceDrive}kingpin\DATA1.CAB"; DestDir: "{app}"; Flags: external ignoreversion deleteafterinstall skipifsourcedoesntexist
Source: "{code:GetSourceDrive}kingpin\DATA1.HDR"; DestDir: "{app}"; Flags: external ignoreversion deleteafterinstall skipifsourcedoesntexist
Source: "{code:GetSourceDrive}Readme.txt"; DestDir: "{app}"; Flags: external ignoreversion skipifsourcedoesntexist
Source: "kingpin.info.url"; DestDir: "{app}"

; Manual and icon
Source: "Manual.pdf"; DestDir: "{app}"; Flags: ignoreversion skipifsourcedoesntexist
Source: "Kingpin.ico"; DestDir: "{app}"; Flags: ignoreversion

; Tool needed to extract the CAB
Source: "Tools\CABExtract\i5comp.exe"; DestDir: "{app}"; Flags: deleteafterinstall
Source: "Tools\CABExtract\ZD51145.DLL"; DestDir: "{app}"; Flags: deleteafterinstall

[Icons]
; First and last icons are created only if user choose not to use the videos, 
; else the normal ones are created.
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; IconFilename: "{app}\Kingpin.exe";Comment: "Run Kingpin: Life of Crime";
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}"; Filename: "{uninstallexe}"; IconFilename: "{app}\Kingpin.exe";
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; IconFilename: "{app}\Kingpin.exe"; Comment: "Run Kingpin: Life of Crime"; Tasks: desktopicon
Name: "{group}\Kingpin.info"; Filename: "{app}\kingpin.info.url"

[Tasks]
; Create a desktop icon, run with administrator rights
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "Admin"; Description: "Run {#MyAppName} with Administrator Rights"; GroupDescription: "{cm:AdditionalIcons}"

[Registry]
; Registry strings are always hard-coded (!No ISPP functions!) to ensure everything works properly.
Root: "HKCU"; Subkey: "Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Layers"; ValueType: string; ValueName: "{app}\kingpin.exe"; ValueData: "RUNASADMIN"; Flags: uninsdeletevalue; Tasks: Admin
;Root: "HKCU"; Subkey: "Software\Xatrix\Kingpin\1.00.000"; ValueType: string; ValueName: "{app}\Kingpin.exe"; ValueData: "RUNASADMIN"; Flags: uninsdeletevalue; Tasks: Admin

[Run]
; From to to bottom: Extract the CAB, run game 
; (depending on user's choice on the videos).
Filename: "{app}\i5comp.exe"; Parameters: "x ""{app}\DATA1.CAB"""; Flags: runascurrentuser
Filename: "{app}\{#MyAppExeName}"; Flags: nowait postinstall skipifsilent runascurrentuser; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}";

[UninstallDelete]
; Because the files came from a CAB rather than [Files],
; this is needed to delete them.
Type: files; Name: "{app}\{#MyAppExeName}"
Type: files; Name: "{app}\*.tun"
; Deletes kpintro.exeif it exists; Does not throw error if it does not exist
;Type: files; Name: "{app}\kpintro.exe"

[Dirs]
; Created to ensure the save games are not removed (which should never ever happen).
Name: "{app}\main\save"; Flags: uninsneveruninstall

[Code]
// Pascal script from Bgbennyboy to pull files off a CD, greatly trimmed up 
// and modified to support ANSI and Unicode Inno Setup by Triangle717.
var
	SourceDrive: string;

#include "FindDisc.iss"

function GetSourceDrive(Param: String): String;
begin
	Result:=SourceDrive;
end;

procedure InitializeWizard();
begin
	SourceDrive:=GetSourceCdDrive();
end;
