// prefs.h

#define MAX_BUDDIES 20
#define MAX_VISIBLE_BUDDIES 4		// What actually fits on screen

typedef struct Buddy {
	char name[64];					// Name, as set by the user.
	char sound[260];				// Pathname to .WAV file
	char program[260];				// Pathname to .EXE, along with command line params
	int playing;					// Is this buddy currently active?
	time_t quitPlayingAt;			// If not, this is when they stopped.
} Buddy;

typedef struct Preferences {
	char serverAddrStr[64];			// String in the form of "dns.name.com:port", or "123.45.67.89:27910"
	char rconPassword[64];			// If set by the user, we can try remote administration commands
	int refreshIntervalSecs;		// Re-update every X seconds.
	Buddy buddies[MAX_BUDDIES];		// All our Q2-empowered friends.
	char gamePath[260];				// Path to Quake2.exe
} Preferences;

#define DEFAULT_REFRESH 30
#define MINIMUM_REFRESH 5			// Don't spam server.

void ShowPreferencesDlg(void);
void InitPreferences(void);
void LoadPreferences(void);
void SavePreferences(void);
void RestoreWindowPosition(int *x, int *y, int *dx, int *dy);
void SaveWindowPosition(HWND hwnd);
void SaveWindowRect(HWND hwnd);
BOOL InputDlg(const char *const prompt, char *answer, int asize);
void FindQuakePath(void);