#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>

int main(int argc, char *argv[]) {
    char directory[1024];
    
    // Use directory passed as an argument, or default to current directory
    if (argc > 1) {
        strncpy(directory, argv[1], sizeof(directory) - 1);
        directory[sizeof(directory) - 1] = '\0';
    } else {
        strcpy(directory, ".");
    }
    
    // Build search pattern. If the directory path does not end with '\' or '/',
    // append a backslash and then "*.bsp".
    int len = strlen(directory);
    char searchPath[1100];
    strcpy(searchPath, directory);
    if (len > 0 && directory[len - 1] != '\\' && directory[len - 1] != '/') {
        strcat(searchPath, "\\");
    }
    strcat(searchPath, "*.bsp");

    struct _finddata_t fileinfo;
    intptr_t handle = _findfirst(searchPath, &fileinfo);
    if (handle == -1L) {
        printf("No .bsp files found in directory: %s\n", directory);
        return 0;
    }

    // Open the file for all maps.
    FILE *fp_all = fopen("maps_all.txt", "w");
    if (!fp_all) {
        perror("Error opening maps_all.txt");
        return 1;
    }
    
    // File pointers for the various categories (opened only when a matching file is found)
    FILE *fp_bm     = NULL; // for maps beginning with "team_"
    FILE *fp_crash  = NULL; // for maps beginning with "bom_" or "vip_"
    FILE *fp_hw     = NULL; // for maps beginning with "hw"
    FILE *fp_xmas   = NULL; // for maps beginning with "xmas"
    FILE *fp_kpq2   = NULL; // for maps beginning with "kpq2"
    FILE *fp_kpq3   = NULL; // for maps beginning with "kpq3"
    FILE *fp_others = NULL; // for maps that don't fit the above

    // Process each file found
    do {
        // Skip directories
        if (!(fileinfo.attrib & _A_SUBDIR)) {
            // Although our search pattern is "*.bsp", verify that the extension is .bsp
            char *ext = strrchr(fileinfo.name, '.');
            if (ext && _stricmp(ext, ".bsp") == 0) {
                // Remove the extension by replacing the '.' with a null terminator
                *ext = '\0';
                char *mapName = fileinfo.name;
                
                // Write to the complete maps list
                fprintf(fp_all, "%s\n", mapName);
                
                // Check for each category (using case‑insensitive comparisons)
                if (_strnicmp(mapName, "team_", 5) == 0) {
                    if (!fp_bm) {
                        fp_bm = fopen("maps_bm.txt", "w");
                        if (!fp_bm)
                            perror("Error opening maps_bm.txt");
                    }
                    if (fp_bm)
                        fprintf(fp_bm, "%s\n", mapName);
                }
                else if (_strnicmp(mapName, "bom_", 4) == 0 || _strnicmp(mapName, "vip_", 4) == 0) {
                    if (!fp_crash) {
                        fp_crash = fopen("maps_crash.txt", "w");
                        if (!fp_crash)
                            perror("Error opening maps_crash.txt");
                    }
                    if (fp_crash)
                        fprintf(fp_crash, "%s\n", mapName);
                }
                else if (_strnicmp(mapName, "hw", 2) == 0) {
                    if (!fp_hw) {
                        fp_hw = fopen("maps_hw.txt", "w");
                        if (!fp_hw)
                            perror("Error opening maps_hw.txt");
                    }
                    if (fp_hw)
                        fprintf(fp_hw, "%s\n", mapName);
                }
                else if (_strnicmp(mapName, "xmas", 4) == 0) {
                    if (!fp_xmas) {
                        fp_xmas = fopen("maps_xmas.txt", "w");
                        if (!fp_xmas)
                            perror("Error opening maps_xmas.txt");
                    }
                    if (fp_xmas)
                        fprintf(fp_xmas, "%s\n", mapName);
                }
                else if (_strnicmp(mapName, "kpq2", 4) == 0) {
                    if (!fp_kpq2) {
                        fp_kpq2 = fopen("maps_kpq2.txt", "w");
                        if (!fp_kpq2)
                            perror("Error opening maps_kpq2.txt");
                    }
                    if (fp_kpq2)
                        fprintf(fp_kpq2, "%s\n", mapName);
                }
                else if (_strnicmp(mapName, "kpq3", 4) == 0) {
                    if (!fp_kpq3) {
                        fp_kpq3 = fopen("maps_kpq3.txt", "w");
                        if (!fp_kpq3)
                            perror("Error opening maps_kpq3.txt");
                    }
                    if (fp_kpq3)
                        fprintf(fp_kpq3, "%s\n", mapName);
                }
                else {
                    // If it does not match any of the above, place it in maps.txt
                    if (!fp_others) {
                        fp_others = fopen("maps.txt", "w");
                        if (!fp_others)
                            perror("Error opening maps.txt");
                    }
                    if (fp_others)
                        fprintf(fp_others, "%s\n", mapName);
                }
            }
        }
    } while (_findnext(handle, &fileinfo) == 0);
    
    _findclose(handle);
    fclose(fp_all);
    if (fp_bm)     fclose(fp_bm);
    if (fp_crash)  fclose(fp_crash);
    if (fp_hw)     fclose(fp_hw);
    if (fp_xmas)   fclose(fp_xmas);
    if (fp_kpq2)   fclose(fp_kpq2);
    if (fp_kpq3)   fclose(fp_kpq3);
    if (fp_others) fclose(fp_others);

    return 0;
}
