/* MOUSE.C - Mouse test program */

/************************************************************************/
/*	Copyright (C) 1986-1990 Phar Lap Software, Inc.			*/
/*	Unpublished - rights reserved under the Copyright Laws of the	*/
/*	United States.  Use, duplication, or disclosure by the 		*/
/*	Government is subject to restrictions as set forth in 		*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 	*/
/*	Computer Software clause at 252.227-7013.			*/
/*	Phar Lap Software, Inc., 60 Aberdeen Ave., Cambridge, MA 02138	*/
/************************************************************************/

#include <stdio.h>

#define FOREVER while(1)



/*

Main routine

*/

main()

{

	short rc, butc, x, y, but, state;

	/* Reset the mouse driver and exit it there is no mouse. */

	_asm
	{
		mov	ax,0
		int	33h
		mov	rc,ax
		mov	butc,bx
	}
	if(rc == 0)
	{
		printf("Mouse support is not available.\n");
		return 1; 
	}
	printf("Mouse support is available.\n");
	printf("Number of mouse buttons = <<%d>>.\n", butc);
	printf("\n");

	/* Turn on the mouse pointer on the screen */

	_asm
	{
		mov	ax,1h
		int	33h
	}

	/* Display the mouse position until one of the mouse buttons
	   has been pressed */

	state = 0;
	FOREVER
	{
		_asm mov ax,3
		_asm int 33h
		_asm mov but,bx
		_asm mov x,cx
		_asm mov y,dx
		printf("Mouse=<<%03d,%03d>> Button=<<%02X>>\r", x, y, but);
		if(state == 0)
		{
			state = but & 0x7;
		}
		else
		{
			if(!(but & 0x7))
				break;
		}
	}

	/* Reset the mouse driver */

	_asm
	{
		mov	ax,2
		int	33h
	}
	_asm
	{
		mov	ax,0
		int	33h
	}

	/* Print out the final button state */

	printf("\n");
	if(state & 0x1)
		printf("Left button is pressed.\n");
	if(state & 0x2)
	{
		if(butc == 3)
			printf("Center button is pressed.\n");
		else	
			printf("Right button is pressed.\n");
	}
	if(state & 0x4)
		printf("Right button is pressed.\n");

	/* All done. */

	printf("All done.\n");
	return 0;

}

