#include "g_local.h"
qboolean Pickup_Speedway_Fire (edict_t *ent, edict_t *other) // speedway v1.8
{
	return false;
}






void fire_touch( edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	static float	last_touch_time;
	static edict_t	*last_touch_ent;
	static int		last_touch_count = 0;

	if (!other->client)		return;

	if ((level.time < last_touch_time) || (last_touch_time && (last_touch_time < (level.time - 2.0))) || (last_touch_ent && (last_touch_ent != other)))
	{	// reset
		last_touch_time = 0;
		last_touch_ent = NULL;
		last_touch_count = 0;
	}
	else if (last_touch_time > (level.time - 0.1))		return;

	else
	{
		last_touch_count++;
		last_touch_time = level.time;

		if (last_touch_count > 1)
		{
			last_touch_count = 0;
			other->onfiretime = 20;
			other->onfireent = other;
		}
	}

	last_touch_ent = other;
}

void fire_think(edict_t *self)
{
	if(self->spawnflags & 1 && self->style & 1)
	{
		self->s.angles[YAW] = (rand()%360);
		self->s.angles[ROLL] = 90;
		if(rand()%2) self->s.angles[ROLL] *= -1;
		self->style &= ~1; // so this only does this once. removes the 1 bit turning a 3 into a 2
	}

	if(self->timestamp == level.time - 0.7)// stop bouncing
	{
		self->solid = SOLID_TRIGGER;
		self->movetype = MOVETYPE_NONE;
		if( self->style & 2 ) self->s.origin[2] -= 10;
		else self->s.origin[2] -= 15;
		self->style = 0;
	}
	// sink into ground
	if ( self->timestamp < (level.time - 15) && !(self->spawnflags & 2)) 
	{
		self->s.origin[2] -= 0.5;
		self->count--;

		// done with this body
		if (self->count <= -30) self->think = G_FreeEdict;
	}
	self->nextthink = level.time + 0.1;
}



edict_t *Drop_Fire (edict_t *ent, gitem_t *item) // speedway v1.8
{
	edict_t	*dropped;
	vec3_t	forward, right;
	vec3_t	offset;

	dropped = G_Spawn();

		dropped->classname = gi.TagMalloc(sizeof("speedway_fire")+1, TAG_LEVEL);
		strcpy( dropped->classname, "speedway_fire" );

	dropped->item = item;
	dropped->spawnflags = DROPPED_ITEM; // 16 ... safe 
	dropped->s.effects = item->world_model_flags;
	dropped->s.effects |= EF_FLAMETHROWER;
	dropped->s.renderfx = RF_GLOW;
	dropped->s.renderfx2 = RF2_NOSHADOW; 	

	VectorSet (dropped->mins, -15, -15, -15);
	VectorSet (dropped->maxs, 15, 15, 15);
	gi.setmodel (dropped, dropped->item->world_model);
	dropped->solid = SOLID_TRIGGER;
	dropped->movetype = MOVETYPE_TOSS;
	dropped->svflags |= SVF_PROP;
	dropped->spawnflags |= 1; // so it lands on its side.
	dropped->touch = fire_touch;
	dropped->owner = ent;

	if (ent->client)
	{
		trace_t	trace;

		AngleVectors (ent->client->v_angle, forward, right, NULL);
		VectorSet(offset, 24, 0, -16);
		G_ProjectSource (ent->s.origin, offset, forward, right, dropped->s.origin);
		trace = gi.trace (ent->s.origin, dropped->mins, dropped->maxs,
			dropped->s.origin, ent, CONTENTS_SOLID);
		VectorCopy (trace.endpos, dropped->s.origin);
	}
	else
	{
		AngleVectors (ent->s.angles, forward, right, NULL);
		VectorCopy (ent->s.origin, dropped->s.origin);
	}

	VectorScale (forward, 100, dropped->velocity);
	dropped->velocity[2] = 300;

	
	dropped->surfacetype = SURF_METAL;

	dropped->think = fire_think;
	dropped->nextthink = level.time + 0.1;
	dropped->count = 0; // so it sinks into ground
	dropped->style = 3;// so it lands on its side
	dropped->timestamp = level.time;

	gi.linkentity (dropped);



	return dropped;
}

/*QUAKED speedway_fire (0.5 0 1) (-12 -12 -16) (12 12 12) SHOW_BIKE PERMANENT
Fire that spawns when a bike dies.
Will sink into ground if you forget the PERMANENT spawnflag

THIS CODE BELOW HERE ONLY PERTAINS TO THIS ENTITY IF IT IS INCLUDED IN
THE MAP ITSELF LIKE A PROP
*/
void SP_speedway_fire( edict_t *self )
{
	if(self->model)
	{
		self->s.modelindex = gi.modelindex(self->model);
		VectorSet( self->mins, -12, -12, -16 );
		VectorSet( self->maxs,  12,  12,  12 );
	}
	else if(self->spawnflags & 1)
	{
		int i;


		self->s.skinnum = self->skin;
 		memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
		self->s.num_parts++;
		self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/props/moto/moto.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_HEAD].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds("models/props/moto/moto.mdx", &self->s.model_parts[PART_HEAD]);	

		self->s.num_parts++;
		self->s.model_parts[PART_BODY].modelindex = gi.modelindex("models/props/moto/chrome.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_BODY].skinnum[i] = self->s.skinnum;
		gi.GetObjectBounds( "models/props/moto/chrome.mdx", &self->s.model_parts[PART_BODY] );

		self->s.renderfx2 |= RF2_DIR_LIGHTS;
//		self->s.renderfx  |= RF_REFL_MAP;

		self->surfacetype = SURF_METAL;

		VectorSet( self->mins, -16, -16, -24 );
		VectorSet( self->maxs,  16,  16,  48 );

	}
	else 
	{
		self->s.modelindex = gi.modelindex("models/props/cigar/cigar.mdx");
		VectorSet( self->mins, -12, -12, -16 );
		VectorSet( self->maxs,  12,  12,  12 );
		self->s.renderfx |= RF_TRANSLUCENT;
	}

	self->svflags |= SVF_PROP;


//	self->movetype = MOVETYPE_WALLBOUNCE;
//	self->movetype = MOVETYPE_BOUNCE;
	self->movetype = MOVETYPE_TOSS;
	self->solid = SOLID_TRIGGER;



	self->s.effects |= EF_FLAMETHROWER;
//	self->s.renderfx |= RF_TRANSLUCENT;
	self->s.renderfx2 |= RF2_NOSHADOW;

	gi.linkentity( self );

	self->touch = fire_touch;

	self->think = fire_think;
	self->nextthink = level.time + 0.1;
	self->count = 1;
	self->timestamp = level.time;
}
