#include "g_local.h"

int	 vote_set[9];        // stores votes for next map

char admincode[16];		 // the admincode
char default_map[32];    // default settings
char default_teamplay[16];
char default_dmflags[16];
char default_password[16];
char default_timelimit[16];
char default_cashlimit[16];
char default_fraglimit[16];
char default_dm_realmode[16];
char custom_map_filename[32];  // stores where various files can be found
char ban_name_filename[32];
char ban_ip_filename[32];
int allow_map_voting;
int disable_admin_voting;
int scoreboard_first;
int fph_scoreboard;
int total_rank;          // used in calculating maps picks based on weight
int num_custom_maps;
int num_netnames;
int num_ips;

int fixed_gametype;
int enable_password;
char rconx_file[32];
int num_rconx_pass;
int keep_admin_status;
int default_random_map;
int disable_anon_text;
// SnaP
int roundlimit;
int riotz_teamplay;

MOTD_t	MOTD[20];

player_t playerlist[64];

ban_t	netname[100];
ban_t	ip[100];

ban_t	rconx_pass[100];

//****************************************************
// Snap - this file contains changes to the code
//        for riotz mod play. teamplay is the only
//        mode supported in this code. no FFA mode.
//****************************************************
//==============================================================
//
// Papa - This file contains all the functions that control the 
//        modes a server may be in.
//
//===============================================================

void PublicSetup ()  // returns the server into ffa mode and resets all the cvars (settings)
{
	edict_t		*self;
	int			i;
//snap, server status
	level.modeset = PUBLICROUNDSETUP;
	level.roundnum = 1;
	level.serverstatus = PUBLIC_GAME;

	gi.cvar_set("dmflags",default_dmflags);
	gi.cvar_set("teamplay",default_teamplay);
	gi.cvar_set("password",default_password);
	gi.cvar_set("timelimit",default_timelimit);
	gi.cvar_set("fraglimit",default_fraglimit);
	gi.cvar_set("cashlimit",default_cashlimit);
	gi.cvar_set("dm_realmode",default_dm_realmode);
	level.startframe = level.framenum;
	for_each_player (self,i)
	{
		self->flags &= ~FL_GODMODE;
		self->health = 0;
		meansOfDeath = MOD_RESTART;
//		player_die (self, self, self, 1, vec3_origin, 0, 0);

		ClientBeginDeathmatch( self );	
	}
	
	gi.bprintf(PRINT_HIGH,"The server is once again public.\n");
}


void MatchSetup () // Places the server in prematch mode
{
	edict_t		*self;
	int			i;

	//snap
	level.serverstatus = MATCH_GAME;


	level.modeset = MATCHSETUP;
	level.startframe = level.framenum;

	for_each_player (self,i)
	{
/*		self->movetype = MOVETYPE_NOCLIP;
		self->solid = SOLID_NOT;
		self->svflags |= SVF_NOCLIENT;
		self->client->pers.weapon = NULL;*/
		if (self->client->pers.spectator == SPECTATING)
			continue;
		meansOfDeath = MOD_RESTART;
		self->client->pers.spectator = SPECTATING;
		self->flags &= ~FL_GODMODE;
		self->health = 0;
//		player_die (self, self, self, 1, vec3_origin, 0, 0);
		ClientBeginDeathmatch( self );	
	}

	gi.bprintf(PRINT_HIGH,"The server is now ready to setup a match.\n");
	gi.bprintf(PRINT_HIGH,"Players need to join the correct teams.\n");
	
}

void ResetServer () // completely resets the server including map
{
	char command[64];

	gi.cvar_set("dmflags",default_dmflags);
	gi.cvar_set("teamplay",default_teamplay);
	gi.cvar_set("password",default_password);
	gi.cvar_set("timelimit",default_timelimit);
	gi.cvar_set("fraglimit",default_fraglimit);
	gi.cvar_set("cashlimit",default_cashlimit);
	gi.cvar_set("dm_realmode",default_dm_realmode);
	gi.cvar_set("cheats","0");

	if (default_random_map && num_custom_maps)
		Com_sprintf (command, sizeof(command), "map \"%s\"\n", custom_list[rand()%num_custom_maps].custom_map);
	else
		Com_sprintf (command, sizeof(command), "map \"%s\"\n", default_map);
	gi.AddCommandString (command);
}

int team_startcash[2]={0,0};

void MatchStart()  // start the match
{
	int			i;
	edict_t		*self;
		
	level.player_num=0;


	level.modeset = FINALCOUNT;
	level.startframe = level.framenum;
	gi.bprintf (PRINT_HIGH,"FINAL COUNTDOWN STARTED.  20 SECONDS TO ROUND.\n");
//snap, leave team scores thru rounds
	if (level.roundnum == 1){
		team_cash[1]=0;
		team_cash[2]=0;
		UPDATESCORE
	}
	for_each_player (self,i)
	{
		self->client->pers.bagcash = 0;
		self->client->resp.deposited = 0;
		self->client->pers.currentcash = 0;
		//snap, keep player stats thru rounds in a map
		if(level.roundnum == 1){
			self->client->resp.score = 0;
			self->client->resp.hits = 0;
			self->client->resp.misses = 0;
			self->client->resp.accuracy = 0;
		}
	}

	gi.WriteByte( svc_stufftext );
	gi.WriteString( va("play world/cypress%i.wav", 2+(rand()%4)) );
	gi.multicast (vec3_origin, MULTICAST_ALL);
}


void SpawnPlayer () // Here I spawn players - 1 per server frame in hopes of reducing overflows
{
	edict_t		*self;
	int			i;
	int			team1=false;

//gi.dprintf("IN: SpawnPlayer\n");

	for (i=0 ; i<maxclients->value; i++)
	{
		self = g_edicts + 1 + i;
		if (!self->inuse)
			continue;
		if (!self->client->resp.is_spawn)
		{
//gi.dprintf("Spawn %d\n",i+1);
			self->flags &= ~FL_GODMODE;
			self->health = 0;
			meansOfDeath = MOD_RESTART;
			team1 = true;
			self->client->pers.spectator = PLAYING;
//			player_die (self, self, self, 1, vec3_origin, 0, 0);
			ClientBeginDeathmatch( self );	
			self->client->resp.is_spawn = true;
			break;
		}
	}
	if (!team1)
		level.is_spawn = true;

//gi.dprintf("OUT: SpawnPlayer\n");
}



void SpawnPlayers ()  // Same idea but 1 player per team
{
	edict_t		*self;
	int			i;
	int			team1,team2;

	team1 = false;
	team2 = false;

	for (i=0 ; i<maxclients->value && (!team1 || !team2); i++)
	{
		self = g_edicts + 1 + i;
		if (!self->inuse)
			continue;
		if ((self->client->pers.team == 1) && (!team1) && (!self->client->resp.is_spawn))
		{
			self->flags &= ~FL_GODMODE;
			self->health = 0;
			meansOfDeath = MOD_RESTART;
			team1 = true;
			self->client->pers.spectator = PLAYING;
//			player_die (self, self, self, 1, vec3_origin, 0, 0);
			ClientBeginDeathmatch( self );	
			self->client->resp.is_spawn = true;
		}
		if ((self->client->pers.team == 2) && (!team2) && (!self->client->resp.is_spawn))
		{
			self->flags &= ~FL_GODMODE;
			self->health = 0;
			meansOfDeath = MOD_RESTART;
			team2 = true;
			self->client->pers.spectator = PLAYING;
//			player_die (self, self, self, 1, vec3_origin, 0, 0);
			ClientBeginDeathmatch( self );	
			self->client->resp.is_spawn = true;
		}
	}

	for_each_player(self,i)
	{
		if (self->client->pers.team)
			self->client->pers.playing_ingame = TRUE;
	}
	if ((!team1) && (!team2))
		level.is_spawn = true;
}

void Start_Match () // Starts the match
{
	edict_t		*self;
	int			i;

	level.startframe = level.framenum;
	level.modeset = STARTINGMATCH;
	level.is_spawn = false;
	for_each_player(self,i)
	{
		gi.centerprintf(self,"The Round has begun.\n");
		self->client->resp.is_spawn = false;
		self->client->resp.enterframe = level.framenum;
	}
	//snap, play sound 
	gi.WriteByte( svc_stufftext );
	gi.WriteString( va("play /world/telering.wav") );
	gi.multicast (vec3_origin, MULTICAST_ALL);

//	level.modeset = MATCH;
}

void Start_Pub () // Starts a pub
{
	edict_t		*self;
	int			i;

	level.startframe = level.framenum;
	level.modeset = STARTINGPUB;
	level.is_spawn = false;
	for_each_player(self,i)
	{
		gi.centerprintf(self,"Let the Fun Begin!\n");
		self->client->resp.is_spawn = false;
		self->client->resp.enterframe = level.framenum;
	}

	gi.WriteByte( svc_stufftext );
	gi.WriteString("play world/pawnbuzz_out.wav");
	gi.multicast (vec3_origin, MULTICAST_ALL);
}

void SetupMapVote () // at the end of a level - starts the vote for the next map
{
	edict_t *self;
	int		found;
	int		i,j,k;
	int		unique;
	int		selection;
	

	level.modeset = ENDMATCHVOTING;
	level.startframe = level.framenum;

	for_each_player (self,i)
	{
		self->movetype = MOVETYPE_NOCLIP;
		self->solid = SOLID_NOT;
		self->svflags |= SVF_NOCLIENT;
		self->client->pers.weapon = NULL;
		self->client->pers.spectator = SPECTATING;
	}
	gi.WriteByte( svc_stufftext );
	gi.WriteString( va("play world/cypress%i.wav", 2+(rand()%4)) );
	gi.multicast (vec3_origin, MULTICAST_ALL);

	i = 0;
	found = false;
	while ((!found) && (i < (num_custom_maps - 1) )) 
	{	
		if (Q_stricmp (custom_list[i].custom_map,level.mapname) == 0)
		{
			vote_set[1] = i+1;
			found = true;
		}
		i++;
	}
	if (!found)
		vote_set[1] = 0;

	if (num_custom_maps < 9) // less than 9 maps found, just display them all
	{
		i = vote_set[1];
		for (j=2; j< (num_custom_maps+2); j++)
		{
			i++;
			if (i == num_custom_maps)
				i=0;
			vote_set[j] = i;
		}
		return;
	}
	// first map is always the next in the rotations
	srand((unsigned int)time((time_t *)NULL));

	for (i=2; i < 6; i++) // 2-5 are weighted by rank
	{
		unique = false;
		while (!unique)
		{		
			selection = rand() % total_rank;
			j=0;
			while (selection >= 0)
			{
				selection -= custom_list[j].rank;
				j++;
			}
			vote_set[i] = (j-1);
			unique = true;
			for (k=0; k < i; k++)
				if (vote_set[i] == vote_set[k])
					unique = false;
		}
	}

	for (i=6; i < 9; i++) // 6-8 are just picked at random
	{
		unique = false;
		while (!unique)
		{		
			selection = rand() % num_custom_maps;
			vote_set[i] = selection;
			unique = true;
			for (k=0; k < i; k++)
				if (vote_set[i] == vote_set[k])
					unique = false;
		}
	}
}

void MatchEnd () // end of the match
{
	edict_t *self;
	int i;
//snap
	if(level.serverstatus == PUBLIC_GAME)
		level.modeset = PUBLICROUNDSETUP;
	else
		level.modeset = MATCHSETUP;

	level.startframe = level.framenum;
	for_each_player(self,i)
	{
        //snap, set flag saying they are not in game playing
		self->client->pers.playing_ingame = FALSE;

		self->flags &= ~FL_GODMODE;
		self->health = 0;
		meansOfDeath = MOD_RESTART;
//		player_die (self, self, self, 1, vec3_origin, 0, 0);

		ClientBeginDeathmatch( self );
	}
	gi.WriteByte( svc_stufftext );
	gi.WriteString( va("play world/pawnomatic/register.wav") );
	gi.multicast (vec3_origin, MULTICAST_ALL);
	//snap, possibly too many songs at one time,so changed this to sound

}


void CheckAllPlayersSpawned () // when starting a match this function is called until all the players are in the game
{

	if (teamplay->value)
		SpawnPlayers ();
	else
		SpawnPlayer ();
		
	if ((level.is_spawn) && (level.modeset == STARTINGMATCH))
		level.modeset = MATCH;
	if ((level.is_spawn) && (level.modeset == STARTINGPUB))
		level.modeset = TEAMPLAY;

		
}
//snap, externs needed
extern void EndDMLevel (void);
extern void Cmd_Join_f (edict_t *self, char *teamcmd);

void CheckIdleMatchSetup () // snap, changed this function
{
	int		i;
	edict_t	*doot;
	int     team_1_ready=FALSE;
	int		team_2_ready=FALSE;

	int     total_players_inserver=0;

	if (level.intermissiontime)
		return;

	if(level.roundnum == 0)
	{
		level.roundnum++;
	}

	for_each_player (doot,i)
	{
		if(doot->client->pers.team && doot->client->pers.spectator != PLAYING)
			doot->client->pers.spectator = PLAYING;

		if(doot->client->pers.toggle_team_to_play && !doot->client->pers.team)
		{
			cprintf (doot, PRINT_HIGH, "Auto-Joining Next Round");
			Cmd_Join_f( doot, team_names[doot->client->pers.toggle_team_to_play] );
		}

		doot->client->pers.playing_ingame = FALSE;

		if(doot->client->pers.spectator == PLAYING)
		{
			if(doot->client->pers.team == 1)
				team_1_ready = TRUE;
			else if(doot->client->pers.team == 2)
				team_2_ready = TRUE;
		}

		total_players_inserver++;

	}
	if (team_1_ready && team_2_ready)
		level.roundReady = TRUE;
	else
		level.roundReady = FALSE;

	//snap, reset server if noone is in the server in matchsetup mode
	if (total_players_inserver == 0)
		ResetServer ();

	if (// if round is # 2 or greater + game isnt over, wait 10 secs then do a 20 second countdown then start the round!
			level.roundnum <= roundlimit && level.roundnum != 1 && level.framenum > level.startframe + 100 && level.matchover == FALSE
	   )
	{
		MatchStart();
	}

	if (riotz_teamplay && level.framenum > level.startframe + 50 
		&& (level.roundnum > roundlimit || team_cash[1] > roundlimit/2 || team_cash[2] > roundlimit/2)
		&& level.matchover == FALSE)
	{
		if(level.roundnum > roundlimit)
			gi.bprintf (PRINT_HIGH, "Roundlimit hit!\n");
		else if(team_cash[1] > roundlimit/2)
			gi.bprintf (PRINT_HIGH, "Mobsterz wins the majority of rounds!\n");
		else if(team_cash[2] > roundlimit/2)
			gi.bprintf (PRINT_HIGH, "Gangsterz wins the majority of rounds!\n");

		for_each_player(doot,i)
		{
			if(team_cash[1] > team_cash[2])
				doot->client->showscores = SCORE_TEAM1_WIN;
			else if(team_cash[1] < team_cash[2])
				doot->client->showscores = SCORE_TEAM2_WIN;
			else
				doot->client->showscores = SCORE_TIE_WIN;
			DeathmatchScoreboard (doot);
		}
		level.matchover = TRUE;
	}

}

void CheckIdlePublicSetup () // snap, changed this function
{
	int		count=0;
	int		i;
	edict_t	*doot;
	int     team_1_ready=FALSE;
	int		team_2_ready=FALSE;
	int     total_players_inserver=0;

	if (level.intermissiontime)
		return;

	if(level.roundnum == 0)
	{
		level.roundReady = FALSE;
		level.roundnum++;
	}

	for_each_player (doot,i)
	{
		if(doot->client->pers.team && doot->client->pers.spectator != PLAYING)
			doot->client->pers.spectator = PLAYING;

		if(doot->client->pers.toggle_team_to_play && !doot->client->pers.team)
		{
			cprintf (doot, PRINT_HIGH, "Auto-Joining Next Round");
			Cmd_Join_f( doot, team_names[doot->client->pers.toggle_team_to_play] );
		}

		doot->client->pers.playing_ingame = FALSE;

		if(doot->client->pers.spectator == PLAYING)
		{
			if(doot->client->pers.team == 1)
				team_1_ready = TRUE;
			else if(doot->client->pers.team == 2)
				team_2_ready = TRUE;
			count++;
		}
		//snap, keep player stats thru rounds in a map
		if(level.roundnum == 1){
			doot->client->resp.score = 0;
			doot->client->resp.hits = 0;
			doot->client->resp.misses = 0;
			doot->client->resp.accuracy = 0;
		}

		total_players_inserver++;

	}

	//snap, reset server if noone is in the server and the current round is not 1
	if (total_players_inserver == 0 && level.roundnum != 1)
		ResetServer ();

	if (
		// map load: after 30 seconds, start game (for modemers)
		(((!riotz_teamplay && count > 1) || (riotz_teamplay && team_1_ready && team_2_ready)) && level.framenum > level.startframe + 300 && level.roundnum == 1)
		// if round is # 2 or greater wait 10 secs then do a 20 second countdown then start the round!
		|| (((!riotz_teamplay && count > 1) || (riotz_teamplay && team_1_ready && team_2_ready)) && level.roundnum <= roundlimit && level.roundnum != 1 && level.framenum > level.startframe + 100)
	   )
	{
		MatchStart();
		level.roundReady = TRUE;
	}

	if (((count < 2 && !riotz_teamplay) || (riotz_teamplay && (!team_1_ready || !team_2_ready))) && total_players_inserver > 0)
	{
		//Waiting for Players to Join
		level.roundReady = FALSE;
	}

	if (riotz_teamplay && level.framenum > level.startframe + 50 
		&& (level.roundnum > roundlimit || team_cash[1] > roundlimit/2 || team_cash[2] > roundlimit/2))
	{
		if(level.roundnum > roundlimit)
			gi.bprintf (PRINT_HIGH, "Roundlimit hit!\n");
		else if(team_cash[1] > roundlimit/2)
			gi.bprintf (PRINT_HIGH, "Mobsterz wins the majority of rounds!\n");
		else if(team_cash[2] > roundlimit/2)
			gi.bprintf (PRINT_HIGH, "Gangsterz wins the majority of rounds!\n");

		for_each_player(doot,i)
		{
			if(team_cash[1] > team_cash[2])
				doot->client->showscores = SCORE_TEAM1_WIN;
			else if(team_cash[1] < team_cash[2])
				doot->client->showscores = SCORE_TEAM2_WIN;
			else
				doot->client->showscores = SCORE_TIE_WIN;
			DeathmatchScoreboard (doot);
		}
		EndDMLevel ();
		return;
	}

}


void CheckStartMatch () // 20 countdown before matches, snap increased this
{
	if (level.framenum >= level.startframe + 195)
	{
		Start_Match ();
		return;
	}

	if ((level.framenum % 10 == 0 ) && (level.framenum > level.startframe + 99))
		gi.bprintf(PRINT_HIGH,"The Round will start in %d seconds!\n", (190 - (level.framenum - level.startframe)) / 10);
}

void CheckStartPub () // 35 second countdown before server starts
{
	if (level.framenum >= 345)
	{
		Start_Pub ();
		return;
	}

	if ((level.framenum % 10 == 0 ) && (level.framenum > 299))
		gi.bprintf(PRINT_HIGH,"The Server will start in %d seconds!\n", (340 - (level.framenum )) / 10);
}

//snap, changed this function
void CheckEndMatch () // check if time,frag,cash limits have been reached in a match
{
	int			i;
//	gclient_t	*cl;
	int		total_players_inserver = 0;
	edict_t	*doot;
	//snap
	int         dragons_numplayers_alive = 0;
	int         nikkis_numplayers_alive = 0;

	for_each_player (doot,i)
	{
		if(doot->client->pers.playing_ingame == TRUE)
		{
			switch(doot->client->pers.team)
			{
				case 1:
					dragons_numplayers_alive++;
					break;
				case 2:
					nikkis_numplayers_alive++;
					break;
				default:
					break;
			}
		}
		total_players_inserver++;
	}

    if(riotz_teamplay)
	{
		if(dragons_numplayers_alive && !nikkis_numplayers_alive)
		{
			gi.bprintf (PRINT_HIGH, "Mobsterz Win Round %d!\n", level.roundnum);

			team_cash[1]++;
			UPDATESCORE
		
			level.roundnum++;
			MatchEnd();
			return;
		}
		else if(!dragons_numplayers_alive && nikkis_numplayers_alive)
		{
			gi.bprintf (PRINT_HIGH, "Gangsterz Win Round %d!\n", level.roundnum);

			team_cash[2]++;
			UPDATESCORE

			level.roundnum++;
			MatchEnd();
			return;
		}
		else if(!dragons_numplayers_alive && !nikkis_numplayers_alive)
		{
			gi.bprintf (PRINT_HIGH, "There is a Tie!\n");

			level.roundnum++;
			MatchEnd();
			return;
		}
		//timelimit
		else if(level.framenum > (level.startframe + ((int)timelimit->value) * 600 - 1))
		{
			gi.bprintf (PRINT_HIGH, "Timelimit hit.\n");

			if(dragons_numplayers_alive > nikkis_numplayers_alive)
			{
				gi.bprintf (PRINT_HIGH, "Mobsterz Win Round %d!\n", level.roundnum);

				team_cash[1]++;
				UPDATESCORE
			}
			else if(dragons_numplayers_alive < nikkis_numplayers_alive)
			{
				gi.bprintf (PRINT_HIGH, "Gangsterz Win Round %d!\n", level.roundnum);

				team_cash[2]++;
				UPDATESCORE
			}
			else
			{
				gi.bprintf (PRINT_HIGH, "There Is A Tie On Round %d!\n", level.roundnum);

			}

			level.roundnum++;
			MatchEnd();
			return;
		}

	}
	else
	{
		if(dragons_numplayers_alive == 1)
		{
			gi.bprintf (PRINT_HIGH, "There is a Winner for Round %d!\n", level.roundnum);

			level.roundnum++;
			MatchEnd();
			return;
		}
		else if(!dragons_numplayers_alive)
		{
			gi.bprintf (PRINT_HIGH, "Everyone is Dead in Round %d!\n", level.roundnum);

			level.roundnum++;
			MatchEnd();
			return;
		}
		else if (level.framenum > (level.startframe + ((int)timelimit->value) * 600 - 1))
		{
			gi.bprintf (PRINT_HIGH, "Timelimit hit.\n");
			MatchEnd();
			return;
		}
	}


/*	if ((int)fraglimit->value)
	{
		for (i=0 ; i<maxclients->value ; i++)
		{
			cl = game.clients + i;
			if (!g_edicts[i+1].inuse)
				continue;

			if (cl->resp.score >= (int)fraglimit->value)
			{
				gi.bprintf (PRINT_HIGH, "Fraglimit hit.\n");
				MatchEnd ();
				return;
			}
		}
	}


	if ((int)cashlimit->value)
	{
		if ((team_cash[1] >= (int)cashlimit->value) || (team_cash[2] >= (int)cashlimit->value))
		{
			gi.bprintf (PRINT_HIGH, "Cashlimit hit.\n");
			MatchEnd ();
			return;
		}
	}*/
//snap, no fraglimit or cashlimit for riotz

	if (((level.framenum - level.startframe ) % 10 == 0 ) && (level.framenum > (level.startframe + (((int)timelimit->value  * 600) - 155))))  
	{
		gi.bprintf(PRINT_HIGH,"The Round will end in  %d seconds\n", (((int)timelimit->value * 600) + level.startframe - level.framenum ) / 10);
		return;
	}

	if (((level.framenum - level.startframe ) % 600 == 0 ) && (level.framenum > (level.startframe + (((int)timelimit->value * 600) - 3000))))  
	{
		gi.bprintf(PRINT_HIGH,"The Round will end in  %d minutes\n", (((int)timelimit->value * 600) + level.startframe - level.framenum ) / 600);
		return;
	}

	if ((level.framenum - level.startframe ) % 3000 == 0 )
		gi.bprintf(PRINT_HIGH,"The Round will end in  %d minutes\n", (((int)timelimit->value * 600) + level.startframe - level.framenum ) / 600);

}

void CheckEndVoteTime () // check the timelimit for voting next level/start next map
{
	int		i,count[9];
	edict_t *player;
	char	command[64];
	int		wining_map;

	if (level.framenum == (level.startframe + 10))
	{
		for_each_player (player,i)
		{
			if (scoreboard_first)
				player->client->showscores = SCOREBOARD;
			else
				player->client->showscores = SCORE_MAP_VOTE;
			DeathmatchScoreboard (player);
		}
	}

	if (level.framenum > (level.startframe + 300))
	{
		memset (&count, 0, sizeof(count));
		for_each_player(player,i)
		{
			count[player->vote]++;
		}
		wining_map = 1;
		for (i = 2;i < 9 ; i++)
		{
			custom_list[vote_set[i]].rank += count[i];
			if (count[i] > count[wining_map])
				wining_map = i;
		}
		i = write_map_file();
		if (i != OK)
			gi.dprintf("Error writing custom map file!\n");

		Com_sprintf (command, sizeof(command), "gamemap \"%s\"\n", custom_list[vote_set[wining_map]].custom_map);
		gi.AddCommandString (command);
	}
}

void CheckVote() // check the timelimit for an admin vote
{
	
	if (level.framenum > (level.voteframe + 1200))
	{
		switch (level.voteset)
		{
			case VOTE_ON_ADMIN:
				gi.bprintf(PRINT_HIGH,"The request for admin has failed!\n");
				break;
		}
		level.voteset = NO_VOTES;
	}
}



int	CheckPlayerBan (edict_t *ent, char *userinfo) 
{
	char	*value;
	int		i,j;
	int		isSame;

	value = Info_ValueForKey (userinfo, "name");
	for (i=0;i<num_netnames;i++) {
		if (Q_strcasecmp (netname[i].value, value) == 0)
			return true;
	}

	value = Info_ValueForKey (userinfo, "ip");
	for (i=0;i<num_ips;i++) {
		isSame = true;
		j = 0;
		while ((isSame) && (value[j] != '\0') && (value[j] != ':'))
		{		
			if (ip[i].value[j] != value[j])
				isSame = false;
			j++;
		}
		if (isSame)
			return true;
	}

	return false;
}

