

#define STAT_KPQ2_TEAM1_PIC			17
#define STAT_KPQ2_TEAM1_CAPS			18
#define STAT_KPQ2_TEAM2_PIC			19
#define STAT_KPQ2_TEAM2_CAPS			20
#define STAT_KPQ2_FLAG_PIC			21
#define STAT_KPQ2_JOINED_TEAM1_PIC	22
#define STAT_KPQ2_JOINED_TEAM2_PIC	23
#define STAT_KPQ2_TEAM1_HEADER		24
#define STAT_KPQ2_TEAM2_HEADER		25
#define STAT_KPQ2_TECH				26
#define STAT_KPQ2_ID_VIEW			27

#define KPQ2_TEAM1_SKIN   "ctf_r"
#define KPQ2_TEAM2_SKIN   "ctf_b"


extern char *ctf_statusbar;

typedef enum {
	KPQ2_NOTEAM,
	KPQ2_TEAM1,
	KPQ2_TEAM2
} ctfteam_t;


#define KPQ2_CAPTURE_BONUS		15	// what you get for capture
#define KPQ2_TEAM_BONUS			10	// what your team gets for capture
#define KPQ2_RECOVERY_BONUS		1	// what you get for recovery
#define KPQ2_FLAG_BONUS			0	// what you get for picking up enemy flag
#define KPQ2_FRAG_CARRIER_BONUS	2	// what you get for fragging enemy flag carrier
#define KPQ2_FLAG_RETURN_TIME	40	// seconds until auto return

#define KPQ2_CARRIER_DANGER_PROTECT_BONUS	2	// bonus for fraggin someone who has recently hurt your flag carrier
#define KPQ2_CARRIER_PROTECT_BONUS			1	// bonus for fraggin someone while either you or your target are near your flag carrier
#define KPQ2_FLAG_DEFENSE_BONUS				1	// bonus for fraggin someone while either you or your target are near your flag
#define KPQ2_RETURN_FLAG_ASSIST_BONUS		1	// awarded for returning a flag that causes a capture to happen almost immediately
#define KPQ2_FRAG_CARRIER_ASSIST_BONUS		2	// award for fragging a flag carrier if a capture happens almost immediately

#define KPQ2_TARGET_PROTECT_RADIUS			400	// the radius around an object being defended where a target will be worth extra frags
#define KPQ2_ATTACKER_PROTECT_RADIUS			400	// the radius around an object being defended where an attacker will get extra frags when making kills

#define KPQ2_CARRIER_DANGER_PROTECT_TIMEOUT	8
#define KPQ2_FRAG_CARRIER_ASSIST_TIMEOUT		10
#define KPQ2_RETURN_FLAG_ASSIST_TIMEOUT		10

#define KPQ2_AUTO_FLAG_RETURN_TIMEOUT		30	// number of seconds before dropped flag auto-returns

//#define KPQ2_GRAPPLE_SPEED					950 // speed of grapple in flight
//#define KPQ2_GRAPPLE_PULL_SPEED				650	// speed player is pulled at

#define KPQ2_GRAPPLE_SPEED					2000 // speed of grapple in flight
#define KPQ2_GRAPPLE_PULL_SPEED				650	// speed player is pulled at



#define KPQ2_TECH_TIMEOUT					60  // seconds before techs spawn again

// KPQ2 FUNCTIONS
void KPQ2Say_Team(edict_t *who, char *msg);
void KPQ2AssignTeam(gclient_t *who);
void KPQ2OpenJoinMenu(edict_t *ent);
char *KPQ2TeamName(int team);
char *KPQ2OtherTeamName(int team);
void KPQ2Effects(edict_t *player);
void KPQ2CalcScores(void);
void SetKPQ2Stats(edict_t *ent);
void KPQ2DeadDropFlag(edict_t *self);
void KPQ2ScoreboardMessage (edict_t *ent, edict_t *killer);
void KPQ2Team_f (edict_t *ent);
//void KPQ2ID_f (edict_t *ent);
void KPQ2FlagSetup (edict_t *ent);
void KPQ2ResetFlag(int ctf_team);
void KPQ2FragBonuses(edict_t *targ, edict_t *inflictor, edict_t *attacker);
void KPQ2CheckHurtCarrier(edict_t *targ, edict_t *attacker);
qboolean KPQ2Pickup_Flag(edict_t *ent, edict_t *other);
qboolean KPQ2Drop_Flag(edict_t *ent, gitem_t *item);

// CHASECAM
void UpdateChaseCam(edict_t *ent);
void ChaseNext(edict_t *ent);
void ChasePrev(edict_t *ent);

// GRAPPLE
void KPQ2Weapon_Grapple (edict_t *ent);
void KPQ2PlayerResetGrapple(edict_t *ent);
void KPQ2GrapplePull(edict_t *self);
void KPQ2ResetGrapple(edict_t *self);
void KPQ2Weapon_Grapple_Fire (edict_t *ent);

//TECH
gitem_t *KPQ2What_Tech(edict_t *ent);
qboolean KPQ2Pickup_Tech (edict_t *ent, edict_t *other);
void KPQ2Drop_Tech(edict_t *ent, gitem_t *item);
void KPQ2DeadDropTech(edict_t *ent);
void KPQ2SetupTechSpawn(void);
int KPQ2ApplyResistance(edict_t *ent, int dmg);
int KPQ2ApplyStrength(edict_t *ent, int dmg);
qboolean KPQ2ApplyStrengthSound(edict_t *ent);
qboolean KPQ2ApplyHaste(edict_t *ent);
void KPQ2ApplyHasteSound(edict_t *ent);
void KPQ2ApplyRegeneration(edict_t *ent);
qboolean KPQ2HasRegeneration(edict_t *ent);
void KPQ2RespawnTech(edict_t *ent);

//SPAWNS
void SP_info_player_team1(edict_t *self);
void SP_info_player_team2(edict_t *self);
//void SP_trigger_teleport (edict_t *ent);
//void SP_info_teleport_destination (edict_t *ent);
void SP_misc_ctf_banner (edict_t *ent);
void SP_misc_ctf_small_banner (edict_t *ent);

