#include "g_local.h"

//............................................................................
// Character Names
//

// ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !
//
// Note, these must be in the same order as the defines in ep_all.h!
//
// ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! ! !

char *ep_names[] =
{
	"--THIS SLOT MUST BE VACANT--",
	"Al",
	"Beth",
	"Magicj",
	"Lisa",
	"Louie",
	"Frank",
	"Buttmunch",
	"Arnold",
	"Brewster",
	"Punky",
	"Igmo",
	"Johnny",
	"Betty",
	"Leroy",
	"Jed",
	"Buster",
	"Bubba",
	"Momo",
	"Muttski",
	"Spike",
	"ToughGuy1",
	"ToughGuy2",
	"IntroGuy",
	"Bernie",
	"Lamont",
	"Mona",
	"Lenny",
	"Chick",
	"Sluggo",
	"Rocko",
	"Rover",
	"Joseph",
	"Rummy", // sr1 bum
	"Nick",  // sr2 bum
	"Jesus", // sr boss 
	"Yolanda",
	"Carlton",
	"Tina",
	"Hardey",
	"Laurel",
	"Harold",
	"Dick",
	"Burt",
	"Fingers",
	"Dan",
	"Clarence",
	"Adolf",
	"Candy",
	"Sharky",
	"Kingpin",
	"Blunt",
	"NikkiBlanco",
	"Moe",
	"Larry",
	"Curly",
	"Ed",
	"Popeye",
	"Dogg",
	"Selma",
	"Jane",
	"Barney",
	"BigWillie",
	"Sal",
	"Lefty",
	"Bwillie",
	"Mung",
	"Tyrone",
	"Luke",
	"Hann",
	"Kroker",
	"kid_1",
	"kid_2",
	"kid_3",
	"kid_4",
	"kid_5",
	"kid_6",
	"kid_7",
	"kid_8",
	"Oscar",
	"David",
	"Bambi",
	"Brittany",
	"Mathew",
	"Pete",
	"Moker",
	"Heilman",
	"Butch",
	"Patrick",
	"Groucho",
	"Harpo",
	"Chico",
	"Blefty",
	"Scalper",
	"Dubs",
	"Rochelle",
	"Lola",
	"Dude",
	"Walter",
	"Donny",
	"Officer BarBrady",
	NULL
};

//............................................................................

// This sets the self->name_index according to the list above
void	EP_SetNameIndex ( edict_t *self )
{
	int i;

	if (!self->name)
	{
		self->name_index = -1;
		return;
	}

	for (i=0; ep_names[i]; i++)
	{
		if (self->name)
			if (!Q_stricmp(self->name, ep_names[i]))
			{	// found a match
				self->name_index = i;
				return;
			}
	}

	// no match found!
	gi.dprintf( "EP_SetNameIndex: Un-matched \"name\" (%s)\n", self->name );
	self->name_index = -1;
}

// Given a NAME_*, returns the entity with the matching name
edict_t	*EP_GetCharacter ( int nameIndex )
{
	int i;

	for (i=0; i<level.num_characters; i++)
	{
		if (!level.characters[i])
			continue;

		if (level.characters[i]->name_index == nameIndex)
		{
			if ((level.characters[i]->inuse) && (level.characters[i]->svflags & SVF_MONSTER) && (level.characters[i]->health > 0))
				return level.characters[i];
			else
				return NULL;	// character has died
		}
	}

	// This is causing problems be cause the guy could get refrenced yet be on another map
	// gi.dprintf( "EP_GetCharacter: couldn't find %s\n", ep_names[nameIndex] );

	return NULL;	// couldn't find them
}

// Given a "name", returns the entity with the matching name
edict_t	*EP_GetCharacterByName ( char *name )
{
	int i;

	for (i=0; i<level.num_characters; i++)
	{
		if (!level.characters[i])
			continue;

		if (!Q_stricmp( level.characters[i]->name, name ))
		{
			if ((level.characters[i]->inuse) && (level.characters[i]->svflags & SVF_MONSTER) && (level.characters[i]->health > 0))
				return level.characters[i];
			else
				return NULL;	// character has died
		}
	}

	gi.dprintf( "EP_GetCharacter: couldn't find %s\n", name );

	return NULL;	// couldn't find them
}

//............................................................................
// Gang Names
//
// These will match the "cast_group" value for characters in the game
// Also must match the defines in ep_all.h !!

char *ep_gang_names[] =
{
	"(neutral)",
	"Our Gang(?)",
	"Main Gang(?)",
	"Rat-Gang",
	NULL
};

char	*EP_GetGangName ( int cast_group )
{
	static char	unknown_str[] = "**UNKNOWN**";

	if (cast_group >= NUM_GANGS)
		return unknown_str;

	return ep_gang_names[cast_group];
}

//=======================================================================================================
