#include "g_local.h"

//+AS Scroll Menu Source Code

#define MAX_MENU_ITEMS	8

#define MENU_LEFT_SIDE	0
#define MENU_RIGHT_SIDE	1

struct MENU_HEADER_NAME
{
	char *name[8];
} menu_header =

{
	{	"Ammo",
		"Equipment",
		"Grenades",
		"Hand Weapon",
		"Pistols",
		"Shotguns",
		"Sub-Rifle",
		"Rifles"
	}
};

struct MENU_ITEM_NAMES
{
	char	*name[8];
	int		price[8];
} menu_item_names[3][MAX_MENU_ITEMS] =
{
	//Null Team
	{
	//Ammo
		{ {NULL} },
	//Equipment	
		{ {NULL} },
	//Grenades
		{ {NULL} },
	//Hand Weapon
		{ {NULL} },
	//Pistol	
		{ {NULL} },
	//Shotgun
		{ {NULL} },
	//Sub-Rifle	
		{ {NULL} },
	//Rifle
		{ {NULL} }
	},
	//Police
	{
	//Ammo
		{ {"Primary", "Secondary" }, {50, 50} },
	//Equipment	
		{ {"Helmet Armor", "Jacket Armor", "Legs Armor", "Helmet Armor Heavy", "Jacket Armor Heavy", "Legs Armor Heavy"}, {250, 500, 250, 500, 1000, 500} },
	//Grenades
		{ {"Frags", "Flash"}, {250, 250} },
	//Hand Weapon
		{ {"Hatchet"}, {250} },
	//Pistol	
		{ {"Beretta 9mm"}, {500} },
	//Shotgun
		{ {"Benelli M3 Super 90"}, {750} },
	//Sub-Rifle	
		{ {"H&K MP5"}, {1000} },
	//Rifle
		{ {"M16A2", "Para M249"}, {1500, 2000} }
	},
	//Robbers
	{
	//Ammo
		{ {"Primary", "Secondary" }, {50, 50} },
	//Equipment	
		{ {"Helmet Armor", "Jacket Armor", "Legs Armor", "Helmet Armor Heavy", "Jacket Armor Heavy", "Legs Armor Heavy"}, {250, 500, 250, 500, 1000, 500} },
	//Grenades
		{ {"Frags", "Flash"}, {250, 250} },
	//Hand Weapon
		{ {"Bat"}, {250} },
	//Pistol	
		{ {"Colt 45cal"}, {500} },
	//Shotgun
		{ {"Mossberg Jungle Gun"}, {750} },
	//Sub-Rifle	
		{ {"Uzi 9mm"}, {1000} },
	//Rifle
		{ {"AK-47", "Para M249"}, {1500, 2000} }
	}
};

//+AS For Game Status
void Cmd_GameStatus_f (edict_t *ent)
{
	gclient_t	*cl;
	cl = ent->client;

	if ( teamplay->value )
		gi.cprintf( ent, PRINT_HIGH, "Teamplay Game\n");
	else if (deathmatch->value)
		gi.cprintf( ent, PRINT_HIGH, "Deathmatch Game\n");

	if (last_man_standing->value)
		gi.cprintf( ent, PRINT_HIGH, "Last Man Standing: Yes\n");
	else
		gi.cprintf( ent, PRINT_HIGH, "Last Man Standing: No\n");

	if ((int)(dmflags->value) & DF_NO_FRIENDLY_FIRE)
		gi.cprintf( ent, PRINT_HIGH, "Friendly Fire: No\n");
	else
		gi.cprintf( ent, PRINT_HIGH, "Friendly Fire: Yes\n");
	
	gi.cprintf( ent, PRINT_HIGH, "Level Time Limit: %i\n", timelimit->value);
	gi.cprintf( ent, PRINT_HIGH, "Round Time Limit: %i\n", round_time_limit->value);
	gi.cprintf( ent, PRINT_HIGH, "Frag Limit: %i\n", fraglimit->value);
	gi.cprintf( ent, PRINT_HIGH, "Cash/Win Limit: %i\n", cashlimit->value);
	gi.cprintf( ent, PRINT_HIGH, "Police Briefcases: %i (%i)\n", level.m_iNumPoliceBriefcases, level.m_iNumRobberBriefcasesReturned);
	gi.cprintf( ent, PRINT_HIGH, "Robber Briefcases: %i (%i)\n", level.m_iNumRobberBriefcases, level.m_iNumPoliceBriefcasesReturned);
	gi.cprintf( ent, PRINT_HIGH, "AI Bots: %i\n", level.total_monsters);
	gi.cprintf( ent, PRINT_HIGH, "Police: %i(%i)\n", level.m_iNumPolice, level.m_iNumPoliceAlive);
	gi.cprintf( ent, PRINT_HIGH, "Robbers: %i(%i)\n", level.m_iNumRobber, level.m_iNumRobberAlive);
}


//+AS For scroll menu init
/*
=================
Cmd_InitMenu_f
=================
*/
void Cmd_InitMenu_f (edict_t *ent)
{
	gclient_t	*cl;

	cl = ent->client;

	cl->showscores = false;
	cl->showhelp = false;
	cl->showinventory = false;

	if (cl->showscrollmenu)
	{
		cl->showscrollmenu = false;
		return;
	}
	else
	{
		cl->showscrollmenu = true;
	}

	ScrollMenuMessage (ent);
}

void ScrollMenuMessage (edict_t *ent)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j, yofs=0;
	
	char	leftname[32];
	char	rightname[32];
	char	*lefttag;
	char	*righttag;

	string[0] = 0;
	stringlength = 0;

	if (ent->client->showscrollmenu)
	{

		for (i=0; i<MAX_MENU_ITEMS; i++)
		{
			if (i == ent->current_menu_left && !ent->current_menu_side)
			{
				lefttag = "999";
			}
			else
			{
				lefttag = "444";
			}

			if (i == ent->current_menu_right && ent->current_menu_side)
			{
				righttag = "999";
			}
			else
			{
				righttag = "444";
			}
		
		
			if (menu_header.name[i])
			{
				strcpy( leftname, menu_header.name[i]);
			}
			else
			{
				strcpy( leftname, "");
			}

			//Check for buying ammo
			if (!ent->current_menu_left)
			{
				gitem_t		*it,*ammo;

				if (i == 0)
				{
					sprintf( rightname, "Primary - ");
					if (ent->client->pers.PrimaryWeaponIndex)
					{
						it = &itemlist[ent->client->pers.PrimaryWeaponIndex];
						ammo = FindItem(it->ammo);
						strcat( rightname, ammo->pickup_name);
					}
					else
					{
						strcat( rightname, "None");		
					}
				}
				else if (i == 1)
				{
					sprintf( rightname, "Secondary - ");
					if (ent->client->pers.SecondaryWeaponIndex)
					{
						it = &itemlist[ent->client->pers.SecondaryWeaponIndex];
						ammo = FindItem(it->ammo);
						strcat( rightname, ammo->pickup_name);
					}
					else
					{
						strcat( rightname, "None");
					}
				}
				else
				{
					sprintf( rightname, "");
				}
			}
			else if (menu_item_names[ent->client->pers.team][ent->current_menu_left].name[i])
			{
				sprintf( rightname, "%i - ", menu_item_names[ent->client->pers.team][ent->current_menu_left].price[i]);
				strcat( rightname, menu_item_names[ent->client->pers.team][ent->current_menu_left].name[i]);
			}
			else
			{
				strcpy( rightname, "");
			}
		
			Com_sprintf(entry, sizeof(entry), "xl 20 yv %i dmstr %s \"%s\" xl 150 dmstr %s \"%s\" ", yofs-109, lefttag, leftname, righttag, rightname);
			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;
			yofs+=20;
		}

	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
	gi.unicast (ent, false);//true);
}

extern void AutoLoadWeapon( gclient_t *client, gitem_t *weapon, gitem_t *ammo );

void ScrollMenuBuy(edict_t *ent)
{
	gitem_t		*it;
	int			index;
	edict_t		*it_ent;
	int oldcost = 0;

	//+AS Must be on right side to have something selected
	if (!ent->current_menu_side)
		return;

	if (!ent->current_menu_left)
	{
		if (ent->current_menu_right == 0)
		{
			if (!ent->client->pers.PrimaryWeaponIndex)
				return;
			it = &itemlist[ent->client->pers.PrimaryWeaponIndex];
		}
		else
		{
			if (!ent->client->pers.SecondaryWeaponIndex)
				return;
			it = &itemlist[ent->client->pers.SecondaryWeaponIndex];
		}
		it = FindItem(it->ammo);
	}
	else
	{
		it = FindItem (menu_item_names[ent->client->pers.team][ent->current_menu_left].name[ent->current_menu_right]);
	}

	if (!it)
	{
		//name = gi.argv(1);
		//it = FindItem (name);
		//if (!it)
		//{
			gi.cprintf (ent, PRINT_HIGH, "not a valid item\n");
			return;
		//}
	}

	if (!it->pickup)
	{
		gi.cprintf (ent, PRINT_HIGH, "non-pickup item\n");
		return;
	}

	index = ITEM_INDEX(it);

	if (it->flags & IT_AMMO)
	{
		gitem_t		*it_weapon;
		int			index_weapon;

		if (ent->client->pers.currentcash < menu_item_names[ent->client->pers.team][ent->current_menu_left].price[ent->current_menu_right])
		{
			gi.cprintf (ent, PRINT_HIGH, "not enough money available\n");
			return;
		}

		if (ent->current_menu_left == 2)
		{
			if (ent->current_menu_right == 0)
			{
				it_weapon = FindItem ("Grenade Frag");
			}
			else if (ent->current_menu_right == 1)
			{
				it_weapon = FindItem ("Grenade Flash");
			}
			
			index_weapon = ITEM_INDEX(it_weapon);

			if (!ent->client->pers.inventory[index_weapon])
			{
				it_ent = G_Spawn();
				it_ent->classname = it_weapon->classname;
				SpawnItem (it_ent, it_weapon);
				Touch_Item (it_ent, ent, NULL, NULL);
				if (it_ent->inuse)
					G_FreeEdict(it_ent);
			}
			else
			{
				if (!ent->client->pers.inventory[index])
					ent->client->pers.inventory[index] = 1;
				else
				{
					gi.cprintf (ent, PRINT_HIGH, "You cannot carry any more of this ammo\n");
					return;
				}
			}
		}
		else
		{
		//if (gi.argc() == 3)
		//	ent->client->pers.inventory[index] = atoi(gi.argv(2));
		//else
			if ( !Add_Ammo( ent, it, it->quantity ) )
			{
				gi.cprintf (ent, PRINT_HIGH, "You cannot carry any more of this ammo\n");
				return;
			}
		//ent->client->pers.inventory[index] += it->quantity;
		//ent->client->pers.inventory[index] += 30;
		}
	}
	else if (it->flags & IT_ARMOR)
	{
		if (ent->client->pers.currentcash < menu_item_names[ent->client->pers.team][ent->current_menu_left].price[ent->current_menu_right])
		{
			gi.cprintf (ent, PRINT_HIGH, "not enough money available\n");
			return;
		}

		ent->client->pers.inventory[ITEM_INDEX(it)] = it->quantity;
	}
	else
	{
		gitem_t *ammo;

		if (it->flags & IT_PRIMARY)
		{
			if (ent->client->pers.PrimaryWeaponIndex)
			{
				oldcost = ent->client->pers.PrimaryWeaponCost;
				ent->client->pers.inventory[ent->client->pers.PrimaryWeaponIndex] = 0;
			}

			if (ent->client->pers.currentcash + oldcost < menu_item_names[ent->client->pers.team][ent->current_menu_left].price[ent->current_menu_right])
			{
				gi.cprintf (ent, PRINT_HIGH, "not enough money available\n");
				return;
			}
	
			ent->client->pers.PrimaryWeaponIndex = ITEM_INDEX(it);
			ent->client->pers.PrimaryWeaponCost = menu_item_names[ent->client->pers.team][ent->current_menu_left].price[ent->current_menu_right];
		}
		else if (it->flags & IT_SECONDARY)
		{
			if (ent->client->pers.SecondaryWeaponIndex)
			{
				oldcost = ent->client->pers.SecondaryWeaponCost;
				ent->client->pers.inventory[ent->client->pers.SecondaryWeaponIndex] = 0;
			}

			if (ent->client->pers.currentcash + oldcost < menu_item_names[ent->client->pers.team][ent->current_menu_left].price[ent->current_menu_right])
			{
				gi.cprintf (ent, PRINT_HIGH, "not enough money available\n");
				return;
			}

			ent->client->pers.SecondaryWeaponIndex = ITEM_INDEX(it);
			ent->client->pers.SecondaryWeaponCost = menu_item_names[ent->client->pers.team][ent->current_menu_left].price[ent->current_menu_right];
		}

		it_ent = G_Spawn();
		it_ent->classname = it->classname;
		SpawnItem (it_ent, it);
		//Touch_Item (it_ent, ent, NULL, NULL);

		ent->client->pers.inventory[index] = 1;

		if (it_ent->inuse)
			G_FreeEdict(it_ent);

		if (it->ammo)
		{
			ammo = FindItem(it->ammo);

			if (!ent->client->pers.inventory[ITEM_INDEX(ammo)])
				Add_Ammo( ent, ammo, ammo->quantity );
			
			AutoLoadWeapon(ent->client, it, ammo);
		}

		ent->client->newweapon = it;
		ChangeWeapon(ent);

		ent->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(it->icon);
		ent->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+ITEM_INDEX(it);
		// JOSEPH 25-JAN-99
		ent->client->pickup_msg_time = level.time + 5.5;

		if (it->use)
			ent->client->pers.selected_item = ent->client->ps.stats[STAT_SELECTED_ITEM] = ITEM_INDEX(it);
	}

	gi.sound(ent, CHAN_ITEM, gi.soundindex(it->pickup_sound), 1, ATTN_NORM, 0);
	ent->client->pers.currentcash -= (menu_item_names[ent->client->pers.team][ent->current_menu_left].price[ent->current_menu_right] - oldcost);
	gi.cprintf(ent, PRINT_HIGH, "Bought: %s\n", it->classname );
}

void ScrollMenuLeft(edict_t *ent)
{
	if (ent->current_menu_side)
	{
		ent->current_menu_side = 0;
	}

	ScrollMenuMessage( ent );
}

void ScrollMenuRight(edict_t *ent)
{
	if (!ent->current_menu_side)
	{
		ent->current_menu_side = 1;
	}

	ScrollMenuMessage( ent );
}

void ScrollMenuPrev(edict_t *ent)
{
	if (!ent->current_menu_side)
	{
		if (menu_header.name[ent->current_menu_left - 1])
		{
			ent->current_menu_left--;
			ent->current_menu_right = 0;
		}
		else
		{
			ent->current_menu_left = MAX_MENU_ITEMS-1;
		}
	}
	else
	{
		if (menu_item_names[ent->client->pers.team][ent->current_menu_left].name[ent->current_menu_right - 1])
			ent->current_menu_right--;
		else
			ent->current_menu_right = 0;
	}

	ScrollMenuMessage( ent );
}

void ScrollMenuNext(edict_t *ent)
{
	if (!ent->current_menu_side)
	{
		if (menu_header.name[ent->current_menu_left + 1])
		{
			ent->current_menu_left++;
			ent->current_menu_right = 0;
		}
		else
		{
			ent->current_menu_left = 0;
		}
	}
	else
	{
		if (menu_item_names[ent->client->pers.team][ent->current_menu_left].name[ent->current_menu_right + 1])
			ent->current_menu_right++;
		else
			ent->current_menu_right = 0;
	}

	ScrollMenuMessage( ent );
}

static void drop_briefcase_touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other == ent->owner)
		return;

	Touch_Item (ent, other, plane, surf);
}

static void drop_make_touchable_briefcase (edict_t *ent)
{
	ent->touch = Touch_Item;
	//Wait until gameover to destroy these
	if (level.gamestatus == GAME_POLICEWON || level.gamestatus == GAME_ROBBERWON)
	{
		ent->nextthink = level.time + 1;
		ent->think = G_FreeEdict;
	}
	else
	{
		ent->nextthink = level.time + 2;
	}
}

void Cmd_DropBriefcase_f (edict_t *ent)
{
	if (ent->briefcase)
	{
	
		edict_t	*dropped;
		gitem_t *item = FindItemByClassname ("item_briefcaseopen");
		vec3_t	forward, right;
		vec3_t	offset;

		dropped = G_Spawn();

		dropped->classname = item->classname;
		dropped->item = item;

		dropped->s.effects = item->world_model_flags;
		dropped->s.renderfx = RF_GLOW;
		// JOSEPH 15-MAR-99	
		dropped->s.renderfx2 = RF2_NOSHADOW; 	
		// END JOSEPH
		VectorSet (dropped->mins, -15, -15, -15);
		VectorSet (dropped->maxs, 15, 15, 15);
		gi.setmodel (dropped, dropped->item->world_model);
		dropped->solid = SOLID_TRIGGER;
		dropped->movetype = MOVETYPE_TOSS;  
		dropped->touch = drop_briefcase_touch;
		dropped->owner = ent;

		if (ent->client)
		{
			trace_t	trace;
	
			AngleVectors (ent->client->v_angle, forward, right, NULL);
			VectorSet(offset, 24, 0, -16);
			G_ProjectSource (ent->s.origin, offset, forward, right, dropped->s.origin);
			trace = gi.trace (ent->s.origin, dropped->mins, dropped->maxs,
			dropped->s.origin, ent, CONTENTS_SOLID);
			VectorCopy (trace.endpos, dropped->s.origin);
		}
		else
		{
			AngleVectors (ent->s.angles, forward, right, NULL);
			VectorCopy (ent->s.origin, dropped->s.origin);
		}

		// JOSEPH 28-APR-99
		if (!(ent->svflags & SVF_PROP))
		{
			VectorScale (forward, 100, dropped->velocity);
			dropped->velocity[2] = 300;
		}
		else
		{
			dropped->s.origin[2] += 8;
			dropped->velocity[2] = 200;		
		}
		// END JOSEPH

		dropped->think = drop_make_touchable_briefcase;
		dropped->nextthink = level.time + 1;

		dropped->currentcash = ent->briefcase->currentcash;
		dropped->pickedup = ent->briefcase->pickedup;
		dropped->style = ent->briefcase->style;

		gi.linkentity (dropped);

		G_FreeEdict(ent->briefcase);
		ent->briefcase = NULL;
		ent->client->pers.bagcash = 0;
	}
}

// ....................................................................
// Briefcase Bag, used for Grab Da Loot and teamplay Cash-Match 

void briefcase_touch( edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t	*dropped;

	static float	last_touch_time;
	static edict_t	*last_touch_ent;
	static int		last_touch_count = 0;

	if (!other->client)
		return;
	//On the move, invisible
	if (!self->s.modelindex)
		return;
	//Do they already have a briefcase?
	if (other->briefcase)
		return;

	//game over don't let these move
	if (level.gamestatus == GAME_POLICEWON || level.gamestatus == GAME_ROBBERWON || level.gamestatus == GAME_TIE)
		return;

	if ((level.time < last_touch_time) || (last_touch_time && (last_touch_time < (level.time - 2.0))) || (last_touch_ent && (last_touch_ent != other)))
	{	// reset
		last_touch_time = 0;
		last_touch_ent = NULL;
		last_touch_count = 0;
	}
	else if (last_touch_time > (level.time - 0.1))
	{
		return;
	}
	else
	{
		last_touch_count++;
		last_touch_time = level.time;

		if (last_touch_count > (int)(50.0 * (1.0 + (0.5*(other->client->pers.team == self->style)))))
		{
			// let them go away on their own terms
			T_Damage( other, other, other, vec3_origin, other->s.origin, vec3_origin, 9999, 0, 0, MOD_SAFECAMPER );
			last_touch_count = 0;
		}
	}

	last_touch_ent = other;

	if (self->timestamp > (level.time - 1.0))
		return;

	self->timestamp = level.time;

	gi.sound(other, CHAN_ITEM, gi.soundindex("world/pickups/cash.wav"), 1, 3, 0);

	if (other->client->pers.team != self->style)
	{
		// alarm!
		gi.positioned_sound(self->s.origin, self, CHAN_ITEM, gi.soundindex("misc/cashmatch_alarm.wav"), 1, 1, 0);
		// let everyone know how much was stolen

		gi.bprintf( PRINT_MEDIUM, "%s stole $%i from %s's\n", other->client->pers.netname, self->currentcash, team_names[self->style] );

		last_safe_withdrawal[self->style] = level.time;

		if (!self->pickedup)
		{
			if (!last_man_standing->value)
				team_cash[other->client->pers.team] += self->currentcash / 10;

			other->client->pers.currentcash += self->currentcash;
			other->client->resp.deposited += self->currentcash / 10;
			self->pickedup = true;
		}
	}

	other->client->pers.bagcash += self->currentcash;

	dropped = G_Spawn();

	dropped->classname = self->classname;
	dropped->item = self->item;
	dropped->currentcash = self->currentcash;
	dropped->pickedup = self->pickedup;
	dropped->style = self->style;

	other->briefcase = dropped;
	self->s.modelindex = 0;
}

void briefcase_think (edict_t *self)
{
	if (level.gamestatus == GAME_POLICEWON || level.gamestatus == GAME_ROBBERWON || level.gamestatus == GAME_TIE)
	{
		if (!self->s.modelindex)
		{
			self->s.modelindex = gi.modelindex("models/pu_icon/money/money_sm.md2");
		}
		if (self->pickedup)
		{
			self->pickedup = 0;
		}
	}

	//Every 2 secs check game status
	self->nextthink = level.time + 2;
}

/*QUAKED dm_briefcase (0.5 0 1) (-12 -12 -16) (12 12 12)
Bag that holds the money in the safe.

  style - team that this bag belongs to (1 or 2)
*/
void SP_dm_briefcase( edict_t *self )
{
	if (!teamplay->value)
	{
		G_FreeEdict( self );
		return;
	}

	if (self->style < 1 || self->style > 2)
	{
		gi.dprintf( "dm_safebag has invalid \"style\" at %s, should be 1 or 2.\n", vtos(self->s.origin));
		G_FreeEdict( self );
		return;
	}

	if (self->style == 1)
	{
		level.m_iNumPoliceBriefcases++;
	}
	else if (self->style == 2)
	{
		level.m_iNumRobberBriefcases++;
	}

	self->s.modelindex = gi.modelindex("models/pu_icon/money/money_sm.md2");
	VectorSet( self->mins, -12, -12, -16 );
	VectorSet( self->maxs,  12,  12,  12 );

	self->movetype = MOVETYPE_NONE;
	self->solid = SOLID_TRIGGER;

	gi.linkentity( self );

	self->touch = briefcase_touch;

	self->think = briefcase_think;
	self->nextthink = level.time + 2;
}

// ....................................................................
// Briefcase Return, used for Grab Da Loot and teamplay Cash-Match 



/*QUAKED dm_briefcase (0.5 0 1) (-12 -12 -16) (12 12 12)
Bag that holds the money in the safe.

  style - team that this bag belongs to (1 or 2)
*/
extern void SP_cast_thug (edict_t *self);

void SP_dm_briefcase_return( edict_t *self )
{
	if (!teamplay->value)
	{
		G_FreeEdict( self );
		return;
	}

	if (self->style < 1 || self->style > 2)
	{
		gi.dprintf( "dm_briefcase_return has invalid \"style\" at %s, should be 1 or 2.\n", vtos(self->s.origin));
		G_FreeEdict( self );
		return;
	}

	SP_cast_thug(self);

	//+AS Old briefcase code
	/*
	self->s.modelindex = gi.modelindex("models/props/phone/tris.md2");
	VectorSet( self->mins, -12, -12, -16 );
	VectorSet( self->maxs,  12,  12,  12 );

	self->movetype = MOVETYPE_NONE;
	self->solid = SOLID_TRIGGER;

	gi.linkentity( self );

	self->touch = briefcase_return_touch;

	self->think = NULL;
	self->nextthink = level.time + 2;
	*/
}

void PrintAllCenter( char *string )
{
	int i;
	edict_t	*client;

	for (i=0 ; i<maxclients->value ; i++)
	{
		client = g_edicts + 1 + i;
		if (client->inuse)
			gi.centerprintf (client, string);
	}
}
