#include "g_local.h"
#if compileJACKBOT

  /*************************************************************************

		Find closest favorite gun available (if none is available, get next
		favorite gun, etc.)

	*************************************************************************/
	void findFavoriteGun(edict_t *bot)
		{
		int				i, j;
		int				weapIndex;
		//int				team;

		// Favorite weapon
		for (i = 0; i < MAX_WEAPONS; i++)
			{
			// Skip pipe
			if (bot->botInfo->def.rankOrder[i] == wPipe)
				continue;

			// Find a gun we like, but don't own yet
			weapIndex = botMisc_FindItemIndexByBotItemType(bot->botInfo->def.rankOrder[i]);
			if (bot->client->pers.inventory[weapIndex])
				continue;
			
			for (j = 0; j < jb_NumItems; j++)
				{
				// No entity
				if (!jb_ItemTable[j].ent)
					continue;
				// Not available
				if ((!jb_ItemTable[j].ent->think) || (jb_ItemTable[j].ent->solid == SOLID_NOT))
					continue;
				// Not in proper turf
				if (jb_ItemTable[j].turf && (jb_ItemTable[j].turf != bot->client->pers.team))
					continue;
				// Okay here one, get cost and weight

				}


			}

		}

	/************************************************************

		ToddlerGoal (things bots can safely reach)

	************************************************************/
	qboolean getToddlerGoal_BagmanMoney(edict_t *bot)
		{
		int			bestDist = BOTNODE_DIST_MAX;
		int			distTaxi;
		edict_t *ent;
		edict_t *bestEntity = NULL;

		// Get some valuables
		for (ent = g_edicts; ent < &g_edicts[globals.num_edicts]; ent++)
			{
			if (!ent->inuse)
				continue;
			if (ent->classname)
				{
				if (!Q_stricmp(ent->classname, "dm_safebag") && (ent->style == bot->client->pers.team))
					continue;
				if (!ent->currentcash)
					{
					if (Q_stricmp(ent->classname, "item_cashroll") && Q_stricmp(ent->classname, "item_cashbaglarge") && Q_stricmp(ent->classname, "item_cashbagsmall"))
						continue;
					}
				}
			if (abs(bot->s.origin[2] - ent->s.origin[2]) > 12)
				continue;
			distTaxi = VectorDistanceTaxicab(bot->s.origin, ent->s.origin);
			if (bestDist < distTaxi)
				continue;
			bestDist = distTaxi;
			bestEntity = ent;
			}

		if (bestEntity)
			{
			if (VectorDistance(bot->s.origin, bestEntity->s.origin) < 256)
				{
				bot->movetarget = bestEntity;
				return true;
				}
			}

		return false;
		}



	/************************************************************

		Set goal to the specified SafeBag

	************************************************************/
	void getObjective_BagmanGetToBase(edict_t *bot, int team, short int nodeCurrent)
		{
		int i;

		for (i = 0; i < jb_NumItems; i++)
			{
			if (!jb_ItemTable[i].ent)
				continue;
			if (jb_ItemTable[i].ent->style != team)
				continue;
			if (Q_stricmp(jb_ItemTable[i].ent->classname, "dm_safebag"))
				continue;
			bot->botInfo->state |= BOTSTATE_FOLLOWPATH;
			ACEND_SetGoal(bot, nodeCurrent, jb_ItemTable[i].node);
			}
		}

	/************************************************************

		Deposite money

	************************************************************/
	void getObjective_BagmanMoneyDeposite(edict_t *bot, signed int nodeCurrent, qboolean immediate)
		{
		int i;

		for (i = 0; i < jb_NumItems; i++)
			{
			if (!jb_ItemTable[i].ent)
				continue;
			if (jb_ItemTable[i].ent->style != bot->client->pers.team)
				continue;
			if (Q_stricmp(jb_ItemTable[i].ent->classname, "dm_safebag"))
				continue;
			if ((immediate) || (VectorDistance(bot->s.origin, jb_ItemTable[i].ent->s.origin) <= 512))
				{
				bot->botInfo->state		&= ~BOTSTATE_WEAPON_WAIT;
				bot->botInfo->state		|= BOTSTATE_FOLLOWPATH;
				bot->botInfo->taskNow	 = TASK_MONEY_DEPOSITE;
				ACEND_SetGoal(bot, nodeCurrent, jb_ItemTable[i].node);
				}
			break;
			}
		}

	/************************************************************

		HONEY BEE:
	    1. Always in driveby attack
	  	2. Get morale up (weapons, armor, health)
			3. Go to cash drop
	  	4. Collect cash
	  	5. Go back to base drop the loot

	************************************************************/
	qboolean getObjective_BagmanHoneyBee(edict_t *bot, short int nodeCurrent)
		{
		short int	bestNode		= BOTNODE_INVALID;
		qboolean	inCashSpawn = false;
		qboolean	isReady			= false;

		// ARE WE PREPARED? CHECK OVERALL STATE & AMMO //
		int armorHead, armorTorso, armorLegs;
		inventoryArmor(bot, &armorHead, &armorTorso, &armorLegs);
		if ((bot->health + armorHead + armorTorso + armorLegs) >= (bot->botInfo->def.preserve * 250))
			isReady = true;
		
		// NOT READY, DROP LOOT OR PILE UP STUFF //
		if (!isReady)
			{
			if (!(bot->client->pers.currentcash + bot->client->pers.bagcash))
				{
				getObjective_Deathmatch(bot, nodeCurrent);
				bot->botInfo->taskNow = TASK_GETREADY;
				}
			else
				getObjective_BagmanMoneyDeposite(bot, nodeCurrent, true);
			return true;
			}

		// Money to pickup nearby? //
		if (getToddlerGoal_BagmanMoney(bot))
			return true;

		// SEEK CASH //
		if ((bot->client->pers.currentcash + bot->client->pers.bagcash) < 75)
			{
			// FIND CASH SPAWN //
			bestNode = botMisc_FindClosestNode(bot->s.origin, -1, nCashSpawn);
			if (bestNode == BOTNODE_INVALID)
				return false;
			if ((VectorDistance(bot->s.origin, jb_Node[bestNode].origin) < 256) && (abs(bot->s.origin[2] - jb_Node[bestNode].origin[2]) <= 8))
				inCashSpawn = true;

			// WE'RE IN CASHSPAWN AREA AND READY//
			if (inCashSpawn)
				{
				bot->movetarget = NULL;
				bot->botInfo->state &= ~BOTSTATE_FOLLOWPATH;
				bot->botInfo->state |= BOTSTATE_WEAPON_WAIT;
				bot->botInfo->taskNow = TASK_MONEY_GET;
				return true;
				}
			
			// WE'RE NOT IN CASHSPAWN AREA //
			else
				{
				bot->botInfo->state |= BOTSTATE_FOLLOWPATH;
				ACEND_SetGoal(bot, nodeCurrent, bestNode);
				bot->botInfo->taskNow = TASK_MONEY_GET;
				return true;
				}
			}

		// ENOUGH CASH, BACK TO BASE! //
		else
			{
			getObjective_BagmanMoneyDeposite(bot, nodeCurrent, true);
			return true;
			}

		return false;
		}



	/************************************************************

		teamBalance

	************************************************************/
	int teamBalance(edict_t *bot)
		{
		int		i;
		float cntGuard = 0;
		float cntThief = 0;
		float cntHoneyBee = 0;
		float cntTotal = 0;

		for (i = 0; i < jb_NumPlayers; i++)
			{
			if (!jb_Player[i])
				break;
			if (!jb_Player[i]->botInfo)
				continue;
			if (jb_Player[i]->client->pers.team == bot->client->pers.team)
				{
				if (jb_Player[i]->botInfo->taskClass == BOTROLE_GUARD)
					cntGuard ++;
				else if (jb_Player[i]->botInfo->taskClass == BOTROLE_THIEF)
					cntThief ++;
				else if (jb_Player[i]->botInfo->taskClass == BOTROLE_HONEYBEE)
					cntHoneyBee ++;
				cntTotal ++;
				}
			}

		// So: you don't need guards if there's little to no money in the bank
		// You don't need thiefs if there's little to no money in the enemy's bank
		// You'll have to be a guard if you're not ready to dive into battle

		if (bot->client->pers.team == TEAM_1)
			i = TEAM_2;
		else
			i = TEAM_1;

		/*if ((cntGuard / cntTotal) < .3)
			return BOTROLE_GUARD;*/
		if (((cntThief / cntTotal) < .5) && (team_cash[i] >= 150))
			return BOTROLE_THIEF;
		return BOTROLE_HONEYBEE;
		}



	/************************************************************

		GUARD:
	  	1. Always in active attack
	  	2. Get morale up (weapons, armor, health)
	  	3. Stay nearby the safe

	************************************************************/
	qboolean getObjective_BagmanGuard(edict_t *bot, short int nodeCurrent)
		{
		bot->botInfo->taskNow = TASK_NONE;
		return true;
		}



	/************************************************************

		THIEF:
	  	1. Always in driveby attack
	  	2. Get morale up (weapons, armor, health)
	  	3. Go to enemy's safe
	    4. Go back to base drop the loot

	************************************************************/
	qboolean getObjective_BagmanThief(edict_t *bot, short int nodeCurrent)
		{
		short int	bestNode = BOTNODE_INVALID;
		qboolean	isReady = false;

		// ARE WE PREPARED? CHECK OVERALL STATE & AMMO //
		int armorHead, armorTorso, armorLegs;
		inventoryArmor(bot, &armorHead, &armorTorso, &armorLegs);
		if ((bot->health + armorHead + armorTorso + armorLegs) >= (bot->botInfo->def.preserve * 250))
			isReady = true;
		
		// GET READY //
		if ((isReady == false) && (getEntityTerritory(bot) == bot->client->pers.team))
			{
			getObjective_Deathmatch(bot, nodeCurrent);
			bot->botInfo->taskNow = TASK_GETREADY;
			return true;
			}

		// GO CAPTURE MONEY //
		if (bot->botInfo->taskNow != TASK_MONEY_CAPTURE)
			{
			if (bot->client->pers.team == TEAM_1)
				getObjective_BagmanGetToBase(bot, TEAM_2, nodeCurrent);
			else
				getObjective_BagmanGetToBase(bot, TEAM_1, nodeCurrent);
			bot->botInfo->taskNow = TASK_MONEY_CAPTURE;
			return true;
			}
		
		// GO BACK TO BASE //
		getObjective_BagmanMoneyDeposite(bot, nodeCurrent, true);
		return true;
		}



	/**********************************************************************

		Return territory <ent> is standing in: 0 for none (deathmatch),
		1 for Dragon, and 2 for Poison.

	**********************************************************************/
	int getEntityTerritory(edict_t *ent)
		{
		if (teamplay->value && (teamplay_mode == TM_GRABDALOOT))
			{
			if (VectorSide2D(ent->s.origin, jb_TeamBorder1, jb_TeamBorder2) > 0)
				return TEAM_2;
			return TEAM_1;
			}
		return 0;
		}

	



	/**********************************************************************

		Split territory in two for Bagman games

	**********************************************************************/
	void BagmanSplitTerritory()
		{
		float		cnt[2] = {0, 0};
		vec3_t	bag[2] = {{0, 0, 0}, {0, 0, 0}};
		float		angle;
		edict_t	*ent;

		// Find bags for both team
		for (ent = g_edicts; ent < &g_edicts[globals.num_edicts]; ent++)
			{
			if (!ent->classname)
				continue;
			if (Q_stricmp(ent->classname, "dm_safebag"))
				continue;
			if ((ent->style != 1) && (ent->style != 2))
				continue;
			bag[ent->style - 1][0] += ent->s.origin[0];
			bag[ent->style - 1][1] += ent->s.origin[1];
			cnt[ent->style - 1]++;
			}

		// Check
		if ((cnt[0] != cnt[1]) || (!cnt[0]) || (!cnt[1]))
			gi.dprintf("BagmanSplitTerritory: Failed to find turfs for Bagman! Team1: %i bag(s), team2: %i bag(s)\n", cnt[0], cnt[1]);

		// Get average of both teams
		bag[0][0] = bag[0][0] / cnt[0];
		bag[0][1] = bag[0][1] / cnt[0];
		bag[1][0] = bag[1][0] / cnt[1];
		bag[1][1] = bag[1][1] / cnt[1];

		// Create invisible line, standing between both "average bag", cutting the map in half
		angle = atan2(bag[0][1] - bag[1][1], bag[0][0] - bag[1][0]) + (M_PI * 0.5);
		jb_TeamBorder1[0] = (bag[0][0] + bag[1][0]) / 2;
		jb_TeamBorder1[1] = (bag[0][1] + bag[1][1]) / 2;
		jb_TeamBorder2[0] = jb_TeamBorder1[0] + (cos(angle) * 128);
		jb_TeamBorder2[1] = jb_TeamBorder1[1] + (sin(angle) * 128);
		}


#endif