#include "g_local.h"

#if compileJACKBOT
  
	// Short hand to botDef_t's members
  #define	BOFS(x) (int)&(((botDef_t *)0)->x)

	// Global variables, see b_local.h
  edict_t				*jb_Player[MAX_CLIENTS];
	botinfo_t			jb_BotInfo[MAX_CLIENTS];

  botnode_t			jb_Node[BOTNODE_MAX]; 
	itemLink_t		jb_ItemTable[MAX_EDICTS];
  short int			jb_PathTable[BOTNODE_MAX][BOTNODE_MAX];
	nodePair_t		jb_JumpTable[BOTNODE_MAX];
	nodePair_t		jb_DuckTable[BOTNODE_MAX];
	nodePair2_t		jb_LinkTable[BOTNODE_MAX];
//short int			jb_PathTableRocket[BOTNODE_MAX][BOTNODE_MAX];	// Node linking with rocket jump enabled 
	int						jb_NumJumps				= 0;
	int						jb_NumDucks				= 0;
	int						jb_NumLinks				= 0;
  int						jb_NumNodes				= 0;
	int						jb_NumItems				= 0;
  int						jb_NumPlayers			= 0;
	short int			jb_NumRevs				= 0;				// route revision number
  int						jb_Debug					= 0x00;
  short int			jb_ShowPathFrom		= BOTNODE_INVALID;
  short int			jb_ShowPathTo			= BOTNODE_INVALID;
	qboolean			jb_NewMap					= false;
	short int			jb_BotVersion			=	1;				// bot version
	float					jb_AutoSave				= 0;

	#if (compileTEST)
	byte								*jb_StringBank = NULL;										// Global string bank
	unsigned short int	jb_StringBankSize = 0;										// Global string bank size
	#endif

	vec3_t				jb_TeamBorder1;
	vec3_t				jb_TeamBorder2;

	vec3_t				jb_NodeArea1;
	vec3_t				jb_NodeArea2;

	field_t				jb_Script[] =
		{
		{"Bot characteristics", 0, F_IGNORE},
		#if (compileTEST)
		{"BOT_NAME",								BOFS(ofsName),												F_STRBANK},	// Bot name
		{"BOT_MODEL_SKIN",					BOFS(ofsSkin),												F_STRBANK},	// Bot model
		{"BOT_MODEL_SKIN_TEAM1",		BOFS(ofsSkinTeam1),										F_STRBANK},	// Bot model (Dragon)
		{"BOT_MODEL_SKIN_TEAM2",		BOFS(ofsSkinTeam2),										F_STRBANK},	// Bot model (Poison)
		{"BOT_MODEL_EXTRA",					BOFS(ofsExtras),											F_STRBANK},	// Bot model extras
		{"BOT_HANDEDNESS",					BOFS(ofsHand),												F_BOTHAND},	// Bot handedness (right, left or center)
		#else
		{"BOT_NAME",								BOFS(name),														F_LSTRING},	// Bot name
		{"BOT_MODEL_SKIN",					BOFS(skin),														F_LSTRING},	// Bot model
		{"BOT_MODEL_SKIN_TEAM1",		BOFS(skinteam1),											F_LSTRING},	// Bot model
		{"BOT_MODEL_SKIN_TEAM2",		BOFS(skinteam2),											F_LSTRING},	// Bot model
		{"BOT_MODEL_EXTRA",					BOFS(extras),													F_LSTRING},	// Bot model extras
		{"BOT_HANDEDNESS",					BOFS(hand),														F_BOTHAND},	// Bot handedness (right, left or center)
		#endif
		{"BOT_CHATTER",							BOFS(chatter),												F_PERCENT},	// How likely the bot is to send a message
		{"BOT_FIELD_OF_VIEW",				BOFS(viewangle),											F_ANGLE},		// Cone of vision, in degrees
		{"BOT_VIEW_DISTANCE",				BOFS(viewdistance), 									F_INT},			// How far the bot can see

		{"Bot skills", 0, F_IGNORE},
		{"SKILL_DODGE",							BOFS(dodge),													F_PERCENT}, // How good the bot is at dodging things
		{"SKILL_JITTERY",						BOFS(jittery),												F_PERCENT},	// How likely the bot is to change dodging direction
		{"SKILL_JUMPER",						BOFS(jumper),													F_PERCENT}, // How likely the bot is to bunny hop
		{"SKILL_CROUCHER",					BOFS(croucher),												F_PERCENT}, // How likely the bot is to crouch
		{"SKILL_ACCURACY",					BOFS(accuracy),												F_PERCENT},	// How accurate/jitty aiming is
		{"SKILL_RELOADER",					BOFS(reloader),												F_PERCENT},	// TODO: weapon swapping maniac
		{"SKILL_NAVIGATION",				BOFS(navigation),											F_PERCENT},	// How good the bot is at moving around
		{"SKILL_SPATIAL_AWARENESS",	BOFS(spaceaware),											F_PERCENT},	// How good the bot is at estimating distances
		{"SKILL_SELF_PRESERVATION",	BOFS(preserve),												F_PERCENT},	// How careful the bot is about its health (+ crave for defense items)
		{"SKILL_CAMPER",						BOFS(camper),													F_PERCENT},	// TODO: camp for good stuff
		{"SKILL_REACTION_TIME",			BOFS(reactiontime),										F_FLOAT},		// How long the bot takes to react to something
		

		{"Weapons preferences", 0, F_IGNORE},
		{"W_PIPE",			  					BOFS(rankWeight[wPipe]),			  			F_PERCENT},
		{"W_CROWBAR",								BOFS(rankWeight[wCrowbar]),			  		F_PERCENT},
		{"W_PISTOL",								BOFS(rankWeight[wPistol]),			  		F_PERCENT},
		{"W_SHOTGUN",								BOFS(rankWeight[wShotgun]),			  		F_PERCENT},
		{"W_TOMMYGUN",			  			BOFS(rankWeight[wTommyGun]),					F_PERCENT},
		{"W_HMG",										BOFS(rankWeight[wHeavyMachineGun]),		F_PERCENT},
		{"W_GRENADELAUNCHER",				BOFS(rankWeight[wGrenadeLauncher]),		F_PERCENT},
		{"W_ROCKETLAUNCHER",				BOFS(rankWeight[wRocketLauncher]),		F_PERCENT},
		{"W_FLAMETHROWER",					BOFS(rankWeight[wFlamethrower]),			F_PERCENT},

		{"Chat messages", 0, F_IGNORE},
		#if (compileTEST)
		{"C_GAMEOVER_SMUG",					BOFS(ofsChatGameoverSmug),				  	F_STRBANK},
		{"C_GAMEOVER_ANGRY",				BOFS(ofsChatGameoverAngry),				  	F_STRBANK},
		{"C_GAMEOVER",     					BOFS(ofsChatGameover),							  F_STRBANK},
		{"C_BAGMAN_SPOTTED",     		BOFS(ofsChatBagmanSpotted),				  	F_STRBANK},
		{"C_JOINGAME",			    		BOFS(ofsChatGamejoin),							  F_STRBANK},
		{"C_RESPAWN", 			    		BOFS(ofsChatRespawn),					  			F_STRBANK},
		#else
		{"C_GAMEOVER_SMUG",					BOFS(c_gameover_smug),				  			F_LSTRING},
		{"C_GAMEOVER_ANGRY",				BOFS(c_gameover_angry),				  			F_LSTRING},
		{"C_GAMEOVER",     					BOFS(c_gameover),							  			F_LSTRING},
		{"C_BAGMAN_SPOTTED",     		BOFS(c_bagman_spotted),				  			F_LSTRING},
		{"C_JOINGAME",			    		BOFS(c_gamejoin),							  			F_LSTRING},
		{"C_RESPAWN", 			    		BOFS(c_respawn),							  			F_LSTRING},
		#endif

		{"AI special flags", 0, F_IGNORE},
		{"AI_HOLSTER",							BOFS(flags),													F_BOTFLAG,	BOTFLAG_HOLSTER},
		{"AI_SLAVE", 								BOFS(flags),													F_BOTFLAG,	BOTFLAG_SLAVE},
		{"AI_NOREACTION",						BOFS(flags),		  										F_BOTFLAG,	BOTFLAG_NOREACTION},
		{"AI_THINK",    						BOFS(flags),		  										F_BOTFLAG,	BOTFLAG_THINK},

		{NULL}
		};

	nodeType_t	jb_NodeType[] =
		{
		// Name						Skin	Code					Linker	KrazeCode
		{"ndAny",     	  0,		nAll,					false,	99},
		{"ndMove",			  1,		nMove,				false,	0},
		{"ndItem",    	  2,		nItem,				true,		4},
		{"ndLadder",		  3,		nLadder,			false,	1},
		{"ndElevator",	  4,		nElevator,		true,		2},
		{"ndWater",   	  5,		nWater,				false,	5},
		{"ndTeleporter",  6,		nTeleporter,	true,		3},
		{"ndAirfall",			7,		nAirFall, 		false,	9},
		{"ndAirjump",			8,		nAirJump, 		false,	9},
		{"ndCashspawn",		9,		nCashSpawn,		false,	9},

		{NULL}
		};

	cvar_t				*bot_nodeviewdist;
	cvar_t				*bot_nodeviewfade;
	cvar_t				*bot_nodeviewupdate;
	cvar_t				*bot_nodeviewtest;
	cvar_t				*bot_nodetrail;
	cvar_t				*bot_nodeviewlinks;
	cvar_t				*bot_nodeshrink;
	cvar_t				*bot_nodesound;
	cvar_t				*bot_nodeautosave;

	cvar_t				*bot_mute;

	int jb_NumNodeTypes = sizeof(jb_NodeType) / sizeof(jb_NodeType[0]) - 1; // Minus 1 because of terminating NULL

#endif