#include "g_local.h"
#if compileJACKBOT

	qboolean move_ElevatorEnter(edict_t *self, float dist)
		{
		int			i;
		edict_t *ent;

		// If we're already on an elevator, or we're not going toward an elevator, bail
		if ((jb_Node[self->botInfo->nodeCurrent].type->value == nElevator) || (jb_Node[self->botInfo->nodeNext].type->value != nElevator))
			return false;
		
		// Stop waiting, start following path again
		if (self->botInfo->state & BOTSTATE_ELEVATOR_WAIT)
			self->botInfo->state &= ~BOTSTATE_ELEVATOR_WAIT;
		if (!(self->botInfo->state & BOTSTATE_FOLLOWPATH))
			self->botInfo->state |= BOTSTATE_FOLLOWPATH;

		// GET PLAT ENTITY //
		for (i = 0; i < jb_NumItems; i++)
			{
			if (jb_ItemTable[i].node != self->botInfo->nodeNext)
				continue;
			ent = jb_ItemTable[i].ent;
			break;
			}

		// ON THE PLATFORM //
		if (self->groundentity == ent)
			{
			botprint(self, "is on the platform...\n");
			bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch);
			self->botInfo->ucmd.forwardmove = BOTSPEED_RUN;
			self->botInfo->state |= BOTSTATE_FOLLOWPATH;
			self->botInfo->state &= ~BOTSTATE_ELEVATOR_WAIT;
			move_CheckpointReached(self);
			return true;
			}
		
		// NOT ON THE PLATFORM //
		botprint(self, "elevator state: %i\n", ent->moveinfo.state);
		// If the platform isn't there, wait for it, make sure we're not hugging it
		if ((ent->moveinfo.state != STATE_BOTTOM) && ((abs(ent->moveinfo.start_origin[2] - ent->moveinfo.end_origin[2]) - ent->moveinfo.remaining_distance) > 8))
			{
			if (self->groundentity)
				botprint(self, "ground entity: %s\n", self->groundentity->classname);
			botprint(self, "waiting for elevator to show up\n");
			self->botInfo->state &= ~BOTSTATE_FOLLOWPATH;
			self->botInfo->state |= BOTSTATE_ELEVATOR_WAIT;
			if ((self->s.origin[0] >= ent->mins[0] - 8) && (self->s.origin[0] <= ent->maxs[0]) + 8)
				if ((self->s.origin[1] >= ent->mins[1] - 8) && (self->s.origin[1] <= ent->maxs[1]) + 8)
					self->botInfo->ucmd.forwardmove = -BOTSPEED_WALK;
			}
		// The platform is there, run toward next node
		else
			{
			self->botInfo->ucmd.forwardmove = BOTSPEED_RUN;
			self->botInfo->state |= BOTSTATE_FOLLOWPATH;
			self->botInfo->state &= ~BOTSTATE_ELEVATOR_WAIT;
			bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch);
			}
		return true;
		}

	qboolean move_ElevatorRide(edict_t *self, float dist)
		{
		float			x;
		float			y;
		float			distH;
		short int outNode;

		// Not riding an elevator
		if ((jb_Node[self->botInfo->nodeCurrent].type->value != nElevator) || (jb_Node[self->botInfo->nodeNext].type->value != nElevator))
			return false;

		// Same level, go to next node!
		if (abs(self->s.origin[2] - jb_Node[self->botInfo->nodeNext].origin[2]) <= 8)
			{
			botprint(self, "reached destination\n");
			self->botInfo->state &= ~BOTSTATE_ELEVATOR_RIDE;
			self->botInfo->state &= ~BOTSTATE_ELEVATOR_WAIT;
			move_CheckpointReached(self);
			bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch);
			self->botInfo->ucmd.forwardmove = BOTSPEED_RUN;
			return true;
			}

		// The elevator is still traveling, do something on the platform
		self->botInfo->state |= BOTSTATE_ELEVATOR_RIDE;
		botprint(self, "waiting to elevator tune\n");
		x = self->s.origin[0] - jb_Node[self->botInfo->nodeNext].origin[0];
		y = self->s.origin[1] - jb_Node[self->botInfo->nodeNext].origin[1];
		distH = sqrt((x * x) + (y * y));

		// If we're not close enough, walk toward node
		if (distH > 16)
			{
			if (distH > 48)
				self->botInfo->ucmd.forwardmove = BOTSPEED_RUN;
			else
				self->botInfo->ucmd.forwardmove = BOTSPEED_WALK;
			bot_LookAt(self, jb_Node[self->botInfo->nodeNext].origin, doAimYaw | doAimPitch);
			}

		// Face the exit
		else
			{
			outNode = jb_PathTable[self->botInfo->nodeNext][self->botInfo->nodeGoal];
			if (outNode != BOTNODE_INVALID)
				bot_LookAt(self, jb_Node[outNode].origin, doAimYaw | doAimPitch);
			}
		return true;
		}

#endif
