	// Misc functions
	FILE								*fs_fileOpen(char *filename, char *mode);
	qboolean						fs_readLine(FILE *pIn, char *strSrc);
	qboolean						fs_splitLine(char *src, char *key, char *value);
	
	// Load/save bot lists
	void								fs_saveBotList();
	void								fs_loadBotList();
	
	// Load/save bot scripts
	void								fs_saveBotScript(char *name);
	void								fs_loadBotScript(char *name, int team);

	// Load/save routes
	void								fs_saveNodes(qboolean quicksave);
	void    						fs_loadNodes();
	qboolean						fs_loadNodesKraze();

	// String bank management
	unsigned short int	fs_stringBankOffset(byte *strBuffer, unsigned int strLength, char *msg);
	unsigned short int	fs_stringBankAppend(byte **strBuffer, unsigned short int *strLength, char *msg);
	void								fs_stringBankSetup(byte **strBuffer, unsigned short int *strLength, qboolean start);
	void								fs_stringBankDestroy(byte **strBuffer, unsigned short int *strLength);

	// Chunk management
	fs_Chunk_t					fs_ChunkSetup(char *label, byte **strBuffer, unsigned short int *strLength, qboolean quicksave);
	void								fs_ChunkApply(fs_Chunk_t chunk, byte *strBuffer, unsigned short int strLength);
	void								fs_ChunkDestroy(fs_Chunk_t chunk);
	