#include "g_local.h"
#if compileJACKBOT


	#define WR_FORWARD		  0
	#define WR_IMMEDIATE	 64
	#define WR_BYTE				128
	#define WR_WORD				192


	/*********************************************************
	
		Word Repeat: get required size for decompression buffer
	
	*********************************************************/
	void wr_Checksum(byte *iccBuffer, unsigned short int iccLength, unsigned int *shrinkLength, unsigned int *expandLength)
		{
		int i, mode, count, ex = 0, sh = 0;

		if (iccLength && iccBuffer)
			{
			for (i = 0; i < iccLength; i++)
				{
				mode  = (iccBuffer[i] >> 6);
				count = (iccBuffer[i] & 0x3F);
				// read forward (need stuff in source)
				ex += count;
				if (mode == (WR_FORWARD >> 6))
					sh += count;
				// read backward (immediate)
				else if (mode == (WR_IMMEDIATE >> 6))
					{ }
				// read backward (small jump - byte)
				else if (mode == (WR_BYTE >> 6))
					i += 1;
				// read backward (big jump - unsigned short)
				else if (mode == (WR_WORD >> 6))
					i += 2;
				}
			}
		(*shrinkLength) = (sh * sizeof(short)); // Size of compressed buffer, in bytes
		(*expandLength) = (ex * sizeof(short)); // Size of decompressed buffer, in bytes
		}



	/*********************************************************
	
		Word Repeat: expand compressed buffer
	
	*********************************************************/
	qboolean wr_Expand(short **datBuffer, unsigned int *datLength, byte **iccBuffer, unsigned int *iccLength)
		{
		unsigned int	shrinkLength;
		unsigned int	expandLength;
		short					*tmpBuffer;
		int						tmpOffset = 0, datOffset = 0;
		int						i, j, o, w, mode;

		// CHECKSUM //
		wr_Checksum(*iccBuffer, *iccLength, &shrinkLength, &expandLength);
		if (shrinkLength != (*datLength))
			{
			gi.dprintf("wr_Expand: Expected %i bytes of data, received %i!\n", shrinkLength, *datLength);
			return true;
			}

		// INITIALIZE DECOMPRESSED BUFFER //
		tmpBuffer = (short *)malloc(expandLength);
		if (!tmpBuffer)
			{
			gi.dprintf("wr_Expand: Failed to allocate %i bytes of memory!\n", expandLength);
			return true;
			}
		memset(tmpBuffer, 0x00, expandLength);

		// EXPAND //
		for (i = 0; i < (*iccLength); i++)
			{
			mode = (((*iccBuffer)[i]) >> 6);
			w    = ((*iccBuffer)[i] & 0x3F);
			// WRITE
			if (mode == (WR_FORWARD >> 6))
				{
				for (j = 0; j < w; j++)
					{
					tmpBuffer[tmpOffset] = (*datBuffer)[datOffset];
					tmpOffset ++; datOffset++;
					}
				}
			// COPY
			else
				{
				if (mode == (WR_IMMEDIATE >> 6))
					o = w;
				else if (mode == (WR_BYTE >> 6))
					{
					o = (*iccBuffer)[i + 1] + w;
					i += 1;
					}
				else if (mode == (WR_WORD >> 6))
					{
					o = (*iccBuffer)[i + 1] + ((int)((*iccBuffer)[i + 2]) << 8) + w;
					i += 2;
					}
				for (j = 0; j < w; j++)
					{
					tmpBuffer[tmpOffset] = tmpBuffer[tmpOffset - o];
					tmpOffset ++;
					}
				}
			}

		// SWAP BUFFER //
		free(*datBuffer);						// Kill source buffer
		*datBuffer = tmpBuffer;			// Replace with compressed buffer
		*datLength = expandLength;	// Replace length
		return false;
		}



	/*********************************************************
	
		Word Repeat: shrink source buffer
	
	*********************************************************/
	void wr_Shrink(short **datBuffer, unsigned int *datLength, byte **iccBuffer, unsigned int *iccLength)
		{
		short		*tmpBuffer;
		int			symbolCount;
		int			tmpLength = 0, totalCount = 0;
		int			count, bestCount, bestOfst, cost, bestCost;
		int			i, j, min = 0, delta, k = WR_FORWARD;

		// INITIALIZE COMPRESSED BUFFER //
		tmpBuffer = (short *)malloc(*datLength);
		if (!tmpBuffer)
			gi.dprintf("wr_Shrink: Failed to allocate %i bytes of memory!\n", (int)(*datLength));

		memset(tmpBuffer, 0x00, *datLength);

		// INITIALIZE INSTRUCTION BUFFER //
		if (*iccBuffer)
			free(*iccBuffer);
		*iccBuffer = (byte *)malloc(*datLength);
		if (!(*iccBuffer))
			gi.dprintf("path_LinkCheckUp: Failed to allocate %i bytes of memory!\n", (int)(*datLength));
		memset(*iccBuffer, 0x00, *datLength);
		*iccLength = 0;

		symbolCount = ((*datLength) / 2);

		// CHECK FOR PREVIOUSLY WRITTEN WORDS //
		for (i = 0; i < symbolCount; i++)
			{
			bestCount = 0;
			if (i)
				{
				bestCost = 3;
				min = (i - 65535);
				if (min < 0)
					min = 0;
				for (j = min; j < i; j++)
					{
					if (((*datBuffer)[j]) != ((*datBuffer)[i]))
						continue;
					count = 0;
					// The bug HAS TO BE somewhere around here (it reads out of boundaries).
					while (true)
						{
						if (((j + count) >= i) || (count >= 63) || (j + count >= symbolCount) || (i + count >= symbolCount))
							break;
						if ((*datBuffer)[j + count] != ((*datBuffer)[i + count]))
							break;
						count ++;
						}
					if (count)
						{
						if ((i - (j + count)) == 0)
							cost = 1 - (2 * count);
						else if ((i - (j + count)) < 256)
							cost = 2 - (2 * count);
						else if ((i - (j + count)) < 65536)
							cost = 3 - (2 * count);
						if (cost <= bestCost)
							{
							bestCost  = cost;
							bestCount = count;
							bestOfst  = j;
							}
						}
					}
				}
			// READ BACKWARD //
			if (bestCount > 0)
				{
				totalCount += (bestCount * 2);
				if (totalCount > (*datLength))
					{
					gi.dprintf("**WARNING** said it found %i symbols, that's %i too many!\n", bestCount, ((totalCount - (*datLength)) / 2));
					bestCount -= (totalCount - (*datLength)) / 2;
					}
				// Get fresh instruction
				if (k == WR_FORWARD)
					(*iccLength) += 1;
				// Immediate
				delta = (i - (bestOfst + bestCount));
				if (delta == 0)
					{
					(*iccBuffer)[*iccLength] = (WR_IMMEDIATE | bestCount);	(*iccLength) += 1;
					k = WR_IMMEDIATE;
					}
				else if (delta < 256)
					{
					(*iccBuffer)[*iccLength] = (WR_BYTE | bestCount);	(*iccLength) += 1;
					(*iccBuffer)[*iccLength] = (delta);								(*iccLength) += 1;
					k = WR_BYTE;
					}
				else if (delta < 65536)
					{
					(*iccBuffer)[*iccLength] = (WR_WORD | bestCount);	(*iccLength) += 1;
					(*iccBuffer)[*iccLength] = (delta & 0xFF);				(*iccLength) += 1;
					(*iccBuffer)[*iccLength] = ((delta >> 8) & 0xFF);	(*iccLength) += 1;
					k = WR_WORD;
					}
				i += (bestCount - 1); // minus one, because <i> will be increase by one at the end of the loop
				}
			// READ FORWARD //
			else
				{
				totalCount += 2;
				// Current instruction maxed out
				if ((*iccBuffer)[*iccLength] == 63)
					(*iccLength) += 1;
				// One more word to read forward
				(*iccBuffer)[*iccLength] += 1;
				tmpBuffer[tmpLength] = (*datBuffer)[i];
				tmpLength ++;
				k = WR_FORWARD;
				}
			}
		// Complete last instruction
		if (k == WR_FORWARD)
			(*iccLength) += 1;

		// RETURN //
		if ((((tmpLength * 2) + (*iccLength))) >= (*datLength))
			{
			free(tmpBuffer);  // Kill temporary buffer
			free(*iccBuffer); // Kill instruction buffer
			*iccBuffer = 0;
			*iccLength = 0;
			}
		else
			{
			free(*datBuffer);							// Kill source buffer
			*datBuffer = tmpBuffer;				// Replace with compressed buffer
			*datLength = (tmpLength * 2); // Replace length
			}
		}




	/*****************************************************************

		Shrink <datBuffer> using RLE-W, if the gain is negative (size
		of compressed buffer + size of ICC is bigger than source size),
		flush the result of the compression. Warning: datLength and
		iccLength are the length of each buffer expressed in BYTES,
		not in WORDS.

	*****************************************************************/
	void rle_Shrink(short **datBuffer, unsigned int *datLength, byte **iccBuffer, unsigned int *iccLength)
		{
		short	*tmpBuffer;
		int		tmpLength = 0;
		int		datOffset = 0;

		int		streak;
		short	streakRef;

		// INITIALIZE COMPRESSED BUFFER //
		tmpBuffer = (short *)malloc(*datLength);
		if (!tmpBuffer)
			gi.dprintf("path_LinkCheckUp: Failed to allocate %i bytes of memory!\n", (int)(*datLength));
		memset(tmpBuffer, 0x00, *datLength);

		// INITIALIZE INSTRUCTION BUFFER //
		if (*iccBuffer)
			free(*iccBuffer);
		*iccBuffer = (byte *)malloc(*datLength);
		if (!(*iccBuffer))
			gi.dprintf("path_LinkCheckUp: Failed to allocate %i bytes of memory!\n", (int)(*datLength));
		memset(*iccBuffer, 0x00, *datLength);
		*iccLength = 0;

		// SHRINK //
		do
			{
			// COUNT IDENTICAL CONSECUTIVE WORDS (MAX 127) //
			streak = 0;
			do
				{
				streak++;
				streakRef = (*datBuffer)[datOffset];
				datOffset++;
				if (datOffset == ((*datLength) / sizeof(short)))
					break;
				} while ((streak < 127) && (streakRef == (*datBuffer)[datOffset]));

			// NON-RLE //
			if (streak == 1)
				{
				if (*iccLength == 0)
					{
					(*iccBuffer)[*iccLength] = 0;
					(*iccLength) += 1;
					}
				else
					{
					// Last post is maxed out, or was RLE
					if (((*iccBuffer)[(*iccLength) - 1] & 0x80) || (((*iccBuffer)[(*iccLength) - 1] & 0x7F) == 127))
						{
						(*iccBuffer)[*iccLength] = 0;
						(*iccLength) += 1;
						}
					}
				// Adding one symbol to current post, adding symbol to table
				(*iccBuffer)[*iccLength - 1]++;
				tmpBuffer[tmpLength] = streakRef;
				tmpLength++;
				}
			// RLE //
			else
				{
				// Creating a whole post, adding symbol to table
				(*iccLength) += 1;
				(*iccBuffer)[(*iccLength) - 1] = (0x80 + (streak & 0x7F));
				tmpBuffer[tmpLength] = streakRef;
				tmpLength++;
				}
			} while (datOffset != ((*datLength) / sizeof(short)));

		// RETURN //
		if ((((tmpLength * 2) + (*iccLength))) >= (*datLength))
			{
			free(tmpBuffer);  // Kill temporary buffer
			free(*iccBuffer); // Kill instruction buffer
			*iccBuffer = 0;
			*iccLength = 0;
			}
		else
			{
			free(*datBuffer);							// Kill source buffer
			*datBuffer = tmpBuffer;				// Replace with compressed buffer
			*datLength = (tmpLength * 2); // Replace length
			}
		}



	
	/*****************************************************************

		Expand buffer using RLE; replaces <datBuffer> and <datLength>,
		doesn't trash iccBuffer, doesn't touch iccLength. Will return
		TRUE if something went wrong, FALSE otherwise

	*****************************************************************/
	qboolean rle_Expand(short **datBuffer, unsigned int *datLength, byte **iccBuffer, unsigned int *iccLength)
		{
		unsigned int	shrinkLength;
		unsigned int	expandLength;
		short					*tmpBuffer;
		int						tmpOffset = 0, datOffset = 0;
		int						i, j, mode, streak;

		// CHECKSUM //
		rle_Checksum(*iccBuffer, *iccLength, &shrinkLength, &expandLength);
		if (shrinkLength != (*datLength))
			{
			gi.dprintf("rle_Expand: Expected %i bytes of data, received %i!\n", shrinkLength, *datLength);
			return true;
			}

		// INITIALIZE DECOMPRESSED BUFFER //
		tmpBuffer = (short *)malloc(expandLength);
		if (!tmpBuffer)
			{
			gi.dprintf("rle_Expand: Failed to allocate %i bytes of memory!\n", expandLength);
			return true;
			}
		memset(tmpBuffer, 0x00, expandLength);

		// EXPAND //
		for (i = 0; i < (*iccLength); i++)
			{
			mode   = (*iccBuffer)[i] & 0x80;
			streak = (*iccBuffer)[i] & 0x7F;
			// RLE
			if (mode)
				{
				for (j = 0; j < streak; j++)
					{
					tmpBuffer[tmpOffset] = (*datBuffer)[datOffset];
					tmpOffset ++;
					}
				datOffset++;
				}
			// NON-RLE
			else
				{
				for (j = 0; j < streak; j++)
					{
					tmpBuffer[tmpOffset] = (*datBuffer)[datOffset];
					tmpOffset ++;
					datOffset ++;
					}
				}
			}

		// SWAP BUFFER //
		free(*datBuffer);						// Kill source buffer
		*datBuffer = tmpBuffer;			// Replace with compressed buffer
		*datLength = expandLength;	// Replace length
		return false;
		}



	/*****************************************************************

		Based on the Instruction for Compressed Chunk stream, return
		the length in bytes of both the compressed buffer and the
		decompressed buffer (should be called before expanding data
		to ensure the file is not corrupted).

	*****************************************************************/
	void rle_Checksum(byte *iccBuffer, unsigned short int iccLength, unsigned int *shrinkLength, unsigned int *expandLength)
		{
		int i, ex = 0, sh = 0;

		if (iccLength && iccBuffer)
			{
			for (i = 0; i < iccLength; i++)
				{
				if (iccBuffer[i] & 0x80)
					sh += 1;											// Compressed buffer stores one word
				else
					sh += (iccBuffer[i] & 0x7F);	// Compressed buffer stores multiple words
				ex += (iccBuffer[i] & 0x7F);		// Target buffer will expand to multiple words
				}
			}

		(*shrinkLength) = sh * sizeof(short); // Size of compressed buffer, in bytes
		(*expandLength) = ex * sizeof(short); // Size of decompressed buffer, in bytes
		}

#endif