#include "g_local.h"
#if compileJACKBOT



	/******************************************************************************

	   Server command processor (this function is hooked into g_svcmds.c)

	******************************************************************************/
	qboolean botCmd_ServerCommands(void)
		{
		char	*cmd;

		cmd = gi.argv(1);

		// DEBUG COMMAND: modify routes
		if (!Q_stricmp(cmd, "editroute"))
			{
			jb_Debug ^= BOTDEBUG_ROUTE;
			gi.dprintf("Route edition mode %s.\n", (jb_Debug & BOTDEBUG_ROUTE)?"enabled":"disabled");
			DummyNode_RemoveAll(); // Always remove 
			if (jb_Debug & BOTDEBUG_ROUTE)
				DummyNode_SpawnAll();
			return true;
			}

		// DEBUG COMMAND: save verbose to log
		else if (!Q_stricmp(cmd, "debuglog"))
			{
			jb_Debug ^= BOTDEBUG_LOGFILE;
			gi.dprintf("Debug log is %s.\n", (jb_Debug & BOTDEBUG_LOGFILE)?"enabled":"disabled");
			return true;
			}

		// BOT COMMAND: add bot to server
		else if (!Q_stricmp(cmd, "botspawn"))
			{
			if (gi.argc() == 4)
				fs_loadBotScript(gi.argv(2), atoi(gi.argv(3)));
			else
				fs_loadBotScript(gi.argv(2), TEAM_NONE);
			return true;
			}

		// BOT COMMAND: instakill bot
		else if (!Q_stricmp(cmd, "botkill"))
			{
			botCmd_killBot(gi.argv(2));
			return true;
			}

		// BOT COMMAND: instakill bot
		else if (!Q_stricmp(cmd, "botgoal"))
			{
			botCmd_setBotGoal(gi.argv(2), atoi(gi.argv(3)));
			return true;
			}

		// BOT COMMAND: remove from server
		else if(!Q_stricmp(cmd, "botremove"))
			{
			botCmd_removeBot(gi.argv(2));
			return true;
			}

		// BOT COMMAND: change attribute
		else if (!Q_stricmp(cmd, "botscript"))
			{
			botCmd_changeStats(gi.argv(2), gi.argv(3), gi.argv(4));
			return true;
			}

		// BOT COMMAND: give bot some stuff
		else if (!Q_stricmp(cmd, "botgive"))
			{
			botCmd_cheatGiveBot(gi.argv(2));
			return true;
			}

		// BOT COMMAND: save bot script
		else if (!Q_stricmp(cmd, "savebotscript"))
			{
			fs_saveBotScript(gi.argv(2));
			return true;
			}

		// BOT COMMAND: save bot list
		else if (!Q_stricmp(cmd, "savebotlist"))
			{
			fs_saveBotList();
			return true;
			}

		// NODE COMMAND: save routes
		else if (!Q_stricmp(cmd, "savenodes"))
			{
			path_LinkDirect();
			path_UnlinkBreaks();
			path_LinkProxy();
			fs_saveNodes(false);
			return true;
			}

		// NODE COMMAND: solve (link nodes to one another)
		else if (!Q_stricmp(cmd, "pathsolve"))
			{
			path_LinkDirect();
			path_UnlinkBreaks();
			path_LinkProxy();
			return true;
			}

		return false;
		}

	qboolean botCmd_CommandAvailability_NodeEdit()
		{
		if (jb_Debug & BOTDEBUG_ROUTE)
			return true;

		gi.dprintf("This command is not available outside node edition.\n");
		return false;
		}


	
	/******************************************************************************

	   Client command processor (this function is hooked into g_cmds.c)

	******************************************************************************/
	qboolean botCmd_ClientCommands(edict_t *ent)
		{
		char			*cmd;

		cmd = gi.argv(0);

		// PathShow <to>: Trace a path from client's origin to node[to]
		// PathShow <from> <to>: Trace a path from node[from] to node[to]
		if (!Q_stricmp(cmd, "pathshow"))
			{
			if (botCmd_CommandAvailability_NodeEdit())
				{
				if (gi.argc() == 2)
					{
					jb_ShowPathFrom = botMisc_FindClosestNode(ent->s.origin, BOTNODE_DIST_MIN, nAll);	// Approximation is good enough
					jb_ShowPathTo		= atoi(gi.argv(1));
					}
				else if (gi.argc() == 3)
					{
					jb_ShowPathFrom = atoi(gi.argv(1));
					jb_ShowPathTo		= atoi(gi.argv(2));
					}
				}
			return true;
			}

		// Create a rectangle full of nodes //
		else if (!Q_stricmp(cmd, "nodearea"))
			{
			edit_AreaPoint(ent);
			return true;
			}

		// Special force node link //
		else if (!Q_stricmp(cmd, "linkadd"))
			{
			if (gi.argc() == 3)
				edit_LinkForce(atoi(gi.argv(1)), atoi(gi.argv(2)), "walk");
			else if (gi.argc() == 4)
				edit_LinkForce(atoi(gi.argv(1)), atoi(gi.argv(2)), gi.argv(3));
			return true;
			}

		// Delete Link //
		else if (!Q_stricmp(cmd, "linkremove"))
			{
			return true;
			}

		// Go to bot position //
		else if (!Q_stricmp(cmd, "botfind"))
			{
			int			i;
			edict_t *bot;
			for (i = maxclients->value; i > 0; i--)
  			{
				bot = &g_edicts[i + 1];
				if ((!bot->inuse) || (!bot->botInfo))
					continue;
				if (!Q_stricmp(bot->client->pers.netname, gi.argv(1)))
					{
					VectorCopy(bot->s.origin, ent->s.origin);
					VectorCopy(bot->s.angles, ent->s.angles);
					}
				}
			return true;
			}

		// NODE: find node //
		else if (!Q_stricmp(cmd, "nodefind"))
			{
			int i = atoi(gi.argv(1));
			if (ValidNode(i))
				VectorCopy(jb_Node[i].origin, ent->s.origin);
			else
				gi.dprintf("Node[%i] is out of range\n", i);
			return true;
			}

		// NODE: insert //
		else if (!Q_stricmp(cmd, "nodeadd"))
			{
			if (botCmd_CommandAvailability_NodeEdit())
				{
				edit_RegisterNode(ent, getNodeTypeByName(gi.argv(1)), NULL);
				if (bot_nodesound->value)
					gi.sound(ent, CHAN_AUTO, gi.soundindex("world/switches/pushbutton.wav"), 1, ATTN_NORM, 0);
				}
			return true;
			}

		// NODE: insert item nodes //
		else if (!Q_stricmp(cmd, "nodeitem"))
			{
			edit_BuildItemNodeTable();
			return true;
			}

		// NODE: remove nodes (closest, specified, "all") //
		else if (!Q_stricmp(cmd, "noderemove"))
			{
			if (botCmd_CommandAvailability_NodeEdit())
				{
				INT16 nodeIndex;

				// What node?
				if (gi.argc() == 2)
					nodeIndex = atoi(gi.argv(1));
				else
					{
					if (!Q_stricmp(gi.argv(1), "all"))
						{
						ACEND_InitNodes();			// remove nodes
						DummyNode_RemoveAll();	// remove dummies
						gi.dprintf("All nodes removed\n");
						return true;
						}
					else
						nodeIndex = botMisc_FindClosestNode(ent->s.origin, BOTNODE_DIST_MIN, nAll); // Approximation is good enough
					}
				
				// Invalid?
				if (!ValidNode(nodeIndex))
					gi.dprintf("Node[%i] out or boundaries\n", nodeIndex);
				
				// Remove.
				else
					{
					edit_NodeRemove(nodeIndex);
					if (bot_nodesound->value)
						gi.sound(ent, CHAN_AUTO, gi.soundindex("world/switches/thunk switch.wav"), 1, ATTN_NORM, 0);
					safe_bprintf(PRINT_MEDIUM, "Node[%i] removed\n", nodeIndex);
					}
				}
			return true;
			}

		// NODE: displace //
		else if (!Q_stricmp(cmd, "nodemove"))
			{
			if (botCmd_CommandAvailability_NodeEdit())
				{
				INT16 nodeIndex;
				
				// What node?
				if (gi.argc() == 2)
					nodeIndex = atoi(gi.argv(1));
				else
					nodeIndex = botMisc_FindClosestNode(ent->s.origin, BOTNODE_DIST_MIN, nAll); // Approximation is good enough
				
				// Invalid?
				if (!ValidNode(nodeIndex))
					gi.dprintf("Node[%i] out or boundaries\n", nodeIndex);
				
				// Displace.
				else
					{
					edit_NodeMove(nodeIndex, ent->s.origin, false);
					if (bot_nodesound->value)
						gi.sound(ent, CHAN_AUTO, gi.soundindex("world/switches/pushbutton.wav"), 1, ATTN_NORM, 0);
					}
				}
			return true;
			}

		// NODE: displace //
		else if (!Q_stricmp(cmd, "nodemove2"))
			{
			if (botCmd_CommandAvailability_NodeEdit())
				{
				INT16 nodeIndex;
				
				// What node?
				if (gi.argc() == 2)
					nodeIndex = atoi(gi.argv(1));
				else
					nodeIndex = botMisc_FindClosestNode(ent->s.origin, BOTNODE_DIST_MIN, nAll); // Approximation is good enough
				
				// Invalid?
				if (!ValidNode(nodeIndex))
					gi.dprintf("Node[%i] out or boundaries\n", nodeIndex);
				
				// Displace.
				else
					{
					edit_NodeMove(nodeIndex, ent->s.origin, true);
					if (bot_nodesound->value)
						gi.sound(ent, CHAN_AUTO, gi.soundindex("world/switches/pushbutton.wav"), 1, ATTN_NORM, 0);
					}
				}
			return true;
			}

		return false;
		}



	/******************************************************************************

	   Change/display bot attributes (real-time)

	******************************************************************************/
	void botCmd_changeStats(char *name, char *key, char *value)
		{
		edict_t	**botList;
		edict_t *bot;
		int			botCount;
		int			i;
		int			j;
		char		msg1[MAX_INFO_STRING]; // source
		char		msg2[MAX_INFO_STRING]; // after correction
		field_t	*f;
		int			ammoIndex;
		int			weapIndex;
		gitem_t *itemPtr;
		char		*weapName;
		char		*ammoName;
		int			ammoMax = 0;
		int			ammoNow = 0;

		// Bot select
		botCount = botMisc_CatchBot(name, &botList);
		if (!botCount)
			return;
		
		for (i = 0; i < botCount; i++)
			{
			bot = botList[i];
			// Change value for all selected bots
			if (strlen(key))
				{
				memset (msg1, 0, MAX_INFO_STRING);
				memset (msg2, 0, MAX_INFO_STRING);
				if (botMisc_attribute(&bot->botInfo->def, key, msg1))
					{
					if (strlen(value))
						{
						botMisc_attribute(&bot->botInfo->def, key, value);
						botMisc_attribute(&bot->botInfo->def, key, msg2);
						gi.dprintf("Changed %s's %s from %s to %s\n", bot->client->pers.netname, key, msg1, msg2);
						botMisc_rankWeapons(&bot->botInfo->def); // just in case we messed with weapon preferences, reset rankings
						}
					else
						gi.dprintf("%s's %s is %s\n", bot->client->pers.netname, key, msg1);
					}
				else
					{
					gi.dprintf("Unknown key: \"%s\"\n", key);
					break; // if it doesn't exist for one, it doesn't exist for anyone, bail.
					}
				}
			// Display key/value pair for all selected bots
			else
				{
				// key/value
				for (f = jb_Script; f->name; f++)
					{
					memset (msg1, 0, MAX_INFO_STRING);
					botMisc_attribute(&bot->botInfo->def, f->name, msg1);
					if (strlen(msg1))
						gi.dprintf("%s %s\n", f->name, msg1);
					else
						gi.dprintf("\n== %s\n", f->name);
					}
	  
				// weapon stats by preference
				gi.dprintf("\n== Weapon preferences\n");
				for (j = 0; j < MAX_WEAPONS; j++)
					{
					// Get gun at rankOrder[j]
					weapIndex = botMisc_FindItemIndexByBotItemType(bot->botInfo->def.rankOrder[j]);
					if (weapIndex == -1)
						continue;

					// Get weapon and ammo names
					weapName = itemlist[weapIndex].pickup_name;
					gi.dprintf("%i - %s ", j, weapName);
					if (!itemlist[weapIndex].ammo)
						gi.dprintf("(melee) ");
					else
						{
						// Get ammo detail
						ammoName = itemlist[weapIndex].ammo;
						itemPtr = FindItem(ammoName);
						if (itemPtr)
  						{
							ammoIndex = ITEM_INDEX(itemPtr);
							ammoNow = bot->client->pers.inventory[ammoIndex];
							}
						if (bot->botInfo->def.rankOrder[j] == wPistol)
							ammoMax = bot->client->pers.max_bullets;
						else if (bot->botInfo->def.rankOrder[j] == wShotgun)
							ammoMax = bot->client->pers.max_shells;
						else if (bot->botInfo->def.rankOrder[j] == wTommyGun)
							ammoMax = bot->client->pers.max_bullets;
						else if (bot->botInfo->def.rankOrder[j] == wGrenadeLauncher)
							ammoMax = bot->client->pers.max_grenades;
						else if (bot->botInfo->def.rankOrder[j] == wRocketLauncher)
							ammoMax = bot->client->pers.max_rockets;
						else if (bot->botInfo->def.rankOrder[j] == wFlamethrower)
							ammoMax = bot->client->pers.max_gas;
						else if (bot->botInfo->def.rankOrder[j] == wHeavyMachineGun)
							ammoMax = bot->client->pers.max_308cal;
						gi.dprintf("(%i/%i %s) ", ammoNow, ammoMax, ammoName);
						}
					if (bot->client->pers.inventory[weapIndex])
						gi.dprintf("- owned\n");
					else
						gi.dprintf("- missing\n");
					}
				}
			}
		}



  /******************************************************************************

     Kill a bot by name (or all bots if name == "all")

  ******************************************************************************/
  void botCmd_killBot(char *name)
		{
		edict_t	  **botList = 0;
		edict_t	  *bot;
		int				botCount;
		int				i;
		
		// Bot select
		botCount = botMisc_CatchBot(name, &botList);
		if (!botCount)
			return;

		// Kill bot
		for (i = 0; i < botCount; i++)
			{
			bot = botList[i];
			bot->health = 0;
			player_die(bot, bot, bot, 1, vec3_origin, 0, 0);
			}

		}



	/******************************************************************************

	   Force goal upon a bot

	******************************************************************************/
	void botCmd_setBotGoal(char *name, int goal)
		{
		edict_t	  **botList = 0;
		int				botCount;
		int				i;

		// Invalid node
		if (!ValidNode(goal))
			return;

		// Bot select
		botCount = botMisc_CatchBot(name, &botList);
		if (!botCount)
			return;

		// For each bot
		for (i = 0; i < botCount; i++)
			ACEND_SetGoal(botList[i], -1, goal);
		}



	/******************************************************************************

	   Remove a bot by name (or all bots if name == "all")

	******************************************************************************/
	void botCmd_removeBot(char *name)
		{
		edict_t	  **botList = 0;
		edict_t	  *bot;
		int				botCount;
		int				i;
		
		// Bot select
		botCount = botMisc_CatchBot(name, &botList);
		if (!botCount)
			return;

		// Remove bot
		for (i = 0; i < botCount; i++)
			{
			bot = botList[i];

			// remove trail if bot uses ai_think
			if (bot->botInfo->def.flags & BOTFLAG_THINK)
				jb_ShowPathFrom = BOTNODE_INVALID;

			// kill bot
			bot->botInfo->inUse = false; // Free registery
			bot->health = 0;
			player_die(bot, bot, bot, 1, vec3_origin, 0, 0);
			BotClientRemoved(bot);
			safe_bprintf(PRINT_MEDIUM, "%s has been removed.\n", bot->client->pers.netname);

			// cannot use G_FreeEdict() on them
			gi.unlinkentity(bot);
			memset (bot, 0, sizeof(*bot));
			bot->classname = "freed";
  		bot->freetime = level.time;
			bot->inuse = false;
			}
		}




	/******************************************************************************
	   
		 Full refill for the specified bot (relies on a slightly modified version
		 of Cmd_Give_f(edict_t *ent);

  ******************************************************************************/
	void botCmd_cheatGive(edict_t *other)
		{
		char			*name;
		gitem_t		*it;
		int				index;
		int				i;
		qboolean	give_all;
		edict_t		*it_ent;

		if (!developer->value)
			return;

		if (deathmatch->value && !sv_cheats->value)
			{
			#if compileSAFEPRINT
			gi.dprintf ("You must run the server with '+set cheats 1' to enable this command.\n");
			#else
			gi.cprintf (ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
			#endif
			return;
			}

		name = gi.argv(3);
		give_all = (!Q_stricmp(name, "all"));

		// GIVE CASH //
		if (give_all || !Q_stricmp(gi.argv(3), "cash"))
			{
			int count = 100;
			if (gi.argc() == 5)
				count = atoi(gi.argv(4));
			other->client->pers.currentcash += count;
			gi.sound (other, CHAN_AUTO, gi.soundindex("world/pickups/cash.wav"), 1, ATTN_NORM, 0);

			if (!give_all)
				return;
			}

		// GIVE HEALTH //
		if (give_all || !Q_stricmp(gi.argv(3), "health"))
			{
			int count = other->max_health;
			if (gi.argc() == 5)
				count = atoi(gi.argv(4));
			other->health = count;

			if (!give_all)
				return;
			}

		// GIVE MODS //
		if (give_all || !Q_stricmp (gi.argv(3), "mods"))
			{
			other->client->pers.pistol_mods |= WEAPON_MOD_ROF;
			other->client->pers.pistol_mods |= WEAPON_MOD_RELOAD;
			other->client->pers.pistol_mods |= WEAPON_MOD_DAMAGE;
			other->client->pers.pistol_mods |= WEAPON_MOD_COOLING_JACKET;
			other->client->pers.hmg_shots = 30;

			if (!give_all)
				return;
			}

		// GIVE WEAPONS //
		if (give_all || !Q_stricmp(name, "weapons"))
			{
			for (i = 0 ; i < game.num_items; i++)
				{
				it = itemlist + i;
				if ((!it->pickup) || (!(it->flags & IT_WEAPON)))
					continue;
				other->client->pers.inventory[i] = 1;
				if (it->flags & IT_SILENCER)
					other->client->pers.silencer_shots = 20;
				}

			if (!give_all)
				return;
			}

		// GIVE AMMO //
		if (give_all || !Q_stricmp(name, "ammo"))
			{
			for (i = 0; i < game.num_items; i++)
				{
				it = itemlist + i;
				if (!it->pickup)
					continue;
				if ((!(it->flags & IT_AMMO)) || (it->flags & IT_NOCHEATS))
					continue;
				Add_Ammo (other, it, 1000);
				}

			if (!give_all)
				return;
			}

		// GIVE ARMOR //
		if (give_all || !Q_stricmp(name, "armor"))
			{
			gitem_t	*it;

			it = FindItem("Jacket Armor Heavy");
			other->client->pers.inventory[ITEM_INDEX(it)] = 100;

			it = FindItem("Legs Armor Heavy");
			other->client->pers.inventory[ITEM_INDEX(it)] = 100;

			it = FindItem("Helmet Armor Heavy");
			other->client->pers.inventory[ITEM_INDEX(it)] = 100;

			if (!give_all)
				return;
			}

		// GIVE ALL //
		if (give_all)
			{
			for (i = 0; i < game.num_items; i++)
				{
				it = itemlist + i;
				if (!it->pickup)
					continue;
				if (it->flags & (IT_ARMOR|IT_WEAPON|IT_AMMO|IT_NOCHEATS))
					continue;
				other->client->pers.inventory[i] = 1;
				}
			return;
			}

		// Something failed (wrong item name)
		it = FindItem (name);
		if (!it)
			{
			name = gi.argv(3);
			it = FindItem (name);
			if (!it)
				{
				#if compileSAFEPRINT
				gi.dprintf("not a valid item\n");
				#else
				gi.cprintf (ent, PRINT_HIGH, "not a valid item\n");
				#endif
				return;
				}
			}

		if (!it->pickup)
			{
			#if compileSAFEPRINT
			gi.dprintf ("non-pickup item\n");
			#else
			gi.cprintf (ent, PRINT_HIGH, "non-pickup item\n");
			#endif
			return;
			}

		index = ITEM_INDEX(it);

		if (it->flags & IT_AMMO)
			{
			if (gi.argc() == 5)
				other->client->pers.inventory[index] = atoi(gi.argv(4));
			else
				other->client->pers.inventory[index] += it->quantity;
			}
		else
			{
			it_ent = G_Spawn();
			it_ent->classname = it->classname;
			SpawnItem (it_ent, it);
			Touch_Item (it_ent, other, NULL, NULL);
			if (it->flags & IT_SILENCER)
				other->client->pers.silencer_shots = 20;
			if (it_ent->inuse)
				G_FreeEdict(it_ent);
			}
		}

  void botCmd_cheatGiveBot(char *name)
		{
		edict_t	  **botList = 0;
		int				botCount;
		int				i;
		//gitem_t	  *it;

		// Bot select
		botCount = botMisc_CatchBot(name, &botList);
		if (!botCount)
			return;

		// Name is at the end of list
		for (i = 0; i < botCount; i++)
			{
			botCmd_cheatGive(botList[i]);
			safe_bprintf(PRINT_MEDIUM, "%s has been refilled.\n", botList[i]->client->pers.netname);
			}

		}

	


#endif