#include "g_local.h"
#if compileJACKBOT

	/***************************************************************

		Initiate a chat command (chat commands should contain a set
		of strings picked at random, and a signification code for
		bots --could help in teamplay--)

	***************************************************************/
	void botChatInitiate(edict_t *self, char *msg, qboolean important, qboolean team)
		{
		// Bots cannot talk
		if ((int)bot_mute->value)
			return;
		// If unimportant, message will depend on bot inclination to chat
		if ((!important) && (random() > self->botInfo->def.chatter))
			return;
		// Set message and give it a time out
		self->botInfo->chatLine = msg;
		self->botInfo->chatTimeOut = level.time + ((1.50 + random()) * (self->botInfo->def.reactiontime + 0.01)) + (strlen(self->botInfo->chatLine) * 0.12);
		self->botInfo->chatTeam = team;
		}

	/****************************************************

		Called during intermission (ClientThink) and
		gameplay (ACEAI_Think)

	****************************************************/
	void botChatThink(edict_t *self)
		{
		if ((self->botInfo->chatTimeOut > level.time) || (!self->botInfo->chatLine) || (self->botInfo->chatTimeOut == 0))
			return;
		botChat(self, self->botInfo->chatTeam, self->botInfo->chatLine);
		self->botInfo->chatTimeOut = 0;
		self->botInfo->chatTeam = false;
		self->botInfo->chatLine = 0;
		}

	void botChat(edict_t *ent, qboolean teamChat, char *msg)
		{
		int				j;
		edict_t		*other;
		char			text[2048];

		if (!strlen(msg))
			return;

		if (!teamplay->value && !((int)(dmflags->value) & (DF_MODELTEAMS)))
			teamChat = false;

		if (teamChat)
			Com_sprintf (text, sizeof(text), ":(%s): ", ent->client->pers.netname);
		else
			Com_sprintf (text, sizeof(text), ":%s: ", ent->client->pers.netname);

		strcat(text, msg);

		// don't let text be too long for malicious reasons
		if (strlen(text) > 150)
			text[150] = 0;

		strcat(text, "\n");
	
		if (dedicated->value)
			#if compileSAFEPRINT
			safe_cprintf(NULL, PRINT_CHAT, "%s", text);
			#else
			gi.cprintf(NULL, PRINT_CHAT, "%s", text);
			#endif

		// Bot should "signal" to other bots, not send message
		for (j = 1; j <= game.maxclients; j++)
			{
			other = &g_edicts[j];
			if (!(other->inuse))
				continue;
			if (!(other->client))
				continue;
			if (teamChat)
				{
				if (!OnSameTeam(ent, other))
					continue;
				if ((ent->client->pers.team == 0) != (other->client->pers.team == 0))
					continue;
				}
			#if compileSAFEPRINT
			safe_cprintf(other, PRINT_CHAT, "%s", text);
			#else
			gi.cprintf(other, PRINT_CHAT, "%s", text);
			#endif
			}
		}
#endif