#include "g_local.h"


/*
==================
ScoreboardMessage

==================
*/
void PrintTeams (char string[], int team, int x, int y, edict_t *ent, edict_t *killer, int teamcount) 
{
	char	entry[1024];
	int		i, j, k, l;
	edict_t		*cl_ent;
	int		sorted[MAX_CLIENTS];
	int		sortedscores[MAX_CLIENTS];
	int		score, total, real_total;
	gclient_t	*cl;
	char	*tag;
	int		tempy = 0;
	char	nfill[64];
	int		stringlength=0;


	Com_sprintf (entry, sizeof(entry),
		"xv %i yv %i tscore %i xv %i dmstr 888 \"%s\"",
		x+42*10, y + (int)(-60.0+-3.5*14), team, x+14*10, team_names[team]);
	/*
		Com_sprintf (entry, sizeof(entry),
			"xv %i yv %i dmstr 668 \"Crenshaw Mafia (%2i plyrs)  WINS: %3i\"",
			x+14*10, y + (int)(-60.0+-3.5*14), teamcount, team_cash[team]);

	*/

	j = strlen(entry);
	if (stringlength + j < 1024){
		strcpy (string + stringlength, entry);
		stringlength += j;
	}
	else
		gi.dprintf("DEBUG: scoreboard overflow for client\n");

	// sort the clients by score
	total = 0;
	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;
		
		if (game.clients[i].pers.team != team)
			continue;
		
		score = (game.clients[i].resp.score<<8)-game.clients[i].resp.deposited;

		for (j=0 ; j<total ; j++)
		{
			if (score > sortedscores[j])
				break;
		}
		for (k=total ; k>j ; k--)
		{
			sorted[k] = sorted[k-1];
			sortedscores[k] = sortedscores[k-1];
		}
		sorted[j] = i;
		sortedscores[j] = score;
		total++;
	}
	
	real_total = total;

	// max players displayed for each team without overflowing buffer
	if (total > 16)
		total = 16;

	
	Com_sprintf (entry, sizeof(entry),
		"yv %i dmstr 663 \"NAME                 ping hits death\"",
		y + (int)(-60.0+-1.5*14));

	j = strlen(entry);
	if (stringlength + j < 1024){
		strcpy (string + stringlength, entry);
		stringlength += j;
	}
	else
		gi.dprintf("DEBUG: scoreboard overflow for client\n");

	for (i=0 ; i<total ; i++)
	{
		cl = &game.clients[sorted[i]];
		cl_ent = g_edicts + 1 + sorted[i];
				

		if (cl_ent->playing_ingame == FALSE)
			tag = "955";
		else if (cl_ent->crashType == CRASH_VIP || cl_ent->crashType == CRASH_BOMBHOLDER)
			tag = "559";
		else
			tag = "999";

		strcpy( nfill, cl->pers.netname );
		if (strlen(nfill) > 13)
			nfill[13] = '\0';

		if (strlen(cl->pers.netname) < 13)
		{
			for (l=0; l<13-strlen(cl->pers.netname); l++)
				strcat( nfill, " " );
		}

		if(cl_ent == ent){
			if (cl_ent->playing_ingame == FALSE){
				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s  *DEAD*%4i %4i %5i <-\"",
					(y - 60) + (i*20), tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited);
			}
			else if (cl_ent->crashType == CRASH_VIP){
				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s  *VIP* %4i %4i %5i <-\"",
					(y - 60) + (i*20), tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited);
			}
			else if (cl_ent->crashType == CRASH_BOMBHOLDER){
				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s  *BOMB*%4i %4i %5i <-\"",
					(y - 60) + (i*20), tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited);
			}
			else{
				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s        %4i %4i %5i <-\"",
					(y - 60) + (i*20), tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited);
			}
		}
		else{
			if (cl_ent->playing_ingame == FALSE){
				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s  *DEAD*%4i %4i %5i\"",
					(y - 60) + (i*20), tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited);
			}
			else if (cl_ent->crashType == CRASH_VIP){
				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s  *VIP* %4i %4i %5i\"",
					(y - 60) + (i*20), tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited);
			}
			else if (cl_ent->crashType == CRASH_BOMBHOLDER){
				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s  *BOMB*%4i %4i %5i\"",
					(y - 60) + (i*20), tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited);
			}
			else{
				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s        %4i %4i %5i\"",
					(y - 60) + (i*20), tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited);
			}
		}

		j = strlen(entry);
		if (stringlength + j < 1024){
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
		else
			gi.dprintf("DEBUG: scoreboard overflow for client\n");
	}

	if (real_total > total)
	{	// show the nuber of undisplayed players

		Com_sprintf (entry, sizeof(entry),
			"yv %i dmstr 888 \"%i plyrs\"",
			(y - 60) + (i*20), real_total );

		j = strlen(entry);
		if (stringlength + j < 1024){
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
		else
			gi.dprintf("DEBUG: scoreboard overflow for client\n");
	}

//snap, debug info
// supposed to be <1024
// currently _should_ max at 1019 and 1022 for team 1/2 respectively
//gi.cprintf( ent, PRINT_CHAT, "size:   %i\n", stringlength);

}


void CrashScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	string[1400]="";
	int		i;
	edict_t		*cl_ent;
	int		teamcount;

	if (!ent->client->showscores)
		goto skipscores;

	teamcount = 0;

	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;

		if (game.clients[i].pers.team != 1)
			continue;

		teamcount++;
	}

	PrintTeams(string, 1, -200, 0, ent, killer, teamcount);

skipscores:

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

void GangScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	string[1400]="";
	int		i;
	edict_t		*cl_ent;
	int		teamcount;

	if (!ent->client->showscores)
		goto skipscores;

	teamcount = 0;

	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;

		if (game.clients[i].pers.team != 2)
			continue;

		teamcount++;
	}

	PrintTeams(string, 2, -200, 0, ent, killer, teamcount);

skipscores:

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

// Note:  function is ugly!
void ScopeScore (edict_t *ent)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		j,i,k,glmode;

	char *scope640x480[][3] =
			{
				{
					"0a",						//picture index
					"0",						//x offset
					"0"						//y offset
				},
				{
					"0b",
					"320",
					"0"
				},
				{
					"0c",
					"0",
					"240"
				},
				{
					"0d",
					"320",
					"240"
				},
				NULL
			};
	char *scope800x600[][3] =
			{
				{
					"1a",						//picture index
					"0",						//x offset
					"0"						//y offset
				},
				{
					"1b",						//picture index
					"200",						//x offset
					"0"						//y offset
				},
				{
					"1c",						//picture index
					"400",						//x offset
					"0"						//y offset
				},
				{
					"1d",						//picture index
					"600",						//x offset
					"0"						//y offset
				},
				{
					"1e",						//picture index
					"0",						//x offset
					"300"						//y offset
				},
				{
					"1f",						//picture index
					"200",						//x offset
					"300"						//y offset
				},
				{
					"1g",						//picture index
					"400",						//x offset
					"300"						//y offset
				},
				{
					"1h",						//picture index
					"600",						//x offset
					"300"					//y offset
				},
				NULL
			};
	char *scope960x720[][3] =
			{
				{
					"2a",						//picture index
					"0",						//x offset
					"0"						//y offset
				},
				{
					"2b",						//picture index
					"320",						//x offset
					"0"						//y offset
				},
				{
					"2c",						//picture index
					"640",						//x offset
					"0"						//y offset
				},
				{
					"2d",						//picture index
					"0",						//x offset
					"240"						//y offset
				},
				{
					"2e",						//picture index
					"320",						//x offset
					"240"						//y offset
				},
				{
					"2f",						//picture index
					"640",						//x offset
					"240"						//y offset
				},
				{
					"2g",						//picture index
					"0",						//x offset
					"480"						//y offset
				},
				{
					"2h",						//picture index
					"320",						//x offset
					"480"						//y offset
				},
				{
					"2i",						//picture index
					"640",						//x offset
					"480"						//y offset
				},
				NULL
			};
	char *scope1024x768[][3] =
			{
				{
					"3a",						//picture index
					"0",						//x offset
					"0"						//y offset
				},
				{
					"3b",						//picture index
					"256",						//x offset
					"0"						//y offset
				},
				{
					"3c",						//picture index
					"512",						//x offset
					"0"						//y offset
				},
				{
					"3d",						//picture index
					"768",						//x offset
					"0"						//y offset
				},
				{
					"3e",						//picture index
					"0",						//x offset
					"256"						//y offset
				},
				{
					"3f",						//picture index
					"256",						//x offset
					"256"						//y offset
				},
				{
					"3g",						//picture index
					"512",						//x offset
					"256"						//y offset
				},
				{
					"3h",						//picture index
					"768",						//x offset
					"256"						//y offset
				},
				{
					"3i",						//picture index
					"0",						//x offset
					"512"						//y offset
				},
				{
					"3j",						//picture index
					"256",						//x offset
					"512"						//y offset
				},
				{
					"3k",						//picture index
					"512",						//x offset
					"512"						//y offset
				},
				{
					"3l",						//picture index
					"768",						//x offset
					"512"						//y offset
				},
				NULL
			};
	char *scope1152x864[][3] =
			{
				{
					"4a",						//picture index
					"0",						//x offset
					"0"						//y offset
				},
				{
					"4b",						//picture index
					"288",						//x offset
					"0"						//y offset
				},
				{
					"4c",						//picture index
					"576",						//x offset
					"0"						//y offset
				},
				{
					"4d",						//picture index
					"864",						//x offset
					"0"						//y offset
				},
				{
					"4e",						//picture index
					"0",						//x offset
					"288"						//y offset
				},
				{
					"4f",						//picture index
					"288",						//x offset
					"288"						//y offset
				},
				{
					"4g",						//picture index
					"576",						//x offset
					"288"						//y offset
				},
				{
					"4h",						//picture index
					"864",						//x offset
					"288"						//y offset
				},
				{
					"4i",						//picture index
					"0",						//x offset
					"576"						//y offset
				},
				{
					"4j",						//picture index
					"288",						//x offset
					"576"						//y offset
				},
				{
					"4k",						//picture index
					"576",						//x offset
					"576"						//y offset
				},
				{
					"4l",						//picture index
					"864",						//x offset
					"576"						//y offset
				},
				NULL
			};
	char *scope1280x960[][3] =
			{
				{
					"5a",						//picture index
					"0",						//x offset
					"0"						//y offset
				},
				{
					"5b",						//picture index
					"320",						//x offset
					"0"						//y offset
				},
				{
					"5c",						//picture index
					"640",						//x offset
					"0"						//y offset
				},
				{
					"5d",						//picture index
					"960",						//x offset
					"0"						//y offset
				},
				{
					"5e",						//picture index
					"0",						//x offset
					"320"						//y offset
				},
				{
					"5f",						//picture index
					"320",						//x offset
					"320"						//y offset
				},
				{
					"5g",						//picture index
					"640",						//x offset
					"320"						//y offset
				},
				{
					"5h",						//picture index
					"960",						//x offset
					"320"						//y offset
				},
				{
					"5i",						//picture index
					"0",						//x offset
					"640"						//y offset
				},
				{
					"5j",						//picture index
					"320",						//x offset
					"640"						//y offset
				},
				{
					"5k",						//picture index
					"640",						//x offset
					"640"						//y offset
				},
				{
					"5l",						//picture index
					"960",						//x offset
					"640"						//y offset
				},
				NULL
			};

	glmode = atoi(Info_ValueForKey (ent->client->pers.userinfo, "gl_mode"));

	string[0] = 0;
	stringlength = 0;
	
	if(glmode == 0){
		for(i=0;scope640x480[i][0];i++){
			for(k=0;k<=2;k++){           // draw it 3 times
				Com_sprintf (entry, sizeof(entry),
					"xl %s yt %s picn %s ",
					scope640x480[i][1], scope640x480[i][2], scope640x480[i][0] );
				j = strlen(entry);
				if (stringlength + j < 1024){
					strcpy (string + stringlength, entry);
					stringlength += j;
				}
				else
					gi.dprintf("DEBUG: scoreboard overflow for client\n");
			}
		}
	}
	else if(glmode == 1){
		for(i=0;scope800x600[i][0];i++){
			for(k=0;k<=2;k++){           // draw it 3 times
				Com_sprintf (entry, sizeof(entry),
					"xl %s yt %s picn %s ",
					scope800x600[i][1], scope800x600[i][2], scope800x600[i][0] );
				j = strlen(entry);
				if (stringlength + j < 1024){
					strcpy (string + stringlength, entry);
					stringlength += j;
				}
				else
					gi.dprintf("DEBUG: scoreboard overflow for client\n");
			}
		}
	}
	else if(glmode == 2){
		for(i=0;scope960x720[i][0];i++){
			for(k=0;k<=2;k++){           // draw it 3 times
				Com_sprintf (entry, sizeof(entry),
					"xl %s yt %s picn %s ",
					scope960x720[i][1], scope960x720[i][2], scope960x720[i][0] );
				j = strlen(entry);
				if (stringlength + j < 1024){
					strcpy (string + stringlength, entry);
					stringlength += j;
				}
				else
					gi.dprintf("DEBUG: scoreboard overflow for client\n");
			}
		}
	}
	else if(glmode == 3){
		for(i=0;scope1024x768[i][0];i++){
			for(k=0;k<=2;k++){           // draw it 3 times
				Com_sprintf (entry, sizeof(entry),
					"xl %s yt %s picn %s ",
					scope1024x768[i][1], scope1024x768[i][2], scope1024x768[i][0] );
				j = strlen(entry);
				if (stringlength + j < 1024){
					strcpy (string + stringlength, entry);
					stringlength += j;
				}
				else
					gi.dprintf("DEBUG: scoreboard overflow for client\n");
			}
		}
	}
	else if(glmode == 4){
		for(i=0;scope1152x864[i][0];i++){
			for(k=0;k<=2;k++){           // draw it 3 times
				Com_sprintf (entry, sizeof(entry),
					"xl %s yt %s picn %s ",
					scope1152x864[i][1], scope1152x864[i][2], scope1152x864[i][0] );
				j = strlen(entry);
				if (stringlength + j < 1024){
					strcpy (string + stringlength, entry);
					stringlength += j;
				}
				else
					gi.dprintf("DEBUG: scoreboard overflow for client\n");
			}
		}
	}
	else if(glmode == 5){
		for(i=0;scope1280x960[i][0];i++){
			for(k=0;k<=2;k++){           // draw it 3 times
				Com_sprintf (entry, sizeof(entry),
					"xl %s yt %s picn %s ",
					scope1280x960[i][1], scope1280x960[i][2], scope1280x960[i][0] );
				j = strlen(entry);
				if (stringlength + j < 1024){
					strcpy (string + stringlength, entry);
					stringlength += j;
				}
				else
					gi.dprintf("DEBUG: scoreboard overflow for client\n");
			}
		}
	}

//	gi.dprintf("DEBUG: client scope array size: %i\n", stringlength);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

// snap, new radio message HUD
void RadioMessage (edict_t *ent)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs=0;
	char	*selectheader[] =
		{
			"RADIO COMMANDS",
			"=====================================",
			"(-1-): Coast is clear, let's go",
			"(-2-): Cover me i'm goin in",
			"(-3-): Follow my lead",
			"(-4-): Hold this ground",
			"(-5-): I have visual confirmation",
			"(-6-): Take these motherfuckers down",
			"(-7-): Let's go",
			"(-8-): That's a negative",
			"(-9-): Stay close team",
			"(-0-): Affirmative",
			"=====================================",
			NULL
		};
	char	*selectheader2[] =
		{
			"RADIO COMMANDS",
			"=====================================",
			"(-1-): I don't see shit",
			"(-2-): Get my back",
			"(-3-): Follow me",
			"(-4-): Stay over here",
			"(-5-): I see them",
			"(-6-): Let's fuck these bitches up",
			"(-7-): Let's go",
			"(-8-): Nah man",
			"(-9-): Don't break the pack",
			"(-0-): Yeah that's it",
			"=====================================",
			NULL
		};

	string[0] = 0;
	stringlength = 0;

	if(ent->client->pers.team == 1){
		for (i=0; selectheader[i]; i++){
			Com_sprintf (entry, sizeof(entry),
				"xm %i yv %i dmstr 773 \"%s\" ",
				-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );
			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;
			yofs += 20;
		}
	}
	else if(ent->client->pers.team == 2){
		for (i=0; selectheader2[i]; i++){
			Com_sprintf (entry, sizeof(entry),
				"xm %i yv %i dmstr 773 \"%s\" ",
				-5*strlen(selectheader2[i]), yofs + (int)(-60.0+-3.5*14), selectheader2[i] );
			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;
			yofs += 20;
		}
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

}