// g_weapon.c

#include "g_local.h"
#include "m_player.h"

#include "voice_bitch.h"
#include "voice_punk.h" 

static qboolean	is_quad;
// RAFAEL
static qboolean is_quadfire;
static byte		is_silenced;

// snap - old shit
/*
void weapon_grenade_fire (edict_t *ent, qboolean held);
void weapon_trap_fire (edict_t *ent, qboolean held);
*/
static void P_ProjectSource (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result)
{
	vec3_t	_distance;

	VectorCopy (distance, _distance);
	if (client->pers.hand == LEFT_HANDED)
		_distance[1] *= -1;
	else if (client->pers.hand == CENTER_HANDED)
		_distance[1] = 0;
	G_ProjectSource (point, _distance, forward, right, result);
}


/*
===============
PlayerNoise

Each player can have two noise objects associated with it:
a personal noise (jumping, pain, weapon firing), and a weapon
target noise (bullet wall impacts)

Monsters that don't directly see the player can move
to a noise in hopes of seeing the player from there.
===============
*/
void PlayerNoise(edict_t *who, vec3_t where, int type)
{

	if (deathmatch->value && type != PNOISE_WEAPON)
		return;

	VectorCopy( who->s.origin, who->noise_pos );
	who->noise_time = level.time + 2;
	who->noise_type = type;
	VectorCopy( who->s.angles, who->noise_angles );

}


// weapon stuff moved from p_weapon.c
#define MAX_PISTOL_ROUNDS		10
#define MAX_SHOTGUN_ROUNDS		8
/*
#define MAX_TOMMYGUN_ROUNDS		50
#define MAX_BARMACHINEGUN_ROUNDS 	5
#define MAX_GRENADELAUNCHER_ROUNDS	3
#define MAX_ROCKETLAUNCHER_ROUNDS	5
#define	MAX_FLAMEGUN_ROUNDS			50
*/
#define MAX_DESERT_ROUNDS		7
#define MAX_MP5_ROUNDS		    30
#define MAX_UZI_ROUNDS		    30
#define MAX_MSG90_ROUNDS		5
#define MAX_AWP_ROUNDS			5
#define MAX_M4A1_ROUNDS			30
#define MAX_DRAG_ROUNDS			30

// this is here so we can simplify the auto-reload code. it's in the same order as clip_t
int	auto_rounds[] =
{
	MAX_PISTOL_ROUNDS,
	MAX_SHOTGUN_ROUNDS,
/*	MAX_TOMMYGUN_ROUNDS,
	MAX_BARMACHINEGUN_ROUNDS,
	MAX_GRENADELAUNCHER_ROUNDS,
	MAX_ROCKETLAUNCHER_ROUNDS,
*/	MAX_DESERT_ROUNDS,
	MAX_MP5_ROUNDS,
	MAX_UZI_ROUNDS,
	MAX_AWP_ROUNDS,
	MAX_MSG90_ROUNDS,
	MAX_M4A1_ROUNDS,
	MAX_DRAG_ROUNDS

};

int QweryClipIndex (gitem_t *item);

void AutoLoadWeapon( gclient_t *client, gitem_t *weapon, gitem_t *ammo )
{
	int clip_index;
	int	ammo_index;
	int diff;
 // snap- changed how this works
	if ( (clip_index = QweryClipIndex( weapon ))){
		ammo_index = ITEM_INDEX(ammo);

		if(client->pers.weapon_clip[clip_index] < auto_rounds[clip_index]){

			diff = auto_rounds[clip_index] - client->pers.weapon_clip[clip_index];

			if (client->pers.inventory[ammo_index] >= diff){
				client->pers.inventory[ammo_index] -= diff;
				client->pers.weapon_clip[clip_index] += diff;
			}
			else{
				client->pers.weapon_clip[clip_index] += client->pers.inventory[ammo_index];
				client->pers.inventory[ammo_index] = 0;
			}
		}
	}
}

// snap - new func
qboolean hasWeapAndAmmo ( gclient_t *client, gitem_t *weapon, gitem_t *ammo )
{
	int clip_index;
	int	ammo_index;

	// no weapon
	if(!client->pers.inventory[ITEM_INDEX(weapon)])
		return false;

	clip_index = QweryClipIndex( weapon );
	ammo_index = ITEM_INDEX(ammo);

	// has ammo in weap or has a clip with ammo in it
	if(client->pers.weapon_clip[clip_index] > 0 || client->pers.inventory[ammo_index] > 0)
		return true;
	// no ammo at all
	else 
		return false;
}


qboolean Pickup_Weapon (edict_t *ent, edict_t *other)
{
	int			index;
	gitem_t		*ammo;
	int			auto_reload=false;

	index = ITEM_INDEX(ent->item);

	if ( ( ((int)(dmflags->value) & DF_WEAPONS_STAY) || coop->value) 
		&& other->client->pers.inventory[index])
	{
		if (!(ent->spawnflags & (DROPPED_ITEM | DROPPED_PLAYER_ITEM) ) )
			return false;	// leave the weapon for others to pickup
	}

	// snap, dont let VIP pickup weapons
	if (other->crashType == CRASH_VIP)
		return false;

	// snap, dont let team 1 players pickup the bomb
	//		 noone can pick it up if it's armed
	if	(!(strcmp (ent->classname, "weapon_bomb"))){
		if (ent->armed == TRUE){ 
			if(other->client->pers.team == 1 && other->deactivate_frame != level.framenum){
				other->deactivate_frame = level.framenum;
		//		gi.bprintf (PRINT_HIGH, "%s triggered disarm bomb frame: %d\n", other->client->pers.netname, other->deactivate_frame);
			}
			return false;
		}
		else if(other->client->pers.team != 2)
			return false;
	}

	// Ridah, start with gun loaded
	if (!(other->client->pers.inventory[index]))
		auto_reload = true;

	// snap, changed this for multiple inventory items
	if	( !(strcmp (ent->classname, "weapon_molotov")) || !(strcmp (ent->classname, "weapon_grenade")) ){
		other->client->pers.inventory[index]++;
	}
	else{
		other->client->pers.inventory[index] = 1;
	}

	// snap, ammo stuff
	if( ent->item->ammo ){
		ammo = FindItem (ent->item->ammo);
		//gi.bprintf (PRINT_HIGH, "ammo pickup: %d\n", ent->item->droppedammo);
		Add_Ammo (other, ammo, ent->item->droppedammo);
		AutoLoadWeapon( other->client, ent->item, ammo );
	}

// snap, not needed anymore, enable if weapons are needed in map
/*
	if (ent->item->ammo && !(ent->spawnflags & DROPPED_ITEM) )
	{
		// give them some ammo with it
		ammo = FindItem (ent->item->ammo);
		if ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value )
			Add_Ammo (other, ammo, 1000);
		else{
			Add_Ammo (other, ammo, ammo->quantity);
		}

		if (auto_reload)
			AutoLoadWeapon( other->client, ent->item, ammo );

		if (! (ent->spawnflags & DROPPED_PLAYER_ITEM) )
		{
			if (deathmatch->value)
			{
				if ((int)(dmflags->value) & DF_WEAPONS_STAY)
					ent->flags |= FL_RESPAWN;
				else
					SetRespawn (ent, 30);
			}
			if (coop->value)
				ent->flags |= FL_RESPAWN;
		}
	}
	else if (!(strcmp (ent->classname, "weapon_crowbar")))
	{
		if (! (ent->spawnflags & DROPPED_PLAYER_ITEM) )
		{
			if (deathmatch->value)
			{
				if ((int)(dmflags->value) & DF_WEAPONS_STAY)
					ent->flags |= FL_RESPAWN;
				else
					SetRespawn (ent, 30);
			}
			if (coop->value)
				ent->flags |= FL_RESPAWN;
		}
	}
	
	if (other->client->pers.weapon == FindItem ("SPistol"))
			other->client->pers.silencer_shots = 20;
*/
	/*
	if (other->client->pers.weapon != ent->item && 
		(other->client->pers.inventory[index] == 1) &&
		( !deathmatch->value || other->client->pers.weapon == FindItem("Pipe") ) )
		other->client->newweapon = ent->item;
	*/
	
	if (deathmatch->value)
	{
		if (other->client->pers.weapon != ent->item && auto_reload && (other->client->pers.weapon == FindItem ("Pistol") || other->client->pers.weapon == FindItem ("Pipe") ))
			other->client->newweapon = ent->item;
	}
	else
	{
	if (other->client->pers.weapon != ent->item && auto_reload)
		other->client->newweapon = ent->item;
	}

	// snap, if they pickup bomb, setup their crashType flag
	if(!(strcmp (ent->classname, "weapon_bomb"))){
		other->crashType = CRASH_BOMBHOLDER;
		gi.bprintf (PRINT_HIGH, "%s Picked Up The Bomb!\n", other->client->pers.netname);
	}
	
	return true;
}

/*
Change Clip Index 
*/
void ChangeClipIndex (edict_t *ent)
{
	
	if (!strcmp(ent->client->pers.weapon->pickup_name, "Pipe"))
		ent->client->clip_index = CLIP_NONE;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "Crowbar"))
		ent->client->clip_index = CLIP_NONE;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "Pistol"))
		ent->client->clip_index = CLIP_PISTOL;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "SPistol"))
		ent->client->clip_index = CLIP_PISTOL;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "Shotgun"))
		ent->client->clip_index = CLIP_SHOTGUN;
	// snap - old stuff
	/*
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "Tommygun"))
		ent->client->clip_index = CLIP_TOMMYGUN;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "FlameThrower"))
		ent->client->clip_index = CLIP_FLAMEGUN;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "Bazooka"))
		ent->client->clip_index = CLIP_ROCKETS;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "Grenade Launcher"))
		ent->client->clip_index = CLIP_GRENADES;
	// JOSEPH 16-APR-99
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "Heavy machinegun"))
		ent->client->clip_index = CLIP_SLUGS;
	// END JOSEPH
	*/
	//Sed,snap
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "desert"))
		ent->client->clip_index = CLIP_DESERT;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "bomb"))
		ent->client->clip_index = CLIP_BOMB;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "uzi"))
		ent->client->clip_index = CLIP_UZI;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "mp5"))
		ent->client->clip_index = CLIP_MP5;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "defuse"))
		ent->client->clip_index = CLIP_DEFUSE;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "awsm"))
		ent->client->clip_index = CLIP_AWP;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "msg90"))
		ent->client->clip_index = CLIP_MSG90;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "m4a1"))
		ent->client->clip_index = CLIP_M4A1;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "dragunov"))
		ent->client->clip_index = CLIP_DRAG;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "molotov"))
		ent->client->clip_index = CLIP_MOLOTOV;
	else if (!strcmp(ent->client->pers.weapon->pickup_name, "grenade"))
		ent->client->clip_index = CLIP_GRENADE;
}


int QweryClipIndex (gitem_t *item)
{
	
	if (!strcmp(item->pickup_name, "Pipe"))
		return CLIP_NONE;
	else if (!strcmp(item->pickup_name, "Crowbar"))
		return CLIP_NONE;
	else if (!strcmp(item->pickup_name, "Pistol"))
		return CLIP_PISTOL;
	else if (!strcmp(item->pickup_name, "SPistol"))
		return CLIP_PISTOL;
	else if (!strcmp(item->pickup_name, "Shotgun"))
		return CLIP_SHOTGUN;
	// snap - old stuff
	/*
	else if (!strcmp(item->pickup_name, "Tommygun"))
		return CLIP_TOMMYGUN;
	else if (!strcmp(item->pickup_name, "FlameThrower"))
		return CLIP_FLAMEGUN;
	else if (!strcmp(item->pickup_name, "Bazooka"))
		return CLIP_ROCKETS;
	else if (!strcmp(item->pickup_name, "Grenade Launcher"))
		return CLIP_GRENADES;
	// JOSEPH 16-APR-99
	else if (!strcmp(item->pickup_name, "Heavy machinegun"))
		return CLIP_SLUGS;
	// END JOSEPH
	*/
	//Sed, snap
	else if (!strcmp(item->pickup_name, "desert"))
		return CLIP_DESERT;
	else if (!strcmp(item->pickup_name, "bomb"))
		return CLIP_BOMB;
	else if (!strcmp(item->pickup_name, "mp5"))
		return CLIP_MP5;
	else if (!strcmp(item->pickup_name, "uzi"))
		return CLIP_UZI;
	else if (!strcmp(item->pickup_name, "defuse"))
		return CLIP_DEFUSE;
	else if (!strcmp(item->pickup_name, "awsm"))
		return CLIP_AWP;
	else if (!strcmp(item->pickup_name, "msg90"))
		return CLIP_MSG90;
	else if (!strcmp(item->pickup_name, "m4a1"))
		return CLIP_M4A1;
	else if (!strcmp(item->pickup_name, "dragunov"))
		return CLIP_DRAG;
	else if (!strcmp(item->pickup_name, "molotov"))
		return CLIP_MOLOTOV;
	else if (!strcmp(item->pickup_name, "grenade"))
		return CLIP_GRENADE;
	return (0);
}

/*
===============
ChangeWeapon

The old weapon has been dropped all the way, so make the new one
current
===============
*/
void ChangeWeapon (edict_t *ent)
{
	int i;

	// snap - don't need this anymore
	/*
	if (ent->client->grenade_time)
	{
		ent->client->grenade_time = level.time;
		ent->client->weapon_sound = 0;
		weapon_grenade_fire (ent, false);
		ent->client->grenade_time = 0;
	}
*/
	ent->client->pers.lastweapon = ent->client->pers.weapon;
	ent->client->pers.weapon = ent->client->newweapon;
	ent->client->newweapon = NULL;
//	ent->client->machinegun_shots = 0;

	// set visible model
	if (ent->s.modelindex == 255) {
		if (ent->client->pers.weapon)
			i = (((QweryClipIndex(ent->client->pers.weapon)+1) & 0xff) << 8);
		else
			i = 0;
		ent->s.skinnum = (ent - g_edicts - 1) | i;
	}

	if (ent->client->pers.weapon && ent->client->pers.weapon->ammo)
		ent->client->ammo_index = ITEM_INDEX(FindItem(ent->client->pers.weapon->ammo));
	else
		ent->client->ammo_index = 0;

	if (!ent->client->pers.weapon)
	{	// dead
		ent->client->ps.gunindex = 0;
		return;
	}

	ent->client->weaponstate = WEAPON_ACTIVATING;
	ent->client->ps.gunframe = 0;
	
	// ent->client->flashlight = false;

	// RAFAEL	28-dec-98
	ent->client->gun_noise = false;
	
	if (ent->client->pers.weapon)
		ChangeClipIndex (ent);
	
	{
		int i;
	
		if (!strcmp (ent->client->pers.weapon->pickup_name , "SPistol"))
		{
			if (ent->client->pers.pistol_mods & WEAPON_MOD_DAMAGE)
				ent->client->ps.gunindex = gi.modelindex("models/weapons/silencer_mdx/magnum.mdx");
			else
				ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);
		}
		else if (!strcmp (ent->client->pers.weapon->pickup_name , "Pistol"))
		{
//			if (ent->client->pers.pistol_mods & WEAPON_MOD_DAMAGE)
//				ent->client->ps.gunindex = gi.modelindex("models/weapons/v_colt/magnum.mdx");
//			else
				ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);
		}
		else if (!strcmp (ent->client->pers.weapon->pickup_name, "Shotgun"))
			ent->client->ps.gunindex = gi.modelindex("models/weapons/shotgun/shotgun.mdx");
		else if (!strcmp (ent->client->pers.weapon->pickup_name, "Heavy machinegun"))
		{
//			if (ent->client->pers.pistol_mods & WEAPON_MOD_COOLING_JACKET)
				ent->client->ps.gunindex = gi.modelindex("models/weapons/v_hmgcool/hmgcool.mdx");
//			else
//				ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);
		}
		else
			ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);

		memset(&(ent->client->ps.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);
		ent->client->ps.num_parts = 0;

		ent->client->ps.num_parts++;
		// ent->client->ps.model_parts[PART_HEAD].modelindex = gi.modelindex(ent->client->pers.weapon->view_model);
		ent->client->ps.model_parts[PART_HEAD].modelindex = ent->client->ps.gunindex;//gi.modelindex(ent->client->pers.weapon->view_model);
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			ent->client->ps.model_parts[PART_HEAD].skinnum[i] = 0; // will we have more than one skin???

		// HACK, set arm model
		if (!strcmp(ent->client->pers.weapon->pickup_name, "Shotgun"))
		{
			// Ridah, HACK: changed this to use PART_LEGS, since PART_BODY sometimes doesn't show up
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/shotgun/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		}
		// JOSEPH 12-OCT-98
		// JOSEPH 5-FEB-99-B
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "Pipe"))
		{
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/blakjak/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
		}
		// END JOSEPH
		// JOSEPH 19-JAN-99
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "Crowbar"))
		{
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/crowbar/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
		}
		// END JOSEPH
/*
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "FlameThrower"))
		{
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_flamegun/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
		}
		// END JOSEPH
		// JOSEPH 4-MAR-99
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "Bazooka"))
		{
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_rocket_launcher/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_rocket_launcher/shell_a.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???		

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_GUN2].modelindex = gi.modelindex("models/weapons/v_rocket_launcher/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_GUN2].skinnum[i] = 0; // will we have more than one skin???		
		}
		// END JOSEPH
		*/
		else if (!strcmp (ent->client->pers.weapon->pickup_name , "SPistol"))
		{
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/silencer_mdx/handl.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
			
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/silencer_mdx/handr.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_GUN].modelindex = gi.modelindex("models/weapons/silencer_mdx/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_GUN].skinnum[i] = 0;

			ent->client->ps.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);
		}
		else if (!strcmp (ent->client->pers.weapon->pickup_name , "Pistol"))
		{
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_colt/handl.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
			
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_colt/handr.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_GUN].modelindex = gi.modelindex("models/weapons/v_colt/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_GUN].skinnum[i] = 0;
		}
		/*
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "Tommygun"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_tomgun/lhand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_tomgun/rhand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}
		// JOSEPH 16-APR-99
		else if (!strcmp (ent->client->pers.weapon->pickup_name , "Heavy machinegun"))
		{
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_hmg/lhand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_hmg/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
			
		}
		// END JOSEPH
		else if (!strcmp (ent->client->pers.weapon->pickup_name , "Grenade Launcher"))
		{
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_grenade_launcher/lhand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_grenade_launcher/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
		}
		*/
		//Sed
		else if (!strcmp (ent->client->pers.weapon->pickup_name , "desert"))
		{
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_de/hands.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
			
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_de/hands.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
	
		}
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "mp5"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_mp5/mp5.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_mp5/mp5.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "uzi"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_uzi/uzi.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_uzi/uzi.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}
		//Sed end
		//snap
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "awsm"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_awp/v_awp.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_awp/v_awp.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "msg90"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_msg90/hands.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_msg90/hands.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "m4a1"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_m4/v_m4.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_m4/v_m4.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "dragunov"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_dragunov/v_dragunov.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_dragunov/v_dragunov.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "molotov"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_molotov/molotov.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_molotov/molotov.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "grenade"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_grenade/v_grenade.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_grenade/v_grenade.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		}
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "bomb"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_c4/v_c4.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_c4/v_c4.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}
		else if (!strcmp(ent->client->pers.weapon->pickup_name, "defuse"))
		{
			// Ridah, hacked this, we're still having disappearing hands after going from the Pistol ?!
			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_CIGAR].modelindex = gi.modelindex("models/weapons/v_deactivator/pliers.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_CIGAR].skinnum[i] = 0; // will we have more than one skin???

			ent->client->ps.num_parts++;
			ent->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_deactivator/pliers.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				ent->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		
		}

	}

//	ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);
/*
#if 0
	ent->client->anim_priority = ANIM_PAIN;
	if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
		int rnd;

		rnd = rand()%3;

		if (rnd==0)
		{
			ent->s.frame = FRAME_crouch_pain1_01;
			ent->client->anim_end = FRAME_crouch_pain1_08;
		}
		else if (rnd==1)
		{
			ent->s.frame = FRAME_crouch_pain2_01;
			ent->client->anim_end = FRAME_crouch_pain2_06;
		}
		else if (rnd==2)
		{
			ent->s.frame = FRAME_crouch_pain3_01;
			ent->client->anim_end = FRAME_crouch_pain3_06;
		}
	}
	else
	{
		int rnd;

		rnd = rand()%6;

		switch (rnd)
		{
		case 0:
			ent->s.frame = FRAME_pain_Rarm_01;
			ent->client->anim_end = FRAME_pain_Rarm_10;
			break;
		case 1:
			ent->s.frame = FRAME_pain_Larm_01;
			ent->client->anim_end = FRAME_pain_Larm_09;
			break;
		case 2:
			ent->s.frame = FRAME_pain_chest_01;
			ent->client->anim_end = FRAME_pain_chest_09;
			break;
		case 3:
			ent->s.frame = FRAME_pain_head_01;
			ent->client->anim_end = FRAME_pain_head_10;
			break;
		case 4:
			ent->s.frame = FRAME_pain_Rleg_01;
			ent->client->anim_end = FRAME_pain_Rleg_10;
			break;
		case 5:
			ent->s.frame = FRAME_pain_Lleg_01;
			ent->client->anim_end = FRAME_pain_Lleg_08;
			break;
		}

	}

#endif
 */
}

/*
=================
NoAmmoWeaponChange
=================
*/
// snap - added the new weapons here
void NoAmmoWeaponChange (edict_t *ent)
{


	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("m4a1Ammo"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("m4a1"))] )
	{
		ent->client->newweapon = FindItem ("m4a1");
		return;
	}

	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("dragAmmo"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("dragunov"))] )
	{
		ent->client->newweapon = FindItem ("dragunov");
		return;
	}

	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("mp5Ammo"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("mp5"))] )
	{
		ent->client->newweapon = FindItem ("mp5");
		return;
	}

	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("uziAmmo"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("uzi"))] )
	{
		ent->client->newweapon = FindItem ("uzi");
		return;
	}

	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("Shells"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("Shotgun"))] )
	{
		ent->client->newweapon = FindItem ("shotgun");
		return;
	}

	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("msg90Ammo"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("msg90"))] )
	{
		ent->client->newweapon = FindItem ("msg90");
		return;
	}

	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("awsmAmmo"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("awsm"))] )
	{
		ent->client->newweapon = FindItem ("awsm");
		return;
	}
			
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("Bullets"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("Pistol"))] )
	{
		ent->client->newweapon = FindItem ("pistol");
		return;
	}

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("molotov"))] )
	{
		ent->client->newweapon = FindItem ("molotov");
		return;
	}

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("grenade"))] )
	{
		ent->client->newweapon = FindItem ("grenade");
		return;
	}

	// JOSEPH 5-FEB-99-B
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("crowbar"))])
		ent->client->newweapon = FindItem ("Crowbar");
	else	
		ent->client->newweapon = FindItem ("Pipe");
	// END JOSEPH




	// snap - here are the old weapons

	// JOSEPH 16-APR-99
/*	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("308cal"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("heavy machinegun"))] )
	{
		ent->client->newweapon = FindItem ("heavy machinegun");
		return;
	}
	// END JOSEPH

	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("Bazooka"))] )
	{
		ent->client->newweapon = FindItem ("Bazooka");
		return;
	}

	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("Grenade Launcher"))] )
	{
		ent->client->newweapon = FindItem ("grenade launcher");
		return;
	}
	
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("Bullets"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("Tommygun"))] )
	{
		ent->client->newweapon = FindItem ("tommygun");
		return;
	}
	if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("gas"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("flamethrower"))] )
	{
		ent->client->newweapon = FindItem ("flamethrower");
		return;
	}
*/	
}


/*
Think_FlashLight
*/
void Think_FlashLight (edict_t *ent)
{

	trace_t tr;
	vec3_t	forward;
	vec3_t	end;
	vec3_t	mins, maxs;
	edict_t	*light;
	vec3_t	angles, origin;

	if (ent->health < 1)
		return;

	if (ent->client->flashlight)
	{
		VectorCopy (ent->client->v_angle, angles);
		VectorCopy (ent->s.origin, origin);
		AngleVectors (angles, forward, NULL, NULL);
		VectorCopy (origin, end);
		VectorMA (end, 8194, forward, end);

		VectorSet (mins, -8, -8, -8 );
		VectorSet (maxs, 8, 8, 8);

		tr = gi.trace (ent->s.origin, mins, maxs, end, ent, MASK_SHOT);

		if (((tr.ent) && (tr.ent->s.renderfx2 & RF2_SURF_ALPHA)) || ((tr.contents & MASK_ALPHA))) 
		{
			vec3_t	start;
			VectorCopy (tr.endpos, start);
			VectorMA (start, 8, forward, start);
			tr = gi.trace (start, mins, maxs, end, ent, MASK_SHOT);
		}

		light = G_Spawn();
		VectorCopy (tr.endpos, light->s.origin);
		light->s.renderfx |= RF_BEAM;
		light->s.effects |= EF_FLASHLIGHT;
		light->nextthink = level.time + 0.1;
		light->think = G_FreeEdict;
		gi.linkentity (light);
	}


}

/*
=================
Think_Weapon

Called by ClientBeginServerFrame and ClientThink
=================
*/		
void Think_Weapon (edict_t *ent)
{
	// make sure flamethrower is disabled when it should be
	ent->s.renderfx2 &= ~RF2_FLAMETHROWER;

	// if just died, put the weapon away
	if (ent->health < 1)
	{
		ent->client->newweapon = NULL;
		ChangeWeapon (ent);
	}
	
	// JOSEPH 10-FEB-99
	if (level.bar_lvl)
		return;
	// END JOSEPH

	// Unholster a holstered gun if fired 
	if ((!ent->client->pers.weapon) && ent->client->pers.holsteredweapon && (((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK)))
	{
		ent->client->newweapon = ent->client->pers.holsteredweapon;
		ChangeWeapon (ent);
		ent->client->pers.holsteredweapon = 0;
	}
	else if (ent->client->pers.weapon && ent->client->pers.weapon->weaponthink)
	{
		is_quad = (ent->client->quad_framenum > level.framenum);
		// RAFAEL
		is_quadfire = (ent->client->quadfire_framenum > level.framenum);
		//if (ent->client->pers.silencer_shots)
		//	is_silenced = MZ_SILENCED;
		//else
		is_silenced = 0;
		ent->client->pers.weapon->weaponthink (ent);
	}

}


/*
================
Use_Weapon

Make the weapon ready if there is ammo
================
*/
void Use_Weapon (edict_t *ent, gitem_t *item)
{
	int			ammo_index;
	gitem_t		*ammo_item;
	int			clip_index;

	// see if we're already using it
	if (item == ent->client->pers.weapon)
		return;

// snap, disabled this (MH: reinstated)
	if (item->ammo && !g_select_empty->value && !(item->flags & IT_AMMO))
	{
		ammo_item = FindItem(item->ammo);
		ammo_index = ITEM_INDEX(ammo_item);
		
		clip_index = QweryClipIndex (item);

		if (!ent->client->pers.inventory[ammo_index] && !ent->client->pers.weapon_clip [clip_index])
		{
			cprintf (ent, PRINT_HIGH, "No %s for %s.\n", ammo_item->pickup_name, item->pickup_name);
			return;
		}
		
	//	if (ent->client->pers.inventory[ammo_index] < item->quantity)
	//	{
	//		cprintf (ent, PRINT_HIGH, "Not enough %s for %s.\n", ammo_item->pickup_name, item->pickup_name);
	//		return;
	//	}
		
	}

	// change to this weapon when down
	ent->client->newweapon = item;
}

// RAFAEL 14-APR-98
void Use_Weapon2 (edict_t *ent, gitem_t *item)
{
	int			ammo_index;
	gitem_t		*ammo_item;
	int			index;
	int			clip_index;


	// JOSEPH 5-FEB-99-B
	if (strcmp (item->pickup_name, "Pipe") == 0)
	{
		// Ridah, changed this so it defaults to Crowbar if we have it
		if (ent->client->pers.weapon != FindItem ("Crowbar"))
		{
			item = FindItem ("Crowbar");
			index = ITEM_INDEX (item);
			if (!ent->client->pers.inventory[index])
			{
				item = FindItem ("Pipe");
			}
		}
	}
	// END JOSEPH

	else if (strcmp (item->pickup_name, "Pistol") == 0)
	{
		if (item == ent->client->pers.weapon)
		{
			item = FindItem ("SPistol");
			index = ITEM_INDEX (item);
			if (!ent->client->pers.inventory[index])
			{
				item = FindItem ("Pistol");
			}
		}
	}
	
	
	// see if we're already using it
	if (item == ent->client->pers.weapon)
		return;
	
// snap, disabled this (MH: reinstated)
	if (item->ammo)
	{
		ammo_item = FindItem(item->ammo);
		ammo_index = ITEM_INDEX(ammo_item);
		clip_index = QweryClipIndex (item);

		if (!ent->client->pers.inventory[ammo_index] && !g_select_empty->value && !ent->client->pers.weapon_clip [clip_index])
		{
			cprintf (ent, PRINT_HIGH, "No %s for %s.\n", ammo_item->pickup_name, item->pickup_name);
			return;
		}
	}

	// change to this weapon when down
	ent->client->newweapon = item;
	
}
// END 14-APR-98

/*
================
Drop_Weapon
================
*/
void Drop_Weapon (edict_t *ent, gitem_t *item)
{
	int		index;

/*	if ((int)(dmflags->value) & DF_WEAPONS_STAY)
		return;
*/
	//Sed
	if (ent->crashType == CRASH_VIP)
	{
		gi.cprintf (ent, PRINT_HIGH, "Can't drop things in vip mode!\n");
		return;
	}
	//Sed end

	index = ITEM_INDEX(item);
	// see if we're already using it
	if ( ((item == ent->client->pers.weapon) || (item == ent->client->newweapon))&& (ent->client->pers.inventory[index] == 1) )
	{
		cprintf (ent, PRINT_HIGH, "Can't drop current weapon\n");
		return;
	}

	Drop_Item (ent, item);
	ent->client->pers.inventory[index]--;
}


/*
================
Weapon_Generic

A generic function to handle the basics of weapon thinking
================
*/

#define FRAME_FIRE_FIRST		(FRAME_ACTIVATE_LAST + 1)
#define FRAME_IDLE_FIRST		(FRAME_FIRE_LAST + 1)
#define FRAME_DEACTIVATE_FIRST	(FRAME_IDLE_LAST + 1)

#define FRAME_OFFSET_FOR_SPISTOL	43
#define FRAME_OFFSET_FOR_SPISTOL_WITH_SILENCER 70

void Weapon_Generic (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int *fire_frames, void (*fire)(edict_t *ent))
{
	int		n;
// RAFAEL 01-11-99


	if (ent->client->weaponstate ==	WEAPON_RELOADING_SPISTOL)
	{
		if (ent->client->ps.gunframe == FRAME_OFFSET_FOR_SPISTOL)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = FRAME_IDLE_FIRST;
			return;
		}

		ent->client->ps.gunframe++;
		return;
	}

	if (ent->client->weaponstate ==	WEAPON_RELOADING)
	{
		if (ent->client->ps.gunframe == FRAME_FIRE_LAST)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = FRAME_IDLE_FIRST;
			return;
		}

		ent->client->ps.gunframe++;
		return;
	}

	if (ent->client->weaponstate == WEAPON_RELOAD_CYCLE)
	{
		/*
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = FRAME_IDLE_FIRST;		
		}
		else
		*/
		{
			ent->client->ps.gunframe++;
			return;
		}
	}

	if (ent->client->weaponstate == WEAPON_DROPPING)
	{
		if (ent->client->pers.weapon == FindItem("SPistol"))
		{
			if (ent->client->pers.silencer_shots && ent->client->ps.gunframe == FRAME_OFFSET_FOR_SPISTOL_WITH_SILENCER)
			{
				ChangeWeapon (ent);
				return;
			}
			if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST)
			{
				ChangeWeapon (ent);
				return;
			}
		}
		else
		{
			if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST)
			{
				ChangeWeapon (ent);
				return;
			}
			else if ((ent->client->weaponstate != WEAPON_FIRING) && (ent->client->ps.gunframe < FRAME_DEACTIVATE_FIRST))
			{
				ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST;
				return;
			}
		}
/*
		else if ((FRAME_DEACTIVATE_LAST - ent->client->ps.gunframe) == 4)
		{
			ent->client->anim_priority = ANIM_REVERSE;
			if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crpain4+1;
				ent->client->anim_end = FRAME_crpain1;
			}
			else
			{
				ent->s.frame = FRAME_pain304+1;
				ent->client->anim_end = FRAME_pain301;
				
			}
		}
*/
		ent->client->ps.gunframe++;

		// Ridah, faster weapon changing in deathmatch
		if (deathmatch->value && ent->client->ps.gunframe < FRAME_DEACTIVATE_LAST)
			ent->client->ps.gunframe++;

		return;
	}

	if (ent->client->weaponstate == WEAPON_ACTIVATING)
	{
		if (ent->client->ps.gunframe == FRAME_ACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = FRAME_IDLE_FIRST;
			return;
		}

		ent->client->ps.gunframe++;

		// Ridah, faster weapon changing in deathmatch
		if (deathmatch->value && ent->client->ps.gunframe < FRAME_ACTIVATE_LAST)
			ent->client->ps.gunframe++;

		return;
	}
	
	if ((ent->client->newweapon) /*&& (ent->client->weaponstate != WEAPON_FIRING)*/)
	{
		ent->client->weaponstate = WEAPON_DROPPING;
		ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST;
/*
		if ((FRAME_DEACTIVATE_LAST - FRAME_DEACTIVATE_FIRST) < 4)
		{
			ent->client->anim_priority = ANIM_REVERSE;
			if(ent->client->ps.pmove.pm_flags & PMF_DUCKED)
			{
				ent->s.frame = FRAME_crpain4+1;
				ent->client->anim_end = FRAME_crpain1;
			}
			else
			{
				ent->s.frame = FRAME_pain304+1;
				ent->client->anim_end = FRAME_pain301;
				
			}
		}
*/
		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			
			if (ent->client->clip_index == CLIP_PISTOL && ent->client->pers.weapon_clip[ent->client->clip_index] >= 1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			else if (ent->client->clip_index == CLIP_SHOTGUN && ent->client->pers.weapon_clip[ent->client->clip_index] >= 1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
/*			else if (ent->client->clip_index == CLIP_TOMMYGUN && ent->client->pers.weapon_clip[ent->client->clip_index] >=1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			else if (ent->client->clip_index == CLIP_SLUGS && ent->client->pers.weapon_clip[ent->client->clip_index] >=1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			else if (ent->client->clip_index == CLIP_GRENADES && ent->client->pers.weapon_clip[ent->client->clip_index] >=1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			else if (ent->client->clip_index == CLIP_ROCKETS && ent->client->pers.weapon_clip[ent->client->clip_index] >=1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
*/
			// snap, new weaps
			else if (ent->client->clip_index == CLIP_DESERT && ent->client->pers.weapon_clip[ent->client->clip_index] >= 1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			else if (ent->client->clip_index == CLIP_UZI && ent->client->pers.weapon_clip[ent->client->clip_index] >=1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			else if (ent->client->clip_index == CLIP_MP5 && ent->client->pers.weapon_clip[ent->client->clip_index] >=1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			else if (ent->client->clip_index == CLIP_AWP && ent->client->pers.weapon_clip[ent->client->clip_index] >=1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			else if (ent->client->clip_index == CLIP_MSG90 && ent->client->pers.weapon_clip[ent->client->clip_index] >=1)
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			// end new weaps
			else if ((!ent->client->ammo_index) || 
				( ent->client->pers.inventory[ent->client->ammo_index] >= ent->client->pers.weapon->quantity))
			{
				ent->client->ps.gunframe = FRAME_FIRE_FIRST;
				ent->client->weaponstate = WEAPON_FIRING;
			}
			else 
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
		}
		else
		{
			if (ent->client->ps.gunframe == FRAME_IDLE_LAST)
			{
				ent->client->ps.gunframe = FRAME_IDLE_FIRST;
				return;
			}

			if (pause_frames)
			{
				for (n = 0; pause_frames[n]; n++)
				{
					if (ent->client->ps.gunframe == pause_frames[n])
					{
						if (rand()&15)
							return;
					}
				}
			}

			ent->client->ps.gunframe++;
			return;
		}
	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{
		for (n = 0; fire_frames[n]; n++)
		{
			if (ent->client->ps.gunframe == fire_frames[n])
			{
				if (ent->client->quad_framenum > level.framenum)
					gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage3.wav"), 1, ATTN_NORM, 0);
/*
				if (ent->client->anim_priority <= ANIM_JUMP 
					&& (!ent->groundentity || (!ent->client->anim_run && !ent->client->anim_slide)))
				{
					// start the animation
					ent->client->anim_priority = ANIM_ATTACK;
					if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
					{
						if (ent->s.frame != FRAME_crch_shoot_01)
							ent->s.frame = FRAME_crch_shoot_01-1;
						ent->client->anim_end = FRAME_crch_shoot_05;
					}
					else
					{
						if (ent->s.frame != FRAME_shoot_01)
							ent->s.frame = FRAME_shoot_01-1;
						ent->client->anim_end = FRAME_shoot_04;
					}
				}
*/
				fire (ent);
				break;
			}
		}

		if (!fire_frames[n])
			ent->client->ps.gunframe++;

		// JOSEPH 5-FEB-99-B
		// Blackjack hack
        if ((ent->client->ps.gunframe == 9) &&
			(!((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK)) &&
			(!strcmp(ent->client->pers.weapon->pickup_name, "Pipe")))
		{
			ent->client->ps.gunframe = FRAME_IDLE_FIRST+1;
			ent->client->weaponstate = WEAPON_READY;
		}
		// END JOSEPH

		// JOSEPH 19-JAN-99
		// Crowbar hack
        else if ((ent->client->ps.gunframe == 9) &&
			(!((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK)) &&
			(!strcmp(ent->client->pers.weapon->pickup_name, "Crowbar")))
		{
			ent->client->ps.gunframe = FRAME_IDLE_FIRST+1;
			ent->client->weaponstate = WEAPON_READY;
		}
		// END JOSEPH

		if (ent->client->ps.gunframe == FRAME_IDLE_FIRST+1)
			ent->client->weaponstate = WEAPON_READY;
	}
}

// snap - we have models with different frame seqs!

void New_Weapon_Generic (edict_t *ent, int act_first, int act_last, int fire_first, int fire_last, int reload_first, int reload_last, int idle_first, int idle_last, int hide_first, int hide_last, int max_rounds)
{
	int rounds;



	switch(ent->client->weaponstate){
		case WEAPON_RELOADING:
			if (ent->client->ps.gunframe == reload_last){
				ent->client->pers.inventory[ent->client->ammo_index] += ent->client->pers.weapon_clip[ent->client->clip_index];	
				if (ent->client->pers.inventory[ent->client->ammo_index] < max_rounds)
					rounds = ent->client->pers.inventory[ent->client->ammo_index];
				else 
					rounds = max_rounds;
				ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
				ent->client->pers.inventory[ent->client->ammo_index] -= rounds;

				ent->client->weaponstate = WEAPON_READY;
				ent->client->ps.gunframe = idle_first;
			}
			else
				ent->client->ps.gunframe++;
			break;
		case WEAPON_DROPPING:
			if (ent->client->ps.gunframe == hide_last)
				ChangeWeapon (ent);
			else if ((ent->client->weaponstate != WEAPON_FIRING) && (ent->client->ps.gunframe < hide_first))
				ent->client->ps.gunframe = hide_first;
			else
				ent->client->ps.gunframe++;
			break;
		case WEAPON_ACTIVATING:
			if (ent->client->ps.gunframe == act_last){
				ent->client->weaponstate = WEAPON_READY;
				ent->client->ps.gunframe = idle_first;
			}
			else
				ent->client->ps.gunframe++;
			break;
		case WEAPON_READY:
			//newstuff
			if ((!ent->client->pers.weapon_clip[ent->client->clip_index] && ent->client->pers.inventory[ent->client->ammo_index]) || ent->client->reload_weapon){
				if(ent->client->pers.weapon_clip[ent->client->clip_index] < auto_rounds[ent->client->clip_index]
					&& ent->client->clip_index != CLIP_GRENADE && ent->client->clip_index != CLIP_MOLOTOV
					&& ent->client->clip_index != CLIP_DEFUSE && ent->client->clip_index != CLIP_BOMB){
					ent->client->ps.gunframe = reload_first;
					ent->client->weaponstate = WEAPON_RELOADING;
					killscope2(ent);
				}
				ent->client->reload_weapon = false;
			}
			else if (ent->client->newweapon){
				ent->client->weaponstate = WEAPON_DROPPING;
				ent->client->ps.gunframe = hide_first;
				killscope2(ent);
			}
			else if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) && ent->waterlevel < 2){
				ent->client->latched_buttons &= ~BUTTON_ATTACK;	
				if (ent->client->pers.weapon_clip[ent->client->clip_index] >=1 || ent->client->clip_index == CLIP_GRENADE || ent->client->clip_index == CLIP_MOLOTOV){  // molotov doesnt use ammo
					ent->client->ps.gunframe = fire_first;
					ent->client->weaponstate = WEAPON_FIRING;
				}
				else {
					if (level.time >= ent->pain_debounce_time){
						gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
						ent->pain_debounce_time = level.time + 1;
					}
					NoAmmoWeaponChange (ent);
				}	
			}
			else{
				if (ent->client->ps.gunframe == idle_last)
					ent->client->ps.gunframe = idle_first;
				else
					ent->client->ps.gunframe++;
			}
			break;
		case WEAPON_FIRING:
			if(ent->client->ps.gunframe == fire_last){
				if(((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) && ent->waterlevel < 2 && ent->client->pers.weapon_clip[ent->client->clip_index] >=1){
					ent->client->ps.gunframe = fire_first;
					ent->client->weaponstate = WEAPON_FIRING;
					if(ent->recoiltime < 8){
						ent->recoiltime++;
					}
				}
				else{
					ent->client->ps.gunframe = idle_first;
					ent->client->weaponstate = WEAPON_READY;
					ent->recoiltime = 1;
				}
			}
			else
				ent->client->ps.gunframe++;
			break;
		default:
			break;
	}

}

// snap, not using this
//======================================================================

//GRENADE

//======================================================================
/*

#define GRENADE_TIMER		3.0
#define GRENADE_MINSPEED	400
#define GRENADE_MAXSPEED	800

void weapon_grenade_fire (edict_t *ent, qboolean held)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
	int		damage = 125;
	float	timer;
	int		speed;
	float	radius;

	radius = damage+40;
	if (is_quad)
		damage *= 4;

	VectorSet(offset, 8, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	timer = ent->client->grenade_time - level.time;
	speed = GRENADE_MINSPEED + (GRENADE_TIMER - timer) * ((GRENADE_MAXSPEED - GRENADE_MINSPEED) / GRENADE_TIMER);
	fire_grenade2 (ent, start, forward, damage, speed, timer, radius, held);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
		ent->client->pers.inventory[ent->client->ammo_index]--;

	ent->client->grenade_time = level.time + 1.0;

}

void Weapon_Grenade (edict_t *ent)
{
	if ((ent->client->newweapon) && (ent->client->weaponstate == WEAPON_READY))
	{
		ChangeWeapon (ent);
		return;
	}

	if (ent->client->weaponstate == WEAPON_ACTIVATING)
	{
		ent->client->weaponstate = WEAPON_READY;
		ent->client->ps.gunframe = 16;
		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			if (ent->client->pers.inventory[ent->client->ammo_index])
			{
				ent->client->ps.gunframe = 1;
				ent->client->weaponstate = WEAPON_FIRING;
				ent->client->grenade_time = 0;
			}
			else
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
			return;
		}

		if ((ent->client->ps.gunframe == 29) || (ent->client->ps.gunframe == 34) || (ent->client->ps.gunframe == 39) || (ent->client->ps.gunframe == 48))
		{
			if (rand()&15)
				return;
		}

		if (++ent->client->ps.gunframe > 48)
			ent->client->ps.gunframe = 16;
		return;
	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{
		if (ent->client->ps.gunframe == 5)
			gi.sound(ent, CHAN_WEAPON, gi.soundindex("weapons/grenade_launcher/hgrena1b.wav"), 1, ATTN_NORM, 0);

		if (ent->client->ps.gunframe == 11)
		{
			if (!ent->client->grenade_time)
			{
				ent->client->grenade_time = level.time + GRENADE_TIMER + 0.2;
				ent->client->weapon_sound = gi.soundindex("weapons/grenade_launcher/hgrenc1b.wav");
			}

			// they waited too long, detonate it in their hand
			if (!ent->client->grenade_blew_up && level.time >= ent->client->grenade_time)
			{
				ent->client->weapon_sound = 0;
				weapon_grenade_fire (ent, true);
				ent->client->grenade_blew_up = true;
			}

			if (ent->client->buttons & BUTTON_ATTACK)
				return;

			if (ent->client->grenade_blew_up)
			{
				if (level.time >= ent->client->grenade_time)
				{
					ent->client->ps.gunframe = 15;
					ent->client->grenade_blew_up = false;
				}
				else
				{
					return;
				}
			}
		}

		if (ent->client->ps.gunframe == 12)
		{
			ent->client->weapon_sound = 0;
			weapon_grenade_fire (ent, false);
		}

		if ((ent->client->ps.gunframe == 15) && (level.time < ent->client->grenade_time))
			return;

		ent->client->ps.gunframe++;

		if (ent->client->ps.gunframe == 16)
		{
			ent->client->grenade_time = 0;
			ent->client->weaponstate = WEAPON_READY;
		}
	}
}



// JOSEPH 18-DEC-98
void Think_Eject_Shell (edict_t *ent)
{
	if (!ent->misstime--)
	{	
		ent->nextthink = 0;
		G_FreeEdict(ent);
	}
	else
	{

		if (ent->misstime <= 20)
		{
			if (ent->misstime == 20)
			{
				ent->s.renderfx2 |= RF2_PASSALPHA;
				ent->s.effects = 1;		// this is full alpha now
			}
			
			ent->s.effects += (255/20);
		
			if (ent->s.effects > 255)
				ent->s.effects = 255;
		}

		ent->s.angles[0] += ent->avelocity[0];
		ent->s.angles[1] += ent->avelocity[1];
		ent->s.angles[2] += ent->avelocity[2];
		ent->nextthink = level.time + 0.1;
	}
}
// END JOSEPH
*/
// end snap


// JOSEPH 7-JAN-99
void Eject_Shotgun_Shell (edict_t *ent)
{
// snap, not using this
/*	edict_t	*dropped = NULL;
	vec3_t	forward, right, up;
	vec3_t	offset;

	if (!(ent->client))
		return;

	if (deathmatch->value)
		return;

	//gi.dprintf("angles = %s\n", vtos(ent->s.angles));

	dropped = G_Spawn();
	
	if (!dropped)
		return;

	dropped->s.modelindex = gi.modelindex("models/weapons/sshell_md2/tris.md2");
		
	dropped->movetype = MOVETYPE_BOUNCE;
	
	dropped->mins[0] = -4;
	dropped->mins[1] = -4;
	dropped->mins[2] = -2;
	
	dropped->maxs[0] =  4;
	dropped->maxs[1] =  4;
	dropped->maxs[2] =  4;

	AngleVectors (ent->client->v_angle, forward, right, up);

	dropped->s.angles[YAW] = ent->client->v_angle[YAW];

	VectorSet(offset, 0, 16, ent->viewheight -2 );


	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, dropped->s.origin);

	VectorScale (forward, 5 + ((rand()&15)-8), dropped->velocity);
    VectorMA (dropped->velocity, 50 + (rand()&31), right, dropped->velocity);
	dropped->velocity[2] = 150 + (rand()&31);

	// Ridah, changed this so they don't stick in the ground so much
	VectorSet(dropped->avelocity, 0, ((rand()&15)-8), ((rand()&7)-4));

	dropped->think = Think_Eject_Shell;
	dropped->misstime = 40;
	dropped->nextthink = level.time + 0.1;

	dropped->s.renderfx2 |= RF2_NOSHADOW;

	gi.linkentity (dropped);

	return;
	*/
}
// END JOSEPH




//======================================================================



// JOSEPH 12-OCT-98
void Blackjack_Hit (edict_t *ent, vec3_t vorigin, int damage)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			kick = 2;
	vec3_t		offset;

	if (is_quad)
		damage *= 4;
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	
	VectorSet(offset, 0, 0, ent->viewheight);
	
	VectorAdd (offset, vorigin, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	if (fire_blackjack (ent, start, forward, damage, kick, MOD_BLACKJACK))
		ent->client->ps.weapon_usage++;

	if (ent->client->ps.weapon_usage > 20)
	{
		ent->client->ps.rdflags &= ~RDF_SKINPLUS;
		ent->client->ps.rdflags |= RDF_SKINPLUSPLUS;
	}
	else if (ent->client->ps.weapon_usage > 10)
		ent->client->ps.rdflags |= RDF_SKINPLUS;
	
	
//	PlayerNoise(ent, start, PNOISE_WEAPON);

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_BLACKJACK_SWING);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
}

void Weapon_Blackjack_Hit (edict_t *ent)
{
	int		damage;

	if (deathmatch->value)
		damage = 10;
	else
		damage = 8;// - (int)(skill->value-1);

	Blackjack_Hit (ent, vec3_origin, damage); 
   	ent->client->ps.gunframe++;	
}

void Weapon_Blackjack (edict_t *ent)
{
	static int	pause_frames[]	= {0, 0};
	static int	fire_frames[]	= {8, 11, 0};
	
	
	if (ent->client->ps.gunframe < 5)
	{
		ent->client->ps.rdflags &= ~RDF_SKINPLUS;
		ent->client->ps.rdflags &= ~RDF_SKINPLUSPLUS;
	}
	
	Weapon_Generic (ent, 5, 13, 31, 36, pause_frames, fire_frames, Weapon_Blackjack_Hit);

	ent->client->ps.model_parts[PART_BODY].invisible_objects = 0;
	
}
// END JOSEPH

// JOSEPH 19-JAN-99
void Crowbar_Hit (edict_t *ent, vec3_t vorigin, int damage)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			kick = 2;
	vec3_t		offset;

	if (is_quad)
		damage *= 4;
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	
	VectorSet(offset, 0, 0, ent->viewheight);
	
	VectorAdd (offset, vorigin, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	if (fire_crowbar (ent, start, forward, damage, kick, MOD_CROWBAR))
		ent->client->ps.weapon_usage++;

	if (ent->client->ps.weapon_usage > 20)
	{
		ent->client->ps.rdflags &= ~RDF_SKINPLUS;
		ent->client->ps.rdflags |= RDF_SKINPLUSPLUS;
	}
	else if (ent->client->ps.weapon_usage > 10)
		ent->client->ps.rdflags |= RDF_SKINPLUS;
	
	
//	PlayerNoise(ent, start, PNOISE_WEAPON);

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_CROWBAR_SWING);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
}

void Weapon_Crowbar_Hit (edict_t *ent)
{
	int		damage;

	if (deathmatch->value)
		damage = 50;	// This should be very powerful in deathmatch
	else
		damage = 12;// - (int)(skill->value-1);

	Crowbar_Hit (ent, vec3_origin, damage); 
   	ent->client->ps.gunframe++;	
}

void Weapon_Crowbar (edict_t *ent)
{
	static int	pause_frames[]	= {0, 0};
	static int	fire_frames[]	= {8, 11, 0};
	
	
	if (ent->client->ps.gunframe < 5)
	{
		ent->client->ps.rdflags &= ~RDF_SKINPLUS;
		ent->client->ps.rdflags &= ~RDF_SKINPLUSPLUS;
	}
	
	Weapon_Generic (ent, 5, 13, 31, 36, pause_frames, fire_frames, Weapon_Crowbar_Hit);

	ent->client->ps.model_parts[PART_BODY].invisible_objects = 0;
	
}
// END JOSEPH 



// JOSEPH 7-JAN-99
void Eject_Pistol_Shell (edict_t *ent)
{
	// snap, not using this
/*	edict_t	*dropped = NULL;
	vec3_t	forward, right, up;
	vec3_t	offset;

	if (!(ent->client))
		return;

	if (deathmatch->value)
		return;

	//gi.dprintf("angles = %s\n", vtos(ent->s.angles));

	dropped = G_Spawn();
	
	if (!dropped)
		return;

	dropped->s.modelindex = gi.modelindex("models/weapons/shell_md2/tris.md2");
		
	dropped->movetype = MOVETYPE_BOUNCE;

	dropped->mins[0] = -4;
	dropped->mins[1] = -4;
	dropped->mins[2] = -2;
	
	dropped->maxs[0] =  4;
	dropped->maxs[1] =  4;
	dropped->maxs[2] =  4;

	AngleVectors (ent->client->v_angle, forward, right, up);

	dropped->s.angles[YAW] = ent->client->v_angle[YAW];

//	VectorSet(offset, 0, 16, ent->viewheight -2 );
// snap, changed position closer to gun
	VectorSet(offset, 8, 11, ent->viewheight -6 );

	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, dropped->s.origin);

	VectorScale (forward, 5 + ((rand()&15)-8), dropped->velocity);
    VectorMA (dropped->velocity, 50 + (rand()&31), right, dropped->velocity);
	dropped->velocity[2] = 150 + (rand()&31);

	// Ridah, changed this so they don't stick in the ground so much
	VectorSet(dropped->avelocity, 0, ((rand()&15)-8), ((rand()&7)-4));
	
	dropped->think = Think_Eject_Shell;
	dropped->misstime = 40;
	dropped->nextthink = level.time + 0.1;

	dropped->s.renderfx2 |= RF2_NOSHADOW;

	gi.linkentity (dropped);

	return;
	*/
}

// JOSEPH 7-JAN-99
// ============
void Eject_Tommy_Shell (edict_t *ent)
{
// snap, not using this
/*	edict_t	*dropped = NULL;
	vec3_t	forward, right, up;
	vec3_t	offset;

	if (!(ent->client))
		return;

	if (deathmatch->value)
		return;

	//gi.dprintf("angles = %s\n", vtos(ent->s.angles));

	dropped = G_Spawn();

	if (!dropped)
		return;
	
	dropped->s.modelindex = gi.modelindex("models/weapons/shell_md2/tris.md2");
		
	dropped->movetype = MOVETYPE_BOUNCE;
	
	dropped->mins[0] = -4;
	dropped->mins[1] = -4;
	dropped->mins[2] = -2;
	
	dropped->maxs[0] =  4;
	dropped->maxs[1] =  4;
	dropped->maxs[2] =  4;

	AngleVectors (ent->client->v_angle, forward, right, up);

	dropped->s.angles[YAW] = ent->client->v_angle[YAW];

//	VectorSet(offset, 0, 16, ent->viewheight -2 );
// snap, changed position closer to gun
	VectorSet(offset, 5, 11, ent->viewheight -6 );

	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, dropped->s.origin);

	VectorScale (forward, 5 + ((rand()&15)-8), dropped->velocity);
    VectorMA (dropped->velocity, 50 + (rand()&31), right, dropped->velocity);
	dropped->velocity[2] = 150 + (rand()&31);

	// Ridah, changed this so they don't stick in the ground so much
	VectorSet(dropped->avelocity, 0, ((rand()&15)-8), ((rand()&7)-4));

	dropped->think = Think_Eject_Shell;
//	dropped->misstime = 40;
	dropped->misstime = 10;
	dropped->nextthink = level.time + 0.1;
	
	dropped->s.renderfx2 |= RF2_NOSHADOW;

	gi.linkentity (dropped);

	return;
	*/
}
// END JOSEPH
/*********************************************************************
======================================================================

                 NEW CRASH SQUAD WEAPONS / MODES

======================================================================
*********************************************************************/

//===============
//    DESERT
//===============
//Sed DE fire
void Desert_Fire (edict_t *ent, vec3_t vorigin, int damage)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			kick = 2;
	vec3_t		offset;

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	
	VectorSet(offset, 0, 0, ent->viewheight);
	
	VectorAdd (offset, vorigin, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);


    if (ent->client->ps.pmove.pm_flags & PMF_DUCKED || level.framenum > ent->move_frame+5){
		//snap - normal fire
		 ent->client->kick_angles[0] = 0;
	     fire_bullet (ent, start, forward, damage, kick, 40, 80, MOD_DESERT);
	}
	else{
		//snap - less accurate than normal
		 ent->client->kick_angles[0] = -6;
	     fire_bullet (ent, start, forward, damage, kick, 360, 720, MOD_DESERT);
	}

		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (ent-g_edicts);
		gi.WriteByte (MZ_SSHOTGUN | is_silenced);
		gi.multicast (ent->s.origin, MULTICAST_PVS);

	
		PlayerNoise(ent, start, PNOISE_WEAPON);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
	{
		ent->client->pers.weapon_clip[ent->client->clip_index]--;
	}

	ent->client->gun_noise = true;

}
//Sed end
//Sed DE fire
// snap, fixed this 
void Weapon_Desert_Fire (edict_t *ent)
{
	int		damage;
	int		rounds;
	
	damage = 50;

	if (ent->waterlevel >= 2)
	{
		if (ent->client->weaponstate == WEAPON_FIRING)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = 28;
		}
		return;
	}

	if (ent->client->ps.gunframe == 6)
	{
		Desert_Fire (ent, vec3_origin, damage); 
//		Eject_Pistol_Shell(ent);
		ent->client->ps.gunframe++;
	}
	else if (ent->client->ps.gunframe == 8)
	{
		ent->client->ps.gunframe = 28;
	}

	else if (ent->client->ps.gunframe == 9)
	{
		if (!ent->client->pers.weapon_clip[ent->client->clip_index])
		{
			
			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_DESERT_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_DESERT_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			ent->client->ps.gunframe++;	

			if (! ent->client->pers.weapon_clip[ent->client->clip_index])
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
		}
		else
			ent->client->ps.gunframe = 28;
	}
	else
		ent->client->ps.gunframe++;

}
//Sed end
//Sed DE
void Weapon_Desert (edict_t *ent)
{
	int		rounds;
	static int	pause_frames[]	= {0, 0};
	static int	fire_frames[]	= {6, 8, 0};

	if (ent->client->reload_weapon)
	{
		if (ent->client->ps.gunframe >= 27 && ent->client->ps.gunframe <= 43)
		{
			if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_DESERT_ROUNDS)
			{
				ent->client->ps.gunframe = 9;
				ent->client->weaponstate = WEAPON_RELOADING;
				
				ent->client->pers.inventory[ent->client->ammo_index] += ent->client->pers.weapon_clip[ent->client->clip_index];	

				if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_DESERT_ROUNDS)
				{
					rounds = ent->client->pers.inventory[ent->client->ammo_index];
				}
				else 
					rounds = MAX_DESERT_ROUNDS;

				ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
				ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			}

			ent->client->reload_weapon = false;
		}
		else
			ent->client->reload_weapon = false;
	}
	else if (!ent->client->pers.weapon_clip[ent->client->clip_index] && ent->client->pers.inventory[ent->client->ammo_index])
	{
		if (ent->client->ps.gunframe >= 27 && ent->client->ps.gunframe <= 43)
		{
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 9;
			ent->client->weaponstate = WEAPON_RELOADING;

			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_DESERT_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_DESERT_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
		}
	}
	
	if (ent->client->ps.gunframe == 9)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/desert/desert_reload.wav"), 1, ATTN_NORM, 0);

	Weapon_Generic (ent, 5, 27, 43, 48, pause_frames, fire_frames, Weapon_Desert_Fire);

}
//Sed end
//===============
// END DESERT
//===============


//===============
//   MP-5
//===============
void Mp5_Fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			damage;
	int			kick = 2;
	vec3_t		offset;

	damage = 25;

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorScale (forward, -3, ent->client->kick_origin);

	VectorSet(offset, 0, 0,  ent->viewheight-1);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	//snap
	apply_kick(ent, ent->recoiltime);
	fire_bullet (ent, start, forward, damage, kick, 30*ent->recoiltime, 30*ent->recoiltime, MOD_MP5);

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_PISTOL | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	PlayerNoise(ent, start, PNOISE_WEAPON);


	ent->client->pers.weapon_clip [ent->client->clip_index]--;


	ent->client->gun_noise = true;
}

void Weapon_Mp5 (edict_t *ent)
{

	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
	}

	if (ent->client->ps.gunframe == 11 || ent->client->ps.gunframe == 12)
		Mp5_Fire (ent);
	else if (ent->client->ps.gunframe == 13)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/mp5/mp5reloading.wav"), 1, ATTN_NORM, 0);

/*
0-10 Pick up
11-12 Fire
13-30 Reload
31-65 Idle
66-69 hide
*/
	New_Weapon_Generic (ent, 0, 10, 11, 12, 13, 30, 31, 65, 66, 69, MAX_MP5_ROUNDS);

}



//===============
//   END MP-5
//===============


//===============
//     UZI
//===============
void Uzi_Fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			damage;
	int			kick = 2;
	vec3_t		offset;

	damage = 25;

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorScale (forward, -3, ent->client->kick_origin);

	VectorSet(offset, 0, 0,  ent->viewheight-1);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	//snap
	apply_kick(ent, ent->recoiltime);
	fire_bullet (ent, start, forward, damage, kick, 30*ent->recoiltime, 30*ent->recoiltime, MOD_UZI);

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_HYPERBLASTER | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	PlayerNoise(ent, start, PNOISE_WEAPON);


	ent->client->pers.weapon_clip [ent->client->clip_index]--;


	ent->client->gun_noise = true;
}

void Weapon_Uzi (edict_t *ent)
{

	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
	}

	if (ent->client->ps.gunframe == 10 || ent->client->ps.gunframe == 11)
		Uzi_Fire (ent);
	else if (ent->client->ps.gunframe == 12)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/uzi/uzi_reload1.wav"), 1, ATTN_NORM, 0);

/*
0-9  pick up
10-11 shoot
12-29 reload
30-64 idle
65-68 hide(putaway)
*/
	New_Weapon_Generic (ent, 0, 9, 10, 11, 12, 29, 30, 64, 65, 68, MAX_UZI_ROUNDS);

}


//===============
//    END UZI
//===============
//Sed end UZI

//===============
//    BOMB
//===============
/*
================
Snap - new function  ********** FIXME ********** get rid of this..
Needed for weapon models that have different frame sequence
================
*/

void Weapon_Bomb_Frames (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, int FRAME_FIRE_FIRST_NEW, int FRAME_IDLE_FIRST_NEW, int FRAME_DEACTIVATE_FIRST_NEW)
{
	int		n;


	if (ent->client->weaponstate == WEAPON_DROPPING)
	{

		if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST)
		{
			ChangeWeapon (ent);
			return;
		}
		else if ((ent->client->weaponstate != WEAPON_FIRING) && (ent->client->ps.gunframe < FRAME_DEACTIVATE_FIRST_NEW))
		{
			ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST_NEW;
			return;
		}

		ent->client->ps.gunframe++;

		// Ridah, faster weapon changing in deathmatch
		if (deathmatch->value && ent->client->ps.gunframe < FRAME_DEACTIVATE_LAST)
			ent->client->ps.gunframe++;

		return;
	}

	if (ent->client->weaponstate == WEAPON_ACTIVATING)
	{
		if (ent->client->ps.gunframe == FRAME_ACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = FRAME_IDLE_FIRST_NEW;
			return;
		}

		ent->client->ps.gunframe++;

		// Ridah, faster weapon changing in deathmatch
		if (deathmatch->value && ent->client->ps.gunframe < FRAME_ACTIVATE_LAST)
			ent->client->ps.gunframe++;

		return;
	}
	
	if ((ent->client->newweapon) /*&& (ent->client->weaponstate != WEAPON_FIRING)*/)
	{
		ent->client->weaponstate = WEAPON_DROPPING;
		ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST_NEW;

		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			
			ent->client->ps.gunframe = 13;
			ent->client->weaponstate = WEAPON_FIRING;
			
		}

		else
		{
			if (ent->client->ps.gunframe == FRAME_IDLE_LAST)
			{
				ent->client->ps.gunframe = FRAME_IDLE_FIRST_NEW;
				return;
			}

			if (pause_frames)
			{
				for (n = 0; pause_frames[n]; n++)
				{
					if (ent->client->ps.gunframe == pause_frames[n])
					{
						if (rand()&15)
							return;
					}
				}
			}

			ent->client->ps.gunframe++;
			return;
		}
	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{

		if((ent->at_target_frame > (level.framenum - 5)) && ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) ){


			if (ent->client->ps.gunframe == 13){
				ent->activate_bomb_frame = level.framenum;
				ent->client->ps.gunframe = 14;
			}
			else if (ent->client->ps.gunframe == 14)
				ent->client->ps.gunframe = 15;
			else if (ent->client->ps.gunframe == 15)
				ent->client->ps.gunframe = 16;
			else if (ent->client->ps.gunframe == 16 && ((level.framenum - ent->activate_bomb_frame) >= 40) ){ // MH: reduced from 100
				gitem_t		*item;
				edict_t		*drop;
				int			index;
				edict_t		*player;
				int			number;

				item = FindItem("bomb"); 
				index = ITEM_INDEX(item);
				ent->client->pers.inventory[index]--;

				drop = Drop_Item_Notoss (ent, item);
				drop->spawnflags = DROPPED_PLAYER_ITEM;
				drop->armed = TRUE;
				level.bomb_activated = TRUE;
				drop->armframe = level.framenum;
				drop->soundframe = level.framenum + 30; // MH: reduced from 50

				ent->crashType = CRASH_NORMAL;
				ent->client->showscores = NO_SCOREBOARD;
				ent->client->resp.scoreboard_frame = 0; // MH: trigger scoreboard update instead of calling DeathmatchScoreboard
				NoAmmoWeaponChange (ent);
		
				for_each_player(player, number)
				{
					gi.cprintf(player, PRINT_CHAT, "> The BOMB Has Been Planted!\n"); // MH: removed newline
					RadioSound(player, "crash/planted.wav"); // MH: "bomb planted" radio message
				}
			}
			else if(ent->client->showscores != SCORE_BOMB) // MH: only update scoreboard if not already showing
			{
				ent->client->showscores = SCORE_BOMB;
				ent->client->resp.scoreboard_frame = 0; // MH: trigger scoreboard update instead of calling DeathmatchScoreboard
			}
		}
		else{
			if((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK)
				gi.centerprintf(ent,"you must crouch\nand plant the bomb\nat the bomb target"); // MH: removed newline
			if (ent->client->showscores == SCORE_BOMB) // MH: only reset scoreboard if were planting
			{
				ent->client->showscores = NO_SCOREBOARD;
				ent->client->resp.scoreboard_frame = 0; // MH: trigger scoreboard update instead of calling DeathmatchScoreboard
			}
			ent->client->ps.gunframe = 4;
			ent->client->weaponstate = WEAPON_READY;
		}

	}
}

void Weapon_Bomb (edict_t *ent)
{
	static int	pause_frames[]	= {0, 0};

	Weapon_Bomb_Frames (ent, 3, 16, 12, 20, pause_frames, 13, 4, 17);

}
//=================
//   END BOMB
//=================

//===============
//    DEFUSE KIT
//===============
/*
================
Snap - new function *********FIXME***** - use new weap gen. funct.
Needed for weapon models that have different frame sequence
================
*/
void Weapon_Defuse (edict_t *ent)
{
						   
	int FRAME_ACTIVATE_LAST = 5;
	int FRAME_FIRE_LAST = 10;
	int FRAME_DEACTIVATE_LAST = 15;
	int FRAME_FIRE_FIRST_NEW = 7;
	int FRAME_IDLE_FIRST_NEW = 6;
	int FRAME_DEACTIVATE_FIRST_NEW = 11;

	if (ent->client->weaponstate == WEAPON_DROPPING)
	{

		if (ent->client->ps.gunframe == FRAME_DEACTIVATE_LAST)
		{
			ChangeWeapon (ent);
			return;
		}
		else if ((ent->client->weaponstate != WEAPON_FIRING) && (ent->client->ps.gunframe < FRAME_DEACTIVATE_FIRST_NEW))
		{
			ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST_NEW;
			return;
		}

		ent->client->ps.gunframe++;

		// Ridah, faster weapon changing in deathmatch
		if (deathmatch->value && ent->client->ps.gunframe < FRAME_DEACTIVATE_LAST)
			ent->client->ps.gunframe++;

		return;
	}

	if (ent->client->weaponstate == WEAPON_ACTIVATING)
	{
		if (ent->client->ps.gunframe == FRAME_ACTIVATE_LAST)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = FRAME_IDLE_FIRST_NEW;
			return;
		}

		ent->client->ps.gunframe++;

		// Ridah, faster weapon changing in deathmatch
		if (deathmatch->value && ent->client->ps.gunframe < FRAME_ACTIVATE_LAST)
			ent->client->ps.gunframe++;

		return;
	}
	
	if ((ent->client->newweapon) /*&& (ent->client->weaponstate != WEAPON_FIRING)*/)
	{
		ent->client->weaponstate = WEAPON_DROPPING;
		ent->client->ps.gunframe = FRAME_DEACTIVATE_FIRST_NEW;

		return;
	}

	if (ent->client->weaponstate == WEAPON_READY)
	{
		if ( ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK) )
		{
			ent->client->latched_buttons &= ~BUTTON_ATTACK;
			
			ent->client->ps.gunframe = 7;
			ent->client->weaponstate = WEAPON_FIRING;
			
		}

		else
			return;

	}

	if (ent->client->weaponstate == WEAPON_FIRING)
	{

		if((ent->deactivate_frame > (level.framenum - 5)) && ((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK)
			&& (ent->client->ps.pmove.pm_flags & PMF_DUCKED)){ // MH: need to crouch to defuse (like planting)

			if (ent->client->ps.gunframe == 7){
				ent->activate_bomb_frame = level.framenum;
				ent->client->ps.gunframe = 8;
			}
			else if (ent->client->ps.gunframe == 8)
				ent->client->ps.gunframe = 9;
			else if (ent->client->ps.gunframe == 9){
				gi.sound(ent, CHAN_VOICE, gi.soundindex("world/c4_deac1.wav"), 1, ATTN_NORM, 0);
				ent->client->ps.gunframe = 10;
			}
			else if (ent->client->ps.gunframe == 10 && ((level.framenum - ent->activate_bomb_frame) >= 70) ){ // MH: reduced from 100

				edict_t		*player;
				int			number;

				ent->client->showscores = NO_SCOREBOARD;
				ent->client->resp.scoreboard_frame = 0; // MH: trigger scoreboard update instead of calling DeathmatchScoreboard
				NoAmmoWeaponChange (ent);
				
				level.defused = TRUE;
				
				for_each_player(player, number)
				{
					gi.cprintf(player, PRINT_CHAT, "> The BOMB Has Been Defused!\n"); // MH: removed newline
				}
			}
			else{
				if(ent->client->showscores != SCORE_BOMB)
				{
					ent->client->showscores = SCORE_BOMB;
					ent->client->resp.scoreboard_frame = 0; // MH: trigger scoreboard update instead of calling DeathmatchScoreboard
				}
				
			}

		}
		else{
			if((ent->client->latched_buttons|ent->client->buttons) & BUTTON_ATTACK)
				gi.centerprintf(ent,"you must crouch over\nan armed bomb"); // MH: crouch notice
			if (ent->client->showscores == SCORE_BOMB) // MH: only reset scoreboard if were defusing
			{
				ent->client->showscores = NO_SCOREBOARD;
				ent->client->resp.scoreboard_frame = 0; // MH: trigger scoreboard update instead of calling DeathmatchScoreboard
			}
			ent->client->ps.gunframe = 6;
			ent->client->weaponstate = WEAPON_READY;
		}

	}
}

// ================
//  END DEFUSE
// ================

//===============
//   AWSM
//===============
//Snap
/*
Animations
----------
0-5 Lift up
6-24 Shoot (fire)
25-51 Reload 
52-55 Idle
56-59 Hide (putaway)
*/
void AWP_Fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			damage;
	int			kick = 20;
	vec3_t		offset;

/*	if(ent->scope){
		damage = 150;
	}
	else{
		damage = 50;
	}*/
	damage = 150; // MH: scope doesn't affect damage

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorScale (forward, -3, ent->client->kick_origin);

	VectorSet(offset, 0, 0,  ent->viewheight-1);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

    if (ent->client->ps.pmove.pm_flags & PMF_DUCKED || level.framenum > ent->move_frame+5){
		ent->client->kick_angles[0] = -4;
        fire_bullet (ent, start, forward, damage, kick, 0, 0, MOD_AWP);
	}
	else{
		//snap - less accurate than normal
		ent->client->kick_angles[0] = -20;
		damage = (int)damage/2;
		fire_bullet (ent, start, forward, damage, kick, 1000, 1000, MOD_AWP);
	}

	ent->client->ps.gunframe++;  // hack to make frames look better

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_ROCKET | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	PlayerNoise(ent, start, PNOISE_WEAPON);

	ent->client->pers.weapon_clip [ent->client->clip_index]--;

	ent->client->gun_noise = true;
}

void Weapon_AWP (edict_t *ent)
{

	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
	}

	if (ent->client->ps.gunframe == 6)
		AWP_Fire (ent);
	else if (ent->client->ps.gunframe == 25)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/awsm/awsmre.wav"), 1, ATTN_NORM, 0);
/*
0-5 Lift up
6-24 Shoot (fire)
25-51 Reload 
52-55 Idle
56-59 Hide (putaway)
*/
	New_Weapon_Generic (ent, 0, 5, 6, 24, 25, 51, 52, 55, 56, 59, MAX_AWP_ROUNDS);


}

//===============
//   END AWSM
//===============
//===============
//   MSG90
//===============
//Snap
void MSG90_Fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			damage;
	int			kick = 20;
	vec3_t		offset;

	if(ent->scope){
		damage = 150;
	}
	else{
		damage = 50;
	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorScale (forward, -3, ent->client->kick_origin);

	VectorSet(offset, 0, 0,  ent->viewheight-1);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

    if (ent->client->ps.pmove.pm_flags & PMF_DUCKED || level.framenum > ent->move_frame+5){
		ent->client->kick_angles[0] = -4;
        fire_bullet (ent, start, forward, damage, kick, 0, 0, MOD_MSG90);
	}
	else{
		//snap - less accurate than normal
		ent->client->kick_angles[0] = -20;
		damage = (int)damage/2;
		fire_bullet (ent, start, forward, damage, kick, 1000, 1000, MOD_MSG90);
	}


	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_MACHINEGUN | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	PlayerNoise(ent, start, PNOISE_WEAPON);

	ent->client->pers.weapon_clip [ent->client->clip_index]--;


	Eject_Pistol_Shell(ent);

	ent->client->gun_noise = true;


}

void Weapon_MSG90 (edict_t *ent)
{

	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
	}

	if(ent->client->ps.gunframe == 14)
		MSG90_Fire(ent);
	else if(ent->client->ps.gunframe == 17)
		ent->client->ps.gunframe++;  // hack to make equal to awsm
	else if(ent->client->ps.gunframe == 33)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/msg90/msg90re.wav"), 1, ATTN_NORM, 0);


	/*
draw		 0 - 13
fire		14 - 32
reload		33 - 59
idle		60 - 62
holster		63 - 65
*/
	New_Weapon_Generic (ent, 0, 13, 14, 32, 33, 59, 60, 62, 63, 65, MAX_MSG90_ROUNDS);

}

//===============
//   END MSG90
//===============
//===============
//   m4a1
//===============
void m4a1_Fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			damage;
	int			kick = 4;
	vec3_t		offset;

	damage = 30;

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorScale (forward, -3, ent->client->kick_origin);

	VectorSet(offset, 0, 0,  ent->viewheight-1);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	apply_kick(ent, ent->recoiltime);
	fire_bullet (ent, start, forward, damage, kick, 30*ent->recoiltime, 30*ent->recoiltime, MOD_M4A1);

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_SPISTOL | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	PlayerNoise(ent, start, PNOISE_WEAPON);


	ent->client->pers.weapon_clip [ent->client->clip_index]--;


	ent->client->gun_noise = true;
}

void Weapon_m4a1 (edict_t *ent)
{

	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
	}

	if (ent->client->ps.gunframe == 7 || ent->client->ps.gunframe == 8)
		m4a1_Fire (ent);

	else if (ent->client->ps.gunframe == 10)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/m4a1/m4a1reloading.wav"), 1, ATTN_NORM, 0);
/*

Animations
----------
0-5 Lift up
6-9 Shoot
10-23 Reload
24-27 Idle
28-31 Putaway*/

	New_Weapon_Generic (ent, 0, 5, 7, 8, 10, 23, 24, 25, 28, 31, MAX_M4A1_ROUNDS);

}


//===============
//   dragunov
//===============
void drag_Fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			damage;
	int			kick = 4;
	vec3_t		offset;

	damage = 30;

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorScale (forward, -3, ent->client->kick_origin);

	VectorSet(offset, 0, 0,  ent->viewheight-1);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	apply_kick(ent, ent->recoiltime);
	fire_bullet (ent, start, forward, damage, kick, 30*ent->recoiltime, 30*ent->recoiltime, MOD_DRAG);

	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_BARMACHINEGUN | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);


	PlayerNoise(ent, start, PNOISE_WEAPON);


	ent->client->pers.weapon_clip [ent->client->clip_index]--;


	ent->client->gun_noise = true;
}

void Weapon_drag (edict_t *ent)
{

	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
	}

	if (ent->client->ps.gunframe == 7 || ent->client->ps.gunframe == 8)
		drag_Fire (ent);

	else if (ent->client->ps.gunframe == 10)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/dragunov/dragreloading.wav"), 1, ATTN_NORM, 0);
/*

Animations
----------
0-5 Lift up
6-9 Shoot
10-19 Reload
20-24 Idle
25-28 Putaway*/

	New_Weapon_Generic (ent, 0, 5, 7, 8, 10, 19, 20, 24, 25, 28, MAX_DRAG_ROUNDS);

}


//===============
//   hand grenade
//===============
static void Grenade_Explode (edict_t *ent)
{
	vec3_t		origin, vec;
	int			mod;
	trace_t		tr;

	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	if (ent->enemy == ent->owner)
		ent->enemy = NULL;

	if (ent->spawnflags & 2)
		mod = MOD_HELD_GRENADE;
	else if (ent->spawnflags & 1)
		mod = MOD_HG_SPLASH;
	else
		mod = MOD_G_SPLASH;
	
	T_RadiusDamage(ent, ent->owner, ent->dmg, ent->enemy, ent->dmg_radius, mod);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);

	// Ridah, trace a line to this "origin" to make sure it isn't in a solid (in which case the explosion won't show)
	if (!VectorCompare( ent->velocity, vec3_origin))
	{
		tr = gi.trace( ent->s.origin, NULL, NULL, origin, ent, MASK_SOLID );
		if (tr.fraction < 1)
			VectorCopy(ent->s.origin, origin);
	}

	gi.WriteByte (svc_temp_entity);

	if (!ent->enemy)
	{
		VectorClear( vec );
		vec[2] = 1;
	}
	else
	{
		VectorSubtract( ent->s.origin, ent->enemy->s.origin, vec );
		VectorNormalize( vec );
	}

	if (ent->waterlevel)
	{
		gi.WriteByte (TE_CONCUSSION_EXPLOSION_WATER);
	}
	else
	{
		gi.WriteByte (TE_CONCUSSION_EXPLOSION_BIG);
	}
	gi.WritePosition (origin);
	gi.WriteDir( vec );
	gi.WriteByte( (int)(ent->dmg) );
	gi.multicast (ent->s.origin, MULTICAST_PHS);

	G_FreeEdict (ent);
}
// END JOSEPH

// JOSEPH
static void Grenade_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	
	if (other == ent->owner)
		return;

	if (other->takedamage)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

	if (surf && (surf->flags & SURF_ALPHA))
	{
		// Grenade gets stuck in alpha surface
		if (!(crandom() < .85))
        {
			ent->gravity = 0; 
			VectorClear (ent->velocity);
			VectorClear (ent->avelocity);
			return;
		}
	}

	if (!other->takedamage)
	{
		VectorSet (ent->avelocity, crandom()*500, crandom()*500, crandom()*500);

		if ((rand()%100) > 66)
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenade_launcher/grenade bounce1.wav"), 1, ATTN_NORM, 0);
		else if ((rand()%100) > 50)
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenade_launcher/grenade bounce2.wav"), 1, ATTN_NORM, 0);
		else
			gi.sound (ent, CHAN_VOICE, gi.soundindex ("weapons/grenade_launcher/grenade bounce3.wav"), 1, ATTN_NORM, 0);

		// Ridah, Grenade Avoidance: notify AI of our existance
		AI_AvoidDangerousEntity( ent );
		// done.

		// MH: add a shadow when it hits the ground
		if (plane && plane->normal[2] > 0.5)
			ent->s.renderfx2 &= ~RF2_NOSHADOW;

		return;
	}

	ent->enemy = other;
	Grenade_Explode (ent);
}
// END JOSEPH


void fire_grenade (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int speed, float timer, float damage_radius)
{
	edict_t	*grenade;
	vec3_t	dir;
	vec3_t	forward, right, up;

	vectoangles (aimdir, dir);
	AngleVectors (dir, forward, right, up);

	grenade = G_Spawn();
	VectorCopy (start, grenade->s.origin);
//	VectorCopy (aimdir, grenade->movedir);
//	vectoangles (aimdir, grenade->s.angles);
	VectorScale (aimdir, speed, grenade->velocity);



	grenade->movetype = MOVETYPE_BOUNCE;

	grenade->clipmask = MASK_SHOT;
	grenade->solid = SOLID_BBOX;
	grenade->s.effects |= EF_ROTATE;
	// MH: stop grenade sinking into surfaces
	VectorSet(grenade->mins, -2, -2, -2);
	VectorSet(grenade->maxs, 2, 2, 2);

	grenade->s.modelindex = gi.modelindex ("models/weapons/v_grenade/thrown3.mdx"); // MH: fixed model

	grenade->owner = self;
	grenade->touch = Grenade_Touch;

	grenade->nextthink = level.time + timer;
	grenade->think = Grenade_Explode;

	grenade->dmg = damage;
	grenade->dmg_radius = damage_radius;
	grenade->classname = "grenade";

	grenade->s.renderfx2 |= RF2_NOSHADOW;	
	grenade->s.renderfx  |= RF_REFL_MAP;

	// Ridah, Grenade Avoidance: notify AI of our existance

		AI_AvoidDangerousEntity( self);

	// done.

	gi.linkentity (grenade);
	add_ent_to_array(grenade);
}

// MH: speed option added for throw or drop
void grenade_Fire (edict_t *ent, int speed)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
	int		damage;
	float	radius;
	float	timer;


	damage = 175;	
	radius = 550.0; // MH: reduced from 700
	timer = 1.0;

	VectorSet(offset, 16, 8, ent->viewheight-4);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

//	VectorScale (forward, -2, ent->client->kick_origin); // MH: removed (no kickback from throwing)

	fire_grenade (ent, start, forward, damage, speed, timer, radius);

	PlayerNoise(ent, start, PNOISE_WEAPON);

	ent->client->gun_noise = true;

}

void Weapon_grenade (edict_t *ent)
{
	gitem_t		*item;
	int			index;

    if(ent->client->ps.gunframe == 18){
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/grenade/pin.wav"), 1, ATTN_NORM, 0);
	}
	else if(ent->client->ps.gunframe == 26){
		grenade_Fire (ent, 800); // MH: release grenade with speed=800 (raised from 750)
		// take away one of the client's grenades
		item = FindItem("grenade");
		index = ITEM_INDEX(item);
		ent->client->pers.inventory[index]--;
	}
	else if(ent->client->ps.gunframe == 29){
		NoAmmoWeaponChange (ent);
		ChangeWeapon (ent);	
	}
	// MH: pull the pin sooner (skip frames)
	if (ent->client->ps.gunframe == 7 || (ent->client->ps.gunframe >= 10 && ent->client->ps.gunframe < 17))
		ent->client->ps.gunframe++;
/*

Animations
----------
0-6 Lift up
7-22 PullPin 
23-29 Throw
30-33 Idle
34-37 Putaway
void New_Weapon_Generic (edict_t *ent, int act_first, int act_last, int fire_first, int fire_last, int reload_first, int reload_last, int idle_first, int idle_last, int hide_first, int hide_last, int max_rounds)
{	
	*/

	New_Weapon_Generic (ent, 0, 6, 7, 29, 30, 30, 6, 6, 34, 37, 0);

}




//===============
//   molotov cocktail
//===============

// MH: added for molotov flame damage
static void molotovflame_Touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (self->timestamp > level.time)
		return;

	self->timestamp = level.time + FRAMETIME;

	T_Damage (other, other, self->owner, vec3_origin, other->s.origin, vec3_origin, self->dmg, self->dmg, 0, MOD_FLAMETHROWER);	
}

void ThrowFlamingStuff (edict_t *self, char *modelname, float speed, vec3_t origin)
{
	edict_t	*chunk;
	vec3_t	v;

	// MH: modified (flames now cause damage, and reduced velocity)
	chunk = G_Spawn();
	VectorCopy (origin, chunk->s.origin);
	gi.setmodel (chunk, modelname);
	v[0] = crandom();
	v[1] = crandom();
	v[2] = 0.2 + fabs(crandom()) * 0.5;
	VectorScale(self->velocity, 0.5, chunk->velocity);
	chunk->velocity[2] = 0;
	VectorMA (chunk->velocity, speed, v, chunk->velocity);
	chunk->movetype = MOVETYPE_TOSS;
	chunk->think = G_FreeEdict;
	chunk->nextthink = level.time + 3 + random()*2;
	chunk->s.frame = 0;
	chunk->flags = 0;
    chunk->s.renderfx2 |= RF2_NOSHADOW;

	chunk->touch = molotovflame_Touch;
	chunk->dmg = 4;
	chunk->owner = self->owner;
	chunk->solid = SOLID_TRIGGER;
	VectorSet(chunk->mins, -16, -16, 0);
	VectorSet(chunk->maxs, 16, 16, 24);

	chunk->s.effects |= EF_FLAMETHROWER;  //snap, new
	gi.linkentity (chunk);
}

float find_distance (edict_t *ent, vec3_t org)
{
	vec3_t	eorg;
	int		j;
	
	for (j=0 ; j<3 ; j++)
		eorg[j] = org[j] - (ent->s.origin[j] + (ent->mins[j] + ent->maxs[j])*0.5);

	return VectorLength(eorg);

}

void molotov_Explode (edict_t *ent)
{
	vec3_t		origin, vec;
	trace_t		tr;
	edict_t	*e = NULL;
	float	dist, dmg;
	int w;

	if (!ent->waterlevel){

		while (e = findradius(e, ent->s.origin, ent->dmg_radius))
		{
			if (e->client)
			{
				// MH: ramped damage instead of 4 bands
				dist = VectorDistance(e->s.origin, ent->s.origin);
				dmg = 1.3 - (dist / ent->dmg_radius) * 1.2;
				if (dmg > 1)
					dmg = 1;
				dmg *= ent->radius_dmg;
				// MH: check if already more on fire
				if (e->onfiretime >= dmg)
					continue;
				// MH: check not blocked by door/etc
				if (!CanDamage(e, ent))
					continue;
				e->onfiretime = dmg;

				e->onfireent = ent->owner;
				// MH: don't scream if not much damage
				if (dmg >= 15)
				{
					e->pain_debounce_time = level.time + 5;
					if (e->gender == GENDER_FEMALE){
						if (e->health > 80)
							Voice_Specific (e, e->owner, female_specific, 8);
						else if (e->health > 40)
							Voice_Specific (e, e->owner, female_specific, 7);
						else
							Voice_Specific (e, e->owner, female_specific, 6);
					}
					else if (e->gender == GENDER_MALE){
						if (e->health > 80)
							Voice_Specific (e, e->owner, male_specific, 12);
						else if (e->health > 40)
							Voice_Specific (e, e->owner, male_specific, 11);
						else
							Voice_Specific (e, e->owner, male_specific, 10);
					}
				}
			}
		}

		{
			// MH: make sure there's space for the flame
			vec3_t mins, maxs;
			VectorSet(mins, -16, -16, 0);
			VectorSet(maxs, 16, 16, 24);
			VectorMA (ent->s.origin, -FRAMETIME, ent->velocity, origin);
			tr = gi.trace( origin, mins, maxs, ent->s.origin, ent, MASK_SOLID );
			VectorCopy(tr.endpos, origin);
		}

		// MH: changed speed
		for	(w=0; w<15; w++)
			ThrowFlamingStuff(ent, "models/props/glass/glass2.md2", w ? 300 : 0, origin);

		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/molotov/explode.wav"), 1, ATTN_NORM, 0);
	}
	else
		gi.sound(ent, CHAN_VOICE, gi.soundindex("world/glasbrk.wav"), 1, ATTN_NORM, 0);

	G_FreeEdict (ent);
}

static void molotov_Touch (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	
/*	if (other == ent->owner)
		return;

	if (other->takedamage)
		return;
*/
	if (surf && (surf->flags & SURF_SKY))
	{
		G_FreeEdict (ent);
		return;
	}

/*	if (surf && (surf->flags & SURF_ALPHA))
	{
		// Grenade gets stuck in alpha surface
		if (!(crandom() < .85))
        {
			ent->gravity = 0; 
			VectorClear (ent->velocity);
			VectorClear (ent->avelocity);
			return;
		}
	}*/

	ent->enemy = other;
	molotov_Explode (ent);
}
// END JOSEPH

void fire_molotov (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, float damage_radius, int radius_damage)
{
	edict_t	*rocket;

	rocket = G_Spawn();
	VectorCopy (start, rocket->s.origin);
	VectorCopy (dir, rocket->movedir);
	vectoangles (dir, rocket->s.angles);
	VectorScale (dir, speed, rocket->velocity);
	rocket->movetype = MOVETYPE_BOUNCE;
	rocket->clipmask = MASK_SHOT;
	rocket->solid = SOLID_BBOX;
	rocket->s.effects |= EF_FLAMETHROWER;
	VectorClear (rocket->mins);
	VectorClear (rocket->maxs);
	rocket->s.modelindex = gi.modelindex ("models/weapons/v_molotov/eject.mdx");
	rocket->s.renderfx2 |= RF2_NOSHADOW;	
	rocket->owner = self;
	rocket->touch = molotov_Touch;
	rocket->dmg = damage;
	rocket->radius_dmg = radius_damage;
	rocket->dmg_radius = damage_radius;
	rocket->classname = "molotov";

	gi.linkentity (rocket);

	// snap - store to struct
	add_ent_to_array(rocket);
}

// MH: speed option added for throw or drop
void molotov_Fire (edict_t *ent, int speed)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
	int		damage;
	float	radius;


	damage = 50;	 // onfire time at break origin (health taken)
	radius = 250.0; // MH: reduced from 400

	VectorSet(offset, 16, 8, ent->viewheight); // MH: launch at eye level
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

/*	VectorScale (forward, -2, ent->client->kick_origin); // MH: removed (no kickback from throwing)
	ent->client->kick_angles[0] = -1;*/

	fire_molotov (ent, start, forward, damage, speed, radius, damage);

	PlayerNoise(ent, start, PNOISE_WEAPON);

	ent->client->gun_noise = true;

}

void Weapon_molotov (edict_t *ent)

{
	gitem_t		*item;
	int			index;

	if(ent->client->ps.gunframe == 9){
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/molotov/lighter.wav"), 1, ATTN_NORM, 0);
	}
	else if(ent->client->ps.gunframe == 13){
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/molotov/fire.wav"), 1, ATTN_NORM, 0);
	}
	else if(ent->client->ps.gunframe == 21){
		molotov_Fire(ent, 750); // MH: release molotov with speed=750
		// take away one of the client's grenades
		item = FindItem("molotov"); 
		index = ITEM_INDEX(item);
		ent->client->pers.inventory[index]--;	
		NoAmmoWeaponChange (ent);
		ChangeWeapon (ent);	
	}

	New_Weapon_Generic (ent, 0, 6, 7, 21, 22, 22, 22, 32, 33, 36, 0);

}
/*********************************************************************
======================================================================

             END NEW CRASH SQUAD WEAPONS / MODES

======================================================================
*********************************************************************/

// WEAPON PISTOL
void Pistol_Fire (edict_t *ent, vec3_t vorigin, int damage)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			kick = 2;
	vec3_t		offset;

//	if (is_quad)
//		damage *= 4;
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	
	VectorSet(offset, 0, 0, ent->viewheight);
	
	VectorAdd (offset, vorigin, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);

	ent->client->kick_angles[0] = -4;
    
	fire_bullet (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_PISTOL);
	
//	if (ent->client->pers.pistol_mods & WEAPON_MOD_DAMAGE)
//	{
		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (ent-g_edicts);
		gi.WriteByte (MZ_PISTOL_DAMAGE_MOD | is_silenced);
		gi.multicast (ent->s.origin, MULTICAST_PVS);
/*	}
	else
	{
		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (ent-g_edicts);
		gi.WriteByte (MZ_PISTOL | is_silenced);
		gi.multicast (ent->s.origin, MULTICAST_PVS);
	}*/
	
	PlayerNoise(ent, start, PNOISE_WEAPON);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
	{
		ent->client->pers.weapon_clip[ent->client->clip_index]--;
	}

	ent->client->gun_noise = true;

}

void Weapon_Pistol_Fire (edict_t *ent)
{
	int		damage;
	int		rounds;
	

	if (ent->waterlevel >= 2)
	{
		// gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);	
		if (ent->client->weaponstate == WEAPON_FIRING)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = 29;
		}
		return;
	}

/*	if (deathmatch->value)
		damage = 15;
	else
		damage = 10;
*/
	damage = 25;

	if (ent->client->ps.gunframe == 6)
	{
/*		if (ent->client->pers.pistol_mods & WEAPON_MOD_ROF)
		{
			if (ent->client->pers.pistol_mods & WEAPON_MOD_DAMAGE)
			{
				damage *= 2;
			}
			ent->client->ps.gunframe = 8;	
		}
		else
		{
			if (ent->client->pers.pistol_mods & WEAPON_MOD_DAMAGE)
			{
				damage *= 2;
			}*/
			ent->client->ps.gunframe++;	
//		}
		Pistol_Fire (ent, vec3_origin, damage); 
//		Eject_Pistol_Shell(ent);
	}
	else if (ent->client->ps.gunframe == 10)
	{
		if (!ent->client->pers.weapon_clip[ent->client->clip_index])
		{
			
			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_PISTOL_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_PISTOL_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			ent->client->ps.gunframe++;	
//			if (ent->client->pers.pistol_mods & WEAPON_MOD_RELOAD)
//				;//gi.dprintf ("need fast reload sound\n");
//			else
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/pistol/clip_out.wav"), 1, ATTN_NORM, 0);

			if (! ent->client->pers.weapon_clip[ent->client->clip_index])
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
		}
		else
			ent->client->ps.gunframe = 29;
	}

}

void Weapon_Pistol (edict_t *ent)
{
	int		rounds;
	//static int	pause_frames[]	= {46, 0, 0};
	static int	pause_frames[]	= {0, 0, 0};
	static int	fire_frames[]	= {6, 10, 0};

	if (ent->client->reload_weapon)
	{
		if (ent->client->ps.gunframe >= 28 && ent->client->ps.gunframe <= 44)
		{
			if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_PISTOL_ROUNDS)
			{
				ent->client->ps.gunframe = 10;
				ent->client->weaponstate = WEAPON_RELOADING;
				
				ent->client->pers.inventory[ent->client->ammo_index] += ent->client->pers.weapon_clip[ent->client->clip_index];	

				if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_PISTOL_ROUNDS)
				{
					rounds = ent->client->pers.inventory[ent->client->ammo_index];
				}
				else 
					rounds = MAX_PISTOL_ROUNDS;

				ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
				ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			}

			ent->client->reload_weapon = false;
		}
		else
			ent->client->reload_weapon = false;
	}
	else if (!ent->client->pers.weapon_clip[ent->client->clip_index] && ent->client->pers.inventory[ent->client->ammo_index])
	{
		if (ent->client->ps.gunframe >= 28 && ent->client->ps.gunframe <= 44)
		{
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 10;
			ent->client->weaponstate = WEAPON_RELOADING;

			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_PISTOL_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_PISTOL_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
		}
	}
	
//	if (ent->client->pers.pistol_mods & WEAPON_MOD_DAMAGE)
//		ent->client->ps.gunindex = gi.modelindex("models/weapons/v_colt/magnum.mdx");

	Weapon_Generic (ent, 5, 28, 44, 49, pause_frames, fire_frames, Weapon_Pistol_Fire);

/*	if (ent->client->pers.pistol_mods & WEAPON_MOD_RELOAD)
	{
		if (ent->client->ps.gunframe == 21)
			ent->client->ps.gunframe = 26;
	}*/
	
	if (ent->client->ps.gunframe >= 10 && ent->client->ps.gunframe <= 28) 
	{
		ent->client->ps.model_parts[PART_BODY].invisible_objects = 0;
	}
	else
		ent->client->ps.model_parts[PART_BODY].invisible_objects = (1<<0 | 1<<1);

	if (ent->client->ps.gunframe == 1)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/pistol/holster.wav"), 1, ATTN_NORM, 0);

	if (ent->client->ps.gunframe == 11)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/pistol/clip_out.wav"), 1, ATTN_NORM, 0);

	if (ent->client->ps.gunframe == 18)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/pistol/clip_in.wav"), 1, ATTN_NORM, 0);

	if (ent->client->ps.gunframe >= 10 && ent->client->ps.gunframe <= 24) 
	{
		ent->client->ps.model_parts[PART_GUN].invisible_objects = 0;
	}
	else
		ent->client->ps.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);

}



void SPistol_Fire (edict_t *ent, vec3_t vorigin, int damage)
{
	vec3_t		start;
	vec3_t		forward, right;
	int			kick = 2;
	vec3_t		offset;

	// is_silenced = MZ_SILENCED;

	if (is_quad)
		damage *= 4;
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	
	VectorSet(offset, 0, 0, ent->viewheight);
	
	VectorAdd (offset, vorigin, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	
	ent->client->kick_angles[0] = -4;
    
	fire_bullet (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_SILENCER);
	
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_SPISTOL | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
		ent->client->pers.weapon_clip[ent->client->clip_index]--;

	if (!ent->client->pers.weapon_clip[ent->client->clip_index] && !ent->client->pers.inventory[ ent->client->ammo_index])
		{
			if (level.time >= ent->pain_debounce_time)
			{
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
				ent->pain_debounce_time = level.time + 1;
			}
			NoAmmoWeaponChange (ent);
		}
    
//	Eject_Pistol_Shell(ent);
	ent->client->gun_noise = false;
}


void Weapon_SPistol_Fire (edict_t *ent)
{
	int		damage;
	int		rounds;


	if (ent->waterlevel >= 2)
	{
		//gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);	
		if (ent->client->weaponstate == WEAPON_FIRING)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = 50;
		}
		return;
	}

	if (deathmatch->value)
		damage = 15;
	else
		damage = 10;

	if (ent->client->ps.gunframe == 21)
	{
		if (ent->client->pers.pistol_mods & WEAPON_MOD_ROF)
		{
			ent->client->ps.gunframe = 23;	
		}
		else
		{
			ent->client->ps.gunframe++;	
		}

		if (ent->client->pers.pistol_mods & WEAPON_MOD_DAMAGE)
		{
			damage *= 2;
		}

		SPistol_Fire (ent, vec3_origin, damage); 
//		Eject_Pistol_Shell(ent);
		ent->client->pers.silencer_shots--;

		if (!ent->client->pers.silencer_shots)
			ent->client->ps.gunframe = 43;

	}
	else if (ent->client->ps.gunframe == 25)
	{
		if (!ent->client->pers.weapon_clip[ent->client->clip_index])
		{
			
			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_PISTOL_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_PISTOL_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			ent->client->ps.gunframe++;	
			if (ent->client->pers.pistol_mods & WEAPON_MOD_RELOAD)
				;//gi.dprintf ("need fast reload sound\n");
			else
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/pistol/clip_out.wav"), 1, ATTN_NORM, 0);

			if (! ent->client->pers.weapon_clip[ent->client->clip_index])
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
		}
		else
			ent->client->ps.gunframe = 50;
	}
	
	else if (ent->client->ps.gunframe == 44) 
	{
		if (!(ent->client->pers.silencer_shots))
			ent->client->ps.gunframe++;
		else
			ent->client->ps.gunframe = 50;
	}
	

}


void Weapon_SPistol (edict_t *ent)
{
	static int	pause_frames[]	= {0, 0, 0};
	static int	fire_frames[]	= {21, 25, 44, 0};
	int		rounds;

// gi.dprintf ("silencer shots left: %d\n", ent->client->pers.silencer_shots);

	if (ent->client->ps.gunframe < 22)
	{
		ent->client->ps.model_parts[PART_BODY].invisible_objects = 0;
	}
	else if (ent->client->weaponstate == WEAPON_RELOADING_SPISTOL && ent->client->ps.gunframe < 40)
	{
		if (ent->client->ps.gunframe < 39)
		ent->client->ps.model_parts[PART_GUN].invisible_objects = 0;
		else
			ent->client->ps.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);

		ent->client->ps.model_parts[PART_BODY].invisible_objects = 0;
	}
	else if (ent->client->pers.holsteredweapon)
	{
		ent->client->ps.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);
		ent->client->ps.model_parts[PART_BODY].invisible_objects = (1<<0 | 1<<1);
	}
	else
	{
		ent->client->ps.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);
		ent->client->ps.model_parts[PART_BODY].invisible_objects = (1<<0 | 1<<1);
	}

	if (ent->client->ps.gunframe == 49)
	{
		if ( ent->client->pers.inventory[ITEM_INDEX(FindItem("bullets"))]
		&&  ent->client->pers.inventory[ITEM_INDEX(FindItem("pistol"))] )
		{
			ent->client->newweapon = FindItem ("pistol");
			
		}
		else
			NoAmmoWeaponChange (ent);

		ent->client->ps.gunframe = 71;
		ent->client->weaponstate = WEAPON_DROPPING;
		{
			gitem_t *it;
			int		index;
			it = FindItem ("SPistol");
			index = ITEM_INDEX (it);
			ent->client->pers.inventory[index] = 0;
		}
	}
	else if (ent->client->reload_weapon)
	{
		if (ent->client->ps.gunframe >= 50 && ent->client->ps.gunframe <= 65)
		{
		
			if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_PISTOL_ROUNDS)
			{
				ent->client->ps.gunframe = 25;
				ent->client->weaponstate = WEAPON_RELOADING_SPISTOL;
				
				ent->client->pers.inventory[ent->client->ammo_index] += ent->client->pers.weapon_clip[ent->client->clip_index];	

				if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_PISTOL_ROUNDS)
				{
					rounds = ent->client->pers.inventory[ent->client->ammo_index];
				}
				else 
					rounds = MAX_PISTOL_ROUNDS;

				ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
				ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			}

			ent->client->reload_weapon = false;
		}
	}
	else if (!ent->client->pers.weapon_clip[ent->client->clip_index] && ent->client->pers.inventory[ent->client->ammo_index])
	{
		
		if (ent->client->ps.gunframe >= 50 && ent->client->ps.gunframe <= 65)
		{
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 25;
			ent->client->weaponstate = WEAPON_RELOADING_SPISTOL;

			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_PISTOL_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_PISTOL_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
		}
	}

	if (ent->client->pers.pistol_mods & WEAPON_MOD_DAMAGE)
		ent->client->ps.gunindex = gi.modelindex("models/weapons/silencer_mdx/magnum.mdx");
			

	Weapon_Generic (ent, 20, 49, 65, 75, pause_frames, fire_frames, Weapon_SPistol_Fire);
		
	if (ent->client->ps.gunframe == 1)
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/pistol/silencerattatch.wav"), 1, ATTN_NORM, 0);
	
	
}


// JOSEPH 26-AUG-98 
//======================================================================

//TOMMYGUN 

//======================================================================
// begin snap - commenting old weapons
/*
void Tommygun_Fire (edict_t *ent)
{
	int	i;
	vec3_t		start;
	//vec3_t	fireorigin;
	vec3_t		forward, right;
	vec3_t		angles;
	int			damage = 8;
	int			kick = 2;
	vec3_t		offset;

	if (ent->waterlevel >= 2)
	{
		// gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);	
		if (ent->client->weaponstate == WEAPON_FIRING)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = 30;
		}
		return;
	}

	// First shot
	if (!(ent->client->buttons & BUTTON_ATTACK))
	{
		// ent->client->machinegun_shots = 0;
		ent->client->ps.gunframe = 30;
		return;
	}

	if (deathmatch->value)
		damage *= 1.75;

	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0) 
		return;

	if (ent->client->ps.gunframe == 5)
		ent->client->ps.gunframe = 4;
	else
		ent->client->ps.gunframe = 5;

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	// Tommy is too powerful in real-mode
	if (dm_realmode->value)
		damage /= 2;

	// Bounce
	for (i=1 ; i<3 ; i++)
	{
		ent->client->kick_origin[i] = crandom() * 0.22;
		ent->client->kick_angles[i] = crandom() * 0.6;
	}
	ent->client->kick_origin[0] = crandom() * 0.22;
	// ent->client->kick_angles[0] = ent->client->machinegun_shots * -.5;

	// get start / end positions
	VectorAdd (ent->client->v_angle, ent->client->kick_angles, angles);
	AngleVectors (angles, forward, right, NULL);
	
	VectorSet(offset, 0, 0, ent->viewheight-1);
	
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
	
	fire_bullet (ent, start, forward, damage, kick, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, MOD_MACHINEGUN);

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_MACHINEGUN | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	PlayerNoise(ent, start, PNOISE_WEAPON);

	// Disable for unlimited ammo
	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
	{
		ent->client->pers.weapon_clip [ent->client->clip_index]--;

		if (!(ent->client->pers.inventory[ent->client->ammo_index]) && !ent->client->pers.weapon_clip [ent->client->clip_index])
		{
			NoAmmoWeaponChange (ent);
			ent->client->ps.gunframe = 30;		
		}
		else if (!ent->client->pers.weapon_clip [ent->client->clip_index])
		{
			ent->client->reload_weapon = true;
			ent->client->ps.gunframe = 30;		
			// gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/machinegun/machgcock.wav"), 1, ATTN_NORM, 0);
		}
	}

	if (!deathmatch->value)	// uses up bandwidth
    Eject_Tommy_Shell(ent);

	ent->client->gun_noise = true;
}

void Weapon_Tommygun (edict_t *ent)
{
	int		rounds;
	static int	pause_frames[]	= {44, 0, 0};
	static int	fire_frames[]	= {4, 5, 0};
	
	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
	}
	else if (ent->client->reload_weapon)
	{
		if (ent->client->ps.gunframe >= 30 && ent->client->ps.gunframe <= 40)
		{
			if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_TOMMYGUN_ROUNDS)
			{
				ent->client->ps.gunframe = 6;
				ent->client->weaponstate = WEAPON_RELOADING;
				
				ent->client->pers.inventory[ent->client->ammo_index] += ent->client->pers.weapon_clip[ent->client->clip_index];	

				if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_TOMMYGUN_ROUNDS)
				{
					rounds = ent->client->pers.inventory[ent->client->ammo_index];
				}
				else 
					rounds = MAX_TOMMYGUN_ROUNDS;

				ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
				ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/machinegun/machgcock.wav"), 1, ATTN_NORM, 0);
			}

			ent->client->reload_weapon = false;
		}
	}
	else if (!ent->client->pers.weapon_clip[ent->client->clip_index] && ent->client->pers.inventory[ent->client->ammo_index])
	{
		if (ent->client->ps.gunframe >= 30 && ent->client->ps.gunframe <= 40)
		{
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 6;
			ent->client->weaponstate = WEAPON_RELOADING;

			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_TOMMYGUN_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_TOMMYGUN_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/machinegun/machgcock.wav"), 1, ATTN_NORM, 0);
		}
	}

	Weapon_Generic (ent, 3, 29, 40, 46, pause_frames, fire_frames, Tommygun_Fire);


}
// END JOSEPH




//======================================================================

  //FLAMETHROWER

//======================================================================


void FlameThrower_Fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		angles;
	int			damage = 1;
	int			kick = 0;
	static int flamesnd = 0;
//	vec3_t		offset;

	if (ent->waterlevel >= 2)
	{
		// gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);	
		if (ent->client->weaponstate == WEAPON_FIRING)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = 14;
			ent->s.renderfx2 &= ~RF2_FLAMETHROWER;
		}
		return;
	}

	if (deathmatch->value && rand()%2)
		damage = 1;

	if (ent->health <= 0)
		return;

	if (!(ent->client->buttons & BUTTON_ATTACK))
	{
		// ent->client->machinegun_shots = 0;
		ent->client->ps.gunframe = 14;
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/flame_thrower/flameend.wav"), 1, ATTN_NORM, 0);
		flamesnd = 0;
		ent->s.renderfx2 &= ~RF2_FLAMETHROWER;
		return;
	}

	ent->client->ps.gunframe ++ ;

	if (ent->client->ps.gunframe == 14)
		ent->client->ps.gunframe = 6;
	
	if (ent->client->pers.inventory[ent->client->ammo_index] < 1)
	{
		ent->client->ps.gunframe = 6; 
		
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
		ent->s.renderfx2 &= ~RF2_FLAMETHROWER;
		return;
	}

	if (is_quad)
	{
		damage *= 4;
		kick *= 4;
	}

	// get start / end positions
	VectorAdd (ent->client->v_angle, ent->client->kick_angles, angles);
	AngleVectors (angles, forward, right, NULL);
	
	VectorCopy( ent->s.origin, start );
	
	fire_flamethrower (ent, start, forward, damage, kick, MOD_FLAMETHROWER);

	PlayerNoise(ent, start, PNOISE_WEAPON);

	ent->s.renderfx2 |= RF2_FLAMETHROWER;

	flamesnd++;
	
	if (flamesnd > 2)
		flamesnd = 0;

	if (flamesnd == 1)
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame2.wav"), 1, ATTN_NORM, 0);
	else if (flamesnd == 2)
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame3.wav"), 1, ATTN_NORM, 0);
	else
		gi.sound(ent, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame1.wav"), 1, ATTN_NORM, 0);


	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
	{
		if ((ent->client->pers.inventory[ent->client->ammo_index] -= 2) < 0)
			ent->client->pers.inventory[ent->client->ammo_index] = 0;
	}

	// RAFAEL	28-dec-98
	ent->client->gun_noise = true;


}

void Weapon_FlameThrower (edict_t *ent)
{
	static int	pause_frames[]	= {18, 24, 0};

	static int	fire_frames[]	= {6, 7, 8, 9, 10, 11, 12, 13};

		Weapon_Generic (ent, 5, 13, 25, 31, pause_frames, fire_frames, FlameThrower_Fire);
	
}
*/
// end snap


/*
	SHOTGUN
*/

void shotgun_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	int			damage;
	int			kick = 10;

	if (ent->waterlevel >= 2)
	{
		// gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);	
		if (ent->client->weaponstate == WEAPON_FIRING)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = 33;
		}
		return;
	}

//	if (deathmatch->value)
//		damage *= 2;
	damage = 30;

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorSet(offset, 0, 0,  ent->viewheight-2);

	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
	
	if (deathmatch->value)
	{
		fire_shotgun (ent, start, forward, damage, kick, 500, 500, DEFAULT_SAWED_SHOTGUN_COUNT, MOD_SHOTGUN);
	}
	else
	{
		fire_shotgun (ent, start, forward, damage, kick, 500, 500, DEFAULT_SAWED_SHOTGUN_COUNT , MOD_SHOTGUN);
	}
	
	VectorScale (forward, -2, ent->client->kick_origin);
	
	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_SHOTGUN | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	ent->client->ps.gunframe++;
	PlayerNoise(ent, start, PNOISE_WEAPON);
	
	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
		ent->client->pers.weapon_clip[ent->client->clip_index]--;
	
	Eject_Shotgun_Shell(ent);
	ent->client->gun_noise = true;

}

void Weapon_Shotgun_Fire (edict_t *ent)
{
	if (ent->client->ps.gunframe == 6)
	{
		if (ent->client->pers.weapon_clip[ent->client->clip_index])
			shotgun_fire (ent);
		else
		{
			ent->client->ps.gunframe = 17;
			ent->client->reload_weapon = true;
			ent->client->weaponstate = WEAPON_RELOAD_CYCLE;
		}
	}
	else if (ent->client->ps.gunframe == 16)
	{
		if (!ent->client->pers.weapon_clip[ent->client->clip_index])
		{
			if (ent->client->pers.inventory[ent->client->ammo_index])
			{
				ent->client->ps.gunframe ++;
				ent->client->reload_weapon = true;
				ent->client->weaponstate = WEAPON_RELOAD_CYCLE;
			}
			else
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
		}
		else
		{
			ent->client->ps.gunframe = 33;
		}
	}
}


void Weapon_Shotgun (edict_t *ent)
{
	static int	pause_frames[]	= {0, 0};
	static int	fire_frames[]	= {6, 16, 0};
	static int  kick_frames[]   = {-12, -9, -6, -4, -1};

	if ((ent->client->ps.gunframe >= 6) & (ent->client->ps.gunframe <= 9))
	{
		ent->client->kick_angles[0] = kick_frames[ent->client->ps.gunframe-6];
	}
	
	if (ent->client->ps.gunframe == 7)
		ent->client->ps.rdflags |= RDF_NOLERP;
	else
		ent->client->ps.rdflags &= ~RDF_NOLERP;

	if (ent->client->reload_weapon)
	{
		if (ent->client->buttons & BUTTON_ATTACK && ent->client->pers.weapon_clip[ent->client->clip_index] >= 1 && ent->client->weaponstate != WEAPON_FIRING)
		{
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 33;
			ent->client->weaponstate = WEAPON_READY;
		}
		else if (ent->client->newweapon)
		{
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 33;
			ent->client->weaponstate = WEAPON_DROPPING;
		}
		else
		{
			if (ent->client->ps.gunframe == 29)
			{
				if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_SHOTGUN_ROUNDS)
				{
					if (ent->client->pers.inventory[ent->client->ammo_index])
					{
						ent->client->pers.inventory[ent->client->ammo_index]--;
						ent->client->pers.weapon_clip[ent->client->clip_index]++;

						if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_SHOTGUN_ROUNDS)
							ent->client->ps.gunframe = 21; 
						else
						{
							ent->client->reload_weapon = false;
							ent->client->ps.gunframe = 29; 
							ent->client->weaponstate = WEAPON_RELOADING;
						}
					}
					else
					{
						ent->client->reload_weapon = false;
						ent->client->weaponstate = WEAPON_RELOADING;
					}
				}
				else
				{
					ent->client->reload_weapon = false;
					ent->client->weaponstate = WEAPON_RELOADING;
				}
			}
			else if (ent->client->ps.gunframe >= 33 && ent->client->ps.gunframe <= 40)
			{
				if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_SHOTGUN_ROUNDS &&
					ent->client->pers.inventory[ent->client->ammo_index])
				{
					ent->client->weaponstate = WEAPON_RELOAD_CYCLE;
					ent->client->ps.gunframe = 17;
				}
			}
		}
	}
	else if (!ent->client->pers.weapon_clip[ent->client->clip_index] && ent->client->weaponstate != WEAPON_DROPPING
		&& !ent->client->buttons & BUTTON_ATTACK)
	{
		ent->client->reload_weapon = true;
		ent->client->weaponstate = WEAPON_RELOAD_CYCLE;
		ent->client->ps.gunframe = 17;
		
		if (!ent->client->pers.inventory[ent->client->ammo_index])
		{
			if (level.time >= ent->pain_debounce_time)
			{
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
				ent->pain_debounce_time = level.time + 1;
			}
			NoAmmoWeaponChange (ent);
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 33;
			ent->client->weaponstate = WEAPON_READY;
		}
	}
	
	if (ent->client->ps.gunframe == 21)
	{
		gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/shotgun/shotgload.wav"), 1, ATTN_NORM, 0);
	}

	Weapon_Generic (ent, 5, 32, 40, 45, pause_frames, fire_frames, Weapon_Shotgun_Fire);

	/*
	if (ent->client->ps.gunframe == 1)
	{
		ent->client->ps.model_parts[PART_HEAD].invisible_objects = 0;
		ent->client->ps.model_parts[PART_BODY].invisible_objects = 0;
		ent->client->ps.model_parts[PART_LEGS].invisible_objects = 0;
	}
	*/


}

// begin snap commenting old weapons
/*
void weapon_barmachinegun_fire (edict_t *ent)
{
	vec3_t		start;
	vec3_t		forward, right;
	vec3_t		offset;
	int			damage;
	int			kick;


	if (ent->waterlevel >= 2)
	{
		// gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);	
		if (ent->client->weaponstate == WEAPON_FIRING)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = 43;
		}
		return;
	}

//	if (deathmatch->value)
//	{	
		// tone down if too much in deathmatch
		damage = 75;
		kick = 50;
//	}
//	else
//	{
//		damage = 25;
//		kick = 50;
//	}

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorScale (forward, -3, ent->client->kick_origin);
	VectorSet(offset, 0, 0,  ent->viewheight-1);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);


    if (ent->client->ps.pmove.pm_flags & PMF_DUCKED)
	{
		//snap - more accurate than normal
		ent->client->kick_angles[0] = -5;
 		fire_bullet (ent, start, forward, damage, kick, 0, 0, MOD_BARMACHINEGUN);
	}
	else if(level.framenum<(ent->move_frame+5))
	{
		//snap - less accurate than normal -- damn this is inaccurate, useless really
		ent->client->kick_angles[0] = -15;
 		fire_bullet (ent, start, forward, damage, kick, 200, 200, MOD_BARMACHINEGUN);

	}
    else
	{
		//snap - normal fire
		ent->client->kick_angles[0] = -10;
 		fire_bullet (ent, start, forward, damage, kick, 5, 5, MOD_BARMACHINEGUN);
	}


	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	if (ent->client->ps.gunframe == 5)
		gi.WriteByte (MZ_BARMACHINEGUN | is_silenced);
	else
		gi.WriteByte (MZ_BARMACHINEGUN2 | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	PlayerNoise(ent, start, PNOISE_WEAPON);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
	{
		ent->client->pers.weapon_clip [ent->client->clip_index]--;

		if (!(ent->client->pers.inventory[ent->client->ammo_index]) && !ent->client->pers.weapon_clip [ent->client->clip_index])
		{
			NoAmmoWeaponChange (ent);
			ent->client->ps.gunframe = 43;		
		}
		else if (ent->client->pers.inventory[ent->client->ammo_index] && !(ent->client->pers.weapon_clip [ent->client->clip_index]))
		{
			ent->client->reload_weapon = true;
			ent->client->ps.gunframe = 43;		
		}
		
	}

    Eject_Tommy_Shell(ent);

	ent->client->gun_noise = true;

}

void barmachinegun_fire (edict_t *ent)
{


	if ((ent->client->ps.gunframe == 19))
	{
		ent->client->ps.gunframe = 43;
		return;
	}
	else if (ent->client->ps.gunframe == 12)
	{
		if (ent->client->pers.pistol_mods & WEAPON_MOD_COOLING_JACKET)
		{
			ent->client->ps.gunframe = 43;
		}
	}
	else if (ent->client->ps.gunframe == 5)
			|| ent->client->ps.gunframe == 7 
			|| ent->client->ps.gunframe == 9)
	{
		weapon_barmachinegun_fire (ent);
	
		if (ent->client->pers.pistol_mods & WEAPON_MOD_COOLING_JACKET)
		{
			ent->client->pers.hmg_shots --;

			if (!ent->client->pers.hmg_shots)
			{
				ent->client->pers.pistol_mods &= ~WEAPON_MOD_COOLING_JACKET;
				
				ent->client->newweapon = ent->client->pers.weapon;
				
				if (ent->client->pers.inventory[ent->client->ammo_index] || ent->client->pers.weapon_clip[ent->client->clip_index])
					ChangeWeapon (ent);
				else
					NoAmmoWeaponChange (ent);
			}
		}
	}
	else if (ent->client->ps.gunframe == 7)
		ent->client->ps.gunframe = 10;
	
	ent->client->ps.gunframe++;
	
}

void Weapon_Barmachinegun (edict_t *ent)
{
	static int	pause_frames[]	= {0, 0};
	static int	fire_frames[]	= {5, 6, 7, 8, 9, 12, 19, 0};
	int			rounds;
	
	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
	}
	else if (ent->client->reload_weapon)
	{
		if (ent->client->ps.gunframe >= 43 && ent->client->ps.gunframe <= 53)
		{
			if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_BARMACHINEGUN_ROUNDS)
			{
				ent->client->ps.gunframe = 20;
				ent->client->weaponstate = WEAPON_RELOADING;
				
				ent->client->pers.inventory[ent->client->ammo_index] += ent->client->pers.weapon_clip[ent->client->clip_index];	

				if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_BARMACHINEGUN_ROUNDS)
				{
					rounds = ent->client->pers.inventory[ent->client->ammo_index];
				}
				else 
					rounds = MAX_BARMACHINEGUN_ROUNDS;

				ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
				ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/hmg/hmgcock.wav"), 1, ATTN_NORM, 0);
			}

			ent->client->reload_weapon = false;
		}
	}
	else if (!ent->client->pers.weapon_clip[ent->client->clip_index] && ent->client->pers.inventory[ent->client->ammo_index])
	{
		if (ent->client->ps.gunframe >= 43 && ent->client->ps.gunframe <= 53)
		{
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 20;
			ent->client->weaponstate = WEAPON_RELOADING;

			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_BARMACHINEGUN_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_BARMACHINEGUN_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/hmg/hmgcock.wav"), 1, ATTN_NORM, 0);
		}
	}

	
	Weapon_Generic (ent, 4, 42, 53, 59, pause_frames, fire_frames, barmachinegun_fire);

 	// gi.dprintf ("Frame: %d\n", ent->client->ps.gunframe);
}



//======================================================================

//GRENADE LAUNCHER

//======================================================================


void Eject_Grenade_Shell (edict_t *ent)
{
	edict_t	*dropped = NULL;
	vec3_t	forward, right, up;
	vec3_t	offset;

	if (!(ent->client))
		return;


	if (deathmatch->value)
		return;

	//gi.dprintf("angles = %s\n", vtos(ent->s.angles));

	dropped = G_Spawn();
	
	if (!dropped)
		return;

	dropped->s.modelindex = gi.modelindex("models/weapons/grenade_shell/tris.md2");
		
	dropped->movetype = MOVETYPE_BOUNCE;
	
	dropped->mins[0] = -4;
	dropped->mins[1] = -4;
	dropped->mins[2] = -2;
	
	dropped->maxs[0] =  4;
	dropped->maxs[1] =  4;
	dropped->maxs[2] =  4;

	AngleVectors (ent->client->v_angle, forward, right, up);

	dropped->s.angles[YAW] = ent->client->v_angle[YAW];

//	VectorSet(offset, 0, 16, ent->viewheight -2 );
// snap, changed position closer to gun
	VectorSet(offset, 8, 11, ent->viewheight -6 );

	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, dropped->s.origin);

	VectorScale (forward, 5 + ((rand()&15)-8), dropped->velocity);
    VectorMA (dropped->velocity, 50 + (rand()&31), right, dropped->velocity);
	dropped->velocity[2] = 150 + (rand()&31);

	// Ridah, changed this so they don't stick in the ground so much
	VectorSet(dropped->avelocity, 0, ((rand()&15)-8), ((rand()&7)-4));

	dropped->think = Think_Eject_Shell;
	dropped->misstime = 40;
	dropped->nextthink = level.time + 0.1;

	dropped->s.renderfx2 |= RF2_NOSHADOW;

	gi.linkentity (dropped);

	return;
}


void weapon_grenadelauncher_fire (edict_t *ent)
{
	vec3_t	offset;
	vec3_t	forward, right;
	vec3_t	start;
	int		damage = 120;
	float	radius;

	if (ent->waterlevel >= 2)
	{
		// gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);	
		if (ent->client->weaponstate == WEAPON_FIRING)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = 33;
		}
		return;
	}

	damage *= 2;		// 240 points of damage
	radius = damage*2;	// 480 units radius
	radius *= 0.75;

	VectorSet(offset, 16, 8, ent->viewheight-8);
	AngleVectors (ent->client->v_angle, forward, right, NULL);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	fire_grenade (ent, start, forward, damage, 750, 2.0, radius);

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_GRENADE | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	ent->client->ps.gunframe++;

	PlayerNoise(ent, start, PNOISE_WEAPON);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
	{
		ent->client->pers.weapon_clip[ent->client->clip_index]--;
	
		if (!(ent->client->pers.inventory[ent->client->ammo_index]) && !ent->client->pers.weapon_clip [ent->client->clip_index])
		{
			NoAmmoWeaponChange (ent);
			ent->client->ps.gunframe = 33;		
		}
	}
		
	Eject_Grenade_Shell(ent);
	
	ent->client->gun_noise = true;

}

void Weapon_GrenadeLauncher_Fire (edict_t *ent)
{
	if (ent->client->ps.gunframe == 5)
			weapon_grenadelauncher_fire (ent);
	else if (ent->client->ps.gunframe == 16)
	{
		if ((ent->client->pers.inventory[ent->client->ammo_index]) && !ent->client->pers.weapon_clip [ent->client->clip_index])
		{
			ent->client->reload_weapon = true;
		}
		
		ent->client->ps.gunframe = 33;

	}

}

#define	MAX_GRENADE_ROUNDS	3

void Weapon_GrenadeLauncher (edict_t *ent)
{
	static int	pause_frames[]	= {0, 0};
	static int	fire_frames[]	= {5, 16, 0};
	int			rounds;

	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
			{
				if (level.time >= ent->pain_debounce_time)
				{
					gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
					ent->pain_debounce_time = level.time + 1;
				}
				NoAmmoWeaponChange (ent);
			}
	else if (ent->client->reload_weapon)
	{
		if (ent->client->ps.gunframe >= 33 && ent->client->ps.gunframe <= 40)
		{
			if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_GRENADE_ROUNDS)
			{
				ent->client->ps.gunframe = 17;
				ent->client->weaponstate = WEAPON_RELOADING;
				
				ent->client->pers.inventory[ent->client->ammo_index] += ent->client->pers.weapon_clip[ent->client->clip_index];	

				if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_GRENADE_ROUNDS)
				{
					rounds = ent->client->pers.inventory[ent->client->ammo_index];
				}
				else
					rounds = MAX_GRENADE_ROUNDS;

				ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
				ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/grenade_launcher/reload.wav"), 1, ATTN_NORM, 0);
			}

			ent->client->reload_weapon = false;
		}
	}
	else if (!ent->client->pers.weapon_clip[ent->client->clip_index] && ent->client->pers.inventory[ent->client->ammo_index])
	{
		if (ent->client->ps.gunframe >= 33 && ent->client->ps.gunframe <= 40)
		{
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 17;
			ent->client->weaponstate = WEAPON_RELOADING;

			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_GRENADE_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_GRENADE_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/grenade_launcher/reload.wav"), 1, ATTN_NORM, 0);
		}
	}

	Weapon_Generic (ent, 4, 32, 40, 45, pause_frames, fire_frames, Weapon_GrenadeLauncher_Fire);

	if (ent->client->ps.gunframe >= 17 && ent->client->ps.gunframe <= 32)
	{
		ent->client->ps.model_parts[PART_GUN].invisible_objects = 0;
	}
	else
		ent->client->ps.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);

	
	if (ent->client->ps.gunframe >= 9 && ent->client->ps.gunframe <= 16)
		ent->client->ps.rdflags |= RDF_NOLERP;
	else
		ent->client->ps.rdflags &= ~RDF_NOLERP;


}

// rocket launcher

void weapon_rocketlauncher_fire (edict_t *ent)
{
	vec3_t	offset, start;
	vec3_t	forward, right;
	int		damage;
	float	damage_radius;
	int		radius_damage;
	
	if (ent->waterlevel >= 2)
	{
		// gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);	
		if (ent->client->weaponstate == WEAPON_FIRING)
		{
			ent->client->weaponstate = WEAPON_READY;
			ent->client->ps.gunframe = 30;
		}
		return;
	}

	damage = 100 + (int)(random() * 20.0);
	radius_damage = 120;
	damage_radius = 180;	// 256;
	if (is_quad)
	{
		damage *= 4;
		radius_damage *= 4;
	}
	
	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -4;

	VectorSet(offset, 8, 8, ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
	fire_rocket (ent, start, forward, damage, 900, damage_radius, radius_damage);

	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_ROCKET | is_silenced);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	ent->client->ps.gunframe++;

	PlayerNoise(ent, start, PNOISE_WEAPON);

	if (! ( (int)dmflags->value & DF_INFINITE_AMMO && deathmatch->value ) )
	{
		ent->client->pers.weapon_clip[ent->client->clip_index]--;
		
		if (!(ent->client->pers.inventory[ent->client->ammo_index]) && !ent->client->pers.weapon_clip [ent->client->clip_index])
		{
			NoAmmoWeaponChange (ent);
			ent->client->ps.gunframe = 30;		
		}
	}

	ent->client->gun_noise = true;

}

void Weapon_RocketLauncher_Fire (edict_t *ent)
{
	if (ent->client->ps.gunframe == 6)
		weapon_rocketlauncher_fire (ent);
	else if (ent->client->ps.gunframe == 13)
	{
		if ((ent->client->pers.inventory[ent->client->ammo_index]) && !ent->client->pers.weapon_clip [ent->client->clip_index])
		{
			ent->client->reload_weapon = true;
		}
	
		ent->client->ps.gunframe = 30;
	}

}

#define	MAX_ROCKET_ROUNDS	5

void Weapon_RocketLauncher (edict_t *ent)
{
	static int	pause_frames[]	= {0, 0};
	static int	fire_frames[]	= {6, 13, 0};
	int			rounds;

	if (ent->client->pers.inventory[ent->client->ammo_index] == 0 && ent->client->pers.weapon_clip[ent->client->clip_index] == 0
		&& ent->client->weaponstate != WEAPON_DROPPING) 
	{
		if (level.time >= ent->pain_debounce_time)
		{
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/noammo.wav"), 1, ATTN_NORM, 0);
			ent->pain_debounce_time = level.time + 1;
		}
		NoAmmoWeaponChange (ent);
	}
	else if (ent->client->reload_weapon)
	{
		if (ent->client->ps.gunframe >= 30 && ent->client->ps.gunframe <= 41)
		{
			if (ent->client->pers.weapon_clip[ent->client->clip_index] < MAX_ROCKET_ROUNDS)
			{
				ent->client->ps.gunframe = 14;
				ent->client->weaponstate = WEAPON_RELOADING;
				
				ent->client->pers.inventory[ent->client->ammo_index] += ent->client->pers.weapon_clip[ent->client->clip_index];	

				if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_ROCKET_ROUNDS)
				{
					rounds = ent->client->pers.inventory[ent->client->ammo_index];
				}
				else 
					rounds = MAX_ROCKET_ROUNDS;

				ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
				ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
				gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/rocket_launcher/reload.wav"), 1, ATTN_NORM, 0);
			}

			ent->client->reload_weapon = false;
		}
	}
	else if (!ent->client->pers.weapon_clip[ent->client->clip_index] && ent->client->pers.inventory[ent->client->ammo_index])
	{
		if (ent->client->ps.gunframe >= 30 && ent->client->ps.gunframe <= 41)
		{
			ent->client->reload_weapon = false;
			ent->client->ps.gunframe = 14;
			ent->client->weaponstate = WEAPON_RELOADING;

			if (ent->client->pers.inventory[ent->client->ammo_index] < MAX_ROCKET_ROUNDS)
			{
				rounds = ent->client->pers.inventory[ent->client->ammo_index];
			}
			else 
				rounds = MAX_ROCKET_ROUNDS;

			ent->client->pers.weapon_clip[ent->client->clip_index] = rounds;
			ent->client->pers.inventory[ent->client->ammo_index] -= rounds;
			gi.sound(ent, CHAN_VOICE, gi.soundindex("weapons/rocket_launcher/reload.wav"), 1, ATTN_NORM, 0);
		}
	}
	
	Weapon_Generic (ent, 5, 29, 41, 47, pause_frames, fire_frames, Weapon_RocketLauncher_Fire);


}
*/
// end snap