#include "g_local.h"


void InitTrigger (edict_t *self)
{
	if (!VectorCompare (self->s.angles, vec3_origin))
		G_SetMovedir (self->s.angles, self->movedir);

	self->solid = SOLID_TRIGGER;
	self->movetype = MOVETYPE_NONE;
	gi.setmodel (self, self->model);
	self->svflags = SVF_NOCLIENT;
}


// the wait time has passed, so set back up for another activation
void multi_wait (edict_t *ent)
{
	ent->nextthink = 0;
}


// the trigger was just activated
// ent->activator should be set to the activator so it can be held through a delay
// so wait for the delay time before firing
void multi_trigger (edict_t *ent)
{
	if (ent->nextthink)
		return;		// already been triggered

	G_UseTargets (ent, ent->activator);

	if (ent->wait > 0)	
	{
		ent->think = multi_wait;
		ent->nextthink = level.time + ent->wait;
	}
	else
	{	// we can't just remove (self) here, because this is a touch function
		// called while looping through area links...
		ent->touch = NULL;
//CDEATH - Prevent the entity from deleting itself. Just set it idle as it will be completely reset at the next round
//		ent->nextthink = level.time + FRAMETIME;
//		ent->think = G_FreeEdict;
		ent->nextthink = 0;
		ent->think = NULL;
		ent->use = NULL;
		ent->activator = NULL;
//END CDEATH
	}
}

void Use_Multi (edict_t *ent, edict_t *other, edict_t *activator)
{
	ent->activator = activator;
	multi_trigger (ent);
}

void Touch_Multi (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if(other->client)
	{
		if (self->spawnflags & 2)
			return;
	}
	else if (other->svflags & SVF_MONSTER)
	{
		if (!(self->spawnflags & 1))
			return;
	}
	else
		return;

	if (!VectorCompare(self->movedir, vec3_origin))
	{
		vec3_t	forward;

		AngleVectors(other->s.angles, forward, NULL, NULL);
		if (_DotProduct(forward, self->movedir) < 0)
			return;
	}

	self->activator = other;
	multi_trigger (self);
}

void Touch_Multi2 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if(other->client)
	{
		if (!(other->client->pers.holsteredweapon))
			return;

		if (self->spawnflags & 2)
			return;
	}
	else if (other->svflags & SVF_MONSTER)
	{
		if (!(self->spawnflags & 1))
			return;
	}
	else
		return;

	if (!VectorCompare(self->movedir, vec3_origin))
	{
		vec3_t	forward;

		AngleVectors(other->s.angles, forward, NULL, NULL);
		if (_DotProduct(forward, self->movedir) < 0)
			return;
	}

	self->activator = other;
	multi_trigger (self);
}

/*QUAKED trigger_multiple (.5 .5 .5) ? MONSTER NOT_PLAYER TRIGGERED
Variable sized repeatable trigger.  Must be targeted at one or more entities.
If "delay" is set, the trigger waits some time after activating before firing.
"wait" : Seconds between triggerings. (.2 default)
sounds
1)	secret
2)	beep beep
3)	large switch
4)
set "message" to text string
*/
void trigger_enable (edict_t *self, edict_t *other, edict_t *activator)
{
	self->solid = SOLID_TRIGGER;
	self->use = Use_Multi;
	gi.linkentity (self);
}

void SP_trigger_multiple (edict_t *ent)
{
	if (ent->sounds == 1)
		ent->noise_index = gi.soundindex ("misc/secret.wav");
	else if (ent->sounds == 2)
		ent->noise_index = gi.soundindex ("misc/talk.wav");
	else if (ent->sounds == 3)
		ent->noise_index = gi.soundindex ("misc/trigger1.wav");
	
	if (!ent->wait)
		ent->wait = 0.2;
	ent->touch = Touch_Multi;
	ent->movetype = MOVETYPE_NONE;
	ent->svflags |= SVF_NOCLIENT;


	if (ent->spawnflags & 4)
	{
		ent->solid = SOLID_NOT;
		ent->use = trigger_enable;
	}
	else
	{
		ent->solid = SOLID_TRIGGER;
		ent->use = Use_Multi;
	}

	if (!VectorCompare(ent->s.angles, vec3_origin))
		G_SetMovedir (ent->s.angles, ent->movedir);

	gi.setmodel (ent, ent->model);
	gi.linkentity (ent);
}

void SP_trigger_multiple2 (edict_t *ent)
{
	if (ent->sounds == 1)
		ent->noise_index = gi.soundindex ("misc/secret.wav");
	else if (ent->sounds == 2)
		ent->noise_index = gi.soundindex ("misc/talk.wav");
	else if (ent->sounds == 3)
		ent->noise_index = gi.soundindex ("misc/trigger1.wav");
	
	if (!ent->wait)
		ent->wait = 0.2;
	ent->touch = Touch_Multi2;
	ent->movetype = MOVETYPE_NONE;
	ent->svflags |= SVF_NOCLIENT;


	if (ent->spawnflags & 4)
	{
		ent->solid = SOLID_NOT;
		ent->use = trigger_enable;
	}
	else
	{
		ent->solid = SOLID_TRIGGER;
		ent->use = Use_Multi;
	}

	if (!VectorCompare(ent->s.angles, vec3_origin))
		G_SetMovedir (ent->s.angles, ent->movedir);

	gi.setmodel (ent, ent->model);
	gi.linkentity (ent);
}

/*QUAKED trigger_once (.5 .5 .5) ? x x TRIGGERED SCENERIC
Triggers once, then removes itself.
You must set the key "target" to the name of another object in the level that has a matching "targetname".

If TRIGGERED, this trigger must be triggered before it is live.

sounds
 1)	secret
 2)	beep beep
 3)	large switch
 4)

"message"	string to be displayed when triggered
*/

void SP_trigger_once(edict_t *ent)
{
	// make old maps work because I messed up on flag assignments here
	// triggered was on bit 1 when it should have been on bit 4
	if (ent->spawnflags & 1)
	{
		vec3_t	v;

		VectorMA (ent->mins, 0.5, ent->size, v);
		ent->spawnflags &= ~1;
		ent->spawnflags |= 4;
		gi.dprintf("fixed TRIGGERED flag on %s at %s\n", ent->classname, vtos(v));
	}

	ent->wait = -1;
	
	if (ent->spawnflags & 8)
		SP_trigger_multiple2 (ent);
	else
		SP_trigger_multiple (ent);
}

/*QUAKED trigger_relay (.5 .5 .5) (-8 -8 -8) (8 8 8)
This fixed size trigger cannot be touched, it can only be fired by other events.
*/
void trigger_relay_use (edict_t *self, edict_t *other, edict_t *activator)
{
	G_UseTargets (self, activator);
}

void SP_trigger_relay (edict_t *self)
{
	self->use = trigger_relay_use;
}


/*
==============================================================================

trigger_key

==============================================================================
*/

/*QUAKED trigger_key (.5 .5 .5) (-8 -8 -8) (8 8 8)
A relay trigger that only fires it's targets if player has the proper key.
Use "item" to specify the required key, for example "key_data_cd"
*/
void trigger_key_use (edict_t *self, edict_t *other, edict_t *activator)
{
	int			index;

	if (!self->item)
		return;
	if (!activator->client)
		return;

	index = ITEM_INDEX(self->item);
	if (!activator->client->pers.inventory[index])
	{
		if (level.time < self->touch_debounce_time)
			return;
		self->touch_debounce_time = level.time + 5.0;
		// JOSEPH 4-JUN-99
		if (!strcmp(self->item->pickup_name, "Fuse"))
		{
			//gi.sound (activator, CHAN_AUTO, gi.soundindex ("misc/fusetry.wav"), 1, ATTN_NORM, 0);
		}
		else if (!strcmp(self->item->pickup_name, "Oil Can"))
		{
			//gi.sound (activator, CHAN_AUTO, gi.soundindex ("misc/fusetry.wav"), 1, ATTN_NORM, 0);
		}
		else if (!strcmp(self->item->pickup_name, "Valve"))
		{
			//gi.sound (activator, CHAN_AUTO, gi.soundindex ("misc/fusetry.wav"), 1, ATTN_NORM, 0);
		}
		else
		{
			gi.centerprintf (activator, "You need the %s", self->item->pickup_name);
		}
		// END JOSEPH
		return;
	}

	// JOSEPH 13-MAY-99
	//gi.sound (activator, CHAN_AUTO, gi.soundindex ("misc/keyuse.wav"), 1, ATTN_NORM, 0);
	// END JOSEPH
/*	if (coop->value)
	{
		int		player;
		edict_t	*ent;

		if (strcmp(self->item->classname, "key_fuse") == 0)
		{
			int	cube;

			for (cube = 0; cube < 8; cube++)
				if (activator->client->pers.fusekey & (1 << cube))
					break;
			for (player = 1; player <= game.maxclients; player++)
			{
				ent = &g_edicts[player];
				if (!ent->inuse)
					continue;
				if (!ent->client)
					continue;
				if (ent->client->pers.fusekey & (1 << cube))
				{
					ent->client->pers.inventory[index]--;
					ent->client->pers.fusekey &= ~(1 << cube);
				}
			}
		}
		else
		{
			for (player = 1; player <= game.maxclients; player++)
			{
				ent = &g_edicts[player];
				if (!ent->inuse)
					continue;
				if (!ent->client)
					continue;
				ent->client->pers.inventory[index] = 0;
			}
		}
	}
	else*/
	{
		activator->client->pers.inventory[index]--;
	}

	G_UseTargets (self, activator);

	self->use = NULL;
}

void SP_trigger_key (edict_t *self)
{
	if (!st.item)
	{
		gi.dprintf("no key item for trigger_key at %s\n", vtos(self->s.origin));
		return;
	}
	self->item = FindItemByClassname (st.item);

	if (!self->item)
	{
		gi.dprintf("item %s not found for trigger_key at %s\n", st.item, vtos(self->s.origin));
		return;
	}

	if (!self->target)
	{
		gi.dprintf("%s at %s has no target\n", self->classname, vtos(self->s.origin));
		return;
	}

	// JOSEPH 13-MAY-99
	//gi.soundindex ("misc/keytry.wav");
	//gi.soundindex ("misc/keyuse.wav");
	// END JOSEPH

	self->use = trigger_key_use;
}


/*
==============================================================================

trigger_counter

==============================================================================
*/

/*QUAKED trigger_counter (.5 .5 .5) ? nomessage
Acts as an intermediary for an action that takes multiple inputs.

If nomessage is not set, t will print "1 more.. " etc when triggered and "sequence complete" when finished.

After the counter has been triggered "count" times (default 2), it will fire all of it's targets and remove itself.
*/

void trigger_counter_use(edict_t *self, edict_t *other, edict_t *activator)
{
	if (self->count == 0)
		return;
	
	self->count--;

	if (self->count)
	{
		if (! (self->spawnflags & 1))
		{
			if (developer->value)
				gi.centerprintf(activator, "%i more to go...", self->count);
			// JOSEPH 29-MAR-99
			//gi.sound (activator, CHAN_AUTO, gi.soundindex ("misc/talk1.wav"), 1, ATTN_NORM, 0);
			// END JOSEPH
		}
		return;
	}
	
	if (! (self->spawnflags & 1))
	{
		if (developer->value)
		{
			// gi.centerprintf(activator, "Sequence completed!");
			gi.centerprintf (activator, "Armagedon virus installed successfully");
		}

		// JOSEPH 29-MAR-99
		//gi.sound (activator, CHAN_AUTO, gi.soundindex ("misc/talk1.wav"), 1, ATTN_NORM, 0);
		// END JOSEPH
	}
	self->activator = activator;
	multi_trigger (self);
}

void SP_trigger_counter (edict_t *self)
{
	self->wait = -1;
	if (!self->count)
		self->count = 2;

	self->use = trigger_counter_use;
}


/*
==============================================================================

trigger_always

==============================================================================
*/

/*QUAKED trigger_always (.5 .5 .5) (-8 -8 -8) (8 8 8)
This trigger will always fire.  It is activated by the world.
*/
void SP_trigger_always (edict_t *ent)
{
	// we must have some delay to make sure our use targets are present
	if (ent->delay < 0.2)
		ent->delay = 0.2;
	G_UseTargets(ent, ent);
}


/*
==============================================================================

trigger_push

==============================================================================
*/
//#if 0
#define PUSH_ONCE		1

static int windsound;

void trigger_push_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (strcmp(other->classname, "grenade") == 0)
	{
		VectorScale (self->movedir, self->speed * 10, other->velocity);
	}
	else if (other->health > 0)
	{
		VectorScale (self->movedir, self->speed * 10, other->velocity);

		if (other->client)
		{
			// don't take falling damage immediately from this
			VectorCopy (other->velocity, other->client->oldvelocity);
			if (other->fly_sound_debounce_time < level.time)
			{
				other->fly_sound_debounce_time = level.time + 1.5;
				gi.sound (other, CHAN_AUTO, windsound, 1, ATTN_NORM, 0);
			}
		}
	}
	if (self->spawnflags & PUSH_ONCE)
		G_FreeEdict (self);
}

void SP_trigger_push (edict_t *self)
{
	InitTrigger (self);
	windsound = gi.soundindex ("misc/windfly.wav");
	self->touch = trigger_push_touch;
	if (!self->speed)
		self->speed = 1000;
	gi.linkentity (self);
}
//#endif
#if 0
// RAFAEL
#define PUSH_ONCE  1

static int windsound;

void trigger_push_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (strcmp(other->classname, "grenade") == 0)
	{
		VectorScale (self->movedir, self->speed * 10, other->velocity);
	}
	else if (other->health > 0)
	{	
		VectorScale (self->movedir, self->speed * 10, other->velocity);

		if (other->client)
		{
			// don't take falling damage immediately from this
			VectorCopy (other->velocity, other->client->oldvelocity);
			if (other->fly_sound_debounce_time < level.time)
			{
				other->fly_sound_debounce_time = level.time + 1.5;
				gi.sound (other, CHAN_AUTO, windsound, 1, ATTN_NORM, 0);
			}
		}
	}
	if (self->spawnflags & PUSH_ONCE)
	G_FreeEdict (self);
}


/*QUAKED trigger_push (.5 .5 .5) ? PUSH_ONCE PUSH_PLUS PUSH_RAMP
Pushes the player
"speed"  defaults to 1000
"wait"  defaults to 10 must use PUSH_PLUS  used for on
*/

void trigger_push_active (edict_t *self);

void trigger_effect (edict_t *self)
{
	vec3_t	origin;
	vec3_t	size;
	int		i;
	
	VectorScale (self->size, 0.5, size);
	VectorAdd (self->absmin, size, origin);
		
}

void trigger_push_inactive (edict_t *self)
{
	if (self->delay > level.time)
	{
		self->nextthink = level.time + 0.1;
	}
	else
	{
		self->touch = trigger_push_touch;
		self->think = trigger_push_active;
		self->nextthink = level.time + 0.1;
		self->delay = self->nextthink + self->wait;  
	}
}

void trigger_push_active (edict_t *self)
{
	if (self->delay > level.time)
	{
		self->nextthink = level.time + 0.1;
		trigger_effect (self);
	}
	else
	{
		self->touch = NULL;
		self->think = trigger_push_inactive;
		self->nextthink = level.time + 0.1;
		self->delay = self->nextthink + self->wait;  
	}
}

void SP_trigger_push (edict_t *self)
{
	InitTrigger (self);
	windsound = gi.soundindex ("misc/windfly.wav");
	self->touch = trigger_push_touch;
	
	if (self->spawnflags & 2)
	{
		if (!self->wait)
			self->wait = 10;
  
		self->think = trigger_push_active;
		self->nextthink = level.time + 0.1;
		self->delay = self->nextthink + self->wait;
	}

	if (!self->speed)
		self->speed = 1000;
	
	gi.linkentity (self);

}
#endif
/*
==============================================================================

trigger_hurt

==============================================================================
*/

/*QUAKED trigger_hurt (.5 .5 .5) ? START_OFF TOGGLE SILENT NO_PROTECTION SLOW
Any entity that touches this will be hurt.

It does dmg points of damage each server frame

SILENT			supresses playing the sound
SLOW			changes the damage rate to once per second
NO_PROTECTION	*nothing* stops the damage

"dmg"			default 5 (whole numbers only)

*/
void hurt_use (edict_t *self, edict_t *other, edict_t *activator)
{
	if (self->solid == SOLID_NOT)
		self->solid = SOLID_TRIGGER;
	else
		self->solid = SOLID_NOT;
	gi.linkentity (self);

	if (!(self->spawnflags & 2))
		self->use = NULL;
}


void hurt_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	int		dflags;

	if (!other->takedamage)
		return;

	if (self->timestamp > level.time)
		return;

	if (self->spawnflags & 16)
		self->timestamp = level.time + 1;
	else
		self->timestamp = level.time + FRAMETIME;

	if (!(self->spawnflags & 4))
	{
		if ((level.framenum % 10) == 0)
			gi.sound (other, CHAN_AUTO, self->noise_index, 1, ATTN_NORM, 0);
	}

	if (self->spawnflags & 8)
		dflags = DAMAGE_NO_PROTECTION;
	else
		dflags = 0;
	T_Damage (other, self, self, vec3_origin, other->s.origin, vec3_origin, self->dmg, self->dmg, dflags, MOD_TRIGGER_HURT);
}

void SP_trigger_hurt (edict_t *self)
{
	InitTrigger (self);

	// JOSEPH 29-MAR-99
	//self->noise_index = gi.soundindex ("world/electro.wav");
	// END JOSEPH
	self->touch = hurt_touch;

	if (!self->dmg)
		self->dmg = 5;

	if (self->spawnflags & 1)
		self->solid = SOLID_NOT;
	else
		self->solid = SOLID_TRIGGER;

	if (self->spawnflags & 2)
		self->use = hurt_use;

	gi.linkentity (self);
}

// JOSEPH 23-MAR-99
/*
==============================================================================

trigger_hurt_fire

==============================================================================
*/

/*QUAKED trigger_hurt_fire (.5 .5 .5) ? START_OFF TOGGLE SILENT NO_PROTECTION SLOW
Any entity that touches this will be hurt.

It does dmg points of damage each server frame and burns the player

SILENT			supresses playing the sound
SLOW			changes the damage rate to once per second
NO_PROTECTION	*nothing* stops the damage

"dmg"			default 5 (whole numbers only)

*/
void hurt_use_fire (edict_t *self, edict_t *other, edict_t *activator)
{
	if (self->solid == SOLID_NOT)
		self->solid = SOLID_TRIGGER;
	else
		self->solid = SOLID_NOT;
	gi.linkentity (self);

	if (!(self->spawnflags & 2))
		self->use = NULL;
}

void hurt_touch_fire (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	int		dflags;

	// JOSEPH 11-APR-99	
	//if (!other->client)
	//	return;
	// END JOSEPH
	
	if (self->timestamp > level.time)
		return;

	if (self->spawnflags & 16)
		self->timestamp = level.time + 1;
	else
		self->timestamp = level.time + FRAMETIME;

	if (!(self->spawnflags & 4))
	{
		if ((level.framenum % 10) == 0)
			gi.sound (other, CHAN_AUTO, self->noise_index, 1, ATTN_NORM, 0);
	}

	if (self->spawnflags & 8)
		dflags = DAMAGE_NO_PROTECTION;
	else
		dflags = 0;

    T_Damage (other, other, other, vec3_origin, other->s.origin, vec3_origin, self->dmg, self->dmg, dflags, MOD_FLAMETHROWER);	
	// JOSEPH 29-MAR-99
	//gi.sound (other, CHAN_BODY, gi.soundindex ("misc/fhit3.wav"), 1, ATTN_NORM, 0);
	// END JOSEPH
}

void SP_trigger_hurt_fire (edict_t *self)
{
	InitTrigger (self);

	// JOSEPH 29-MAR-99
	//self->noise_index = gi.soundindex ("world/electro.wav");
	// END JOSEPH
	self->touch = hurt_touch_fire;

	if (!self->dmg)
		self->dmg = 5;

	if (self->spawnflags & 1)
		self->solid = SOLID_NOT;
	else
		self->solid = SOLID_TRIGGER;

	if (self->spawnflags & 2)
		self->use = hurt_use_fire;

	gi.linkentity (self);
}
// END JOSEPH

/*
==============================================================================

trigger_gravity

==============================================================================
*/

/*QUAKED trigger_gravity (.5 .5 .5) ?
Changes the touching entites gravity to
the value of "gravity".  1.0 is standard
gravity for the level.
*/

void trigger_gravity_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	other->gravity = self->gravity;
}

void SP_trigger_gravity (edict_t *self)
{
	if (st.gravity == 0)
	{
		gi.dprintf("trigger_gravity without gravity set at %s\n", vtos(self->s.origin));
		G_FreeEdict  (self);
		return;
	}

	InitTrigger (self);
	self->gravity = atoi(st.gravity);
	self->touch = trigger_gravity_touch;
}


/*
==============================================================================

trigger_monsterjump

==============================================================================
*/

/*QUAKED trigger_monsterjump (.5 .5 .5) ?
Walking monsters that touch this will jump in the direction of the trigger's angle
"speed" default to 200, the speed thrown forward
"height" default to 200, the speed thrown upwards
*/

void trigger_monsterjump_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if (other->flags & (FL_FLY | FL_SWIM) )
		return;
	if (other->svflags & SVF_DEADMONSTER)
		return;
	if ( !(other->svflags & SVF_MONSTER))
		return;

// set XY even if not on ground, so the jump will clear lips
	other->velocity[0] = self->movedir[0] * self->speed;
	other->velocity[1] = self->movedir[1] * self->speed;
	
	if (!other->groundentity)
		return;
	
	other->groundentity = NULL;
	other->velocity[2] = self->movedir[2];
}

void SP_trigger_monsterjump (edict_t *self)
{
	if (!self->speed)
		self->speed = 200;
	if (!st.height)
		st.height = 200;
	if (self->s.angles[YAW] == 0)
		self->s.angles[YAW] = 360;
	InitTrigger (self);
	self->touch = trigger_monsterjump_touch;
	self->movedir[2] = st.height;
}

void unlock_sound (edict_t *self)
{
	gi.sound (self, CHAN_VOICE, gi.soundindex("world/doors/dr_unlock.wav"), 1, ATTN_NORM, 0);
	self->think = G_FreeEdict;
	self->nextthink = level.time + 1.0;
}


// JOSEPH 1-MAR-99
/*QUAKED trigger_unlock (.5 .5 .5) ?
Player will unlock a targeted door when this brush is touched
Can be triggered also!
door's "key" should equal -1
"target" target ID to match door
*/

void Touch_unlock (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t	*e;
	int		i;
	
	// Make sure player triggered brush
	if (!((other->classname) && (strcmp(other->classname, "player") == 0)))
		return;
	
	// Find target entity
	self->target_ent = 0;

	if (self->target)
	{
		for (i=1, e=g_edicts+i ; i < globals.num_edicts ; i++,e++)
		{
			if ((e->targetname) && (!strcmp(e->targetname, self->target)))
			{
				self->target_ent = e;
				break;	
			}
		}	
	}

	// No target found
	if (self->target_ent)
	{
		// Unlock target door
		if (self->target_ent->key == -1)
		{
			self->target_ent->key = 0;	
			// snap, store ent info in struct so we can respawn it later
	        level.num_ent_respawn++;
			level.ent_to_respawn[level.num_ent_respawn].ent = self->target_ent;
			level.ent_to_respawn[level.num_ent_respawn].ent_type = UNLOCK;
//			self->target_ent->targetname = NULL;
			// JOSEPH 24-JAN-99
			{
				edict_t *unlock;

				unlock = G_Spawn();
				unlock->think = unlock_sound;
				unlock->nextthink = level.time + 0.1;
				if (other)
					VectorCopy (other->s.origin, unlock->s.origin);
				gi.linkentity(unlock);
			}
		}
	}
// snap, dont free this
//	G_FreeEdict(self);
}
/*
void Use_unlock (edict_t *self, edict_t *other, edict_t *activator)
{
	edict_t	*e;
	int		i;
	
	// Make sure player triggered brush
	// if (!((activator->classname) && (strcmp(activator->classname, "player") == 0)) || !(other->cast_info.aiflags & AI_DOKEY))
	// 	return;
	
	// Find target entity
	self->target_ent = 0;

	if (self->target)
	{
		for (i=1, e=g_edicts+i ; i < globals.num_edicts ; i++,e++)
		{
			if ((e->targetname) && (!strcmp(e->targetname, self->target)))
			{
				self->target_ent = e;
				break;	
			}
		}	
	}

	// No target found
	if (self->target_ent)
	{
		// Unlock target door
		if (self->target_ent->key == -1)
		{
			self->target_ent->key = 0;	
			// Don't tigger door
			self->target = NULL;
			self->target_ent->targetname = NULL;
			// JOSEPH 24-JAN-99

			{
				edict_t *unlock;

				unlock = G_Spawn();
				unlock->think = unlock_sound;
				unlock->nextthink = level.time + 0.1;
				if (activator)
					VectorCopy (other->s.origin, unlock->s.origin);
				gi.linkentity(unlock);
			}
		}
	}

	G_FreeEdict(self);
}
*/
void SP_trigger_unlock (edict_t *self)
{
	self->solid = SOLID_TRIGGER;
	gi.setmodel (self, self->model);
    self->svflags |= SVF_NOCLIENT;
	self->touch = Touch_unlock;
//	self->use = Use_unlock;
	gi.linkentity (self);
}
// END JOSEPH

// JOSEPH 16-MAR-99
/*QUAKED trigger_motorcycle (.5 .5 .5) ?
Will trigger the motorcycle
*/
extern int EP_skidrow_touch_motorcycle_that_needs_battery_to_start (edict_t *self, edict_t *trigger);

void Touch_motorcycle (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	// Make sure player triggered brush
	if (!((other->classname) && (strcmp(other->classname, "player") == 0)))
		return;
	
	// Call motorcycle episode function
    if (EP_skidrow_touch_motorcycle_that_needs_battery_to_start (other, self))
		G_FreeEdict(self);
}
// END JOSEPH

void SP_trigger_motorcycle (edict_t *self)
{
	self->solid = SOLID_TRIGGER;
	gi.setmodel (self, self->model);
    self->svflags |= SVF_NOCLIENT;
	self->touch = Touch_motorcycle;
	gi.linkentity (self);
}


/*QUAKED trigger_hurt_electric (.5 .5 .5) ? START_OFF TOGGLE SILENT NO_PROTECTION SLOW
Any entity that touches this will be hurt.

it does dmg of electric damage

SILENT			supresses playing the sound
SLOW			changes the damage rate to once per second
NO_PROTECTION	*nothing* stops the damage

"dmg"			default 5 (whole numbers only)

"count"			is the number of sparks

*/
void hurt_use_electric (edict_t *self, edict_t *other, edict_t *activator)
{
	if (self->solid == SOLID_NOT)
		self->solid = SOLID_TRIGGER;
	else
		self->solid = SOLID_NOT;
	
	//if (!(self->spawnflags & 2))
	//	self->use = NULL;
}

void hurt_touch_electric (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	int		dflags;

	if (self->timestamp > level.time)
		return;

	if (self->spawnflags & 16)
		self->timestamp = level.time + 1;
	else
		self->timestamp = level.time + FRAMETIME;

	if (!(self->spawnflags & 4))
	{
		if ((level.framenum % 10) == 0)
			gi.sound (other, CHAN_AUTO, self->noise_index, 1, ATTN_NORM, 0);
	}

	if (self->spawnflags & 8)
		dflags = DAMAGE_NO_PROTECTION;
	else
		dflags = 0;

	{
		vec3_t startpos;
		int		i;

		VectorCopy (other->s.origin, startpos);
		
		for (i=0 ; i<4; i++)
		{
			startpos[2] += other->viewheight + ((crandom() * 16) - 8);
		
			gi.WriteByte (svc_temp_entity);
			gi.WriteByte (TE_SPLASH);
			gi.WriteByte (self->count);
			gi.WritePosition (startpos);
			gi.WriteDir (self->movedir);
			// JOSEPH 17-MAY-99
			if (other->client)
				gi.WriteByte (SPLASH_SPARKS_P);
			else 
				gi.WriteByte (1);
			// END JOSEPH
			gi.multicast (other->s.origin, MULTICAST_PVS);
		
		}

		if (other->client)
		{
			VectorScale (self->movedir, self->speed, other->velocity);
			gi.sound(other, CHAN_VOICE, gi.soundindex("world/shock.wav"), 1, ATTN_NORM, 0);
			T_Damage (other, other, other, vec3_origin, other->s.origin, vec3_origin, self->dmg, self->dmg, dflags, MOD_FALLING);	
		}
	}
	
}

void SP_trigger_hurt_electric (edict_t *self)
{
	InitTrigger (self);

	self->touch = hurt_touch_electric;

	if (!self->dmg)
		self->dmg = 5;

	if (self->spawnflags & 1)
		self->solid = SOLID_NOT;
	else
		self->solid = SOLID_TRIGGER;

	if (self->spawnflags & 2)
		self->use = hurt_use_electric;

	//if (!self->count)
		self->count = 5;

	gi.linkentity (self);
}


// ***************************************
// *  Snap - VIP Trigger Code Below      *
// ***************************************
//Sed trigger vip stuff
void vip_trigger (edict_t *ent)
{
	if (ent->nextthink)
		return;		// already been triggered

	G_UseTargets (ent, ent->activator);

	//snap, changed this
	if (!level.roundover)
	{
		level.round_end_frame = level.framenum;
		level.roundover = TRUE;
		level.roundover_type = VIP_ESCAPED;
		return;

	}

	if (ent->wait > 0)	
	{
		ent->think = multi_wait;
		ent->nextthink = level.time + ent->wait;
	}
	else
	{	// we can't just remove (self) here, because this is a touch function
		// called while looping through area links...
		ent->touch = NULL;
		ent->nextthink = level.time + FRAMETIME;
		ent->think = G_FreeEdict;
	}
}

void Use_vip (edict_t *ent, edict_t *other, edict_t *activator)
{
	ent->activator = activator;
	vip_trigger (ent);

}

void Touch_VIP (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if(other->client)
	{
		// return if the person that touched the trigger is not the VIP
		if(self->spawnflags & 2 || other->crashType != CRASH_VIP)
			return;
	}
	else if (other->svflags & SVF_MONSTER)
	{
		if (!(self->spawnflags & 1))
			return;
	}
	else
		return;

	if (!VectorCompare(self->movedir, vec3_origin))
	{
		vec3_t	forward;

		AngleVectors(other->s.angles, forward, NULL, NULL);
		if (_DotProduct(forward, self->movedir) < 0)
			return;
	}

	self->activator = other;
    vip_trigger (self);
}

void vip_enable (edict_t *self, edict_t *other, edict_t *activator)
{
	self->solid = SOLID_TRIGGER;
	self->use = Use_vip;
	gi.linkentity (self);
}

void SP_trigger_vip (edict_t *ent)
{
	// setup game type
	level.crash_gametype = VIP_MAP;

	if (!ent->wait)
		ent->wait = 0.2;
	ent->touch = Touch_VIP;
	ent->movetype = MOVETYPE_NONE;
	ent->svflags |= SVF_NOCLIENT;


	if (ent->spawnflags & 4)
	{
		ent->solid = SOLID_NOT;
		ent->use = vip_enable;
	}
	else
	{
		ent->solid = SOLID_TRIGGER;
		ent->use = Use_vip;
	}

	if (!VectorCompare(ent->s.angles, vec3_origin))
		G_SetMovedir (ent->s.angles, ent->movedir);

	gi.setmodel (ent, ent->model);
	gi.linkentity (ent);
}
//Sed end

// ***************************************
// *  Snap - Bomb trigger Code Below     *
// ***************************************
void bomb_trigger (edict_t *ent)
{
	// snap - entity cannot trigger this if the client is not the bomb holder
	if (ent->activator->crashType != CRASH_BOMBHOLDER)
		return;

	if (ent->nextthink)
		return;		// already been triggered

	G_UseTargets (ent, ent->activator);

	// snap, the bomber is in the target zone and crouching, set the frame number this happened
	if (ent->activator->client->ps.pmove.pm_flags & PMF_DUCKED)
		ent->activator->at_target_frame = level.framenum;

	if (ent->wait > 0)	
	{
		ent->think = multi_wait;
		ent->nextthink = level.time + ent->wait;
	}
	else
	{	// we can't just remove (self) here, because this is a touch function
		// called while looping through area links...
		ent->touch = NULL;
		ent->nextthink = level.time + FRAMETIME;
		ent->think = G_FreeEdict;
	}
}

void Use_bomb (edict_t *ent, edict_t *other, edict_t *activator)
{
	ent->activator = activator;
	bomb_trigger (ent);

}

void Touch_bomb (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if(other->client){
		if(self->spawnflags & 2)
			return;
	}

	else if (other->svflags & SVF_MONSTER)
	{
		if (!(self->spawnflags & 1))
			return;
	}
	else
		return;

	if (!VectorCompare(self->movedir, vec3_origin))
	{
		vec3_t	forward;

		AngleVectors(other->s.angles, forward, NULL, NULL);
		if (_DotProduct(forward, self->movedir) < 0)
			return;
	}

	self->activator = other;
    bomb_trigger (self);
}

void bomb_enable (edict_t *self, edict_t *other, edict_t *activator)
{
	self->solid = SOLID_TRIGGER;
	self->use = Use_bomb;
	gi.linkentity (self);
}

void SP_trigger_bomb (edict_t *ent)
{
	// setup game type
	level.crash_gametype = BOMB_MAP;

	if (!ent->wait)
		ent->wait = 0.2;
	ent->touch = Touch_bomb;
	ent->movetype = MOVETYPE_NONE;
	ent->svflags |= SVF_NOCLIENT;

	if (ent->spawnflags & 4)
	{
		ent->solid = SOLID_NOT;
		ent->use = bomb_enable;
	}
	else
	{
		ent->solid = SOLID_TRIGGER;
		ent->use = Use_bomb;
	}

	if (!VectorCompare(ent->s.angles, vec3_origin))
		G_SetMovedir (ent->s.angles, ent->movedir);

	gi.setmodel (ent, ent->model);
	gi.linkentity (ent);
}

//FREDZ new not really good place but easyr fix.
void SP_crash_vip(edict_t *ent)
{
	// setup game type
	level.crash_gametype = VIP_MAP;

	if (!ent->wait)
		ent->wait = 0.2;
	ent->touch = Touch_VIP;
	ent->movetype = MOVETYPE_NONE;
//	ent->svflags |= SVF_NOCLIENT;

	//FREDZ
	if (!strcmp(ent->type, "small"))
	{
		ent->model = "models/props/phone/tris.md2";
		ent->s.modelindex = gi.modelindex(ent->model);

		//Same size as dm_safebag for playing bagman maps
		VectorSet(ent->mins, -12, -12, -16);
		VectorSet(ent->maxs, 12, 12, 12);

//		ent->s.origin[2] -= 10;
	}
	else if (!strcmp(ent->type, "bike"))
	{
		edict_t	*moto = NULL;
		extern void SP_props_motorcycle(edict_t *self);

		moto = G_Spawn();

		SP_props_motorcycle(moto);

		VectorSet(ent->mins, -60, -20, -26);
		VectorSet(ent->maxs, 60, 20, 26);
	}
	else
	{
		VectorSet(ent->mins, -64, -64, -24);
		VectorSet(ent->maxs, 64, 64, 48);
	}

/*	if (ent->spawnflags & 4)//FREDZ enity not really needed.
	{
		ent->solid = SOLID_NOT;
		ent->use = vip_enable;
	}
	else*/
	{
		ent->solid = SOLID_TRIGGER;
		ent->use = Use_vip;
	}

//	if (!VectorCompare(ent->s.angles, vec3_origin))/FREDZ not needed.
//		G_SetMovedir(ent->s.angles, ent->movedir);

//	gi.setmodel(ent, ent->model); / FREDZ not needed.
	gi.linkentity(ent);
}
void SP_crash_bomb(edict_t *ent)
{
	// setup game type
	level.crash_gametype = BOMB_MAP;

	if (!ent->wait)
		ent->wait = 0.2;
	ent->touch = Touch_bomb;
	ent->movetype = MOVETYPE_NONE;
//	ent->svflags |= SVF_NOCLIENT;

	//FREDZ
	if (!strcmp(ent->type, "small"))
	{
		ent->model = "models/props/radio/tris.md2";
		ent->s.modelindex = gi.modelindex(ent->model);

		//Radio still need to explode

		//Same size as dm_safebag for playing bagman maps
		VectorSet(ent->mins, -12, -12, -16);
		VectorSet(ent->maxs, 12, 12, 12);

//		ent->s.origin[2] -= 8;
	}
	else if (!strcmp(ent->type, "bike"))
	{
		edict_t	*moto = NULL;
		extern void SP_props_motorcycle(edict_t *self);

		moto = G_Spawn();

		SP_props_motorcycle(moto);

		VectorSet(ent->mins, -60, -20, -26);
		VectorSet(ent->maxs, 60, 20, 26);
	}
	if (!strcmp(ent->type, "cross"))
	{
		ent->model = "models/object/cross/tris.md2";
		ent->s.modelindex = gi.modelindex(ent->model);

		//Same size as dm_safebag for playing bagman maps
		VectorSet(ent->mins, -12, -12, -16);
		VectorSet(ent->maxs, 12, 12, 12);
	}
	else
	{
		VectorSet(ent->mins, -64, -64, -24);
		VectorSet(ent->maxs, 64, 64, 48);
	}

/*	if (ent->spawnflags & 4)//FREDZ enity not really needed.
	{
		ent->solid = SOLID_NOT;
		ent->use = bomb_enable;
	}
	else*/
	{
		ent->solid = SOLID_TRIGGER;
		ent->use = Use_bomb;
	}

//	if (!VectorCompare(ent->s.angles, vec3_origin)) // FREDZ not needed.
//		G_SetMovedir(ent->s.angles, ent->movedir);

//	gi.setmodel(ent, ent->model); // FREDZ not needed.
	gi.linkentity(ent);
}