#include "g_local.h"

extern void GangScoreboardMessage (edict_t *ent, edict_t *killer);
extern void CrashScoreboardMessage (edict_t *ent, edict_t *killer);
extern void RadioMessage (edict_t *ent);
extern void ScopeScore (edict_t *ent);

#define ENABLE_INDEX_NAMES		1


// MH: show chase message, pre-match notice, scoreboard key notice
void ScoreboardFooter(char *string, edict_t *ent)
{
	char	entry[1024];
	int		j;
	int		stringlength;

	entry[0] = 0;
	if (level.modeset == PRE_MATCH && !level.roundover)
	{
		strcpy(entry, "xm -145 yb -68 dmstr 993 \"The game will start when each\" xm -130 yb -50 dmstr 993 \"team has at least 1 player\"");
	}
	else if (level.modeset == MATCH && ent->client->pers.spectator == SPECTATING)
	{
		if (!ent->client->chase_target)
		{
			if (!ent->client->pers.team)
				strcpy(entry, "xm -105 yb -50 dmstr 773 \"hit ACTIVATE to chase\" ");
		}
		else if (ent->client->chase_target->client)
		{
			if (ent->client->pers.team)
			{
				if(ent->client->chasemode == FREE_CHASE)
					sprintf(entry, "xm -160 yb -64 dmstr 773 \"chasing %s in freelook mode\" xm -145 yb -40 dmstr 552 \"[ and ] cycles, JUMP changes mode\" ",
						ent->client->chase_target->client->pers.netname);
				else
					sprintf(entry, "xm -150 yb -64 dmstr 773 \"chasing %s in locked mode\" xm -145 yb -40 dmstr 552 \"[ and ] cycles, JUMP changes mode\" ",
						ent->client->chase_target->client->pers.netname);
			}
			else
			{
				if(ent->client->chasemode == FREE_CHASE)
					sprintf(entry, "xm -160 yb -64 dmstr 773 \"chasing %s in freelook mode\" xm -225 yb -40 dmstr 552 \"[ and ] cycles, JUMP changes mode, ACTIVATE quits\" ",
						ent->client->chase_target->client->pers.netname);
				else
					sprintf(entry, "xm -150 yb -64 dmstr 773 \"chasing %s in locked mode\" xm -225 yb -40 dmstr 552 \"[ and ] cycles, JUMP changes mode, ACTIVATE quits\" ",
						ent->client->chase_target->client->pers.netname);
			}
		}
	}
	else if (level.modeset == ENDGAMEVOTE)
	{
		if (ent->client->showscores == SCORE_MAP_VOTE)
			strcpy(entry, "xm -230 yb -40 dmstr 552 \"hit your scoreboard key (f1) for the scoreboard\" ");
		else
			strcpy(entry, "xm -230 yb -40 dmstr 552 \"hit your scoreboard key (f1) for the vote menu\" ");
	}
	if (entry[0])
	{
		j = strlen(entry);
		stringlength = strlen(string);
		if (stringlength + j < 1024)
			strcpy (string + stringlength, entry);
	}
}


/*
======================================================================

INTERMISSION

======================================================================
*/

void MoveClientToIntermission (edict_t *ent)
{
/*	if (deathmatch->value || coop->value)
		ent->client->showscores = SCOREBOARD;
snap, this is set right before intermission based on who wins
*/
	VectorCopy (level.intermission_origin, ent->s.origin);
	ent->client->ps.pmove.origin[0] = level.intermission_origin[0]*8;
	ent->client->ps.pmove.origin[1] = level.intermission_origin[1]*8;
	ent->client->ps.pmove.origin[2] = level.intermission_origin[2]*8;
	VectorCopy (level.intermission_angle, ent->client->ps.viewangles);
	ent->client->ps.pmove.pm_type = PM_FREEZE;
	ent->client->ps.gunindex = 0;
	ent->client->ps.blend[3] = 0;
	ent->client->ps.rdflags &= ~RDF_UNDERWATER;

	// clean up powerup info
//	ent->client->quad_framenum = 0;//Q2
//	ent->client->invincible_framenum = 0;//Q2
//	ent->client->breather_framenum = 0;//Q2
//	ent->client->enviro_framenum = 0;//Q2
//	ent->client->grenade_blew_up = false;//Q2
//	ent->client->grenade_time = 0;//Q2

	// RAFAEL
//	ent->client->quadfire_framenum = 0;//Q2 Xatrix MOD

	// RAFAEL
//	ent->client->trap_blew_up = false;//Q2 Xatrix MOD
//	ent->client->trap_time = 0;//Q2 Xatrix MOD

	ent->viewheight = 0;
	ent->s.modelindex = 0;
//	ent->s.modelindex2 = 0;//Q2
//	ent->s.modelindex3 = 0;//Q2
	ent->s.effects = 0;
	ent->s.sound = 0;
	ent->solid = SOLID_NOT;

	ent->playing_ingame = FALSE; // MH:

	// add the layout

	if (deathmatch->value || coop->value)
	{
		ent->client->resp.scoreboard_frame = 0; // MH: trigger scoreboard update instead of calling DeathmatchScoreboard
//		gi.unicast (ent, true);
	}

}

void BeginIntermission (edict_t *targ)
{
	int		i, n;
	edict_t	*ent, *client;

	if (level.intermissiontime)
		return;		// already activated

	game.autosaved = false;

	// respawn any dead clients
	for (i=0 ; i<maxclients->value ; i++)
	{
		client = g_edicts + 1 + i;
		if (!client->inuse)
			continue;
		if (client->health <= 0)
			respawn(client);
	}

	level.intermissiontime = level.time;
	
	level.changemap = targ ? targ->map : ""; // MH:

	if (strstr(level.changemap, "*"))
	{
		//if (coop->value)
		{
			for (i=0 ; i<maxclients->value ; i++)
			{
				client = g_edicts + 1 + i;
				if (!client->inuse)
					continue;
				// strip players of all keys between units
				for (n = 0; n < MAX_ITEMS; n++)
				{
					if (itemlist[n].flags & IT_FLASHLIGHT)
						continue;

					if (itemlist[n].flags & IT_KEY)
						client->client->pers.inventory[n] = 0;
				}

				client->episode_flags = client->client->pers.episode_flags = 0;
				client->client->pers.friends = 0;
				level.helpchange = 0;
			}
		}

		// Dan: this should eliminate the need to press a key to exit the end of episode
		if (!deathmatch->value)
		{
			level.exitintermission = 1;		// go immediately to the next level
			return;
		}
	}
	else
	{
		if (!deathmatch->value)
		{
			level.exitintermission = 1;		// go immediately to the next level
			return;
		}
	}

	level.exitintermission = 0;


	// find an intermission spot
	ent = G_Find (NULL, FOFS(classname), "info_player_intermission");
	if (!ent)
	{	// the map creator forgot to put in an intermission point...
		ent = G_Find (NULL, FOFS(classname), "info_player_start");
//		if (!ent)//FREDZ not using
//			ent = G_Find (NULL, FOFS(classname), "info_player_deathmatch");
	}
	else
	{	// chose one of four spots
		i = rand() & 3;
		while (i--)
		{
			ent = G_Find (ent, FOFS(classname), "info_player_intermission");
			if (!ent)	// wrap around the list
				ent = G_Find (ent, FOFS(classname), "info_player_intermission");
		}
	}

	VectorCopy (ent->s.origin, level.intermission_origin);
	VectorCopy (ent->s.angles, level.intermission_angle);

	// move all clients to the intermission point
	for (i=0 ; i<maxclients->value ; i++)
	{
		client = g_edicts + 1 + i;
		if (!client->inuse)
			continue;
		MoveClientToIntermission (client);
	}
}
//===================================================================
//
// Papa - The following are the various scoreboards that I use 
//
//		phear id's confusing format - check qdevels on planetquake if
//		you don't understand this crap
//
//		one hint - dmstr xxx is the rgb color of the text :)
//
//===================================================================
//===================================================================

//snap, the following functions are for my scoreboards

void NoScoreboardMessage (edict_t *ent)
{
	char	string[1400];
	int		stringlength;

	string[0] = 0;
	stringlength = 0;

	// MH: show message to bomber/VIP at start of round
	if (ent->crashType == CRASH_BOMBHOLDER && level.framenum < ent->client->resp.enterframe + 30)
	{
		strcpy(string, "xm -235 yv -9 dmstr 999 \"You have the bomb! Try to plant it at a target!\" " );
		stringlength = strlen(string);
	}
	else if (ent->crashType == CRASH_VIP && level.framenum < ent->client->resp.enterframe + 30)
	{
		strcpy(string, "xm -270 yv -9 dmstr 999 \"You are the VIP! Try to get to the escape point alive!\" " );
		stringlength = strlen(string);
	}

	ScoreboardFooter(string, ent); // MH: show chase message and pre-match notice

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}


/*
void RadarScoreboardMessage (edict_t *ent)
{
	edict_t		*e;
	int         k;
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		j;
	vec3_t	v, v2 = { 9999 };
	float	len;


	string[0] = 0;
	stringlength = 0;

	Com_sprintf (entry, sizeof(entry),
		"xl %i yt %i picn %s ",
		5, 5, PIC_SCANNER_TAG );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	// MH: show bomb targets or VIP escape point
	k = 0;
	e = NULL;
	while (e = G_Find(e, FOFS(classname), level.crash_gametype == BOMB_MAP ? "trigger_bomb" : "trigger_vip"))
	{
		VectorSet(v, (e->mins[0] + e->maxs[0]) / 2, (e->mins[1] + e->maxs[1]) / 2, 0);
		if (v2[0] != 9999 && VectorDistance(v, v2) < 500) // some maps have a cluster of trigger_bomb
			continue;
		VectorCopy(v, v2);
		VectorSubtract (ent->s.origin, v, v);
		v[2] = 0;
		len = VectorLength (v);
		if (len <= SCANNER_RANGE)
		{
			int		sx, sy;
			vec3_t	dp;
			vec3_t	normal = {0,0,-1};

			VectorNormalize(v);
			RotatePointAroundVector( dp, normal, v, ent->s.angles[1]);
			VectorScale(dp,len*60/SCANNER_RANGE,dp);

			sx = 68 + dp[1];
			sy = 68 + dp[0]; 

			Com_sprintf (entry, sizeof(entry),
				"xl %i yt %i picn %s ",
				sx, sy, PIC_DOT2_TAG );

			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
		if (++k == 2)
			break;
	}

	for_each_player (e,k)
	{
		if (e->client->pers.team != ent->client->pers.team || e == ent || e->playing_ingame == FALSE){
			continue;
		}

		VectorSubtract (ent->s.origin, e->s.origin, v);

		v[2] = 0;

		len = VectorLength (v);

		if (len <= SCANNER_RANGE)
		{
			int		sx,
					sy;

			vec3_t	dp;

			vec3_t	normal = {0,0,-1};

			VectorNormalize(v);

			RotatePointAroundVector( dp, normal, v, ent->s.angles[1]);

			VectorScale(dp,len*60/SCANNER_RANGE,dp);


			sx = 68 + dp[1];  
			sy = 68 + dp[0];   

			// MH: indicate vip or bomb holder
			if ((e->crashType == CRASH_VIP || e->crashType == CRASH_BOMBHOLDER) && (level.framenum % 10) < 5)
				Com_sprintf (entry, sizeof(entry),
					"xl %i yt %i picn %s ",
					sx, sy, PIC_DOT2_TAG );
			else
				Com_sprintf (entry, sizeof(entry),
					"xl %i yt %i picn %s ",
					sx, sy, PIC_DOT_TAG );

			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;

		}
	}

	// MH: show dropped bomb
	if (ent->client->pers.team == 2 && level.crash_gametype == BOMB_MAP && (level.framenum % 10) < 5 && (e = G_Find(NULL, FOFS(classname), "weapon_bomb")))
	{
		VectorSubtract (ent->s.origin, e->s.origin, v);
		v[2] = 0;
		len = VectorLength (v);
		if (len <= SCANNER_RANGE)
		{
			int		sx, sy;
			vec3_t	dp;
			vec3_t	normal = {0,0,-1};

			VectorNormalize(v);
			RotatePointAroundVector( dp, normal, v, ent->s.angles[1]);
			VectorScale(dp,len*60/SCANNER_RANGE,dp);

			sx = 68 + dp[1];
			sy = 68 + dp[0]; 

			Com_sprintf (entry, sizeof(entry),
				"xl %i yt %i picn %s ",
				sx, sy, PIC_DOT2_TAG );

			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}

	// MH: show message to bomber/VIP at start of round
	if (ent->crashType == CRASH_BOMBHOLDER && level.framenum < ent->client->resp.enterframe + 30)
	{
		strcpy(entry, "xm -235 yv -9 dmstr 999 \"You have the bomb! Try to plant it at a target!\" " );

		j = strlen(entry);
		if (stringlength + j < 1024)
		{
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}
	else if (ent->crashType == CRASH_VIP && level.framenum < ent->client->resp.enterframe + 30)
	{
		strcpy(entry, "xm -270 yv -9 dmstr 999 \"You are the VIP! Try to get to the escape point alive!\" " );

		j = strlen(entry);
		if (stringlength + j < 1024)
		{
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}

	// MH: show radar key
	if (ent->client->resp.radarhint < 30)
	{
		ent->client->resp.radarhint++;
		if (level.crash_gametype == BOMB_MAP)
		{
			strcpy(entry, "xl 8 yt 140 string \"blue = teammate\" "
				"yt 150 string \"red = bomb target\" ");
			if (ent->client->pers.team == 2)
				strcat(entry, "yt 160 string \"flashing red = bomb\" ");
		}
		else
		{
			strcpy(entry, "xl 8 yt 140 string \"blue = teammate\" "
				"yt 150 string \"red = VIP escape point\" ");
			if (ent->client->pers.team == 1)
				strcat(entry, "yt 160 string \"flashing red = VIP\" ");
		}

		j = strlen(entry);
		if (stringlength + j < 1024)
		{
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}

	ScoreboardFooter(string, ent); // MH: show pre-match notice

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}
*/
/*
void RadarScoreboardMessage (edict_t *ent)
{
	edict_t		*player;
	int         k;
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		j;
	vec3_t	v;
	float	len;
	int		hd;

	string[0] = 0;
	stringlength = 0;

	Com_sprintf (entry, sizeof(entry),
		"xl %i yt %i picn %s ",
		5, 5, PIC_SCANNER_TAG );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	for_each_player (player,k)
	{
		if (!(player->client->pers.team == ent->client->pers.team) || player == ent || player->playing_ingame == FALSE)
			continue;

		VectorSubtract (ent->s.origin, player->s.origin, v);
		hd = v[2] / SCANNER_UNIT;

		v[2] = 0;

		len = VectorLength (v) / SCANNER_UNIT;

		if (len <= SCANNER_RANGE)
		{
			int		sx,
					sy;

			vec3_t	dp;

			vec3_t	normal = {0,0,-1};

			VectorNormalize(v);

			RotatePointAroundVector( dp, normal, v, ent->s.angles[1]);

			VectorScale(dp,len*60/SCANNER_RANGE,dp);


			sx = 68 + dp[1];  
			sy = 68 + dp[0];   

			Com_sprintf (entry, sizeof(entry),
				"xl %i yt %i picn %s ",
				sx, sy, PIC_DOT_TAG );

			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;

			if (hd < 0){
				Com_sprintf (entry, sizeof(entry),
					"yt %i picn %s ",
					sy-5, PIC_UP_TAG );

				j = strlen(entry);
				strcpy (string + stringlength, entry);
				stringlength += j;
			}
			else if (hd > 0){
				Com_sprintf (entry, sizeof(entry),
					"yt %i picn %s ",
					sy+5, PIC_DOWN_TAG );

				j = strlen(entry);
				strcpy (string + stringlength, entry);
				stringlength += j;
			}
		}
	}

	
	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}
*/

// snap, for misc. messages in game
void GameMSGScoreboardMessage  (edict_t *ent)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs=100;
	char	*selectheader[] =
		{
			"The " TEAM_NAME_1 " win this map!",
			"The " TEAM_NAME_2 " win this map!",
			"There is a TIE on this map!",
			"The Round Is Restarting!",
			NULL
		};

	string[0] = 0;
	stringlength = 0;

	switch(ent->client->showscores){
		case SCORE_TEAM1_WIN:
			i = 0;
			break;
		case SCORE_TEAM2_WIN:
			i = 1;
			break;
		case SCORE_TIE_WIN:
			i = 2;
			break;
		case SCORE_R_RESTART:
			i = 3;
			break;
		default:
			return;
	}

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 999 \"%s\" ",
		-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	// MH: display scoreboard notice
	if (i < 3)
	{
		static const char *note = "xm -230 yb -40 dmstr 552 \"hit your scoreboard key (f1) for the scoreboard\" ";
		j = strlen(note);
		if (stringlength + j < 1024)
		{
			strcpy(string + stringlength, note);
			stringlength += j;
		}
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

}

void GameMSGScoreboardMessage2  (edict_t *ent)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs=100;
	char	*selectheader[] =
		{
			"Bomb Defused! " TEAM_NAME_1 " win this round!",
			"VIP Escaped! " TEAM_NAME_1 " win this round!",
			"VIP Left The Game! This round is a tie!",
			"Target Bombed! " TEAM_NAME_2 " win this round!",
			"VIP Was Killed! " TEAM_NAME_2 " win this round!",
			"VIP Did Not Escape! " TEAM_NAME_2 " win this round!",
			"Target Not Bombed! " TEAM_NAME_1 " win this round!",
			TEAM_NAME_1 " Eliminated! " TEAM_NAME_2 " win this round!",
			TEAM_NAME_2 " Eliminated! " TEAM_NAME_1 " win this round!",
			"Both Teams Are Dead! This round is a tie!",
			NULL
		};

	string[0] = 0;
	stringlength = 0;

	switch(level.roundover_type)
	{
		case BOMB_DEFUSED:
			i = 0;
			break;
		case VIP_ESCAPED:
			i = 1;
			break;
		case VIP_LEFT:
			i = 2;
			break;
		case TARGET_BOMBED:
			i = 3;
			break;
		case VIP_KILLED:
			i = 4;
			break;
		case TIMELIMIT_HIT:
//			gi.bprintf (PRINT_HIGH, "Timelimit hit.\n"); // MH: already done in matchend_msg
			if(level.crash_gametype == VIP_MAP)
				i = 5;
			else if(level.crash_gametype == BOMB_MAP)
				i = 6;
			break;
		case TEAM_1_DEAD:
			i = 7;
			break;
		case TEAM_2_DEAD:
			i = 8;
			break;
		case BOTH_TEAMS_DEAD:
			i = 9;
			break;
		default:
			return;
	}

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 999 \"%s\" ",
		-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

	j = strlen(entry);
	strcpy (string + stringlength, entry);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

}

//===================================================================
//===================================================================
//===================================================================
//snap, this is displayed to the bomber when they are activating bomb
//		lets them know how much longer until bomb is armed
void BomberScoreboardMessage (edict_t *ent)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs=0;
	int		time_diff;
	char	*selectheader[] =
		{ // MH: modified for shorter planting/defusing duration
			"Bomb Activation Status",
			"========================",
			"[                     ]",
			"[***                  ]",
			"[******               ]",
			"[*********            ]",
			"[************         ]",
			"[***************      ]",
			"[******************   ]",
			"[*********************]",
			"Bomb Defusing Status",
			NULL
		};

	string[0] = 0;
	stringlength = 0;

	// MH: show planting/defusing progress of chase target
	if (!ent->playing_ingame)
	{
		if (!ent->client->chase_target || ent->client->chase_target->client->showscores != SCORE_BOMB)
		{
			ent->client->showscores = NO_SCOREBOARD;
			NoScoreboardMessage(ent);
			return;
		}
		ScoreboardFooter(string, ent);
		stringlength = strlen(string);
		ent = ent->client->chase_target;
	}

	time_diff = (level.framenum - ent->activate_bomb_frame);

	// print 'bomb defusing / activation' string
	if(ent->client->pers.team == 1)
		i = 10; // MH:
	else if(ent->client->pers.team == 2)
		i = 0;	

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 999 \"%s\" ",
		-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 20;

	// print separator
	i = 1;

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 999 \"%s\" ",
		-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	yofs += 20;

	// MH: tweaked for 4s planting and 7s defusing
	if (ent->client->pers.team == 1)
		i = 2 + (time_diff + 5) / 10;
	else
		i = 2 + time_diff / 5;
	if (i > 9)
		i = 9;

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 944 \"%s\" ",
		-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	gi.WriteByte (svc_layout);
	gi.WriteString (string);

}
//===================================================================
//===================================================================
//===================================================================

//===================================================================
//===================================================================
//===================================================================
//snap, here is the start of papa's scoreboards

// MH: copied from MM2 and modified for Crsah
void SpectatorScoreboardMessage (edict_t *ent)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j, k;
	edict_t	*player;
	char	*tag;

	string[0] = 0;
	stringlength = 0;

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 888 \"Spectators\" ",
		-5*10, -60-49);
	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 663 \"NAME          ping\" ",
		-5*18, -60-21);
	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	for (k=i=0 ; i<maxclients->value ; i++)
	{
		player = g_edicts + 1 + i;
		if (!player->inuse || player->client->pers.team)
			continue;

		if (curtime - player->client->pers.lastpacket >= 5000)
			tag = "666";
		else if (player->client->pers.rconx[0])
			tag = "096";
		else if (player->client->pers.admin > NOT_ADMIN)
			tag = "779";
		else if (player == ent)
			tag = "990";
		else
			tag = "999";	// fullbright

		Com_sprintf (entry, sizeof(entry), "yv %i dmstr %s \"%-13s %4i\" ",
			-60+k*20, tag, player->client->pers.netname, player->client->ping);
		j = strlen(entry);
		if (stringlength + j >= 1024)
			break;
		strcpy (string + stringlength, entry);
		stringlength += j;
		k++;
	}

	if (k)
		k++;

	for (i=0 ; i<maxclients->value ; i++)
	{
		player = g_edicts + 1 + i;
		if (player->inuse || !player->client || !player->client->pers.connected || !(kpded2 || curtime - player->client->pers.lastpacket < 120000))
			continue;

		tag = "666";

		Com_sprintf (entry, sizeof(entry), "yv %i dmstr %s \"%-13s CNCT\" ",
			-60+k*20, tag, player->client->pers.netname);
		j = strlen(entry);
		if (stringlength + j >= 1024)
			break;
		strcpy (string + stringlength, entry);
		stringlength += j;
		k++;
	}

	ScoreboardFooter(string, ent);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}


//===================================================================
//===================================================================
//===================================================================

// snap, here is the old scoreboard
/*
void GrabDaLootScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j, k;
	int		sorted[MAX_CLIENTS];
	int		sortedscores[MAX_CLIENTS];
	int		score, total, real_total;
//	int		picnum;
	int		x, y;
	gclient_t	*cl;
	edict_t		*cl_ent;
	char	*tag;
	int		team;
	char *header;
	char	*headerb = "Thug         ping hits depst";// score";
	char	*headerd = "NAME         ping hits deaths";// score";
	char	nfill[64];
	int		yofs=0;
	int		teamcount[3];

	char	*selectheader[] =
		{
			"You are watching CRASH",
			"Press 1 or 2 to join a team!",
			"The teams are:",
			NULL
		};

	header=teamplay->value==4?headerd:headerb;

//			"%12s - 1 (%i players)"\n%12s - 2\n\n--------------------------------------------------------\n", team_names[1], team_names[2]


	x = (-1*strlen(header) - 2) * 10;	// 10 pixels per char

	string[0] = 0;
	stringlength = 0;

	


	SHOWCHASENAME

	if (!ent->client->showscores)
		goto skipscores;
		
	if (!ent->client->pers.team)
	{
		// count players per team
		memset( teamcount, 0, sizeof(int) * 3 );

		for (team=1; team<=2; team++)
		{
			for (i=0 ; i<game.maxclients ; i++)
			{
				cl_ent = g_edicts + 1 + i;
				if (!cl_ent->inuse)
					continue;

				if (game.clients[i].pers.team != team)
					continue;

				teamcount[team]++;
			}
		}

		// print the team selection header
		for (i=0; selectheader[i]; i++)
		{
			Com_sprintf (entry, sizeof(entry),
				"xm %i yv %i dmstr 677 \"%s\" ",
				-5*strlen(selectheader[i]), yofs + (int)(-60.0+-3.5*14), selectheader[i] );

			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;

			yofs += 30;
		}

		// show team counts
		for (team=1; team<=2; team++)
		{
			strcpy( nfill, team_names[team] );
			if (strlen(nfill) > 14)
				nfill[14] = '\0';

			if (strlen(team_names[team]) < 14)
			{
				for (k=0; k<14-strlen(team_names[team]); k++)
					strcat( nfill, " " );
			}

			Com_sprintf (entry, sizeof(entry),
				"xm %i yv %i dmstr 677 \"%i - %s (%i plyrs)\" ",
				-15*10, yofs + (int)(-60.0+-3.5*14), team, nfill, teamcount[team] );

			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;

			yofs += 20;
		}

		yofs += 15;

		CHASEMESSAGE

	}

	for (team=1; team<=2; team++)
	{

		// Team header, snap changed colors
		if(team == 1)
		{
			Com_sprintf (entry, sizeof(entry),
				"xm %i yv %i tscore %i xm %i dmstr 888 \"%s\" teampic %i ",
				x+14*10, yofs + (int)(-60.0+-3.5*14), team, x, team_names[team], team );
		}
		else
		{
			Com_sprintf (entry, sizeof(entry),
				"xm %i yv %i tscore %i xm %i dmstr 558 \"%s\" teampic %i ",
				x+14*10, yofs + (int)(-60.0+-3.5*14), team, x, team_names[team], team );
		}
		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		// sort the clients by score
		total = 0;
		for (i=0 ; i<game.maxclients ; i++)
		{
			cl_ent = g_edicts + 1 + i;
			if (!cl_ent->inuse)
				continue;

			if (game.clients[i].pers.team != team)
				continue;

//			score = (int)(1.0*game.clients[i].resp.score + (0.3*game.clients[i].resp.deposited));
//			score = game.clients[i].resp.deposited + game.clients[i].resp.score;	// so it works in games without cash
			if (teamplay->value==4) 
				score = (game.clients[i].resp.score<<8)-game.clients[i].resp.deposited;
			else
				score = (game.clients[i].resp.deposited<<4)+game.clients[i].resp.score;

			for (j=0 ; j<total ; j++)
			{
				if (score > sortedscores[j])
					break;
			}
			for (k=total ; k>j ; k--)
			{
				sorted[k] = sorted[k-1];
				sortedscores[k] = sortedscores[k-1];
			}
			sorted[j] = i;
			sortedscores[j] = score;
			total++;
		}

		real_total = total;

		// header
//#if ENABLE_INDEX_NAMES
		if (ent->client->pers.version >= 114)
		{

			// add the clients in sorted order
			if (ent->client->pers.team)
			{
				if (total > 10)
					total = 10;
			}
			else	// don't show as much, less space remaining
			{
				if (total > 7)
					total = 7;
			}

		}
//#else
		else
		{

			if (ent->client->pers.team)
			{
				if (total > 5)
					total = 5;
			}
			else	// don't show as much, less space remaining
			{
				if (total > 3)
					total = 3;
			}

		}
//#endif

		Com_sprintf (entry, sizeof(entry),
			"yv %i dmstr 888 \"%s\" ",
			yofs + (int)(-60.0+-1.5*14), header );

		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;

		for (i=0 ; i<total ; i++)
		{
			cl = &game.clients[sorted[i]];
			cl_ent = g_edicts + 1 + sorted[i];

	//		picnum = gi.imageindex ("i_fixme");
			y = 32 + 32 * i;

			if (i < 2)
				y -= 16;

			if (cl_ent == ent)
				tag = "990";
			else if (cl_ent->client->pers.playing_ingame == FALSE)
				tag = "955";
			else if (cl_ent->crashType == CRASH_VIP)
				tag = "559";
			else
				tag = "999";
//#if ENABLE_INDEX_NAMES
			if (ent->client->pers.version >= 114)
			{
				Com_sprintf (entry, sizeof(entry),
					"yv %i ds %s %i %i %i %i ",// %5i\" ",					// ~28 chars
					yofs + -60+i*16, tag, sorted[i], cl->ping, cl->resp.score, cl->resp.deposited );

			}
//#else
			else
			{

				strcpy( nfill, cl->pers.netname );
				if (strlen(nfill) > 12)
					nfill[12] = '\0';

				if (strlen(cl->pers.netname) < 12)
				{
					for (k=0; k<12-strlen(cl->pers.netname); k++)
						strcat( nfill, " " );
				}

				Com_sprintf (entry, sizeof(entry),
					"yv %i dmstr %s \"%s %4i %4i %5i \" ",// %5i\" ",		// 48 chars
					yofs + -60+i*16, tag, nfill, cl->ping, cl->resp.score, cl->resp.deposited);

			}

//#endif

			j = strlen(entry);
			if (stringlength + j > 1024)
				break;
			strcpy (string + stringlength, entry);
			stringlength += j;
		}

		if (real_total > total)
		{	// show the nuber of undisplayed players

			Com_sprintf (entry, sizeof(entry),
				"yv %i dmstr 777 \"(%i players)\" ",
				yofs + -60+i*16 + 6, real_total );

			j = strlen(entry);
			if (stringlength + j > 1024)
				break;
			strcpy (string + stringlength, entry);
			stringlength += j;
		}

		x = -8;
	}

skipscores:
	
	// TODO: add the spectators at the bottom

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}
*/

// MH: map voting screen
void VoteMapScoreboardMessage(edict_t *ent)
{
	char	entry[1024];
	char	temp[64];
	char	string[1400];
	int		stringlength;
	int		i, j, w;
	int		yofs;
	int		count[9];
	edict_t *player;
	const char	*selectheader[] =
	{
		"Please vote your choice for the next map.",
		"Hit the corresponding number (weapon key)",
		"or use [ and ] to place your vote.",
		NULL
	};
	const char	*basechoice[] =
	{
		"1:  ",
		"2:  ",
		"3:  ",
		"4:  ",
		"5:  ",
		"6:  ",
		"7:  ",
		"8:  ",
		NULL
	};

	string[0] = 0;
	stringlength = 0;
	yofs = -60 - 49;

	Com_sprintf(entry, sizeof(entry), "xm %i ", -5 * 41);
	j = strlen(entry);
	strcpy(string + stringlength, entry);
	stringlength += j;

	for (i = 0; selectheader[i]; i++)
	{
		Com_sprintf(entry, sizeof(entry), "yv %i dmstr 863 \"%s\" ",
			yofs, selectheader[i]);
		j = strlen(entry);
		strcpy(string + stringlength, entry);
		stringlength += j;
		yofs += 20;
	}

	memset(&count, 0, sizeof(count));
	for_each_player(player, i)
	{
		count[player->client->mapvote]++;
	}

	{
		yofs += 10;

		if (count[0])
		{
			if (ent->client->mapvote == 0)
				Com_sprintf(entry, sizeof(entry), "yv %i dmstr %s \"-->      %d players have not voted\" ",
					yofs, vote_winner ? "770" : "990", count[0]);
			else
				Com_sprintf(entry, sizeof(entry), "yv %i dmstr 777 \"         %d players have not voted\" ",
					yofs, count[0]);
			j = strlen(entry);
			strcpy(string + stringlength, entry);
			stringlength += j;
		}

		yofs += 30;

		for (i = 1; i <= num_vote_set; i++)
		{
			strcpy(temp, maplist[vote_set[i]]);
			if (ent->client->mapvote == i)
				Com_sprintf(entry, sizeof(entry), "yv %i dmstr %s \"--> %s %d %s - %s\" ",
					yofs, vote_winner && i != vote_winner ? "770" : "990", basechoice[i - 1], count[i], count[i] == 1 ? "vote " : "votes", temp);
			else
				Com_sprintf(entry, sizeof(entry), "yv %i dmstr %s \"    %s %d %s - %s\" ",
					yofs, vote_winner && i != vote_winner ? "777" : "999", basechoice[i - 1], count[i], count[i] == 1 ? "vote " : "votes", temp);
			j = strlen(entry);
			strcpy(string + stringlength, entry);
			stringlength += j;
			yofs += 20;
		}

		if (ent->client->mapvote > 0 && !vote_nopic[ent->client->mapvote])
		{
			yofs += 15;
			Com_sprintf(entry, sizeof(entry),
				"xm %i yv %i picn %s ",
				-5 * 20, yofs, maplist[vote_set[ent->client->mapvote]]);
			j = strlen(entry);
			strcpy(string + stringlength, entry);
			stringlength += j;
		}
	}

	ScoreboardFooter(string, ent);

	gi.WriteByte(svc_layout);
	gi.WriteString(string);
}

// MH: MOTD/intro screen
void MOTDScoreboardMessage (edict_t *ent)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j;
	int		yofs;
	const char	*seperator = "==================================";

	static const char *gameheader[] =
	{
		"This server is running " GAMEVERSION " ",
		NULL
	};

	string[0] = 0;
	stringlength = 0;

	yofs = 130 - num_MOTD_lines * 10;
	if (yofs < 0 )
		yofs = 0;

	for (i=0; gameheader[i]; i++)
	{
		Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 863 \"%s\" ",
			-5*strlen(gameheader[i]), yofs + -60-49, gameheader[i] );
		j = strlen(entry);
		strcpy (string + stringlength, entry);
		stringlength += j;
		yofs += 20;
	}
	yofs += 10;

	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 772 \"%s\" ",
		-5*strlen(seperator), yofs + -60-49, seperator );
	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;
	yofs += 30;

	if (num_MOTD_lines)
	{
		for (i=0; i<num_MOTD_lines; i++)
		{
			Com_sprintf (entry, sizeof(entry),
				"xm %i yv %i dmstr 953 \"%s\" ",
				-5*strlen(MOTD[i]), yofs + -60-49, MOTD[i] );
			j = strlen(entry);
			if (stringlength + j < 1024)
			{
				strcpy (string + stringlength, entry);
				stringlength += j;
			}
			yofs += 20;
		}
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

//===================================================================
//===================================================================
//===================================================================

/*
==================
DeathmatchScoreboard

Draw instead of help message.
Note that it isn't that hard to overflow the 1400 byte message limit!
==================
*/

// Papa - Here is where i determine what scoreboard to display
// snap - changed/added to this
void DeathmatchScoreboard (edict_t *ent)
{
	if(ent->client->showscores == SCORE_SCOPE)
		ScopeScore(ent);
	else{
//		killscope(ent); // MH: not needed with disabled scope

		switch(ent->client->showscores){
			// MH: new MOTD/intro screen
			case SCORE_MOTD:
				MOTDScoreboardMessage (ent);
				break;
			// MH: map voting
			case SCORE_MAP_VOTE:
				VoteMapScoreboardMessage(ent);
				break;
			case SPECTATORS:
				SpectatorScoreboardMessage (ent);
				break;
			case SCORE_TEAM1_WIN:
			case SCORE_TEAM2_WIN:
			case SCORE_TIE_WIN:
			case SCORE_R_RESTART:
				GameMSGScoreboardMessage(ent);
				break;
			case SCORE_ROUNDEND:
				GameMSGScoreboardMessage2(ent);
				break;
			case SCORE_RADIO:
				RadioMessage(ent);
				break;
			case SCORE_BOMB:
				BomberScoreboardMessage(ent);
				break;
			// MH: radar is in HUD now (see UpdateRadarHUD)
/*			case SCORE_RADAR:
				RadarScoreboardMessage(ent);
				break;*/
			case SCOREBOARD_1:
				CrashScoreboardMessage (ent, ent->enemy);
				break;
			case SCOREBOARD_2:
				GangScoreboardMessage (ent, ent->enemy);
				break;
			case NO_SCOREBOARD:
/*				if(ent->playing_ingame == TRUE){
					ent->client->showscores = SCORE_RADAR;
					RadarScoreboardMessage(ent);
				}
				else*/
					NoScoreboardMessage(ent);
				break;
			default:
				break;
		}
	}

	gi.unicast (ent, !ent->client->resp.scoreboard_frame); // MH: make reliable if it's a requested (not periodic) update

	// MH: set next refresh
	if (ent->client->showscores == NO_SCOREBOARD && ent->crashType && level.framenum < ent->client->resp.enterframe + 30)
		ent->client->resp.scoreboard_frame = ent->client->resp.enterframe + 30; // remove bomb/vip message after 3s
	else if (ent->client->showscores == NO_SCOREBOARD || ent->client->showscores == SCORE_MOTD)
		ent->client->resp.scoreboard_frame = 0x7fffffff; // don't refresh MOTD
/*	else if (ent->client->showscores == SCORE_RADAR)
		ent->client->resp.scoreboard_frame = level.framenum + 5; // 0.5s for radar*/
	else if (ent->client->showscores == SCORE_BOMB)
		ent->client->resp.scoreboard_frame = level.framenum + 5; // 0.5s for bomb planting/defusing
	else if (ent->client->showscores == SCORE_MAP_VOTE && level.framenum < level.startframe + 300)
		ent->client->resp.scoreboard_frame = (level.framenum + 10 < level.startframe + 300 ? level.framenum + 10 : level.startframe + 300);
	else
		ent->client->resp.scoreboard_frame = level.framenum + 30; // 3s default
}


/*
==================
Cmd_Score_f

Display the scoreboard
==================
*/

// Papa - This is the start of the scoreboard command, this sets the showscores value
  
void Cmd_Score_f (edict_t *ent)
{
	int		i,found;
	edict_t	*dood;

	ent->client->showinventory = false;
	ent->client->showhelp = false;

	if (!deathmatch->value && !coop->value)
		return;

	// dont fook the scope up
	if(ent->client->showscores == SCORE_SCOPE)
		return;

	// snap, for radio hud
	else if (ent->client->showscores == SCORE_RADIO)
		ent->client->showscores = NO_SCOREBOARD;

	else if (ent->client->showscores == SCOREBOARD_1)
		ent->client->showscores = SCOREBOARD_2;

	else if (ent->client->showscores == SCOREBOARD_2)
	{
		found = false;
		// MH: also check for connecting players, which are included in spectators list
		for (i=0 ; i<maxclients->value ; i++)
		{
			dood = g_edicts + 1 + i;
			if (dood->client && ((dood->inuse && dood->client->pers.team == 0) || (!dood->inuse && dood->client->pers.connected && (kpded2 || curtime - dood->client->pers.lastpacket < 120000))))
				found = true;
		}
		if (found)
			ent->client->showscores = SPECTATORS;
		else
		{
			// MH: always show a scoreboard during intermission
			if (level.intermissiontime)
			{
				if (level.modeset == ENDGAMEVOTE)
					ent->client->showscores = SCORE_MAP_VOTE;
				else
					ent->client->showscores = SCOREBOARD_1;
			}
			else
				ent->client->showscores = NO_SCOREBOARD;
		}
	}		
	else if (ent->client->showscores == SPECTATORS)
	{
		// MH: always show a scoreboard during intermission
		if (level.intermissiontime)
		{
			if (level.modeset == ENDGAMEVOTE)
				ent->client->showscores = SCORE_MAP_VOTE;
			else
				ent->client->showscores = SCOREBOARD_1;
		}
		else
			ent->client->showscores = NO_SCOREBOARD;
	}
	else
		ent->client->showscores = SCOREBOARD_1;

	// MH: skip 2nd scoreboard if it isn't needed (no more than 10 players)
	if (ent->client->showscores == SCOREBOARD_2)
	{
		int count = 0;
		for_each_player(dood,i)
		{
			if (dood->client->pers.team)
				count++;
		}
		if (count <= 10)
		{
			Cmd_Score_f(ent);
			return;
		}
	}
		
	ent->client->resp.scoreboard_frame = 0; // MH: trigger scoreboard update instead of calling DeathmatchScoreboard
}


/*
==================
HelpComputer

Draw help computer.
==================
*/
void HelpComputer (edict_t *ent, int page)
{
	char	string[1024];
/*	char	*sk;

	if (skill->value == 0)
		sk = "easy";
	else if (skill->value == 1)
		sk = "medium";
	else if (skill->value == 2)
		sk = "hard";
	else
		sk = "hard+";

	// send the layout
	Com_sprintf (string, sizeof(string),
		"xv 33 yv 7 picnote " // background		
		"xv 202 yv 12 string2 \"%s\" "		// skill
		"xv 0 yv 24 cstring2 \"%s\" "		// level name
		"xv 0 yv 54 cstring2 \"%s\" "		// help 1
		"xv 0 yv 110 cstring2 \"%s\" "		// help 2
		"xv 50 yv 164 string2 \" kills     goals    secrets\" "
		"xv 50 yv 172 string2 \"%3i/%3i     %i/%i       %i/%i\" ", 
		sk,
		level.level_name,
		game.helpmessage1,
		game.helpmessage2,
		level.killed_monsters, level.total_monsters, 
		level.found_goals, level.total_goals,
		level.found_secrets, level.total_secrets);*/

	EP_PlayerLog (ent, page);

	level.helpchange = 0;
	
	Com_sprintf (string, sizeof(string),
		"picnote \"%s\" "
		" \"%s\" ",		
		game.helpmessage1,
		game.helpmessage2);

//	Com_sprintf (string, sizeof(string),
//		"xv 32 yv 8 string2 \"Help screen not yet implemented\" "	);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
	gi.unicast (ent, true);
}

#if 0
/*
==================
HelpComputer

Draw help computer.
==================
*/
void HelpComputer (edict_t *ent)
{
	char	string[1024];
	char	*sk;

	if (skill->value == 0)
		sk = "easy";
	else if (skill->value == 1)
		sk = "medium";
	else if (skill->value == 2)
		sk = "hard";
	else
		sk = "hard+";
/*
	// send the layout
	Com_sprintf (string, sizeof(string),
		"xv 32 yv 8 picn help "			// background
		"xv 202 yv 12 string2 \"%s\" "		// skill
		"xv 0 yv 24 cstring2 \"%s\" "		// level name
		"xv 0 yv 54 cstring2 \"%s\" "		// help 1
		"xv 0 yv 110 cstring2 \"%s\" "		// help 2
		"xv 50 yv 164 string2 \" kills     goals    secrets\" "
		"xv 50 yv 172 string2 \"%3i/%3i     %i/%i       %i/%i\" ", 
		sk,
		level.level_name,
		game.helpmessage1,
		game.helpmessage2,
		level.killed_monsters, level.total_monsters, 
		level.found_goals, level.total_goals,
		level.found_secrets, level.total_secrets);
*/
	Com_sprintf (string, sizeof(string),
		"xv 32 yv 8 string2 \"Help screen not yet implemented\" "	);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
	gi.unicast (ent, true);
}
#endif

/*
==================
Cmd_Help_f

Display the current help message
==================
*/
void Cmd_Help_f (edict_t *ent, int page)
{
	// this is for backwards compatability
	if (deathmatch->value)
	{
		Cmd_Score_f (ent);
		return;
	}

	ent->client->showinventory = false;
	ent->client->showscores = NO_SCOREBOARD;

	if (ent->client->showhelp && (ent->client->pers.game_helpchanged == game.helpchanged) && !(page))
	{
		ent->client->showhelp = false;
		return;
	}

	ent->client->showhelp = true;
	ent->client->pers.helpchanged = 0;

	HelpComputer (ent, page);
}


//=======================================================================

/*
===============
G_SetStats
===============
*/
void G_SetStats (edict_t *ent)
{
	gitem_t		*item;
	int			index, cells;
	int			power_armor_type;


	// if chasecam, show stats of player we are following
	if (ent->client->chase_target && ent->client->chase_target->client)
	{
		memcpy( ent->client->ps.stats, ent->client->chase_target->client->ps.stats, sizeof( ent->client->ps.stats ) );
		ent->client->ps.stats[STAT_LAYOUTS] = 1; // MH: always showing a scoreboard (should already be set)
		
		// MH: keep own score
		ent->client->ps.stats[STAT_FRAGS] = ent->client->resp.score;
		ent->client->ps.stats[STAT_DEPOSITED] = ent->client->resp.deposited;

		// MH: if the target is planting/defusing, see their progress bar
		if (ent->client->showscores == NO_SCOREBOARD && ent->client->chase_target->client->showscores == SCORE_BOMB)
		{
			ent->client->showscores = SCORE_BOMB;
			ent->client->resp.scoreboard_frame = 0;
		}
		else if (ent->client->showscores == SCORE_BOMB && ent->client->chase_target->client->showscores != SCORE_BOMB)
		{
			ent->client->showscores = NO_SCOREBOARD;
			ent->client->resp.scoreboard_frame = 0;
		}

		return;
	}


	//
	// health
	//
	// JOSEPH 23-MAR-99
	//ent->client->ps.stats[STAT_HEALTH_ICON] = level.pic_health;
	{	
		int     index1, index2, index3;
		
		item = FindItem ("Cash");
		index1 = ITEM_INDEX (item);
		item = FindItem ("Large Cash Bag");
		index2 = ITEM_INDEX (item);
		item = FindItem ("Small Cash Bag");
		index3 = ITEM_INDEX (item);
		
		if (!((ent->client->ps.stats[STAT_PICKUP_STRING] == CS_ITEMS+index1) ||
			  (ent->client->ps.stats[STAT_PICKUP_STRING] == CS_ITEMS+index2) ||
			  (ent->client->ps.stats[STAT_PICKUP_STRING] == CS_ITEMS+index3)))
			ent->client->ps.stats[STAT_CASH_PICKUP] = 0;

		// JOSEPH 1-APR-99-B
		item = FindItem ("Helmet Armor");
		ent->client->ps.stats[STAT_ARMOR1] = ent->client->pers.inventory[ITEM_INDEX(item)];
		item = FindItem ("Jacket Armor");
		ent->client->ps.stats[STAT_ARMOR2] = ent->client->pers.inventory[ITEM_INDEX(item)];
		item = FindItem ("Legs Armor");
		ent->client->ps.stats[STAT_ARMOR3] = ent->client->pers.inventory[ITEM_INDEX(item)];
		item = FindItem ("Helmet Armor Heavy");
		if (ent->client->pers.inventory[ITEM_INDEX(item)])
			ent->client->ps.stats[STAT_ARMOR1] = ent->client->pers.inventory[ITEM_INDEX(item)] + 1024;
		item = FindItem ("Jacket Armor heavy");
		if (ent->client->pers.inventory[ITEM_INDEX(item)])
			ent->client->ps.stats[STAT_ARMOR2] = ent->client->pers.inventory[ITEM_INDEX(item)] + 1024;
		item = FindItem ("Legs Armor Heavy");
		if (ent->client->pers.inventory[ITEM_INDEX(item)])
			ent->client->ps.stats[STAT_ARMOR3] = ent->client->pers.inventory[ITEM_INDEX(item)] + 1024;
		// END JOSEPH		
	}
	// END JOSEPH

	ent->client->ps.stats[STAT_HEALTH] = ent->health;

	//
	// ammo
	//
	
	// JOSEPH 28-APR-99
	if (!level.bar_lvl)
	{
		if (!ent->client->ammo_index /* || !ent->client->pers.inventory[ent->client->ammo_index] */)
		{
			ent->client->ps.stats[STAT_AMMO_ICON] = 0;
			ent->client->ps.stats[STAT_AMMO] = 0;
		}
		else
		{
			item = &itemlist[ent->client->ammo_index];
			ent->client->ps.stats[STAT_AMMO_ICON] = gi.imageindex (item->icon);
			ent->client->ps.stats[STAT_AMMO] = ent->client->pers.inventory[ent->client->ammo_index];
		}

		// RAFAEL 01-11-99
		// JOSEPH 9-MAR-99
		if (ent->client->ammo_index)
		{
			item = &itemlist[ent->client->ammo_index];
		}
		else
		{
			item = NULL;
		}

		if ((item) && (item->pickup_name) && (/*(!strcmp(item->pickup_name, "Rockets")) ||*/ ((!strcmp(item->pickup_name, "Gas")))))
		{
			ent->client->ps.stats[STAT_CLIP] = -1;
		}
		else
		{
			// ent->client->ps.stats[STAT_CLIP_ICON] = gi.imageindex (clipname);//FREDZ was this mod type?
			ent->client->ps.stats[STAT_CLIP] = ent->client->pers.weapon_clip[ent->client->clip_index];
		}
	}
	else
	{
		ent->client->ps.stats[STAT_AMMO_ICON] = 0;
		ent->client->ps.stats[STAT_AMMO] = 0;
		ent->client->ps.stats[STAT_CLIP] = -1;
	}
	// END JOSEPH
	
	//
	// money
	//

	// Ridah, 26-may-99, show frag count
	if (deathmatch->value && teamplay->value!=1)
		ent->client->ps.stats[STAT_CASH] = ent->client->resp.score;
	else	// show cash
		ent->client->ps.stats[STAT_CASH] = ent->client->pers.currentcash;

	if (level.pawn_time)
		ent->client->ps.stats[STAT_FORCE_HUD] = 1;
	else
		ent->client->ps.stats[STAT_FORCE_HUD] = 0;
	// END JOSEPH

	// JOSEPH 4-MAR-99
	if ((level.cut_scene_time) || (level.fadeendtime > level.time))
		ent->client->ps.stats[STAT_HIDE_HUD] = 1;
	else
		ent->client->ps.stats[STAT_HIDE_HUD] = 0;
	// END JOSEPH    

	if ((level.cut_scene_time || level.cut_scene_end_count) && level.cut_scene_camera_switch)
		ent->client->ps.stats[STAT_SWITCH_CAMERA] = 1;
	else
		ent->client->ps.stats[STAT_SWITCH_CAMERA] = 0;
	// END JOSEPH    
	
	// JOSEPH 2-FEB-99
	if (level.time > ent->client->hud_enemy_talk_time)
	{
		ent->client->ps.stats[STAT_HUD_ENEMY_TALK] = 0;
	}
	else if ((ent->client->hud_enemy_talk_time - level.time) > 1.0)
	{
		ent->client->ps.stats[STAT_HUD_ENEMY_TALK_TIME] = 255;		
	}
	else
	{
		ent->client->ps.stats[STAT_HUD_ENEMY_TALK_TIME] =
			(short)((255.0/1.0)*(ent->client->hud_enemy_talk_time - level.time));
		if (ent->client->ps.stats[STAT_HUD_ENEMY_TALK_TIME] < 0)
			ent->client->ps.stats[STAT_HUD_ENEMY_TALK_TIME] = 0;
	}
	
	if (level.time > ent->client->hud_self_talk_time)
	{
		ent->client->ps.stats[STAT_HUD_SELF_TALK] = 0;
	}
	else if ((ent->client->hud_self_talk_time - level.time) > 1.0)
	{
		ent->client->ps.stats[STAT_HUD_SELF_TALK_TIME] = 255;		
	}
	else
	{
		ent->client->ps.stats[STAT_HUD_SELF_TALK_TIME] =
			(short)((255.0/1.0)*(ent->client->hud_self_talk_time - level.time));
		if (ent->client->ps.stats[STAT_HUD_SELF_TALK_TIME] < 0)
			ent->client->ps.stats[STAT_HUD_SELF_TALK_TIME] = 0;
	}
	// END JOSEPH	

	// JOSEPH 16-FEB-99
	{
		cast_memory_t *mem;
		int firsthire = 0;
		int i;
		edict_t *theent;

		ent->client->ps.stats[STAT_HUD_HIRE1] = 0;
		ent->client->ps.stats[STAT_HUD_HIRE2] = 0;

		theent = &g_edicts[0];
		for (i=0 ; i<globals.num_edicts ; i++, theent++)
		{
			if (!theent->inuse)
				continue;

			if ((theent->leader) && (theent->leader == ent))
			{
				mem = level.global_cast_memory[theent->character_index][ent->character_index];

				if (!mem)
					continue;

				if (mem->flags & MEMORY_HIRED)
				{   
					if (!firsthire)
					{
						if (theent->health > 0)
						{
							// JOSEPH 28-APR-99
							ent->client->ps.stats[STAT_HUD_HIRE1] = (int)((100.0/(float)theent->max_health)*((float)theent->health));
							// END JOSEPH
							
							if ((theent->enemy) && (theent->enemy->health > 0))
							{
								ent->client->ps.stats[STAT_HUD_HIRE1_CMD] = 3;
							}
							else if (theent->cast_info.aiflags & AI_MOVEOUT || theent->cast_info.aiflags & AI_DOKEY)
							{
								ent->client->ps.stats[STAT_HUD_HIRE1_CMD] = 1;
							}
							else if (theent->cast_info.aiflags & AI_HOLD_POSITION)
							{
								ent->client->ps.stats[STAT_HUD_HIRE1_CMD] = 2;
							}
							else
							{
								ent->client->ps.stats[STAT_HUD_HIRE1_CMD] = 0;
							}
								
							firsthire = 1;
						}
					}
					else
					{
						if (theent->health > 0)
						{
							// JOSEPH 28-APR-99
							ent->client->ps.stats[STAT_HUD_HIRE2] = (int)((100.0/(float)theent->max_health)*((float)theent->health));
							// END JOSEPH
						
							if ((theent->enemy) && (theent->enemy->health > 0))
							{
								ent->client->ps.stats[STAT_HUD_HIRE1_CMD] = 3;
							}
							else if (theent->cast_info.aiflags & AI_MOVEOUT || theent->cast_info.aiflags & AI_DOKEY)
							{
								ent->client->ps.stats[STAT_HUD_HIRE2_CMD] = 1;
							}
							else if (theent->cast_info.aiflags & AI_HOLD_POSITION)
							{
								ent->client->ps.stats[STAT_HUD_HIRE2_CMD] = 2;
							}
							else
							{
								ent->client->ps.stats[STAT_HUD_HIRE2_CMD] = 0;
							}						
						}
						break;
					}
				}
			}
		}
	}
	// END JOSEPH

	// JOSEPH 4-FEB-99-C
	ent->client->ps.stats[STAT_HUD_INV] = 0;

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Battery"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 1;

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Coil"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 2;

	// JOSEPH 17-MAR-99
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Watch"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 4;
	// END JOSEPH

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Safe docs"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 8;

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Fuse"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 16;
	
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Valve"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 32;
	// END JOSEPH

	// JOSEPH 10-JUN-99
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Lizzy Head"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 64;
	
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Whiskey"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 128;

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Oil Can"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 256;	

	if (ent->client->pers.inventory[ITEM_INDEX(FindItem ("Ticket"))])
		ent->client->ps.stats[STAT_HUD_INV] |= 512;		
	// END JOSEPH

	//
	// armor
	//
/*	power_armor_type = PowerArmorType (ent);//Q2
	if (power_armor_type)
	{
		cells = ent->client->pers.inventory[ITEM_INDEX(FindItem ("Gas"))];
		if (cells == 0)
		{	// ran out of cells for power armor
			ent->flags &= ~FL_POWER_ARMOR;
			gi.sound(ent, CHAN_ITEM, gi.soundindex("misc/power2.wav"), 1, ATTN_NORM, 0);
			power_armor_type = 0;;
		}
	}*/

//	index = ArmorIndex (ent);

	// JOSEPH 1-APR-99
	/*if (power_armor_type && (!index || (level.framenum & 8) ) )
	{	// flash between power armor and other armor icon
		ent->client->ps.stats[STAT_ARMOR_ICON] = gi.imageindex ("i_powershield");
		ent->client->ps.stats[STAT_ARMOR] = cells;
	}
	else if (index)
	{
		item = GetItemByIndex (index);
		ent->client->ps.stats[STAT_ARMOR_ICON] = gi.imageindex (item->icon);
		ent->client->ps.stats[STAT_ARMOR] = ent->client->pers.inventory[index];
	}
	else
	{
		// ent->client->ps.stats[STAT_ARMOR_ICON] = 0;
		ent->client->ps.stats[STAT_ARMOR] = 0;
	}*/
	// END JOSEPH

	//
	// pickup message
	//
	// JOSEPH 25-JAN-99
	if (level.time > ent->client->pickup_msg_time)
	{
		ent->client->ps.stats[STAT_PICKUP_ICON] = 0;
		ent->client->ps.stats[STAT_PICKUP_STRING] = 0;
		ent->client->ps.stats[STAT_PICKUP_COUNT] = 0;	
	}
	else if ((ent->client->pickup_msg_time - level.time) > 1.5)
	{
		ent->client->ps.stats[STAT_PICKUP_COUNT] = 255;		
	}
	else
	{
		ent->client->ps.stats[STAT_PICKUP_COUNT] =
			(short)((255.0/1.5)*(ent->client->pickup_msg_time - level.time));
		if (ent->client->ps.stats[STAT_PICKUP_COUNT] < 0)
			ent->client->ps.stats[STAT_PICKUP_COUNT] = 0;
	}
	// END JOSEPH

	//
	// timers
	//
	// JOSEPH 12-MAY-99-B
	/*
	if (ent->client->quad_framenum > level.framenum)//Q2
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_quad");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->quad_framenum - level.framenum)/10;
	}
	// RAFAEL
	else if (ent->client->quadfire_framenum > level.framenum)//Q2 Xatrix MOD
	{
		// note to self
		// need to change imageindex
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_quadfire");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->quadfire_framenum - level.framenum)/10;
	}
	else if (ent->client->invincible_framenum > level.framenum)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_invulnerability");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->invincible_framenum - level.framenum)/10;
	}
	else if (ent->client->enviro_framenum > level.framenum)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_envirosuit");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->enviro_framenum - level.framenum)/10;
	}
	else if (ent->client->breather_framenum > level.framenum)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_rebreather");
		ent->client->ps.stats[STAT_TIMER] = (ent->client->breather_framenum - level.framenum)/10;
	}
	else
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = 0;
		ent->client->ps.stats[STAT_TIMER] = 0;
	}	
	*/

// Papa - Here is the Timer for the hud
// snap, changed this alot
// using stat_bagcash for time display now.

/*	if (level.modeset == PUBLICROUNDSETUP && level.roundnum == 1)
		ent->client->ps.stats[STAT_BAGCASH] =	((300 - (level.framenum - level.startframe)) / 10);
*/
	if ((int)timelimit->value)
	{
/*		if (level.modeset == FREEFORALL)
			ent->client->ps.stats[STAT_TIMER] = ((350 -  level.framenum ) / 10);

		else if (level.modeset == FINALCOUNT)
			ent->client->ps.stats[STAT_TIMER] =	((200 - (level.framenum - level.startframe)) / 10);

*/
		if (/*(level.modeset == PRE_MATCH) ||*/ (level.modeset == MATCH)) // MH: removed from pre-match mode
			if (level.framenum > (level.startframe + (((int)timelimit->value  * 600) - 605)))  
				ent->client->ps.stats[STAT_BAGCASH] = ((((int)timelimit->value * 600) + level.startframe - level.framenum ) / 10);
			else
				ent->client->ps.stats[STAT_BAGCASH] = ((((int)timelimit->value * 600) + level.startframe - level.framenum ) / 600);
		else 
			ent->client->ps.stats[STAT_BAGCASH] = 0;

	}
	else
		ent->client->ps.stats[STAT_BAGCASH] = 0; // MH: corrected STAT_TIMER to STAT_BAGCASH

	if (ent->client->ps.stats[STAT_BAGCASH] < 0 )
		ent->client->ps.stats[STAT_BAGCASH] = 0;

	// SnaP, here is the HUD display for the round info
/*	if(roundlimit)
	{
	   ent->client->ps.stats[STAT_ROUNDLIM] = roundlimit;
	   ent->client->ps.stats[STAT_ROUND] = level.roundnum;

	   if(ent->client->ps.stats[STAT_ROUND] > roundlimit)
		   ent->client->ps.stats[STAT_ROUND] = roundlimit;
	}
	else
	{*/
/*	   ent->client->ps.stats[STAT_ROUNDLIM] = 0;
	   ent->client->ps.stats[STAT_ROUND] = 0;*/
//	}

	// MH: show map timer in HUD
	if (level.map_startframe)
	{
		if (level.framenum > (level.map_startframe + (((int)map_timelimit->value  * 600) - 605)))  
			ent->client->ps.stats[STAT_TIMER] = ((((int)map_timelimit->value * 600) + level.map_startframe - level.framenum ) / 10);
		else
			ent->client->ps.stats[STAT_TIMER] = ((((int)map_timelimit->value * 600) + level.map_startframe - level.framenum ) / 600);
	}
	else 
		ent->client->ps.stats[STAT_TIMER] = (int)map_timelimit->value;

	if (ent->client->ps.stats[STAT_TIMER] < 0)
		ent->client->ps.stats[STAT_TIMER] = 0;

	// END JOSEPH

	//
	// selected item
	//
	// JOSEPH 1-APR-99
	/*if (ent->client->pers.selected_item == -1)
		ent->client->ps.stats[STAT_SELECTED_ICON] = 0;
	else
		ent->client->ps.stats[STAT_SELECTED_ICON] = gi.imageindex (itemlist[ent->client->pers.selected_item].icon);
	*/
	// END JOSEPH
	ent->client->ps.stats[STAT_SELECTED_ITEM] = ent->client->pers.selected_item;

	//
	// layouts
	//
	ent->client->ps.stats[STAT_LAYOUTS] = 0;

	// changed this for radar, snap
	if (deathmatch->value)
	{
		ent->client->ps.stats[STAT_LAYOUTS] = 1; // MH: always showing a scoreboard
		if (ent->client->showinventory && ent->client->pers.health > 0)
			ent->client->ps.stats[STAT_LAYOUTS] |= 2;
	}
	else
	{
		if (ent->client->showscores || ent->client->showhelp)
			ent->client->ps.stats[STAT_LAYOUTS] |= 1;
		if (ent->client->showinventory && ent->client->pers.health > 0)
			ent->client->ps.stats[STAT_LAYOUTS] |= 2;
	}

	//
	// frags
	//
	ent->client->ps.stats[STAT_FRAGS] = ent->client->resp.score;
	ent->client->ps.stats[STAT_DEPOSITED] = ent->client->resp.deposited;

	//
	// help icon / current weapon if not shown
	//
	if (ent->client->resp.helpchanged && (level.framenum&8) )
		ent->client->ps.stats[STAT_HELPICON] = gi.imageindex ("i_help");
	else if ( (ent->client->pers.hand == CENTER_HANDED || ent->client->ps.fov > 91)
		&& ent->client->pers.weapon)
		ent->client->ps.stats[STAT_HELPICON] = gi.imageindex (ent->client->pers.weapon->icon);
	else
		ent->client->ps.stats[STAT_HELPICON] = 0;

	// JOSEPH 14-JUN-99
	ent->client->ps.stats[STAT_HELPICON] = level.helpchange;
	// END JOSEPH

	// Teamplay
	if (deathmatch->value && teamplay->value)
	{
		int i;

		// show team scores
		for (i=0; i<2; i++)
		{
			ent->client->ps.stats[STAT_TEAM1_SCORE + i] = team_cash[1+i];	// set score

			ent->client->ps.stats[STAT_TEAM1_FLASH + i] = 0;	// set normal

			if (last_safe_withdrawal[i+1] > last_safe_deposit[i+1])
			{
				if (last_safe_withdrawal[i+1] > (level.time - 3.0))
					ent->client->ps.stats[STAT_TEAM1_FLASH + i] = 2;	// flash red
			}
			else
			{
				if (last_safe_deposit[i+1] > (level.time - 3.0))
					ent->client->ps.stats[STAT_TEAM1_FLASH + i] = 1;	// flash green
			}
		}

		// show bagged cash
		// snap, show round time left instead of the bagcash
//		ent->client->ps.stats[STAT_BAGCASH] = ent->client->pers.bagcash;


	}
}

// JOSEPH 16-DEC-98

// RAFAEL
/*void BeginCutScene (edict_t *ent)
{
	edict_t *player;

	player = g_edicts + 1;

	level.cut_scene_time = level.time + 0.1;
	
	VectorCopy (ent->s.angles, level.cut_scene_angle);
	VectorCopy (ent->s.origin, level.cut_scene_origin);
	
	VectorCopy (player->s.origin, level.player_oldpos);
	VectorCopy (player->s.angles, level.player_oldang);

	MoveClientToCutScene (player);

}*/

void FollowEnt (edict_t *ent)
{
    /*if (ent->target2_ent)
	{
    	vec3_t	forward, right, up, forward2, right2, up2, avect, avect2;

		AngleVectors (ent->s.origin, forward, right, up);
	    AngleVectors (ent->target2_ent->s.origin, forward2, right2, up2);
		avect[0] = ((forward[0] + right[0] + up[0]))/3;
		avect[1] = ((forward[1] + right[1] + up[1]))/3;
		avect[2] = ((forward[2] + right[2] + up[2]))/3;
		avect2[0] = ((forward2[0] + right2[0] + up2[0]))/3;
		avect2[1] = ((forward2[1] + right2[1] + up2[1]))/3;
		avect2[2] = ((forward2[2] + right2[2] + up2[2]))/3;
		VectorSubtract(avect, avect2, avect);
		VectorNormalize(avect);
		vectoangles(avect, ent->s.angles);	
	}*/

    if (ent->target2_ent)
	{
//    	vec3_t	forward, forward2;
		vec3_t	avect;

// Ridah, not sure how this is supposed to work, doesn't make sense to do an AngleVectors() call on an origin
//		AngleVectors (ent->s.origin, forward, NULL, NULL);
//	    AngleVectors (ent->target2_ent->s.origin, forward2, NULL, NULL);
//		VectorSubtract(forward, forward2, avect);

		VectorSubtract(ent->target2_ent->s.origin, ent->s.origin, avect);

		VectorNormalize(avect);
		vectoangles(avect, ent->s.angles);	
	}
}

// JOSEPH 23-FEB-99
void BeginCutScene (edict_t *ent)
{
	edict_t *player;

	player = g_edicts + 1;

    level.cut_scene_camera_switch = 1;

	level.cut_scene_time = level.time + 0.1;
	
	VectorCopy(ent->s.angles, ent->save_avel);
	VectorCopy(ent->s.origin, ent->savecameraorigin);
	
	if (ent->cameraangle[0])
	{
		ent->s.angles[0] += ent->cameraangle[0];
	}

	if (ent->cameraangle[1])
	{
		ent->s.angles[1] += ent->cameraangle[1];
	}

	if (ent->cameraangle[2])
	{
		ent->s.angles[2] += ent->cameraangle[2];
	}

    FollowEnt (ent);

	VectorCopy (ent->s.angles, level.cut_scene_angle);
	VectorCopy (ent->s.origin, level.cut_scene_origin);
	
	VectorCopy (player->s.origin, level.player_oldpos);
	VectorCopy (player->s.angles, level.player_oldang);
	
	MoveClientToCutSceneCamera (player, ent->deadticks);
}

void NewCutSceneCamera (edict_t *ent)
{
	edict_t *player;

	player = g_edicts + 1;

	level.cut_scene_camera_switch = 1;

	VectorCopy(ent->s.angles, ent->save_avel);
	VectorCopy(ent->s.origin, ent->savecameraorigin);
	
	level.cut_scene_time = level.time + 0.1;

	// JOSEPH 19-MAR-99-B
	ent->alphalevel = level.time + ent->reactdelay;	
	// END JOSEPH

	if (ent->cameraangle[0])
	{
		ent->s.angles[0] += ent->cameraangle[0];
	}

	if (ent->cameraangle[1])
	{
		ent->s.angles[1] += ent->cameraangle[1];
	}

	if (ent->cameraangle[2])
	{
		ent->s.angles[2] += ent->cameraangle[2];
	}

    FollowEnt (ent);
	
	VectorCopy (ent->s.angles, level.cut_scene_angle);
	VectorCopy (ent->s.origin, level.cut_scene_origin);
	
	MoveClientToCutSceneCamera (player, ent->deadticks);
}

void AdjustCutSceneCamera(edict_t *ent)
{
	edict_t *player;

	player = g_edicts + 1;

	if (ent->accel)
	{
		if (ent->delay < (level.time - ent->timestamp))
		{
			if ((ent->delay + ent->reactdelay) < (level.time - ent->timestamp))
			{
				if (ent->speed > 0)
				{
					ent->speed -= ent->decel * FRAMETIME;

					if (ent->speed < 0)
						ent->speed = 0;
				}
			}
			else if (ent->speed < 1)
			{
				ent->speed += ent->accel * FRAMETIME;
				if (ent->speed > 1)
					ent->speed = 1;
			}
		}
	}

    level.cut_scene_camera_switch = 0;	

	level.cut_scene_time = level.time + 0.1;

	if (ent->rotate[0])
	{
		ent->s.angles[0] += ent->rotate[0]*FRAMETIME*ent->speed;
	}

	if (ent->rotate[1])
	{
		ent->s.angles[1] += ent->rotate[1]*FRAMETIME*ent->speed;
	}

	if (ent->rotate[2])
	{
		ent->s.angles[2] += ent->rotate[2]*FRAMETIME*ent->speed;
	}

	// Ridah, not sure what ->save_avel is, but we need a way of setting an absolute velocity
	VectorMA(ent->s.origin, FRAMETIME*ent->speed, ent->cameravel, ent->s.origin);
/*
	if (ent->cameravel[0])
	{
    	vec3_t	forward;

	    AngleVectors (ent->save_avel, forward, NULL, NULL);
		VectorMA(ent->s.origin, ent->cameravel[0]*FRAMETIME, forward, ent->s.origin);
	}
	
	if (ent->cameravel[1])
	{
    	vec3_t	right;

	    AngleVectors (ent->save_avel, NULL, right, NULL);
		VectorMA(ent->s.origin, ent->cameravel[1]*FRAMETIME, right, ent->s.origin);
	}
	
	if (ent->cameravel[2])
	{
    	vec3_t	up;

	    AngleVectors (ent->save_avel, NULL, NULL, up);
		VectorMA(ent->s.origin, ent->cameravel[2]*FRAMETIME, up, ent->s.origin);
	}	
*/
	if (ent->cameravelrel[0])
	{
    	vec3_t	forward;

	    AngleVectors (ent->s.angles, forward, NULL, NULL);
		VectorMA(ent->s.origin, ent->cameravelrel[0]*FRAMETIME*ent->speed, forward, ent->s.origin);
	}
	
	if (ent->cameravelrel[1])
	{
    	vec3_t	right;

	    AngleVectors (ent->s.angles, NULL, right, NULL);
		VectorMA(ent->s.origin, ent->cameravelrel[1]*FRAMETIME*ent->speed, right, ent->s.origin);
	}
	
	if (ent->cameravelrel[2])
	{
    	vec3_t	up;

	    AngleVectors (ent->s.angles, NULL, NULL, up);
		VectorMA(ent->s.origin, ent->cameravelrel[2]*FRAMETIME*ent->speed, up, ent->s.origin);
	}	

    FollowEnt (ent);
 	
	VectorCopy (ent->s.angles, level.cut_scene_angle);
	VectorCopy (ent->s.origin, level.cut_scene_origin);

    //VectorCopy (ent->s.origin, ent->origin);	
    //VectorCopy (ent->s.origin, ent->oldorigin);	
	//VectorCopy (player->s.origin, level.player_oldpos);
	//VectorCopy (player->s.angles, level.player_oldang);

	// JOSEPH 19-MAR-99-B
	// Fade out
	if (ent->duration)
	{
		if ((level.time + ent->duration) > ent->alphalevel) 	
		{
			level.totalfade = ent->duration;
			level.fadeendtime = level.time + level.totalfade;		
			level.inversefade = 1;
			ent->duration = 0;
		}
	}
    // END JOSEPH

    MoveClientToCutSceneCamera (player, ent->deadticks);
}

void EndCutScene (edict_t *ent)
{
	edict_t *player;

	player = g_edicts + 1;

    level.cut_scene_camera_switch = 0;

    player->client->ps.fov = 90;
	
	VectorCopy (level.player_oldpos, player->s.origin);
	VectorCopy (level.player_oldang, player->s.angles);
	
	// JOSEPH 24-FEB-99
    level.cut_scene_camera_switch = 1;
	level.cut_scene_end_count = 5;
	// END JOSEPH	

	level.cut_scene_time = 0;
	
	player->client->ps.pmove.origin[0] = player->s.origin[0]*8;
	player->client->ps.pmove.origin[1] = player->s.origin[1]*8;
	player->client->ps.pmove.origin[2] = player->s.origin[2]*8;
	
	VectorCopy (level.player_oldang, player->client->ps.viewangles);


	if (!player->client->pers.weapon)
		return;
	
	{
		int i;


		if (!strcmp (player->client->pers.weapon->pickup_name , "Pistol Silencer"))
		{
			if ((player->client->pers.pistol_mods) && (player->client->pers.inventory[ITEM_INDEX(FindItem("Pistol Magnum Mod"))]))
				player->client->ps.gunindex = gi.modelindex("models/weapons/silencer_mdx/magnum.mdx");
			else
				player->client->ps.gunindex = gi.modelindex(player->client->pers.weapon->view_model);
		}
		else if (!strcmp (player->client->pers.weapon->pickup_name , "Pistol"))
		{
			if ((player->client->pers.pistol_mods) && (player->client->pers.inventory[ITEM_INDEX(FindItem("Pistol Magnum Mod"))]))
				player->client->ps.gunindex = gi.modelindex("models/weapons/v_colt/magnum.mdx");
			else
				player->client->ps.gunindex = gi.modelindex(player->client->pers.weapon->view_model);
		}
		else if (!strcmp (player->client->pers.weapon->pickup_name, "Heavy machinegun"))
		{
			if (player->client->pers.inventory[ITEM_INDEX(FindItem("HMG Cooling Mod"))])
				player->client->ps.gunindex = gi.modelindex("models/weapons/v_hmgcool/hmgcool.mdx");
			else
				player->client->ps.gunindex = gi.modelindex(player->client->pers.weapon->view_model);
		}
		else
			player->client->ps.gunindex = gi.modelindex(player->client->pers.weapon->view_model);


		memset(&(player->client->ps.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);

		player->client->ps.num_parts++;
		// player->client->ps.model_parts[PART_HEAD].modelindex = gi.modelindex(player->client->pers.weapon->view_model);
		player->client->ps.model_parts[PART_HEAD].modelindex = player->client->ps.gunindex;
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			player->client->ps.model_parts[PART_HEAD].skinnum[i] = 0; // will we have more than one skin???
	
		// HACK, set arm model
		if (!strcmp(player->client->pers.weapon->pickup_name, "Shotgun"))
		{
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/shotgun/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/shotgun/shell.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???
		}
		else if (!strcmp(player->client->pers.weapon->pickup_name, "Pipe"))
		{
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/blakjak/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
		}
		else if (!strcmp(player->client->pers.weapon->pickup_name, "Crowbar"))
		{
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/crowbar/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
		}
		else if (!strcmp(player->client->pers.weapon->pickup_name, "FlameThrower"))
		{
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_flamegun/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
		}
		// JOSEPH 4-MAR-99
		else if (!strcmp(player->client->pers.weapon->pickup_name, "Bazooka"))
		{
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_rocket_launcher/hand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
		
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_rocket_launcher/shell_a.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???		

			
			/*
			// note to self: not using this anymore
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_GUN].modelindex = gi.modelindex("models/weapons/v_rocket_launcher/shell_b.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_GUN].skinnum[i] = 0; // will we have more than one skin???		
			*/

			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_GUN2].modelindex = gi.modelindex("models/weapons/v_rocket_launcher/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_GUN2].skinnum[i] = 0; // will we have more than one skin???		

			
		}
		// END JOSEPH
		else if (!strcmp (player->client->pers.weapon->pickup_name , "Pistol Silencer"))
		{
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/silencer_mdx/handl.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
			
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/silencer_mdx/handr.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???

			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_GUN].modelindex = gi.modelindex("models/weapons/silencer_mdx/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_GUN].skinnum[i] = 0;

		}
		else if (!strcmp (player->client->pers.weapon->pickup_name , "Pistol"))
		{
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_colt/handl.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
			
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_colt/handr.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???

			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_GUN].modelindex = gi.modelindex("models/weapons/v_colt/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_GUN].skinnum[i] = 0;
		}
		// JOSEPH 16-APR-99
		else if (!strcmp (player->client->pers.weapon->pickup_name , "Heavy machinegun"))
		{
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_hmg/lhand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???

			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_hmg/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???
			
	}
		// END JOSEPH
		else if (!strcmp (player->client->pers.weapon->pickup_name , "Grenade Launcher"))
		{
			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_LEGS].modelindex = gi.modelindex("models/weapons/v_grenade_launcher/lhand.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_LEGS].skinnum[i] = 0; // will we have more than one skin???

			player->client->ps.num_parts++;
			player->client->ps.model_parts[PART_BODY].modelindex = gi.modelindex("models/weapons/v_grenade_launcher/clip.mdx");
			for (i=0; i<MAX_MODELPART_OBJECTS; i++)
				player->client->ps.model_parts[PART_BODY].skinnum[i] = 0; // will we have more than one skin???

		}

	}

// 	player->client->ps.gunindex = gi.modelindex(player->client->pers.weapon->view_model);
}
// END JOSEPH

void MoveClientToCutScene (edict_t *ent)
{
	VectorCopy (level.cut_scene_origin, ent->s.origin);
	ent->client->ps.pmove.origin[0] = level.cut_scene_origin[0]*8;
	ent->client->ps.pmove.origin[1] = level.cut_scene_origin[1]*8;
	ent->client->ps.pmove.origin[2] = level.cut_scene_origin[2]*8;
	VectorCopy (level.cut_scene_angle, ent->client->ps.viewangles);
	ent->client->ps.pmove.pm_type = PM_FREEZE;
		
	// note to self
	// this may cause a problem
	ent->client->ps.gunindex = 0;
	ent->client->ps.blend[3] = 0;
	ent->client->ps.rdflags &= ~RDF_UNDERWATER;
			
	// clean up powerup info
//	ent->client->quad_framenum = 0;//Q2
//	ent->client->invincible_framenum = 0;//Q2
//	ent->client->breather_framenum = 0;//Q2
//	ent->client->enviro_framenum = 0;//Q2
//	ent->client->grenade_blew_up = false;//Q2
//	ent->client->grenade_time = 0;//Q2

	// RAFAEL
//	ent->client->quadfire_framenum = 0;//Q2 Xatrix MOD

	// RAFAEL
//	ent->client->trap_blew_up = false;//Q2 Xatrix MOD
//	ent->client->trap_time = 0;//Q2 Xatrix MOD

	/*
	ent->viewheight = 0;
	ent->s.modelindex = 0;
//	ent->s.modelindex2 = 0;//Q2
//	ent->s.modelindex3 = 0;//Q2
	ent->s.effects = 0;
	ent->s.sound = 0;
	ent->solid = SOLID_NOT;
	*/

}

void MoveClientToCutSceneCamera (edict_t *ent, int fov)
{
	ent->client->ps.fov = fov;
	
	VectorCopy (level.cut_scene_origin, ent->s.origin);
	ent->client->ps.pmove.origin[0] = level.cut_scene_origin[0]*8;
	ent->client->ps.pmove.origin[1] = level.cut_scene_origin[1]*8;
	ent->client->ps.pmove.origin[2] = level.cut_scene_origin[2]*8;
	VectorCopy (level.cut_scene_angle, ent->client->ps.viewangles);
	ent->client->ps.pmove.pm_type = PM_FREEZE;
	
	// note to self
	// this may cause a problem
	ent->client->ps.gunindex = 0;
	ent->client->ps.blend[3] = 0;
	ent->client->ps.rdflags &= ~RDF_UNDERWATER;

	// clean up powerup info
//	ent->client->quad_framenum = 0;//Q2
//	ent->client->invincible_framenum = 0;//Q2
//	ent->client->breather_framenum = 0;//Q2
//	ent->client->enviro_framenum = 0;//Q2
//	ent->client->grenade_blew_up = false;//Q2
//	ent->client->grenade_time = 0;//Q2

	// RAFAEL
//	ent->client->quadfire_framenum = 0;//Q2 Xatrix MOD

	// RAFAEL
//	ent->client->trap_blew_up = false;//Q2 Xatrix MOD
//	ent->client->trap_time = 0;//Q2 Xatrix MOD

	/*
	ent->viewheight = 0;
	ent->s.modelindex = 0;
//	ent->s.modelindex2 = 0;//Q2
//	ent->s.modelindex3 = 0;//Q2
	ent->s.effects = 0;
	ent->s.sound = 0;
	ent->solid = SOLID_NOT;
	*/

}
// END JOSEPH

void MoveClientToPawnoMatic (edict_t *ent)
{
// RAFAEL 03-14-99
// Drew will compensate by moveing the start pos	
//	ent->client->ps.fov = 96;
	
// 	ent->s.origin[2] = level.pawn_origin[2];
	ent->client->ps.pmove.origin[0] = level.cut_scene_origin[0]*8;
	ent->client->ps.pmove.origin[1] = level.cut_scene_origin[1]*8;
	ent->client->ps.pmove.origin[2] = level.cut_scene_origin[2]*8;
	
	ent->client->ps.pmove.pm_type = PM_FREEZE;
	
	ent->client->ps.gunindex = 0;
	ent->client->ps.blend[3] = 0;
	ent->client->ps.rdflags &= ~RDF_UNDERWATER;

	// clean up powerup info
//	ent->client->quad_framenum = 0;//Q2
//	ent->client->invincible_framenum = 0;//Q2
//	ent->client->breather_framenum = 0;//Q2
//	ent->client->enviro_framenum = 0;//Q2
//	ent->client->grenade_blew_up = false;//Q2
//	ent->client->grenade_time = 0;//Q2

	// RAFAEL
//	ent->client->quadfire_framenum = 0;//Q2 Xatrix MOD

	// RAFAEL
//	ent->client->trap_blew_up = false;//Q2 Xatrix MOD
//	ent->client->trap_time = 0;//Q2 Xatrix MOD

}

// MH:
void UpdateRadarHUD (edict_t *ent)
{
	edict_t		*e;
	int         k;
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		j;
	vec3_t	v, v2 = { 9999 };
	float	len;
	int		maxlen = (CS_SERVER_VERSION - level.cs_statusbarex) * MAX_QPATH;
	int		players[2] = { 0 }; // MH: count players on each team

	string[0] = 0;
	stringlength = 0;

	Com_sprintf (entry, sizeof(entry),
		"xl %i yt %i picn %s ",
		5, 50 + 5, PIC_SCANNER_TAG ); // MH: lower the radar for console overlay

	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	// MH: show bomb targets or VIP escape point
	k = 0;
	e = NULL;
//	while (e = G_Find(e, FOFS(classname), level.crash_gametype == BOMB_MAP ? "trigger_bomb" : "trigger_vip"))
	while (e = G_Find(e, FOFS(classname), level.crash_gametype == BOMB_MAP ? "trigger_bomb","crash_bomb" : "trigger_vip", "crash_vip"))//FREDZ added 2 new entities
	{
		VectorSet(v, (e->mins[0] + e->maxs[0]) / 2, (e->mins[1] + e->maxs[1]) / 2, 0);
		if (v2[0] != 9999 && VectorDistance(v, v2) < 500) // some maps have a cluster of trigger_bomb
			continue;
		VectorCopy(v, v2);
		VectorSubtract (ent->s.origin, v, v);
		v[2] = 0;
		len = VectorLength (v);
		if (len <= SCANNER_RANGE)
		{
			int		sx, sy;
			vec3_t	dp;
			vec3_t	normal = {0,0,-1};

			VectorNormalize(v);
			RotatePointAroundVector( dp, normal, v, ent->s.angles[1]);
			VectorScale(dp,len*60/SCANNER_RANGE,dp);

			sx = 68 + dp[1];
			sy = 50 + 68 + dp[0];

			Com_sprintf (entry, sizeof(entry),
				"xl %i yt %i picn %s ",
				sx, sy, PIC_DOT2_TAG );

			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
		if (++k == 2)
			break;
	}

	for_each_player (e,k)
	{
		if (e->playing_ingame)
			players[e->client->pers.team != ent->client->pers.team]++; // MH: count players

		if (e->client->pers.team != ent->client->pers.team || e == ent || e->playing_ingame == FALSE)
			continue;

		VectorSubtract (ent->s.origin, e->s.origin, v);

		v[2] = 0;

		len = VectorLength (v);

		if (len <= SCANNER_RANGE)
		{
			int		sx,
					sy;

			vec3_t	dp;

			vec3_t	normal = {0,0,-1};

			VectorNormalize(v);

			RotatePointAroundVector( dp, normal, v, ent->s.angles[1]);

			VectorScale(dp,len*60/SCANNER_RANGE,dp);


			sx = 68 + dp[1];  
			sy = 50 + 68 + dp[0]; // MH: lower the radar for console overlay

			// MH: indicate vip or bomb holder
			if ((e->crashType == CRASH_VIP || e->crashType == CRASH_BOMBHOLDER) && (level.framenum % 10) < 5)
				Com_sprintf (entry, sizeof(entry),
					"xl %i yt %i picn %s ",
					sx, sy, PIC_DOT2_TAG );
			else
				Com_sprintf (entry, sizeof(entry),
					"xl %i yt %i picn %s ",
					sx, sy, PIC_DOT_TAG );

			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;

		}
	}

	// MH: show dropped bomb
	if (ent->client->pers.team == 2 && level.crash_gametype == BOMB_MAP && (level.framenum % 10) < 5 && (e = G_Find(NULL, FOFS(classname), "weapon_bomb")))
	{
		VectorSubtract (ent->s.origin, e->s.origin, v);
		v[2] = 0;
		len = VectorLength (v);
		if (len <= SCANNER_RANGE)
		{
			int		sx, sy;
			vec3_t	dp;
			vec3_t	normal = {0,0,-1};

			VectorNormalize(v);
			RotatePointAroundVector( dp, normal, v, ent->s.angles[1]);
			VectorScale(dp,len*60/SCANNER_RANGE,dp);

			sx = 68 + dp[1];
			sy = 50 + 68 + dp[0]; 

			Com_sprintf (entry, sizeof(entry),
				"xl %i yt %i picn %s ",
				sx, sy, PIC_DOT2_TAG );

			j = strlen(entry);
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}

	// MH: show radar key
	if (level.crash_gametype != DM_MAP && (level.modeset == PRE_MATCH || ++ent->client->resp.radarhint < 30))
	{
		if (level.crash_gametype == VIP_MAP)
		{
			strcpy(entry, "xl 8 yt 190 string \"blue = teammate\" "
				"yt 200 string \"red = VIP escape point\" ");
			if (ent->client->pers.team == 1)
				strcat(entry, "yt 210 string \"flashing red = VIP\" ");
		}
		else if (level.crash_gametype == BOMB_MAP)
		{
			strcpy(entry, "xl 8 yt 190 string \"blue = teammate\" "
				"yt 200 string \"red = bomb target\" ");
			if (ent->client->pers.team == 2)
				strcat(entry, "yt 210 string \"flashing red = bomb\" ");
		}

		j = strlen(entry);
		if (stringlength + j < maxlen)
		{
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}
	else
	{
		// MH: show number of players
		Com_sprintf(entry, sizeof(entry), "xl 41 yt 190 dmstr 787 \"%i v %i\" ", players[0], players[1]);
		j = strlen(entry);
		if (stringlength + j < maxlen)
		{
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}

	// MH: show sniper scope hint
	if ( !ent->client->pers.usedscope && ent->client->pers.weapon && (!strcmp(ent->client->pers.weapon->classname, "weapon_awp") || !strcmp(ent->client->pers.weapon->classname, "weapon_msg90")))
	{
		strcpy(entry, "xm -120 yb -68 dmstr 999 \"Press Z to use the scope\"");
		j = strlen(entry);
		if (stringlength + j < maxlen)
		{
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}

	SetExtendedHUD(ent, string, !ent->client->resp.exhud[0]);
}

// MH: set extended HUD content
void SetExtendedHUD(edict_t *ent, char *string, qboolean reliable)
{
	int maxlen;

	if (!reliable && !strcmp(string, ent->client->resp.exhud))
		return;

	// check it doesn't exceed the HUD size limit
	maxlen = (CS_SERVER_VERSION - level.cs_statusbarex) * MAX_QPATH - 1;
	if (strlen(string) > maxlen)
	{
		gi.dprintf("HUD size limit exceeded\n");
		string[maxlen] = 0;
	}

#define svc_configstring 15
	gi.WriteByte(svc_configstring);
	gi.WriteShort(level.cs_statusbarex);
	gi.WriteString(string);
	gi.unicast(ent, reliable);

	strcpy(ent->client->resp.exhud, string);
}

