//CTF_Stats.c - routines to display player stats

#include "g_local.h"

//Just sort the table by scores here because by the time the player reaches this board
//they know where their name is in the list - ie dont have them looking about

void CTF_Stats_Team(edict_t *ent, int Team)
{
	char	temp[64];
	char	entry[1024];
	char	string[1400]="";
	int		stringlength=0;
	int		i, j, k;
	int		sorted[MAX_CLIENTS];
	int		sortedscores[MAX_CLIENTS];
	int		score, total, realtotal;
//	int		picnum;
	gclient_t	*cl;
	edict_t		*cl_ent;
	char	*tag;
	int yofs;
	char* Team_ID;
	CTF_Player_Struct* PlayerData;

	switch (Team)
	{
		case 1:
		{
			Team_ID = "1";
			break;
		}
		case 2:
		{
			Team_ID = "2";
			break;
		}
		default:
		{
//Invalid
			return;
			break;
		}
	}

	GetChaseMessage(ent, entry);

//Display the map name
	Com_sprintf(temp, sizeof(temp), "current map : %s", level.mapname);
	Com_sprintf(entry, sizeof(entry), "xm %i yt 5 dmstr 752 \"%s\" ", -5 * strlen(temp), temp);

	j = strlen(entry);
	Q_Strcpy(string + stringlength, entry);
	stringlength += j;

// sort the clients by score
	total = 0;
	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;

		if (cl_ent->client->pers.spectator == SPECTATING)
			continue;
		if (cl_ent->client->pers.team != Team)
			continue;

		score = game.clients[i].resp.score;

		for (j=0 ; j<total ; j++)
		{
			if (score > sortedscores[j])
				break;
		}
		for (k=total ; k>j ; k--)
		{
			sorted[k] = sorted[k-1];
			sortedscores[k] = sortedscores[k-1];
		}
		sorted[j] = i;
		sortedscores[j] = score;
		total++;
	}

	realtotal = total;

/*	int Enemy_Flag_Stolen;//How many stolen from enemy base
	int Enemy_Flag_Pickups;//How many picked up away from base
	int Enemy_Flag_Stolen_Captures;//How many stolen from enemy base and captured
	int Enemy_Flag_Pickup_Captures;//How many picked up away from base and captured
	int Team_Flag_Rescued;;//How many own flag returned to home base
	int Enemy_Flag_Total_Captures;//Total enemy flag returns to home base
*/
		// Team header
	yofs = 0;
	
	Com_sprintf (entry, sizeof(entry),
		"xm %i yv %i dmstr 677 \"%s\" teampic %s xm %i tscore %s ",
		-31 * 10, yofs + (int)(-60.0 + -3.5 * 14), team_names[Team], Team_ID, -170, Team_ID);

	j = strlen(entry);
	Q_Strcpy (string + stringlength, entry);
	stringlength += j;

	yofs+=28;
	Com_sprintf (entry, sizeof(entry),
			"xm %i yv %i dmstr 663 \"NAME           frag steal pickup hrun caps total resc\" ",
			-31*10, yofs + (int)(-60.0+-3.5*14));

	yofs+=21;
	j = strlen(entry);
	Q_Strcpy (string + stringlength, entry);
	stringlength += j;

	for (i=0 ; i<total ; i++)
	{
		cl = &game.clients[sorted[i]];
		PlayerData = &cl->resp.PlayerData;

//		if ((cl->pers.spectator == SPECTATING) && (level.modeset != ENDMATCHVOTING))
//			continue;
//		picnum = gi.imageindex ("i_fixme");
		if (cl_ent == ent)
			tag = "990";
		else
			tag = "999";	// fullbright
//CDEATH - this shows who is carrying the flag
		if (PlayerData->Flag_State != CTF_DATA_FLAG_STATE_NULL)
			tag = "f00";
//END CDEATH

		Com_sprintf (entry, sizeof(entry),
//			"yv %i ds %s %i %i %i %i %i %i %i ",
			"yv %i dmstr %s \"%-16s %-4i %-4i   %-4i  %-4i %-4i %-4i  %-4i\" ",
			yofs + -109 + i * 17, tag, /*sorted[i],*/ cl->pers.netname, PlayerData->Frags, PlayerData->Enemy_Flag_Stolen,
			PlayerData->Enemy_Flag_Pickups, PlayerData->Enemy_Flag_Stolen_Captures, PlayerData->Enemy_Flag_Pickup_Captures,
			PlayerData->Enemy_Flag_Total_Captures, PlayerData->Team_Flag_Rescued);

//		yofs+=10;
		j = strlen(entry);
		if (stringlength + j > 1024)
			break;
		Q_Strcpy (string + stringlength, entry);
		stringlength += j;
	}

	if ((stringlength + 30 < 1024) && realtotal > total)
	{
		Com_sprintf (entry, sizeof(entry),
			"yv %i dmstr 999 \" ( %i total players )\" ",
			-60+total*16, realtotal );

		j = strlen(entry);
		if (stringlength + j < 1024)
		{
			Q_Strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}
skipscores:
	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

/*
{	y = 200;
	sprintf(string, "xm -300 yv %i dmstr f40 %s xm -225 dmstr 08f %s ", y, "\"Code:\"", "\"Captain Death\"");
	strcat(CTF_Game.MOTD, string);
	y += 20;
	sprintf(string, "xm -300 yv %i dmstr f40 %s xm -225 dmstr 08f %s ", y, "\"Skins:\"", "\"DirtyDog{WC}\"");
	strcat(CTF_Game.MOTD, string);
	y += 20;
	sprintf(string, "xm -300 yv %i dmstr f40 %s xm -225 dmstr 08f %s ", y, "\"Lead:\"", "\"Mr. Damage\"");
	strcat(CTF_Game.MOTD, string);
	y += 20;
	sprintf(string, "xm -300 yv %i dmstr f40 %s xm -225 dmstr 08f %s ", y, "\"Maps:\"", "\"TeaMXtReMe*, Mayhem, Sonik, Hypo, Tunnleram\"");
	strcat(CTF_Game.MOTD, string);
	y += 20;
	sprintf(string, "xm -300 yv %i dmstr f40 %s xm -225 dmstr 08f %s ", y, "\"Models:\"", "\"Tical\"");
	strcat(CTF_Game.MOTD, string);
}
*/

void CTF_DeathmatchScoreboard (edict_t *ent)
{
	switch (ent->client->showscores)
	{
		case SCORE_MOTD:
		{
			MOTDScoreboardMessage(ent);
			break;
		}
		case SCORE_REJOIN:
		{
			RejoinScoreboardMessage(ent);
			break;
		}
		case SPECTATORS:
		{
			SpectatorScoreboardMessage(ent);
			break;
		}
		case SCORE_MAP_VOTE:
		{
			VoteMapScoreboardMessage(ent);
			break;
		}
		case SCORE_STATS_ONE:
		{
			CTF_Stats_Team(ent, 1);
			break;
		}
		case SCORE_STATS_TWO:
		{
			CTF_Stats_Team(ent, 2);
			break;
		}
		case NO_SCOREBOARD:	//Required for chase message etc
		case SCOREBOARD:
		case SCOREBOARD2:
		{
//			if ((level.modeset == MATCHSETUP) || (level.modeset == MATCHCOUNT) || (level.modeset == PREGAME))
//				MatchSetupScoreboardMessage(ent);
//			else
				GrabDaLootScoreboardMessage(ent);
			break;
		}
		default:
		{
			break;
		}
	}

	gi.unicast(ent, !ent->client->resp.scoreboard_frame);

	ent->client->resp.scoreboard_frame = level.framenum;
	if (ent->client->showscores == SCORE_REJOIN)
		ent->client->resp.scoreboard_frame += 10000; // no need to refresh rejoin message

}

void CTF_Cmd_Score_f (edict_t *ent)
{
	int		i,spectators;
	edict_t	*dood;

	ent->client->showinventory = false;

//Check for spectators
	spectators = false;
	for_each_player(dood,i)
	{
		if (dood->client->pers.spectator == SPECTATING)
		{
			spectators = true;
			break;
		}
	}
/*
Rearrange this logic so that spectators (if any) are shown after SCORE_STATSTWO
Also check display logic is correct as currently when map voting is enabled, if going off the map vote you cannot get back on it
It just cycles between scoreboard 1 & 2
*/
	switch (level.modeset)
	{
		case MATCHSETUP:
		case MATCHCOUNT:
		case PREGAME:
		{
//Setup. Cycle Scoreboard->scoreboard2->spectators->off
			switch (ent->client->showscores)
			{
				case SCORE_MOTD:
				case NO_SCOREBOARD:
				{
					ent->client->showscores = SCOREBOARD;
					break;
				}
				case SCOREBOARD:
				{
					ent->client->showscores = SCOREBOARD2;
					break;
				}
				case SCOREBOARD2:
				{
					if (spectators == true)
						ent->client->showscores = SPECTATORS;
					else
						ent->client->showscores = NO_SCOREBOARD;
					break;
				}
				case SPECTATORS:
				{
					ent->client->showscores = NO_SCOREBOARD;
					break;
				}
			}
			break;
		}
//Game is in process of starting. Probably lasts a couple of frames at most so same as MATCH etc
		case MATCHSPAWN:
		case PUBLICSPAWN:
		case MATCH:
		case PUBLIC:
		{
//Active game. Cycle Scoreboard->scoreboard2->stats1->stats2->spectators->off
			switch (ent->client->showscores)
			{
				case SCORE_MOTD:
				case NO_SCOREBOARD:
				{
					ent->client->showscores = SCOREBOARD;
					break;
				}
				case SCOREBOARD:
				{
					ent->client->showscores = SCOREBOARD2;
					break;
				}
				case SCOREBOARD2:
				{
					ent->client->showscores = SCORE_STATS_ONE;
					break;
				}
				case SCORE_STATS_ONE:
				{
					ent->client->showscores = SCORE_STATS_TWO;
					break;
				}
				case SCORE_STATS_TWO:
				{
					if (spectators == true)
						ent->client->showscores = SPECTATORS;
					else
					{
						if (level.intermissiontime)
							ent->client->showscores = SCOREBOARD;
						else
							ent->client->showscores = NO_SCOREBOARD;
					}
					break;
				}
				case SPECTATORS:
				{
					if (level.intermissiontime)
						ent->client->showscores = SCOREBOARD;
					else
						ent->client->showscores = NO_SCOREBOARD;
					break;
				}
			}
			break;
		}
		case ENDGAMEVOTE:
		{
//Map vote mode. Cycle: vote->scoreboard->stats1->stats2->spectators->vote
			switch (ent->client->showscores)
			{
				case SCORE_MAP_VOTE:
				case SCORE_MOTD:
				case NO_SCOREBOARD:
				{
					ent->client->showscores = SCOREBOARD;
					break;
				}
				case SCOREBOARD:
				{
					ent->client->showscores = SCOREBOARD2;
					break;
				}
				case SCOREBOARD2:
				{
					ent->client->showscores = SCORE_STATS_ONE;
					break;
				}
				case SCORE_STATS_ONE:
				{
					ent->client->showscores = SCORE_STATS_TWO;
					break;
				}
				case SCORE_STATS_TWO:
				{
					if (spectators == true)
						ent->client->showscores = SPECTATORS;
					else
						ent->client->showscores = SCORE_MAP_VOTE;
					break;
				}
				case SPECTATORS:
				{
					ent->client->showscores = SCORE_MAP_VOTE;
					break;
				}
			}
			break;
		}
	}
	ent->client->resp.scoreboard_frame = 0;
	CTF_DeathmatchScoreboard(ent);
}
