/*
	Author	: Vincent 'Zarjazz' Sweeney
	Email	: zarjazz@barrysworld.com
	WebPage	: http://www.barrysworld.com/

	Copyright  1998-2000 BarrysWorld Ltd - All rights reserved.
	----
	$Id: common.c,v 1.1 2000/07/07 11:07:31 zarjazz Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <string.h>
#include <ctype.h>

#include <time.h>
#include <sys/stat.h>

#include "common.h"

/*
=================
Memory (De)Allocation

=================
*/

void *safe_malloc (unsigned size)
{
	void *p = (void *) malloc(size);

	if (!p) Error("Memory Alloc (%u) bytes",size);

	return p;
}

void safe_free (void *ptr)
{
	if (ptr) free (ptr);
}

/*
=================
local_time_str

returns a string with the local time
in "dd:mm:yy" format
=================
*/

char *local_time_str (void)
{
	char *s;
	struct tm *newtime;
	time_t tm;

	time( &tm );
	newtime = localtime( &tm );
	s = asctime(newtime);
	s[strlen(s)-1] = '\0'; // remove newline

	return s;
}

/*
=================
Read_To_Buf

Reads entire file to a malloc'd buffer
=================
*/

unsigned char *ReadToBuf (const char *fname, unsigned int *sz)
{
	struct stat filestats;
	unsigned char *buf;
	unsigned int size;
	FILE *f;

	f = fopen(fname,"rb");
	if (!f)	Error("Unable to open file: %s",fname);

	stat(fname,&filestats);
	size = filestats.st_size;

	buf = (unsigned char *) safe_malloc (size + 1);
	fread(buf,size,1,f);
	buf[size] = '\0';	// Ensure 0 byte terminator
	fclose(f);

	if (sz) *sz = size;

	return buf;
}


/*
=================
Error

prints an error message and exits progam
=================
*/

void Error (const char *error, ...)
{
	va_list argptr;

	puts("************ ERROR ************");

	va_start(argptr, error);
	vprintf(error, argptr);
	va_end(argptr);

	printf("\n");

	exit(EXIT_FAILURE);
}

/*
=================
Warn

prints a warning message
=================
*/

void Warn (const char *warning, ...)
{
	va_list argptr;

	printf("** WARNING ***\n");

	va_start(argptr, warning);
	vprintf(warning, argptr);
	va_end(argptr);

	printf("\n");
}

/*
=================
Print_Raw

writes raw data to file
=================
*/

#define COL_WIDTH	8
#define COL_COUNT	2

void Print_Raw (FILE *f, unsigned char *d, unsigned int sz)
{
	unsigned int i,j,n,x;
	unsigned char *c;
	int k;

	while (sz)
	{
		// Hex Output

		c = d;
		x = sz;

		fputs("  ",f);

		for (k = 0; k < COL_COUNT; k++)
		{
			if (x >= COL_WIDTH)
				{ i = COL_WIDTH; j = 0; }
			else
				{ i = x; j = COL_WIDTH - x; }

			for (n=0; n < i; n++) fprintf(f,"%.2x ",(int) *c++);
			for (n=0; n < j; n++) fputs("   ",f);

			fputc(' ',f);

			x -= i;
		}

		// Ascii Output

		c = d;
		x = sz;

		fputc(' ',f);

		for (k = 0; k < COL_COUNT; k++)
		{
			if (x >= COL_WIDTH)
				{ i = COL_WIDTH; j = 0; }
			else
				{ i = x; j = COL_WIDTH - x; }

			for (n=0; n < i; n++)
			{
				unsigned char a;

				a = *c++;
				fputc(isprint(a) ? a : '.',f);
			}
			for (n=0; n < j; n++) fputc(' ',f);

			x -= i;
		}

		// End

		d = c;
		sz = x;

		fputs("\n",f);
	}
}
