#include "g_local.h"



// snap - turn the radio on or off
void RadioToggle_f(edict_t *self)
{
	if(self->radio_power){
		self->radio_power = 0;
		gi.cprintf(self, PRINT_CHAT, "\n>.RADIO power is OFF\n");

		gi.WriteByte( svc_stufftext );
		gi.WriteString( va("play misc/talk.wav") );
		gi.unicast (self, true);
	}
	else{
		self->radio_power = 1;
		gi.cprintf(self, PRINT_CHAT, "\n>.RADIO power is ON\n");

		gi.WriteByte( svc_stufftext );
		gi.WriteString( va("play misc/talk.wav") );
		gi.unicast (self, true);
	}
		
}


// snap - changed the centerprints to print_chats
//        kingpin's centerprints are nasty, they clear the chat messages
void Radio_f(edict_t *self, char *channel)
{
	edict_t	*player;
	int		i;
	gclient_t *cl;

	// snap, check to make sure they arent dead before playing radio
	if(!self->playing_ingame || !self->radio_power)
		return;

	// snap - flood protection for clients spamming radio messages
	if (flood_msgs->value) {
		cl = self->client;

      if (level.time < cl->R_flood_locktill) {
			cprintf(self, PRINT_HIGH, "You can't use the radio for %d more seconds\n",
				(int)(cl->R_flood_locktill - level.time));
            return;
      }
      i = cl->R_flood_whenhead - flood_msgs->value + 1;
      if (i < 0)
          i = (sizeof(cl->R_flood_when)/sizeof(cl->R_flood_when[0])) + i;
		if (cl->R_flood_when[i] && 
			level.time - cl->R_flood_when[i] < flood_persecond->value) {
			cl->R_flood_locktill = level.time + flood_waitdelay->value;
			gi.cprintf(self, PRINT_CHAT, "Flood protection:  You can't use the radio for %d seconds.\n",
				(int)flood_waitdelay->value);
         return;
      }

      // if they repeat themselves really quickly, bitch-slap time
		if (cl->R_flood_when[cl->R_flood_whenhead] && (cl->R_flood_when[cl->R_flood_whenhead] > level.time - 1) &&
			!strcmp( self->client->R_flood_lastmsg, channel ))
		{
			cl->R_flood_locktill = level.time + flood_waitdelay->value;
			gi.cprintf(self, PRINT_CHAT, "Repeat Flood protection:  You can't use the radio for %d seconds.\n",
				(int)flood_waitdelay->value);
         return;
		}

		cl->R_flood_whenhead = (cl->R_flood_whenhead + 1) %
			(sizeof(cl->R_flood_when)/sizeof(cl->R_flood_when[0]));
		cl->R_flood_when[cl->R_flood_whenhead] = level.time;
	}

	strcpy( self->client->R_flood_lastmsg, channel );

	// snap - turn off the radio hud if displayed
	if(self->client->showscores == SCORE_RADIO){
		self->client->showscores = NO_SCOREBOARD;
		DeathmatchScoreboard (self);
	}

	if (Q_stricmp (channel, "clear") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: The coast is clear, let's go\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/clear.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: I don't see shit\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/clear.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
	else if (Q_stricmp (channel, "cover") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Cover me I'm goin in\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/cover.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Get my back\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/cover.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
	else if (Q_stricmp (channel, "follow") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Follow my lead\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/follow.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Follow me\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/follow.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
	else if (Q_stricmp (channel, "hold") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Hold this ground\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/hold.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Stay over here\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/hold.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
	else if (Q_stricmp (channel, "icenemy") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: I have visual confirmation\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/icenemy.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: I see them\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/icenemy.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
	else if (Q_stricmp (channel, "kill") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Take these motherfuckers down\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/kill.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Let's fuck these bitches up\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/kill.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
	else if (Q_stricmp (channel, "letsgo") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Let's go\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/letsgo.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Let's go\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/letsgo.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
	else if (Q_stricmp (channel, "no") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: That's a negative\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/no.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Nah man\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/no.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
	else if (Q_stricmp (channel, "stay") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Stay close team\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/stay.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Don't break the pack\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/stay.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
	else if (Q_stricmp (channel, "yes") == 0)
	{
		for_each_player(player, i)
		{
			// snap, check to make sure they are playing and have radio on to hear this
			if (player->radio_power && player->client->pers.team == self->client->pers.team && player->playing_ingame)
			{
				gi.WriteByte( svc_stufftext );
				if (player->client->pers.team == 1){
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Affirmative\n", self->client->pers.netname);
					gi.WriteString( va("play radio_crash/yes.wav") );
				}
				else{
					gi.cprintf(player, PRINT_CHAT, "(%s):RADIO: Yeah that's it\n", self->client->pers.netname);
					gi.WriteString( va("play radio_gang/yes.wav") );
				}
				gi.unicast (player, true);	
			}
		}
         return;
	}
}
