/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) & Frank Petersen (Chief), 
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington or Frank Petersen

//
//	I, Ernest Buffington & Frank Petersen, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
//
//  I also wish to thank and acknowledge the great work of others
//  that has helped me to develop this code.
//

//  {GT}Amber          - Design ideas and debug intervals. (My Daughter - She is great!)
//  {GT}Seb            - Design ideas and debug intervals. (My Son - He is 4 years old)
//  {GT}Krieg          - Design ideas and debug intervals. (My Son - He is the greatest)
//  {GT}PitBullet      - Design ideas and debug intervals.
//  {GT}Deeg           - Design ideas and debug intervals.
//  {GT}PsychoTaz      - Design ideas and debug intervals.
//  {GT}*Knight*       - For Model Design ideas and debug intervals.
//  {GT}SubZero        - Design ideas and debug intervals.
//  {GT}Freak          - For Model Design ideas and swapping code.
//  {GT}Sylacs         - For Model Design.
//  Chief              - For ideas and swapping code.
//  SNAP               - For ideas and swapping code.
//  TiCal              - For Model Design ideas and swapping code.
//  Scott Buffington   - Code Design. (This is my father, there is no other like my dear father)
//
//  And to all the other testers, pathers, and players and people
//  who I can't remember who the heck they were, but helped out.
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "g_local.h"

// edict->hookstate bit constants
#define HOOK_ON		0x00000001 // set if hook command is active
#define HOOK_IN		0x00000002 // set if hook has attached
#define SHRINK_ON	0x00000004 // set if shrink chain is active 
#define GROW_ON		0x00000008 // set if grow chain is active

// edict->sounds constants
#define MOTOR_OFF	0	   // motor sound has not been triggered
#define MOTOR_START	1	   // motor start sound has been triggered
#define MOTOR_ON	2	   // motor running sound has been triggered


void SV_AddGravity (edict_t *ent);
qboolean CheckTeamDamage (edict_t *targ, edict_t *attacker);
void button_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void Cmd_Hook1_f (edict_t *ent);
void Cmd_Hook_f (edict_t *ent);

// this is the same as function P_ProjectSource in p_weapons.c except it 
// projects the offset distance in reverse since hook is launched with 
// player's free hand
void P_ProjectSource_Reverse (gclient_t *client, vec3_t point, vec3_t distance,vec3_t forward, vec3_t right, vec3_t result) 
{

  vec3_t _distance;


  VectorCopy (distance, _distance);

  if (client->pers.hand == RIGHT_HANDED)
    _distance[1] *= -1;
  else if (client->pers.hand == CENTER_HANDED)
    _distance[1] = 0;

  G_ProjectSource (point, _distance, forward, right, result);

}

static void P_ProjectSourceKPQ2 (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward, vec3_t right, vec3_t result)
{
	vec3_t	_distance;

	VectorCopy (distance, _distance);
	if (client->pers.hand == LEFT_HANDED)
		_distance[1] *= -1;
	else if (client->pers.hand == CENTER_HANDED)
		_distance[1] = 0;
	G_ProjectSource (point, _distance, forward, right, result);
}


// ent is player
void KPQ2PlayerResetGrapple(edict_t *ent)
{
	if (ent->client && ent->client->kpq2_grapple)
	{
		KPQ2ResetGrapple(ent->client->kpq2_grapple);
	}
}

// self is grapple, not player
void KPQ2ResetGrapple(edict_t *self)
{
	if (self->owner->client->kpq2_grapple)
	{
		float volume = 1.0;
		gclient_t *cl;

		if (self->owner->client->silencer_shots)
			volume = 0.2;

		gi.sound (self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("weapons/grapple/grreset.wav"), volume, ATTN_NORM, 0);
		cl = self->owner->client;
		cl->kpq2_grapple = NULL;
		cl->kpq2_grapplereleasetime = level.time;
		cl->kpq2_grapplestate = KPQ2_GRAPPLE_STATE_FLY; // we're firing, not on hook
		cl->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
		G_FreeEdict(self);
	}
}


void KPQ2GrappleTouch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	float volume = 1.0;

	if (other == self->owner)
		return;

	if (self->owner->client->kpq2_grapplestate != KPQ2_GRAPPLE_STATE_FLY)
		return;

	if (surf && (surf->flags & SURF_SKY))
	{
		KPQ2ResetGrapple(self);
		return;
	}

	VectorCopy(vec3_origin, self->velocity);

	PlayerNoise(self->owner, self->s.origin, PNOISE_IMPACT);

	if (other->takedamage) {
		T_Damage (other, self, self->owner, self->velocity, self->s.origin, plane->normal, self->dmg, 1, 0, MOD_GRAPPLE);
		KPQ2ResetGrapple(self);
		return;
	}

	self->owner->client->kpq2_grapplestate = KPQ2_GRAPPLE_STATE_PULL; // we're on hook
	self->enemy = other;

	self->solid = SOLID_NOT;

	if (self->owner->client->silencer_shots)
		volume = 0.2;

	gi.sound (self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("weapons/grapple/grpull.wav"), volume, ATTN_NORM, 0);
	gi.sound (self, CHAN_WEAPON, gi.soundindex("weapons/grapple/grhit.wav"), volume, ATTN_NORM, 0);

	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_SPARKS);
	gi.WritePosition (self->s.origin);
	if (!plane)
		gi.WriteDir (vec3_origin);
	else
		gi.WriteDir (plane->normal);
	gi.multicast (self->s.origin, MULTICAST_PVS);
}


// draw beam between grapple and self
void KPQ2GrappleDrawCable(edict_t *self)
{
	vec3_t	offset, start, end, f, r;
	vec3_t	dir;
	float	distance;

	
	if(!self->owner->health)
		return;

	AngleVectors (self->owner->client->v_angle, f, r, NULL);
	VectorSet(offset, 16, 16, self->owner->viewheight-8);
	P_ProjectSourceKPQ2 (self->owner->client, self->owner->s.origin, offset, f, r, start);

	VectorSubtract(start, self->owner->s.origin, offset);

	VectorSubtract (start, self->s.origin, dir);
	distance = VectorLength(dir);
	// don't draw cable if close
	if (distance < 64)
		return;

#if 0
	if (distance > 256)
		return;

	// check for min/max pitch
	vectoangles (dir, angles);
	if (angles[0] < -180)
		angles[0] += 360;
	if (fabs(angles[0]) > 45)
		return;

	trace_t	tr; //!!

	tr = gi.trace (start, NULL, NULL, self->s.origin, self, MASK_SHOT);
	if (tr.ent != self) {
		KPQ2ResetGrapple(self);
		return;
	}
#endif

	// adjust start for beam origin being in middle of a segment
	VectorMA (start, 8, f, start);
	
	VectorCopy (self->s.origin, end);
	// adjust end z for end spot since the monster is currently dead
	end[2] = self->absmin[2] + self->size[2] / 2;


    gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_GRAPPLE_CABLE);
	gi.WriteShort (self->owner - g_edicts);
	gi.WritePosition (self->owner->s.origin);
	gi.WritePosition (end);
	gi.WritePosition (offset);
	gi.multicast (self->s.origin, MULTICAST_PVS);
		
}

// pull the player toward the grapple
void KPQ2GrapplePull(edict_t *self)
{
	
    vec3_t hookdir, v;
	float vlen;

	
	if (strcmp(self->owner->client->pers.weapon->classname, "weapon_grapple") == 0 &&
		!self->owner->client->newweapon &&
		self->owner->client->weaponstate != WEAPON_FIRING &&
		self->owner->client->weaponstate != WEAPON_ACTIVATING) 
	{
		KPQ2ResetGrapple(self);
		return;
	}


	if (self->enemy)
	{
		if (self->enemy->solid == SOLID_NOT) 
		{
			KPQ2ResetGrapple(self);
			return;
		}
		
	if (self->movetype == MOVETYPE_NOCLIP)
		{
			KPQ2ResetGrapple(self);
			return;
		}

	if (self->enemy->is_hook)
		{
			KPQ2ResetGrapple(self);
			return;
		}

		
	if (self->enemy->solid == SOLID_BBOX) 
		{
			VectorScale(self->enemy->size, 0.5, v);
			VectorAdd(v, self->enemy->s.origin, v);
			VectorAdd(v, self->enemy->mins, self->s.origin);
			gi.linkentity (self);
		} 
		else
			VectorCopy(self->enemy->velocity, self->velocity);
		
	if (self->enemy->takedamage &&
			!CheckTeamDamage (self->enemy, self->owner)) 
		{
			float volume = 0.6;

	if (self->owner->client->silencer_shots)
				volume = 0.6;

			T_Damage (self->enemy, self, self->owner, self->velocity, self->s.origin, vec3_origin, 1, 1, 0, MOD_GRAPPLE);
			gi.sound (self, CHAN_WEAPON, gi.soundindex("weapons/grapple/grhurt.wav"), volume, ATTN_NORM, 0);
		}
		
	if (self->enemy->deadflag) 
		{ // he died
			KPQ2ResetGrapple(self);
			return;
		}
	}

	KPQ2GrappleDrawCable(self);

	if (self->owner->client->kpq2_grapplestate > KPQ2_GRAPPLE_STATE_FLY) 
	{
		// pull player toward grapple
		// this causes icky stuff with prediction, we need to extend
		// the prediction layer to include two new fields in the player
		// move stuff: a point and a velocity.  The client should add
		// that velociy in the direction of the point
		vec3_t forward, up;

		AngleVectors (self->owner->client->v_angle, forward, NULL, up);
		VectorCopy(self->owner->s.origin, v);
		v[2] += self->owner->viewheight;
		VectorSubtract (self->s.origin, v, hookdir);

		vlen = VectorLength(hookdir);

		if (self->owner->client->kpq2_grapplestate == KPQ2_GRAPPLE_STATE_PULL &&
			vlen < 64) 
		{
			float volume = 0.6;

			if (self->owner->client->silencer_shots)
				volume = 0.6;

			self->owner->client->ps.pmove.pm_flags |= PMF_NO_PREDICTION;
			gi.sound (self->owner, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("weapons/grapple/grhang.wav"), volume, ATTN_NORM, 0);
			self->owner->client->kpq2_grapplestate = KPQ2_GRAPPLE_STATE_HANG;
		}

		VectorNormalize (hookdir);
		VectorScale(hookdir, KPQ2_GRAPPLE_PULL_SPEED, hookdir);
		VectorCopy(hookdir, self->owner->velocity);
		SV_AddGravity(self->owner);
	}
}

void KPQ2FireGrapple (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int effect)
{
	edict_t	*grapple;
	trace_t	tr;

	VectorNormalize (dir);

	grapple = G_Spawn();
	VectorCopy (start, grapple->s.origin);
	VectorCopy (start, grapple->s.old_origin);
	vectoangles (dir, grapple->s.angles);
	VectorScale (dir, speed, grapple->velocity);
	grapple->movetype = MOVETYPE_FLYMISSILE;
	grapple->clipmask = MASK_SHOT;
	grapple->solid = SOLID_BBOX;
	grapple->s.effects |= effect;
	VectorClear (grapple->mins);
	VectorClear (grapple->maxs);
	grapple->s.modelindex = gi.modelindex ("models/weapons/grapple/hook/tris.md2");
//	grapple->s.sound = gi.soundindex ("misc/lasfly.wav");
	grapple->owner = self;
	grapple->touch = KPQ2GrappleTouch;
//	grapple->nextthink = level.time + FRAMETIME;
//	grapple->think = KPQ2GrappleThink;
	grapple->dmg = CustBlakjakDmg;
	self->client->kpq2_grapple = grapple;
	self->client->kpq2_grapplestate = KPQ2_GRAPPLE_STATE_FLY; // we're firing, not on hook
	gi.linkentity (grapple);

	tr = gi.trace (self->s.origin, NULL, NULL, grapple->s.origin, grapple, MASK_SHOT);
	if (tr.fraction < 1.0)
	{
		VectorMA (grapple->s.origin, -10, dir, grapple->s.origin);
		grapple->touch (grapple, tr.ent, NULL, NULL);
	}
}	

void KPQ2GrappleFire (edict_t *ent, vec3_t g_offset, int damage, int effect)
{
	vec3_t	forward, right;
	vec3_t	start;
	vec3_t	offset;
	float volume = 1.0;

	
	gclient_t *cl;
	
	cl = ent->client;

   if (cl->pers.holsteredweapon){ 
   return;
   }
	
	if (ent->solid == SOLID_NOT)
	return;
	
	if (ent->client->kpq2_grapplestate > KPQ2_GRAPPLE_STATE_FLY)
		return; // it's already out

	AngleVectors (ent->client->v_angle, forward, right, NULL);
//	VectorSet(offset, 24, 16, ent->viewheight-8+2);
	VectorSet(offset, 24, 8, ent->viewheight-8+2);
	VectorAdd (offset, g_offset, offset);
	P_ProjectSourceKPQ2 (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	if (ent->client->silencer_shots)
		volume = 0.2;

	gi.sound (ent, CHAN_RELIABLE+CHAN_WEAPON, gi.soundindex("weapons/grapple/grfire.wav"), volume, ATTN_NORM, 0);
	KPQ2FireGrapple (ent, start, forward, damage, KPQ2_GRAPPLE_SPEED, effect);

#if 0
	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_BLASTER);
	gi.multicast (ent->s.origin, MULTICAST_PVS);
#endif

	PlayerNoise(ent, start, PNOISE_WEAPON);
		
}

void KPQ2Weapon_Grapple_Fire (edict_t *ent)
{
	int		damage;

	damage = 0;
	
	KPQ2GrappleFire (ent, vec3_origin, damage, 0);
	
	ent->client->ps.gunframe++;
}

void Weapon_Generic (edict_t *ent, int FRAME_ACTIVATE_LAST, int FRAME_FIRE_LAST, 
					 int FRAME_IDLE_LAST, int FRAME_DEACTIVATE_LAST, int *pause_frames, 
					 int *fire_frames, void (*fire)(edict_t *ent));


void KPQ2Weapon_Grapple (edict_t *ent)
{
	static int	pause_frames[]	= {10, 18, 27, 0};
	static int	fire_frames[]	= {6, 0};
	int prevstate;

	// if the the attack button is still down, stay in the firing frame
	if ((ent->client->buttons & BUTTON_ATTACK) && 
		ent->client->weaponstate == WEAPON_FIRING &&
		ent->client->kpq2_grapple)
		ent->client->ps.gunframe = 9;

	if (!(ent->client->buttons & BUTTON_ATTACK) && 
		ent->client->kpq2_grapple)
	{
		KPQ2ResetGrapple(ent->client->kpq2_grapple);
		if (ent->client->weaponstate == WEAPON_FIRING)
			ent->client->weaponstate = WEAPON_READY;
	}


	if (ent->client->newweapon && 
		ent->client->kpq2_grapplestate > KPQ2_GRAPPLE_STATE_FLY &&
		ent->client->weaponstate == WEAPON_FIRING)
	{
		// he wants to change weapons while grappled
		ent->client->weaponstate = WEAPON_DROPPING;
		ent->client->ps.gunframe = 32;
	}

	prevstate = ent->client->weaponstate;
	Weapon_Generic (ent, 5, 9, 31, 36, pause_frames, fire_frames,KPQ2Weapon_Grapple_Fire);

	// if we just switched back to grapple, immediately go to fire frame
	if (prevstate == WEAPON_ACTIVATING &&
		ent->client->weaponstate == WEAPON_READY &&
		ent->client->kpq2_grapplestate > KPQ2_GRAPPLE_STATE_FLY)
	{
		if (!(ent->client->buttons & BUTTON_ATTACK))
			ent->client->ps.gunframe = 9;
		else
			ent->client->ps.gunframe = 5;
		ent->client->weaponstate = WEAPON_FIRING;
	}
}

void Offhand_Grapple_Fire (edict_t *ent)
{
   
    if (ent->touch != button_touch){

	if (ent->client->kpq2_grapplestate > KPQ2_GRAPPLE_STATE_FLY){
	KPQ2PlayerResetGrapple(ent);
	}

	if (ent->solid != SOLID_NOT)
		{	// stop chasing
		KPQ2GrappleFire (ent, vec3_origin, 10, 0);
		}
	
	}
}

void Offhand_Grapple_Drop (edict_t *ent)
{
  KPQ2PlayerResetGrapple(ent);
}

void Cmd_Hook_f (edict_t *ent)
{

	char		*z;

	if (CustHook != 1){
	    safe_centerprintf (ent, "Admin Has The Hook Disabled!!!\n");
        return;
	}

    else
	if (CustHook == 1){

	z = gi.args();

	if (z)
		{
			if (!strcmp(z, "out"))
				if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Hook"))] < 1){
			    safe_centerprintf (ent, "Hook is holstered or out already!\n");
				}
		else
            if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Hook"))] > 0){ 
			KPQ2GrappleFire (ent, vec3_origin, 10, 0);
	        ent->client->pers.inventory[ITEM_INDEX(FindItem("Hook"))] -= 1;	
			}
			
			else if (!strcmp(z, ""))
			{	// Pins
				if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Hook"))] < 5){
				safe_centerprintf (ent, "\nType 'HELPME' in console\n");
			    ent->client->pers.inventory[ITEM_INDEX(FindItem("Hook"))] = 1; 	
				}
			}

		
			if (!strcmp(z, "in"))
			{	// Pins
				if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Hook"))] < 1){
				KPQ2PlayerResetGrapple(ent);
			   ent->client->pers.inventory[ITEM_INDEX(FindItem("Hook"))] += 1;
				}
			}
		return;
	}


 }	
	
}

//FREAK_ADD
//====================================================================
//
// HITMEN GRAPPLING HOOK for Kingpin
// Original Hook by: Perecli Manole AKA Bort
// Re Write by : {GT}Freak
//====================================================================
// Aside from this new file, the following are the modifications
// done to id's original source files:
//--------------------------------------------------------------------
// File: g_cmds.c
// Location: on top after the #includes
// Added: void Cmd_Hook_f (edict_t *ent);
//--------------------------------------------------------------------
// File: g_cmds.c
// Procedure: ClientCommand
// Location: after line "if (level.intermissiontime) return;"
// Added: if (Q_stricmp (cmd, "hook") == 0)
//			Cmd_Hook_f (ent);
//        else
//--------------------------------------------------------------------
// File: p_view.c
// Procedure: P_FallingDamage
// Location: after line "if (ent->waterlevel == 3) return;"
// Added: if (!(ent->client->ps.pmove.pm_flags & PMF_ON_GROUND))
//          return;
//--------------------------------------------------------------------
// File: g_local.h
// Structure: gclient_s 
// Location: after line "weaponstate_t weaponstate;"
// Added: int hookstate;
//--------------------------------------------------------------------
// File: q_shared.h
// Location: sound channel definitions
// Added: #define CHAN_HOOK 5
//--------------------------------------------------------------------
void DropHook (edict_t *ent) {

  // remove all hook flags
  ent->owner->client->hookstate = 0;
  
  gi.sound (ent->owner, CHAN_HOOK, gi.soundindex("hook/retract.wav"), 1, 
	    ATTN_IDLE, 0);
	
  // removes hook
  G_FreeEdict (ent);

}


void MaintainLinks (edict_t *ent) {

  float  multiplier;	 // prediction multiplier
  vec3_t pred_hookpos;	 // predicted future hook origin
  vec3_t norm_hookvel;	 // normalized hook velocity
  vec3_t offset, start;
  vec3_t forward, right;
  vec3_t chainvec;	 // vector of the chain 
  vec3_t norm_chainvec;	 // vector of chain with distance of 1


  // predicts hook's future position since chain links fall behind
  multiplier = VectorLength(ent->velocity) / 22; 
  VectorNormalize2 (ent->velocity, norm_hookvel); 
  VectorMA (ent->s.origin, multiplier, norm_hookvel, pred_hookpos);
  
  // derive start point of chain
  AngleVectors (ent->owner->client->v_angle, forward, right, NULL);
  VectorSet (offset, 8, 8, ent->owner->viewheight-8);
  P_ProjectSource_Reverse (ent->owner->client, ent->owner->s.origin, offset, 
			   forward, right, start);
  
  // get info about chain
  _VectorSubtract (pred_hookpos,start,chainvec);
  VectorNormalize2 (chainvec, norm_chainvec);
  
  // shorten ends of chain
  VectorMA (start, 10, norm_chainvec, start);
  VectorMA (pred_hookpos, -20, norm_chainvec, pred_hookpos);
  
  // create temp entity chain
  gi.WriteByte (svc_temp_entity);
  gi.WriteByte (TE_MEDIC_CABLE_ATTACK);
  gi.WriteShort (ent - g_edicts);
  gi.WritePosition (pred_hookpos);
  gi.WritePosition (start);
  gi.multicast (ent->s.origin, MULTICAST_PVS);

}

void HookBehavior(edict_t *ent) {

  vec3_t offset, start;
  vec3_t forward, right;

  qboolean chain_moving;
  vec3_t chainvec;   // chain's vector
  float  chainlen;   // length of extended chain
  vec3_t velpart;    // player's velocity component moving to or away from hook
  float f1, f2;	     // restrainment forces
		

  // decide when to disconnect hook
  if ((!(ent->owner->client->hookstate & HOOK_ON)) ||
      (ent->enemy->solid == SOLID_NOT)             || 
      (ent->owner->deadflag)                       ||
      (level.modeset == ENDMATCHVOTING)            ||
      (ent->owner->s.event == EV_PLAYER_TELEPORT)) {

    DropHook(ent);
    return;

  }

  // gives hook same velocity as the entity it is stuck in
  if (ent->enemy->client) {
    
    if((ent->enemy->deadflag) || 
       (ent->enemy->s.event == EV_PLAYER_TELEPORT)) {
      
      DropHook(ent);
      return;
      
    }
    
    VectorCopy (ent->enemy->s.origin, ent->s.origin);
    ent->s.origin[2] += 8.0;
    
  } else {
    
    VectorCopy (ent->enemy->velocity, ent->velocity);
    
  }
  
  // chain sizing 
  chain_moving = false;
  
  // grow the length of the chain
  if ((ent->owner->client->hookstate & GROW_ON) && 
      (ent->angle < hook_max_length->value)) {

    ent->angle += hook_pull_speed->value;
    if (ent->angle > hook_max_length->value) 
      ent->angle = hook_max_length->value;
    chain_moving = true;

  }

  // shrink the length of the chain
  if ((ent->owner->client->hookstate & SHRINK_ON) && 
      (ent->angle > hook_min_length->value)) {

    ent->angle -= hook_pull_speed->value;
    if (ent->angle < hook_min_length->value) 
      ent->angle = hook_min_length->value;
    chain_moving = true;

  }

  // determine sound play if climbing or sliding
  if (chain_moving) {

    if (ent->sounds == MOTOR_OFF) {

      // play start of climb sound
      gi.sound (ent->owner, CHAN_HOOK, gi.soundindex("hook/motor1.wav"), 1, 
		ATTN_IDLE, 0);
      ent->sounds = MOTOR_START;

    } else if (ent->sounds == MOTOR_START) {

      // play repetitive climb sound
      gi.sound (ent->owner, CHAN_HOOK, gi.soundindex("hook/motor2.wav"), 1, 
		ATTN_IDLE, 0);
      ent->sounds = MOTOR_ON;

    }

  } else if (ent->sounds != MOTOR_OFF) {

    gi.sound (ent->owner, CHAN_HOOK, gi.soundindex("hook/motor3.wav"), 1, 
	      ATTN_IDLE, 0);
    ent->sounds = MOTOR_OFF;

  }

  // chain physics

  // derive start point of chain
  AngleVectors (ent->owner->client->v_angle, forward, right, NULL);
  VectorSet(offset, 8, 8, ent->owner->viewheight-8);
  P_ProjectSource_Reverse (ent->owner->client, ent->owner->s.origin, offset, 
			   forward, right, start);

  // get info about chain
  _VectorSubtract (ent->s.origin, start, chainvec);
  chainlen = VectorLength (chainvec);
  
  // if player's location is beyond the chain's reach
  if (chainlen > ent->angle) {	 

    // determine player's velocity component of chain vector
    VectorScale (chainvec, _DotProduct (ent->owner->velocity, chainvec) / 
		 _DotProduct (chainvec, chainvec), velpart);
		
    // restrainment default force 
    f2 = (chainlen - ent->angle) * 5;

    // if player's velocity heading is away from the hook
    if (_DotProduct (ent->owner->velocity, chainvec) < 0) {

      // if chain has streched for 25 units
      if (chainlen > ent->angle + 25) {

	// remove player's velocity component moving away from hook
	_VectorSubtract(ent->owner->velocity, velpart, ent->owner->velocity);

      }

      f1 = f2;

    } else {

      // if player's velocity heading is towards the hook	      
      if (VectorLength (velpart) < f2)
	f1 = f2 - VectorLength (velpart);
      else		
	f1 = 0;
    }

  } else {

    f1 = 0;

  }
  
  // applys chain restrainment 
  VectorNormalize (chainvec);
  
  if(ent->enemy->client) {

    if(ent->owner->groundentity) {
      
      VectorMA (ent->enemy->velocity, -f1, chainvec, 
		ent->enemy->velocity);
      
    } else {
      
      f1 /= 2.0;
      
      VectorMA (ent->enemy->velocity, -f1, chainvec,
		ent->enemy->velocity);
      VectorMA (ent->owner->velocity,  f1, chainvec,
		ent->owner->velocity);
      
    }
    
    // vampire hook stuff
    if(((level.time - ent->owner->client->hook_vampire_time) >= 1.0) && 
       hook_vampirism->value) {

      ent->owner->client->hook_vampire_time = level.time;

      if(hook_vampirism->value > 0) {
	
	ent->owner->health += hook_vampirism->value * hook_vampire_ratio->value;
	
	if((ent->enemy->health -= hook_vampirism->value) <= 0) {
	  
	  T_Damage (ent->enemy, ent, ent->owner, ent->velocity, 
		    ent->s.origin, chainvec, hook_vampirism->value, 0, 
		    DAMAGE_NO_KNOCKBACK, MOD_HOOK_VAMPIRE1);
	}
	
      } else {
	
	ent->enemy->health -= 
	  hook_vampirism->value * hook_vampire_ratio->value;
	
	if((ent->owner->health += hook_vampirism->value) <= 0) {
	  
	  T_Damage (ent->owner, ent, ent->enemy, ent->velocity, 
		    ent->s.origin, chainvec, -(hook_vampirism->value), 0, 
		    DAMAGE_NO_KNOCKBACK, MOD_HOOK_VAMPIRE2);
	  
	}
	
      }

    }

  } else {
    
    VectorMA (ent->owner->velocity, f1, chainvec, ent->owner->velocity);
    
  }
  
  MaintainLinks (ent);
  
  // prep for next think
  ent->nextthink = level.time + FRAMETIME;

}


void HookTouch (edict_t *ent, edict_t *other, cplane_t *plane, 
		csurface_t *surf) {

  vec3_t offset, start;
  vec3_t forward, right;
  vec3_t chainvec;	  // chain's vector


  // derive start point of chain
  AngleVectors (ent->owner->client->v_angle, forward, right, NULL);
  VectorSet(offset, 8, 8, ent->owner->viewheight-8);
  P_ProjectSource_Reverse (ent->owner->client, ent->owner->s.origin, offset, 
			   forward, right, start);
  
  // member angle is used to store the length of the chain
  _VectorSubtract(ent->s.origin,start,chainvec);
  ent->angle = VectorLength (chainvec);	

  // don't attach hook to sky
  if(!hook_sky->value && (surf && (surf->flags & SURF_SKY))) {
    
    DropHook(ent);
    return;
    
  }

  // inflict damage on damageable items
  if (other->takedamage) {

    T_Damage (other, ent, ent->owner, ent->velocity, ent->s.origin,plane->normal, ent->dmg, 100, 0, MOD_HOOK_DAMAGE1);

  }

  if ((other->solid == SOLID_BBOX)) {

    if ((other->svflags & SVF_MONSTER) || (other->client)) {

      gi.sound (ent, CHAN_VOICE, gi.soundindex("hook/smack.wav"), 1, 
		ATTN_IDLE, 0);

      ent->owner->client->hook_vampire_time = level.time;
      
      if(other->client && hook_messages->value && hook_players->value) {
	
	safe_centerprintf(other, "%s has hooked you!", 
			ent->owner->client->pers.netname);
	safe_centerprintf(ent->owner, "You've hooked %s!", 
			other->client->pers.netname);

      }
      
    }
    
    if(!(other->client && hook_players->value)) {

      DropHook(ent);
      return;

    }

  }
	
  if(other->client) {
    
    ent->solid = SOLID_NOT; // so that it does not interfere with 
                            // other's movements

  }

  if (other->solid == SOLID_BSP) {

    // create puff of smoke
    gi.WriteByte (svc_temp_entity);
    gi.WriteByte (TE_SHOTGUN);
    gi.WritePosition (ent->s.origin);

    if (!plane)
      gi.WriteDir (vec3_origin);
    else
      gi.WriteDir (plane->normal);

    gi.multicast (ent->s.origin, MULTICAST_PVS);
    gi.sound (ent, CHAN_VOICE, gi.soundindex("hook/hit.wav"), 1, ATTN_IDLE, 0);
    VectorClear (ent->avelocity);

  } else if (other->solid == SOLID_TRIGGER) {

    // debugging line; don't know if this will ever happen 
    safe_cprintf (ent->owner, PRINT_HIGH, "Hook touched a SOLID_TRIGGER\n");

  }
	
  // hook gets the same velocity as the item it attached to
  VectorCopy (other->velocity,ent->velocity);

  // flags hook as being attached to something
  ent->owner->client->hookstate |= HOOK_IN;
  
  ent->enemy = other;
  ent->touch = NULL;
  ent->think = HookBehavior;
  ent->nextthink = level.time + FRAMETIME;

}


void HookAirborne (edict_t *ent) {

  vec3_t chainvec;	// chain's vector
  float chainlen;	// length of extended chain
  
  edict_t *target = NULL; // the homee ;)
  edict_t *blip = NULL;   // potential homee
  vec3_t   targetdir, blipdir;
  vec_t    speed;
  
  
  // get info about chain
  _VectorSubtract (ent->s.origin, ent->owner->s.origin, chainvec);
  chainlen = VectorLength (chainvec);
  
  // check to see if we're at the end of our rope
  if ( (!(ent->owner->client->hookstate & HOOK_ON)) || 
       (chainlen > hook_max_length->value) ) {
    
    DropHook(ent);
    return;
    
  }
  
  MaintainLinks (ent);	
  
  if(hook_is_homing->value && hook_players->value) {
    
    // make the hook "homing"
    while ((blip = findradius(blip, ent->s.origin, 
			      hook_homing_radius->value)) != NULL) {
      
      if (!(blip->svflags & SVF_MONSTER) && !blip->client)
	continue;
      if (blip == ent->owner)
	continue;
      if (!blip->takedamage)
	continue;
      if (blip->health <= 0)
	continue;
      if (!visible(ent, blip))
	continue;
      if (!infront(ent, blip))
	continue;
      if (!infront(ent->owner, blip))
	continue;
      
      VectorSubtract(blip->s.origin, ent->s.origin, blipdir);
      blipdir[2] += 16.0;
      
      if((target == NULL) || 
	 (VectorLength(blipdir) < VectorLength(targetdir))) {
	
	target = blip;
	VectorCopy(blipdir, targetdir);
	
      }
      
    }
    
    if(target != NULL) {
      
      VectorNormalize(targetdir);
      VectorScale(targetdir, hook_homing_factor->value, targetdir);
      VectorAdd(targetdir, ent->movedir, targetdir);
      VectorNormalize(targetdir);
      VectorCopy(targetdir, ent->movedir);
      vectoangles(targetdir, ent->s.angles);
      speed = VectorLength(ent->velocity);
      VectorScale(targetdir, speed, ent->velocity);
      
    }
    
  }
  // end homing hook
  
  ent->nextthink = level.time + FRAMETIME;
  
}


void FireHook (edict_t *ent) {

  edict_t *newhook;
  vec3_t   offset, start;
  vec3_t   forward, right;
  int	   damage;

  if (ent->solid == SOLID_NOT)
	return;

  if (ent->deadflag) 
     return;

  if (ent->movetype == MOVETYPE_NOCLIP)
    return;
  // determine the damage the hook will inflict
  damage = 10;
  if (ent->client->quad_framenum > level.framenum)
    damage *= 4;
	
  // derive point of hook origin
  AngleVectors (ent->client->v_angle, forward, right, NULL);
  VectorSet(offset, 8, 8, ent->viewheight-8);
  P_ProjectSource_Reverse (ent->client, ent->s.origin, offset, forward, 
			   right, start);

  // spawn hook
  newhook = G_Spawn();
  VectorCopy (start, newhook->s.origin);
  VectorCopy (forward, newhook->movedir);
  vectoangles (forward, newhook->s.angles);
  VectorScale (forward, hook_fire_speed->value, newhook->velocity);
  VectorSet(newhook->avelocity,0,0,-800);
  newhook->movetype = MOVETYPE_FLYMISSILE;
  newhook->clipmask = MASK_SHOT;
  newhook->solid = SOLID_BBOX;
  VectorClear (newhook->mins);
  VectorClear (newhook->maxs);
  newhook->s.modelindex = gi.modelindex ("models/items/hook/tris.md2");
  newhook->owner = ent;
  newhook->dmg = damage;

  // keeps track of motor chain sound played 
  newhook->sounds = 0;   
  
  // play hook launching sound
  gi.sound (ent, CHAN_HOOK, gi.soundindex ("medic/medatck2.wav"), 1, 
	    ATTN_IDLE, 0);
	
  // specify actions to follow 
  newhook->touch = HookTouch;
  newhook->think = HookAirborne;
  newhook->nextthink = level.time + FRAMETIME;
  
  gi.linkentity (newhook);

}


void Cmd_Hook1_f (edict_t *ent) {

  char *s;
  int *hookstate;


    if (ent->movetype == MOVETYPE_NOCLIP)
    return;


	if (CustHook != 1){
	    safe_centerprintf (ent, "Admin Has The Hook Disabled!!!\n");
        return;
	}

    else
	if (CustHook == 1){

  // get the first hook argument
  s = gi.argv(1);
  
  // create intermediate value
  hookstate = &ent->client->hookstate;
  
  if ((!(*hookstate & HOOK_ON)) && (Q_stricmp(s, "action") == 0)) {
    
    // flags hook as being active 
    *hookstate = HOOK_ON;    
    FireHook (ent);
    return;

  }

  if  (*hookstate & HOOK_ON) {

    // release hook	
    if (Q_stricmp(s, "action") == 0) {

      *hookstate = 0;
      return;

    }

    // deactivate chain growth or shrink
    if (Q_stricmp(s, "stop") == 0) {

      *hookstate -= *hookstate & (GROW_ON | SHRINK_ON);
      return;

    }

    // activate chain growth
    if (Q_stricmp(s, "grow") == 0) {

      *hookstate |= GROW_ON;
      *hookstate -= *hookstate & SHRINK_ON;
      return;

    }

    // activate chain shrinking
    if (Q_stricmp(s, "shrink") == 0) {

      *hookstate |= SHRINK_ON;		
      *hookstate -= *hookstate & GROW_ON;
    }

  }

 }
}
