/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) 
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington

//
//	I, Ernest Buffington, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// ai_shorty.c shorty clone of the punk
// 

#include "g_local.h"
#include "ai_shorty.h"

#include "voice_punk.h"

void shorty_end_stand( edict_t *self );
void shorty_firehmg (edict_t *self);
void shorty_firegun( edict_t *self );
void shorty_firegun_left( edict_t *self );
void shorty_firegun_right( edict_t *self );
void shorty_talk_think( edict_t *self );
void think_playthud( edict_t *self );
void shorty_firegun_cr (edict_t *self);
void shorty_shotgun_reload( edict_t *self );
void shorty_reload_snd (edict_t *self);
void shorty_firehmg_delay (edict_t *self);
void shorty_hmg_avoid (edict_t *self);
void shorty_bazooka_delay (edict_t *self);

#include "ai_shorty_tables.h"

int ThugSitCash;
int ThugCash;
int SpiderCash;
int ShortyCash;
int RuntCash;
int PunkCash;
int MummyCash;
int BumSitCash;
int BitchCash;

#define SHORTY_FLAMEGUN		4
#define	SHORTY_BAZOOKA		8
#define SHORTY_HMG			16
#define	SHORTY_TOMMYGUN		64	// spawnflag
#define SHORTY_GRENADE		128
#define SHORTY_SHOTGUN		8192

int	tommy_soundindex;
int	shotgun_soundindex;
int	shotgun_reload_soundindex;
int	heavymachinegun_soundindex;
int	rocketgun_soundindex;

void Cmd_Shorty_f (edict_t *self, char *secondword)
{

}

void shorty_respawn(edict_t *self)
{

//  level.num_shortyloads++;

}

void shorty_reload_snd (edict_t *self)
{
	if (self->spawnflags & SHORTY_TOMMYGUN)
		gi.sound(self, CHAN_VOICE, gi.soundindex("weapons/machinegun/machgcock.wav"), 1, ATTN_NORM, 0);
	else if (self->spawnflags &	SHORTY_HMG)
		gi.sound(self, CHAN_VOICE, gi.soundindex("weapons/machinegun/machgcock.wav"), 1, ATTN_NORM, 0);
	else if (self->spawnflags & SHORTY_BAZOOKA)
		gi.sound(self, CHAN_VOICE, gi.soundindex("weapons/rocket_launcher/reload.wav"), 1, ATTN_NORM, 0);
	else if (self->spawnflags & SHORTY_GRENADE)
		gi.sound(self, CHAN_VOICE, gi.soundindex("weapons/grenade_launcher/reload.wav"), 1, ATTN_NORM, 0);
}

void shorty_catch_fire( edict_t *self, edict_t *other )
{
	self->enemy = NULL;		// stop attacking
	self->cast_info.currentmove = &shorty_move_run_on_fire;
}

void shorty_talk_think( edict_t *self )
{
	AI_TalkThink( self, true );
}

void shorty_talk( edict_t *self )
{
	float rnd;

	rnd = random() * 7;

	// only make talking jester if we've recently said something
	if (!(self->cast_info.aiflags & AI_REPEAT_TALK_JESTURE) && self->last_talk_time < (level.time - 1.0))
	{
		self->cast_info.currentmove = self->cast_info.move_stand;
		return;
	}

	if (self->cast_info.currentmove != self->cast_info.move_stand)
		return;

	if (rnd < 1)
		self->cast_info.currentmove = &shorty_move_talk1;
	else if (rnd < 2)
		self->cast_info.currentmove = &shorty_move_talk2;
	else if (rnd < 3)
		self->cast_info.currentmove = &shorty_move_talk3;
	else if (rnd < 4)
		self->cast_info.currentmove = &shorty_move_talk4;
	else if (rnd < 5)
		self->cast_info.currentmove = &shorty_move_talk5;
	else if (rnd < 6)
		self->cast_info.currentmove = &shorty_move_talk6;
	else
		self->cast_info.currentmove = &shorty_move_talk7;
	
}

void shorty_avoid ( edict_t *self, edict_t *other, qboolean face )
{
	vec3_t	vec;


	if (self->health <= 0)
		return;

	if (!self->groundentity)
		return;

	if (!other)
	{
		self->cast_info.currentmove = self->cast_info.move_stand;
		return;
	}

	self->cast_info.last_avoid = level.time;
	self->cast_info.avoid_ent = NULL;

	if (face)
	{	// turn to face them
		VectorSubtract( other->s.origin, self->s.origin, vec );
		self->cast_info.avoid_ent = other;
	}
	else
	{	// turn to face away from them
		VectorSubtract( self->s.origin, other->s.origin, vec );
	}
	VectorNormalize( vec );

	self->ideal_yaw = vectoyaw( vec );

	if (self->maxs[2] > DUCKING_MAX_Z)
	{
		if (self->cast_info.aiflags & AI_NOWALK_FACE)
		{
//			if (face)
			{
				int		side_result;

				side_result = AI_SideTrace( self, 48, 90, SIDE_RANDOM );

				if (side_result == AI_SideTrace( self, 48, 90 + (self->ideal_yaw - self->s.angles[YAW]), side_result ))
				{
					if (side_result < 0)
						self->cast_info.currentmove = &shorty_move_lside_step;
					else
						self->cast_info.currentmove = &shorty_move_rside_step;

					return;
				}

				// if no move set, just turn to face
				M_ChangeYaw( self );

				return;
			}
		}

		if ((VectorDistance( self->s.origin, other->s.origin ) > 72) || !face)
		{
			if (self->moral > 4)
				self->cast_info.currentmove = &shorty_move_avoid_walk;
			else
				self->cast_info.currentmove = &shorty_move_avoid_run;
		}
		else
		{
			if (self->moral > 4)
				self->cast_info.currentmove = &shorty_move_avoid_reverse_walk;
			else
				self->cast_info.currentmove = &shorty_move_avoid_reverse_run;
		}
	}
	else
	{
		self->cast_info.currentmove = &shorty_move_avoid_crouch_walk;
	}

}

void shorty_end_stand( edict_t *self )
{
	if (self->cast_info.move_stand_evade && (self->last_stand_evade > (level.time - 3)))
		return;

	if (self->cast_info.currentmove == self->cast_info.move_crstand)
		return;

//	if (	((!self->cast_group) && (random() < 0.8))
//		||	((self->cast_group) && (random() < 0.3)))
	{	// stand normally

		if (	(self->cast_info.currentmove != &shorty_move_talk7)
			&&	(random() < 0.3) && self->spawnflags & SHORTY_TOMMYGUN)
		{	// randomly wipe our face
			self->cast_info.currentmove = &shorty_move_talk7;
		}
		else
		{
			self->cast_info.currentmove = self->cast_info.move_stand;
		}

//		return;
	}

	AI_CheckTalk(self);
}

void shorty_long_attack( edict_t *self )
{
	// keep running, and try to fire if possible

	if (self->maxs[2] < self->cast_info.standing_max_z)
		return;

	// self->cast_info.currentmove = &shorty_move_run_shoot;
	
	if (self->spawnflags & SHORTY_TOMMYGUN)
		self->cast_info.currentmove = &shorty_move_run_tg_sht;
	else if (self->spawnflags & SHORTY_SHOTGUN)
		self->cast_info.currentmove = &shorty_move_run_shg_sht;
	else if (self->spawnflags & SHORTY_HMG)
		self->cast_info.currentmove = &shorty_move_run_hmg_sht;
	else if (self->spawnflags & SHORTY_BAZOOKA)
		self->cast_info.currentmove = &shorty_move_run_bazooka_sht;
	else if (self->spawnflags & SHORTY_FLAMEGUN)
		self->cast_info.currentmove = &shorty_move_run_flamegun_sht;
	else if (self->spawnflags & SHORTY_GRENADE)
		self->cast_info.currentmove = &shorty_move_run_grenade_sht;
	else
	{
		gi.dprintf ("actor is missing weapon spawnflag\n");
		self->cast_info.currentmove = &shorty_move_run_shg_sht;
	}
}

qboolean shorty_attack( edict_t *self )
{

	if (self->maxs[2] < self->cast_info.standing_max_z)
	{
		self->cast_info.currentmove = &shorty_move_crouch_shoot;
		return true;
	}
	else
	{
		vec3_t	vec;
		float dist;


		VectorSubtract( self->enemy->s.origin, self->s.origin, vec );
		dist = VectorNormalize( vec );

		// Special case: enemy has flamethrower, run backwards, keep firing
		if (	(dist < 384)				// they're close
			&&	(self->spawnflags & SHORTY_TOMMYGUN)
			&&	(self->enemy->client)
			&&	(self->enemy->client->pers.weapon)
			&&	(Q_stricmp(self->enemy->client->pers.weapon->classname, "weapon_flamethrower") == 0))
		{
			int		side_result;

			// see if we can go backwards
			if (side_result = AI_SideTrace( self, -64, 0, 1 ))
			{
				self->cast_info.currentmove = &shorty_move_run_reverse_tg_sht;
				return true;
			}

		}

		// if just popped out from a corner, just stand here
		if (self->dont_takecover_time > (level.time - 2))
		{
			goto stand_shoot;
		}


		if ((skill->value > random()*2) && (self->cast_info.last_side_attack_time < (level.time - 1)) && (dist > 128))
		{
			// attempt a side-ways attack

			int		side_result, side_result2;

			side_result = AI_SideTrace( self, 64, 90, -self->cast_info.last_side_attack );

			if (side_result)
			{
				side_result2 = AI_SideTrace( self, 128, 90, side_result );

				if (side_result2 == side_result)
				{
					/*
					if (side_result < 0)
						self->cast_info.currentmove = &shorty_move_lside_run;
					else
						self->cast_info.currentmove = &shorty_move_rside_run;
					*/
					if (side_result < 0)
					{
						if (self->spawnflags & SHORTY_TOMMYGUN)
							self->cast_info.currentmove = &shorty_move_lsd_tg_run;
						else if (self->spawnflags & SHORTY_SHOTGUN)
							self->cast_info.currentmove = &shorty_move_lsd_shg_run;
						else if (self->spawnflags & SHORTY_HMG)
							// self->cast_info.currentmove = &shorty_move_lsd_hmg_run;
							self->cast_info.currentmove = &shorty_move_walk_hmg_sht;
						else if (self->spawnflags & SHORTY_BAZOOKA)
							self->cast_info.currentmove = &shorty_move_lsd_bazooka_run;
						else if (self->spawnflags & SHORTY_FLAMEGUN)
							self->cast_info.currentmove = &shorty_move_lsd_flamegun_run;
						else if (self->spawnflags & SHORTY_GRENADE)
							self->cast_info.currentmove = &shorty_move_lsd_grenade_run;
						else
						{
							gi.dprintf ("missing weapon spawnflag\n");
							self->cast_info.currentmove = &shorty_move_lsd_shg_run;
						}
					}
					else
					{
						if (self->spawnflags & SHORTY_TOMMYGUN)
							self->cast_info.currentmove = &shorty_move_rsd_tg_run;
						else if (self->spawnflags & SHORTY_SHOTGUN)
							self->cast_info.currentmove = &shorty_move_rsd_shg_run;
						else if (self->spawnflags & SHORTY_HMG)
							// self->cast_info.currentmove = &shorty_move_rsd_hmg_run;
							self->cast_info.currentmove = &shorty_move_walk_hmg_sht;
						else if (self->spawnflags & SHORTY_BAZOOKA)
							self->cast_info.currentmove = &shorty_move_rsd_bazooka_run;
						else if (self->spawnflags & SHORTY_FLAMEGUN)
							self->cast_info.currentmove = &shorty_move_rsd_flamegun_run;
						else if (self->spawnflags & SHORTY_GRENADE)
							self->cast_info.currentmove = &shorty_move_rsd_grenade_run;
						else
						{
							gi.dprintf ("missing weapon spawnflag\n");
						}
					}


					self->ideal_yaw = vectoyaw(vec) + side_result * 90;

					M_ChangeYaw( self );

					self->cast_info.last_side_attack = side_result;
					self->cast_info.last_side_attack_time = level.time;

					return true;
				}
			}

		}

		self->ideal_yaw = vectoyaw(vec);

		M_ChangeYaw( self );

		// just shoot like normal

		// walk shooting?
		if ((dist > 256) && directly_infront( self, self->enemy ) && AI_SideTrace(self, 32, 0, 1 ) )
		{
			if (self->spawnflags & SHORTY_TOMMYGUN)
				self->cast_info.currentmove = &shorty_move_walk_tg_sht;
			else if (self->spawnflags & SHORTY_HMG)
				self->cast_info.currentmove = &shorty_move_walk_hmg_sht;
			else if (self->spawnflags & SHORTY_BAZOOKA)
				self->cast_info.currentmove = &shorty_move_walk_bazooka_sht;
			else if (self->spawnflags & SHORTY_FLAMEGUN)
				self->cast_info.currentmove = &shorty_move_walk_flamegun_sht;
			else if (self->spawnflags & SHORTY_GRENADE)
				self->cast_info.currentmove = &shorty_move_walk_grenade_sht;
			else if (self->spawnflags & SHORTY_SHOTGUN)
			{
				if (dist > 800)	// shotgun dude should get closer
					self->cast_info.currentmove = &shorty_move_walk_shg_sht;
				else
					self->cast_info.currentmove = &shorty_move_run_shg_sht;
			}

			return true;
		}
/* TODO: Reverse walking anim table
		else if ((dist < 128) && AI_SideTrace(self, -32, 0, 1 ) )
		{
			self->cast_info.currentmove = &thug_move_reverse_walk_shoot;
			return true;
		}
*/
		// normal attack

stand_shoot:

		self->ideal_yaw = vectoyaw(vec);

		M_ChangeYaw( self );

		if (self->spawnflags & SHORTY_TOMMYGUN)
			self->cast_info.currentmove = &shorty_move_tg_shoot;
		else if (self->spawnflags & SHORTY_SHOTGUN)
			self->cast_info.currentmove = &shorty_move_shg_shoot;
		else if (self->spawnflags & SHORTY_HMG)
			self->cast_info.currentmove = &shorty_move_hmg_shoot;
		else if (self->spawnflags & SHORTY_BAZOOKA)
			self->cast_info.currentmove = &shorty_move_bazooka_shoot;
		else if (self->spawnflags & SHORTY_FLAMEGUN)
			self->cast_info.currentmove = &shorty_move_flamegun_shoot;
		else if (self->spawnflags & SHORTY_GRENADE)
			self->cast_info.currentmove = &shorty_move_grenade_shoot;
		else
		{
			gi.dprintf ("missing weapon spawnflag\n");
			self->cast_info.currentmove = &shorty_move_shg_shoot;
		}

		return true;
	}

	return false;
}

void shorty_firegun_cr ( edict_t *self )
{
	if (self->spawnflags & SHORTY_SHOTGUN)
		return;
	else if (self->spawnflags & SHORTY_HMG)
		return;
	else if (self->spawnflags & SHORTY_BAZOOKA)
		return;
	else if (self->spawnflags &	SHORTY_FLAMEGUN)
		return;
	else if (self->spawnflags & SHORTY_GRENADE)
		return;
	else if (self->spawnflags & SHORTY_TOMMYGUN)
		shorty_firegun (self);
	else
		gi.dprintf ("error : not tagged right!\n");
}

void shorty_hmg_avoid (edict_t *self)
{
	if (self->name_index == NAME_HEILMAN)
	{
		self->cast_info.avoid(self, self->enemy, true);
	}
	else if (self->s.frame == FRAME_tg_shoot_07)
		self->cast_info.avoid(self, self->enemy, true);
	else
		self->cast_info.avoid(self, self->enemy, false);
}

void shorty_firehmg_delay (edict_t *self)
{

	if (self->name_index == NAME_HEILMAN)
		return;

	if (self->s.frame == FRAME_tg_shoot_07)
		self->cast_info.currentmove = &shorty_move_hmg_shoot2;
	else if (self->s.frame == FRAME_walk_tg_sht_10)
		self->cast_info.currentmove = &shorty_move_walk_hmg_sht2;
	else
		self->cast_info.currentmove = &shorty_move_run_hmg_sht2;
}

void shorty_bazooka_delay (edict_t *self)
{
	if (self->s.frame == FRAME_tg_shoot_07)
		self->cast_info.currentmove = &shorty_move_bazooka_shoot2;
	else if (self->s.frame == FRAME_walk_tg_sht_10)
		self->cast_info.currentmove = &shorty_move_walk_bazooka_shoot2;
	else
		self->cast_info.currentmove = &shorty_move_run_bazooka_shoot2;
}

void shorty_firehmg( edict_t *self )
{

	vec3_t	start;
	vec3_t	forward, right;
	vec3_t	target;
	vec3_t	aim;
	vec3_t	offset;
	int		flash_number;
	float	dist;
	int     damage = 15;

	if(self->cal) damage = self->cal;
	if(self->dmg) damage = self->dmg;

	if (!AI_BeginAttack( self ))
	{
		// self->s.frame++;		// skip the firing frame since it might have a muzzle flash
		self->cast_info.currentmove = self->cast_info.move_stand;
		
		// may need to hack this
		// self->s.frame == standframe;
		return;
	}
	
	/*
	if (self->durationflag)
	{
		self->durationflag++;
		if (self->durationflag > 6)
			self->durationflag = 0;
		self->s.frame++;
		return;
	}

	if (self->lastduration++ > 2)
		self->lastduration = 0;
	*/

	if (self->duration++ > 30)
	{
		self->duration = 0;
		self->cast_info.currentmove = &shorty_move_tg_reload;
		self->s.frame++;		// skip the firing frame since it might have a muzzle flash
		return;
	}
		
	// yell at them?
	if (self->last_talk_time < (level.time - TALK_FIGHTING_DELAY))
	{
		if (self->name_index == NAME_HEILMAN)
		{
			Voice_Random (self, self->enemy, &heilman[6], 11);
		}
		else if (self->cast_group != 1)
		{
			Voice_Random(self, self->enemy, fightsounds, NUM_FIGHTING);
		}
		else
			Voice_Random(self, self->enemy, friendlycombat, NUM_FRIENDLYCOMBAT );
	}

	{
		VectorSet(offset, 0, 8,  self->viewheight-8);

		AngleVectors (self->s.angles, forward, right, NULL);
		G_ProjectSource (self->s.origin, offset, forward, right, start);

		// project enemy back a bit and target there
		VectorCopy (self->enemy->s.origin, target);
		VectorMA (target, (-0.5 * (crandom())) * (1.0 - (skill->value/4.0)), self->enemy->velocity, target);

		if (self->enemy->maxs[2] < self->cast_info.standing_max_z)
			target[2] += - ( 8 * random());
		else
			target[2] += self->enemy->viewheight - 4 - (16 * random());

		flash_number = MZ2_GUNNER_MACHINEGUN_1;

		VectorSubtract (target, start, aim);
		dist = VectorNormalize (aim);
	}

#if 0	
	// look for a new attack?
	if (	(dist < self->cast_info.max_attack_distance)
		&&	(	((random() < 0.1) && (self->cast_info.last_side_attack_time < (level.time - 2)))
			 ||	(	(!(self->cast_info.aiflags & AI_SIDE_ATTACK) || (self->cast_info.last_side_attack_time < (level.time - 2)))
				 &&	(directly_infront( self->enemy, self))
				 &&	(self->enemy->client)
				 &&	(self->enemy->client->pers.weapon)
				 &&	(self->enemy->client->pers.weapon->ammo))))		// if we are directly infront of them, try to strafe
	{
		if (self->cast_info.aiflags & AI_SIDE_ATTACK)
		{
			// self->cast_info.currentmove = &shorty_move_shoot;
			if (self->spawnflags & SHORTY_TOMMYGUN)
				self->cast_info.currentmove = &shorty_move_run_tg_sht;
			else if (self->spawnflags & SHORTY_SHOTGUN)
				self->cast_info.currentmove = &shorty_move_run_shg_sht;
			else if (self->spawnflags & SHORTY_HMG)
				self->cast_info.currentmove = &shorty_move_run_hmg_sht;
			else if (self->spawnflags & SHORTY_BAZOOKA)
				self->cast_info.currentmove = &shorty_move_run_bazooka_sht;
			else if (self->spawnflags & SHORTY_FLAMEGUN)
				self->cast_info.currentmove = &shorty_move_run_flamegun_sht;
			else if (self->spawnflags & SHORTY_GRENADE)
				self->cast_info.currentmove = &shorty_move_run_grenade_sht;
			else
			{
				gi.dprintf ("missing weapon spawnflag\n");
				self->cast_info.currentmove = &shorty_move_run_shg_sht;
			}
		}
		else
			self->cast_info.attack( self );
	}
#endif

	self->ideal_yaw = vectoyaw( aim );

	{
		fire_bullet (self, start, aim, damage, 50, DEFAULT_BULLET_HSPREAD>>self->acc, DEFAULT_BULLET_VSPREAD>>self->acc, MOD_BARMACHINEGUN);
		{
			if (self->s.frame == FRAME_tg_shoot_01
				|| self->s.frame == FRAME_walk_tg_sht_01
				|| self->s.frame == FRAME_run_tg_sht_01)
			{
				gi.sound(self, CHAN_WEAPON, gi.soundindex("weapons/hmg/hmg.wav"), 1, ATTN_NORM, 0);
			}
		}
	}
	
};

void shorty_firegun( edict_t *self )
{
	vec3_t	start;
	vec3_t	forward, right;
	vec3_t	target;
	vec3_t	aim;
	vec3_t	offset;
	int		flash_number;
	float	dist;
	int     damage = 6;

	if(self->cal) damage = self->cal;
	if(self->dmg) damage = self->dmg;

	if (self->cast_info.aiflags & AI_RELOAD)
	{	// we need to reload first, just do it now (since it's a similar motion)
		shorty_shotgun_reload( self );
		self->s.frame++;		// skip the firing frame since it might have a muzzle flash
		return;
	}

	if (self->spawnflags & SHORTY_TOMMYGUN)
	{
		if (	(self->maxs[2] == self->cast_info.standing_max_z)
			&&	!(self->cast_info.aiflags & AI_SIDE_ATTACK)
			&&	(self->duration++ > 40))
		{

				self->duration = 0;
				self->cast_info.currentmove = &shorty_move_tg_reload;
				self->s.frame++;		// skip the firing frame since it might have a muzzle flash
				return;
		}
	}
	else if (self->spawnflags & SHORTY_BAZOOKA)
	{
		if (	(self->maxs[2] == self->cast_info.standing_max_z)
			&&	!(self->cast_info.aiflags & AI_SIDE_ATTACK)
			&&	(self->duration++ > 3))
		{

				self->duration = 0;
				self->cast_info.currentmove = &shorty_move_tg_reload;
				self->s.frame++;		// skip the firing frame since it might have a muzzle flash
				return;
		}
	}
	else if (self->spawnflags & SHORTY_GRENADE)
	{
		if (	(self->maxs[2] == self->cast_info.standing_max_z)
			&&	!(self->cast_info.aiflags & AI_SIDE_ATTACK)
			&&	(self->duration++ > 2))
		{

				self->duration = 0;
				self->cast_info.currentmove = &shorty_move_tg_reload;
				self->s.frame++;		// skip the firing frame since it might have a muzzle flash
				return;
		}
	}


	if (!AI_BeginAttack( self ))
	{
		self->s.frame++;		// skip the firing frame since it might have a muzzle flash
		return;
	}

	// yell at them?
	if (self->last_talk_time < (level.time - TALK_FIGHTING_DELAY))
	{
		if (self->name_index == NAME_HEILMAN)
		{
			Voice_Random (self, self->enemy, &heilman[6], 11);
		}
		else if (self->cast_group != 1)
			Voice_Random(self, self->enemy, fightsounds, NUM_FIGHTING);
		else
			Voice_Random(self, self->enemy, friendlycombat, NUM_FRIENDLYCOMBAT );
	}

	// fire the gun
	if (self->spawnflags & SHORTY_BAZOOKA)
	{
		VectorSet(offset, 0, 8,  self->viewheight-8);

		AngleVectors (self->s.angles, forward, right, NULL);
		G_ProjectSource (self->s.origin, offset, forward, right, start);

		// project enemy back a bit and target there
		VectorCopy (self->enemy->s.origin, target);
		
		target[2] -= 24; // this will help create more splash damage

		VectorMA (target, (-0.5 * (crandom())) * (1.0 - (skill->value/4.0)), self->enemy->velocity, target);

		if (self->enemy->maxs[2] < self->cast_info.standing_max_z)
			target[2] += - ( 8 * random());
		else
			target[2] += self->enemy->viewheight - 4 - (16 * random());

		flash_number = MZ2_GUNNER_MACHINEGUN_1;

		VectorSubtract (target, start, aim);
		dist = VectorNormalize (aim);

		// idiot check
		{
			// clean shot???
			trace_t tr;
			vec3_t mins;
			vec3_t maxs;
			vec3_t origin;
			vec3_t destination;

			VectorCopy (self->s.origin, origin);
			origin[2] += self->viewheight;

			VectorCopy (self->enemy->s.origin, destination);
			destination[2] += self->enemy->viewheight;

			VectorSet (mins, -8, -8, -8);
			VectorSet (maxs,  8,  8,  8);
			
			tr = gi.trace (origin, mins, maxs, destination, self, MASK_SHOT);

			if (tr.ent != self->enemy)
			{
				if (!(AI_ForceTakeCover( self, self->enemy, false )))
				{
					self->cast_info.avoid(self, self->enemy, false);
				}
				
				if (self->duration)
					self->duration--;

				return;
			}
			goto skipbail; // causes bazooka dude to shoot twice
		}
	}
	else
	{
		VectorSet(offset, 0, 8,  self->viewheight-8);

		AngleVectors (self->s.angles, forward, right, NULL);
		G_ProjectSource (self->s.origin, offset, forward, right, start);

		// project enemy back a bit and target there
		VectorCopy (self->enemy->s.origin, target);
		VectorMA (target, (-0.5 * (crandom())) * (1.0 - (skill->value/4.0)), self->enemy->velocity, target);

		if (self->enemy->maxs[2] < self->cast_info.standing_max_z)
			target[2] += - ( 8 * random());
		else
			target[2] += self->enemy->viewheight - 4 - (16 * random());

		flash_number = MZ2_GUNNER_MACHINEGUN_1;

		VectorSubtract (target, start, aim);
		dist = VectorNormalize (aim);
	}
	
	// look for a new attack?
	if (	(dist < self->cast_info.max_attack_distance)
		&&	(	((random() < 0.1) && (self->cast_info.last_side_attack_time < (level.time - 2)))
			 ||	(	(!(self->cast_info.aiflags & AI_SIDE_ATTACK) || (self->cast_info.last_side_attack_time < (level.time - 2)))
				 &&	(directly_infront( self->enemy, self))
				 &&	(self->enemy->client)
				 &&	(self->enemy->client->pers.weapon)
				 &&	(self->enemy->client->pers.weapon->ammo))))		// if we are directly infront of them, try to strafe
	{
		if (self->cast_info.aiflags & AI_SIDE_ATTACK)
		{
			// self->cast_info.currentmove = &shorty_move_shoot;
			if (self->spawnflags & SHORTY_TOMMYGUN)
				self->cast_info.currentmove = &shorty_move_run_tg_sht;
			else if (self->spawnflags & SHORTY_SHOTGUN)
				self->cast_info.currentmove = &shorty_move_run_shg_sht;
			else if (self->spawnflags & SHORTY_BAZOOKA)
				self->cast_info.currentmove = &shorty_move_run_bazooka_sht;
			else if (self->spawnflags & SHORTY_FLAMEGUN)
				self->cast_info.currentmove = &shorty_move_run_flamegun_sht;
			else if (self->spawnflags & SHORTY_GRENADE)
				self->cast_info.currentmove = &shorty_move_run_grenade_sht;
			else
			{
				gi.dprintf ("missing weapon spawnflag\n");
				self->cast_info.currentmove = &shorty_move_run_shg_sht;
			}
		}
		else
			self->cast_info.attack( self );
	}

skipbail:

	self->ideal_yaw = vectoyaw( aim );

	if (self->spawnflags & SHORTY_TOMMYGUN)
	{
		if (self->acc)
			cast_fire_bullet (self, start, aim, damage, 10, DEFAULT_BULLET_HSPREAD>>self->acc, DEFAULT_BULLET_VSPREAD>>self->acc, flash_number);
		else
		cast_fire_bullet (self, start, aim, damage, 10, DEFAULT_BULLET_HSPREAD, DEFAULT_BULLET_VSPREAD, flash_number);
		gi.sound(self, CHAN_WEAPON, tommy_soundindex, 1, ATTN_NORM, 0);
	}
	else if (self->spawnflags & SHORTY_SHOTGUN)
	{
		// tweeking the damage
		cast_fire_shotgun (self, start, aim, damage, 10, DEFAULT_SHOTGUN_HSPREAD, DEFAULT_SHOTGUN_VSPREAD, DEFAULT_SHOTGUN_COUNT, flash_number); 
		gi.sound(self, CHAN_WEAPON, shotgun_soundindex, 1, ATTN_NORM, 0);
		self->cast_info.aiflags |= AI_RELOAD;
	}
	else if (self->spawnflags & SHORTY_BAZOOKA)
	{
		{
			int	speed = 900;
			damage = 100;
			if(self->dmg) damage = self->dmg;

			cast_fire_rocket (self, start, aim, damage, speed, MOD_ROCKET);
			gi.sound (self, CHAN_WEAPON, rocketgun_soundindex, 1, ATTN_NORM, 0);
		}
	}
	else if (self->spawnflags & SHORTY_FLAMEGUN)
	{
		int	kick = 4;
		static int flamesnd = 0;
		
		extern void fire_target_flamethrower (edict_t *self, vec3_t start, vec3_t forward, int damage, int kick, int mod);

		damage = 1;

		if(self->dmg) damage = self->dmg;

		fire_flamethrower(self, start, aim, damage, 0, MOD_FLAMETHROWER);
		self->s.renderfx2 |= RF2_FLAMETHROWER;
//		fire_target_flamethrower(self, start, aim, damage, 0, MOD_FLAMETHROWER);
//		self->s.renderfx2 = RF2_FLAMESHOOTER;

		flamesnd++;
		
		if (flamesnd > 2)
			flamesnd = 0;

		if (flamesnd == 1)
			gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame2.wav"), 1, ATTN_NORM, 0);
		else if (flamesnd == 2)
			gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame3.wav"), 1, ATTN_NORM, 0);
		else
			gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/flame_thrower/flame1.wav"), 1, ATTN_NORM, 0);

	}
	else if (self->spawnflags & SHORTY_GRENADE)
	{
		damage = 150;
		if(self->dmg) damage = self->dmg;
		fire_grenade (self, start, aim, damage, 450, 2.0, 256);
		gi.sound(self, CHAN_AUTO, gi.soundindex("weapons/grenade_launcher/gl_fire.wav"), 1, ATTN_NORM, 0);
	}
	else
	{
		gi.dprintf ("Error: Bang Bang not tagged right\n");
	}

}

void shorty_shotgun_reload( edict_t *self )
{
	if (self->cast_info.aiflags & AI_TURN_BLOCKED)
	{	// abort the side run
		self->cast_info.aiflags &= ~AI_TURN_BLOCKED;
		AI_EndAttack(self);
	}

	if (!(self->spawnflags & SHORTY_SHOTGUN))
	{	// no need to reload
		return;
	}

	gi.sound(self, CHAN_AUTO, shotgun_reload_soundindex, 1, ATTN_NORM, 0);
	self->cast_info.aiflags &= ~AI_RELOAD;
}

void shorty_firegun_right( edict_t *self )
{
//	vec3_t	vec;
//	float	oldyaw;

	if (!self->enemy || (self->enemy->health <= 0))
	{
		self->cast_info.currentmove = self->cast_info.move_stand;
		return;
	}

	if (self->cast_info.aiflags & AI_TURN_BLOCKED)
	{	// abort the side run
		self->cast_info.aiflags &= ~AI_TURN_BLOCKED;
		AI_EndAttack(self);
		return;
	}

	// if the path ahead is not clear, abort
	if (!AI_SideTrace( self, 96, 0, 1 ))
	{
		AI_EndAttack(self);
		return;
	}

/*
	oldyaw = self->s.angles[YAW];

	VectorSubtract( self->enemy->s.origin, self->s.origin, vec );
	VectorNormalize( vec );

	self->s.angles[YAW] = vectoyaw( vec );
*/
	self->cast_info.aiflags |= AI_SIDE_ATTACK;
	shorty_firegun(self);
	self->cast_info.aiflags &= ~AI_SIDE_ATTACK;
/*
	// keep running to the side
	self->ideal_yaw = self->s.angles[YAW] + 90;

	self->s.angles[YAW] = oldyaw;
*/
}

void shorty_firegun_left( edict_t *self )
{
//	vec3_t	vec;
//	float	oldyaw;

	if (!self->enemy)
	{
		self->cast_info.currentmove = self->cast_info.move_stand;
		return;
	}

	if (self->cast_info.aiflags & AI_TURN_BLOCKED)
	{	// abort the side run
		self->cast_info.aiflags &= ~AI_TURN_BLOCKED;
		AI_EndAttack(self);
		return;
	}

	// if the path ahead is not clear, abort
	if (!AI_SideTrace( self, 96, 0, 1 ))
	{
		AI_EndAttack(self);
		return;
	}

/*
	oldyaw = self->s.angles[YAW];

	VectorSubtract( self->enemy->s.origin, self->s.origin, vec );
	VectorNormalize( vec );

	self->s.angles[YAW] = vectoyaw( vec );
*/
	self->cast_info.aiflags |= AI_SIDE_ATTACK;
	shorty_firegun(self);
	self->cast_info.aiflags &= ~AI_SIDE_ATTACK;
/*
	// keep running to the side
	self->ideal_yaw = self->s.angles[YAW] - 90;

	self->s.angles[YAW] = oldyaw;
*/
}

void shorty_pain (edict_t *self, edict_t *other, float kick, int damage, int mdx_part, int mdx_subobject)
{
	int		orientation;

	if (self->s.renderfx2 & RF2_FLAMETHROWER)
		self->s.renderfx2 &= ~RF2_FLAMETHROWER;
	
	AI_CheckMakeEnemy( self, other );

	if (level.time < self->pain_debounce_time)
		return;

	self->pain_debounce_time = level.time + 3 + random();

	if (skill->value >= 3)
		return;		// no pain anims in nightmare

	// faked client pain sound

	if (self->name_index == NAME_HEILMAN)
		Voice_Random (self, self->enemy, &heilman[2], 4);

		// gi.sound (self, CHAN_VOICE, gi.soundindex(va("*pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
	

	// Ridah, randomly don't play an animation, since it' leaves them WAY open to be killed
	if (skill->value > 0 && rand()%2)
		return;


	if (other->client || (other->svflags & SVF_MONSTER))
	{
		orientation = AI_GetOrientation( self, other );
	}
	else
	{
		orientation = ORIENTATION_CENTER;
	}

	if (self->maxs[2] < self->cast_info.standing_max_z)
	{	// crouching
		
		switch (orientation)
		{
		case ORIENTATION_CENTER :
			{
				self->cast_info.currentmove = &shorty_move_crouch_painC;
				break;
			}
		case ORIENTATION_LEFT :
			{
				self->cast_info.currentmove = &shorty_move_crouch_painL;
				break;
			}
		case ORIENTATION_RIGHT :
			{
				self->cast_info.currentmove = &shorty_move_crouch_painR;
				break;
			}
		}

	}
	else	// standing
	{
			if (	(mdx_part == PART_BODY)
				||	(other->client && other->client->pers.weapon && !(other->client->pers.weapon->ammo) && (orientation = rand()%2+1)))
			{
				switch (orientation)
				{
				case ORIENTATION_CENTER :
					{
						self->cast_info.currentmove = &shorty_move_pain_chest;		
						break;
					}
				case ORIENTATION_LEFT :
					{
						self->cast_info.currentmove = &shorty_move_pain_Larm;		
						break;
					}
				case ORIENTATION_RIGHT :
					{
						self->cast_info.currentmove = &shorty_move_pain_Rarm;		
						break;
					}
				}
			}
			else if (mdx_part == PART_LEGS)
			{
				switch (orientation)
				{
				case ORIENTATION_CENTER :
					{
						if (infront(self, other))
						{
							self->cast_info.currentmove = &shorty_move_pain_crch; 
						}
						else
						{
							self->cast_info.currentmove = &shorty_move_pain_butt; 			
						}
						break;
					}
				case ORIENTATION_LEFT :
					{
						self->cast_info.currentmove = &shorty_move_pain_Lleg; 			
						break;
					}
				case ORIENTATION_RIGHT :
					{
						self->cast_info.currentmove = &shorty_move_pain_Rleg; 			
						break;
					}
				}
			}
			else if (mdx_part == PART_HEAD)
			{
				self->cast_info.currentmove = &shorty_move_pain_head; 
			}

	}

}

// JOSEPH 26-FEB-99
void shorty_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point, int mdx_part, int mdx_subobject)
{
	trace_t	tr;
	vec3_t	end;
	edict_t *playthud1, *playthud2;

	if (self->s.renderfx2 & RF2_FLAMETHROWER)
		self->s.renderfx2 &= ~RF2_FLAMETHROWER;

	self->s.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);
	self->s.model_parts[PART_GUN2].invisible_objects = (1<<0 | 1<<1);

// regular death
	self->takedamage = DAMAGE_YES;

	if (DeathByGib(self, inflictor, attacker, damage))
	{	// gib
		self->deadflag = DEAD_DEAD;
		GibEntity( self, inflictor, damage );

		safe_bprintf (PRINT_MEDIUM, "%s Is Dead Now!\n\n",self->name);

		shorty_respawn(self); // replace shorty.
		
		MemoryBang(self);
		
		level.num_shortyloads -= 1;

		return;
	}

	if (self->deadflag == DEAD_DEAD)
		return;

	self->deadflag = DEAD_DEAD;

	// JOSEPH 7-MAY-99

	if (!(self->cast_info.aiflags & AI_MELEE))
	{
		if (self->spawnflags & SHORTY_SHOTGUN)
			SpawnTheWeapon (self, "weapon_shotgun_e");
		else if (self->spawnflags &	SHORTY_HMG)
			SpawnTheWeapon (self, "weapon_heavymachinegun_e");
		else if (self->spawnflags & SHORTY_BAZOOKA)
			SpawnTheWeapon (self, "weapon_bazooka_e");
		else if (self->spawnflags & SHORTY_FLAMEGUN)
			SpawnTheWeapon (self, "weapon_flamethrower_e");
		else if (self->spawnflags & SHORTY_GRENADE)
			SpawnTheWeapon (self, "weapon_grenadelauncher_e");
		else
			SpawnTheWeapon (self, "weapon_tommygun_e");
	}
	// END JOSEPH

	// EP_SpecialEventDeath (self);

	VectorCopy (self->s.origin, end);
	end[2] -= 64;
	tr = gi.trace (self->s.origin, self->mins, self->maxs, end, self, MASK_SHOT);
	
	// JOSEPH 5-JUN-99
	if (mdx_part == PART_HEAD)
	{	// probably head impact, we should really be passing in the model_part here

		self->cast_info.currentmove = &shorty_move_death3;

		playthud1 = G_Spawn();
		VectorCopy (self->s.origin, playthud1->s.origin);
		playthud1->thudsurf = tr.surface->flags;
		playthud1->thudsnd = 1; 
		playthud1->nextthink = level.time + (0.1*8.0);
		playthud1->think = think_playthud;
		gi.linkentity (playthud1);

   		safe_bprintf (PRINT_MEDIUM, "%s Is Dead Now!\n\n",self->name);
		
    	shorty_respawn(self); // replace shorty.
		
        level.num_shortyloads -= 1;

	}
	else if (self->maxs[2] < self->cast_info.standing_max_z)
	{
		if (rand()%100 > 50)
		{
	
			self->cast_info.currentmove = &shorty_move_crouch_death1;

			playthud1 = G_Spawn();
			VectorCopy (self->s.origin, playthud1->s.origin);
			playthud1->thudsurf = tr.surface->flags;
			playthud1->thudsnd = 1; 
			playthud1->nextthink = level.time + (0.1*10.0);
			playthud1->think = think_playthud;
			gi.linkentity (playthud1);
				
			playthud2 = G_Spawn();
			VectorCopy (self->s.origin, playthud2->s.origin);
			playthud2->thudsurf = tr.surface->flags;
			playthud2->thudsnd = 2; 
			playthud2->nextthink = level.time + (0.1*14.0);
			playthud2->think = think_playthud;
			gi.linkentity (playthud2);					

    		safe_bprintf (PRINT_MEDIUM, "%s Is Dead Now!\n\n",self->name);
		
        	shorty_respawn(self); // replace shorty.
		
            level.num_shortyloads -= 1;


		}
		else
		{
            
			self->cast_info.currentmove = &shorty_move_crouch_death2;

			playthud1 = G_Spawn();
			VectorCopy (self->s.origin, playthud1->s.origin);
			playthud1->thudsurf = tr.surface->flags;
			playthud1->thudsnd = 1; 
			playthud1->nextthink = level.time + (0.1*5.0);
			playthud1->think = think_playthud;
			gi.linkentity (playthud1);
				
			playthud2 = G_Spawn();
			VectorCopy (self->s.origin, playthud2->s.origin);
			playthud2->thudsurf = tr.surface->flags;
			playthud2->thudsnd = 2; 
			playthud2->nextthink = level.time + (0.1*7.0);
			playthud2->think = think_playthud;
			gi.linkentity (playthud2);							
		

     		safe_bprintf (PRINT_MEDIUM, "%s Is Dead Now!\n\n",self->name);
		
        	shorty_respawn(self); // replace shorty.
		
            level.num_shortyloads -= 1;

		
		}
	}
	else
	{
		int n;

		n = rand() % 4;
		if (n == 0)
		{
	
			self->cast_info.currentmove = &shorty_move_death1;

			playthud1 = G_Spawn();
			VectorCopy (self->s.origin, playthud1->s.origin);
			playthud1->thudsurf = tr.surface->flags;
			playthud1->thudsnd = 1; 
			playthud1->nextthink = level.time + (0.1*6.0);
			playthud1->think = think_playthud;
			gi.linkentity (playthud1);
				
			playthud2 = G_Spawn();
			VectorCopy (self->s.origin, playthud2->s.origin);
			playthud2->thudsurf = tr.surface->flags;
			playthud2->thudsnd = 2; 
			playthud2->nextthink = level.time + (0.1*15.0);
			playthud2->think = think_playthud;
			gi.linkentity (playthud2);				


     		safe_bprintf (PRINT_MEDIUM, "%s Is Dead Now!\n\n",self->name);
		
        	shorty_respawn(self); // replace shorty.
		
            level.num_shortyloads -= 1;

		
		}
		else if (n == 1)
		{
	
			self->cast_info.currentmove = &shorty_move_death2;

			playthud1 = G_Spawn();
			VectorCopy (self->s.origin, playthud1->s.origin);
			playthud1->thudsurf = tr.surface->flags;
			playthud1->thudsnd = 1; 
			playthud1->nextthink = level.time + (0.1*6.0);
			playthud1->think = think_playthud;
			gi.linkentity (playthud1);
				
			playthud2 = G_Spawn();
			VectorCopy (self->s.origin, playthud2->s.origin);
			playthud2->thudsurf = tr.surface->flags;
			playthud2->thudsnd = 2; 
			playthud2->nextthink = level.time + (0.1*10.0);
			playthud2->think = think_playthud;
			gi.linkentity (playthud2);				

     		safe_bprintf (PRINT_MEDIUM, "%s Is Dead Now!\n\n",self->name);
		
        	shorty_respawn(self); // replace shorty.
		
            level.num_shortyloads -= 1;


		
		}
		else if (n == 2)
		{
	
			self->cast_info.currentmove = &shorty_move_death3;

			playthud1 = G_Spawn();
			VectorCopy (self->s.origin, playthud1->s.origin);
			playthud1->thudsurf = tr.surface->flags;
			playthud1->thudsnd = 1; 
			playthud1->nextthink = level.time + (0.1*8.0);
			playthud1->think = think_playthud;
			gi.linkentity (playthud1);


     		safe_bprintf (PRINT_MEDIUM, "%s Is Dead Now!\n\n",self->name);
		
        	shorty_respawn(self); // replace shorty.
		
            level.num_shortyloads -= 1;

		
		}
		else
		{
	
			self->cast_info.currentmove = &shorty_move_death4;

			playthud1 = G_Spawn();
			VectorCopy (self->s.origin, playthud1->s.origin);
			playthud1->thudsurf = tr.surface->flags;
			playthud1->thudsnd = 1; 
			playthud1->nextthink = level.time + (0.1*7.0);
			playthud1->think = think_playthud;
			gi.linkentity (playthud1);
				
			playthud2 = G_Spawn();
			VectorCopy (self->s.origin, playthud2->s.origin);
			playthud2->thudsurf = tr.surface->flags;
			playthud2->thudsnd = 2; 
			playthud2->nextthink = level.time + (0.1*16.0);
			playthud2->think = think_playthud;
			gi.linkentity (playthud2);				


     		safe_bprintf (PRINT_MEDIUM, "%s Is Dead Now!\n\n",self->name);
		
        	shorty_respawn(self); // replace shorty.
		
            level.num_shortyloads -= 1;

		
		}
	}
	// END JOSEPH

	// JOSEPH 7-DEC-98
    //if (!(self->spawnflags & SHORTY_MELEE))
	//{
		//self->s.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);
		//Shot_Drop_Item(self, FindItem("Tommygun"), "models/weapons/g_tomgun/tomgun_pu.mdx");
	//}
	// END JOSEPH	
	
	if (!self->onfiretime)
	{
		if (self->name_index == NAME_HEILMAN)
			Voice_Random (self, self->enemy, &heilman[0], 2);
		else
			Voice_Random (self, attacker, &male_specific[8], 2);
	}
		// gi.sound (self, CHAN_VOICE, gi.soundindex(va("*death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
}
// END JOSEPH


// =========================================================================

/*QUAKED cast_shorty (1 .5 0) (-16 -16 -24) (16 16 48) FLASH_LIGHT TRIGGERED_START FLAM_BE BAZOOKA HMG IMMEDIATE_FOLLOW_PATH TOMMYGUN GRENADE 

cast_group defines which group the character is a member of
default cast_group is 0, which is neutral (won't help others out)
player's cast_group is 1 (friendly characters)

The default weapon for a shorty is the shotgun

model="models\actors\shorty\"


*/
void SP_cast_shorty(edict_t *self)
{
	int i;
	char	*head_skin, *body_skin, *legs_skin;
	int	skin;
	char *cmd;
	cmd = gi.argv(2);

    if (level.num_shortyloads == 0)
	level.num_shortyloads = 1;
	else
	level.num_shortyloads++;

	if (gamemode->value == 2)
	{

	    SP_info_player_deathmatch(self);	
		return;
    }

	if (stricmp (level.mapname, "rcboss2") == 0)
	{
//      self->target = NULL;
        self->deathtarget = NULL;
		self->spawnflags -= 2;
		self->targetname = NULL;
	}


	if (stricmp (level.mapname, "pv_b") == 0)
	{
      self->deathtarget = NULL;
      self->spawnflags -= 2;
	  self->targetname = NULL;
	}


	//added by ghost
	if (!self->cast_group)
    self->cast_group = 2;

	//added by ghost
    self->classname = "cast_shorty";

    if (stricmp (level.mapname, "sy2") == 0)
	{
      self->target = NULL;
      self->targetname = NULL;
      self->deathtarget = NULL;
	}

	if (!(stricmp (level.mapname, "sy2") == 0))
{
	//added by ghost
	if (!self->name)
	{	// use default skins
		switch(level.num_shortyloads)
		{
			case 1:	    self->name = "Burt";      break;
			case 2:	    self->name = "Fingers";   break;
			case 3:	    self->name = "Dan";       break;
			case 4:	    self->name = "Clarence";  break;
			case 5:	    self->name = "Adolf";     break;
			case 6:	    self->name = "Sharky";    break;
			case 7:	    self->name = "Kingpin";   break;
			case 8:	    self->name = "Blunt";     break;
			case 9:	    self->name = "Moe";       break;
			case 10:    self->name = "Larry";     break;
			case 11:	self->name = "Curly";     break;
			case 12:	self->name = "Ed";        break;
			case 13:	self->name = "Popeye";    break;
			case 14:	self->name = "Dogg";      break;
			case 15:	self->name = "Barney";    break;
			case 16:	self->name = "BigWillie"; break;
			case 17:	self->name = "Sal";       break;
			case 18:	self->name = "Lefty";     break;
			case 19:	self->name = "Mung";      break;
			case 20:	self->name = "Tyrone";    break;
			case 21:	self->name = "Luke";      break;
			case 22:	self->name = "Han";       break;
			case 23:	self->name = "Kroker";    break;
			case 24:	self->name = "David";     break;
			case 25:	self->name = "Moker";     break;
			case 26:	self->name = "Heilman";   break;
			case 27:	self->name = "Dubs";      break;
			case 28:	self->name = "Patrick";   break;
			case 29:	self->name = "Chico";     break;
			case 30:	self->name = "Walter";    break;
			case 31:	self->name = "Donny";     break;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
			case 32:	self->name = "Burt";      break;
			case 33:	self->name = "Fingers";   break;
			case 34:	self->name = "Dan";       break;
			case 35:	self->name = "Clarence";  break;
			case 36:	self->name = "Adolf";     break;
			case 37:	self->name = "Sharky";    break;
			case 38:	self->name = "Kingpin";   break;
			case 39:	self->name = "Blunt";     break;
			case 40:	self->name = "Moe";       break;
			case 41:    self->name = "Larry";     break;
			case 42:	self->name = "Curly";     break;
			case 43:	self->name = "Ed";        break;
			case 44:	self->name = "Popeye";    break;
			case 45:	self->name = "Dogg";      break;
			case 46:	self->name = "Barney";    break;
			case 47:	self->name = "BigWillie"; break;
			case 48:	self->name = "Sal";       break;
			case 49:	self->name = "Lefty";     break;

		}
	}

	// re-wrote the skin assign code and got the idea from Franks old code that assigned a 
	// random skin to the shorty
	// there are 49 skin sets from the original kingpin game
	// each skin is one that was assigned to at least one episode from the 
	// original single player kingpin game

	if (!self->art_skins)
	{	// use default skins
		switch(level.num_shortyloads)
		{
			case 1:	    self->art_skins = "022 020 020"; break;
			case 2:	    self->art_skins = "022 020 022"; break;
			case 3:	    self->art_skins = "022 021 022"; break;
			case 4:	    self->art_skins = "023 020 022"; break;
			case 5:	    self->art_skins = "023 021 021"; break;
			case 6:	    self->art_skins = "023 021 022"; break;
			case 7:	    self->art_skins = "024 020 022"; break;
			case 8:	    self->art_skins = "024 021 022"; break;
			case 9:	    self->art_skins = "025 021 022"; break;
			case 10:    self->art_skins = "030 030 031"; break;
			case 11:	self->art_skins = "030 031 032"; break;
			case 12:	self->art_skins = "030 032 032"; break;
			case 13:	self->art_skins = "032 030 031"; break;
			case 14:	self->art_skins = "033 032 032"; break;
			case 15:	self->art_skins = "035 030 031"; break;
			case 16:	self->art_skins = "035 032 032"; break;
			case 17:	self->art_skins = "036 030 031"; break;
			case 18:	self->art_skins = "036 031 032"; break;
			case 19:	self->art_skins = "036 032 032"; break;
			case 20:	self->art_skins = "037 031 032"; break;
			case 21:	self->art_skins = "037 032 032"; break;
			case 22:	self->art_skins = "050 051 054"; break;
			case 23:	self->art_skins = "050 053 054"; break;
			case 24:	self->art_skins = "050 081 054"; break;
			case 25:	self->art_skins = "051 053 054"; break;
			case 26:	self->art_skins = "052 051 054"; break;
			case 27:	self->art_skins = "053 051 054"; break;
			case 28:	self->art_skins = "053 053 054"; break;
			case 29:	self->art_skins = "054 051 054"; break;
			case 30:	self->art_skins = "054 053 054"; break;
			case 31:	self->art_skins = "054 081 054"; break;
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
			case 32:	self->art_skins = "056 056 057"; break;
			case 33:	self->art_skins = "057 055 058"; break;
			case 34:	self->art_skins = "060 060 060"; break;
			case 35:	self->art_skins = "060 062 060"; break;
			case 36:	self->art_skins = "061 060 060"; break;
			case 37:	self->art_skins = "061 062 060"; break;
			case 38:	self->art_skins = "062 061 060"; break;
			case 39:	self->art_skins = "062 062 060"; break;
			case 40:	self->art_skins = "063 064 060"; break;
			case 41:	self->art_skins = "064 047 047"; break;
			case 42:	self->art_skins = "064 066 060"; break;
			case 43:	self->art_skins = "065 063 060"; break;
			case 44:	self->art_skins = "070 070 071"; break;
			case 45:	self->art_skins = "074 070 071"; break;
			case 46:	self->art_skins = "121 121 121"; break;
			case 47:	self->art_skins = "130 130 010"; break;
			case 48:	self->art_skins = "130 131 010"; break;
			case 49:	self->art_skins = "131 130 010"; break;

		
		}
	}

}
	if (!(self->spawnflags & (SHORTY_FLAMEGUN|SHORTY_BAZOOKA|SHORTY_HMG|SHORTY_TOMMYGUN|SHORTY_GRENADE)))
	{
		self->spawnflags |= SHORTY_SHOTGUN;
	}

	self->movetype = MOVETYPE_STEP;
	self->solid = SOLID_BBOX;
	self->s.skinnum = (self->skin-1) * 3;

	VectorSet (self->mins, -16, -16, -24);
	VectorSet (self->maxs,  16,  16,  48);

	if (!self->art_skins)
	{	// use default skins
		self->art_skins = "001 001 001";
	}

	if (self->art_skins)
	{
		// convert spaces to NULL's
		for (i=0; i<11; i++)
			if (self->art_skins[i] == ' ')
				self->art_skins[i] = '\0';

		head_skin = &self->art_skins[0];
		body_skin = &self->art_skins[4];
		legs_skin = &self->art_skins[8];
	}
	else
	{
		head_skin = body_skin = legs_skin = NULL;
	}

	tommy_soundindex = gi.soundindex("weapons/machinegun/machgf1b.wav");
	shotgun_soundindex = gi.soundindex("weapons/shotgun/shotgf1b.wav");
	shotgun_reload_soundindex = gi.soundindex("weapons/shotgun/shotgr1b.wav");
	heavymachinegun_soundindex = gi.soundindex ("weapons/hmg/single.wav");
	rocketgun_soundindex = gi.soundindex ("weapons/rocket_launcher/rl_fire.wav");

	// ------------------------------------------------------------------------
	// initialize all model_part data
	memset(&(self->s.model_parts[0]), 0, sizeof(model_part_t) * MAX_MODEL_PARTS);

	self->s.num_parts++;

	switch (self->head)
	{
		case 1:
			self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/actors/shorty/bald_head.mdx");
			break;
		case 2:
			self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/actors/shorty/ski_head.mdx");
			break;
		case 3:
			self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/actors/shorty/weld_head.mdx");
			break;
		default:
	self->s.model_parts[PART_HEAD].modelindex = gi.modelindex("models/actors/shorty/head.mdx");
			break;
	}
	if (head_skin)
	{
		skin = gi.skinindex( self->s.model_parts[PART_HEAD].modelindex, head_skin );
	}
	else
		skin = self->s.skinnum;
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		self->s.model_parts[PART_HEAD].baseskin = self->s.model_parts[PART_HEAD].skinnum[i] = skin;
	gi.GetObjectBounds( "models/actors/shorty/head.mdx", &self->s.model_parts[PART_HEAD] );

	self->s.num_parts++;
	self->s.model_parts[PART_LEGS].modelindex = gi.modelindex("models/actors/shorty/legs.mdx");
	if (head_skin)
		skin = gi.skinindex( self->s.model_parts[PART_LEGS].modelindex, legs_skin );
	else
		skin = self->s.skinnum;
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		self->s.model_parts[PART_LEGS].baseskin = self->s.model_parts[PART_LEGS].skinnum[i] = skin;
	gi.GetObjectBounds( "models/actors/shorty/legs.mdx", &self->s.model_parts[PART_LEGS] );

	self->s.num_parts++;
	self->s.model_parts[PART_BODY].modelindex = gi.modelindex("models/actors/shorty/body.mdx");
	if (head_skin)
		skin = gi.skinindex( self->s.model_parts[PART_BODY].modelindex, body_skin );
	else
		skin = self->s.skinnum;
	for (i=0; i<MAX_MODELPART_OBJECTS; i++)
		self->s.model_parts[PART_BODY].baseskin = self->s.model_parts[PART_BODY].skinnum[i] = skin;
	gi.GetObjectBounds( "models/actors/shorty/body.mdx", &self->s.model_parts[PART_BODY] );

// Ridah, temp only for testing, hard to test with all grenade guys
//if (self->spawnflags & SHORTY_GRENADE)
//self->spawnflags |= SHORTY_SHOTGUN;

	if (self->spawnflags & SHORTY_TOMMYGUN)
	{
		self->s.num_parts++;
		self->s.model_parts[PART_GUN].modelindex = gi.modelindex("models/actors/shorty/tommygun.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_GUN].baseskin = self->s.model_parts[PART_GUN].skinnum[i] = 0;// self->s.skinnum;
		gi.GetObjectBounds( "models/actors/shorty/tommygun.mdx", &self->s.model_parts[PART_GUN] );
	}
	else if (self->spawnflags & SHORTY_SHOTGUN)
	{
		self->s.num_parts++;
		self->s.model_parts[PART_GUN].modelindex = gi.modelindex("models/actors/shorty/shotgun.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_GUN].baseskin = self->s.model_parts[PART_GUN].skinnum[i] = 0;// self->s.skinnum;
		gi.GetObjectBounds( "models/actors/shorty/shotgun.mdx", &self->s.model_parts[PART_GUN] );
	}
	else if (self->spawnflags & SHORTY_HMG)
	{
		self->s.num_parts++;
		self->s.model_parts[PART_GUN].modelindex = gi.modelindex("models/actors/shorty/hmg.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_GUN].baseskin = self->s.model_parts[PART_GUN].skinnum[i] = 0;// self->s.skinnum;
		gi.GetObjectBounds( "models/actors/shorty/hmg.mdx", &self->s.model_parts[PART_GUN] );
	}
	else if (self->spawnflags & SHORTY_BAZOOKA)
	{
		self->s.num_parts++;
		self->s.model_parts[PART_GUN].modelindex = gi.modelindex("models/actors/shorty/rocket_lnch.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_GUN].baseskin = self->s.model_parts[PART_GUN].skinnum[i] = 0;// self->s.skinnum;
		gi.GetObjectBounds( "models/actors/shorty/rocket_lnch.mdx", &self->s.model_parts[PART_GUN] );
	}
	else if (self->spawnflags & SHORTY_FLAMEGUN)
	{
		// NOTE TO SELF: tell Jason to make a gun.mdx for this weapon
		self->s.num_parts++;
		self->s.model_parts[PART_GUN].modelindex = gi.modelindex("models/actors/shorty/rocket_lnch.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_GUN].baseskin = self->s.model_parts[PART_GUN].skinnum[i] = 0;// self->s.skinnum;
		gi.GetObjectBounds( "models/actors/shorty/rocket_lnch.mdx", &self->s.model_parts[PART_GUN] );
	}	
	else if (self->spawnflags & SHORTY_GRENADE)
	{
		self->s.num_parts++;
		self->s.model_parts[PART_GUN].modelindex = gi.modelindex("models/actors/shorty/grenade_lnch.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_GUN].baseskin = self->s.model_parts[PART_GUN].skinnum[i] = 0;// self->s.skinnum;
		gi.GetObjectBounds( "models/actors/shorty/grenade_lnch.mdx", &self->s.model_parts[PART_GUN] );
	}
	else
	{
		gi.dprintf ("error no weapon spawnflag\n");

		self->s.num_parts++;
		self->s.model_parts[PART_GUN].modelindex = gi.modelindex("models/actors/shorty/shotgun.mdx");
		for (i=0; i<MAX_MODELPART_OBJECTS; i++)
			self->s.model_parts[PART_GUN].baseskin = self->s.model_parts[PART_GUN].skinnum[i] = 0;// self->s.skinnum;
		gi.GetObjectBounds( "models/actors/shorty/shotgun.mdx", &self->s.model_parts[PART_GUN] );
	}

	// remove NULL's
	if (self->art_skins)
		self->art_skins[3] = self->art_skins[7] = ' ';

	// ------------------------------------------------------------------------

	if (!self->health)
	self->health = 100;

	self->gib_health = -200;
	self->mass = 200;

	self->gender = GENDER_MALE;

	self->pain = shorty_pain;
	self->die = shorty_die;

	self->cast_info.checkattack = AI_CheckAttack;

	self->cast_info.attack = shorty_attack;
	self->cast_info.long_attack = shorty_long_attack;
	self->cast_info.talk = shorty_talk;
	self->cast_info.avoid = shorty_avoid;

	self->cast_info.catch_fire = shorty_catch_fire;

// Ridah, new AI system stuff!
	self->cast_info.max_attack_distance = 2000;

	// Ridah, so they don't shoot the flamegun from too far away
	if (self->spawnflags & SHORTY_FLAMEGUN)
		self->cast_info.max_attack_distance = 384;

	self->cast_info.move_stand = &shorty_move_stand;

// 	self->cast_info.move_crstand = &shorty_move_crouch_stand;
	self->cast_info.move_crstand = &shorty_move_crch_astand;

	self->cast_info.move_run = &shorty_move_run_gun_down;
	
	// RAFAEL
	if (self->spawnflags & 1)
		self->cast_info.move_runwalk = &shorty_move_walk_gdownFLASHLIGHT;
	else
		self->cast_info.move_runwalk = &shorty_move_walk_gdown;

	self->cast_info.move_crwalk = &shorty_move_crh_shuf;

	self->cast_info.move_jump = &shorty_move_jump;

	self->cast_info.move_avoid_walk = &shorty_move_avoid_walk;
	self->cast_info.move_avoid_run = &shorty_move_avoid_run;
	self->cast_info.move_avoid_reverse_walk = &shorty_move_avoid_reverse_walk;
	self->cast_info.move_avoid_reverse_run = &shorty_move_avoid_reverse_run;
	self->cast_info.move_avoid_crwalk = &shorty_move_avoid_crouch_walk;

	self->cast_info.move_crouch_down = &shorty_move_crouch_stand_down;
	self->cast_info.move_stand_up = &shorty_move_crouch_stand_up;

	self->cast_info.move_lside_step = &shorty_move_lside_step;
	self->cast_info.move_rside_step = &shorty_move_rside_step;

	self->cast_info.move_start_climb = &shorty_move_clmb_loop;
	self->cast_info.move_end_climb = &shorty_move_clmb_over;

// Ridah, done.

	gi.linkentity (self);

	self->cast_info.currentmove = self->cast_info.move_stand;

	if (!self->cast_info.scale)
		self->cast_info.scale = MODEL_SCALE;

	self->s.scale = self->cast_info.scale - 1.0;

	// talk by default
	self->cast_info.aiflags |= AI_TALK;

	if (!self->acc)
		self->acc = 2;

	walking_cast_start (self);

	self->count = -1;	// assault virgin13

	if (!disable_bloodmoney_debug) //added for bloodmoney
	{
	if (self->name)
	safe_bprintf(PRINT_HIGH,"\n1st Spawn: I am a %s my name is %s and my map address is (%d,%d,%d)\n",self->classname,self->name,(int)self->s.origin[0], (int)self->s.origin[1], (int)self->s.origin[2]);
	else
	safe_bprintf(PRINT_HIGH,"\n1st Spawn: I am a %s and I have no name, my map address is (%d,%d,%d)\n",self->classname,(int)self->s.origin[0], (int)self->s.origin[1], (int)self->s.origin[2]);
	
	if ( (self->target) || (self->targetname) )
	{
	safe_bprintf(PRINT_HIGH,"1st Spawn: I am set to activate (%s)<-target ",self->target);
    safe_bprintf(PRINT_HIGH,"to activate me use (%s)<-targetname\n",self->targetname);
	}

	safe_bprintf(PRINT_HIGH,"1st Spawn: self->head (%i) self->art_skins (%s)\n",self->head,self->art_skins);
    safe_bprintf(PRINT_HIGH,"1st Spawn: self->health is (%i) self->gib_health (%i)\n",self->health,self->gib_health);
    safe_bprintf(PRINT_HIGH,"1st Spawn: self->s.scale (%f) self->acc (%i) self->count (%i)\n",self->s.scale,self->acc,self->count);

	}

}



/************************************************
qboolean CheckShortyScripts(edict_t *self)

is called from
g_ai_fight.c: qboolean AI_CheckAttack(edict_t *self) AND
g_ai.c:       void AI_TalkThink( edict_t *self, qboolean ismale )


Allows scripts to run for cast_shorty etc.
*************************************************/


qboolean CheckShortyScripts(edict_t *self)
{
	int n = self->option - self->count;

	if(    self->count > -1 
		&& !strcmp(self->classname,"cast_shorty") 
		&& self->gesture[n] ) // assault virgin11beta
	{

		CHECKPLAYSOUND

		else if(!strcmp(self->gesture[n],"shorty_attack"))	
		{
			AssaultAICheckForEnemies(self);
			if(self->count-- < 0) return false;
		}

		n = self->option - self->count;

			 if(!strcmp(self->gesture[n],"wait") || !strcmp(self->gesture[n],"shorty_move_stand") )
		   self->cast_info.currentmove = &shorty_move_stand;
		else if(!strcmp(self->gesture[n],"shorty_move_tg_shoot"))
		   self->cast_info.currentmove = &shorty_move_tg_shoot;
		else if(!strcmp(self->gesture[n],"shorty_move_hmg_shoot"))
		   self->cast_info.currentmove = &shorty_move_hmg_shoot;
		else if(!strcmp(self->gesture[n],"shorty_move_bazooka_shoot"))
		   self->cast_info.currentmove = &shorty_move_bazooka_shoot;
		else if(!strcmp(self->gesture[n],"shorty_move_grenade_shoot"))
		   self->cast_info.currentmove = &shorty_move_grenade_shoot;
		else if(!strcmp(self->gesture[n],"shorty_move_flamegun_shoot"))
		   self->cast_info.currentmove = &shorty_move_flamegun_shoot;
		else if(!strcmp(self->gesture[n],"shorty_move_shg_shoot"))
		   self->cast_info.currentmove = &shorty_move_shg_shoot;
		else if(!strcmp(self->gesture[n],"shorty_move_tg_reload"))
		   self->cast_info.currentmove = &shorty_move_tg_reload;
		else if(!strcmp(self->gesture[n],"shorty_move_talk1"))
		   self->cast_info.currentmove = &shorty_move_talk1;
		else if(!strcmp(self->gesture[n],"shorty_move_talk2"))
		   self->cast_info.currentmove = &shorty_move_talk2;
		else if(!strcmp(self->gesture[n],"shorty_move_talk3"))
		   self->cast_info.currentmove = &shorty_move_talk3;
		else if(!strcmp(self->gesture[n],"shorty_move_talk4"))
		   self->cast_info.currentmove = &shorty_move_talk4;
		else if(!strcmp(self->gesture[n],"shorty_move_talk5"))
		   self->cast_info.currentmove = &shorty_move_talk5;
		else if(!strcmp(self->gesture[n],"shorty_move_talk6"))
		   self->cast_info.currentmove = &shorty_move_talk6;
		else if(!strcmp(self->gesture[n],"shorty_move_talk7"))
		   self->cast_info.currentmove = &shorty_move_talk7;
		else if(!strcmp(self->gesture[n],"shorty_move_pain_Rarm"))
		   self->cast_info.currentmove = &shorty_move_pain_Rarm;
		else if(!strcmp(self->gesture[n],"shorty_move_pain_Larm"))
		   self->cast_info.currentmove = &shorty_move_pain_Larm;
		else if(!strcmp(self->gesture[n],"shorty_move_pain_chest"))
		   self->cast_info.currentmove = &shorty_move_pain_chest;
		else if(!strcmp(self->gesture[n],"shorty_move_pain_head"))
		   self->cast_info.currentmove = &shorty_move_pain_head;
		else if(!strcmp(self->gesture[n],"shorty_move_pain_Rleg"))
		   self->cast_info.currentmove = &shorty_move_pain_Rleg;
		else if(!strcmp(self->gesture[n],"shorty_move_pain_Lleg"))
		   self->cast_info.currentmove = &shorty_move_pain_Lleg;
		else if(!strcmp(self->gesture[n],"shorty_move_pain_crch"))
		   self->cast_info.currentmove = &shorty_move_pain_crch;
		else if(!strcmp(self->gesture[n],"shorty_move_pain_butt"))
		   self->cast_info.currentmove = &shorty_move_pain_butt;
		else if(!strcmp(self->gesture[n],"shorty_move_jump"))
		   self->cast_info.currentmove = &shorty_move_jump;
		else if(!strcmp(self->gesture[n],"shorty_move_death1"))
		   self->cast_info.currentmove = &shorty_move_death1;
		else if(!strcmp(self->gesture[n],"shorty_move_death2"))
		   self->cast_info.currentmove = &shorty_move_death2;
		else if(!strcmp(self->gesture[n],"shorty_move_death3"))
		   self->cast_info.currentmove = &shorty_move_death3;
		else if(!strcmp(self->gesture[n],"shorty_move_death4"))
		   self->cast_info.currentmove = &shorty_move_death4;
		else if(!strcmp(self->gesture[n],"shorty_move_death5"))
		   self->cast_info.currentmove = &shorty_move_death5;
		else if(!strcmp(self->gesture[n],"shorty_move_death6"))
		   self->cast_info.currentmove = &shorty_move_death6;
		else if(!strcmp(self->gesture[n],"shorty_move_death7"))
		   self->cast_info.currentmove = &shorty_move_death7;
		else if(!strcmp(self->gesture[n],"shorty_move_death8"))
		   self->cast_info.currentmove = &shorty_move_death8;
		else if(!strcmp(self->gesture[n],"shorty_move_crh_shuf"))
		   self->cast_info.currentmove = &shorty_move_crh_shuf;
		else if(!strcmp(self->gesture[n],"shorty_move_crouch_walk"))
		   self->cast_info.currentmove = &shorty_move_crouch_walk;
		else if(!strcmp(self->gesture[n],"shorty_move_crouch_painC"))
		   self->cast_info.currentmove = &shorty_move_crouch_painC;
		else if(!strcmp(self->gesture[n],"shorty_move_crouch_painL"))
		   self->cast_info.currentmove = &shorty_move_crouch_painL;
		else if(!strcmp(self->gesture[n],"shorty_move_crouch_painR"))
		   self->cast_info.currentmove = &shorty_move_crouch_painR;
		else if(!strcmp(self->gesture[n],"shorty_move_crouch_shoot"))
		   self->cast_info.currentmove = &shorty_move_crouch_shoot;
		else if(!strcmp(self->gesture[n],"shorty_move_crch_shg_sht"))
		   self->cast_info.currentmove = &shorty_move_crch_shg_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_crouch_stand_down"))
		   self->cast_info.currentmove = &shorty_move_crouch_stand_down;
		else if(!strcmp(self->gesture[n],"shorty_move_crouch_stand_up"))
		   self->cast_info.currentmove = &shorty_move_crouch_stand_up;
		else if(!strcmp(self->gesture[n],"shorty_move_crch_astand"))
		   self->cast_info.currentmove = &shorty_move_crch_astand;
		else if(!strcmp(self->gesture[n],"shorty_move_crouch_death1"))
		   self->cast_info.currentmove = &shorty_move_crouch_death1;
		else if(!strcmp(self->gesture[n],"shorty_move_crouch_death2"))
		   self->cast_info.currentmove = &shorty_move_crouch_death2;
		else if(!strcmp(self->gesture[n],"shorty_move_clmb_loop"))
		   self->cast_info.currentmove = &shorty_move_clmb_loop;
		else if(!strcmp(self->gesture[n],"shorty_move_clmb_over"))
		   self->cast_info.currentmove = &shorty_move_clmb_over;
		else if(!strcmp(self->gesture[n],"shorty_move_lside_step"))
		   self->cast_info.currentmove = &shorty_move_lside_step;
		else if(!strcmp(self->gesture[n],"shorty_move_rside_step"))
		   self->cast_info.currentmove = &shorty_move_rside_step;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_nw"))
		   self->cast_info.currentmove = &shorty_move_walk_nw;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_tg_sht"))
		   self->cast_info.currentmove = &shorty_move_walk_tg_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_hmg_sht"))
		   self->cast_info.currentmove = &shorty_move_walk_hmg_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_bazooka_sht"))
		   self->cast_info.currentmove = &shorty_move_walk_bazooka_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_grenade_sht"))
		   self->cast_info.currentmove = &shorty_move_walk_grenade_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_flamegun_sht"))
		   self->cast_info.currentmove = &shorty_move_walk_flamegun_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_shg_sht"))
		   self->cast_info.currentmove = &shorty_move_walk_shg_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_gdown"))
		   self->cast_info.currentmove = &shorty_move_walk_gdown;
		else if(!strcmp(self->gesture[n],"shorty_move_run_nw"))
		   self->cast_info.currentmove = &shorty_move_run_nw;
		else if(!strcmp(self->gesture[n],"shorty_move_run_tg_sht"))
		   self->cast_info.currentmove = &shorty_move_run_tg_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_reverse_tg_sht"))
		   self->cast_info.currentmove = &shorty_move_run_reverse_tg_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_hmg_sht"))
		   self->cast_info.currentmove = &shorty_move_run_hmg_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_reverse_hmg_sht"))
		   self->cast_info.currentmove = &shorty_move_run_reverse_hmg_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_bazooka_sht"))
		   self->cast_info.currentmove = &shorty_move_run_bazooka_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_reverse_bazooka_sht"))
		   self->cast_info.currentmove = &shorty_move_run_reverse_bazooka_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_grenade_sht"))
		   self->cast_info.currentmove = &shorty_move_run_grenade_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_reverse_grenade_sht"))
		   self->cast_info.currentmove = &shorty_move_run_reverse_grenade_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_flamegun_sht"))
		   self->cast_info.currentmove = &shorty_move_run_flamegun_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_reverse_flamegun_sht"))
		   self->cast_info.currentmove = &shorty_move_run_reverse_flamegun_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_shg_sht"))
		   self->cast_info.currentmove = &shorty_move_run_shg_sht;
		else if(!strcmp(self->gesture[n],"shorty_move_run_gun_down"))
		   self->cast_info.currentmove = &shorty_move_run_gun_down;
		else if(!strcmp(self->gesture[n],"shorty_move_run_on_fire"))
		   self->cast_info.currentmove = &shorty_move_run_on_fire;
		else if(!strcmp(self->gesture[n],"shorty_move_lsd_tg_run"))
		   self->cast_info.currentmove = &shorty_move_lsd_tg_run;
		else if(!strcmp(self->gesture[n],"shorty_move_rsd_tg_run"))
		   self->cast_info.currentmove = &shorty_move_rsd_tg_run;
		else if(!strcmp(self->gesture[n],"shorty_move_lsd_hmg_run"))
		   self->cast_info.currentmove = &shorty_move_lsd_hmg_run;
		else if(!strcmp(self->gesture[n],"shorty_move_rsd_hmg_run"))
		   self->cast_info.currentmove = &shorty_move_rsd_hmg_run;
		else if(!strcmp(self->gesture[n],"shorty_move_lsd_bazooka_run"))
		   self->cast_info.currentmove = &shorty_move_lsd_bazooka_run;
		else if(!strcmp(self->gesture[n],"shorty_move_rsd_bazooka_run"))
		   self->cast_info.currentmove = &shorty_move_rsd_bazooka_run;
		else if(!strcmp(self->gesture[n],"shorty_move_lsd_grenade_run"))
		   self->cast_info.currentmove = &shorty_move_lsd_grenade_run;
		else if(!strcmp(self->gesture[n],"shorty_move_rsd_grenade_run"))
		   self->cast_info.currentmove = &shorty_move_rsd_grenade_run;
		else if(!strcmp(self->gesture[n],"shorty_move_lsd_flamegun_run"))
		   self->cast_info.currentmove = &shorty_move_lsd_flamegun_run;
		else if(!strcmp(self->gesture[n],"shorty_move_rsd_flamegun_run"))
		   self->cast_info.currentmove = &shorty_move_rsd_flamegun_run;
		else if(!strcmp(self->gesture[n],"shorty_move_rsd_shg_run"))
		   self->cast_info.currentmove = &shorty_move_rsd_shg_run;
		else if(!strcmp(self->gesture[n],"shorty_move_lsd_shg_run"))
		   self->cast_info.currentmove = &shorty_move_lsd_shg_run;
		else if(!strcmp(self->gesture[n],"shorty_move_avoid_walk"))
		   self->cast_info.currentmove = &shorty_move_avoid_walk;
		else if(!strcmp(self->gesture[n],"shorty_move_avoid_crouch_walk"))
		   self->cast_info.currentmove = &shorty_move_avoid_crouch_walk;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_gdownFLASHLIGHT"))
		   self->cast_info.currentmove = &shorty_move_walk_gdownFLASHLIGHT;
		else if(!strcmp(self->gesture[n],"shorty_move_avoid_run"))
		   self->cast_info.currentmove = &shorty_move_avoid_run;
		else if(!strcmp(self->gesture[n],"shorty_move_avoid_reverse_walk"))
		   self->cast_info.currentmove = &shorty_move_avoid_reverse_walk;
		else if(!strcmp(self->gesture[n],"shorty_move_avoid_reverse_run"))
		   self->cast_info.currentmove = &shorty_move_avoid_reverse_run;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_dokey"))
		   self->cast_info.currentmove = &shorty_move_walk_dokey;
		else if(!strcmp(self->gesture[n],"shorty_move_crch_dokey"))
		   self->cast_info.currentmove = &shorty_move_crch_dokey;
		else if(!strcmp(self->gesture[n],"shorty_move_hmg_shoot2"))
		   self->cast_info.currentmove = &shorty_move_hmg_shoot2;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_hmg_sht2"))
		   self->cast_info.currentmove = &shorty_move_walk_hmg_sht2;
		else if(!strcmp(self->gesture[n],"shorty_move_run_hmg_sht2"))
		   self->cast_info.currentmove = &shorty_move_run_hmg_sht2;
		else if(!strcmp(self->gesture[n],"shorty_move_bazooka_shoot2"))
		   self->cast_info.currentmove = &shorty_move_bazooka_shoot2;
		else if(!strcmp(self->gesture[n],"shorty_move_walk_bazooka_shoot2"))
		   self->cast_info.currentmove = &shorty_move_walk_bazooka_shoot2;
		else if(!strcmp(self->gesture[n],"shorty_move_run_bazooka_shoot2"))
		   self->cast_info.currentmove = &shorty_move_run_bazooka_shoot2;
		else self->cast_info.currentmove = &shorty_move_stand;

     	if (!disable_bloodmoney_debug) //added for bloodmoney
		gi.bprintf(PRINT_HIGH,"Script line: %i %s gesture: %s\n",n, self->classname, self->gesture[n]);

		self->count--;
		return true;
	}

	return false;
}