#!/bin/bash

# bash script to run sh files in the terminal emulators

# Copyright (C) 2023 Imam Hossain

# License
#	This program is free software; you can use it for any purposes but can not redistribute it and/or modify it.
#	This program is distributed in the hope that it will be useful but WITHOUT ANY WARRANTY.

SCRIPT_NAME="launch_kingpin"

APP_NAME="Kingpin: Life of Crime"

APP_EXECUTABLE="kingpin.x86"

GL_LIB="`ldd glxgears | grep libGL.so | cut -d " " -f 3`"

LAUNCH_COMMAND="./$APP_EXECUTABLE +set vid_ref glx +set gl_driver \"$GL_LIB\" $@"

RRVal=0

CDIR="`dirname "$0"`"

if [ $CDIR == "." ]; then
CDIR="`pwd`"
fi

cd $CDIR

export LD_LIBRARY_PATH=".:${LD_LIBRARY_PATH}"
export MESA_EXTENSION_MAX_YEAR=2005

$LAUNCH_COMMAND
RRVal=$?

if [ $RRVal -ne 0 ]
then
echo "Could not start $APP_NAME ($APP_EXECUTABLE), run the $SCRIPT_NAME in the terminal to see log" > tempm
xdg-open tempm
fi

exit $RRVal
