#!/bin/bash
cd "$(dirname "$0")"

gamepath=$(find /home/$USER -type d -name "kingpin" 2>/dev/null | head -n 1)
if [ -z "$gamepath" ]; then
  echo "Kingpin directory not found. Please place this script in the game folder."
  exit 1
fi
sed -i "/^path=/c\path=$gamepath" kingpin.conf

sudo modprobe snd-pcm-oss
if [ -e /proc/asound/card0/pcm0p/oss ]; then
  echo kingpin 0 0 direct | sudo tee /proc/asound/card0/pcm0p/oss
else
  echo "Warning: OSS sound device not found  audio might not work."
fi

export LD_LIBRARY_PATH=".:${LD_LIBRARY_PATH}"
export MESA_EXTENSION_MAX_YEAR=2005
./kingpin.x86