    'Libraries
    #INCLUDE ONCE   "genlib.bas"
    
    'Constants
    #DEFINE UNDEFINED ("?")
    'Chunk Flags
    #define CH_VALID        1
    #define CH_FLAG2        2
    #define CH_FLAG3        4
    #define CH_FLAG4        8
    #define CH_FLAG5        16
    #define CH_FLAG6        32
    #define CH_FLAG7        64
    #define CH_FLAG8        128
    'Data Type
    #define DT_BYTE         1
    #define DT_STRING       2
    #define DT_SHORT        3
    #define DT_BINARY       4
    'Allower characters
    #define CHR_NONE        0
    #define CHR_NUMBERS     1
    #define CHR_STANDARD    2
    #define CHR_EXTENDED    3

    'Types
    Type Table_t
      ChunkName(0 to 16)  as string
      PawnSlot(1 to 8)    as string
      pawnitem(1 to 64)   as string
    end type
    
    type Pair_t
      DataType        as ubyte        '1 = byte, 2 = string, 3 = short, 4 = binary (stored in ubyte, waste 7 bits)
      Point2Byte      as ubyte ptr
      Point2String    as zstring ptr
      Point2Short     as ushort ptr
      WhatIs          as string
      Limit           as short
      Descr           as string
      AllowChr        as ubyte
    end type
    
    Type CHUNK_t  'If you wanna add a new chunk: do it here, search for the RefreshSETTINGS routine, check both SSFLoad and SSFSave
      'Chunk FLAG, for this program, never stored
      FLAG                      as ubyte = 0
      'Chunk ID
      ID                        as ubyte
      'ID=1, Episode Flags
      Flag_Entries              as ubyte
      Flag_Number(1 to 32)      as ubyte  => { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 ,26, 27, 28, 29, 30, 31, 32 }
      Flag_LabelSize(1 to 32)   as ubyte
      Flag_Label(1 to 32)       as zstring*60 'max: 48
      'ID=2, Logs
      Logs_Entries              as ubyte
      Logs_BindFlag(0 to 32)    as ubyte  => { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25 ,26, 27, 28, 29, 30, 31, 32 }
      Logs_MessageSize(0 to 32) as ubyte
      Logs_Message(0 to 32)     as zstring*300 'max: 255
      'ID=3 or 4, Shops
      Shop_ID                   as ubyte  =  1
      Shop_Available(1 to 64)   as ubyte  => { 1,1,1,1,1,1,1,0,1,1,1,1,1,0,0,0,1,1,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } 'Not looking good, but easier to handle
      Shop_Prices(1 to 64)      as ushort => { 50, 150, 250, 750, 200, 350, 500, 0, 10, 25, 50, 25, 50, 60, 100, 0, 5, 25, 20, 100, 0, 0, 0, 0, 100, 25, 0, 0, 0, 0, 0, 0, 25, 50, 0, 0, 0, 0, 0, 0, 100, 200, 150, 300, 100, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}  ' ID 4 (prices)
      'ID=16, Meta
      Meta_MessageSize          as ushort
      Meta_Message              as zstring*1100 'max: 1024 -- made larger to avoid data overloaping (it happened)
    end type

    'Variables
      dim shared as wstring*128   USER_SRCFILE, TMP_FILE                  'filename to create/edit (TMP_FILE is the display name)
      dim shared as byte          PRG_COLUMN=1,PRG_EditMode=0             'is 1 (left) or 2 (right)
      dim shared as ushort        PRG_SELCHUNK=0,PRG_SELCONTENT=0         'currently selected chunk
      dim shared as integer       PRG_ScrollChunks=0,PRG_ScrollContent=0  'Chunks to skip when showing the list
      dim shared as uinteger      Square(0 to 32)                         'Power of two
      for k as ushort = lbound(Square) to ubound(Square): Square(k) = 2^k:next k      
      dim shared as string        ChrTable(1 to 3)
      ChrTable(1) = "0123456789"
      ChrTable(2) = "0123456789_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
      ChrTable(3) = "0123456789_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ&'.,;:!?-*/\+-#=()[]{} "
    redim shared as pair_t        Pairs(0 to 0)                           'Data Displayed in content field
      dim shared as Table_t       PRG_Table
      PRG_Table.ChunkName(1)= "EPFLAGS"      :PRG_Table.ChunkName(2) = "LOGS"
      PRG_Table.ChunkName(3)= "SHOPSTOCKS"   :PRG_Table.ChunkName(4) = "SHOPPRICES"
      PRG_Table.ChunkName(16)="META"
      PRG_Table.PawnSlot(1) = "Weapons"       :PRG_Table.PawnSlot(2) = "Mods"
      PRG_Table.PawnSlot(3) = "Ammo1"         :PRG_Table.PawnSlot(4) = "Ammo2"
      PRG_Table.PawnSlot(5) = "Health"        :PRG_Table.PawnSlot(6) = "Armors"
      PRG_Table.PawnItem(1) = "Pistol"        :PRG_Table.PawnItem(2) = "Shotgun"
      PRG_Table.PawnItem(3) = "Tommy Gun"     :PRG_Table.PawnItem(4) = "Hvy Machine Gun"
      PRG_Table.PawnItem(5) = "Grenade Launcher":PRG_Table.PawnItem(6)="Bazooka"
      PRG_Table.PawnItem(7) = "Flamethrower"
      PRG_Table.PawnItem(9) = "Silencer"      :PRG_Table.PawnItem(10)= "Rate of Fire"
      PRG_Table.PawnItem(11) ="Magnum Mod"    :PRG_Table.PawnItem(12)= "Reload Mod"
      PRG_Table.PawnItem(13) ="Cooling Mod"   :PRG_Table.PawnItem(14)= "Accuracy Mod"
      PRG_Table.PawnItem(15) ="Slowburn Mod"
      PRG_Table.PawnItem(17) ="Bullets"       :PRG_Table.PawnItem(18)= "Shells"
      PRG_Table.PawnItem(19) =".308"          :PRG_Table.PawnItem(20)= "Grenades"
      PRG_Table.PawnItem(25) ="Rockets"       :PRG_Table.PawnItem(26) ="Gas"
      PRG_Table.PawnItem(33) ="Small Medkit"  :PRG_Table.PawnItem(34) ="Large Medkit"
      PRG_Table.PawnItem(41) ="Helmet"        :PRG_Table.PawnItem(42) ="Heavy Helmet"
      PRG_Table.PawnItem(43) ="Jacket"        :PRG_Table.PawnItem(44) ="Heavy Jacket"
      PRG_Table.PawnItem(45) ="Legs Armor"    :PRG_Table.PawnItem(46) ="Hvy Legs Armor"
    redim shared as CHUNK_t       Chunks      (0 to 0)    'Contains chunk datas
    
    'Declare subs and functions
         declare sub SSFLoad          ()
         declare sub SSFSave          ()
         declare sub ActionEDIT       ()
         declare sub ActionABORT      ()
         declare sub ActionCONFIRM    ()
         declare sub ActionSWAP       (count as byte)         
         declare sub ActionUPDOWN     (Count as byte)
         declare sub ActionLEFTRIGHT  (Count as byte)
         declare sub ActionINSERT     ()
         declare sub ActionDELETE     ()
         declare sub RefreshSTATUS    (byval Text as string = "")
         declare SUB RefreshCHUNKS    ()
         declare sub RefreshCONTENT   ()
         declare sub RefreshSCROLL    ()
         declare sub RefreshSETTINGS  ()
    declare function HoldPress        (KeyScan as uinteger, Waiting as double) as ubyte
    declare function Desc             (ItemType as string, Offset as ushort)   as string

    'Read command line
    USER_SRCFILE = lcase(READCOMMANDLINE(RCMLN_ALLOWEMPTY + RCMLN_FORCEONE))
    if (USER_SRCFILE = "") then
      critical ("No source file."):end
    else
      if (right(USER_SRCFILE, len(USER_SRCFILE)-instrrev(USER_SRCFILE,".")) <> "ssf") then USER_SRCFILE += ".ssf" ' Add .ssf if required
    end if
    if (Dir(USER_SRCFILE) <> "") then SSFLoad()

    ' Display screen
    locate ,,0: screen 0,0,0:color 7,1:cls
    dim as string* 9 Revision = mid(__DATE__, 9,2)+mid(__DATE__, 1,2)+mid(__DATE__, 4,2)+".01"
    TMP_FILE = right(USER_SRCFile, len(USER_SRCFile)-instrrev(USER_SRCFile, "\"))
    color 0,7:  locate 1,1:  print space(80);: locate 1,3:  print "SSF Edit ";: color 8:print "(Rev: "+Revision+")";:color 0:locate ,77-len(TMP_FILE):print"["+ucase(TMP_FILE)+"]"
    color 15,1: for k as ubyte = 5 to 23: locate k,18:print chr(179);: next k
    RefreshSTATUS(): RefreshSCROLL(): RefreshCHUNKS (): RefreshSETTINGS(): RefreshCONTENT ()

    do
      if (PRG_EditMode = 0) then
        if HoldPress(&h4F, .2)  then ActionSWAP(1)        'Push chunk higher in the list
        if HoldPress(&h47, .2)  then ActionSWAP(-1)       'Push chunk lower in the list
        if HoldPress(&h1C, .1)  then ActionCONFIRM()      'From column1 to column2 or more...      
        if HoldPress(&h01, .2)  then ActionABORT()        'From column2 to column1 to exit
        if HoldPress(&h52, .1)  then ActionINSERT()       'New chunk
        if HoldPress(&h53, .1)  then ActionDELETE()       'Kill chunk
        if HoldPress(&h50, .08) then ActionUPDOWN(1)      'Go Down
        if HoldPress(&h48, .08) then ActionUPDOWN(-1)     'Go Up
        if HoldPress(&h51, .1)  then ActionUPDOWN(8)      'Go Down (fast)
        if HoldPress(&h49, .1)  then ActionUPDOWN(-8)     'Go Up (fast)
        if HoldPress(&h4D, .1)  then ActionLEFTRIGHT(1)   'Go right
        if HoldPress(&h4B, .1)  then ActionLEFTRIGHT(-1)  'Go left
      else
        ActionEDIT()
      end if
    loop

    '===========================================================================
    ' Edit field
    '===========================================================================
    sub ActionEDIT ()
      dim as ubyte      DTP = Pairs(PRG_SelContent).DataType
      dim as string     STRWorking, STRBackup, STRTemp, r
      if DTP = DT_BYTE then
        STRWorking = str(*Pairs(PRG_SelContent).Point2Byte)
      elseif (DTP = DT_STRING) then
        STRWorking = *Pairs(PRG_SelContent).Point2String
      elseif DTP = DT_SHORT then
        STRWorking = str(*Pairs(PRG_SelContent).Point2Short)
      end if
      STRBackup = STRWorking
      While Inkey <> "": Wend
      do
        r = inkey
        if (r <> "") then
          if (instr(ChrTable(Pairs(PRG_SelContent).AllowChr), r)) then STRWorking += r
          if r = chr(8)  then STRWorking = left(STRWorking,len(STRWorking)-1)
          if r = chr(27) then STRWorking = STRBackup
          if Pairs(PRG_SelContent).Limit then
            if (DTP = DT_BYTE) or (DTP = DT_SHORT) then
              RefreshStatus ("Highest value allowed: "+str(Pairs(PRG_SelContent).Limit))
              if (val(STRWorking) > Pairs(PRG_SelContent).Limit) then STRWorking = str(Pairs(PRG_SelContent).Limit)
            elseif (DTP = DT_STRING) then
              STRTemp = STRWorking: STRTemp = strsub(STRTemp, "\n", chr(10))
              if len(STRTemp) > (Pairs(PRG_SelContent).Limit) then
                STRWorking = left(STRWorking, len(STRWorking)-1)
                RefreshStatus ("String full")
              else
                RefreshStatus (str(Pairs(PRG_SelContent).Limit-len(STRTemp))+" characters left")
              end if
            end if
          end if
          if DTP = DT_BYTE then
            if val(STRWorking) < 0 then STRWorking = "0"
            *Pairs(PRG_SelContent).Point2Byte   = val(STRWorking)
          elseif (DTP = DT_STRING) then
            *Pairs(PRG_SelContent).Point2String = STRWorking
          elseif DTP = DT_SHORT then
            if val(STRWorking) < 0 then STRWorking = "0"
            *Pairs(PRG_SelContent).Point2Short  = val(STRWorking)
          end if
          RefreshCONTENT()
          if (r = chr(13)) or (r = chr(27)) then exit do 'ugly, but hell...
        end if
      loop
      While Inkey <> "": Wend
      do: loop while (multikey(&h1C) or multikey(&h01))
      PRG_EditMode = 0: RefreshContent()
    end sub
    
    '===========================================================================
    ' Delay inputs
    '===========================================================================
    function HoldPress(KeyScan as uinteger, Waiting as double) as ubyte
      static TimeElapse as double
      if multikey(KeyScan) then
        if (TIMER - TimeElapse) < Waiting then return 0
        TimeElapse = TIMER: return 1
      end if
    end function
    
    '===========================================================================
    ' Return item description (purely esthetical)
    '===========================================================================
    function Desc(ItemType as string, Offset as ushort) as string
      if lcase(ItemType) = "chunk" then
        if (Offset > ubound(PRG_Table.ChunkName)) or (Offset < lbound(PRG_Table.ChunkName)) then return UNDEFINED
        if (PRG_Table.ChunkName(Offset) = "") then return UNDEFINED
        return PRG_Table.ChunkName(Offset)
      elseif lcase(ItemType) = "pawnslot" then
        if (Offset > ubound(PRG_Table.PawnSlot)) or (Offset < lbound(PRG_Table.PawnSlot)) then return UNDEFINED
        if (PRG_Table.PawnSlot(Offset) = "") then return UNDEFINED
        return PRG_Table.PawnSlot(Offset)
      elseif lcase(ItemType) = "pawnitem" then
        if (Offset > ubound(PRG_Table.PawnItem)) or (Offset < lbound(PRG_Table.PawnItem)) then return UNDEFINED
        if (PRG_Table.PawnItem(Offset) = "") then return UNDEFINED
        return PRG_Table.PawnItem(Offset)
      end if
    end function

    '===========================================================================
    ' Edit chunk, edit content
    '===========================================================================
    sub ActionCONFIRM()
      if PRG_Column = 1 then
        if ubound(Chunks) = 0 then exit sub
        if (PRG_Column = 1) and (Desc("chunk", Chunks(PRG_SelChunk).ID) <> UNDEFINED) then
          PRG_Column = 2: RefreshSETTINGS(): RefreshCHUNKS(): RefreshSCROLL(): RefreshCONTENT()': RefreshSTATUS()
        end if
      elseif (PRG_Column = 2) then
        if (Pairs(PRG_SelContent).AllowChr <> CHR_NONE) then PRG_EditMode = abs(PRG_EditMode-1):RefreshCONTENT()
      end if
    end sub

    '===========================================================================
    ' Display stuff in the status bar
    '===========================================================================
    sub RefreshSTATUS(byval Text as string = "")
      color 15,3: locate 25,1: print space(80);
      if PRG_Column = 1 then
        locate 25,2:print "[INS]Create [UP/DN]Select [LF-RT]ChangeID [ENT]Edit [DEL]Delete [ESC]Quit";
      elseif PRG_Column = 2 then
        if text = "" then
          locate 25,2:print "[UP/DN]Select [LF-RT]Toggle [ESC]Confirm";
        else
          locate 25,2:print text;
        end if
      end if
      color 0,7
    end sub
  
    '===========================================================================
    ' Content to chunks and chunks to exit
    '===========================================================================
    sub ActionABORT()      
      if PRG_Column = 2 then
        PRG_Column = 1:PRG_ScrollContent = 0: PRG_SelContent = 0
      elseif PRG_Column = 1 then
        SSFSave(): end  '!! DEBUG !! We should print a warning first
      end if
      RefreshSTATUS(): RefreshCHUNKS(): RefreshCONTENT()
    end sub

    '===========================================================================
    ' Kill an existing chunk
    '===========================================================================
    sub ActionDELETE ()
      if PRG_Column = 1 then
        if ubound(Chunks) = 0 then exit sub
        if ubound(Chunks) = 1 then
          redim Chunks(0 to 0)
        else
          for k as ushort = PRG_SelChunk to ubound(Chunks)-1
            Chunks(k) = Chunks(k+1)
          next k
          redim preserve Chunks(1 to ubound(Chunks)-1)
        end if
        if PRG_SelChunk > ubound(Chunks) then PRG_SelChunk = ubound(Chunks)
        RefreshScroll(): RefreshCHUNKS(): RefreshSETTINGS(): RefreshCONTENT()
      end if
    end sub

    '===========================================================================
    ' Insert a new chunk after the currently selected chunk
    '===========================================================================
    sub ActionINSERT ()
      if (PRG_COLUMN = 1) then
        redim preserve Chunks(1 to ubound(Chunks)+1)
        Chunks(ubound(Chunks)).ID = 0
        if ubound(Chunks) = 1 then
          PRG_SELCHUNK = ubound(Chunks)
        else
          PRG_SELCHUNK += 1
          if PRG_SELCHUNK <> ubound(Chunks) then
            dim as ushort Counter = ubound(Chunks)-PRG_SELCHUNK         
            for k as ushort = 0 to Counter-1
              swap CHUNKS(ubound(Chunks)-k), CHUNKS((ubound(Chunks)-k)-1)
            next k
          end if
        end if
        RefreshSCROLL(): RefreshCHUNKS(): RefreshSETTINGS(): RefreshCONTENT()
      end if
    end sub

    '===========================================================================
    ' Move a chunk higher or lower in the list
    '===========================================================================
    sub ActionSWAP (count as byte)
      if PRG_Column = 1 then
        if ubound(Chunks) = 0 then exit sub
        if (count > 0) then
          if (PRG_SelChunk + abs(count)) > ubound(Chunks) then exit sub
        else
          if (PRG_SelChunk - abs(count)) < lbound(Chunks) then exit sub
        end if
        swap Chunks(PRG_SelChunk), Chunks(PRG_SelChunk + count)
        PRG_SelChunk += count
        RefreshCHUNKS()
      end if
    end sub

    '===========================================================================
    ' Handle left and right keys (generally: switch options)
    '===========================================================================
    sub ActionLEFTRIGHT (Count as byte)
      dim as ubyte Refresh
      if (PRG_COLUMN = 1) and (PRG_SelChunk <> 0) then
        dim as short CurrentChunkID = Chunks(PRG_SelChunk).ID
        if (count < 0) then
          if (CurrentChunkID-abs(Count) >= lbound(PRG_Table.ChunkName)) then Chunks(PRG_SelChunk).ID -= abs(Count): Refresh = 1
        else
          if (CurrentChunkID+abs(Count) <= ubound(PRG_Table.ChunkName)) then Chunks(PRG_SelChunk).ID += abs(Count): Refresh = 1
        end if
        if Refresh then RefreshCHUNKS(): RefreshSETTINGS(): RefreshCONTENT()
      elseif (PRG_COLUMN = 2) then
        if Pairs(PRG_SelContent).DataType = DT_BINARY then
          dim as ubyte PrevByte = *Pairs(PRG_SelContent).Point2Byte
          *Pairs(PRG_SelContent).Point2Byte = abs(Count > 0)
          if PrevByte <> *Pairs(PRG_SelContent).Point2Byte then Refresh = 1
        end if
        if Refresh then RefreshCONTENT()
      end if
    end sub

    '===========================================================================
    ' Adjust scrolling of chunk list or content list
    '===========================================================================
    sub RefreshSCROLL()
      if (PRG_COLUMN = 1) then
        if ubound(Chunks) = 0 then exit sub
        if PRG_SELCHUNK = 0 then PRG_SELCHUNK = 1 ' By default, we select chunk 0 (no chunk yet) -- if we load a file, we'll need to select chunk 1
        if (PRG_SELCHUNK) < (PRG_ScrollChunks) then PRG_ScrollChunks = PRG_SELCHUNK-1   'Because min val for SELCHUNK is 1 and SCROLLCHUNK is 0
        if (PRG_SELCHUNK) > (PRG_ScrollChunks+19) then PRG_ScrollChunks = PRG_SELCHUNK-19
      elseif (PRG_COLUMN = 2) then
        if ubound(Pairs) = 0 then PRG_ScrollContent = 0: PRG_SelContent = 0: exit sub
        if (PRG_SelContent) < (PRG_ScrollContent) then PRG_ScrollContent = PRG_SelContent 'Content starts at 0
        if (PRG_SelContent) > (PRG_ScrollContent+18) then PRG_ScrollContent = PRG_SelContent-18
      end if
    end sub

    '===========================================================================
    ' Go up or down in chunk list or content list
    '===========================================================================
    sub ActionUPDOWN (Count as byte)
      if (PRG_COLUMN = 1) and (ubound(Chunks)) then
        dim as ushort PrevSelChunk = PRG_SELCHUNK
        if count < 0 then
          if (PRG_SELCHUNK-abs(Count) >= lbound(Chunks)) then PRG_SELCHUNK -= abs(Count) else PRG_SELCHUNK = lbound(Chunks)
        else
          if (PRG_SELCHUNK+abs(Count) <= ubound(Chunks)) then PRG_SELCHUNK += abs(Count) else PRG_SELCHUNK = ubound(Chunks)
        end if
        if PrevSelChunk <> PRG_SELCHUNK then RefreshSCROLL(): RefreshCHUNKS(): RefreshSETTINGS(): RefreshCONTENT()
      elseif (PRG_COLUMN =2) and (ubound(Pairs)) then
        dim as ushort PrevSelContent = PRG_SelContent
        if count < 0 then
          if (PRG_SelContent-abs(Count) >= lbound(Pairs)) then PRG_SelContent -= abs(Count) else PRG_SelContent = lbound(Pairs)
        else
          if (PRG_SelContent+abs(Count) <= ubound(Pairs)) then PRG_SelContent += abs(Count) else PRG_SelContent = ubound(Pairs)
        end if
        if PrevSelContent <> PRG_SelContent then RefreshSCROLL(): RefreshCONTENT()
      end if
    end sub

    '===========================================================================
    ' Refresh chunk list
    '===========================================================================    
    SUB RefreshCHUNKS ()
      dim as string ChunkName
      if (PRG_COLUMN = 1) then
        color 15,1:locate 3,2:  print ":CHUNKS["+str(PRG_SelChunk)+"/"+str(ubound(Chunks))+"]   "
      else
        color 7,1:locate 3,2:   print " CHUNKS["+str(PRG_SelChunk)+"/"+str(ubound(Chunks))+"]   "
      end if: color 15,1: locate 5,2
      if (ubound(Chunks) = 0) then color 0,7: print "No chunk yet    ":exit sub
      for k as ushort = 1 to 19
        if ((PRG_ScrollChunks + k) >= lbound(Chunks)) and ((PRG_ScrollChunks + k) <= ubound(Chunks)) then
          ChunkName = str(Chunks(PRG_ScrollChunks+k).ID)+space(3-len(str(Chunks(PRG_ScrollChunks+k).ID)))
          ChunkName += Desc("chunk", Chunks(PRG_ScrollChunks+k).ID)
          ChunkName += space(16-len(ChunkName))
          if (PRG_ScrollChunks+k) = (PRG_SELCHUNK) then color 0,7 else Color 15,1
          locate 5+(k-1), 2:print ChunkName
        else
          color 15,1:locate 5+(k-1), 2:print space(16)
        end if
      next k
    end sub
    
    '===========================================================================
    ' Load SSF if possible (not yet extra safe, but close enough)
    '===========================================================================
    sub SSFLoad ()
      dim as string*3     SSF_Signature
      dim as ubyte        SSF_Version
      dim as ushort       SSF_Tables
      dim as string       SSF_TempString
      dim as ubyte        SSF_TempByte
      open USER_SRCFILE for binary as #1
      if lof(1) <= 6 then close #1:exit sub
      get #1,, SSF_Signature
      get #1,, SSF_Version
      get #1,, SSF_Tables
      if (SSF_Signature <> "SSF") or (SSF_Version <> 1) or (SSF_Tables = 0) then close #1:exit sub
      redim Chunks(1 to SSF_Tables)
      for k as ushort = 1 to SSF_Tables
        get #1,, Chunks(k).ID
        if Chunks(k).ID = 1 then
          get #1,, Chunks(k).Flag_Entries
          if Chunks(k).Flag_Entries then
            for l as ushort = 1 to Chunks(k).Flag_Entries '1 to 32
              get #1,, SSF_TempByte
              Chunks(k).Flag_Number(SSF_TempByte) = SSF_TempByte
              get #1,, Chunks(k).Flag_LabelSize(SSF_TempByte)
              if Chunks(k).Flag_LabelSize(SSF_TempByte) then
                SSF_TempString = space(Chunks(k).Flag_LabelSize(SSF_TempByte))
                get #1,, SSF_TempString
                SSF_TempString = STRSUB(SSF_TempString, chr(10), "\n")
                Chunks(k).Flag_Label(SSF_TempByte) = SSF_TempString
              end if
            next l
          end if
        elseif Chunks(k).ID = 2 then
          get #1,, Chunks(k).Logs_Entries
          if Chunks(k).Logs_Entries then
            for l as ushort = 0 to Chunks(k).Logs_Entries-1   '0 to 32
              get #1,, SSF_TempByte
              Chunks(k).Logs_BindFlag(SSF_TempByte) = SSF_TempByte
              get #1,, Chunks(k).Logs_MessageSize(SSF_TempByte)
              if Chunks(k).Logs_MessageSize(SSF_TempByte) then
                SSF_TempString = space(Chunks(k).Logs_MessageSize(SSF_TempByte))
                get #1,, SSF_TempString
                SSF_TempString = STRSUB(SSF_TempString, chr(10), "\n")
                Chunks(k).Logs_Message(SSF_TempByte) = SSF_TempString
              end if
            next l
          end if
        elseif Chunks(k).ID = 3 then
          get #1,, Chunks(k).Shop_ID
          for l as ushort = 1 to 8
            get #1,, SSF_TempByte
            for m as ushort = 1 to 8
              if (SSF_TempByte and SQUARE(m-1)) then Chunks(k).Shop_Available(((l-1)*8)+m) = 1 else Chunks(k).Shop_Available(((l-1)*8)+m) = 0
            next m
          next l
        elseif Chunks(k).ID = 4 then
          get #1,, Chunks(k).Shop_ID
          for l as ushort = 1 to 64
            get #1,, Chunks(k).Shop_Prices(l)
          next l
        elseif Chunks(k).ID = 16 then
          get #1,, Chunks(k).Meta_MessageSize
          if Chunks(k).Meta_MessageSize then
            SSF_TempString = space(Chunks(k).Meta_MessageSize)
            get #1,, SSF_TempString
            SSF_TempString = STRSUB(SSF_TempString, chr(10), "\n")
            Chunks(k).Meta_Message = SSF_TempString
          end if
        end if
      next k
      close #1
    end sub

    '===========================================================================
    ' Refresh settings (the content column is buffered from here)
    '===========================================================================
    sub RefreshSETTINGS ()
      PRG_SelContent = 0: PRg_ScrollContent = 0
      redim Pairs(0 to 0)
      if (Chunks(PRG_SelChunk).ID = 1) then     '------------- FLAGS -----------
        redim Pairs(0 to 31)
        for k as ushort = lbound(Pairs) to ubound(Pairs)
          Pairs(k).DataType = DT_STRING
          Pairs(k).Point2String = strptr(Chunks(PRG_SelChunk).Flag_Label(k+1))
          Pairs(k).WhatIS = "FLAG_"+str(k+1)+space(2-len(str(k+1)))+": "
          Pairs(k).Limit = 48
          Pairs(k).Descr = "Name for episode flag #"+str(k+1)+" (value: "+str(Square(k))+")"
          Pairs(k).AllowChr = CHR_STANDARD
        next k
      elseif (Chunks(PRG_SelChunk).ID = 2) then '------------ LOGS -------------
        redim Pairs(0 to 32)
        for k as ushort = lbound(Pairs) to ubound(Pairs)
          Pairs(k).DataType = DT_STRING
          Pairs(k).Point2String = strptr(Chunks(PRG_SelChunk).Logs_Message(k))
          Pairs(k).WhatIS = "LOG_"+str(k)+space(2-len(str(k)))+": "
          Pairs(k).Limit = 255
          Pairs(k).AllowChr = CHR_EXTENDED
          if k = 0 then
            Pairs(k).Descr = "Default log entry, always displayed"
          else
            Pairs(k).Descr = "Log entry unlocked when episode flag #"+str(k)+" is on"
          end if
        next k
      elseif (Chunks(PRG_SelChunk).ID = 3) then '-------- Shop stocks ----------
        redim Pairs(0 to 64)
        Pairs(0).DataType = DT_BYTE
        Pairs(0).Point2Byte = @Chunks(PRG_SelChunk).Shop_ID
        Pairs(0).WhatIs = "Shop ID: "
        Pairs(0).Limit = 255
        Pairs(0).Descr = "Shop ID number to be used with the pawn_o_matic entity"
        Pairs(0).AllowChr = CHR_NUMBERS
        for k as ushort = 1 to 64
          Pairs(k).AllowChr = CHR_NONE
          Pairs(k).DataType = DT_BINARY
          Pairs(k).Point2Byte = @Chunks(PRG_SelChunk).Shop_Available(k)
          Pairs(k).WhatIS = Desc("pawnitem", k)+": "
          Pairs(k).Descr = "Availability for item "+str(((k-1) mod 8)+1)+" ("+Desc("pawnitem", k)+") in section "+str(((k-1)\8)+1)+" ("+ucase(Desc("pawnslot", (((k-1)\8)+1)))+")"
        next k
      elseif (Chunks(PRG_SelChunk).ID = 4) then '----------- Shop prices -------
        redim Pairs(0 to 64)
        Pairs(0).DataType = DT_BYTE
        Pairs(0).Point2Byte = @Chunks(PRG_SelChunk).Shop_ID
        Pairs(0).WhatIs = "Shop ID: "
        Pairs(0).Limit = 255
        Pairs(0).Descr = "Shop ID number to be used with the pawn_o_matic entity"
        Pairs(0).AllowChr = CHR_NUMBERS
        for k as ushort = 1 to 64
          Pairs(k).AllowChr = CHR_NUMBERS
          Pairs(k).DataType = DT_SHORT
          Pairs(k).Point2Short = @Chunks(PRG_SelChunk).Shop_Prices(k)
          Pairs(k).WhatIS = Desc("pawnitem", k)+": $"
          Pairs(k).Descr = "Price for item "+str(((k-1) mod 8)+1)+" ("+Desc("pawnitem", k)+") in section "+str(((k-1)\8)+1)+" ("+ucase(Desc("pawnslot", (((k-1)\8)+1)))+")"
        next k            
      elseif (Chunks(PRG_SelChunk).ID =16) then '------------ Meta -------------
        redim Pairs(0 to 0)
        Pairs(0).DataType = DT_STRING
        Pairs(0).Point2String = strptr(Chunks(PRG_SelChunk).Meta_Message)
        Pairs(0).WhatIS = "META: "
        Pairs(0).Limit = 1024
        Pairs(0).Descr = "Random string of data"
        Pairs(0).AllowChr = CHR_EXTENDED
      end if
    end sub
    
    '===========================================================================
    ' Refresh content column (content must be buffered!)
    '===========================================================================    
    sub RefreshCONTENT ()
      if (PRG_COLUMN = 1) then
        color 7,1:locate 3,20:  print " CONTENT   "
      else
        color 15,1:locate 3,20:  print ":CONTENT   "
      end if: color 15,1
      if (ubound(Chunks)) = 0 then
        locate 5,20:print "No chunk yet (create one with INSERT)                       "
        for k as ubyte = 1 to 19:locate 5+k,20:print space(60);:next k:exit sub
      else
        if Desc("chunk",Chunks(PRG_SelChunk).ID) = UNDEFINED then
          locate 5,20:print "Undefined ChunkID (change ID with LEFT and RIGHT)           "
          for k as ubyte = 1 to 19:locate 5+k,20:print space(60);:next k:exit sub
        else
          if (PRG_EditMode = 0) then
            for k as ushort = 0 to 18
              if k+PRG_ScrollContent > ubound(Pairs) then
                locate 5+k,20: print space(60);
              else
                dim as short    LeftChars = 60-len(Pairs(k+PRG_ScrollContent).WhatIS)
                dim as string   TEMPString, Quotes = ""
                if (Pairs(k+PRG_ScrollContent).DataType = DT_BYTE) then
                  TEMPString = str(*Pairs(k+PRG_ScrollContent).Point2Byte)
                elseif (Pairs(k+PRG_ScrollContent).DataType = DT_STRING) then
                  TEMPString = *Pairs(k+PRG_ScrollContent).Point2String
                  LeftChars -= 2: Quotes = chr(34)  'We add Quotes to strings
                elseif (Pairs(k+PRG_ScrollContent).DataType = DT_SHORT) then
                  TEMPString = str(*Pairs(k+PRG_ScrollContent).Point2Short)
                elseif (Pairs(k+PRG_ScrollContent).DataType = DT_BINARY) then
                  if (*Pairs(k+PRG_ScrollContent).Point2Byte) then TEMPSTRING = "[AVAILABLE]" else TEMPSTRING = "[UNAVAILABLE]"
                end if
                if (PRG_SelContent = k+PRG_ScrollContent) and (PRG_Column = 2) then
                  RefreshSTATUS(Pairs(k+PRG_ScrollContent).Descr)
                  color 15,1: locate 5+k,20: print Pairs(k+PRG_ScrollContent).WhatIS+Quotes;
                  color 0,7:  print right(TEMPString, LeftChars);
                  color 15,1: print Quotes;
                else
                  color 7,1
                  locate 5+k,20: print Pairs(k+PRG_ScrollContent).WhatIS+Quotes+right(TEMPString, LeftChars)+Quotes;
                end if
                color ,1: print (space(1+LeftChars-len(right(TEMPString, LeftChars))))
              end if
            next k
          else
            dim as short    LeftChars = 60-len(Pairs(PRG_SelContent).WhatIS)
            dim as string   TEMPString, Quotes = ""
            if (Pairs(PRG_SelContent).DataType = DT_BYTE) then
              TEMPString = str(*Pairs(PRG_SelContent).Point2Byte)
            elseif (Pairs(PRG_SelContent).DataType = DT_STRING) then
              TEMPString = *Pairs(PRG_SelContent).Point2String
              LeftChars -= 2: Quotes = chr(34)
            elseif (Pairs(PRG_SelContent).DataType = DT_SHORT) then
              TEMPString = str(*Pairs(PRG_SelContent).Point2Short)
            end if
            color 15,1: locate 5+(PRG_SelContent-PRG_ScrollContent),20: print Pairs(PRG_SelContent).WhatIS+Quotes;
            color 0,7:  print right(TEMPString, LeftChars);
            color 15,1: print "_"+Quotes;
            color ,1: print (space(LeftChars-len(right(TEMPString, LeftChars))))
          end if
        end if
      end if
    end sub

    '===========================================================================
    ' Save SSF if possible
    '===========================================================================
    sub SSFSave ()
      dim as string*3     SSF_Signature = "SSF"
      dim as ubyte        SSF_Version   = 1, SSF_TempByte = 0
      dim as ushort       SSF_Tables, Count
      dim as string       SSF_TempString      
      if ubound(Chunks) = 0 then exit sub 'No chunks, skip
      
      for k as ushort = lbound(Chunks) to ubound(Chunks)  'Analyse each and every chunk
        Chunks(k).FLAG = 0            'Set as non valid by default
        if Chunks(k).ID = 1 then      'Episode flag
          Count = 0: for l as ushort = 1 to 32
            if (Chunks(k).Flag_Number(l) <> 0) and (Chunks(k).Flag_Label(l) <> "") then Count += 1
          next l
          if Count then Chunks(k).FLAG = CH_VALID    'If there's at least one flag defined, consider as valid
        elseif Chunks(k).ID = 2 then  'Log Flag
          Count = 0: for l as ushort = 0 to 32
            if (Chunks(k).Logs_Message(l) <> "") then Count += 1
          next l
          if Count then Chunks(k).FLAG = CH_VALID    'If there's at least one log defined, consider as valid
        elseif Chunks(k).ID = 3 then  'Shop (stocks)
          Chunks(k).FLAG = CH_VALID          'always valid, don't know how it could be different
        elseif Chunks(k).ID = 4 then  'Shop (prices)
          Chunks(k).FLAG = CH_VALID          'always valid, don't know how it could be different
        elseif Chunks(k).ID =16 then
          if (Chunks(k).Meta_Message <> "") then Chunks(k).FLAG = CH_VALID 'There's a message, consider as valid
        else
          Chunks(k).FLAG = 0  'chunk unknown, not valid
        end if
      next k
      for k as ushort = lbound(Chunks) to ubound(Chunks)
        if (Chunks(k).FLAG and CH_VALID) then SSF_Tables += 1
      next k

      if dir(USEr_SRCFILE) <> "" then kill USEr_SRCFILE
      open USER_SRCFILE for binary as #1
      put #1,, SSF_Signature
      put #1,, SSF_Version
      put #1,, SSF_Tables
      for k as ushort = lbound(Chunks) to ubound(Chunks)
        if (Chunks(k).FLAG and CH_VALID) then   'Only save valid chunks
          put #1,, Chunks(k).ID
          if Chunks(k).ID = 1 then
            Chunks(k).Flag_Entries = 0
            for l as ushort = 1 to 32
              if (Chunks(k).Flag_Number(l) <> 0) and (Chunks(k).Flag_Label(l) <> "") then Chunks(k).Flag_Entries += 1
            next l
            put #1,, Chunks(k).Flag_Entries
            for l as ushort = 1 to 32
              if (Chunks(k).Flag_Number(l) <> 0) and (Chunks(k).Flag_Label(l) <> "") then
                put #1,, Chunks(k).Flag_Number(l)
                SSF_TempString = Chunks(k).Flag_Label(l)
                Chunks(k).Flag_LabelSize(l) = len(SSF_TempString)
                put #1,, Chunks(k).Flag_LabelSize(l)
                put #1,, SSF_TempString
              end if
            next l
          elseif Chunks(k).ID = 2 then
            Chunks(k).Logs_Entries = 0
            for l as ushort = 0 to 32
              if (Chunks(k).Logs_Message(l) <> "") then Chunks(k).Logs_Entries += 1
            next l          
            put #1,, Chunks(k).Logs_Entries
            for l as ushort = 0 to 32
              if (Chunks(k).Logs_Message(l) <> "") then
                put #1,, Chunks(k).Logs_BindFlag(l)
                SSF_TempString = strsub(Chunks(k).Logs_Message(l), "\n", chr(10))
                Chunks(k).Logs_MessageSize(l) = len(SSF_TempString )
                put #1,, Chunks(k).Logs_MessageSize(l)
                put #1,, SSF_TempString
              end if
            next l
          elseif Chunks(k).ID = 3 then
            put #1,, Chunks(k).Shop_ID
            for l as ushort = 1 to 8
              SSF_TempByte = 0
              for m as ushort = 1 to 8
                if Chunks(k).Shop_Available(((l-1)*8)+m) then SSF_TempByte += SQUARE(m-1)
              next m
              put #1,, SSF_TempByte
            next l
          elseif Chunks(k).ID = 4 then
            put #1,, Chunks(k).Shop_ID
            for l as ushort = 1 to 64
              put #1,, Chunks(k).Shop_Prices(l)
            next l
          elseif Chunks(k).ID = 16 then
            SSF_TempString  = strsub(Chunks(k).Meta_Message, "\n", chr(10))
            Chunks(k).Meta_MessageSize = len(SSF_TempString)
            put #1,, Chunks(k).Meta_MessageSize
            put #1,, SSF_TempString
          end if
        end if
      next k
      close #1      
    end sub
