// BARREN MEADOW
#include "g_local.h"
#include "voice_punk.h"

voice_table_t dale_lines [] =
	{
	// 0 to 3 - idle (4)
	{NULL, "Are you lost or something'?",														"Are you lost or something'?",														"actors/male/dale/idle1.wav",			0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "If I were you I'd stay clear of the deranged.",					"If I were you I'd stay clear of the deranged.",					"actors/male/dale/idle2.wav",			0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Man! My socks are WET!",																"Man! My socks are WET!",																	"actors/male/dale/idle3.wav",			0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "I'm so hungry I could eat a rat...",										"I'm so hungry I could eat a rat...",											"actors/male/dale/idle4.wav",			0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 4 to 5 - question (2)
	{NULL, "Wanna buy a priceless mystery key? Twenty five bucks.",	"Wanna buy a priceless mystery key? Twenty five bucks.",	"actors/male/dale/askcash1.wav",	0,{0,0,0,0,0},0,0, TT_QUESTION},
	{NULL, "How 'bout a shiny key? Twenty five bucks only!",				"How 'bout a shiny key? Twenty five bucks only!",					"actors/male/dale/askcash2.wav",	0,{0,0,0,0,0},0,0, TT_QUESTION},
	// 6 - agreed (1)
	{NULL, "Ah! Always a pleasure.",																"Ah! Always a pleasure.",																	"actors/male/dale/gotcash1.wav",	0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 7 to 8 - refused (2)
	{NULL, "Ain't nobody got money for ol' Dale.",									"Ain't nobody got money for ol' Dale.",										"actors/male/dale/nocash1.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "I know, I know, I heard that before.",									"I know, I know, I heard that before.",										"actors/male/dale/nocash2.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 9 to 10 - insulted (2)
	{NULL, "Aye! You don't scare me!",															"Aye! You don't scare me!",																"actors/male/dale/pissed1.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	{NULL, "Remember you asked for it!",														"Remember you asked for it!",															"actors/male/dale/pissed2.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	// 11 to 13 - scared (3)
	{NULL, "Please don't hurt me!",																	"Please don't hurt me!",																	"actors/male/dale/scared1.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	{NULL, "Stay away!",																						"Stay away!",																							"actors/male/dale/scared2.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	{NULL, "Put that thing down!",																	"Put that thing down!",																		"actors/male/dale/scared3.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	};

#if 0
voice_table_t chip_lines [] =
	{
	// 0 to 3 - idle (4)
	{NULL, "Arnie's dog is drivin' me fucking crazy!",		"Arnie's dog is drivin' me  @*%$#! crazy!",			"actors/male/chip/upset1.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "This fucking mutt, I swear!",									"You lost or something'?",											"actors/male/chip/upset2.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Bitch needs a muzzle, know what I mean?",			"You lost or something'?",											"actors/male/chip/upset3.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "I haven't slept in three days for Christ's sake!",	"You lost or something'?",								"actors/male/chip/upset4.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 4 to 7 - idle (4)
	{NULL, "You hear that? No more barking!",							"You hear that? No more barking!",							"actors/male/chip/relief1.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "You hear that? No more barking!",							"You hear that? No more barking!",							"actors/male/chip/relief2.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "You hear that? No more barking!",							"You hear that? No more barking!",							"actors/male/chip/relief3.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "You hear that? No more barking!",							"You hear that? No more barking!",							"actors/male/chip/relief4.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 8 - agreed (1)
	{NULL, "Man! You're stone cold.",											"Man! You're stone cold.",											"actors/male/chip/jobdone1.wav",	0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 9 to 11 - insulted (3)
	{NULL, "Fuck off with that shit.",                    "@*%$#! off with that @*%$#!.",                 "actors/male/chip/pissed1.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	{NULL, "Get lost asshole!",                           "Get lost @*%$#!",                              "actors/male/chip/pissed2.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	{NULL, "Eat shit, bitch!",                            "Eat @*%$#!, @*%$#!",                           "actors/male/chip/pissed3.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	// 12 to 13 - scared (2)
	{NULL, "Drop your fucking weapon",										"Drop your @*%$#! weapon",											"actors/male/chip/scared1.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	{NULL, "Put that shit down",													"Put that @*%$#! down",													"actors/male/chip/scared2.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE}
	};
	#endif
	
voice_table_t jeda_lines [] =
	{
	// 0 to 2 - random idle (3)
	{NULL, "Hey you gonna buy a drink or what?",																					"Hey you gonna buy a drink or what?",																					"actors/male/jeda/idle1.wav",			0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "We don't often get visitors around here.",																		"We don't often get visitors around here.",																		"actors/male/jeda/idle2.wav",			0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Don't mind the rats, they're part of the scenery.",														"Don't mind the rats, they're part of the scenery.",													"actors/male/jeda/idle3.wav",			0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 3 to 4 - decline (2)
	{NULL, "Alright. Lemme know if you need somethin'.",																	"Alright. Lemme know if you need somethin'.",																	"actors/male/jeda/decline1.wav",	0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Silent type, uh? I don't blame ya'.",																					"Silent type, uh? I don't blame ya'.",																				"actors/male/jeda/decline2.wav",	0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 5 to 8 - insult (4)
	{NULL, "Hey! How about a tall glass of bleach? Nah?",																	"Hey! How about a tall glass of bleach? Nah?",																"actors/male/jeda/pissed1.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	{NULL, "Fuck you! I'm only nice to you because you're a customer.",										"@*%$#! you! I'm only nice to you because you're a customer.",								"actors/male/jeda/pissed2.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	{NULL, "Uh you're just like a real little bitch! You're all barks and no bite.",			"Uh you're just like a real little @*%$#! You're all barks and no bite.",			"actors/male/jeda/pissed3.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	{NULL, "If you ain't gonna buy a drink, you can fuck right off buddy.",								"If you ain't gonna buy a drink, you can @*%$#! right off buddy.",						"actors/male/jeda/pissed4.wav",		0,{0,0,0,0,0},0,0, TT_NEGATIVE},
	// 9 - didn't visit old house 
	{NULL, "I've never seen you before. You lookin' for something?",											"I've never seen you before. You lookin' for something?",											"actors/male/jeda/question1.wav",	0,{0,0,0,0,0},0,0, TT_QUESTION},
	// 10- didn't visit cemetery
	{NULL, "You didn't find what you're looking for. Am I right?",												"You didn't find what you're looking for. Am I right?",												"actors/male/jeda/question2.wav",	0,{0,0,0,0,0},0,0, TT_QUESTION},
	// 11- no more bike
	{NULL, "You still here? You really kicked the hornet nest, uh?",											"You still here? You really kicked the hornet nest, uh?",											"actors/male/jeda/question3.wav",	0,{0,0,0,0,0},0,0, TT_QUESTION},
	// 12 (main hint) then 13 to 16 - go visit the old house (4)
	{NULL, "If I were looking for someone, I'd check the old house.",											"If I were looking for someone, I'd check the old house.",										"actors/male/jeda/house1.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Every time someone's gone missing, this is where we find the mangled body.",	"Every time someone's gone missing, this is where we find the mangled body.",	"actors/male/jeda/house2.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "I heard there is a huge stash of cash behind a painting in there",						"I heard there is a huge stash of cash behind a painting in there",						"actors/male/jeda/house3.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Watch your back, the deranged are nasty fuckers.",														"Watch your back, the deranged are nasty @*%$#!.",														"actors/male/jeda/house4.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "They turn themselves blind so they can focus on the voices in their head",		"They turn themselves blind so they can focus on the voices in their head",		"actors/male/jeda/house5.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 17 (main hint) then 18 to 20 - go visit the cemetery (2)
	{NULL, "They hang around the cemetery at night, this should help.",										"They hang around the cemetery at night, this should help.",									"actors/male/jeda/boneyard1.wav",	0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Last night the gravedigger got so wasted the dumbass forgot his keys.",				"Last night the gravedigger got so wasted the @*%$#! forgot his keys.",				"actors/male/jeda/boneyard2.wav",	0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "They crash in a crypt deep within the boneyard.",															"They crash in a crypt deep within the boneyard.",														"actors/male/jeda/boneyard3.wav",	0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Bring a flashlight with you.",																								"Bring a flashlight with you.",																								"actors/male/jeda/boneyard4.wav",	0,{0,0,0,0,0},0,0, TT_POSITIVE},
	// 21 (main hint) then 22 to 24 - leave through the woods (3)
	{NULL, "Take this and use the backdoor. Run though the woods and follow the track.",	"Take this and use the backdoor. Run though the woods and follow the track.",	"actors/male/jeda/woods1.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "It's muddy and dark but the woods are your best bet.",												"It's muddy and dark but the woods are your best bet.",												"actors/male/jeda/woods2.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Right now would be the right time to spend your cash on guns.",								"Right now would be the right time to spend your cash on guns.",							"actors/male/jeda/woods3.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	{NULL, "Man, that's all I've got for you. Good luck.",																"Man, that's all I've got for you. Good luck.",																"actors/male/jeda/woods4.wav",		0,{0,0,0,0,0},0,0, TT_POSITIVE},
	};

// This replaces the episode-specific code for handling Momo (the bouncer)
void GenericMomo_GotMoney(edict_t *self, edict_t *other, response_t response)
	{
	if (game.serverflags & SFL_MOMO_TOOK_MONEY)
		return;

	switch (response)
		{
		case resp_yes:
			Voice_Player_Specific(self, TT_YES);
			Voice_Random (self, other, player_money_yes, NUM_PLAYER_MONEY_YES); // yes
			break;
		case resp_no:
			Voice_Player_Specific (self, TT_NO);
			Voice_Random (self, other, player_money_no, NUM_PLAYER_MONEY_NO); // no
			break;
		}

	self->response_ent = other;
	self->last_response_time = level.time;
	self->last_response = response;
	}

// This replaces the episode-specific code for handling Momo (the bouncer)
void GenericMomo_Check (edict_t *ent, cast_memory_t *mem)
	{
	if (game.serverflags & SFL_MOMO_ASKED_MONEY)
		mem->inc++;
	}

// Defined in g_spawn.c
char *ED_NewString (char *string);

// This replaces the episode-specific code for handling Momo (the bouncer)
void GenericMomo_Initialize (edict_t *self)
	{
	// Invincible and can see through glass
	self->cast_info.aiflags |= AI_IMMORTAL;

	// Never show guns (I'm not sure that's needed anymore)
	self->s.model_parts[PART_GUN].invisible_objects = (1<<0 | 1<<1);
	self->s.model_parts[PART_GUN2].invisible_objects = (1<<0 | 1<<1);

	// Force neutral
	self->cast_group = 0;

	// We need a door to unlock
	if (!self->target2)
		{
		switch (level.episode)
			{
			case EP_SKIDROW:
				self->target2 = ED_NewString("bardoor_sr");
				break;
			case EP_POISONVILLE:
				self->target2 = ED_NewString("bardoor_pv");
				break;
			case EP_SHIPYARDS:
				self->target2 = ED_NewString("bardoor_sy");
				break;
			case EP_STEELTOWN:
				self->target2 = ED_NewString("bardoor_st");
				break;
			case EP_RADIOCITY:
				self->target2 = ED_NewString("bardoor_rc");
				break;
			default:
				self->target2 = ED_NewString("bardoor");
				break;
			}
		}

	// We also need a greeting (index in momo_specific[])
	if (!self->sounds)
		{
		switch (level.episode)
			{
			case EP_SKIDROW:
				self->sounds = 0;
				break;
			case EP_POISONVILLE:
				self->sounds = 17;
				break;
			case EP_SHIPYARDS:
				self->sounds = 19;
				break;
			case EP_STEELTOWN:
				self->sounds = 18;
				break;
			case EP_RADIOCITY:
				self->sounds = 20;
				break;
			}
		}
	}

// This replaces the episode-specific code for handling Momo (the bouncer)
qboolean GenericMomo_Process (edict_t *self, edict_t *other)
	{
	cast_memory_t	*mem;	
	mem = level.global_cast_memory[self->character_index][other->character_index];

	// get the fuck out of my foyer
	if (mem->flags & MEMORY_LASTWARNING)
		{
		Voice_Random (self, other, &momo_specific[13], 2);
		return true;
		}

	// Ridah, 5-8-99, we've already taken their money, so say one of the following..
	if (game.serverflags & SFL_MOMO_TOOK_MONEY)
		{
		// ACC, if we went to the ladies' bathroom (special entity to put in the ladie's restroom)
		if (game.serverflags & SFL_MOMO_LADIES)
			{
			Voice_Specific(self, other, momo_specific, 11);			// and stay out of the ladies bathroom you fuckin' pervert
			game.serverflags &= ~SFL_MOMO_LADIES; // don't mention it anymore
			return true;
			}
		if (!(mem->flags & MEMORY_ASSHOLE))
			Voice_Random (self, other, &momo_specific[12], 2);		// so what's it gonna be... in or out?
		else // they've cussed us, don't act all happy to see them
			Voice_Random (self, other, &momo_specific[13], 2);		// get the fuck out of my foyer
		return true;
		}

	// first time we see the player, welcome and drop the name of the place
	if (!(game.serverflags & SFL_MOMO_FIRST_TIME))
		{
		Voice_Specific (self, other, momo_specific, self->sounds); // ACC, default greetings (see voice_punk.c)
		game.serverflags |= SFL_MOMO_FIRST_TIME;
		return true;
		}

	// Ridah, 5-8-99, I changed this so it clears this flag in EP_CastSight() if Momo sees you after not having seen you for a while
	if (!(game.serverflags & SFL_MOMO_ASKED_MONEY))
		{
		if (!mem->inc)
			{
			if (!(mem->flags & MEMORY_ASSHOLE))
				{
				Voice_Random (self, other, &momo_specific[1], 3); // 10 dollar cover charge
				mem->inc = 1;
				}
			else
				{
				Voice_Specific (self, other, momo_specific, 5);		// now it's 20 bucks!
				mem->inc = 2;
				}
			}
		else
			Voice_Specific (self, other, momo_specific, 9); // you're back

		game.serverflags |= SFL_MOMO_ASKED_MONEY;
		mem->response = GenericMomo_GotMoney;
		
		return true;
		}

	// have they responded yet?
	else if ((other->response_ent == self) && (other->last_response_time > (level.time - 5)))
		{
		if (other->last_response == resp_yes)
			{	
			edict_t	*door = NULL;
			int	i, cost;

			if (mem->flags & MEMORY_ASSHOLE)
				{
				if (mem->inc < 3)
					cost = 20;
				else
					cost = 30;
				}
			else
				cost = 10;

			// have we really have money to give?
			if (other->client->pers.currentcash >= cost)
				{
				other->client->pers.currentcash -= cost;
				self->currentcash += cost;
				game.serverflags |= SFL_MOMO_TOOK_MONEY;
				Voice_Specific(self, other, &momo_specific[0], 10);	// go on in

				// Search for anything locked that uses the provided target2
				for (i = 1, door = g_edicts + i; i < globals.num_edicts; i++, door++)
					{
					if ((door->targetname) && (!strcmp(door->targetname, self->target2)) && (door->key == -1))
						{
						door->key = 0;
						door->targetname = NULL;
						}
					}
				}
			else
				Voice_Random(self, other, &momo_specific[7], 2);	// see me later when you got the money
			}
		else	// they said no
			Voice_Random(self, other, &momo_specific[13], 3);

		other->last_response_time = 0;	// so we don't process this response again

		mem->response = NULL;
		other->response_ent = NULL;

		return true;
		}

	else 
		{
		if (mem->flags & MEMORY_ASSHOLE)
			{
			if (!(mem->flags & MEMORY_UPSET))
				{
				mem->flags |= MEMORY_UPSET;
				if (mem->inc < 3)
					Voice_Specific (self, other, momo_specific, 5);
				else	// 30 bucks for you now!
					Voice_Specific (self, other, momo_specific, 6);
				}
			else
				{
				Voice_Random (self, other, &momo_specific[12], 4); 
				// This needs to be here, or Momo will never take the money when mad
				if (momo_specific[12].last_played == level.time)
					mem->response = GenericMomo_GotMoney;
				}
			}
		else
			{
			Voice_Random (self, other, &momo_specific[12], 5); 
			if (momo_specific[12].last_played == level.time)
				mem->response = GenericMomo_GotMoney;
			}
		}
	return true;
	}

void GenericMomo_Sight(edict_t *self, edict_t *other, cast_memory_t *mem)
	{
	// haven't seen them for a while
	if (mem->timestamp < (level.time - 8))
		game.serverflags &= ~SFL_MOMO_ASKED_MONEY;

	// give them a chance to make friends if they holster
	if (mem->memory_type == MEMORY_TYPE_ENEMY)
		{	
		self->enemy = NULL;
		AI_RemoveFromMemory(self, mem); // make them a neutral instead of enemy
		AI_AddToMemory(self, mem, MEMORY_TYPE_NEUTRAL);
		mem->flags &= ~MEMORY_HOSTILE_ENEMY;
		}
	}

qboolean EP_BarrenMeadow_CastSight (edict_t *self, edict_t *other, cast_memory_t *mem)
	{
	switch (self->name_index)
		{
		/*** JEDA - Barman ***/
		case NAME_JEDA:
			if (!other->client)
				return false; // ignore NPCs

		/*** CAIN & ABEL - Henchmen ***/
		/*case NAME_CAIN:
		case NAME_ABEL:
			return true;*/

		/*** GIDEON - Boss ***/
		case NAME_GIDEON:
			return true;

		/*** BLAKE - Goon with two dogs in cemetery ***/
		/*case NAME_BLAKE:
			return true;*/

		/*** CHIP - Dog killer ***/
		#if 0
		case NAME_CHIP:
			if (!other->client)
				return false; // ignore other NPCs
		#endif

		/*** DALE - Cemetery bum in hub ***/
		case NAME_DALE:
			if (!other->client)
				return false; // ignore other NPCs

			if (!(other->client->pers.holsteredweapon))
				{
				mem->flags |= MEMORY_AFRAID;
				if ((mem->flags & MEMORY_AFRAID) && (other->client->pers.weapon))
					{
					// if running, don't say or do anything
					if (self->cast_info.currentmove->frame->aifunc == ai_run)
						return true;

					// cower
					if (!(mem->flags & MEMORY_HOSTILE_ENEMY))
						{
						if ((level.time > mem->not_holstered_attack_time)	&& (level.time < (mem->not_holstered_attack_time + 5)))
							{
							if (!(self->cast_info.aiflags & AI_NO_TALK))
								{
								self->cast_info.aiflags |= AI_NO_TALK;
								Voice_Random(self, other, &dale_lines[9], 2); // insulted
								}
							}
						else if (level.time > mem->not_holstered_attack_time)
							{
							Voice_Random(self, other, &dale_lines[11], 3); // scared
							mem->not_holstered_attack_time = level.time + 5;
							if ((self->cast_info.currentmove->frame->aifunc == ai_stand) &&	(self->cast_info.move_avoid_walk && self->cast_info.move_avoid_crwalk))
								self->cast_info.avoid(self, other, true);
							}
						}

					// if we're standing around, turn to face them
					if (self->cast_info.currentmove->frame->aifunc == ai_stand)
						{
						vec3_t vec;

						VectorSubtract(other->s.origin, self->s.origin, vec);
						VectorNormalize(vec);
						self->ideal_yaw = vectoyaw(vec);

						M_ChangeYaw(self);
						}

					// evade?
					if (self->cast_info.currentmove->frame->aifunc == ai_stand && self->cast_info.move_stand_evade && (self->moral < MORAL_AGGRESSIVE))
						{
						self->cast_info.currentmove = self->cast_info.move_stand_evade;
						self->last_stand_evade = level.time;
						}
					return true;
					}
				}
			else
				{
				self->cast_info.aiflags &= ~AI_NO_TALK;
				mem->flags &= ~MEMORY_AFRAID;
				}
			return false;
		}

	// Generic bum
	if ((self->spawnflags & 1) && (!Q_stricmp(self->classname, "cast_bum_sit")))
		{
		if (other->client && (mem->memory_type == MEMORY_TYPE_ENEMY) && !(other->client->pers.weapon)) // give chance to make friends
			{
			self->enemy = NULL;
			AI_RemoveFromMemory(self, mem);
			AI_AddToMemory(self, mem, MEMORY_TYPE_NEUTRAL);
			mem->flags &= ~MEMORY_HOSTILE_ENEMY;
			}
		return true; // ignore them
		}

	return false;
	}

// Player (self) answers Jeda's (other) offer for help
void EPresp_Jeda(edict_t *self, edict_t *other, response_t response)
	{
	switch (response)
		{
		case resp_yes:
			Voice_Player_Specific(self, TT_YES);
			Voice_Specific(self, other, player_answer, 1); // yes
			break;
		case resp_no:
			Voice_Player_Specific (self, TT_NO);
			Voice_Specific(self, other, player_answer, 0); // no
			break;
		}
	self->response_ent = other;
	self->last_response_time = level.time;
	self->last_response = response;
	}

// Player (self) answers Dale's (other) request for money.
void EPresp_Dale(edict_t *self, edict_t *other, response_t response)
	{
	switch (response)
		{
		case resp_yes:
			Voice_Player_Specific(self, TT_YES);
			if (!(self->episode_flags & EP_BM_DALE_GOT_MONEY))
				{
				if (self->client->pers.currentcash >= 25)
					{
					Voice_Random(self, other, player_money_yes, NUM_PLAYER_MONEY_YES);
					/*
					// it is possible to screw this up if the player moves out of Dale's sight, so I'm moving this
					// to the other part of the code
					self->client->pers.currentcash -= 25;
					other->currentcash += 25;
					EP_Shared_Register_EPFLAG(self, EP_BM_DALE_GOT_MONEY);
					*/
					break;
					}
				}
		case resp_no:
			response = resp_no; // force response to "no", just in case we failed the requirements for the "yes" branching above
			Voice_Player_Specific(self, TT_NO);
			Voice_Random(self, other, player_money_no, NUM_PLAYER_MONEY_NO); // generic "ain't got enough"
		}

	self->response_ent = other;
	self->last_response_time = level.time;
	self->last_response = response;
	}

// This routine handles how characters react to things they're told. "Other" is the speaker, "self" is
// the listener and "saywhat" is say_neutral, say_hostile or say_flashlight -- yes, the flashlight
// beam sight is handled here. Most of the time, other must be client. This routine quickly becomes a
// mess of branching stuff, so good luck reading it. I decided to create more routines for each character
// because I really can't be bothered stuffing everything here. Since it should only be checked when a
// "talk" action is processed, it shouldn't be a huge cost.
qboolean EP_BarrenMeadow_EventSpeech (edict_t *self, edict_t *other, int saywhat)
	{
	cast_memory_t	*mem;
	mem = level.global_cast_memory[self->character_index][other->character_index];

	// Default reaction to flashlight, we put it in here so it only occurs if we aren't already angry at them
	if ((saywhat == say_flashlight) && (self->enemy != other))
		{
		cast_memory_t	*mem, *premem;
		// get the memory of this "other" character before we record the sighting
		premem = level.global_cast_memory[self->character_index][other->character_index];
		AI_RecordSighting(self, other, VectorDistance(self->s.origin, other->s.origin));
		// get the post sighting memory
		mem = level.global_cast_memory[self->character_index][other->character_index];
		// if we recorded a new sighting (or hadn't seen them in a while), and they are hostile...
		return ((!premem || (premem->timestamp < (level.time - 10))) && (mem->flags & MEMORY_HOSTILE_ENEMY));
		}

	// Actor-specific reaction
	switch (self->name_index)
		{
		/*case NAME_CAIN: // Henchman
		case NAME_ABEL: // Henchman
			return false;*/
			//return EPspeech_Cain(self, other, saywhat);
		case NAME_GIDEON: // Boss
			return false;
			//return EPspeech_Gideon(self, other, saywhat);
		/*case NAME_BLAKE: // Goon with two dogs in cemetery
			return false;*/
			//return EPspeech_Blake(self, other, saywhat);

		/*
		JEDA, barman -- For some fucking reason, sometime, the barman will "hang" on a question. The player
		will be able to spam the "yes" and "no" answers and he won't respond to it. As far as I can tell,
		after waiting for 20 seconds, the whole thing resets and Jeda will ask the question again, unlocking
		the situation. Still, it's frustrating and wanky as fuck!
		*/
		case NAME_JEDA:
			{
			if (!other->client)
				return true; // pretend we responded to NPCs so we don't trigger common chit-chat

			switch (saywhat)
				{
				case say_neutral:
					{
					int askQuestion = 0;

					/* Test for possible question */
					if ((other->episode_flags & EP_BM_NO_BIKE) && (!(other->episode_flags & EP_BM_VISIT_WOODS)) && (((level.time - jeda_lines[11].last_played) > 20) || (jeda_lines[11].last_played == 0)))
						askQuestion = 11; // Bike is missing, player doesn't know about woods yet, and we haven't asked for a while...
					else if ((other->episode_flags & EP_BM_CADAVER_ATTIC) && (!(other->episode_flags & EP_BM_VISIT_CEMETERY)) && (((level.time - jeda_lines[10].last_played) > 20) || (jeda_lines[10].last_played == 0)))
						askQuestion = 10; // Player saw the old house, player doesn't know about cemetery yet, and we haven't asked for a while...
					else if (!(other->episode_flags & EP_BM_CADAVER_ATTIC) && (!(other->episode_flags & EP_BM_VISIT_MADHOUSE)) && (((level.time - jeda_lines[9].last_played) > 20) || (jeda_lines[9].last_played == 0)))
						askQuestion = 9; // Player didn't see the old house, doesn't know about it yet, and we haven't asked for a while...
					if (askQuestion)
						{
						Voice_Specific(self, other, jeda_lines, askQuestion);
						mem->response = EPresp_Jeda;
						return true;
						}

					/* Can't ask question now, check for player answer */
					if ((other->response_ent == self) && (other->last_response_time > (level.time - 5)))
						{
						// Player declined help
						if (other->last_response == resp_no)
							Voice_Random(self, other, &jeda_lines[3], 2); // alright, lemme know if you need somethin'
						else
							{
							// bike was stolen, tell player to go through the woods, give key
							if ((other->episode_flags & EP_BM_NO_BIKE) && (!(other->episode_flags & EP_BM_VISIT_WOODS)))
								{
								int     index;
								gitem_t *item;
								// Give key
								item = FindItem("StoreRoomKey");
								index = ITEM_INDEX(item);
								other->client->pers.inventory[index]++;
								other->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(item->icon);
								other->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS + index;
								other->client->pickup_msg_time = level.time + 5.5;
								// Add note to road book, tell player to check woods
								EP_Shared_Register_EPFLAG (other, EP_BM_VISIT_WOODS);
								Voice_Specific(self, other, jeda_lines, 21);
								}
							// player visited the old house, tell him to go to the cemetery, give key
							else if ((other->episode_flags & EP_BM_CADAVER_ATTIC) && (!(other->episode_flags & EP_BM_VISIT_CEMETERY)))
								{
								int     index;
								gitem_t *item;
								// Give key
								item = FindItem("Cemetery_Key");
								index = ITEM_INDEX(item);
								other->client->pers.inventory[index]++;
								other->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(item->icon);
								other->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS + index;
								other->client->pickup_msg_time = level.time + 5.5;
								// Write to road book, tell player to check cemetery
								EP_Shared_Register_EPFLAG (other, EP_BM_VISIT_CEMETERY);
								Voice_Specific (self, other, jeda_lines, 17);
								}
							// player hasn't visited the old house, hint
							else if (!(other->episode_flags & EP_BM_VISIT_MADHOUSE))
								{
								EP_Shared_Register_EPFLAG (other, EP_BM_VISIT_MADHOUSE);
								Voice_Specific (self, other, jeda_lines, 12);
								}
							}
						mem->response = NULL; // unload processing routine
						other->response_ent = NULL; // player doesn't have to talk with anyone anymore
						other->last_response_time = 0;	// ignore when was the last reponse
						return true; // we're done
						}

					/* Player didn't answer, we can't ask question, just throw random idle lines */
					if (other->episode_flags & EP_BM_VISIT_WOODS)
						Voice_Random(self, other, &jeda_lines[22], 3); // player has been told about the woods, give random hint about that only
					else if ((other->episode_flags & EP_BM_VISIT_CEMETERY) && (!(other->episode_flags & EP_BM_LEAVE_TOWN)))
						Voice_Random(self, other, &jeda_lines[18], 3); // player has been told about the cemetery and didn't complete that level, give random hints
					else if ((other->episode_flags & EP_BM_VISIT_MADHOUSE) && (!(other->episode_flags & EP_BM_CADAVER_ATTIC)))
						Voice_Random(self, other, &jeda_lines[13], 4); // player has been told about the house and didn't complete that level, give random hints
					else
						Voice_Random(self, other, &jeda_lines[0], 3); // player didn't ask about anything, random talk
					mem->response = NULL; // unload processing routine
					other->response_ent = NULL; // player doesn't have to talk with anyone anymore
					other->last_response_time = 0;	// ignore when was the last reponse
					return true;
					}

				// Jeda says something mean (doesn't hold a grudge)
				case say_hostile:
					Voice_Random (self, other, &jeda_lines[5], 4); // insulted
					mem->flags &= ~MEMORY_ASSHOLE;
					return true;
				}
			break;
			}

		/*
		CHIP, the guy with a hate boner for Arnie's dog in bm_hub
		*/
		#if 0
		case NAME_CHIP:
			{
			if (!other->client)
				return true; // pretend we responded

			switch (saywhat)
				{
				// Chip says something neutral
				case say_neutral:
					// Chip got the dog collar
					if (other->episode_flags & EP_BM_CHIP_GOT_COLLAR)
						{
						Voice_Random (self, other, &chip_lines[4], 4); // relief idle
						return true; // we're done
						}
					// Chip didn't get the dog collar yet
					else
						{
						// Player has the collar in his inventoy!
						if (other->client->pers.inventory[ITEM_INDEX(FindItem("Dog_Collar"))])
							{
							int     index;
							gitem_t *item;

							// Take dog collar
							item = FindItem("Dog_Collar");
							index = ITEM_INDEX(item);
							other->client->pers.inventory[index]--;

							// Give reward
							item = FindItem ("Cash");
							index = ITEM_INDEX (item);
							gi.sound (other, CHAN_AUTO, gi.soundindex("world/pickups/cash.wav"), 1, ATTN_NORM, 0);		
							other->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(item->icon);
							other->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS+index;
							other->client->pickup_msg_time = level.time + 5.5;
							other->client->pers.currentcash += self->currentcash;
							self->currentcash = 0;

							// Thank and register job done
							Voice_Specific(self, other, chip_lines, 8);
							EP_Shared_Register_EPFLAG (other, EP_BM_CHIP_GOT_COLLAR);
							return true;
							}
						// Player doesn't have dog collar in inventory, register request and use random "I'm pissed" idle sentences
						EP_Shared_Register_EPFLAG (other, EP_BM_CHIP_ASKED_COLLAR);
						Voice_Random (self, other, &chip_lines[0], 4);
						return true; // we're done
						}

				// Chip says something mean, after a while, he should downright attack the player
				case say_hostile:
					Voice_Random (self, other, &chip_lines[9], 3); // insulted
					return true;
				}
			break;
			}
		#endif

		/*
		DALE, bum near the cemetery gate in bm_hub
		*/
		case NAME_DALE:
			{
			if (!other->client)
				return true; // pretend we responded

			switch (saywhat)
				{
				// Dale says something neutral
				case say_neutral:
					// If Dale didn't ask for money yet, OR didn't receive money AND hasn't been asking for a while, then beg for money.
					if (/*((dale_lines[4].last_played == 0) && (dale_lines[5].last_played == 0)) ||*/ // Dale didn't ask for money yet, OR
						(!(other->episode_flags & EP_BM_DALE_GOT_MONEY) &&                         // Dale didn't receive money yet and
						((dale_lines[4].last_played == 0) || (level.time - dale_lines[4].last_played) > 30) && // he hasn't asked for a while...
						((dale_lines[5].last_played == 0) || (level.time - dale_lines[5].last_played) > 40)) )
						{
						mem->response = EPresp_Dale; // this routine will catch the player's answer
						Voice_Random(self, other, &dale_lines[4], 2); // ask question (play sound)
						EP_Shared_Register_EPFLAG (other, EP_BM_DALE_ASKED_MONEY); // Dale asked for money (make a note in road book)
						return true; // we're done
						}
					// Dale doesn't have to ask for money (either he has it, or he asked recently)
					else
						{
						// The player responded recently, so something must have been processed by EPresp_Dale()
						if ((other->response_ent == self) && (other->last_response_time != 0)) // Fire as soon as possible.
							{
							// Dale gives key in exchange
							if (other->last_response == resp_yes)
								{
								int     index;
								gitem_t *item;

								// Moved away from EPresp_Dale because it is possible the character will not respond if we move out of sight.
								other->client->pers.currentcash -= 25;
								self->currentcash += 25;
								EP_Shared_Register_EPFLAG(other, EP_BM_DALE_GOT_MONEY);

								// Add key to player inventory, show icon and name on status bar
								item = FindItem("Garage_Key");
								index = ITEM_INDEX(item);
								other->client->pers.inventory[index]++;
								other->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex(item->icon);
								other->client->ps.stats[STAT_PICKUP_STRING] = CS_ITEMS + index;
								other->client->pickup_msg_time = level.time + 5.5;

								Voice_Specific(self, other, dale_lines, 6); // agreed
								}
							else
								Voice_Random(self, other, &dale_lines[7], 2); // refused

							mem->response = NULL; // unload processing routine
							other->response_ent = NULL; // player doesn't have to talk with anyone anymore
							other->last_response_time = 0;	// ignore when was the last reponse
							return true; // we're done
							}

						// player didn't respond recently and we don't feel like asking for money, just say something randomly
						mem->response = NULL; // unload answer processing routine, just in case the player left Dale hanging
						Voice_Random (self, other, &dale_lines[0], 4); // idle
						return true; // we're done
						}

				// Dale says something mean (he responds to insults but doesn't hold a grudge)
				case say_hostile:
					Voice_Random (self, other, &dale_lines[9], 2); // insulted
					mem->flags &= ~MEMORY_ASSHOLE;
					return true;
				}
			break;
			}
		}

	// Bums, generic behavior (works for both saywhat == say_neutral, say_hostile or even say_flashlight)
	if (!Q_stricmp(self->classname, "cast_bum_sit") && (self->spawnflags & 1))
		{
		Voice_Random (self, other, rummy, 4);
		return true;
		}

	// Nothing
	return false;
	}

void EP_BarrenMeadow_Flags (edict_t *self)
	{	}

qboolean EP_BarrenMeadow_CastUse (edict_t *self, edict_t *other, edict_t *activator)
	{	return false;	}

void EP_BarrenMeadow_ItemPickup (edict_t *self, edict_t *other)
	{	}

void EP_BarrenMeadow_Script (edict_t *ent, char *scriptname)
	{	}

int	EP_BarrenMeadow_HiredGuysFlags (edict_t *player, edict_t *self)
	{	return true;	}

qboolean EP_BarrenMeadow_DoKey (edict_t *self, edict_t *other)
	{	return false;	}

qboolean EP_BarrenMeadow_UnlockDoorFlag (edict_t *ent)
	{	return false;	}

void EP_BarrenMeadow_HiredGuysRegisterFlags (edict_t *ent, edict_t *other)
	{	}

void EP_BarrenMeadow_SpecialEventDeath (edict_t *self)
	{	}

void EP_BarrenMeadow_ReachedDoKey (edict_t *self)
	{	}

void EP_BarrenMeadow_EndDoKey (edict_t *self)
	{	}

void EP_BarrenMeadow_Check_DoKey (edict_t *self, edict_t *ent)
	{	}