-- hypov8
-- will animate a quake2 model into a kingpin usable model
-- load md2 body and weapon
-- select the 2 files. press convert

-- quake2 animations are very limited compare dto kingpin. some odd animations will exist and need to be changed manualy
-- quake2 also uses only 1 model part. 
-- 		you can chose to export model as a complet part(eg body) but you must export a tiny triangle for the other parts
--		otherwise the model needs to be split into 3 parts and exported seperatly


utility QuakeMD2_To_Kingpin "Q2 to Kingpin"
(
	local array_kp_Anims=#()
	local array_Q2_Anims=#() --txt file with 25 leg/body events (structure(start,end)
	local array_body_wep=#() --selected models to process
	local array_timeTags=#()	 -- max 'time tag' names

	-- q2 animation file indexed names
	local Q2_STAND		= 1 as integer 
	local Q2_RUN			= 2 as integer 
	local Q2_ATTACK 	= 3 as integer 
	local Q2_PAIN1		= 4 as integer 
	local Q2_PAIN2		= 5 as integer 
	local Q2_PAIN3		= 6 as integer 
	local Q2_JUMP		= 7 as integer 
	local Q2_FLIP			= 8 as integer 
	local Q2_SALUTE		= 9 as integer 
	local Q2_TAUNT		= 10 as integer 
	local Q2_WAVE		= 11 as integer 
	local Q2_POINT		= 12 as integer 
	local Q2_CRSTAND	= 13 as integer 
	local Q2_CRWALK	= 14 as integer 
	local Q2_CRATTACK	= 15 as integer 
	local Q2_CRPAIN		= 16 as integer 
	local Q2_CRDEATH	= 17 as integer 
	local Q2_DEATH1		= 18 as integer 
	local Q2_DEATH2		= 19 as integer 
	local Q2_DEATH3		= 20 as integer 
	
	--"Taunt Animation"
	group "Replacement Animations"
	(
		radiobuttons UI_rBtn_taunt "Taunt:"  align:#left  labels:#("WAVE    (Taunt Anim)", "SALUTE  (Taunt Anim)")  default:1	tooltip:("Taunt:\n" +
												"Quake 2 has 4 taunts and kingpin has 3\nChoose desired animation")		
		radiobuttons UI_rBtn_attack "Runing Attack:"  align:#left  labels:#("RUN        (Run Only)", "ATTACK  (Attack Only)")  default:1	tooltip:("Running Attack:\n"+
												"Quake 2 does not have a attack while running\n\n"+
												"RUN\n show runnig but no attack.\nThis is ok if gun faces forward.\n"+
												"Or if you want to manualy edit the vertex later.\n\n" +
												"ATTACK\nWill have player sliding around but gun will shoot\n"	+
												"Use this if model has been animated to move while shooting")
		radiobuttons UI_rBtn_strafe "Strafe:"  align:#left  labels:#("RUN        (Run Only)", "ATTACK  (Attack Only)")   default:1	tooltip:("Strafe:\n" +
												"Kingpin strafe and strafe/shoot use the same animation\n"+
												"Choose desired Q2 animation to use")	
		radiobuttons UI_rBtn_ladder "Ladder:"  align:#left  labels:#("CROUCH (Crouch Idle)", "JUMP       (Jump Anim)")   default:1	tooltip:("Ladders:\n" +
												"Select best fit replacement")													
												
	)
	
	
	checkbox UI_ChkBox_x "Scale" across:2 checked:true  align:#left tooltip:"Scale model up to suit kingpin"
	spinner UI_Num_Scale "*" range:[1.0,2.0,1.4] scale:0.1 tooltip:"scale default 1. quake 2 about 1.4x" align:#left 
	
	
	button UI_btn_DoConversion "  Convert  " align:#centre --across:1 --height:18
	
	
	--q2 anims structure	
	struct frame_num_q2(	start,	total_fr)
	
	--kp anims structure
	struct frame_num_KP(	start,	end,	head,	wep,	legs,	body	)
	
	--time tags structure
	struct struc_timetag(	tname, ttime )
	
	fn Set_timeTag_array =
	(
		append array_timeTags(struc_timetag 	tname: "tgun_rdy_"			ttime: 0	)
		append array_timeTags(struc_timetag 	tname: "tg_shoot_"			ttime: 32	)
		append array_timeTags(struc_timetag 	tname: "tg_bird_"				ttime: 37	)
		append array_timeTags(struc_timetag 	tname: "tg_crch_grab_"	ttime: 47	)
		append array_timeTags(struc_timetag 	tname: "tg_chin_flip_"		ttime: 63	)
		append array_timeTags(struc_timetag 	tname: "1pstl_rdy_"			ttime: 78	)
		append array_timeTags(struc_timetag 	tname: "p_std_shoot_"		ttime: 101	)
		append array_timeTags(struc_timetag 	tname: "walk_gdown_"		ttime: 105	)
		append array_timeTags(struc_timetag 	tname: "walk_tg_sht_"		ttime: 115	)
		append array_timeTags(struc_timetag 	tname: "run_tg_sht_"		ttime: 125	)
		append array_timeTags(struc_timetag 	tname: "rsd_tg_run_"		ttime: 131	)
		append array_timeTags(struc_timetag 	tname: "lsd_tg_run_"		ttime: 137	)
		append array_timeTags(struc_timetag 	tname: "p_walk_sht_"		ttime: 143	)
		append array_timeTags(struc_timetag 	tname: "p_run_shoot_"		ttime: 153	)
		append array_timeTags(struc_timetag 	tname: "p_rside_run_"		ttime: 159	)
		append array_timeTags(struc_timetag 	tname: "p_lside_run_"		ttime: 165	)
		append array_timeTags(struc_timetag 	tname: "melee_rdy_"			ttime: 171	)
		append array_timeTags(struc_timetag 	tname: "melee1_"				ttime: 190	)
		append array_timeTags(struc_timetag 	tname: "melee2_"				ttime: 197	)
		append array_timeTags(struc_timetag 	tname: "run_melee_"			ttime: 203	)
		append array_timeTags(struc_timetag 	tname: "run_gun_dn_"		ttime: 209	)
		append array_timeTags(struc_timetag 	tname: "jump_"				ttime: 215	)
		append array_timeTags(struc_timetag 	tname: "clmb_loop_"			ttime: 222	)
		append array_timeTags(struc_timetag 	tname: "death1_"				ttime: 231	)
		append array_timeTags(struc_timetag 	tname: "death2_"				ttime: 250	)
		append array_timeTags(struc_timetag 	tname: "death3_"				ttime: 266	)
		append array_timeTags(struc_timetag 	tname: "death4_"				ttime: 294	)
		append array_timeTags(struc_timetag 	tname: "tg_crch_rdy_"		ttime: 307	)
		append array_timeTags(struc_timetag 	tname: "crouch_shoot_"	ttime: 334	)
		append array_timeTags(struc_timetag 	tname: "crch_walk_"			ttime: 340	)
		append array_timeTags(struc_timetag 	tname: "1p_crch_rdy_"		ttime: 345	)
		append array_timeTags(struc_timetag 	tname: "p_crch_sht_"		ttime: 363	)
		append array_timeTags(struc_timetag 	tname: "p_crch_walk_"		ttime: 368	)
		append array_timeTags(struc_timetag 	tname: "crouch_death_"	ttime: 373	)
	)
	--set time tags for kp
	fn setTimeTags =
	(
		if FrameTagManager.GetTagCount() == 0 then
		(
			for i=0 to  (array_timeTags.count - 1 ) do
			(
				local ttime = array_timeTags[i+1].ttime
				local tname = array_timeTags[i+1].tname
				
				FrameTagManager.CreateNewTag tname ttime
				
			)	
			
		)
	)	
	
	
	-- q2 animation set. start, total_fr
	fn SetQ2Frames=
	(	
		append array_Q2_Anims (frame_num_q2 start:0	total_fr:40)	-- Q2_STAND
		append array_Q2_Anims (frame_num_q2 start:40	total_fr:6)		-- Q2_RUN
		append array_Q2_Anims (frame_num_q2 start:46	total_fr:8)		-- Q2_ATTACK
		append array_Q2_Anims (frame_num_q2 start:54	total_fr:4)		-- Q2_PAIN1
		append array_Q2_Anims (frame_num_q2 start:58	total_fr:4)		-- Q2_PAIN2
		append array_Q2_Anims (frame_num_q2 start:62	total_fr:4)		-- Q2_PAIN3
		append array_Q2_Anims (frame_num_q2 start:66	total_fr:6)		-- Q2_JUMP
		append array_Q2_Anims (frame_num_q2 start:72	total_fr:12)	-- Q2_FLIP
		append array_Q2_Anims (frame_num_q2 start:84	total_fr:11)	-- Q2_SALUTE
		append array_Q2_Anims (frame_num_q2 start:95	total_fr:17)	-- Q2_TAUNT
		append array_Q2_Anims (frame_num_q2 start:112	total_fr:11)	-- Q2_WAVE
		append array_Q2_Anims (frame_num_q2 start:123	total_fr:12)	-- Q2_POINT
		append array_Q2_Anims (frame_num_q2 start:135	total_fr:19)	-- Q2_CRSTAND
		append array_Q2_Anims (frame_num_q2 start:154	total_fr:6)		-- Q2_CRWALK
		append array_Q2_Anims (frame_num_q2 start:160	total_fr:9)		-- Q2_CRATTACK
		append array_Q2_Anims (frame_num_q2 start:169	total_fr:4)		-- Q2_CRPAIN
		append array_Q2_Anims (frame_num_q2 start:173	total_fr:5)		-- Q2_CRDEATH
		append array_Q2_Anims (frame_num_q2 start:178	total_fr:6)		-- Q2_DEATH1
		append array_Q2_Anims (frame_num_q2 start:184	total_fr:6)		-- Q2_DEATH2
		append array_Q2_Anims (frame_num_q2 start:190	total_fr:8)		-- Q2_DEATH3
	)
	
	-- kp animations set, start, end, q2 animation set
	fn SetKPFrames=
	(
		-- kingpin multi player model ani set
		append array_kp_Anims (frame_num_KP start:0  	end:31		body:Q2_STAND)			--	ok
		append array_kp_Anims (frame_num_KP start:32	end:36		body:Q2_ATTACK)		--	ok
		append array_kp_Anims (frame_num_KP start:37	end:46		body:Q2_WAVE)			--	ok	10
		append array_kp_Anims (frame_num_KP start:47	end:62		body:Q2_TAUNT)			--	ok	16
		append array_kp_Anims (frame_num_KP start:63	end:77		body:Q2_FLIP)			--	ok	15
		append array_kp_Anims (frame_num_KP start:78	end:100		body:Q2_STAND)			--	ok *missing* pistol
		append array_kp_Anims (frame_num_KP start:101	end:104		body:Q2_ATTACK)		--	ok *missing* pistol
		append array_kp_Anims (frame_num_KP start:105	end:114		body:Q2_RUN	)			--	ok *missing* slow	
		append array_kp_Anims (frame_num_KP start:115	end:124		body:Q2_ATTACK)		--	*missing* slot+walking
		append array_kp_Anims (frame_num_KP start:125	end:130		body:Q2_ATTACK)		--	--*missing* run
		append array_kp_Anims (frame_num_KP start:131	end:136		body:Q2_RUN)				--	ok~ *missing* side	
		append array_kp_Anims (frame_num_KP start:137	end:142		body:Q2_RUN)				--	ok~ *missing* side	
		append array_kp_Anims (frame_num_KP start:143	end:152		body:Q2_ATTACK)		--	--*missing* slow+walk
		append array_kp_Anims (frame_num_KP start:153	end:158		body:Q2_ATTACK)		--	--*missing* running	pistol
		append array_kp_Anims (frame_num_KP start:159	end:164		body:Q2_RUN)				--	ok~ *missing* sidestep
		append array_kp_Anims (frame_num_KP start:165	end:170		body:Q2_RUN	)			--	ok~ *missing* sidestep
		append array_kp_Anims (frame_num_KP start:171	end:189		body:Q2_STAND)			--	ok *missing*
		append array_kp_Anims (frame_num_KP start:190	end:196		body:Q2_ATTACK)		--	--*missing* crowbar
		append array_kp_Anims (frame_num_KP start:197	end:202		body:Q2_ATTACK)		--	--*missing* crowbar2
		append array_kp_Anims (frame_num_KP start:203	end:208		body:Q2_RUN)				--	ok *missing* crowbar
		append array_kp_Anims (frame_num_KP start:209	end:214		body:Q2_RUN)				--	ok
		append array_kp_Anims (frame_num_KP start:215	end:221		body:Q2_JUMP)			--	ok
		append array_kp_Anims (frame_num_KP start:222	end:230		body:Q2_CRSTAND)		--	--*missing* 1frame crch?
		append array_kp_Anims (frame_num_KP start:231	end:249		body:Q2_DEATH1)		--	ok 19 frames
		append array_kp_Anims (frame_num_KP start:250	end:265		body:Q2_DEATH2)		--	ok 16 frames
		append array_kp_Anims (frame_num_KP start:266	end:293		body:Q2_DEATH3)		--	ok 28 frames
		append array_kp_Anims (frame_num_KP start:294	end:306		body:Q2_DEATH2)		--	ok 13 frames
		append array_kp_Anims (frame_num_KP start:307	end:333		body:Q2_CRSTAND)		--	ok
		append array_kp_Anims (frame_num_KP start:334	end:339		body:Q2_CRATTACK)	--	ok	
		append array_kp_Anims (frame_num_KP start:340	end:344		body:Q2_CRWALK)		--	ok	
		append array_kp_Anims (frame_num_KP start:345	end:362		body:Q2_CRSTAND)		--	ok *missing*
		append array_kp_Anims (frame_num_KP start:363	end:367		body:Q2_CRATTACK)	--	ok *missing*
		append array_kp_Anims (frame_num_KP start:368	end:373		body:Q2_CRWALK)		--	ok *missing*
		append array_kp_Anims (frame_num_KP start:374	end:385		body:Q2_CRDEATH)		--	ok
	)	
	
	--
	fn mapTheKeys theTime theArg = 
	(
		theTime + theArg --= (theTime) as float
			--print("time= " + ((theTime ) as string))
			
	)
	
	fn get_tagent_type_fn key_f q3_current_f q3_total_f =
	(
		if (q3_current_f == 0) then --first frame
		(
			key_f.inTangentType = #step
			key_f.outTangentType =#linear
		)
		else if q3_current_f >= (q3_total_f - 1) then --last frame
		(
			key_f.inTangentType = #linear
			key_f.outTangentType = #step
		)
		else	--any frame between
		(
			key_f.inTangentType = #linear 
			key_f.outTangentType = #linear
		)
	)
	
	--
	fn moveModelKeys_fn selected_md3_f offsetFrame_q3_f=
	(
		--clearSelection()
		print("moving ANIMATION SET keys----- PLEASE WAIT!!!")	
		
		for obj_index in selected_md3_f do
		(	
			--progress_cnt2 = 0 as integer
			local aniset_kp_count = 0 as integer
			local count = 0	
			
			(
				--suspendEditing()
				snaptarget = obj_index
				tempname = uniqueName ("KP_" + snaptarget.name + "_")
				forcesnapshot = snapshot obj_index name:tempname
				convertTo forcesnapshot Editable_Mesh
				forcesnapshot.controller = snaptarget.controller
				--resumeEditing()
				animateVertex forcesnapshot #all
				--bakeRange = (animationRange.end - animationRange.start).frame as integer
				sourceObj = snaptarget
				targetObj = forcesnapshot
				InstanceMgr.MakeControllersUnique targetObj targetObj.controller #prompt 
				
				masterCtrl = targetObj[4][1]
				deleteKeys masterCtrl #allKeys --todo does root work?
			)
			
			
			-- loop through all kp animation sequences
			for aniset_kp in array_kp_Anims do
			(
				local deathanim = false
				count += 1
				format "--aniset_kp=%" count
				--frame_num_KP start:0  	end:31		body:Q2_STAND
				
				local modelIndex_q3 = aniset_kp.body
				
				-- varable animations
				(
					-- taunt
					if UI_rBtn_taunt.state == 2 and  
						modelIndex_q3 == Q2_WAVE then
							modelIndex_q3 =  Q2_SALUTE
					-- attack/run
					if UI_rBtn_attack.state == 2 and  
					(count == 10 or count == 14  or count == 20)then -- run_tg_sht_ + p_run_shoot_
							modelIndex_q3 =  Q2_ATTACK	
					-- strafe
					if UI_rBtn_strafe.state == 2 and  
					(count == 11 or count == 12 or  count == 15 or count == 16 ) then
							modelIndex_q3 =  Q2_ATTACK
					-- ladders
					if UI_rBtn_ladder.state == 2 and  count == 23 then
							modelIndex_q3 =  Q2_JUMP					
					
				)				
				-- end varable animations	
			
				local frames_total_kp = (aniset_kp.end - aniset_kp.start+1) as integer
				local frames_total_q3 = array_Q2_Anims[modelIndex_q3].total_fr as integer
				local frame_start_kp = aniset_kp.start as integer
				local frame_end_kp = aniset_kp.end as integer
				
				local frameID_start_q3 = (offsetFrame_q3_f + array_Q2_Anims[modelIndex_q3].start) as integer
				local frameID_end_q3 = (frameID_start_q3 + array_Q2_Anims[modelIndex_q3].total_fr - 1) as integer
				--local frameID_start_kp = ( frame_start_kp - frameID_start_q3) as integer
				--local frameID_end_kp = ( frame_start_kp - frameID_start_q3) as integer
				
				--print("kp count=" +count as string+" q2Index=" +modelIndex_q3 as string)

				-- taunt anims (debug)
				--if (count != 3 ) and (count != 4)and (count != 5) then
					--continue				
				
				--death anims (debug)
				--if (count != 24 ) and (count != 25)and (count != 26)and (count != 27) then
				--	continue
				
				--make animations exactly frame for frame
				if 	modelIndex_q3 == Q2_CRDEATH or 	modelIndex_q3 == Q2_DEATH1 or 
					modelIndex_q3 == Q2_DEATH2 or 	modelIndex_q3 == Q2_DEATH3 or
					modelIndex_q3 == Q2_WAVE  or 	modelIndex_q3 == Q2_TAUNT or 
					/*modelIndex_q3 == Q2_FLIP or */		modelIndex_q3 == Q2_SALUTE then
						deathanim = true
				
				if 	modelIndex_q3 == Q2_WAVE  or 	modelIndex_q3 == Q2_TAUNT or 
					/*modelIndex_q3 == Q2_FLIP or*/ 		modelIndex_q3 == Q2_SALUTE then
						frames_total_q3 -= 1

				-- get every q3 keyframe. paste to kp frame%
				for q3_key = 0 to  frames_total_q3 do
				(
					local offset_q2
					local time_kp
					local time_q3
					
					if q3_key == 0 then
					(
						time_kp = frame_start_kp
						time_q3	= 	frameID_start_q3				
					)
					else	if (q3_key == (frames_total_q3 - 1)) and not deathanim then 
					(
						time_kp = frame_end_kp
						time_q3	= 	frameID_end_q3							
					)
					else if (q3_key <= (frames_total_q3 - 1)) then
					(		
						local tween_fr =	( (frames_total_kp - 1 as Double) / (frames_total_q3 - 1 as Double) ) as Double --was (frames_total_q3--1)
						tween_fr *= (q3_key ) as Double 
						if deathanim then 
							tween_fr = q3_key as integer
						time_kp = (frame_start_kp + tween_fr)  as float
						time_q3 = (frameID_start_q3 + q3_key )	 as integer	
					)
					else	if deathanim then	-- death animations, 1 extra last frame
					(	
						--print("--using death anim--")
						time_kp = frame_end_kp  as integer
						time_q3 = (frameID_start_q3 + (q3_key - 1))  as integer
					)
					else
					(
						--print("--skip death anim--")
						exit -- non death animations
					) -- end q3_keys setup
					
					--print("kpFrameTime=" + time_kp as string)
					
					progressUpdate (count /27*100)
					-- copy q2 to kp verts 
					for i in 1 to targetObj.numVerts do 
					(
						k = addNewKey masterCtrl[i].controller time_kp
						get_tagent_type_fn k q3_key frames_total_q3 
						k.value = at time time_q3 in coordSys sourceObj getVert sourceObj i
					)	
					progressUpdate (count /27*100)
				)
				--exit	-- do 1 set
-----------------------------------	
			)
			
					-- scale model
		if UI_ChkBox_x.checked then
		(
			local kp_floor_matrix =	(matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,-24])		--kp floor  origin
			local resizeVal = UI_Num_Scale.value

			about kp_floor_matrix scale targetObj [resizeVal, resizeVal, resizeVal]
		)
			
			
		) -- end objects
		
		--todo delet q2 keys
		--todo set tween type
		print("moving ANIMATION SET keys Done-----")
	) --end function copy keys
	
	fn setupObjectsAsGroups =	
	(
		array_body_wep=#()
		for obj in selection do
		(
			append array_body_wep obj		
			print("---- adding selections obj=")
		) -- end adding each mesh object to array

	)--end function set model groups
	
	-- inital loading of script... Do
	on QuakeMD2_To_Kingpin open do 
	(		
		SetQ2Frames()
		SetKPFrames()
		Set_timeTag_array()
	) --end on load script
	
	-- ui button convert
	on UI_btn_DoConversion pressed do
	(
		UI_btn_DoConversion.enabled = false
		suspendEditing()
		progressStart ("Model Converting")
		progressUpdate (5)
		--clearSelection()
		setupObjectsAsGroups()
		if (array_body_wep.count >= 1) then
		(	
			setTimeTags()
			animationrange = interval 0 400
			
			-- move keyframes to end(out of kp range)		
			offsetFrame_q3 = 1
			moveModelKeys_fn 	array_body_wep 	offsetFrame_q3
		)
		else
		(
			messagebox("ERROR.. no models selected")
		)

		resumeEditing()
		progressEnd()
		UI_btn_DoConversion.enabled = true	
		--IU_status.caption = "Status:  Done"	
		
		max views redraw
	)-- end button do convert

) -- end utility