-- hypov8
-- will animate a q3 model into a kingpin usable model
-- load md3 models. legs, body, head then weapon
-- load the animation file
-- convert

--<node>.isSelected Boolean default: false 

utility QuakeMD3_To_Kingpin "Q3 to Kingpin"
(

	local array_frameFileQ3=#() --txt file with 25 leg/body events (structure(start,end)
	
	local array_legs=#()
	local array_body=#()
	local array_head=#()
	local array_wep=#()
	local array_kp_Anims=#()
 
	-- q3 animation file indexed names
	local BOTH_DEATH1 = 1 as integer 
	local BOTH_DEAD1 = 2 as integer 
	local BOTH_DEATH2 = 3 as integer 
	local BOTH_DEAD2 = 4 as integer 
	local BOTH_DEATH3 = 5 as integer 
	local BOTH_DEAD3 = 6 as integer 
	local TORSO_GESTURE = 7 as integer 
	local TORSO_ATTACK = 8 as integer 
	local TORSO_ATTACK2 = 9 as integer 
	local TORSO_DROP = 10 as integer 
	local TORSO_RAISE = 11 as integer 
	local TORSO_STAND = 12 as integer 
	local TORSO_STAND2 = 13 as integer 
	local LEGS_WALKCR = 14 as integer 
	local LEGS_WALK = 15 as integer 
	local LEGS_RUN = 16 as integer 
	local LEGS_BACK = 17 as integer 
	local LEGS_SWIM = 18 as integer 
	local LEGS_JUMP = 19 as integer 
	local LEGS_LAND = 20 as integer 
	local LEGS_JUMPB = 21 as integer 
	local LEGS_LANDB = 22 as integer 
	local LEGS_IDLE = 23 as integer 
	local LEGS_IDLECR = 24 as integer 
	local LEGS_TURN = 25 as integer 
	
	local HEAD_NULL = 1 as integer 
	local WEP_NULL = 1  as integer 

 	-- forward the body parts group for functions
	local  MODEL_LEGS = 1  as integer
	local  MODEL_HEAD = 2  as integer
	local  MODEL_BODY = 3 as integer
	local  MODEL_WEPS = 4 as integer
	
	local	tag_legs_nodeID = undefined
	--local	tag_body_nodeID= undefined
	local	tag_head_nodeID = undefined
	local	tag_wep_nodeID = undefined
	

	
	local progresss_percent
	local progress_cnt2 = 0 as integer
	
	button UI_btn_GetFile "Load Q3 Animation.cfg  " tooltip:"select file" align:#left across:1 height:22
	checkbox UI_useFrameRateForDeath "Use Q3 FPS for Death" checked:false align:#left height:16 tooltip:("Enable: Death Animations Speeds are calculated\nfrom q3 animation fps\n"+
																																"Disable: will squeeze/stretch animation to fit into kp ")
	
	button UI_btn_DoConversion "Convert Q3 model to KP" align:#left across:1 height:22 tooltip:("Created new objects with name KP_*" +
																																"\nWill search all non hidden items with names\ntag_* \nL_* \nH_* \nU_* \nw_* ")
	label IU_status "Status:  done" style_sunkenedge:true align:#centre height:16 width:130
																														
	--progressbar UI_PBar_percent height:20 color:white --value:50
	
	struct frame_num_q3
	(
		start,
		total_fr,
		fps
	)
	
	struct frame_num_KP
	(
		start,
		end,
		head,
		wep,
		legs,
		body
	)
	
	--keyframe tangents
	struct key_tangnt
		(
			outTangentType,
			inTangentType
		)
		
	fn get_tagent_type_fn key_f q3_current_f q3_total_f =
	(
		--local k --=#(key_tangnt inTangentType:#step outTangentType:#step )
		
		if (q3_total_f == 1) then 	
		(--only 1 keyFrame
			key_f.inTangentType = #step 
			key_f.outTangentType = #step
		)
		else if (q3_current_f == 0) then --first frame
		(
			key_f.inTangentType = #step
			key_f.outTangentType =#linear
		)
		else if (q3_current_f >= (q3_total_f - 1)) then --last frame
		(
			key_f.inTangentType = #linear
			key_f.outTangentType = #step
		)
		else	--any frame between
		(
			key_f.inTangentType = #linear 
			key_f.outTangentType = #linear
		)
		--return q3_current_f
	)
	
	--leg tag_torco
	fn addkeyROT_world_fn targetObj_f sourceObj_f time_kp_f time_q3_f q3_key_f frames_total_q3_f=
	(
		--in coordSys local $tag_torso.rotation.z_rotation
		local k
		k = addNewKey targetObj_f.rotation.x_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = sourceObj_f.rotation.x_rotation.controller.keys[time_q3_f+1].value
		
		k = addNewKey targetObj_f.rotation.y_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = sourceObj_f.rotation.y_rotation.controller.keys[time_q3_f+1].value
		
		k = addNewKey targetObj_f.rotation.z_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = sourceObj_f.rotation.z_rotation.controller.keys[time_q3_f+1].value
	)	
	--leg tag_torco
	fn addkeyPOS_world_fn targetObj_f sourceObj_f time_kp_f time_q3_f q3_key_f frames_total_q3_f=
	(
		local k
		k = addNewKey targetObj_f.pos.x_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys parent sourceObj_f.pos.x
		k = addNewKey targetObj_f.pos.y_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys parent sourceObj_f.pos.y									
		k = addNewKey targetObj_f.pos.z_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys parent sourceObj_f.pos.z							
	)		

	fn addkeyROT_srcPrnt_fn targetObj_f sourceObj_f time_kp_f time_q3_f q3_key_f frames_total_q3_f=
	(
		local k
		k = addNewKey targetObj_f.rotation.x_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.rotation.x_rotation
		k = addNewKey targetObj_f.rotation.y_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.rotation.y_rotation									
		k = addNewKey targetObj_f.rotation.z_rotation.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.rotation.z_rotation								
	)	
	
	fn addkeyPOS_srcPrnt_fn targetObj_f sourceObj_f time_kp_f time_q3_f q3_key_f frames_total_q3_f=
	(
		local k
		k = addNewKey targetObj_f.pos.x_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.pos.x
		k = addNewKey targetObj_f.pos.y_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.pos.y									
		k = addNewKey targetObj_f.pos.z_position.controller time_kp_f
		get_tagent_type_fn k q3_key_f frames_total_q3_f 
		k.value = at time time_q3_f in coordSys sourceObj_f.parent sourceObj_f.pos.z							
	)			
	
	
	-- arange frames from lowest to higest total frames DEATH1=low DEATH3=high
	fn sortDeathAni_ByFrames_fn =
	(
		local highIndex = 5
		local lowIndex = 1, tmpVal=#(0,0,0,0,0)
		tmpVal[1] = array_frameFileQ3[1].total_fr
		tmpVal[3]= array_frameFileQ3[3].total_fr				
		tmpVal[5] = array_frameFileQ3[5].total_fr	
		
		if tmpVal[1] < tmpVal[3] and tmpVal[1] < tmpVal[5] then	lowIndex = 1
		if tmpVal[3] < tmpVal[5] and tmpVal[3] < tmpVal[1] then	lowIndex =3
		if tmpVal[5] < tmpVal[1] and tmpVal[5] < tmpVal[3] then	lowIndex =5
		if lowIndex !=1 then
		(
			swap array_frameFileQ3[1] array_frameFileQ3[lowIndex]
			swap array_frameFileQ3[2] array_frameFileQ3[lowIndex+1]
		)
		
		tmpVal[3] = array_frameFileQ3[3].total_fr
		tmpVal[5] = array_frameFileQ3[5].total_fr	
		
		if tmpVal[3] > tmpVal[5] then highIndex = 3
		if tmpVal[5] > tmpVal[3]  then highIndex = 5
		if highIndex !=5 then	
		(
			swap array_frameFileQ3[3] array_frameFileQ3[5]
			swap array_frameFileQ3[4] array_frameFileQ3[6]
		)
		
	)
						
	fn mapTheKeys theTime theArg = 	
		(	theTime + theArg )

	
	fn moveModelKeys_fn selected_md3_f body_part_f=
	(
		local count = 0  as integer	
		local modelIndex_q3 = 0 as integer
		
		print("moving ANIMATION SET keys----- PLEASE WAIT!!!")	

		local legs_group = 0  as integer		
		local body_group = 0 as integer		
		local head_group = 0	 as integer		
		local wep_group = 0 as integer		
		local tag_body_object =undefined
		if (body_part_f == MODEL_LEGS) then (legs_group = 1)
		if (body_part_f == MODEL_BODY) then (body_group = 1)	
		if (body_part_f == MODEL_HEAD) then (head_group = 1)	
		if (body_part_f == MODEL_WEPS) then (wep_group = 1)	

		slidertime = 0					
		------------------------------------------------------
		------------------------------------------------------
		for obj_index in selected_md3_f do
		(

			local posi_xyz = 0 as integer
			local objectsName = obj_index.name as string 				
			local tagname = 	substring objectsName 1 4 as string
			local masterCtrl
			
			print("------>model= " +objectsName as string  +"  legs=" + legs_group as string +
					"  body=" + body_group as string +"  head=" + head_group as string  +"  wep=" + wep_group as string )
			--print("-------------------------------------------------------")			
					
			if (tagname  == "tag_") then --tag_ item
			(
				posi_xyz = 1
				--setCommandPanelTaskMode #create
				--suspendEditing()
				snaptarget = obj_index
				
				if (legs_group == 1) then
				(
					tempname = uniqueName ("KP_" + snaptarget.name + "_InLegs")-- uniqueName 
				)
				else if (body_group == 1) then
				(					
					if (objectsName == "tag_torso") then (print("----------|  Deleted  |----------") continue) --not needed	
					tempname = uniqueName   ("KP_" + snaptarget.name + "_InBody_") -- uniqueName 
				)
				else if (head_group == 1) then
				(	
					if (objectsName == "tag_head") then (print("----------|  Deleted  |----------") continue) --not needed						
					tempname = uniqueName   ("KP_" + snaptarget.name + "_InHead_") -- uniqueName 	
				)	
				else if (wep_group == 1) then
				(	
					if (objectsName == "tag_wep") then (print("----------|  Deleted  |----------") continue) --not needed	
					if (objectsName == "tag_flash") then (print("----------|  Deleted  |----------") continue) --not needed					
					tempname = uniqueName   ("KP_" + snaptarget.name + "_Inwep_") -- uniqueName 		
				)		
				else		-- todo: tag flash??
				(
					print("-----------tag error---------------- " )
					continue
				)
				
				forcesnapshot = at time 0 snapshot obj_index name:tempname --		
				convertTo forcesnapshot Editable_Mesh
				forcesnapshot.controller = snaptarget.controller
				--resumeEditing()
				sourceObj = snaptarget
				targetObj = forcesnapshot
				InstanceMgr.MakeControllersUnique targetObj targetObj.controller #individual --prompt
				--InstanceMgr.MakeControllersUnique targetObj targetObj.rotation.controller #individual --prompt	
				--InstanceMgr.MakeControllersUnique targetObj targetObj.pos.controller #individual	
				--InstanceMgr.MakeControllersUnique targetObj targetObj.controller #prompt	
				
				deleteKeys targetObj #allKeys
				
				if (legs_group == 1) then	
				(
					if (objectsName == "tag_torso") then tag_legs_nodeID = targetObj.inode.handle
				)
				if (body_group == 1) then
				(	
					if (objectsName == "tag_head") then	tag_head_nodeID = targetObj.inode.handle	
					if (objectsName == "tag_weapon") then	tag_wep_nodeID = targetObj.inode.handle
				)
				

				if (body_group == 1) or ( head_group == 1) or  (wep_group == 1) then		
				(	
					--print("--------------------tag group parent-------------------")
					local tag_parent_ID = tag_legs_nodeID  as integer
					if (head_group == 1) then 	(tag_parent_ID  = tag_head_nodeID as integer)
					if (wep_group == 1) then 	(tag_parent_ID  = tag_wep_nodeID as integer)				
						
					targetObj.parent = undefined
					targetObj.pos = [0,0,0]
					--in coordsys world targetObj.rotation.x_rotation = 0
					--in coordsys world targetObj.rotation.y_rotation = 0
					--in coordsys world targetObj.rotation.z_rotation = 0
					in coordsys world targetObj.rotation = quat 0.0 0.0 0.0 1.0
						
					for parent_obj in objects do
					(
						if parent_obj.isHidden then continue -- node is hidden, skip
						if (parent_obj.inode.handle == tag_parent_ID) then
						(
							print("------>tags_parent= " +parent_obj.name as string)										
							targetObj.parent = parent_obj --tag_body -- todo check wep. head..
							exit
						)
					--print("-----------------------end tag parent------------------")							
					)
				
				)
				--print("-----------------------end tags------------------------")
			)
			else 
			(
				posi_xyz = 0
			--	setCommandPanelTaskMode #create
				--suspendEditing()
				snaptarget = obj_index
				tempname = uniqueName ("KP_" + snaptarget.name + "_")
				forcesnapshot = snapshot obj_index name:tempname
				convertTo forcesnapshot Editable_Mesh
				forcesnapshot.controller = snaptarget.controller
				--resumeEditing()
				animateVertex forcesnapshot #all
				--bakeRange = (animationRange.end - animationRange.start).frame as integer
				sourceObj = snaptarget
				targetObj = forcesnapshot
				InstanceMgr.MakeControllersUnique targetObj targetObj.controller #prompt 
				
				masterCtrl = targetObj[4][1]
				deleteKeys masterCtrl #allKeys --todo does root work?
			)	
			
			progress_cnt2 = 0 as integer
			
			local 	aniset_kp_count = 0 as integer	
			-- loop through all kp animation sequences
			for aniset_kp in array_kp_Anims do
			(

				local frames_total_kp, frames_total_q3, frame_start_kp, frame_end_kp,  frameID_start_q3		
				
				if (body_part_f == MODEL_LEGS) then (modelIndex_q3 = aniset_kp.legs)
				if (body_part_f == MODEL_BODY) then (modelIndex_q3 = aniset_kp.body)
				if (body_part_f == MODEL_HEAD) then (modelIndex_q3 = aniset_kp.head)
				if (body_part_f == MODEL_WEPS) then (modelIndex_q3 = aniset_kp.wep	)
						
				count += 1
				aniset_kp_count += 1
				
				--tmp get specific frames. tests
				--if (aniset_kp_count != 1 ) and (aniset_kp_count != 2)and (aniset_kp_count != 3)and (aniset_kp_count != 27) then
					--continue
---------------					
				progresss_percent = (progress_cnt2 / array_kp_Anims.count) * 100 as float
				progress_cnt2 +=1
				--UI_PBar_percent.value = progresss_percent				
				progressUpdate (progresss_percent)
---------------			

				
				frame_start_kp = aniset_kp.start as integer
				frame_end_kp = aniset_kp.end as integer				
				frames_total_kp = ((aniset_kp.end+1) - aniset_kp.start) as integer

				
				if (head_group == 1) or (wep_group == 1) then
				(
					frames_total_q3 = 1 as integer
					frameID_start_q3 = 1 as integer
				)
				else
				(
					frames_total_q3 = array_frameFileQ3[modelIndex_q3].total_fr as integer
					frameID_start_q3 = array_frameFileQ3[modelIndex_q3].start as integer
				)
				
				local frames_fps_multiply_q3 =  1	
				local IsUsingDeath_FPS = false		
				if UI_useFrameRateForDeath.state then	--will scale death animation speeds to match frame rate in q3 file		
				(					
					if (aniset_kp_count == 24) or (aniset_kp_count == 25) or
						(aniset_kp_count == 26) or (aniset_kp_count == 27) then	-- death animations
					(
						--frames_fps_multiply_q3 = ((array_frameFileQ3[modelIndex_q3].fps as float) / 10) as float
						frames_fps_multiply_q3 = (10 / (array_frameFileQ3[modelIndex_q3].fps as float)) as float
						local total_fps_Q3 = ((frames_fps_multiply_q3 as float) * frames_total_q3) as float
						if frames_total_kp >= total_fps_Q3 as float  then
						(
							IsUsingDeath_FPS = true
							--print("<<-->> using death ani. kpframes=" +frames_total_kp as string+ " q3frames="+total_fps_Q3 as string)
						)
					)
				)
--------------------------------------------------						
				
				-- get every q3 keyframe. paste to kp frame%
				for q3_key = 0 to  frames_total_q3 do -- do first to last frame (can be a single frame
				(
					local time_kp
					local time_q3					
---------------	
					--UI_PBar_percent.value = progresss_percent
					progressUpdate (progresss_percent)					
---------------								
					if (q3_key == 0) then 	--first frame
					(
						time_kp = frame_start_kp  as float
						time_q3 = (frameID_start_q3) as integer
						--print("-- first key Q3-----")
					)
					else	if (q3_key == 1) and (frames_total_q3 == 1) then  --only has 1 frame
					(
						time_kp = frame_end_kp  as float
						time_q3 = (frameID_start_q3) as integer
						--print("-- last key Q3-----")
					)	
					else	if (q3_key == (frames_total_q3 - 1)) and ( IsUsingDeath_FPS == false) then  --total frames(no fps change)
					(
						time_kp = frame_end_kp  as float
						time_q3 = (frameID_start_q3 + (q3_key))  as integer
						--print("-- last key Q3-----")
					)
					else if (q3_key <= (frames_total_q3 - 1)) then
					(	
						local tween_fr =	( (frames_total_kp - 1 as Double) / (frames_total_q3 - 1 as Double) ) as Double --was (frames_total_q3-1)
						if IsUsingDeath_FPS then
							tween_fr = frames_fps_multiply_q3 as Double
--------------------------------------------------						
						tween_fr *=	q3_key as Double	
						time_kp = (frame_start_kp + tween_fr)  as float
						time_q3 = (frameID_start_q3 + (q3_key))	 as integer	
					)	-- end q3 frame numbers
					else
					(
						if IsUsingDeath_FPS then	-- death animations, 1 extra last frame
						(	
							time_kp = frame_end_kp  as float
							time_q3 = (frameID_start_q3 + (q3_key - 1))  as integer
						)
						else -- end 1 extra frame. for death animations
							exit
					) -- end q3_keys setup
					--print("q3key=" + q3_key as string+" q3tween="+ time_q3 as string+" timekp=" + time_kp as string +" posi_xy=" +posi_xyz as string)
					
					--start copying animation for each q3 frame
					if (posi_xyz == 1) then -- is a tag_
					(
						if (legs_group == 1) then -- must be TAG_TORSO in legs
						(
							--k = addNewKey targetObj.rotation.controller time_kp
							--k.value = at time time_q3 in coordSys world sourceObj.transform
							
							addkeyROT_world_fn targetObj sourceObj time_kp time_q3 q3_key frames_total_q3 
							addkeyPOS_world_fn targetObj sourceObj time_kp time_q3 q3_key frames_total_q3 
							
							k = addNewKey targetObj.scale.controller time_kp
							get_tagent_type_fn k q3_key frames_total_q3 
							k.value = at time time_q3 in coordSys world sourceObj.scale
						)	
						else if (body_group == 1) or( head_group == 1) or (wep_group == 1) then	 --all other tags
						(
							-- child tags
							addkeyROT_srcPrnt_fn targetObj sourceObj time_kp time_q3 q3_key frames_total_q3 
							addkeyPOS_srcPrnt_fn targetObj sourceObj time_kp time_q3 q3_key frames_total_q3 								
																
							k = addNewKey targetObj.scale.controller time_kp
							get_tagent_type_fn k q3_key frames_total_q3 								
							k.value = at time time_q3 in coordSys sourceObj.parent sourceObj.scale								
						)	-- END tags in body_group	
						progressUpdate (progresss_percent)		
						
					) 	-- END tag config
					else
					( 	-- vertex animated mesh	objects			
						for i in 1 to targetObj.numVerts do 
						(
							k = addNewKey masterCtrl[i].controller time_kp		
							get_tagent_type_fn k q3_key frames_total_q3 
							k.value = at time time_q3 in coordSys sourceObj getVert sourceObj i -- was sourceObj
							--k.value = at time time_q3 sourceObj.baseobject[#master_point_controller][i].value
						)
						progressUpdate (progresss_percent)						
					) -- END vertex animated mesh objects
					
				) -- end q3 nimation set
				
				--escapeEnable = true
				--if (getProgressCancel == true) then
				--exit	-- loop through only 1 animation
--------------
			)	-- end kp animation set

			
			--reset mesh objects to reflect parent [0,0,0]
			if (body_group == 1) or ( head_group == 1) or (wep_group == 1) then
			(	
				--print("-------------start mesh parent-------------------------")
				if (posi_xyz == 0) then -- is mesh
				(
					local mesh_parent_ID = tag_legs_nodeID as integer
					if (head_group == 1) then	(	mesh_parent_ID  = tag_head_nodeID as integer)
					if (wep_group == 1) then 	(	mesh_parent_ID  = tag_wep_nodeID as integer)	
					
					for parent_obj in objects do
					(
						--print("--------------mesh parent------------------------------")
						if parent_obj.isHidden then continue -- node is hidden, skip
						if (parent_obj.inode.handle == mesh_parent_ID) then -- hypo todo self or parent?
						(
							--print("--------------mesh parent=" +(parent_obj.name as string)+"  ID="+(mesh_parent_ID as string) + "for=" +targetObj.name as string)	
							targetObj.parent = parent_obj --tag_body -- todo check wep. head..
							exit
						)
					)
					in coordsys parent targetObj.pos = [0,0,0]
					in coordsys parent targetObj.rotation.x_rotation = 0
					in coordsys parent targetObj.rotation.y_rotation = 0
					in coordsys parent targetObj.rotation.z_rotation = 0
				) --end mesh object origin/target
				--print("--------------end mesh parent-------------------------- name=" + targetObj.name as string)
			)
			
		
			if (legs_group == 1) and (posi_xyz == 0) then  -- is legs mesh	
			(		
				--print("--------------start legs group--------------------------")				
				for parent_obj in objects do
				(
					if parent_obj.isHidden then continue -- node is hidden, skip
					if (parent_obj.inode.handle == tag_legs_nodeID) then
					(			-- right 131-136 & 159-164 -- left 137-142 & 165-170
						local twistR_timer = #(131, 159)
						local twistL_timer = #(137, 165)	
						local stand_timer = #(0,1,2,130, 143, 158, 171)
						for keyAt in stand_timer do
						(
							animate on (	at time keyAt 	(targetObj.pos = [0, 0, 0]; targetObj.rotation = (EulerAngles 0 0 0); targetObj.scale = [1,1,1]))	
							--at time keyAt targetObj.controller.keys.inTangentType= #step
							--at time keyAt targetObj.controller.keys.outTangentType= #step	
						)	
						for keyAt in twistR_timer do
						(
							animate on (	at time keyAt about parent_obj rotate targetObj  (EulerAngles 0 0 -60))
						--	at time keyAt targetObj.controller.keys.inTangentType= #step
							--at time keyAt targetObj.controller.keys.outTangentType= #step									
						)	
						for keyAt in twistL_timer do
						(
							animate on(at time keyAt about parent_obj rotate targetObj  (EulerAngles 0 0 120))
							
						)
						targetObj.pos.x_position.controller.keys.inTangentType= #step
						targetObj.pos.x_position.controller.keys.outTangentType= #step
						targetObj.pos.y_position.controller.keys.inTangentType= #step
						targetObj.pos.y_position.controller.keys.outTangentType= #step	
						targetObj.pos.z_position.controller.keys.inTangentType= #step
						targetObj.pos.z_position.controller.keys.outTangentType= #step	
						
						targetObj.rotation.x_rotation.controller.keys.inTangentType= #step
						targetObj.rotation.x_rotation.controller.keys.outTangentType= #step
						targetObj.rotation.y_rotation.controller.keys.inTangentType= #step
						targetObj.rotation.y_rotation.controller.keys.outTangentType= #step						
						targetObj.rotation.z_rotation.controller.keys.inTangentType= #step
						targetObj.rotation.z_rotation.controller.keys.outTangentType= #step	
						
						--targetObj.scale.controller.keys.outTangentType= #step						
				--print("--------------finish legs group--------------------------")	
						exit
					)
				)
			--print("--------------legs group loop--------------------------")				
			)
			
			update targetObj
			max views redraw
			print("----------| End Model |----------")
		) -- end loop through body parts
			
		--print("moving ANIMATION SET keys Done-----")
	) --end function copy keys
	
	
		
	fn move_tagToTop array_ tag_name = --hypo todo use swap()
	(
		local tmpArray=#()
		
		for x=1 to array_.count do
		(
			if array_[x].name == tag_name as string then
			(
				swap array_[x] array_[1]
				print("----- tag rename done OK!! -----")
				exit
			)
		)
		print("----- tag rename done     -----")		
	) -- end func move tag to top of list
	
	
	fn setupObjectsAsGroups =	
	(
		array_legs=#()
		array_body=#()
		array_head=#()
		array_wep=#()
	
		for obj in geometry do
		(
			-- node is hidden, skip
			if obj.isHidden then continue
			
			print("adding object= " +	(obj.name as string))
			
			local firstletter = substring obj.name 1 2
			local tagname = 	substring obj.name 1 4
			local parent_tag = undefined
			local objectsName = obj.name as string 	
				
			if obj.parent != undefined then
				parent_tag = obj.parent.name as string

			--asigne each part to a group. eg.. tag_torso to group_body	
			if (tagname as string == "tag_") then
			(
					if (objectsName == "tag_torso" ) then
					(
						if (parent_tag == undefined) then
							append array_legs obj
						else
							append array_body obj
					)
					else if (objectsName == "tag_head") then 
					(
						if (parent_tag == undefined) then
							print("---- parent error ----")
						else if (parent_tag == "tag_head" ) then
							append array_head obj 
						else 
							append array_body obj
					)
					else if (objectsName == "tag_weapon") then
					(
						if (parent_tag == undefined) then
							print("---- parent error ----")
						else if (parent_tag == "tag_weapon") then
							append array_wep obj 
						else
							append array_body obj 
					)
					else if (objectsName == "tag_flash") then
						append array_wep obj 
					else
						print("---- parent error ----")					
			)-- end tag asigments
			else	if (firstletter as string == "l_") then
					append array_legs obj 
			else if (firstletter as string == "u_") then
					append array_body obj 
			else if (firstletter as string == "w_") then
					append array_wep obj 
			else if (firstletter as string == "h_") then
				append array_head obj 	
			else 	
				print("---- error unknown obj=")
				
		) -- end adding each mesh object to array
		

		--move_tagToTop array_legs tag_torso_
		move_tagToTop array_body "tag_torso"
		move_tagToTop array_head "tag_head"
		move_tagToTop array_wep "tag_weapon"
		
	)--end function set model groups
	
	
	-- inital loading of script... Do
	on QuakeMD3_To_Kingpin open do 
	(		
		-- kingpin multi player model ani set
		append array_kp_Anims (frame_num_KP start:0  	end:31		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_STAND)		--tgun_rdy_			1st frame
		append array_kp_Anims (frame_num_KP start:32	end:36		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_ATTACK)		--tg_shoot_
		append array_kp_Anims (frame_num_KP start:37	end:46		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_GESTURE)	--tg_bird_
		append array_kp_Anims (frame_num_KP start:47	end:62		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_GESTURE)	--tg_crch_grab_
		append array_kp_Anims (frame_num_KP start:63	end:77		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_GESTURE)	--tg_chin_flip_
		append array_kp_Anims (frame_num_KP start:78	end:100		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_STAND)		--1pstl_rdy_			1st frame	body:pistol
		append array_kp_Anims (frame_num_KP start:101	end:104		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_ATTACK)		--p_std_shoot_
		append array_kp_Anims (frame_num_KP start:105	end:114		head:1 wep:1		legs:LEGS_WALK		body:TORSO_STAND)		--walk_gdown_		
		append array_kp_Anims (frame_num_KP start:115	end:124		head:1 wep:1		legs:LEGS_WALK		body:TORSO_ATTACK)		--walk_tg_sht_
		append array_kp_Anims (frame_num_KP start:125	end:130		head:1 wep:1		legs:LEGS_RUN		body:TORSO_ATTACK)		--run_tg_sht_
		append array_kp_Anims (frame_num_KP start:131	end:136		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--rsd_tg_run_		
		append array_kp_Anims (frame_num_KP start:137	end:142		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--lsd_tg_run_		
		append array_kp_Anims (frame_num_KP start:143	end:152		head:1 wep:1		legs:LEGS_WALK		body:TORSO_ATTACK)		--p_walk_sht_		pistol
		append array_kp_Anims (frame_num_KP start:153	end:158		head:1 wep:1		legs:LEGS_RUN		body:TORSO_ATTACK)		--p_run_shoot_ 		pistol
		append array_kp_Anims (frame_num_KP start:159	end:164		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--p_rside_run_ 		*missing* pistol
		append array_kp_Anims (frame_num_KP start:165	end:170		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--p_lside_run_ 		*missing* pistol
		append array_kp_Anims (frame_num_KP start:171	end:189		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_STAND2)		--melee_rdy_			1st frame
		append array_kp_Anims (frame_num_KP start:190	end:196		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_ATTACK2)	--melee1_
		append array_kp_Anims (frame_num_KP start:197	end:202		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_ATTACK2)	--melee2_
		append array_kp_Anims (frame_num_KP start:203	end:208		head:1 wep:1		legs:LEGS_RUN		body:TORSO_ATTACK2)	--run_melee_ 		//checkkk
		append array_kp_Anims (frame_num_KP start:209	end:214		head:1 wep:1		legs:LEGS_RUN		body:TORSO_STAND)		--run_gun_dn_	
		append array_kp_Anims (frame_num_KP start:215	end:221		head:1 wep:1		legs:LEGS_JUMP		body:TORSO_STAND)		--jump_				1st frame
		append array_kp_Anims (frame_num_KP start:222	end:230		head:1 wep:1		legs:LEGS_IDLE		body:TORSO_STAND)		--clmb_loop_			*missing*
		append array_kp_Anims (frame_num_KP start:231	end:249		head:1 wep:1		legs:BOTH_DEATH2	body:BOTH_DEATH2)		--death1_				19 frames	--sorted in q3 least to most fps
		append array_kp_Anims (frame_num_KP start:250	end:265		head:1 wep:1		legs:BOTH_DEATH1	body:BOTH_DEATH1)		--death2_				16 frames	--sorted in q3 least to most fps
		append array_kp_Anims (frame_num_KP start:266	end:293		head:1 wep:1		legs:BOTH_DEATH3	body:BOTH_DEATH3)		--death3_				28 frames	--sorted in q3 least to most fps
		append array_kp_Anims (frame_num_KP start:294	end:306		head:1 wep:1		legs:BOTH_DEATH1	body:BOTH_DEATH1)		--death4_				13 frames --duplicate of death2
		append array_kp_Anims (frame_num_KP start:307	end:333		head:1 wep:1		legs:LEGS_IDLECR	body:TORSO_STAND)		--tg_crch_rdy_
		append array_kp_Anims (frame_num_KP start:334	end:339		head:1 wep:1		legs:LEGS_IDLECR	body:TORSO_ATTACK)		--crouch_shoot_	
		append array_kp_Anims (frame_num_KP start:340	end:344		head:1 wep:1		legs:LEGS_WALKCR	body:TORSO_STAND)		--crch_walk_		
		append array_kp_Anims (frame_num_KP start:345	end:362		head:1 wep:1		legs:LEGS_IDLECR	body:TORSO_STAND)		--1p_crch_rdy_		pistol
		append array_kp_Anims (frame_num_KP start:363	end:367		head:1 wep:1		legs:LEGS_IDLECR	body:TORSO_ATTACK)		--p_crch_sht_		pistol
		append array_kp_Anims (frame_num_KP start:368	end:373		head:1 wep:1		legs:LEGS_WALKCR	body:TORSO_ATTACK)		--p_crch_walk_		1st frame, pistol
		append array_kp_Anims (frame_num_KP start:374	end:385		head:1 wep:1		legs:BOTH_DEATH1	body:BOTH_DEATH1)			--crouch_death_		*missing*
	) --end on load script

	-- button get animation.cfg
	on UI_btn_GetFile pressed do
	(
		animationfile=getopenfilename caption:"Open Frame File" filename:"" types:"Quake3 Animation File (animation.cfg)|animation.cfg"
		if animationfile != undefined do
		(
			if DoesFileExist animationfile then
			(
				--free array_frameFileQ3
				array_frameFileQ3=#()
				local index_forFrames = 0 as integer
				
				local file = openFile animationfile mode:"r"
				--local counter = 1
				local startPosi = 0 as integer
				local offsetLegsTime = 0 as integer
				
				while not EOF file do
		 		(
					local strTmp = readLine file
					local lineDelim = filterString strTmp " \t"
					
					--print ("delim1= " + lineDelim[1]as string+", "+lineDelim[2]as string)
					
					if (lineDelim[1] == undefined) or 
						(lineDelim[1].count == 0) then	continue
					
					if (startPosi == 0) and (lineDelim[1] == "0" as string) then
						startPosi = 1
					
					if (startPosi == 1) then
					(
						local frameStart = lineDelim[1] as integer
						local frameEnd = lineDelim[2] as integer
						local frameFPS = lineDelim[4] as integer
	
						index_forFrames += 1						

						if (index_forFrames == LEGS_WALKCR) then 
						(
							local offsetLeg = ( (array_frameFileQ3[BOTH_DEAD3].start) + (array_frameFileQ3[BOTH_DEAD3].total_fr) ) as integer
							print("offset= " +( offsetLeg as string))
							offsetLegsTime = (frameStart - offsetLeg) --should only be 1 frame. but just incase
						)
						
						if (index_forFrames >= LEGS_WALKCR) then 
							frameStart -= offsetLegsTime

							
						append array_frameFileQ3 (frame_num_q3 start:frameStart total_fr:frameEnd fps:frameFPS )
						--print("num= "+(index_forFrames as string)+" start= "+(frameStart as string)+ " getframe= " +(frameEnd as string))
						--print("num= "+(index_forFrames as string)+ "getframe= " +(array_frameFileQ3[index_forFrames].start as string))
					)				
				)
				close file
			)
			
			--arange death by frame counts
			sortDeathAni_ByFrames_fn 

		)
	) -- end button pressed get animation.cfg file
	
	
	on UI_btn_DoConversion pressed do
	(
		tag_legs_nodeID = undefined
		--tag_body_nodeID = undefined
		tag_head_nodeID = undefined
		tag_wep_nodeID = undefined
		
		UI_btn_DoConversion.enabled = false
		
		IU_status.caption = "Status:  Converting.."	
		UI_btn_GetFile
		suspendEditing()
		--progressStart ("Model Converting")
		progressUpdate (5)
		
		clearSelection()
		setupObjectsAsGroups()

		if (array_frameFileQ3 !=undefined) and (array_frameFileQ3.count == 25) then --todo -3 for death
		(
			local completend = ( (array_frameFileQ3[25].start as integer) + ((array_frameFileQ3[25].total_fr as integer) ) ) as integer
			print("completend= " +(completend as string))
			animationrange = interval 0 390
			moveModelKeys_fn 	array_legs 	 	MODEL_LEGS 			
			moveModelKeys_fn 	array_body  	MODEL_BODY	
			moveModelKeys_fn 	array_head   	MODEL_HEAD
			moveModelKeys_fn 	array_wep 	 	MODEL_WEPS
		)
		else
		(
			messagebox("ERROR.. in Animation.cfg")
		)
		
		resumeEditing()
		--progressEnd()
		UI_btn_DoConversion.enabled = true	
		IU_status.caption = "Status:  Done"	
		
		max views redraw		
	)-- end button do convert
	
	
)