#include "../../pluginshare.h"
#include <math.h>

#define USE_GLCOMMANDS_VERSION //hypo use newer kp style glCmds
#define copyUVIdx(src, dst, vertCnt) (dst.s=src.s,dst.t=src.t,dst.vertexIndex=src.vertexIndex, vertCnt+=1)

#define MAX_FRAMES 1024
#define MAXOBJECTS 64
#define MAX_MDX_VERT 2048
#define MAX_MDX_TRI 4096
#define MAX_MDX_GLCMDS (MAX_MDX_VERT*MAX_MDX_TRI)

typedef struct md2Hdr_s
{
	BYTE			id[4];
	int				ver; //kp ver = 4

	int				skinWidth;
	int				skinHeight;
	int				frameSize;

	int				numSkins;				// number of textures
	int				numVerts;				// number of vertices
	int				numTris;				// number of triangles
	int				numGLCmds;				// number of gl commands
	int				numFrames;				// number of frames
	int				num_SfxDefines; //mdx	// number of sfx definitions
	int				num_SfxEntries; //mdx	// number of sfx entries
	int				num_SubObjects; //mdx	// number of subobjects

	int				ofsSkins;			/*md2Skin_t*/	//name[64];
	int				ofsTris;			/*md2Tri_t*/	//vertIDX[3], texIndex[3].
	int				ofsFrames;			//vertex pos, vertex normalIDX
	int				ofsGLCmds;			//triCount(-/+ is type), objectNum, (tri1)s,t, vertIdx... (tri2)s,t,vertIdx...
	int				offsetVertexInfo;	//objectID //mdx
	int				offsetSfxDefines;	//mdx 
	int				offsetSfxEntries;	//mdx 
	int				offsetBBoxFrames;	//mdx 
	int				offsetDummyEnd;

	int				ofsEnd;
} md2Hdr_t;


typedef struct md2Skin_s
{
	char			name[64];
} md2Skin_t;

 //vertPos[3], normalIndex
typedef struct md2Vert_s 
{
	BYTE			vertPos[3];
	BYTE			normalIndex; //index. shared normals
} md2Vert_t;

//vertIDX[3], normalIDX[3]
typedef struct md2Tri_s
{
	WORD			vertIndex[3]; //3 vertex index to make a tri
	WORD			nornalIdx[3]; //vertexnormal[3]
} md2Tri_t;

//scale[3], trans[3], name[16]
typedef struct md2Frame_s
{
	float			scale[3];
	float			trans[3];
	char			name[16]; //frame name
} md2Frame_t;

// GL VERTEX 
typedef struct
{
	float s, t;
	int vertexIndex;
} glVertex_t;

//GL OBJECT HEADDER
typedef struct
{
	int TrisTypeNum;
	int SubObjectID;
} glCmdHeader_t;




extern mathImpFn_t *g_mfn;
extern noePluginFn_t *g_nfn;
extern int g_fmtHandle;

extern float g_q2Normals[162][3];
extern BYTE g_q2Pal[256][4];

NPLUGIN_API bool NPAPI_Init(void);
NPLUGIN_API void NPAPI_Shutdown(void);
NPLUGIN_API int NPAPI_GetPluginVer(void);
