unit AsciiImportPlugin;

interface

uses windows,
    sysutils,
    mslib,
    msPlugin,
    dialogs,
    classes,
    importform,
    controls;

type
    TmsAsciiImportPlugin = class(TmsPlugin)
    public
        function Execute(pModel: PmsModel): integer; override;
    end;

var
    Plug: TmsAsciiImportPlugin;

function StrToFloatDef(const strValue: string; defValue: Extended = 0): Extended;

implementation

function TmsAsciiImportPlugin.Execute(pModel: PmsModel): integer;
var
    str, ll: TStringlist;
    i, j: integer;
    pMesh: PmsMesh;
    pVertex: PmsVertex;
    line: integer;
    error: boolean;
    vec2: TmsVec2;
    vec3: TmsVec3;
     ambient, diffuse, specular, Emissive: TmsVec4;
    shininess, transparency: single;
    index: integer;
    words: TWordArray;
    pTriangle: PmsTriangle;
    pmaterial: PmsMaterial;
    pbone: pmsBone;
    s1, s2: string;
    temp: integer;
    procedure parseLine(line: string);
    var
        index: Integer;
    begin
        ll.clear;
        line := trim(line);
        index := pos(' ', line);
        while (index > 0) or ((pos('"', line) > 0) and (length(line) > 1)) do
        begin
            if line[1] = '"' then
            begin
                delete(line, 1, 1);
                if pos('"', line) > 0 then
                begin
                    index := pos('"', line);
                    delete(line, index, 1);
                end;
            end;

            ll.add(copy(line, 1, index - 1));

            delete(line, 1, index);
            line := trim(line);
            index := pos(' ', line);
        end;
        if length(line) > 0 then
            ll.add(line);
    end;

    function Nextline(llcount: integer): boolean;
    begin
        result := false;
        inc(line);
        if (line > str.count - 1) then
            exit;
        parseline(str[line]);

        if ll.count <> llcount then
            exit;
        result := true;
    end;
begin
    importdlg := TImportdlg.create(nil);
    if (importdlg.showmodal = mrOK) and fileexists(importdlg.FilenameEdit.text) then
    begin

        if (msModel_GetBoneCount(pModel) > 0) then
        begin
            if messagebox(0, 'The importer won''t import additional bones!! Continue anyway?', '(Delphi SDK) MilkShape 3D ASCII Importer', MB_YESNO) <> ID_YES then
            begin
                result:=-1;
                exit;
            end;
        end;

        str := TStringlist.create;
        ll := TStringlist.create;
        str.loadfromfile(importdlg.FilenameEdit.text);

        // destroy the bones
        if assigned(pModel.pBones) then
        begin

            for i:=0 to pmodel^.nNumbones-1 do
            begin
                msBone_Destroy(pModel.pbones);
                inc(pModel.pbones);
            end;

            // freemem(pModel^.pBones, pModel.nNumBones * sizeof(TmsBone));
            pModel.pBones := nil;
            pModel.nNumBones := 0;
            pModel.nNumAllocedBones := 0;
        end;

        // detach the vertices from the bones
        for i := 0 to msModel_GetMeshCount(pModel) - 1 do
        begin
            pMesh := msModel_GetMeshAt(pModel, i);
            for j := 0 to msMesh_GetVertexCount(pMesh) - 1 do
            begin
                pVertex := msMesh_GetVertexAt(pMesh, j);
                msVertex_SetBoneIndex(pVertex, -1);
            end;
        end;

        line := 0;
        error:=false;
        while (line < str.count) and (not error) do
        begin
            parseline(str[line]);
            if (ll.count = 0) or (pos('//', ll[0]) > 0) then
            begin
                inc(line);
                continue;
            end;

            if ll[0] = 'Frames' then
                msModel_SetTotalFrames(pModel, strtoInt(ll[1]))
            else
                if ll[0] = 'Frame:' then
                    msModel_SetFrame(pModel, strtoint(ll[1]))
                else
                    if ll[0] = 'Meshes:' then
                    begin
                        temp := strtoint(ll[1]);
                        for i := 0 to temp - 1 do
                        begin
                            pMesh := nil;

                            if importdlg.meshescb.checked then
                            begin
                                index := msModel_AddMesh(pModel);
                                pMesh := msModel_GetMeshAt(pModel, index);
                            end;

                            if not nextline(3) then
                                break;

                            if importdlg.meshescb.checked then
                            begin

                                msMesh_SetName(pMesh, pchar(ll[0]));
                                msMesh_SetFlags(pMesh, strtoint(ll[1]));
                                if importdlg.materialscb.checked then
                                    msMesh_SetMaterialIndex(pMesh, strtoint(ll[2]));
                            end
                            else
                                msMesh_SetMaterialIndex(pMesh, -1);

                            if not nextline(1) then
                                break;
                            temp:=strtoint(ll[0]);
                            for j := 0 to temp - 1 do
                            begin

                                if not nextline(7) then
                                    break;

                                if importdlg.meshescb.checked then
                                begin

                                    index := msMesh_AddVertex(pMesh);
                                    pVertex := msMesh_GetVertexAt(pMesh, index);
                                    msVertex_SetFlags(pVertex, strtoint(ll[0]));
                                    vec3[0] := strtofloatdef(ll[1]);
                                    vec3[1] := strtofloatdef(ll[2]);
                                    vec3[2] := strtofloatdef(ll[3]);
                                    msVertex_SetVertex(pVertex, Vec3);
                                    vec2[0] := strtofloatdef(ll[4]);
                                    vec2[1] := strtofloatdef(ll[5]);
                                    msVertex_SetTexCoords(pVertex, vec2);
                                    if importdlg.bonescb.checked then
                                        msVertex_SetBoneIndex(pVertex, strtoint(ll[6]))
                                    else
                                        msVertex_SetBoneIndex(pVertex, -1);
                                end;
                            end;

                            // normals
                            if not nextline(1) then
                                break;
                            temp := strtoint(ll[0]);
                            for j := 0 to temp - 1 do
                            begin
                                if not nextline(3) then
                                    break;

                                if importdlg.meshescb.checked then
                                begin
                                    vec3[0] := strtofloatdef(ll[0]);
                                    vec3[1] := strtofloatdef(ll[1]);
                                    vec3[2] := strtofloatdef(ll[2]);
                                    index := msMesh_AddVertexNormal(pMesh);
                                    msMesh_SetVertexNormalAt(pMesh, index, vec3);
                                end;
                            end;

                            // triangles
                            if not nextline(1) then
                                break;

                            temp := strtoint(ll[0]);
                            for j := 0 to temp - 1 do
                            begin
                                if not nextline(8) then
                                    break;

                                if importdlg.meshescb.checked then
                                begin
                                    index := msMesh_AddTriangle(pMesh);
                                    pTriangle := msMesh_GetTriangleAt(pMesh, index);

                                    msTriangle_SetFlags(pTriangle, strtoint(ll[0]));
                                    setlength(words, 3);
                                    words[0] := strtoint(ll[1]);
                                    words[1] := strtoint(ll[2]);
                                    words[2] := strtoint(ll[3]);
                                    msTriangle_SetVertexIndices(pTriangle, words);
                                    words[0] := strtoint(ll[4]);
                                    words[1] := strtoint(ll[5]);
                                    words[2] := strtoint(ll[6]);
                                    msTriangle_SetNormalIndices(pTriangle, words);

                                    msTriangle_SetSmoothingGroup(pTriangle, strtoint(ll[7]));
                                    setlength(words, 0);
                                end;
                            end;

                        end;
                    end
                    // materials
                    else
                        if ll[0] = 'Materials:' then
                        begin

                            temp := strtoint(ll[1]);
                            for i := 0 to temp - 1 do
                            begin
                                pMaterial := nil;
                                if importdlg.materialscb.checked then
                                begin
                                    index := msModel_AddMaterial(pModel);
                                    pMaterial := msModel_GetMaterialAt(pModel, index);
                                end;

                                // name
                                if not nextline(1) then
                                    break;
                                s1 := ll[0];

                                // ambient
                                if not nextline(4) then
                                    break;
                                Ambient[0] := strtofloatdef(ll[0]);
                                Ambient[1] := strtofloatdef(ll[1]);
                                Ambient[2] := strtofloatdef(ll[2]);
                                Ambient[3] := strtofloatdef(ll[3]);

                                // diffuse
                                if not nextline(4) then
                                    break;
                                Diffuse[0] := strtofloatdef(ll[0]);
                                Diffuse[1] := strtofloatdef(ll[1]);
                                Diffuse[2] := strtofloatdef(ll[2]);
                                Diffuse[3] := strtofloatdef(ll[3]);

                                // specular
                                if not nextline(4) then
                                    break;
                                Specular[0] := strtofloatdef(ll[0]);
                                Specular[1] := strtofloatdef(ll[1]);
                                Specular[2] := strtofloatdef(ll[2]);
                                Specular[3] := strtofloatdef(ll[3]);

                                // emissive
                                if not nextline(4) then
                                    break;
                                Emissive[0] := strtofloatdef(ll[0]);
                                Emissive[1] := strtofloatdef(ll[1]);
                                Emissive[2] := strtofloatdef(ll[2]);
                                Emissive[3] := strtofloatdef(ll[3]);

                                // shininess
                                if not nextline(1) then
                                    break;
                                Shininess := strtofloatdef(ll[0]);

                                // transparency
                                if not nextline(1) then
                                    break;
                                Transparency := strtofloatdef(ll[0]);

                                // diffuse texture
                                if not nextline(1) then
                                    break;
                                s2 := ll[0];

                                // alpha texture
                                if not nextline(1) then
                                    break;

                                if importdlg.materialscb.checked then
                                begin
                                    msMaterial_SetName(pMaterial, pchar(s1));
                                    msMaterial_SetAmbient(pMaterial, Ambient);
                                    msMaterial_SetDiffuse(pMaterial, Diffuse);
                                    msMaterial_SetSpecular(pMaterial, Specular);
                                    msMaterial_SetEmissive(pMaterial, Emissive);
                                    msMaterial_SetShininess(pMaterial, Shininess);
                                    if not importdlg.Transparencycb.checked then
                                        msMaterial_SetTransparency(pMaterial, 1)
                                    else
                                        msMaterial_SetTransparency(pMaterial, Transparency);

                                    msMaterial_SetDiffuseTexture(pMaterial, pchar(s2));
                                    msMaterial_SetAlphaTexture(pMaterial, pchar(ll[0]));
                                end;
                            end;
                        // bones
                        end
                        else
                            if ll[0] = 'Bones:' then
                            begin

                                temp := strtoint(ll[1]);
                                for i := 0 to temp - 1 do
                                begin
                                  // showmessage(inttostr(i)+' - '+inttostr(temp));
                                    pBone := nil;
                                    if importdlg.bonescb.checked then
                                    begin
                                        index := msModel_AddBone(pModel);
                                        pBone := msModel_GetBoneAt(pModel, index);
                                    end;

                                    // name
                                    if not nextline(1) then
                                        break;
                                    s1 := ll[0];

                                    // parent name
                                    if not nextline(1) then
                                        break;
                                    s2 := ll[0];

                                    if not nextline(7) then
                                        break;

                                    if importdlg.bonescb.checked then
                                    begin
                                        msBone_SetName(pBone, pchar(s1));
                                        msBone_SetParentName(pBone, pchar(s2));
                                        msBone_SetFlags(pBone, strtoint(ll[0]));
                                        vec3[0] := strtofloatdef(ll[1]);
                                        vec3[1] := strtofloatdef(ll[2]);
                                        vec3[2] := strtofloatdef(ll[3]);
                                        msBone_SetPosition(pBone, vec3);
                                        vec3[0] := strtofloatdef(ll[4]);
                                        vec3[1] := strtofloatdef(ll[5]);
                                        vec3[2] := strtofloatdef(ll[6]);
                                        msBone_SetRotation(pBone, vec3);
                                    end;

                                    // position key count
                                    if not nextline(1) then
                                        break;
                                    temp:=strtoint(ll[0]);
                                    for j := 0 to temp - 1 do
                                    begin
                                        if not nextline(4) then
                                            break;

                                        if importdlg.bonescb.checked or importdlg.keyframescb.checked then

                                        begin
                                            vec3[0] := strtofloatdef(ll[1]);
                                            vec3[1] := strtofloatdef(ll[2]);
                                            vec3[2] := strtofloatdef(ll[3]);
                                            msBone_AddPositionKey(pBone, strtofloatdef(ll[0]), vec3);
                                        end;

                                    end;

                                    // rotation key count
                                    if not nextline(1) then
                                        break;

                                    temp := strtoint(ll[0]);
                                    for j := 0 to temp - 1 do
                                    begin
                                        if not nextline(4) then
                                            break;

                                        if importdlg.bonescb.checked or importdlg.keyframescb.checked then

                                        begin
                                            vec3[0] := strtofloatdef(ll[1]);
                                            vec3[1] := strtofloatdef(ll[2]);
                                            vec3[2] := strtofloatdef(ll[3]);
                                            msBone_AddRotationKey(pBone, strtofloatdef(ll[0]), vec3);
                                        end;

                                    end;

                                end;
                            end
                            // GroupComments
                            else
                                if ll[0] = 'GroupComments:' then
                             begin
                                    temp := strtoint(ll[1]);
                                    for i := 0 to temp - 1 do
                                    begin
                                        if not nextline(1) then
                                            break;
                                        index := strtoint(ll[0]);
                                        // comment
                                        if not nextline(1) then
                                            break;
                                        pMesh := msModel_GetMeshAt(pModel, Index);
                                        if assigned(pMesh) then
                                            msMesh_SetComment(pMesh, pchar(ll[0]));

                                    end;
                                end
                                // MaterialComments
                                else
                                    if ll[0] = 'MaterialComments:' then
                                    begin

                                        temp := strtoint(ll[1]);
                                        for i := 0 to temp - 1 do
                                        begin
                                            // group index
                                            if not nextline(1) then
                                                break;
                                            index := strtoint(ll[0]);

                                            // comment
                                            if not nextline(1) then
                                                break;
                                            pMaterial := msModel_GetMaterialAt(pModel, Index);
                                            if assigned(pMaterial) then
                                                msMaterial_SetComment(pMaterial, pchar(ll[0]));
                                        end;
                                    end
                                    // BoneComments
                                    else
                                        if ll[0] = 'BoneComments:' then
                                        begin

                                            temp := strtoint(ll[1]);
                                            for i := 0 to temp - 1 do
                                            begin
                                                // group index

                                                if not nextline(1) then
                                                    break;
                                                index := strtoint(ll[0]);
                                                // commennt
                                                if not nextline(1) then
                                                    break;
                                                pBone := msModel_GetBoneAt(pModel, Index);
                                                if assigned(pBone) then
                                                    msBone_SetComment(pBone, pchar(ll[0]));

                                            end;
                                        end
                                        // ModelComment
                                        else
                                            if ll[0] = 'ModelComments:' then
                                            begin

                                                temp := strtoint(ll[1]);
                                                showmessage(inttostr(temp));
                                                for i := 0 to temp - 1 do
                                                begin
                                                    // group index
                                                    if not nextline(1) then
                                                        break;
                                                    if not nextline(1) then
                                                        break;
                                                    msModel_SetComment(pModel, pchar(ll[0]));
                                                end;
                                            end;
                inc(line);
        end;

        if Error then
            messagebox(0, 'Error importing MilkShape 3D ASCII file.', '(Delphi SDK) MilkShape 3D ASCII Importer', MB_OK);

        result := 0;
    end
    else
    begin
        result := -1;
        msmodel_destroy(pmodel);
    end;
    importdlg.free;
end;

// TryStrToFloat
//
function TryStrToFloat(const strValue: string; var val: Extended): Boolean;
var
    i, j, divider, lLen, exponent: Integer;
    c: Char;
    v: Extended;
begin
    if strValue = '' then
    begin
        Result := False;
        Exit;
    end
    else
        v := 0;
    lLen := Length(strValue);
    while (lLen > 0) and (strValue[lLen] = ' ') do
        Dec(lLen);
    divider := lLen + 1;
    exponent := 0;
    for i := 1 to lLen do
    begin
        c := strValue[i];
        case c of
            ' ':
                if v <> 0 then
                begin
                    Result := False;
                    Exit;
                end;
            '0'..'9': v := (v * 10) + Integer(c) - Integer('0');
            ',', '.':
                begin
                    if (divider > lLen) then
                        divider := i + 1
                    else
                    begin
                        Result := False;
                        Exit;
                    end;
                end;
            '-', '+':
                if i > 1 then
                begin
                    Result := False;
                    Exit;
                end;
            'e', 'E':
                begin
                    if i + 1 > lLen then
                    begin
                        Result := False;
                        Exit;
                    end;
                    for j := i + 1 to lLen do
                    begin
                        c := strValue[j];
                        case c of
                            '-', '+':
                                if j <> i + 1 then
                                begin
                                    Result := False;
                                    Exit;
                                end;
                            '0'..'9': exponent := (exponent * 10) + Integer(c) - Integer('0');
                        else
                            Result := False;
                            Exit;
                        end;
                    end;
                    if strValue[i + 1] <> '-' then
                        exponent := -exponent;
                    exponent := exponent - 1;
                    lLen := i;
                    if divider > lLen then
                        divider := lLen;
                    Break;
                end;
        else
            Result := False;
            Exit;
        end;
    end;
    divider := lLen - divider + exponent + 1;
    if strValue[1] = '-' then
    begin
        v := -v;
    end;
    if divider <> 0 then
        v := v * Exp(-divider * Ln(10));
    val := v;
    Result := True;
end;

// StrToFloatDef
//
function StrToFloatDef(const strValue: string; defValue: Extended = 0): Extended;
begin
    if not TryStrToFloat(strValue, Result) then
        result := defValue;
end;

end.

