/*
    msPlugInImpl.h - Microsoft DirectX export plug-in for MilkShape.

    Copyright (c) John Thompson, 2001.
    Permission hereby granted to you to use non-exclusively or modify as you wish,
    provided you preserve this copyright message.
*/

#ifndef __MS_PLUGIN_IMPL_H__
#define __MS_PLUGIN_IMPL_H__



#include "msPlugIn.h"
#include "msPlugInData.h"
#include "msPlugInOptions.h"

#define PI 3.141593f

    // Registry sub key for options.
#define kRegistrySubKeyString "Software\\JT Software\\msXExporter"

    // Registry value name string.
#define kRegistryValueNameString "Options"

    // CWinApp class pertaining to the exporter DLL.
class CMSPlugInApp : public CWinApp
{
public:
	CMSPlugInApp();
	DECLARE_MESSAGE_MAP()
        // Overridden InitInstance function for initializing instance.
    virtual BOOL InitInstance();
};

    // DLL app.
extern CMSPlugInApp oPlugInDLLApp;

struct msModel;
struct msBone;
class cPlugIn : public cMsPlugIn, public Node
{
    char szTitle[64];
    char m_caFileName[kNameLen];
    char m_caBaseName[kNameLen];
    char m_caRootFrameName[kNameLen];
    char m_caAnimationSetName[kNameLen];
    FILE *m_pFilePointer;
    Frame *m_opRootFrame;
    Frame *m_opBodyFrame;
    Mesh *m_opBodyMesh;
    FrameArray m_oBoneFrames;
    D3DXVECTOR3 m_oEulerFactor;
    float m_fPositionFactor;
    AnimationSet *m_opAnimationSet;
    bool m_blSkinAndBones;

    // These are the saved options.  Preserve this order or else mess up the
    // previously saved options.
    char m_cStartSave;
    EFormat m_eFormat;
    bool m_blExcludeGeometry;
    bool m_blAddRootFrame;
    bool m_blMeshOnly;
    bool m_blRightHandedCoordinateSystem;
	bool m_blBinary;
    float m_fAnimationTimeFactor;
    D3DXVECTOR3 m_oPositionOffset;
    D3DXVECTOR3 m_oRotation;
    bool m_blFlipTextureVertical;
	bool m_blFlipTextureHorizontal;
    bool m_blExcludeAnimation;
    bool m_blExcludeAnimationOptions;
    bool m_blLoopAnimations;
    bool m_blSplinePositions;
    bool m_blSplineRotations;
    bool m_blMatrixKeys;
    bool m_blCenterAtOffset;
    bool m_blStandAtOffset;
    bool m_blSortOriginalVertices;
	bool m_blAddInterpolations;
	int m_iInterpolationCount;
    bool m_blAddTemplates;
    bool m_blAddSkinAndBonesTemplates;
    bool m_blCloseHoles;
    bool m_blExcludeNormals;
    char m_cEndSave;
    // End of save options.

    float m_fAnimationRangeLow;
    float m_fAnimationRangeHigh;
    D3DXVECTOR3 m_oMinVector;
    D3DXVECTOR3 m_oMaxVector;
    D3DXMATRIX m_oOffsetMatrix;
    D3DXMATRIX m_oOffsetTranslationMatrix;
    D3DXMATRIX m_oOffsetRotationMatrix;

public:
	cPlugIn ();
    virtual ~cPlugIn ();

public:
    int GetType ();
    const char *GetTitle ();
    int Execute (msModel* pMSModel);
    bool LoadOptions();
    bool SaveOptions();
    bool PromptFile();
    bool OpenFile();
    bool CloseFile();
    void CheckForDirectXFormat(msModel *pMSModel);
    bool PromptOptions();
    bool DoRetainedMode(msModel *pMSModel);
    bool DoSkinAndBones(msModel *pMSModel);
    bool DoJTGameSkinAndBones(msModel *pMSModel);
    bool DoJTGameRenderGroups(msModel *pMSModel);
    void CreateBodyMesh(msModel *pMSModel);
    void GetOffsetMatrices();
    void CreateMainFrame();
    bool CreateFrames(msModel *pMSModel);
    bool CreateRetainedModeMeshes();
    bool CollectUnassignedFaces();
    bool CreateSkinAndBonesMesh();
    bool CreateTransformations(msModel *pMSModel);
    bool CreateRenderGroups(msModel *pMSModel);
    bool CreateAnimations(msModel *pMSModel);
    int CountKeys(msBone *pMSBone, bool blRotation);
    bool OutputFileHeader();
    bool OutputTemplates();
    bool OutputGeometry();
    bool OutputMeshes(Frame *opFrame);
    void CleanUp();
    void Debug(const char *cpMessage, ...);
    void DisplayMatrix(const char *cpName, int iIndex, D3DXMATRIX matrix);
    void DisplayTransformation(const char *cpName, D3DXVECTOR3 oVector, D3DXMATRIX oMatrix);
    void DisplayQuaternion(const char *cpName, int iIndex, D3DXQUATERNION quat);
    void MakeNameLegal(char *name, bool isFileName);
    void MatrixRotationYawPitchRoll(
        D3DXMATRIX *opRotationMatrix,
        float fYawY,
        float fPitchX,
        float fRollZ);
};

void Debug(const char *cpMessage, ...);

#endif // __MS_PLUGIN_IMPL_H__