/*
    msPlugInHelp.cpp - Exporter help dialog.

    Copyright (c) John Thompson, 2001-2004.  All rights reserved.
*/

#include "stdafx.h"
#include "resource.h"
#include "msPlugInHelp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const char caHelp[] =
"MilkShape DirectX Exporter - Version 1.06\r\n"
"\r\n"
"Welcome to my DirectX file exporter, provided for your pleasure "
"by me, John Thompson, of JTSoftware, john @jtgame.com. "
"Please read this whole thing before emailing me about questions or problems. "
"If you do email me about a problem, please send me a zip of your .ms3d, .x, and "
"texture files so I can reproduce the problem.\r\n"
"\r\n"
"Shameless Advertisement:  Care to try a powerful but free modeler able to read and "
"write .x files?  Check out JTEdit at:  http://www.jtgame.com/jtedit\r\n"
"\r\n"
"The following describes the available options.\r\n"
"\r\n"
"Overall format options:\r\n"
"\r\n"
"Format:  Selects a sub-format.  The exporter can output both the old "
"DirectX Retained Mode format or the newer skin and bones format "
" originating with DirectX 8, as demonstrated by the "
"DirectX 8 SDK SkinnedMesh sample program.  It can also output two customized "
"formats for the JTGame game framework (www.jtgame.com), which is more efficient "
"and simple for custom loaders.  See \"http://www.jtgame.com/jtfile.html\" "
"for further information on the JTGame formats.\r\n"
"\r\n"
"Note: The Mesh Viewer program in the DirectX 8.1 sdk seems to have some problem "
"with the files this exporter exports when in skin and bones format.  Mesh for "
"bones lower in hierarchy are often missing.  The SkinnedMesh sample sometimes "
"works better.  If anyone can identify any problems with the format as output, "
"please let me know, as I can't seem to find any problem.\r\n"
"\r\n"
"Note: The plug-in appears to crash if you export a model in skinned mesh "
"format with no bones.\r\n"
"\r\n"
"Binary:  Causes the model to be output in DirectX binary format, which "
"is a faster loading and smaller format.\r\n"
"\r\n"
"Templates:  Causes the appropriate templates to be output.  This is a "
"mechanism in the DirectX format for describing the data format content "
"to the loader, such that it can load custom formats which are not "
"predefined.  It also serves as self-documentation.\r\n"
"\r\n"
"S&B Templates:  Outputs just the templates which are extensions "
"to the DirectX Retained Mode format.  This includes the SkinnedMesh "
"extensions as well as the JTGame extensions.  Unfortunately, "
"DirectX 8 did not add the skin and bones extensions to the predefined "
"format templates it supports.  You will need to check this if you use the "
"DirectX 8 SkinnedMesh sample or derivative code.  As a safety measure, "
"when you change to the DirectX skin and bones format, this option will be enabled "
"by default.\r\n"
"\r\n"
"Geometry options:\r\n"
"\r\n"
"Exclude Geometry:  Allows you to leave out the geometry (i.e. Frames and Meshes) "
"presumably so you can output only animation data, for loading one or more "
"animations separately.\r\n"
"\r\n"
"Add Root Frame:  Will insert a top level frame at the top of the frame "
"hierarchy.  This may allow you to have a vanilla frame to modify without "
"disturbing an initial transformation on the original root frame.\r\n"
"\r\n"
"Mesh Only:  Allows you to output only \"Mesh\" objects, and no \"Frame\" "
"objects.\r\n"
"\r\n"
"Right Handed:  Outputs the geometry assuming a right-handed coordinate "
"system.  If not checked, outputs in left-handed form.  The old DirectX "
"Retained Mode format usually used the left-handed coordinate system. "
"The DirectX SkinnedMesh sample uses the right-handed coordinate system. "
"As a safety measure, when you change to the skin and bones format, this "
"option will be selected by default.\r\n"
"\r\n"
"Close Holes:  This option attempts to close holes in the model.  For example, "
"if you are using the Retained Mode format, but your model has assigned "
"vertices to multiple bones in a group, this will cause the group to be "
"split into separate meshes belonging to the different bones, causing the "
"areas of the mesh where the split occurs to be left open, which can be "
"apparent when animated.  This option "
"attempts to cap off these holes by collecting the edges which are not "
"shared, linking them as holes, and tesselating them.  Whether this works "
"very well or not depends a lot on how the mesh is set up.\r\n"
"\r\n"
"Flip Texture Vertical:  Effectively flips the texture vertically by "
"subtracting the texture \"v\" coordinate from 1.0 and using the result "
"for \"v\".\r\n"
"\r\n"
"Flip Texture Horizontal:  Effectively flips the texture horizontally by "
"subtracting the texture \"u\" coordinate from 1.0 and using the result "
"for \"u\".\r\n"
"\r\n"
"Stand at Position Offset:  Adjusts the mesh vertex positions such that "
"the model is standing on the origin (i.e. the model is centered about Y "
"and the lowest point is at Y 0.0), or if a position offset is set, "
"at the position offset.\r\n"
"\r\n"
"Center at Position Offset:  Adjusts the mesh vertex positions such that "
"the model is centered about the origin, or if a position offset is set, "
"about the position offset.\r\n"
"\r\n"
"Exclude Normals:  Omits the vertex normals from the output.\r\n"
"\r\n"
"Position Offset:  Adjusts the mesh by offseting the vertex positions by "
"the X, Y, and Z values of this option, after multiplication by the "
"Position Scaling value.\r\n"
"\r\n"
"Rotation:  Rotates the model by introducing a rotation into the top-level "
"frame of the model.\r\n"
"\r\n"
"Position Scaling:  Adjusts the mesh by multiplying the vertex positions "
"by this value.  The default is set to 0.1 to scale models into a more "
"typical size for DirectX models.\r\n"
"\r\n"
"Root Frame Name:  Allows you to name the inserted root frame name, if "
"the \"Add Root Frame\" option is selected.  The default "
"name is derived from the output file name, less the extension, and "
"appending \"Frame\".\r\n"
"\r\n"
"Animation options:\r\n"
"\r\n"
"Exclude Animation:  Allows you to leave out the animation information "
"(exclude the \"AnimationSet\" object).\r\n"
"\r\n"
"Exclude Options:  Leaves out the animation option objects (AnimationOptions).  "
"If excluded, the animation options (looping and splining) are up to the "
"engine.\r\n"
"\r\n"
"Matrix Keys:  Outputs matrix-based animation keys, as opposed to separate "
"position and rotation keys.  Note that the DirectX 8 "
"SkinnedMesh sample does not do any interpolation for frames between the "
"key times when matrix keys are used.\r\n"
"\r\n"
"Add Interpolations:  Inserts addtional key frames between the MilkShape "
"animation key frames.  The \"Interpolation Count\" option indicates how "
"many key frames to add.  This option is provided for the case of engines "
"which might not do interpolations between key frames when animating.\r\n"
"\r\n"
"Loop Animations:  If the animation options are not excluded, sets the "
"option flag indicating that the animation should loop.\r\n"
"\r\n"
"Spline Positions:  If the animation options are not excluded, sets the "
"option flag indicating that the animation key interpolations, if the engine "
"supports it, should round out the translation movements.\r\n"
"\r\n"
"Spline Rotations:  If the animation options are not excluded, sets the "
"option flag indicating that the animation key interpolations, if the engine "
"supports it, should smooth out the rotation movements.\r\n"
"\r\n"
"Interpolation Count:  If the \"Add Interpolations\" checkbox is checked, "
"this many key frames (less one for the key frame already there) are inserted.\r\n"
"\r\n"
"Animation time factor:  The animation key time values are multiplied by this "
"value, allowing you to scale the animation speed.  The default of 210 "
"scales the animation rate from MilkShape (about 24 frames per second) to "
"approximately match the rate assumed by the DirectX 8 SkinnedMesh "
"sample.\r\n"
"\r\n"
"Animation Range:  Allows you to select and output only a sub-range of the "
"animation.  The animation key times are adjusted to start from 0.  "
"This option might be useful if you output segments of the animation only "
"in separate files.\r\n"
"\r\n"
"Animation Set Name:  Allows you to specify the name of the \"AnimationSet\" "
"object.  Might be useful if outputting separate animation segments.\r\n"
"\r\n"
"Notes:\r\n"
"\r\n"
"The \"Frame\" objects in both the Retained Mode and Skin and Bones sub-formats "
"correspond to the joints in MilkShape, and get their names from there.  "
"In the Retained Mode sub-format, the mesh components which belong to "
"specific bones are collected into a \"Mesh\" object inside the "
"corresponding \"Frame\" object.  The Mesh name is that of the frame, "
"with \"Mesh\" appended.  In the Skin and Bones sub-format, a Frame with "
"the name \"Body\" is injected into the top-level frame, and all the mesh "
"is collected into a Mesh object inside the Body frame, with a name "
"derived from the output file name (less extension) with \"Mesh\" appended.\r\n"
"\r\n"
"Note that Retained Mode-format models typically assume a left-handed "
"coordinate system, whereas Skin and Bones models used by the SkinnedMesh "
"sample assume a right-handed coordinate system.\r\n"
"\r\n";

/////////////////////////////////////////////////////////////////////////////
// msPlugInHelp dialog


msPlugInHelp::msPlugInHelp(CWnd* pParent /*=NULL*/)
	: CDialog(msPlugInHelp::IDD, pParent)
{
	//{{AFX_DATA_INIT(msPlugInHelp)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void msPlugInHelp::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(msPlugInHelp)
	DDX_Control(pDX, IDC_EDIT_HELP, m_oEditHelp);
	//}}AFX_DATA_MAP

    //m_oEditHelp.FmtLines(TRUE);
    m_oEditHelp.SetWindowText(caHelp);
}


BEGIN_MESSAGE_MAP(msPlugInHelp, CDialog)
	//{{AFX_MSG_MAP(msPlugInHelp)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// msPlugInHelp message handlers
