/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */

#include "glxfont.h"
#include "config.h"

#ifdef WIN32
#undef HAVE_XFONT
#endif

#ifdef HAVE_XFONT
#include <GL/glx.h>
#endif 

class GlxFontData
{
   public:
#ifdef HAVE_XFONT
      GlxFontData() : m_display( NULL ), m_glFont( NULL ) {};
#else
      GlxFontData() {};
#endif // HAVE_XFONT
      virtual ~GlxFontData() {};

#ifdef HAVE_XFONT
      Display     * m_display;
      XFontStruct * m_glFont;
#endif
};

GlxFontData * GlxFont_Allocate()
{
   GlxFontData * gfd = new GlxFontData;
   return gfd;
}

void GlxFont_GetFont( GlxFontData * gfd, int displayList, const char * fontStr )
{
#ifdef HAVE_XFONT
   gfd->m_display = XOpenDisplay( NULL );
   gfd->m_glFont  = XLoadQueryFont( gfd->m_display, fontStr );
   glXUseXFont( gfd->m_glFont->fid, FONT_START, FONT_SIZE, displayList );
#endif
}

void GlxFont_Free( GlxFontData * gfd )
{
#ifdef HAVE_XFONT
   XFreeFont( gfd->m_display, gfd->m_glFont );
   XCloseDisplay( gfd->m_display );
#endif
}

