/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include <qgl.h>
#include "qtmain.h"
#include "viewwin.h"
#include "model.h"
#include <unistd.h>
#include <qapplication.h>

#include "log.h"
#include "mm3dport.h"
#include "misc.h"
#include "msg.h"
#include "msgqt.h"
#include "3dmprefs.h"
//#include "startprompt.h"
#include "cmdline.h"
#include "checkupdate.h"

static bool _has_gl_support()
{
   if ( ! QGLFormat::hasOpenGL() )
   {
      log_error( "No openGL support, exiting...\n" );
      return false;
   }

   QGLFormat format = QGLFormat::defaultFormat();

   format.setDoubleBuffer( true );
   format.setRgba( true );
   format.setAlpha( true );

   QGLFormat::setDefaultFormat( format );

   format = QGLFormat::defaultFormat();

   log_debug( "qt says alpha is%s enabled\n", (format.alpha() ? "" : " not" ) );

   return true;
}

static void _cleanup()
{
   // TODO add any necessary cleanup
}

static void _update_check()
{
   int p = -1;
   int currentDate = 0;

   if ( g_prefs.exists( "ui_check_update_enabled" ) )
   {
      p = g_prefs( "ui_check_update_enabled" );
   }

   if ( p > 0 )
   {
      int checkDate = g_prefs( "ui_check_update_date" );

      time_t t;
      time( &t );
      struct tm tval;

      PORT_localtime_r( &t, &tval );

      currentDate = (1900 + tval.tm_year) * 10000 + (tval.tm_mon + 1) * 100 + tval.tm_mday;

      if ( currentDate != checkDate )
      {
         log_debug( "starting update check\n" );
         check_update_start();
      }
      else
      {
         log_debug( "skipping update check\n" );
      }

      g_prefs( "ui_check_update_date" ) = currentDate;
   }

   g_prefs( "ui_check_update_enabled" ) = p;
}

int ui_init( int argc, char * argv[] )
{
   int rval = 0;

   QApplication app( argc, argv );

   if ( cmdline_runcommand )
   {
      rval = cmdline_command( argc, argv );
   }
   if ( cmdline_runui )
   {
      _update_check();

      if ( ! _has_gl_support() )
      {
         return -1;
      }

      bool opened = false;
      unsigned openCount = 0;

      init_msgqt();

      openCount = cmdline_getOpenModelCount();

      if ( openCount == 0 )
      {
         for ( int t = 1; t < argc; t++ )
         {
            char pwd[ PATH_MAX ];
            getcwd( pwd, PATH_MAX );
            std::string file = normalizePath( argv[t], pwd );
            if ( ViewWindow::openModel( file.c_str() ) )
            {
               openCount++;
               opened = true;
            }
         }
      }
      else
      {
         for ( unsigned t = 0; t < openCount; t++ )
         {
            Model * m = cmdline_getOpenModel( t );
            ViewWindow * win = new ViewWindow( m, NULL, "" );
            win->getSaved(); // Just so I don't have a warning
            opened = true;
         }

         cmdline_clearOpenModelList();
      }

      if ( opened )
      {
         rval = app.exec();
      }
      else
      {
         ViewWindow * win = new ViewWindow( new Model );
         win->getSaved(); // Just so I don't have a warning
         rval = app.exec();

         /*
            StartPrompt p;
            p.exec();

            if ( !p.shouldExit() )
            {
            rval = app.exec();
            }
            */
      }

      _cleanup();
   }

   return rval;
}

void ui_exit()
{
   _cleanup();
   if ( qApp )
   {
      qApp->quit();
   }
   else
   {
      exit( 0 );
   }
}

