/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "jointtool.h"

#include "model.h"
#include "msg.h"
#include "log.h"
#include "modelstatus.h"

#include "pixmap/jointtool.xpm"

JointTool::JointTool()
   : m_jointId( -1 )
{
}

JointTool::~JointTool()
{
}


void JointTool::mouseButtonDown( Parent * parent, int buttonState, int x, int y )
{
   Model * model = parent->getModel();

   double coord[3] = {0,0,0};

   int c1 = 0;
   int c2 = 0;

   if ( !parent->getXValue( x, y, &coord[0] ) )
   {
      c1 = 1;
      c2 = 2;
   }
   if ( !parent->getYValue( x, y, &coord[1] ) )
   {
      c1 = 0;
      c2 = 2;
   }
   if ( !parent->getZValue( x, y, &coord[2] ) )
   {
      c1 = 0;
      c2 = 1;
   }

   int p = -1;
   double pDist = 0.0;
   double parentCoords[3];
   int jointCount = model->getBoneJointCount();

   for ( int t = 0; t < jointCount; t++ )
   {
      model->getBoneJointCoords( t, parentCoords );
      double dist = distance( coord[c1], coord[c2], parentCoords[c1], parentCoords[c2] );
      if ( p == -1 || dist < pDist )
      {
         p = t;
         pDist = dist;
      }
   }

   // Find a unique name for the joint
   char name[32] = "Joint 1";
   unsigned c = model->getBoneJointCount();
   bool uniqueName = (c == 0) ? true : false;

   for ( unsigned i = 1; !uniqueName && i < 1000; i++ )
   {
      uniqueName = true;
      sprintf( name, "Joint %d", i );
      for ( unsigned j = 0; j < c; j++ )
      {
         if ( strcmp( name, model->getBoneJointName( j ) ) == 0 )
         {
            uniqueName = false;
            break;
         }
      }
   }

   // I give up, just call it "Joint"
   if ( ! uniqueName )
   {
      strcpy( name, "Joint" );
   }

   m_jointId = model->addBoneJoint( name, coord[0], coord[1], coord[2], 0, 0, 0, p );

   model->unselectAll();
   model->selectBoneJoint( m_jointId );

   parent->updateAllViews();

   if ( p >= 0 )
   {
      model_status( model, StatusNormal, STATUSTIME_SHORT, "Joint created" );
   }
   else
   {
      model_status( model, StatusNormal, STATUSTIME_SHORT, "Root joint created" );
   }
}

void JointTool::mouseButtonMove( Parent * parent, int buttonState, int x, int y )
{
   if ( m_jointId >= 0 )
   {
      double coord[3] = {0,0,0};

      parent->getXValue( x, y, &coord[0] );
      parent->getYValue( x, y, &coord[1] );
      parent->getZValue( x, y, &coord[2] );

      parent->getModel()->moveBoneJoint( m_jointId, coord[0], coord[1], coord[2] );

      parent->updateAllViews();
   }
}

void JointTool::mouseButtonUp( Parent * parent, int buttonState, int x, int y )
{
}

const char ** JointTool::getPixmap()
{
   return (const char **) jointtool_xpm;
}

