/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#ifndef __DUPCMD_H
#define __DUPCMD_H

#include "command.h"

#include <qnamespace.h>

class DuplicateCommand : public Command
{
   public:
      DuplicateCommand();
      virtual ~DuplicateCommand();

      int getCommandCount() { return 1; };
      const char * getName( int arg ) { return "Duplicate"; };
      bool getKeyBinding( int arg, int & keyBinding ) { keyBinding = Qt::CTRL+Qt::Key_D; return true; };

      bool activated( int arg, Model * model );

      bool isPrimitive() { return true; };

   protected:
};

#endif // __DUPCMD_H
