/*****************************************************************
Copyright (c) 1998 Jawed Karim <jkarim@students.uiuc.edu>
All rights reserved.

This source code has been provided to you under the condition
that you adhere to the following terms:

1. YOU MAY USE THIS SOURCE CODE PRIVATELY WITHOUT RESTRICTIONS.

2. REDISTRIBUTIONS OF MODIFICATIONS OF THIS PROGRAM IN BINARY OR
   IN SOURCE CODE FORM ARE NOT PERMITTED.

3. REDISTRIBUTIONS OF THIS SOURCE CODE ARE ONLY PERMITTED IF
   THE SOURCE CODE REMAINS COMPLETELY UNCHANGED AND ALL THE
   FILES WHICH WERE IN THE ORIGINAL DISTRIBUTION ARE INCLUDED.

4. ALL SOFTWARE USING SECTIONS OF THIS SOURCE CODE MUST GIVE
   EXPLICIT ACKNOWLEDGMENT TO JAWED KARIM IN THE PROGRAM
   ITSELF AS WELL AS IN THE DOCUMENTATION.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION).
*****************************************************************/

#include <iostream.h>
#include <windows.h>
#include <commctrl.h>
#include <windowsx.h>

#include "slidebar.h"

void CSlidebar::Initialize (HWND hwnd)
{
	m_sliderHwnd = hwnd;

	m_sliderMax = m_sliderMin = m_sliderCurrent = 0;

	setRange (0, 0);
}

void CSlidebar::setRange (int iMin, int iMax)
{
	if (iMin >= 0)
	{
		m_sliderMax = iMax;
		m_sliderMin = iMin;

		SendMessage (m_sliderHwnd, TBM_SETRANGEMIN, (WPARAM)TRUE, (LPARAM)iMin);
		SendMessage (m_sliderHwnd, TBM_SETRANGEMAX, (WPARAM)TRUE, (LPARAM)iMax);
	}
}

void CSlidebar::setPosition (int iPosition)
{
	if (iPosition >= m_sliderMin && iPosition <= m_sliderMax)
	{
		m_sliderCurrent = iPosition;
		SendMessage (m_sliderHwnd, TBM_SETPOS, TRUE, m_sliderCurrent);
	}
}

int CSlidebar::getPosition (void)
{
	return (int) SendMessage (m_sliderHwnd, TBM_GETPOS, 0, 0);
}

void CSlidebar::setFocus (void)
{
	SetFocus (m_sliderHwnd);
}