/*****************************************************************
Copyright (c) 1998 Jawed Karim <jkarim@students.uiuc.edu>
All rights reserved.

This source code has been provided to you under the condition
that you adhere to the following terms:

1. YOU MAY USE THIS SOURCE CODE PRIVATELY WITHOUT RESTRICTIONS.

2. REDISTRIBUTIONS OF MODIFICATIONS OF THIS PROGRAM IN BINARY OR
   IN SOURCE CODE FORM ARE NOT PERMITTED.

3. REDISTRIBUTIONS OF THIS SOURCE CODE ARE ONLY PERMITTED IF
   THE SOURCE CODE REMAINS COMPLETELY UNCHANGED AND ALL THE
   FILES WHICH WERE IN THE ORIGINAL DISTRIBUTION ARE INCLUDED.

4. ALL SOFTWARE USING SECTIONS OF THIS SOURCE CODE MUST GIVE
   EXPLICIT ACKNOWLEDGMENT TO JAWED KARIM IN THE PROGRAM
   ITSELF AS WELL AS IN THE DOCUMENTATION.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION).
*****************************************************************/

#include <stdio.h>
#include <iostream.h>
#include <windows.h>
#include <commctrl.h>
#include <windowsx.h>
#include <math.h>

#define MAX_TRIANGLES 4096
#define MAX_VERTS 2048
#define MAX_FRAMES 512
#define MAX_MD2SKINS 32
#define MAX_SKINNAME 64

typedef struct
{
	int a, b, c;
	int a_s, a_t,
		b_s, b_t,
		c_s, c_t;
} make_index_list;

typedef struct
{
	float x, y, z;
} make_vertex_list;

typedef struct
{
	make_vertex_list *vertex;
} make_frame_list;

typedef unsigned char byte;

typedef struct
{
	float v[3];
}vec3_t;

typedef struct
{
	short s;
	short t;
} dstvert_t;

typedef struct 
{
	short index_xyz[3];
	short index_st[3];
} dtriangle_t;


typedef struct
{
	byte v[3];
	byte lightnormalindex;
} dtrivertx_t;

typedef struct
{
	float scale[3];
	float translate[3];
	char name[16];
	dtrivertx_t verts[1];

} daliasframe_t;

typedef struct
{
	int ident;
	int version;

	int skinwidth;
	int skinheight;
	int framesize;

	int num_skins;
	int num_xyz;
	int num_st;
	int num_tris;
	int num_glcmds;
	int num_frames;

	int ofs_skins;
	int ofs_st;
	int ofs_tris;
	int ofs_frames;
	int ofs_glcmds; 
	int ofs_end;

} dmdl_t;

typedef struct
{
        vec3_t          v;
        int		lightnormalindex;
} trivert_t;

typedef struct
{
        vec3_t          mins, maxs;
        char            name[16];
        trivert_t       v[MAX_VERTS];
} frame_t;

//////////////////////////////////////////////////////////////////////////////////////

class CMD2 {

friend void redraw (int);

public:
	CMD2();
	~CMD2();

	int Read (char []);
	void Destroy (void);

	inline long getnumberFrames (void) {return (long)m_iFrames;};
	inline long getnumberVertices (void) {return (long)m_iVertices;};
	inline long getnumberTriangles (void){return (long)m_iTriangles;};

	void SafeRead (FILE *f, void *buffer, int count) {fread (buffer, 1, count, f);}

private:

	make_index_list *m_index_list;
	make_frame_list *m_frame_list;

	long m_iFrames, m_iVertices, m_iTriangles;
};
