//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//
//
#include "mdl.h"
#include "mdl_gif.h"


//  export mdl frame to :  asc,pov,wrl,raw,dfx,map,(3ds  almost)
void export_mdl_frame(char *filename, int frame, MDL_model *model)
{
	#include "mdl_norm.h"

	// frame is really frame-1 since indices start at 0

	strlwr(filename);
	char  *ptr;

	///////////////////////////////// 3ds out-doesn't  work right, use asc!
	if(strstr(filename,".3ds"))
	{
		FILE *out;

		out=fopen(filename,"wb");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }

		// do this first to get length

		unsigned short matr=0x4160;
		unsigned malength=2+4+4*3*4;

		unsigned short tris=0x4120;
		short unsigned num_tris=(short unsigned)model->num_triangles;
		unsigned tlength=2+4+(unsigned)num_tris*4*2;

		unsigned short vert=0x4110;
		short unsigned num_verts=(short unsigned)model->num_vertices;
		unsigned vlength=2+4+(unsigned)num_verts*3*2;

		unsigned short block=0x4100;
		unsigned blength=2+4+vlength+tlength+malength;

		unsigned short object=0x4000;
		char oname[128];
		sprintf(oname,"%s",model->block[frame-1].name);
		unsigned olength=2+4+strlen(oname)+1+blength;

		unsigned short mesh=0x3d3d;
		unsigned mlength=2+4+olength;

		unsigned short magic=0x4d4d;
		unsigned filelength=2+4+mlength;

		// magic numbers
		fwrite(&magic,2,1,out);
		fwrite(&filelength,4,1,out);

		// mesh chunk
		fwrite(&mesh,2,1,out);
		fwrite(&mlength,4,1,out);

		// write object chunk
		fwrite(&object,2,1,out);
		fwrite(&olength,4,1,out);
		fwrite(oname,strlen(oname)+1,1,out);

		// write block
		fwrite(&block,2,1,out);
		fwrite(&blength,4,1,out);

		// write all vertices
		fwrite(&vert,2,1,out);
		fwrite(&vlength,4,1,out);
		fwrite(&num_verts,2,1,out);
		for(int i=0; i<num_verts; i++)
		{
			float vx,vy,vz;
			vy=(float)(model->block[frame-1].ptlist[i].x);//-model->xoffset);
			vx=-(float)(model->block[frame-1].ptlist[i].y);//-model->yoffset);
			vz=(float)(model->block[frame-1].ptlist[i].z);//-model->zoffset);
			fwrite(&vx,4,1,out);
			fwrite(&vy,4,1,out);
			fwrite(&vz,4,1,out);
		}
		// write tris (faces)
		fwrite(&tris,2,1,out);
		fwrite(&tlength,4,1,out);
		fwrite(&num_tris,2,1,out);
		for(int i=0; i<num_tris; i++)
		{
			unsigned short v1,v2,v3,v4=0;
			v1=(short unsigned)model->side[i].pt[0];
			v2=(short unsigned)model->side[i].pt[1];
			v3=(short unsigned)model->side[i].pt[2];

			fwrite(&v1,2,1,out);
			fwrite(&v2,2,1,out);
			fwrite(&v3,2,1,out);
			fwrite(&v4,2,1,out);
		}
		// orietation matrix
		fwrite(&matr,2,1,out);
		fwrite(&malength,4,1,out);
		float m[3];
		m[0]=1.;m[1]=0.;m[2]=0.;
		fwrite(&m,4,3,out);
		m[0]=0.;m[1]=1.;m[2]=0.;
		fwrite(&m,4,3,out);
		m[0]=0.;m[1]=0.;m[2]=1.;
		fwrite(&m,4,3,out);
		m[0]=0.;m[1]=0.;m[2]=0.;
		fwrite(&m,4,3,out);

		fclose(out);
	}

	///////////////////////////////// asc (3ds) out
	else if(strstr(filename,".asc"))
	{
		FILE *out;

		out=fopen(filename,"wt");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }


		fprintf(out,"Ambient light color: Red=0.039216 Green=0.039216 Blue=0.039216\n\n");
		fprintf(out,"Named object: \"%s\"\n",model->block[frame-1].name);
		fprintf(out,"Tri-mesh, Vertices: %d    Faces: %d\n",(int)model->num_vertices,(int)model->num_triangles);
		fprintf(out,"Vertex list:\n");
		for(int i=0; i<model->num_vertices; i++)
		{
			fprintf(out,"Vertex %d:  X: %lf  Y: %lf  Z: %lf\n",i,
				model->block[frame-1].ptlist[i].y,
				-model->block[frame-1].ptlist[i].x,
				model->block[frame-1].ptlist[i].z);
		}
		fprintf(out,"Face list:\n");
		for(int i=0; i<model->num_triangles; i++)
		{
			// reverse order and say that no sides lie in a plane
			fprintf(out,"Face %d:  A:%u B:%u C:%u AB:1 BC:1 CA:1\n",i,
			model->side[i].pt[0],
			model->side[i].pt[2],
			model->side[i].pt[1]);
//			fprintf(out,"Smoothing:  %d\n",1);
		}

		fclose(out);
	}
	///////////////////////////////// clayworks out
	else if(strstr(filename,".3d"))
	{
		FILE *out;

		out=fopen(filename,"wb");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }

		unsigned short int tmp;
		tmp=(word)model->num_vertices;
		fwrite(&tmp,2,1,out);
		int joints;
		joints=3*model->num_triangles;
		tmp=(word)joints;
		fwrite(&tmp,2,1,out);
		tmp=(word)model->num_triangles;
		fwrite(&tmp,2,1,out);


		for(int i=0; i<model->num_vertices; i++)
		{
			float ftmp;
			ftmp=model->block[frame-1].ptlist[i].y;
			fwrite(&ftmp,4,1,out);
			ftmp=-model->block[frame-1].ptlist[i].x;
			fwrite(&ftmp,4,1,out);
			ftmp=model->block[frame-1].ptlist[i].z;
			fwrite(&ftmp,4,1,out);

		}

		// joints
		for(int i=0; i<model->num_triangles; i++)
		{
			tmp=model->side[i].pt[0];
			fwrite(&tmp,2,1,out);
			tmp=model->side[i].pt[2];
			fwrite(&tmp,2,1,out);

			fwrite(&tmp,2,1,out);
			tmp=model->side[i].pt[1];
			fwrite(&tmp,2,1,out);

			fwrite(&tmp,2,1,out);
			tmp=model->side[i].pt[0];
			fwrite(&tmp,2,1,out);
		}

		for(int i=0; i<model->num_triangles; i++)
		{
			byte ctmp;
			ctmp=3;
			fwrite(&ctmp,1,1,out);
			tmp=model->side[i].pt[0];
			fwrite(&tmp,2,1,out);
			tmp=model->side[i].pt[2];
			fwrite(&tmp,2,1,out);
			tmp=model->side[i].pt[1];
			fwrite(&tmp,2,1,out);
			ctmp=0;
			fwrite(&ctmp,1,1,out);
			fwrite(&ctmp,1,1,out);
		}

		fclose(out);
	}
	///////////////////////////////// pov out
	else if(strstr(filename,".pov"))
	{
		FILE *out;

		out=fopen(filename,"wt");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }


		fprintf(out,"// POV scene my MedDLe.  Note this  is just an object.\n");
		fprintf(out,"// You need to add stuff if youu want to render it.\n\n");
		fprintf(out,"// Object: %s\n",model->block[frame-1].name);
		fprintf(out,"object\n");
		fprintf(out,"{\n");
		fprintf(out,"\tunion\n\t{\n");
		// i could just use the triangle command,  but  may as well
		// through  in the vertex normals
		for(int i=0; i<model->num_triangles; i++)
		{
			fprintf(out,"\tsmooth_triangle\n\t{\n");
			fprintf(out,"\t\t<%lf,%lf,%lf>,",
				-model->block[frame-1].ptlist[model->side[i].pt[0]].y,
				model->block[frame-1].ptlist[model->side[i].pt[0]].x,
				model->block[frame-1].ptlist[model->side[i].pt[0]].z);
			fprintf(out," <%lf,%lf,%lf>,\n",
				-vertex_normal[model->block[frame-1].nindex[model->side[i].pt[0]]].y,
				vertex_normal[model->block[frame-1].nindex[model->side[i].pt[0]]].x,
				vertex_normal[model->block[frame-1].nindex[model->side[i].pt[0]]].z);
			fprintf(out,"\t\t<%lf,%lf,%lf>,",
				-model->block[frame-1].ptlist[model->side[i].pt[1]].y,
				model->block[frame-1].ptlist[model->side[i].pt[1]].x,
				model->block[frame-1].ptlist[model->side[i].pt[1]].z);
			fprintf(out," <%lf,%lf,%lf>,\n",
				-vertex_normal[model->block[frame-1].nindex[model->side[i].pt[1]]].y,
				vertex_normal[model->block[frame-1].nindex[model->side[i].pt[1]]].x,
				vertex_normal[model->block[frame-1].nindex[model->side[i].pt[1]]].z);
			fprintf(out,"\t\t<%lf,%lf,%lf>,",
				-model->block[frame-1].ptlist[model->side[i].pt[2]].y,
				model->block[frame-1].ptlist[model->side[i].pt[2]].x,
				model->block[frame-1].ptlist[model->side[i].pt[2]].z);
			fprintf(out," <%lf,%lf,%lf>\n",
				-vertex_normal[model->block[frame-1].nindex[model->side[i].pt[2]]].y,
				vertex_normal[model->block[frame-1].nindex[model->side[i].pt[2]]].x,
				vertex_normal[model->block[frame-1].nindex[model->side[i].pt[2]]].z);
			fprintf(out,"\t}\n");
		}
		fprintf(out,"\t}\n}\n");
		fclose(out);
	}

	///////////////////////////////// raw out
	else if(strstr(filename,".raw"))
	{
		FILE *out;

		out=fopen(filename,"wt");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }
		char name[24];

		strcpy(name,model->block[frame-1].name);
		strupr(name);
		fprintf(out,"%s\n",name);
		for(int i=0; i<model->num_triangles; i++)
		{

			fprintf(out,"%lf %lf %lf\t",
				-model->block[frame-1].ptlist[model->side[i].pt[0]].y,
				model->block[frame-1].ptlist[model->side[i].pt[0]].x,
				model->block[frame-1].ptlist[model->side[i].pt[0]].z);
			fprintf(out,"%lf %lf %lf\t",
				-model->block[frame-1].ptlist[model->side[i].pt[1]].y,
				model->block[frame-1].ptlist[model->side[i].pt[1]].x,
				model->block[frame-1].ptlist[model->side[i].pt[1]].z);
			fprintf(out,"%lf %lf %lf\n",
				-model->block[frame-1].ptlist[model->side[i].pt[2]].y,
				model->block[frame-1].ptlist[model->side[i].pt[2]].x,
				model->block[frame-1].ptlist[model->side[i].pt[2]].z);
		}

		fclose(out);

	}
	// geo
		///////////////////////////////// raw out
	else if(strstr(filename,".geo"))
	{
		FILE *out;

		out=fopen(filename,"wt");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }
		char name[24];

		strcpy(name,model->block[frame-1].name);
		strupr(name);
		fprintf(out,"%d %d\n",model->num_vertices,model->num_triangles);
		for( int i=0; i<model->num_vertices ;i++)
		{
			fprintf(out,"%lf %lf %lf\n",
			model->block[frame-1].ptlist[i].x,
			model->block[frame-1].ptlist[i].y,
			model->block[frame-1].ptlist[i].z);
		}

		for(int i=0; i<model->num_triangles; i++)
		{
			fprintf(out,"3 %d %d %d\n",model->side[i].pt[0],
			model->side[i].pt[1],model->side[i].pt[2]);
		}

		fclose(out);

	}
	else if(strstr(filename,".obj"))
	{
		FILE *out;

		out=fopen(filename,"wt");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }
		char name[24];

		strcpy(name,model->block[frame-1].name);
		strupr(name);
		fprintf(out,"%s\n",name);
		fprintf(out,"%d\n",model->num_vertices);
		for( int i=0; i<model->num_vertices ;i++)
		{
			fprintf(out,"%lf %lf %lf\n",
			model->block[frame-1].ptlist[i].x,
			model->block[frame-1].ptlist[i].y,
			model->block[frame-1].ptlist[i].z);
		}
		fprintf(out,"%d\n",model->num_triangles);
		for(int i=0; i<model->num_triangles; i++)
		{
			fprintf(out,"3 %d %d %d\n",model->side[i].pt[0],
			model->side[i].pt[1],model->side[i].pt[2]);
		}

		fclose(out);

	}


	else if(strstr(filename,".map"))
	{
		FILE *out;

		out=fopen(filename,"wt");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }

		fprintf(out,"{\n");
		fprintf(out,"\t\"message\"\t\"mdl model frame: %s\"\n",model->block[frame-1].name);
		fprintf(out,"\t\"message\"\t\"all values must be in a 255x255x255 cube!\"\n",model->block[frame-1].name);
		fprintf(out,"\t\"wad\"\t\"skin.wad\"\n");
		fprintf(out,"\t\"classname\"\t\"worldspawn\"\n");
		fprintf(out,"\t{\n");

		for(int i=0; i<model->num_triangles; i++)
		{

			fprintf(out,"\t ( %d %d %d ) ",
				-(int)((model->block[frame-1].ptlist[model->side[i].pt[0]].y-model->yoffset)/model->yscale),
				(int)((model->block[frame-1].ptlist[model->side[i].pt[0]].x-model->xoffset)/model->xscale),
				(int)((model->block[frame-1].ptlist[model->side[i].pt[0]].z-model->zoffset)/model->zscale));
			fprintf(out,"(%d %d %d) ",
				-(int)((model->block[frame-1].ptlist[model->side[i].pt[1]].y-model->yoffset)/model->yscale),
				(int)((model->block[frame-1].ptlist[model->side[i].pt[1]].x-model->xoffset)/model->xscale),
				(int)((model->block[frame-1].ptlist[model->side[i].pt[1]].z-model->zoffset)/model->zscale));
			fprintf(out,"(%d %d %d) ",
				-(int)((model->block[frame-1].ptlist[model->side[i].pt[2]].y-model->yoffset)/model->yscale),
				(int)((model->block[frame-1].ptlist[model->side[i].pt[2]].x-model->xoffset)/model->xscale),
				(int)((model->block[frame-1].ptlist[model->side[i].pt[2]].z-model->zoffset)/model->zscale));
			fprintf(out,"SKIN 0 0 0 1 1\n");

		}
		fprintf(out,"\t}\n}\n");

		fclose(out);

	}
	else if(strstr(filename,".dxf"))
	{
		FILE *out;
		out=fopen(filename,"wt");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }
		fprintf(out,"0\nSECTION\n2\nHEADER\n0\nENDSEC\n");
//		fprintf(out,"0\nSECTION\n2\nTABLES\n");
//		fprintf(out,"0\nTABLE\n2\nLAYER\n");
		//layer 2 and 1
//		fprintf(out,"0\nLAYER\n2\n1\n0\nLAYER\n2\n2\n");
//		fprintf(out,"0\nENDTAB\n0\nENDSEC\n");
//		fprintf(out,"0\nSECTION\n2\nBLOCKS\n0\nENDSEC\n");
		fprintf(out,"0\nSECTION\n2\nENTITIES\n");
		// 3d stuff goes here
		// i  should place every frame on a different layer

		for(int i=0; i<model->num_triangles; i++)
		{

			// draw  3d face on layer 1
			fprintf(out,"0\n3DFACE\n8\n0\n");
			// color 2
			fprintf(out,"62\n0\n");
			// 3 vertices, with last one twice
			fprintf(out,"10\n%lf\n",-model->block[frame-1].ptlist[model->side[i].pt[0]].y);//-model->xoffset);
			fprintf(out,"20\n%lf\n",model->block[frame-1].ptlist[model->side[i].pt[0]].x);//-model->yoffset);
			fprintf(out,"30\n%lf\n",model->block[frame-1].ptlist[model->side[i].pt[0]].z);//-model->zoffset);
			fprintf(out,"11\n%lf\n",-model->block[frame-1].ptlist[model->side[i].pt[1]].y);//-model->xoffset);
			fprintf(out,"21\n%lf\n",model->block[frame-1].ptlist[model->side[i].pt[1]].x);//-model->yoffset);
			fprintf(out,"31\n%lf\n",model->block[frame-1].ptlist[model->side[i].pt[1]].z);//-model->zoffset);
			fprintf(out,"12\n%lf\n",-model->block[frame-1].ptlist[model->side[i].pt[2]].y);//-model->xoffset);
			fprintf(out,"22\n%lf\n",model->block[frame-1].ptlist[model->side[i].pt[2]].x);//-model->yoffset);
			fprintf(out,"32\n%lf\n",model->block[frame-1].ptlist[model->side[i].pt[2]].z);//-model->zoffset);
			fprintf(out,"13\n%lf\n",-model->block[frame-1].ptlist[model->side[i].pt[2]].y);//-model->xoffset);
			fprintf(out,"23\n%lf\n",model->block[frame-1].ptlist[model->side[i].pt[2]].x);//-model->yoffset);
			fprintf(out,"33\n%lf\n",model->block[frame-1].ptlist[model->side[i].pt[2]].z);//-model->zoffset);

		}

		fprintf(out,"0\nENDSEC\n");
		fprintf(out,"0\nEOF\n");

		fclose(out);
	}

	///////////////////////////////// wrl out
	else if(strstr(filename,".wrl") || strstr(filename,".wrz"))
	{

		FILE *out;
		out=fopen(filename,"wt");
		if(out==NULL) { printf("can't create file\n"); getch(); return; }
		fprintf(out,"#VRML V1.0 ascii\n\n# Created by MedDLe\n# by Brian Martin\n# brian@phyast.pitt.edu\n\n");
		fprintf(out,"Separator {\n");
		fprintf(out,"\tPerspectiveCamera {\n");
		fprintf(out,"\t\tposition    0. 0. 100.\n");
		fprintf(out,"\t}\n");
		fprintf(out,"\tDEF %s Separator {\n",model->block[frame-1].name );


		fprintf(out,"\t\tMaterial { diffuseColor [ 0.5 0.5 0.5 ] }\n");
		fprintf(out,"\t\tTexture2 {\n");
		fprintf(out,"\t\t\tfilename \"skin.gif\"\n");
		fprintf(out,"\t\t}\n");

		// these are all the 2d points including the seemed ones
		fprintf(out,"\t\tTextureCoordinate2 {\n");
		fprintf(out,"\t\t\tpoint [\n");
		for(int i=0; i<model->num_vertices; i++)
		{
			float s,t;
			s=model->vertex[i*3+1];
			t=model->skinh-model->vertex[i*3+2];
			s/=(float)model->skinw;
			t/=(float)model->skinh;
			fprintf(out,"\t\t\t%f %f,\n",s,t);
		}
		// add ones on seem plus extras
		for(int i=0; i<model->num_vertices; i++)
		{
			float s,t;
			s=model->skinw/2+model->vertex[i*3+1];
			t=model->skinh-model->vertex[i*3+2];
			s/=(float)model->skinw;
			t/=(float)model->skinh;
			fprintf(out,"\t\t\t%f %f,\n",s,t);
		}
		fprintf(out,"\t\t\t]\n\t\t}\n");

		fprintf(out,"\t\tCoordinate3 {\n\t\tpoint [\n");
		for( int i=0; i<model->num_vertices ;i++)
		{
			// vrml wacky coordinate system...
			fprintf(out,"\t\t\t%lf %lf %lf,\n",
			-model->block[frame-1].ptlist[i].y,
			model->block[frame-1].ptlist[i].z,
			model->block[frame-1].ptlist[i].x);
		}

		fprintf(out,"\t\t\t]\n\t\t}\n");
		fprintf(out,"\t\tIndexedFaceSet {\n");
		fprintf(out,"\t\tcoordIndex [\n");
		for( int i=0; i<model->num_triangles ;i++)
		{
			fprintf(out,"\t\t\t%d, %d, %d, -1,\n",
			model->side[i].pt[0],
			model->side[i].pt[1],
			model->side[i].pt[2] );
		}
		fprintf(out,"\t\t\t]\n");
		fprintf(out,"\t\ttextureCoordIndex [\n");
		int x1,x2,x3;
		unsigned p1,p2,p3,p4;
		unsigned offset=model->num_vertices;
		for(int i=0;i<model->num_triangles;i++)
		{
			p1=model->triangle[i*4+1];
			p2=model->triangle[i*4+2];
			p3=model->triangle[i*4+3];
			p4=model->triangle[i*4];
			x1=x2=x3=0;
			if((model->vertex[3*p1]==32)&&(p4==0)) x1=1;
			if((model->vertex[3*p2]==32)&&(p4==0)) x2=1;
			if((model->vertex[3*p3]==32)&&(p4==0)) x3=1;

			BG_Line(model->vertex[p1*3+1]+x1,model->vertex[p1*3+2],model->vertex[p2*3+1]+x2,model->vertex[p2*3+2],8);
			BG_Line(model->vertex[p2*3+1]+x2,model->vertex[p2*3+2],model->vertex[p3*3+1]+x3,model->vertex[p3*3+2],8);
			BG_Line(model->vertex[p3*3+1]+x3,model->vertex[p3*3+2],model->vertex[p1*3+1]+x1,model->vertex[p1*3+2],8);
			fprintf(out,"\t\t\t%d, %d, %d, -1,\n",
			p1+x1*offset,
			p2+x2*offset,
			p3+x3*offset);
		}
		fprintf(out,"\t\t\t]\n");
		fprintf(out,"\t\t}\n");

		fprintf(out,"\t}\n");
		fprintf(out,"}"); //end

		fclose(out);
	}
	else
	{
		printf("Don't know that file extension.\nHit a key.\n");
		getch();
	}

	return;


}


void export_mdl_skin(char *filename, int skin, MDL_model *model )
{
	strlwr(filename);
	char  *ptr;

	if(strstr(filename,".gif"))
	{
		int	i,j, Error, NumFiles, ExtCode;
		GifRecordType RecordType;
		GifByteType *Extension;
		GifRowType *ImageBuffer;
		GifFileType *GifFileOut = NULL;
		ColorMapObject CM;
		CM.Colors=new(GifColorType)[256];

		if((skin<=model->num_skins)&&(skin>0))
		{
			write_gif(filename, model->skin[skin-1].bitmap, model->skinw, model->skinh);
		}
		// new skin (polygon pic)
		if(skin<=0)
		{
			int x1,x2,x3;
			unsigned p1,p2,p3,p4;
			unsigned char *pic;
			pic= new(unsigned char)[model->skinw*model->skinh];

			for(j=0; j<model->skinh; j++)
			{
				for(i=0; i<model->skinw; i++)
				{
					pic[i+model->skinw*j]=0;
				}
			}

			int v1[2], v2[2];
			for(i=0;i<model->num_triangles;i++)
			{
				p1=model->triangle[i*4+1];
				p2=model->triangle[i*4+2];
				p3=model->triangle[i*4+3];
				p4=model->triangle[i*4];
				x1=x2=x3=0;
				if((model->vertex[3*p1]==32)&&(p4==0)) x1=model->skinw/2;
				if((model->vertex[3*p2]==32)&&(p4==0)) x2=model->skinw/2;
				if((model->vertex[3*p3]==32)&&(p4==0)) x3=model->skinw/2;
				v1[0]=model->vertex[p2*3+1]+x2;
				v1[1]=model->vertex[p2*3+2];
				v2[0]=model->vertex[p3*3+1]+x3;
				v2[1]=model->vertex[p3*3+2];
				vline(pic,v1,v2,model);
				v1[0]=model->vertex[p3*3+1]+x3;
				v1[1]=model->vertex[p3*3+2];
				v2[0]=model->vertex[p1*3+1]+x1;
				v2[1]=model->vertex[p1*3+2];
				vline(pic,v1,v2,model );
				v1[0]=model->vertex[p1*3+1]+x1;
				v1[1]=model->vertex[p1*3+2];
				v2[0]=model->vertex[p2*3+1]+x2;
				v2[1]=model->vertex[p2*3+2];
				vline(pic,v1,v2,model);

			}

			write_gif(filename, pic, model->skinw, model->skinh);
			delete [] pic;
		}

		delete [] CM.Colors;

	}
	else if(strstr(filename,".bmp"))
	{
		FILE *out;
		int i,j;
		if((skin<=model->num_skins)&&(skin>0))
		{
			out=fopen(filename,"wb");
			BG_WriteBMP(out, pal, model->skin[skin-1].bitmap, model->skinw, model->skinh);
			fclose(out);
		}
		// new skin (polygon pic)
		if(skin<=0)
		{
			int x1,x2,x3;
			unsigned p1,p2,p3,p4;
			unsigned char *pic;
			pic= new(unsigned char)[model->skinw*model->skinh];

			for(j=0; j<model->skinh; j++)
			{
				for(i=0; i<model->skinw; i++)
				{
					pic[i+model->skinw*j]=0;
				}
			}

			int v1[2], v2[2];
			for(i=0;i<model->num_triangles;i++)
			{
				p1=model->triangle[i*4+1];
				p2=model->triangle[i*4+2];
				p3=model->triangle[i*4+3];
				p4=model->triangle[i*4];
				x1=x2=x3=0;
				if((model->vertex[3*p1]==32)&&(p4==0)) x1=model->skinw/2;
				if((model->vertex[3*p2]==32)&&(p4==0)) x2=model->skinw/2;
				if((model->vertex[3*p3]==32)&&(p4==0)) x3=model->skinw/2;
				v1[0]=model->vertex[p2*3+1]+x2;
				v1[1]=model->vertex[p2*3+2];
				v2[0]=model->vertex[p3*3+1]+x3;
				v2[1]=model->vertex[p3*3+2];
				vline(pic,v1,v2,model);
				v1[0]=model->vertex[p3*3+1]+x3;
				v1[1]=model->vertex[p3*3+2];
				v2[0]=model->vertex[p1*3+1]+x1;
				v2[1]=model->vertex[p1*3+2];
				vline(pic,v1,v2,model );
				v1[0]=model->vertex[p1*3+1]+x1;
				v1[1]=model->vertex[p1*3+2];
				v2[0]=model->vertex[p2*3+1]+x2;
				v2[1]=model->vertex[p2*3+2];
				vline(pic,v1,v2,model);

			}
			out=fopen(filename,"wb");
			BG_WriteBMP(out, pal, pic, model->skinw, model->skinh);
			fclose(out);
			delete [] pic;
		}
	}
	else
	{
		printf("Don't know that file extension.\nHit a key.\n");
		getch();
	}

}

void vline(unsigned char *pic, int *v1, int *v2, MDL_model *model)
{

			int i;
			register int inc_ah,inc_al;
			int dx,dy,long_d,short_d;
			int d,add_dh,add_dl;
			int inc_xh,inc_yh,inc_xl,inc_yl;

			dx=v2[0]-v1[0]; dy=v2[1]-v1[1];

			if(dx<0){dx=-dx; inc_xh=-1; inc_xl=-1;}
			else    {        inc_xh=1;  inc_xl=1; }

			if(dy<0){dy=-dy;inc_yh=-model->skinw;
					 inc_yl=-model->skinw;
					 }
			else    {       inc_yh= model->skinw;
					 inc_yl= model->skinw;
			}
			 if(dx>dy){long_d=dx;short_d=dy;inc_yl=0;}
			else     {long_d=dy;short_d=dx;inc_xl=0;}

			inc_ah=inc_xh+inc_yh;
			inc_al=inc_xl+inc_yl;
			pic+=v1[1]*model->skinw+v1[0];

			d=2*short_d-long_d;
			add_dl=2*short_d;
			add_dh=2*short_d-2*long_d;

			for(i=0;i<=long_d;i++)
			{
				*pic=11;
				if(d>=0){pic+=inc_ah; d+=add_dh;}
				else    {pic+=inc_al; d+=add_dl;}
			}

}

void write_gif(char *fname, unsigned char *pic, unsigned w, unsigned h)
{
	int	i,j, Error, NumFiles, ExtCode;
	GifRecordType RecordType;
	GifByteType *Extension;
	GifRowType *ImageBuffer;
	GifFileType *GifFileOut = NULL;
	ColorMapObject CM;
	CM.Colors=new(GifColorType)[256];

	GifFileOut = EGifOpenFileName(fname,0);
	EGifSetGifVersion("87a");
	int expc=8;
	// set palette
	CM.ColorCount=256;
	CM.BitsPerPixel=8;
	for(i=0; i<256; i++)
	{
		CM.Colors[i].Red=pal[i*3];
		CM.Colors[i].Green=pal[i*3+1];
		CM.Colors[i].Blue=pal[i*3+2];
	}
	EGifPutScreenDesc(GifFileOut,w,h,8,0,&CM);
	EGifPutImageDesc(GifFileOut,0, 0, w, h, 0, NULL);
	for (i = 0; i < h; i++)
	{
		EGifPutLine(GifFileOut, pic+i*w, w);
	}
	EGifCloseFile(GifFileOut);
}

