#ifndef __MEDDLE3D_H
#define __MEDDLE3D_H
#include "MedDLeTypes.h"

class CMedDLeLight : public CMedDLePosition
{
public:
	CMedDLeLight();
	CMedDLeLight(const CMedDLeLight &);
	CMedDLeLight& operator =(const CMedDLeLight &);

	BOOL m_bVisible;
	float m_fIntensity;
};

class CMedDLeCamera : public CMedDLePosition
{
public:
	CMedDLeCamera();
	CMedDLeCamera(const CMedDLeCamera &);
	CMedDLeCamera& operator =(const CMedDLeCamera &);

	BOOL m_bVisible;
	float w,h,d;
	float zmax, zmin;
};

class CMedDLeObject : public CMedDLePosition
{
public:
	CMedDLeObject();
	~CMedDLeObject();
	CMedDLeObject(const CMedDLeObject &);
	CMedDLeObject& operator =(const CMedDLeObject &);

	BOOL bAdopted;
	BOOL m_bVisible;
	CMedDLeBaseFrame *m_BaseFrame;	
	CArray <CMedDLeFrame*, CMedDLeFrame *> m_Frames;	// Frames
	CMedDLeFrame *m_curFrame;
	int m_curFrameN;
	
	CArray <CMedDLeMeshAnimation*, CMedDLeMeshAnimation*>m_Anims;
	CMedDLeMeshAnimation *m_curAnim;
	int m_curAnimN;

	// quake =1, quake2 =2 jk =3 hexen =4
	DWORD m_game;
	
	BOOL m_bValidSkin;	// q,q2,h
	int m_nSkinWidth;	// q,q2,h
	int m_nSkinHeight;
	BOOL m_bSaveSkins;

};

// animation info
// 


class CMedDLeScene
{
public:
	CMedDLeScene();
	~CMedDLeScene();
	void Reset();
	
	int m_nAmbientIntensity;

	CArray <CMedDLeObject*, CMedDLeObject*> m_Objects;
	CArray <CMedDLeLight, CMedDLeLight&> m_Lights;
	CArray <CMedDLeCamera, CMedDLeCamera&> m_Cameras;

};
#endif