// MedDLe 3d

// this is a 3d rendering class.

//	Direction matrix:
//	 right                  1 0 0 0
//	 looking                0 1 0 0
//	 up                     0 0 1 0
//	 translation            0 0 0 1
	

#include "..\stdafx.h"
#include "MedDLe3D.h"

CMedDLeCamera::CMedDLeCamera(): CMedDLePosition()
{
	m_bVisible=0;
	w=h=d=0;

//	pos.x[0]=80.0; 
//	pos.x[1]=0.0; 
//	pos.x[2]=8.0; 

//	pos_matrix=1.f;
//	for(int i=0; i<3; i++) pos_matrix.m[i].x[i]=pos.x[i];
//	pos_matrix.m[0].x[3]=pos.x[0];
///	pos_matrix.m[1].x[3]=pos.x[1];
//	pos_matrix.m[2].x[3]=pos.x[2];
//	dir_matrix=0.f;
//	dir_matrix.m[0].x[1] = 1.;
//	dir_matrix.m[1].x[0] = -1.;
//	dir_matrix.m[2].x[2] = 1.;
//	dir_matrix.m[3].x[3] = 1.;

}
CMedDLeCamera::CMedDLeCamera(const CMedDLeCamera& mc)
{
//	pos=mc.pos;				// position
//	pos_matrix=mc.pos_matrix;	// postion matrix
//	dir_matrix=mc.dir_matrix;	// direction matrix

//	m_bVisible=mc.m_bVisible;
//	w=mc.w;
//	h=mc.h;
//	d=mc.d;
//	bTargetMode=mc.bTargetMode;

}

CMedDLeCamera& CMedDLeCamera::operator=(const CMedDLeCamera& mc)
{
//	pos=mc.pos;				// position
//	pos_matrix=mc.pos_matrix;	// postion matrix
//	dir_matrix=mc.dir_matrix;	// direction matrix

	m_bVisible=mc.m_bVisible;
	w=mc.w;
	h=mc.h;
	d=mc.d;
//	bTargetMode=mc.bTargetMode;
	return *this;
}

CMedDLeLight::CMedDLeLight(): CMedDLePosition()
{
	m_fIntensity=0;
	m_bVisible=0;
	Orientation=1.f;
//	pos.x[2]=100.f;
//	for(int i=0; i<3; i++) pos_matrix.m[i].x[i]=pos.x[i];
//	dir_matrix=1.f;
//	dir_matrix.m[1].x[0]=-1;
//	dir_matrix.m[1].x[1]=-1;
//	dir_matrix.m[1].x[2]=-1;
	
}
CMedDLeLight::CMedDLeLight(const CMedDLeLight &ml)
{
//	pos=ml.pos;				// position
//	pos_matrix=ml.pos_matrix;	// postion matrix
//	dir_matrix=ml.dir_matrix;	// direction matrix

	m_fIntensity=ml.m_fIntensity;
	m_bVisible=ml.m_bVisible;

}
CMedDLeLight& CMedDLeLight::operator=(const CMedDLeLight &ml)
{
//	pos=ml.pos;				// position
//	pos_matrix=ml.pos_matrix;	// postion matrix
//	dir_matrix=ml.dir_matrix;	// direction matrix

	m_fIntensity=ml.m_fIntensity;
	m_bVisible=ml.m_bVisible;
	return *this;
}


CMedDLeObject::CMedDLeObject(): CMedDLePosition()
{
	bAdopted=0;
	m_bVisible=0;
	m_curFrame=NULL;
	m_Frames.RemoveAll();
	m_BaseFrame=new CMedDLeBaseFrame;
	m_curFrameN=0;
	Orientation=1.f;
	m_Anims.RemoveAll();
	m_curAnim=NULL;
	m_curAnimN=0;

	// quake =1, quake2 =2 jk =3 hexen =4
	m_game=0;
	m_bValidSkin=0;	// q,q2,h
	m_nSkinWidth=0;	// q,q2,h
	m_nSkinHeight=0;
	m_bSaveSkins=0;
}

CMedDLeObject::~CMedDLeObject()
{
	int i,j;
	if(!bAdopted)
	{
		if(m_BaseFrame) delete m_BaseFrame;

		j=m_Frames.GetSize()-1;
		for (i=j; i>=0; i--)
		{
			delete m_Frames.GetAt(i);
		}
		j=m_Anims.GetSize()-1;
		for (i=j; i>=0; i--)
		{
			delete m_Anims.GetAt(i);
		}
	}
	m_BaseFrame=NULL;
	m_Frames.RemoveAll();
	m_curFrame=NULL;
	m_curFrameN=0;
	m_curAnim=NULL;
	m_curAnimN=0;
}

CMedDLeObject::CMedDLeObject(const CMedDLeObject &mo)
{
	bAdopted=1;
//	pos=mo.pos;				// position
//	pos_matrix=mo.pos_matrix;	// postion matrix
//	dir_matrix=mo.dir_matrix;	// direction matrix
	Orientation=mo.Orientation;
	m_bVisible=mo.m_bVisible;
	m_BaseFrame=mo.m_BaseFrame;	
	m_curFrame=mo.m_curFrame;
	m_curFrameN=mo.m_curFrameN;

	m_curAnim=mo.m_curAnim;
	m_curAnimN=mo.m_curAnimN;

	m_game=mo.m_game;
	m_bValidSkin=mo.m_bValidSkin;	// q,q2,h
	m_nSkinWidth=mo.m_nSkinWidth;	// q,q2,h
	m_nSkinHeight=mo.m_nSkinHeight;
	m_bSaveSkins=mo.m_bSaveSkins;

	int i,j;
	j=mo.m_Frames.GetSize();
	m_Frames.RemoveAll();

	for(i=0; i <j; i++)
	{
		m_Frames.Add(mo.m_Frames[i]);
	}

	j=mo.m_Anims.GetSize();
	m_Anims.RemoveAll();

	for(i=0; i <j; i++)
	{
		m_Anims.Add(mo.m_Anims[i]);
	}


}

CMedDLeObject& CMedDLeObject::operator=(const CMedDLeObject &mo)
{
	int i,j;
	if(!bAdopted)
	{
		if(m_BaseFrame) delete m_BaseFrame;

		j=m_Frames.GetSize()-1;
		for (i=j; i>=0; i--)
		{
			delete m_Frames.GetAt(i);
		}
		j=m_Anims.GetSize()-1;
		for (i=j; i>=0; i--)
		{
			delete m_Anims.GetAt(i);
		}
	}

	bAdopted=1;
	Orientation=mo.Orientation;				// position
//	pos_matrix=mo.pos_matrix;	// postion matrix
//	dir_matrix=mo.dir_matrix;	// direction matrix
	m_bVisible=mo.m_bVisible;
	m_BaseFrame=mo.m_BaseFrame;	
	m_curFrame=mo.m_curFrame;
	m_curFrameN=mo.m_curFrameN;
	m_curAnim=mo.m_curAnim;
	m_curAnimN=mo.m_curAnimN;

	m_game=mo.m_game;
	m_bValidSkin=mo.m_bValidSkin;	// q,q2,h
	m_nSkinWidth=mo.m_nSkinWidth;	// q,q2,h
	m_nSkinHeight=mo.m_nSkinHeight;
	m_bSaveSkins=mo.m_bSaveSkins;

	j=mo.m_Frames.GetSize();
	m_Frames.RemoveAll();
	for(i=0; i <j; i++)
	{
		m_Frames.Add(mo.m_Frames[i]);
	}
	j=mo.m_Anims.GetSize();
	m_Anims.RemoveAll();

	for(i=0; i <j; i++)
	{
		m_Anims.Add(mo.m_Anims[i]);
	}

	return *this;
}


//-----------------------------------------------
//

CMedDLeScene::CMedDLeScene()
{
	m_nAmbientIntensity=0;

	m_Objects.RemoveAll();
	m_Lights.RemoveAll();
	m_Cameras.RemoveAll();

}

CMedDLeScene::~CMedDLeScene()
{

	int i,j;
	j=m_Objects.GetSize()-1;
	for (i=j; i>=0; i--)
	{
		delete m_Objects.GetAt(i);
	}
	m_Objects.RemoveAll();
	m_Lights.RemoveAll();
	m_Cameras.RemoveAll();

}

void CMedDLeScene::Reset()
{
}
