// MedDLeDoc.h : interface of the CMedDLeDoc class
//
/////////////////////////////////////////////////////////////////////////////
// This file is included in MedDLe.h
///////////////////////////////////////////////////////////////////
//#include <XRoads.h>
#include "MedDLeGFX\MedDLeTypes.h"
#include "MedDLeGFX\MedDLe3D.h"

/*
class CMedDLeDoc;
class GWriteCvt : public GWrite {
public:
	CMedDLeDoc* m_pDoc;
	GWriteCvt(CMedDLeDoc *p) : GWrite() {m_pDoc=p;}
	short PolygonSupported(void) {return TRUE;}
	void Polygon(GState& state, long faceNum, MFVec3f* v, MFVec3f* n, GWriteMaterial* m);
};
*/

enum UndoAction {UA_Copy, UA_Cut, UA_Paste, UA_Move, UA_Select};
class Undo
{
	CMedDLeBaseFrame m_BaseUndo; 
	CMedDLeFrame m_Undo; 
	int UndoAction;	
};

//////////////////////////////////////////////////////////////////
// The Main Document Class

class CMedDLeDoc : public CDocument//, public GSeparator
{
protected: // create from serialization only
	CMedDLeDoc();
	DECLARE_DYNCREATE(CMedDLeDoc)

// Attributes
public:

	// Mesh Related Data and Structures
	CGrid m_Grid;						// Editing Grid
	
	CMedDLeObject m_MedDLeObject;
//	CArray <CMedDLeObject*, CMedDLeObject*>  m_Meshs;

	CMedDLeLight m_Light;
	CMedDLeCamera m_Camera;


	// for rotation
	CMedDLePoint3D m_3ptRotHead;
	CMedDLePoint3D m_3ptRotTail;

	// for other things
	CMedDLePoint3D m_3ptCustomHead;
	CMedDLePoint3D m_3ptCustomTail;

	// whole model min, max
	CMedDLePoint3D m_3ptMin;
	CMedDLePoint3D m_3ptMax;

//	CArray <SFVec3f, SFVec3f> m_RawData;	// for importing models

	BOOL m_bAnimationPlaying;	

	// Bones system
//	Skel Skeleton;
//	DWORD SkelAction;
//	DWORD SkelOptions;
//	int curParentBone;
//	CArray <int,int> curChildBones;

//	Frame *Base;					// Base
//	Frame *MapGen;					// Mapping Generation

//	HTREEITEM TreeInfoModel;		// Tree Structures

	// Tools and Objects
//	int EditMode;					// Editing Mode (OGTVS)
//	BOOL TriAdd;					// Triangle Addition in Progress
//	int Trimap[3];					// Mesh Mapped Triangle points
//	float Trivis[3][3];				// Visible Location of points
//	float Triloc[3][3];				// Actual Location of points
	//int ViewAct;					// Current Tool
//	float RotHead[3];				// Rotation Axis Head
//	float RotTail[3];				// Rotation Axis Tail
//	BOOL RotHSel, RotTSel;			// Selection Flags
//	float RotAngle;					// Rotation Angle
	float ScaleVal[3];				// Scaling Values
//	CArray <int, int> HitIndex;		// Triangle indices of hit triangles
		

	
	// 2D Views
	float Extent[3][2];				// Mesh Extents (Min/Max)
	float Center[3][2];				// View Centers
	int AxisMap[3][2];				// Axis Maps
	int AxisDir[3][2];				// Axis Direction
	float Zoom[3];					// Zoom Level
	float Scale;					// Global Scale Value
	int ActiveView;
	// for selection rectangle
	CPoint m_ptSelection0;
	CPoint m_ptSelection1;
	
	
	BOOL Restrict[3];				// Axis Motion Restrictions

//	DWORD Vflags[3];				// View Flags
//	BOOL ClearBlue;
		
	// 3D View
//	situation sit;					// Current View State
//	situation eyeball;				// Current State Of The Eye (Camera)
	BYTE fill_mode;					// Rendering Mode, 0=None, 4=Quakish, 5=Lightshade
	BYTE back_color;				// Background Color
//	BG_3pt light_ray;				// Light Source Direction
	int light_intensity;			// Spotlight Intensity
	int ambient_intensity;			// Ambient Intensity 
//	BG_3pt MD;						// Move Direction
	int tcolor;						// Color of Shirt
	int bcolor;						// Color of Pants
	long rx, ry;					// Ideal Size
	DWORD Rflags;					// Rendering Flags
	
// Operations
public:
	void InitModelVars(void);
	void AutoCreateLineData(CMedDLeBaseFrame &mf);
	void AutoCreateObjects(CMedDLeBaseFrame &mf);
	void AutoCreateColors(CMedDLeBaseFrame &mf);

	//void PrimeSort(void);
	//void OGVParse(void);
	//void ColorSort(void);
	void ResetViewVars(int view);
	void HandleCommonKeys(UINT nChar, UINT nRepCnt, UINT nFlags, int view);
	void StatusMessage(char* fmt, ... );
	void ErrorMessage( char* fmt, ... );
	void StartBusy( void);
	void EndBusy(void);
	void mdl2xroad(void);
	void xroad2mdl(void);
	
	BOOL ReadMM(LPCTSTR lpszPathName);
	BOOL WriteMM(LPCTSTR lpszPathName);
	BOOL ReadMP(LPCTSTR lpszPathName);
	BOOL WriteMP(LPCTSTR lpszPathName);
	BOOL ReadMB(LPCTSTR lpszPathName);
	BOOL WriteMB(LPCTSTR lpszPathName);

	void NewFrameFromXRoad(LPCTSTR lpszPathName);
	void AddFrameFromXRoad(LPCTSTR lpszPathName);
	void MakeMDL(void);
	void GetMDLScaleOffRad(float *scale,float *offset, float *rad);
	void MakeSkinMapping(void);
	void BaseFromSkinMap(void);
	void BaseFromFrame(int frame);
	void MapGenFromSkinMap(void);
	void MapGenFromFrame(int frame);
//	void GenerateBlankSkin(Skin *s);
	void GetNormal(CMedDLeFrame *f, int tri, float *norm);
	int GetVertexNormal(CMedDLeFrame *f,int vindex,float *norm);
	void UpdateGrid(DWORD gridnum);

	void AddFrame(CMedDLeFrame *frame);
	void DeleteFrame(int frame);
	void CopyFrame(CMedDLeFrame *src, CMedDLeFrame *dest);
	void InsertFrame(CMedDLeFrame *frame, int pos);
	void AddFrameToFGroup(int framepos, int groupid);
	//added bm
	void ParseAnimationInfo(void);
	void AddSelToBone(void);
	void FindChildBones(int bone);
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMedDLeDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual void DeleteContents();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CMedDLeDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CMedDLeDoc)
	afx_msg void OnFileExportframe();
	afx_msg void OnFileImportframe();
	afx_msg void OnEditRotate();
	afx_msg void OnEditScale();
	afx_msg void OnFileExportskin();
	afx_msg void OnFileImportskin();
	afx_msg void OnFileSave();
	afx_msg void OnFileSaveAs();
	afx_msg void OnCopyframe();
	afx_msg void On2Deleteframe();
	afx_msg void On2Pasteframe();
	afx_msg void OnUpdate2Pasteframe(CCmdUI* pCmdUI);
	afx_msg void OnFileSettings();
	afx_msg void OnFileSetgame();
	afx_msg void OnEditCopy();
	afx_msg void OnEditCut();
	afx_msg void OnEditPaste();
	afx_msg void OnEditPastenew();
	afx_msg void OnUpdateEditPastenew(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnEditUndo();
	afx_msg void OnEditSelectnone();
	afx_msg void OnEditSelectall();
	afx_msg void OnXyzXlock();
	afx_msg void OnUpdateXyzXlock(CCmdUI* pCmdUI);
	afx_msg void OnXyzYlock();
	afx_msg void OnUpdateXyzYlock(CCmdUI* pCmdUI);
	afx_msg void OnXyzZlock();
	afx_msg void OnUpdateXyzZlock(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////




//#define VERT_LIMIT 2000		// max number of vertices
//#define BONE_LIMIT 200

// C: Cursors
//#define C_NONE 0			// No Active Cursor (Translate & Select)
//#define C_GRID 1			// Grid Cursor
//#define C_ZOOM 2			// Zoom & Move Cursor
//#define C_SCALE 3			// Scale Cursor
//#define C_ROTATE 4			// Rotate Cursor

// SM: Selection Modes
//#define SM_VERT 0			// Vertex Level
//#define SM_TRI 1			// Triangle Level
//#define SM_GROUP 2			// Group Level
//#define SM_OBJECT 4			// Object Level
//#define SM_SKEL 8			// Skeleton Level

// S: System (General)
/*#define S_ONSEEM 32			// Vertex is on seem (id)
#define S_FRONT 1			// The triangle is on the front skin (id)
#define S_HAS_CHILDREN 1	// Skel_bone has children (if not, don't search list!)
#define S_USE_FREESTYLE 2	// The Freestyle mesh is selected for output
#define S_IS_MDL 1			// Is the doc from the MDL format
#define S_HAS_SKIN 2		// Is Mapping Data Globaly Available
#define S_HAS_BASE 4		// Base Frame is Initialized
#define S_HAS_MAPGEN 8		// Mapping Gen Frame is Initialized
#define S_GLOBAL 16			// Views update globaly

// R: Rendering (3D & 2D Views)
#define R_FB 1				// Draw the Front/Back
#define R_WIRE 2			// Draw the lines
#define R_VERT 4			// Draw the vertices
#define R_USE_IDEAL 8		// Draw to a pre-defined size
#define R_NO_BLIT 16		// Don't update the view with the data
#define R_GRID 32			// Draw Grids
#define R_SOLID 64			// Draw Mesh as a Solid

// O: Object
#define O_SELECTED 1		// Data Member is Selected
#define O_VSELECTED 2		// Data Member is Visibly Selected
#define O_HIDDEN 4			// Data Member is Hidden
#define O_VHIDDEN 8			// Data Member is Visibly Hidden (HaHa)
#define O_HAS_MAP 16		// Vertex Has Valid Mapping Data
#define O_DRAW_BLUE 32		// Draw the Vertex Blue!
#define O_MARKED 64			// The selected data is marked
#define O_MODIFY 128		// Modify the selected data
#define O_USER 256			// User (Normal) Grid
#define O_OVERLAY 512		// Frame Overlay Grid
#define O_AXIS 1024			// Axis Bars Grid
#define O_SAFETY 2048		// Safety Grid
#define O_WALL 4096			// Blocking Grid (Wall)

// D: Drawing
#define D_READY 1			// Object can be drawn
#define D_SHOWVERTS 2		// Draw Vertices
#define D_SHOWLINES 4		// Draw Lines
#define D_DRAWSIZE 8		// Apply Vertices' Size

// T: Types
#define T_UNDECLARED 0		// Unknown Object
#define T_FRAME 1			// Frame
#define T_SKIN 2			// Skin
#define T_GRID 3			// Grids
#define T_SKEL 4			// Skeleton Bones
#define T_ROTTOOL 5			// Rotation Tool
#define T_SCALETOOL 6		// Scale Tool
#define T_TRANSTOOL 7		// Translate Tool
// Bone Action Flags
#define BA_PICKPARENT 1		// Action pick parent 
#define BA_MOVEVTO	2		 
#define BA_DETACHBONE 3	 
#define BA_DETACHVERTS 4
#define BA_ADDVERTS 5
#define BA_PICKCURPARENT 10
//normal actions
#define BA_ROT 6
#define BA_TWIST 7
#define BA_SCALE 8
#define BA_TRANS 9

// bone options
#define BO_HARD 1
#define BO_STICKY 2 
#define BO_CONSTVOLUME 4
#define BO_MOVECHILD 5

// P: Pens
#define P_LINE 0			// Line Color
#define P_VERT 1			// Vertex Color
#define P_SLINE 2			// Selected Line Color
#define P_SVERT 3			// Selected Vertex Color
#define P_BACK 4			// Background Color


//------------------------------------------------------------------------------
// data structures

//struct MedDLeGroup {				// Editing Groups
//	DWORD flags;				// Flags
//	DWORD color;				// Actual Group Color
//	DWORD viscolor;			// Visible Group Color
//	char name[32];			// Group Name
//};



//	long x, y;				// Mapping Coords (If O_HAS_MAP is Set)
//	DWORD Mflags;			// MDL Based Flags Including ONSEEM



/*struct Object {				// Editing Objects
	int flags;				// Flags
	int color;				// Actual Object Color
	int viscolor;			// Visible Object Color
	char name[16];			// Object Name
	CArray <Group*, Group*> Groups;	// Groups in the Object
	int dummy;				// Dummy number for various things
};
*/


/*
struct VertData {			// All Vertex Related Data
	int flags;				// Flags
	int object, group;		// Object & Group ID#s
	int skel;				// Skeleton Segment ID#
	int dummy;				// Dummy Value
	DWORD Mflags;			// MDL Based Flags Including ONSEEM
	long x, y;				// Mapping Coords (If O_HAS_MAP is Set)
};

struct Vertex {			// Vertex Definition (Unmodified)
	BYTE v[3];				// X, Y, Z
	BYTE vnormal;			// Light/Normal Index
};

struct fVertex {			// Vertex Definition
	float v[3];				// X, Y, Z
	BYTE vnormal;			// Light/Normal Index
};


struct Triangle {			// Triangle Definition
	DWORD flags;			// Flags Including FRONT
	DWORD Vflags;			// View Based Flags
	DWORD vindex[3];		// Three Vertexes
	int color[3];			// Line segment colors
};
*/
/*
struct Skin {				// Skin (Gee!)
	DWORD type;				// Is it a grouped skin?
	BYTE *bitmap;			// Image Data For Skin
	float tcode;			// Time Code
	float tduration;		// Time Duration
	char name[16];			// Skin's Name
//	HTREEITEM TreeInfoSkin;		// for tree view
	
	DWORD groupnumber;		// What group does this belong 
};

/*
struct Bone {				// Editing Groups
	float head[3];
	float tail[3];
	float length;
	float twist;
};


struct Frame {				// Frame
	DWORD type;				// Is it a grouped frame?
	Vertex bboxmin,bboxmax;	// Bounding Box
	float tcode;			// Time Code
	float tduration;		// Time Duration
	char name[16];			// Frame's Name
	Vertex tv[VERT_LIMIT];	// id's own trivertex
	FVertex fv[VERT_LIMIT];	// like the trivertex, but in float format (scaled, etc)
	FVertex fbboxmin,fbboxmax;	// Bounding Box in float form
	int groupnumber;		// What frame group?
//	HTREEITEM TreeInfoFrame;		// for tree view
	int ListIndex;			// for the list view
	Bone bone[BONE_LIMIT];			// added for testing
};


struct SkinGroup{			// a skin group def
	char name[16];			// the name of the group
	DWORD skins;			// number of skins in group
	Skin **pSkins;			// List of all skins in group
	HTREEITEM TreeInfoGSkin;		// for tree view
};

struct FrameGroup{			// frame group def
	char name[16];			// the name of the frame group
	DWORD frames;			// number of frames in group
	Vertex bboxmin, bboxmax;  // bounding size of group
	FVertex fbboxmin, fbboxmax;  // bounding size of group (float)
	HTREEITEM TreeInfoGFrame;		// for tree view
};
*/
/*
struct LineRef {			// Line reference
	DWORD vindex[2];		// Two Vertices indices
	DWORD flags;			// Flags including SELECTED
	int color;				// Visible Color
};

struct SVertex {			// Screen Vertices
	int v[3][2];			// Actual Coordinates
	int color;				// Color of Vert
	int size;				// Size of Vert
	DWORD flags;			// Flags
};

struct Animation			// animation parsed from names
{
	char name[16];			// base name of animation
	int frames;				// total frames in animaton
	int firstframe;			// index of first frame of animation
	HTREEITEM TreeInfoAnim;		// for tree view
};

struct Skel {
	int hflags[BONE_LIMIT];
	int tflags[BONE_LIMIT];
	int parentindex[BONE_LIMIT];
	int cnt;
};
*/