// FrameTool.cpp : implementation file
//

#include "stdafx.h"
#include "MedDLe.h"
#include "ToolTitle.h"
#include "FrameTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFrameTool dialog


CFrameTool::CFrameTool(CWnd* pParent /*=NULL*/)
	: CDialog(CFrameTool::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFrameTool)
	//}}AFX_DATA_INIT
}


void CFrameTool::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFrameTool)
	DDX_Control(pDX, IDC_NUMVERTS, m_NumTris);
	DDX_Control(pDX, IDC_NUMTRIS, m_NumVerts);
	DDX_Control(pDX, IDC_BUTTON1, m_new);
	DDX_Control(pDX, IDC_COMBO1, m_AnimationCombo);
	DDX_Control(pDX, IDC_LIST1, m_FrameList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFrameTool, CDialog)
	//{{AFX_MSG_MAP(CFrameTool)
	ON_WM_SHOWWINDOW()
	ON_LBN_SELCHANGE(IDC_LIST1, OnSelchangeList1)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTON1, OnNew)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnChangeAnimation)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFrameTool message handlers
BOOL CFrameTool::ShowWindow(int s)
{
	CMedDLeObject *mo;
	int i,j;
	m_FrameList.ResetContent();
	m_AnimationCombo.ResetContent();

	if(theApp.m_pActiveDoc!=NULL)
	{
		CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
		mo=&pDoc->m_MedDLeObject;

		for(i=0; i<mo->m_Anims.GetSize(); i++)
		{
			m_AnimationCombo.AddString(mo->m_Anims[i]->name);
		}

		m_AnimationCombo.SetCurSel(mo->m_curAnimN);


		for(i=0; i<mo->m_Anims[mo->m_curAnimN]->framelist.GetSize(); i++)
		{
			j=mo->m_Anims[mo->m_curAnimN]->framelist[i];

			m_FrameList.AddString(mo->m_Frames[j]->name);
		}
	}

	return CDialog::ShowWindow(s);
}

void CFrameTool::OnShowWindow(BOOL bShow, UINT nStatus) 
{

	CDialog::OnShowWindow(bShow, nStatus);
	
}

void CFrameTool::OnSelchangeList1() 
{
	UpdateData();

	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

	CString str;
	m_FrameList.GetText(m_FrameList.GetCurSel(), str);

	for(int i=0; i<pDoc->m_MedDLeObject.m_Frames.GetSize(); i++)
	{
		if(str.CompareNoCase(pDoc->m_MedDLeObject.m_Frames[i]->name)==0)
		{
			pDoc->m_MedDLeObject.m_curFrame=pDoc->m_MedDLeObject.m_Frames[i];
			pDoc->m_MedDLeObject.m_curFrameN=i;
			break;
		}
	}

	pDoc->UpdateAllViews(NULL);
	
}

HBRUSH CFrameTool::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO: Change any attributes of the DC here
//	pDC->SetBkMode(TRANSPARENT);
//	pDC->SetTextColor(RGB(255,0,0));


	// TODO: Return a different brush if the default is not desired
	return hbr;
}

void CFrameTool::OnNew() 
{
	// TODO: Add your control notification handler code here
	
}

void CFrameTool::OnChangeAnimation() 
{
	UpdateData();

//	MessageBeep(0xffffffff);
	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

	CMedDLeObject *mo=&pDoc->m_MedDLeObject;
	CString str;
	m_AnimationCombo.GetLBText(m_AnimationCombo.GetCurSel(), str);

	for(int i=0; i<pDoc->m_MedDLeObject.m_Anims.GetSize(); i++)
	{
		if(str.CompareNoCase(pDoc->m_MedDLeObject.m_Anims[i]->name)==0)
		{
			pDoc->m_MedDLeObject.m_curAnim=pDoc->m_MedDLeObject.m_Anims[i];
			pDoc->m_MedDLeObject.m_curAnimN=i;
			break;
		}
	}

	int j;
	m_FrameList.ResetContent();
	for(i=0; i<mo->m_Anims[mo->m_curAnimN]->framelist.GetSize(); i++)
	{
		j=mo->m_Anims[mo->m_curAnimN]->framelist[i];
		m_FrameList.AddString(mo->m_Frames[j]->name);
	}
	pDoc->m_MedDLeObject.m_curFrame=pDoc->m_MedDLeObject.m_Frames[mo->m_Anims[mo->m_curAnimN]->framelist[0]];
	pDoc->m_MedDLeObject.m_curFrameN=mo->m_Anims[mo->m_curAnimN]->framelist[0];

	m_FrameList.SetCurSel(0);
	pDoc->UpdateAllViews(NULL);
	
}
